CREATE TABLE occupation_level_metadata (
  onetsoc_code CHARACTER(10) NOT NULL,
  item CHARACTER VARYING(150) NOT NULL,
  response CHARACTER VARYING(75),
  n DECIMAL(4,0),
  percent DECIMAL(4,1),
  date_updated DATE NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code));

INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Data Collection Mode', 'Paper', 87, 66.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Data Collection Mode', 'Web', 87, 33.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Employee Completeness Rate', NULL, NULL, 87.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Employee Response Rate', NULL, NULL, 60.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Establishment Eligibility Rate', NULL, NULL, 87.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Establishment Response Rate', NULL, NULL, 63.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'How Long at Current Job', '1-5 Years', 87, 35.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'How Long at Current Job', '10 Years or More', 87, 43.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'How Long at Current Job', '6-9 Years', 87, 9.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'How Long at Current Job', '<1 Year', 87, 11.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'How Long at Current Job', 'Missing', 87, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 87, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 87, 9.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 87, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 87, 25.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 87, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 87, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 87, 9.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 87, 3.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 87, 39.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 87, 6.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 87, 6.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Accommodation and food services', 87, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 87, 5.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 87, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 87, 1.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Construction', 87, 9.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Education services', 87, 4.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Finance and insurance', 87, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Health care and social assistance', 87, 25.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Information', 87, 6.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Management of Companies and Enterprises', 87, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Manufacturing', 87, 23.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Mining', 87, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Other services, except public administration', 87, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 87, 3.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Public administration', 87, 9.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Real estate and rental and leasing', 87, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Retail trade', 87, 3.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Transportation and warehousing', 87, 1.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Unclassified', 87, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Utilities', 87, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'NAICS Sector', 'Wholesale trade', 87, 6.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'SOC Eligibility Rate', NULL, NULL, 30.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.00', 'Total Completed Questionnaires', NULL, 87, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'Data Collection Mode', 'Paper', 26, 34.6, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'Data Collection Mode', 'Web', 26, 65.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 26, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'How Much Experience Performing Work in this Occupation', '10+ Years', 26, 46.2, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 26, 19.2, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 26, 34.6, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'How Much Experience Performing Work in this Occupation', '<1 Year', 26, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'How Much Experience Performing Work in this Occupation', 'Missing', 26, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 26, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'OE Completeness Rate', NULL, NULL, 92.9, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'OE Response Rate', NULL, NULL, 82.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1011.03', 'Total Completed Questionnaires', NULL, 26, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Data Collection Mode', 'Paper', 158, 71.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Data Collection Mode', 'Web', 158, 28.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Employee Completeness Rate', NULL, NULL, 89.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Employee Response Rate', NULL, NULL, 78.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Establishment Eligibility Rate', NULL, NULL, 84.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Establishment Response Rate', NULL, NULL, 64.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'How Long at Current Job', '1-5 Years', 158, 17.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'How Long at Current Job', '10 Years or More', 158, 56.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'How Long at Current Job', '6-9 Years', 158, 17.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'How Long at Current Job', '<1 Year', 158, 7.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'How Long at Current Job', 'Missing', 158, 0.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 158, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 158, 14.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 158, 10.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 158, 38.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 158, 0.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 158, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 158, 3.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 158, 17.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 158, 6.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 158, 4.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 158, 5.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Accommodation and food services', 158, 1.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 158, 5.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 158, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 158, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Construction', 158, 14.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Education services', 158, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Finance and insurance', 158, 4.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Health care and social assistance', 158, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Information', 158, 2.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Management of Companies and Enterprises', 158, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Manufacturing', 158, 35.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Mining', 158, 0.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Other services, except public administration', 158, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 158, 3.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Public administration', 158, 3.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Real estate and rental and leasing', 158, 6.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Retail trade', 158, 15.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Transportation and warehousing', 158, 1.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Unclassified', 158, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Utilities', 158, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'NAICS Sector', 'Wholesale trade', 158, 5.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'SOC Eligibility Rate', NULL, NULL, 45.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-1021.00', 'Total Completed Questionnaires', NULL, 158, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Data Collection Mode', 'Paper', 74, 55.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Data Collection Mode', 'Web', 74, 44.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Employee Completeness Rate', NULL, NULL, 91.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Employee Response Rate', NULL, NULL, 62.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Establishment Eligibility Rate', NULL, NULL, 86.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Establishment Response Rate', NULL, NULL, 48.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'How Long at Current Job', '1-5 Years', 74, 39.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'How Long at Current Job', '10 Years or More', 74, 32.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'How Long at Current Job', '6-9 Years', 74, 14.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'How Long at Current Job', '<1 Year', 74, 13.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'How Long at Current Job', 'Missing', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 74, 2.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 74, 13.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 74, 60.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 74, 21.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 74, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Accommodation and food services', 74, 5.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 74, 2.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 74, 31.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Construction', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Education services', 74, 6.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Finance and insurance', 74, 2.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Health care and social assistance', 74, 8.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Information', 74, 28.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Management of Companies and Enterprises', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Manufacturing', 74, 8.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Mining', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Other services, except public administration', 74, 4.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 74, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Public administration', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Real estate and rental and leasing', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Retail trade', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Transportation and warehousing', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Unclassified', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Utilities', 74, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'NAICS Sector', 'Wholesale trade', 74, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'SOC Eligibility Rate', NULL, NULL, 17.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2011.00', 'Total Completed Questionnaires', NULL, 74, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Data Collection Mode', 'Paper', 117, 43.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Data Collection Mode', 'Web', 117, 56.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Employee Completeness Rate', NULL, NULL, 86.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Employee Response Rate', NULL, NULL, 64.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Establishment Eligibility Rate', NULL, NULL, 87.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Establishment Response Rate', NULL, NULL, 57.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'How Long at Current Job', '1-5 Years', 117, 45.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'How Long at Current Job', '10 Years or More', 117, 28.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'How Long at Current Job', '6-9 Years', 117, 14.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'How Long at Current Job', '<1 Year', 117, 12.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'How Long at Current Job', 'Missing', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 117, 3.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 117, 5.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 117, 40.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 117, 2.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 117, 32.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 117, 5.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 117, 11.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Accommodation and food services', 117, 7.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 117, 1.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 117, 2.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Construction', 117, 3.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Education services', 117, 5.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Finance and insurance', 117, 4.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Health care and social assistance', 117, 10.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Information', 117, 4.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Management of Companies and Enterprises', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Manufacturing', 117, 39.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Mining', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Other services, except public administration', 117, 0.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 117, 5.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Public administration', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Real estate and rental and leasing', 117, 1.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Retail trade', 117, 1.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Transportation and warehousing', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Unclassified', 117, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Utilities', 117, 0.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'NAICS Sector', 'Wholesale trade', 117, 11.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'SOC Eligibility Rate', NULL, NULL, 16.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2021.00', 'Total Completed Questionnaires', NULL, 117, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Data Collection Mode', 'Paper', 23, 30.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Data Collection Mode', 'Web', 23, 69.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 4.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 87.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 4.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 4.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'OE Completeness Rate', NULL, NULL, 95.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'OE Response Rate', NULL, NULL, 55.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2022.00', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Data Collection Mode', 'Paper', 92, 55.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Data Collection Mode', 'Web', 92, 44.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Employee Completeness Rate', NULL, NULL, 96.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Employee Response Rate', NULL, NULL, 62.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Establishment Eligibility Rate', NULL, NULL, 86.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Establishment Response Rate', NULL, NULL, 51.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'How Long at Current Job', '1-5 Years', 92, 38.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'How Long at Current Job', '10 Years or More', 92, 27.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'How Long at Current Job', '6-9 Years', 92, 18.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'How Long at Current Job', '<1 Year', 92, 16.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'How Long at Current Job', 'Missing', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 92, 1.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 92, 4.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 92, 92.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 92, 2.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Accommodation and food services', 92, 1.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 92, 2.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 92, 16.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Construction', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Education services', 92, 55.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Finance and insurance', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Health care and social assistance', 92, 5.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Information', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Management of Companies and Enterprises', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Manufacturing', 92, 1.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Mining', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Other services, except public administration', 92, 1.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 92, 10.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Public administration', 92, 4.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Real estate and rental and leasing', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Retail trade', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Transportation and warehousing', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Unclassified', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Utilities', 92, 2.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'NAICS Sector', 'Wholesale trade', 92, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'SOC Eligibility Rate', NULL, NULL, 18.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-2031.00', 'Total Completed Questionnaires', NULL, 92, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Data Collection Mode', 'Paper', 134, 52.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Data Collection Mode', 'Web', 134, 47.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Employee Completeness Rate', NULL, NULL, 83.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Employee Response Rate', NULL, NULL, 69.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Establishment Eligibility Rate', NULL, NULL, 88.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Establishment Response Rate', NULL, NULL, 51.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'How Long at Current Job', '1-5 Years', 134, 29.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'How Long at Current Job', '10 Years or More', 134, 46.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'How Long at Current Job', '6-9 Years', 134, 17.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'How Long at Current Job', '<1 Year', 134, 6.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'How Long at Current Job', 'Missing', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 134, 4.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 134, 5.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 134, 22.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 134, 62.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 134, 5.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Accommodation and food services', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 134, 0.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 134, 5.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Construction', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Education services', 134, 26.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Finance and insurance', 134, 4.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Health care and social assistance', 134, 15.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Information', 134, 3.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Management of Companies and Enterprises', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Manufacturing', 134, 5.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Mining', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Other services, except public administration', 134, 5.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 134, 6.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Public administration', 134, 22.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Real estate and rental and leasing', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Retail trade', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Transportation and warehousing', 134, 1.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Unclassified', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Utilities', 134, 3.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'NAICS Sector', 'Wholesale trade', 134, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'SOC Eligibility Rate', NULL, NULL, 39.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3011.00', 'Total Completed Questionnaires', NULL, 134, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Data Collection Mode', 'Paper', 76, 23.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Data Collection Mode', 'Web', 76, 76.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Employee Completeness Rate', NULL, NULL, 92.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Employee Response Rate', NULL, NULL, 61.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Establishment Eligibility Rate', NULL, NULL, 83.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Establishment Response Rate', NULL, NULL, 52.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'How Long at Current Job', '1-5 Years', 76, 38.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'How Long at Current Job', '10 Years or More', 76, 47.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'How Long at Current Job', '6-9 Years', 76, 13.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'How Long at Current Job', '<1 Year', 76, 1.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'How Long at Current Job', 'Missing', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 76, 1.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 76, 9.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 76, 2.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 76, 15.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 76, 30.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 76, 32.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 76, 5.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 76, 2.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Accommodation and food services', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 76, 1.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Construction', 76, 9.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Education services', 76, 7.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Finance and insurance', 76, 2.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Health care and social assistance', 76, 14.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Information', 76, 6.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Management of Companies and Enterprises', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Manufacturing', 76, 14.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Mining', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Other services, except public administration', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 76, 10.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Public administration', 76, 30.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Real estate and rental and leasing', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Retail trade', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Transportation and warehousing', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Unclassified', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Utilities', 76, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'NAICS Sector', 'Wholesale trade', 76, 2.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'SOC Eligibility Rate', NULL, NULL, 12.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3021.00', 'Total Completed Questionnaires', NULL, 76, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Data Collection Mode', 'Paper', 30, 50.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Data Collection Mode', 'Web', 30, 50.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 30, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 30, 96.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 30, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 30, 3.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 30, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 30, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 30, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'OE Completeness Rate', NULL, NULL, 93.8, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'OE Response Rate', NULL, NULL, 65.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.01', 'Total Completed Questionnaires', NULL, 30, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Data Collection Mode', 'Paper', 86, 62.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Data Collection Mode', 'Web', 86, 37.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Employee Completeness Rate', NULL, NULL, 91.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Employee Response Rate', NULL, NULL, 69.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Establishment Eligibility Rate', NULL, NULL, 79.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Establishment Response Rate', NULL, NULL, 51.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'How Long at Current Job', '1-5 Years', 86, 40.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'How Long at Current Job', '10 Years or More', 86, 39.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'How Long at Current Job', '6-9 Years', 86, 14.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'How Long at Current Job', '<1 Year', 86, 4.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'How Long at Current Job', 'Missing', 86, 1.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 86, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Accommodation and food services', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Arts, entertainment, and recreation', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Construction', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Education services', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Finance and insurance', 86, 98.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Health care and social assistance', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Information', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Management of Companies and Enterprises', 86, 1.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Manufacturing', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Mining', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Other services, except public administration', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Public administration', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Real estate and rental and leasing', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Retail trade', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Transportation and warehousing', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Unclassified', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Utilities', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'NAICS Sector', 'Wholesale trade', 86, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'SOC Eligibility Rate', NULL, NULL, 36.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3031.02', 'Total Completed Questionnaires', NULL, 86, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Data Collection Mode', 'Paper', 118, 61.9, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Data Collection Mode', 'Web', 118, 38.1, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Employee Completeness Rate', NULL, NULL, 94.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Employee Response Rate', NULL, NULL, 66.8, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Establishment Eligibility Rate', NULL, NULL, 86.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Establishment Response Rate', NULL, NULL, 70.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'How Long at Current Job', '1-5 Years', 118, 31.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'How Long at Current Job', '10 Years or More', 118, 46.6, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'How Long at Current Job', '6-9 Years', 118, 15.3, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'How Long at Current Job', '<1 Year', 118, 4.2, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'How Long at Current Job', 'Missing', 118, 2.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 118, 100.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Accommodation and food services', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Construction', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Education services', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Finance and insurance', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Health care and social assistance', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Information', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Management of Companies and Enterprises', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Manufacturing', 118, 100.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Mining', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Other services, except public administration', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Public administration', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Real estate and rental and leasing', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Retail trade', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Transportation and warehousing', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Unclassified', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Utilities', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'NAICS Sector', 'Wholesale trade', 118, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'SOC Eligibility Rate', NULL, NULL, 49.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.00', 'Total Completed Questionnaires', NULL, 118, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Data Collection Mode', 'Paper', 60, 41.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Data Collection Mode', 'Web', 60, 58.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Employee Completeness Rate', NULL, NULL, 100.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Employee Response Rate', NULL, NULL, 65.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Establishment Eligibility Rate', NULL, NULL, 83.1, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Establishment Response Rate', NULL, NULL, 77.1, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'How Long at Current Job', '1-5 Years', 60, 43.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'How Long at Current Job', '10 Years or More', 60, 31.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'How Long at Current Job', '6-9 Years', 60, 18.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'How Long at Current Job', '<1 Year', 60, 6.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'How Long at Current Job', 'Missing', 60, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 60, 1.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 60, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 60, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 60, 76.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 60, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 60, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 60, 3.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 60, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 60, 18.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 60, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 60, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Accommodation and food services', 60, 3.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 60, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 60, 6.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 60, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Construction', 60, 6.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Education services', 60, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Finance and insurance', 60, 3.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Health care and social assistance', 60, 11.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Information', 60, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Management of Companies and Enterprises', 60, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Manufacturing', 60, 16.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Mining', 60, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Other services, except public administration', 60, 1.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 60, 28.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Public administration', 60, 1.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Real estate and rental and leasing', 60, 3.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Retail trade', 60, 6.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Transportation and warehousing', 60, 1.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Unclassified', 60, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Utilities', 60, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'NAICS Sector', 'Wholesale trade', 60, 8.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'SOC Eligibility Rate', NULL, NULL, 21.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.01', 'Total Completed Questionnaires', NULL, 60, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Data Collection Mode', 'Paper', 52, 50.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Data Collection Mode', 'Web', 52, 50.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Employee Completeness Rate', NULL, NULL, 94.5, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Employee Response Rate', NULL, NULL, 69.6, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Establishment Eligibility Rate', NULL, NULL, 51.5, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Establishment Response Rate', NULL, NULL, 94.1, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'How Long at Current Job', '1-5 Years', 52, 30.8, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'How Long at Current Job', '10 Years or More', 52, 40.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'How Long at Current Job', '6-9 Years', 52, 23.1, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'How Long at Current Job', '<1 Year', 52, 3.8, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'How Long at Current Job', 'Missing', 52, 1.9, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 52, 9.6, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 52, 25.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 52, 65.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Accommodation and food services', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Arts, entertainment, and recreation', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Construction', 52, 9.6, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Education services', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Finance and insurance', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Health care and social assistance', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Information', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Management of Companies and Enterprises', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Manufacturing', 52, 25.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Mining', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Other services, except public administration', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Public administration', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Real estate and rental and leasing', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Retail trade', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Transportation and warehousing', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Unclassified', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Utilities', 52, 65.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'NAICS Sector', 'Wholesale trade', 52, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'SOC Eligibility Rate', NULL, NULL, 84.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.02', 'Total Completed Questionnaires', NULL, 52, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Data Collection Mode', 'Paper', 65, 73.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Data Collection Mode', 'Web', 65, 26.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Employee Completeness Rate', NULL, NULL, 98.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Employee Response Rate', NULL, NULL, 70.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Establishment Eligibility Rate', NULL, NULL, 79.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Establishment Response Rate', NULL, NULL, 77.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'How Long at Current Job', '1-5 Years', 65, 64.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'How Long at Current Job', '10 Years or More', 65, 6.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'How Long at Current Job', '6-9 Years', 65, 16.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'How Long at Current Job', '<1 Year', 65, 10.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'How Long at Current Job', 'Missing', 65, 1.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 65, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Accommodation and food services', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 65, 1.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 65, 3.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Arts, entertainment, and recreation', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Construction', 65, 1.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Education services', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Finance and insurance', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Health care and social assistance', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Information', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Management of Companies and Enterprises', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Manufacturing', 65, 90.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Mining', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Other services, except public administration', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Professional, Scientific and Technical Services', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Public administration', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Real estate and rental and leasing', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Retail trade', 65, 1.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Transportation and warehousing', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Unclassified', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Utilities', 65, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'NAICS Sector', 'Wholesale trade', 65, 1.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'SOC Eligibility Rate', NULL, NULL, 20.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.03', 'Total Completed Questionnaires', NULL, 65, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Data Collection Mode', 'Paper', 138, 68.1, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Data Collection Mode', 'Web', 138, 31.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Employee Completeness Rate', NULL, NULL, 93.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Employee Response Rate', NULL, NULL, 86.6, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Establishment Eligibility Rate', NULL, NULL, 83.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Establishment Response Rate', NULL, NULL, 92.4, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'How Long at Current Job', '1-5 Years', 138, 35.5, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'How Long at Current Job', '10 Years or More', 138, 44.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'How Long at Current Job', '6-9 Years', 138, 14.5, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'How Long at Current Job', '<1 Year', 138, 5.1, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'How Long at Current Job', 'Missing', 138, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 138, 0.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 138, 7.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 138, 1.4, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 138, 21.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 138, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 138, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 138, 2.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 138, 8.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 138, 2.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 138, 56.5, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 138, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Accommodation and food services', 138, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 138, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 138, 0.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Arts, entertainment, and recreation', 138, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Construction', 138, 7.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Education services', 138, 0.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Finance and insurance', 138, 3.6, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Health care and social assistance', 138, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Information', 138, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Management of Companies and Enterprises', 138, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Manufacturing', 138, 21.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Mining', 138, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Other services, except public administration', 138, 1.4, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Professional, Scientific and Technical Services', 138, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Public administration', 138, 2.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Real estate and rental and leasing', 138, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Retail trade', 138, 8.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Transportation and warehousing', 138, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Unclassified', 138, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Utilities', 138, 54.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'NAICS Sector', 'Wholesale trade', 138, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'SOC Eligibility Rate', NULL, NULL, 16.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.04', 'Total Completed Questionnaires', NULL, 138, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Data Collection Mode', 'Paper', 86, 64.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Data Collection Mode', 'Web', 86, 36.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Employee Completeness Rate', NULL, NULL, 92.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Employee Response Rate', NULL, NULL, 69.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Establishment Eligibility Rate', NULL, NULL, 85.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Establishment Response Rate', NULL, NULL, 83.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'How Long at Current Job', '1-5 Years', 86, 34.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'How Long at Current Job', '10 Years or More', 86, 39.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'How Long at Current Job', '6-9 Years', 86, 15.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'How Long at Current Job', '<1 Year', 86, 10.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'How Long at Current Job', 'Missing', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 86, 1.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 86, 22.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 86, 8.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 86, 68.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Accommodation and food services', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Arts, entertainment, and recreation', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Construction', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Education services', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Finance and insurance', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Health care and social assistance', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Information', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Management of Companies and Enterprises', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Manufacturing', 86, 1.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Mining', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Other services, except public administration', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Professional, Scientific and Technical Services', 86, 8.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Public administration', 86, 22.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Real estate and rental and leasing', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Retail trade', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Transportation and warehousing', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Unclassified', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Utilities', 86, 68.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'NAICS Sector', 'Wholesale trade', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'SOC Eligibility Rate', NULL, NULL, 11.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3051.06', 'Total Completed Questionnaires', NULL, 86, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Data Collection Mode', 'Paper', 21, 23.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Data Collection Mode', 'Web', 21, 76.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 81.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 4.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 14.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'OE Completeness Rate', NULL, NULL, 91.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'OE Response Rate', NULL, NULL, 37.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3061.00', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Data Collection Mode', 'Paper', 98, 56.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Data Collection Mode', 'Web', 98, 43.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Employee Completeness Rate', NULL, NULL, 86.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Employee Response Rate', NULL, NULL, 74.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Establishment Eligibility Rate', NULL, NULL, 88.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Establishment Response Rate', NULL, NULL, 75.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'How Long at Current Job', '1-5 Years', 98, 30.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'How Long at Current Job', '10 Years or More', 98, 53.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'How Long at Current Job', '6-9 Years', 98, 8.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'How Long at Current Job', '<1 Year', 98, 8.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'How Long at Current Job', 'Missing', 98, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 98, 1.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 98, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 98, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 98, 10.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 98, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 98, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 98, 19.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 98, 2.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 98, 5.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 98, 59.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 98, 3.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Accommodation and food services', 98, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 98, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 98, 1.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 98, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Construction', 98, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Education services', 98, 5.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Finance and insurance', 98, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Health care and social assistance', 98, 6.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Information', 98, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Management of Companies and Enterprises', 98, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Manufacturing', 98, 10.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Mining', 98, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Other services, except public administration', 98, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 98, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Public administration', 98, 19.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Real estate and rental and leasing', 98, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Retail trade', 98, 2.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Transportation and warehousing', 98, 53.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Unclassified', 98, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Utilities', 98, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'NAICS Sector', 'Wholesale trade', 98, 3.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'SOC Eligibility Rate', NULL, NULL, 24.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.01', 'Total Completed Questionnaires', NULL, 98, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'Data Collection Mode', 'Paper', 24, 54.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'Data Collection Mode', 'Web', 24, 45.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 24, 87.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 24, 12.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'OE Completeness Rate', NULL, NULL, 75.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'OE Response Rate', NULL, NULL, 44.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.02', 'Total Completed Questionnaires', NULL, 24, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'Data Collection Mode', 'Paper', 30, 50.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'Data Collection Mode', 'Web', 30, 50.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 30, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'How Much Experience Performing Work in this Occupation', '10+ Years', 30, 83.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 30, 3.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 30, 10.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'How Much Experience Performing Work in this Occupation', '<1 Year', 30, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'How Much Experience Performing Work in this Occupation', 'Missing', 30, 3.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 30, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'OE Completeness Rate', NULL, NULL, 96.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'OE Response Rate', NULL, NULL, 37.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3071.03', 'Total Completed Questionnaires', NULL, 30, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Data Collection Mode', 'Paper', 21, 14.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Data Collection Mode', 'Web', 21, 85.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 90.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 9.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'OE Completeness Rate', NULL, NULL, 95.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'OE Response Rate', NULL, NULL, 47.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3111.00', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Data Collection Mode', 'Paper', 24, 41.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Data Collection Mode', 'Web', 24, 58.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 24, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 24, 95.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 24, 4.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 24, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 24, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 24, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 24, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'OE Completeness Rate', NULL, NULL, 88.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'OE Response Rate', NULL, NULL, 79.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3121.00', 'Total Completed Questionnaires', NULL, 24, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Data Collection Mode', 'Paper', 27, 44.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Data Collection Mode', 'Web', 27, 55.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 27, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 27, 77.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 27, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 27, 18.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 27, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 27, 3.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 27, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'OE Completeness Rate', NULL, NULL, 84.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'OE Response Rate', NULL, NULL, 84.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-3131.00', 'Total Completed Questionnaires', NULL, 27, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Data Collection Mode', 'Paper', 92, 85.9, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Data Collection Mode', 'Web', 92, 14.1, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Employee Completeness Rate', NULL, NULL, 90.2, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Employee Response Rate', NULL, NULL, 66.2, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Establishment Eligibility Rate', NULL, NULL, 93.5, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Establishment Response Rate', NULL, NULL, 69.1, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'How Long at Current Job', '1-5 Years', 92, 23.9, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'How Long at Current Job', '10 Years or More', 92, 58.7, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'How Long at Current Job', '6-9 Years', 92, 13.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'How Long at Current Job', '<1 Year', 92, 4.3, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'How Long at Current Job', 'Missing', 92, 0.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 92, 83.7, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 92, 0.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 92, 0.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 92, 0.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 92, 0.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 92, 0.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 92, 0.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 92, 8.7, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 92, 2.2, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 92, 0.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 92, 5.4, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'SOC Eligibility Rate', NULL, NULL, 31.1, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.01', 'Total Completed Questionnaires', NULL, 92, NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'Data Collection Mode', 'Paper', 70, 78.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'Data Collection Mode', 'Web', 70, 21.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'Employee Completeness Rate', NULL, NULL, 87.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'Employee Response Rate', NULL, NULL, 82.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'Establishment Eligibility Rate', NULL, NULL, 66.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'Establishment Response Rate', NULL, NULL, 79.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'How Long at Current Job', '1-5 Years', 70, 7.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'How Long at Current Job', '10 Years or More', 70, 84.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'How Long at Current Job', '6-9 Years', 70, 8.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'How Long at Current Job', '<1 Year', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'How Long at Current Job', 'Missing', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 70, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Accommodation and food services', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 70, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Arts, entertainment, and recreation', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Construction', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Education services', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Finance and insurance', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Health care and social assistance', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Information', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Management of Companies and Enterprises', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Manufacturing', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Mining', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Other services, except public administration', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Public administration', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Real estate and rental and leasing', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Retail trade', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Transportation and warehousing', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Unclassified', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Utilities', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'NAICS Sector', 'Wholesale trade', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'SOC Eligibility Rate', NULL, NULL, 42.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.02', 'Total Completed Questionnaires', NULL, 70, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'Data Collection Mode', 'Paper', 20, 50.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'Data Collection Mode', 'Web', 20, 50.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 95.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 5.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'OE Completeness Rate', NULL, NULL, 95.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'OE Response Rate', NULL, NULL, 58.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9013.03', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Data Collection Mode', 'Paper', 25, 32.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Data Collection Mode', 'Web', 25, 68.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 25, 92.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 25, 8.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'OE Completeness Rate', NULL, NULL, 86.2, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'OE Response Rate', NULL, NULL, 82.9, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9021.00', 'Total Completed Questionnaires', NULL, 25, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Data Collection Mode', 'Paper', 91, 67.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Data Collection Mode', 'Web', 91, 33.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Employee Completeness Rate', NULL, NULL, 93.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Employee Response Rate', NULL, NULL, 75.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Establishment Eligibility Rate', NULL, NULL, 80.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Establishment Response Rate', NULL, NULL, 61.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'How Long at Current Job', '1-5 Years', 91, 36.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'How Long at Current Job', '10 Years or More', 91, 40.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'How Long at Current Job', '6-9 Years', 91, 15.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'How Long at Current Job', '<1 Year', 91, 6.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'How Long at Current Job', 'Missing', 91, 1.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 91, 100.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Accommodation and food services', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Construction', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Education services', 91, 2.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Finance and insurance', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Health care and social assistance', 91, 97.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Information', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Management of Companies and Enterprises', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Manufacturing', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Mining', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Other services, except public administration', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Public administration', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Real estate and rental and leasing', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Retail trade', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Transportation and warehousing', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Unclassified', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Utilities', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'NAICS Sector', 'Wholesale trade', 91, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'SOC Eligibility Rate', NULL, NULL, 68.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9031.00', 'Total Completed Questionnaires', NULL, 91, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Data Collection Mode', 'Paper', 105, 63.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Data Collection Mode', 'Web', 105, 36.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Employee Completeness Rate', NULL, NULL, 94.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Employee Response Rate', NULL, NULL, 73.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Establishment Eligibility Rate', NULL, NULL, 90.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Establishment Response Rate', NULL, NULL, 67.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'How Long at Current Job', '1-5 Years', 105, 38.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'How Long at Current Job', '10 Years or More', 105, 28.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'How Long at Current Job', '6-9 Years', 105, 21.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'How Long at Current Job', '<1 Year', 105, 10.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'How Long at Current Job', 'Missing', 105, 1.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 105, 100.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Accommodation and food services', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Construction', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Education services', 105, 100.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Finance and insurance', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Health care and social assistance', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Information', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Management of Companies and Enterprises', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Manufacturing', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Mining', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Other services, except public administration', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Public administration', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Real estate and rental and leasing', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Retail trade', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Transportation and warehousing', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Unclassified', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Utilities', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'NAICS Sector', 'Wholesale trade', 105, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'SOC Eligibility Rate', NULL, NULL, 58.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9032.00', 'Total Completed Questionnaires', NULL, 105, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Data Collection Mode', 'Paper', 114, 49.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Data Collection Mode', 'Web', 114, 50.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Employee Completeness Rate', NULL, NULL, 90.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Employee Response Rate', NULL, NULL, 67.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Establishment Eligibility Rate', NULL, NULL, 82.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Establishment Response Rate', NULL, NULL, 57.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'How Long at Current Job', '1-5 Years', 114, 41.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'How Long at Current Job', '10 Years or More', 114, 34.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'How Long at Current Job', '6-9 Years', 114, 12.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'How Long at Current Job', '<1 Year', 114, 10.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'How Long at Current Job', 'Missing', 114, 1.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 114, 100.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Accommodation and food services', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Construction', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Education services', 114, 100.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Finance and insurance', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Health care and social assistance', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Information', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Management of Companies and Enterprises', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Manufacturing', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Mining', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Other services, except public administration', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Public administration', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Real estate and rental and leasing', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Retail trade', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Transportation and warehousing', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Unclassified', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Utilities', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'NAICS Sector', 'Wholesale trade', 114, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'SOC Eligibility Rate', NULL, NULL, 66.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9033.00', 'Total Completed Questionnaires', NULL, 114, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.01', 'Data Collection Mode', 'Paper', 22, 22.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.01', 'Data Collection Mode', 'Web', 22, 77.3, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 54.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 4.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 40.9, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.01', 'OE Completeness Rate', NULL, NULL, 88.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.01', 'OE Response Rate', NULL, NULL, 71.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.01', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.02', 'Data Collection Mode', 'Paper', 24, 45.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.02', 'Data Collection Mode', 'Web', 24, 54.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 24, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 24, 79.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 24, 8.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 24, 12.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 24, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 24, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 24, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.02', 'OE Completeness Rate', NULL, NULL, 96.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.02', 'OE Response Rate', NULL, NULL, 86.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9039.02', 'Total Completed Questionnaires', NULL, 24, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Data Collection Mode', 'Paper', 127, 56.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Data Collection Mode', 'Web', 127, 43.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Employee Completeness Rate', NULL, NULL, 94.1, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Employee Response Rate', NULL, NULL, 69.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Establishment Eligibility Rate', NULL, NULL, 87.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Establishment Response Rate', NULL, NULL, 58.5, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'How Long at Current Job', '1-5 Years', 127, 44.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'How Long at Current Job', '10 Years or More', 127, 39.4, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'How Long at Current Job', '6-9 Years', 127, 8.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'How Long at Current Job', '<1 Year', 127, 6.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'How Long at Current Job', 'Missing', 127, 0.8, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 127, 77.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 127, 13.4, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 127, 7.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 127, 1.6, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Accommodation and food services', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Construction', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Education services', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Finance and insurance', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Health care and social assistance', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Information', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Management of Companies and Enterprises', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Manufacturing', 127, 77.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Mining', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Other services, except public administration', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 127, 7.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Public administration', 127, 13.4, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Real estate and rental and leasing', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Retail trade', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Transportation and warehousing', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Unclassified', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Utilities', 127, 1.6, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'NAICS Sector', 'Wholesale trade', 127, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'SOC Eligibility Rate', NULL, NULL, 26.8, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.00', 'Total Completed Questionnaires', NULL, 127, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Data Collection Mode', 'Paper', 100, 36.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Data Collection Mode', 'Web', 100, 64.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Employee Completeness Rate', NULL, NULL, 93.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Employee Response Rate', NULL, NULL, 80.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Establishment Eligibility Rate', NULL, NULL, 81.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Establishment Response Rate', NULL, NULL, 85.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'How Long at Current Job', '1-5 Years', 100, 52.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'How Long at Current Job', '10 Years or More', 100, 15.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'How Long at Current Job', '6-9 Years', 100, 18.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'How Long at Current Job', '<1 Year', 100, 15.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'How Long at Current Job', 'Missing', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 100, 4.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 100, 78.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 100, 3.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 100, 12.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 100, 3.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Accommodation and food services', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Construction', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Education services', 100, 1.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Finance and insurance', 100, 4.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Health care and social assistance', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Information', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Management of Companies and Enterprises', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Manufacturing', 100, 77.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Mining', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Other services, except public administration', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 100, 11.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Public administration', 100, 3.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Real estate and rental and leasing', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Retail trade', 100, 1.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Transportation and warehousing', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Unclassified', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Utilities', 100, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'NAICS Sector', 'Wholesale trade', 100, 3.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'SOC Eligibility Rate', NULL, NULL, 11.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9041.01', 'Total Completed Questionnaires', NULL, 100, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Data Collection Mode', 'Paper', 91, 79.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Data Collection Mode', 'Web', 91, 20.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Employee Completeness Rate', NULL, NULL, 92.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Employee Response Rate', NULL, NULL, 62.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Establishment Eligibility Rate', NULL, NULL, 95.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Establishment Response Rate', NULL, NULL, 39.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'How Long at Current Job', '1-5 Years', 91, 36.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'How Long at Current Job', '10 Years or More', 91, 37.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'How Long at Current Job', '6-9 Years', 91, 15.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'How Long at Current Job', '<1 Year', 91, 11.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'How Long at Current Job', 'Missing', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 91, 1.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 91, 52.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 91, 46.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Accommodation and food services', 91, 49.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 91, 11.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Construction', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Education services', 91, 9.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Finance and insurance', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Health care and social assistance', 91, 25.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Information', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Management of Companies and Enterprises', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Manufacturing', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Mining', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Other services, except public administration', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Public administration', 91, 1.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Real estate and rental and leasing', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Retail trade', 91, 3.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Transportation and warehousing', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Unclassified', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Utilities', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'NAICS Sector', 'Wholesale trade', 91, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'SOC Eligibility Rate', NULL, NULL, 49.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9051.00', 'Total Completed Questionnaires', NULL, 91, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'Data Collection Mode', 'Paper', 56, 67.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'Data Collection Mode', 'Web', 56, 32.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'Employee Completeness Rate', NULL, NULL, 93.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'Employee Response Rate', NULL, NULL, 83.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'Establishment Eligibility Rate', NULL, NULL, 87.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'Establishment Response Rate', NULL, NULL, 68.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'How Long at Current Job', '1-5 Years', 56, 23.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'How Long at Current Job', '10 Years or More', 56, 69.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'How Long at Current Job', '6-9 Years', 56, 7.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'How Long at Current Job', '<1 Year', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'How Long at Current Job', 'Missing', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 56, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Accommodation and food services', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Construction', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Education services', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Finance and insurance', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Health care and social assistance', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Information', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Management of Companies and Enterprises', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Manufacturing', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Mining', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Other services, except public administration', 56, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Public administration', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Real estate and rental and leasing', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Retail trade', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Transportation and warehousing', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Unclassified', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Utilities', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'NAICS Sector', 'Wholesale trade', 56, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'SOC Eligibility Rate', NULL, NULL, 50.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9061.00', 'Total Completed Questionnaires', NULL, 56, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Data Collection Mode', 'Paper', 91, 61.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Data Collection Mode', 'Web', 91, 38.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Employee Completeness Rate', NULL, NULL, 95.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Employee Response Rate', NULL, NULL, 58.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Establishment Eligibility Rate', NULL, NULL, 85.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Establishment Response Rate', NULL, NULL, 53.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'How Long at Current Job', '1-5 Years', 91, 24.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'How Long at Current Job', '10 Years or More', 91, 48.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'How Long at Current Job', '6-9 Years', 91, 18.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'How Long at Current Job', '<1 Year', 91, 8.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'How Long at Current Job', 'Missing', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 91, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Accommodation and food services', 91, 44.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 91, 56.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Construction', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Education services', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Finance and insurance', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Health care and social assistance', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Information', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Management of Companies and Enterprises', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Manufacturing', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Mining', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Other services, except public administration', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Public administration', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Real estate and rental and leasing', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Retail trade', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Transportation and warehousing', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Unclassified', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Utilities', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'NAICS Sector', 'Wholesale trade', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'SOC Eligibility Rate', NULL, NULL, 45.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9071.00', 'Total Completed Questionnaires', NULL, 91, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Data Collection Mode', 'Paper', 49, 53.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Data Collection Mode', 'Web', 49, 46.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Employee Completeness Rate', NULL, NULL, 90.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Employee Response Rate', NULL, NULL, 54.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Establishment Eligibility Rate', NULL, NULL, 94.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Establishment Response Rate', NULL, NULL, 42.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'How Long at Current Job', '1-5 Years', 49, 55.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'How Long at Current Job', '10 Years or More', 49, 18.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'How Long at Current Job', '6-9 Years', 49, 14.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'How Long at Current Job', '<1 Year', 49, 10.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'How Long at Current Job', 'Missing', 49, 2.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 49, 100.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Accommodation and food services', 49, 100.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Construction', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Education services', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Finance and insurance', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Health care and social assistance', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Information', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Management of Companies and Enterprises', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Manufacturing', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Mining', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Other services, except public administration', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Public administration', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Real estate and rental and leasing', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Retail trade', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Transportation and warehousing', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Unclassified', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Utilities', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'NAICS Sector', 'Wholesale trade', 49, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'SOC Eligibility Rate', NULL, NULL, 69.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9081.00', 'Total Completed Questionnaires', NULL, 49, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Data Collection Mode', 'Paper', 26, 30.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Data Collection Mode', 'Web', 26, 69.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 26, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 26, 88.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 26, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 26, 7.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 26, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 26, 3.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 26, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'OE Completeness Rate', NULL, NULL, 86.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'OE Response Rate', NULL, NULL, 43.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9111.00', 'Total Completed Questionnaires', NULL, 26, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Data Collection Mode', 'Paper', 70, 60.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Data Collection Mode', 'Web', 70, 40.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Employee Completeness Rate', NULL, NULL, 86.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Employee Response Rate', NULL, NULL, 66.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Establishment Eligibility Rate', NULL, NULL, 89.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Establishment Response Rate', NULL, NULL, 68.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'How Long at Current Job', '1-5 Years', 70, 30.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'How Long at Current Job', '10 Years or More', 70, 48.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'How Long at Current Job', '6-9 Years', 70, 15.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'How Long at Current Job', '<1 Year', 70, 5.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'How Long at Current Job', 'Missing', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 70, 8.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 70, 60.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 70, 14.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 70, 10.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 70, 7.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Accommodation and food services', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Construction', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Education services', 70, 11.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Finance and insurance', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Health care and social assistance', 70, 1.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Information', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Management of Companies and Enterprises', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Manufacturing', 70, 8.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Mining', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Other services, except public administration', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 70, 1.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Public administration', 70, 60.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Real estate and rental and leasing', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Retail trade', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Transportation and warehousing', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Unclassified', 70, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Utilities', 70, 10.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'NAICS Sector', 'Wholesale trade', 70, 7.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'SOC Eligibility Rate', NULL, NULL, 12.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.00', 'Total Completed Questionnaires', NULL, 70, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Data Collection Mode', 'Paper', 74, 70.3, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Data Collection Mode', 'Web', 74, 29.7, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Employee Completeness Rate', NULL, NULL, 93.7, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Employee Response Rate', NULL, NULL, 66.9, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Establishment Eligibility Rate', NULL, NULL, 89.9, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Establishment Response Rate', NULL, NULL, 75.3, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'How Long at Current Job', '1-5 Years', 74, 52.7, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'How Long at Current Job', '10 Years or More', 74, 17.6, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'How Long at Current Job', '6-9 Years', 74, 21.6, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'How Long at Current Job', '<1 Year', 74, 8.1, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'How Long at Current Job', 'Missing', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 74, 9.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 74, 90.5, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Accommodation and food services', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Construction', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Education services', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Finance and insurance', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Health care and social assistance', 74, 35.1, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Information', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Management of Companies and Enterprises', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Manufacturing', 74, 9.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Mining', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Other services, except public administration', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 74, 55.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Public administration', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Real estate and rental and leasing', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Retail trade', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Transportation and warehousing', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Unclassified', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Utilities', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'NAICS Sector', 'Wholesale trade', 74, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'SOC Eligibility Rate', NULL, NULL, 9.7, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.01', 'Total Completed Questionnaires', NULL, 74, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'Data Collection Mode', 'Paper', 29, 48.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'Data Collection Mode', 'Web', 29, 51.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 29, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 29, 100.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 29, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 29, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 29, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 29, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 29, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'OE Completeness Rate', NULL, NULL, 93.6, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'OE Response Rate', NULL, NULL, 88.6, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9121.02', 'Total Completed Questionnaires', NULL, 29, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Data Collection Mode', 'Paper', 86, 72.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Data Collection Mode', 'Web', 86, 27.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Employee Completeness Rate', NULL, NULL, 86.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Employee Response Rate', NULL, NULL, 47.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Establishment Eligibility Rate', NULL, NULL, 96.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Establishment Response Rate', NULL, NULL, 91.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'How Long at Current Job', '1-5 Years', 86, 25.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'How Long at Current Job', '10 Years or More', 86, 37.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'How Long at Current Job', '6-9 Years', 86, 22.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'How Long at Current Job', '<1 Year', 86, 12.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'How Long at Current Job', 'Missing', 86, 2.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 86, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Accommodation and food services', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Construction', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Education services', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Finance and insurance', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Health care and social assistance', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Information', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Management of Companies and Enterprises', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Manufacturing', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Mining', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Other services, except public administration', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Public administration', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Real estate and rental and leasing', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Retail trade', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Transportation and warehousing', 86, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Unclassified', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Utilities', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'NAICS Sector', 'Wholesale trade', 86, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'SOC Eligibility Rate', NULL, NULL, 94.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9131.00', 'Total Completed Questionnaires', NULL, 86, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Data Collection Mode', 'Paper', 26, 38.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Data Collection Mode', 'Web', 26, 61.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 26, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 26, 100.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 26, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 26, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 26, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 26, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 26, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'OE Completeness Rate', NULL, NULL, 96.3, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'OE Response Rate', NULL, NULL, 57.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9141.00', 'Total Completed Questionnaires', NULL, 26, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Data Collection Mode', 'Paper', 72, 50.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Data Collection Mode', 'Web', 72, 50.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Employee Completeness Rate', NULL, NULL, 90.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Employee Response Rate', NULL, NULL, 69.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Establishment Eligibility Rate', NULL, NULL, 84.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Establishment Response Rate', NULL, NULL, 72.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'How Long at Current Job', '1-5 Years', 72, 38.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'How Long at Current Job', '10 Years or More', 72, 38.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'How Long at Current Job', '6-9 Years', 72, 15.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'How Long at Current Job', '<1 Year', 72, 5.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'How Long at Current Job', 'Missing', 72, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 72, 19.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 72, 80.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Accommodation and food services', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Construction', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Education services', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Finance and insurance', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Health care and social assistance', 72, 70.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Information', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Management of Companies and Enterprises', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Manufacturing', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Mining', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Other services, except public administration', 72, 9.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Public administration', 72, 19.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Real estate and rental and leasing', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Retail trade', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Transportation and warehousing', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Unclassified', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Utilities', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'NAICS Sector', 'Wholesale trade', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'SOC Eligibility Rate', NULL, NULL, 23.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9151.00', 'Total Completed Questionnaires', NULL, 72, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Data Collection Mode', 'Paper', 25, 40.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Data Collection Mode', 'Web', 25, 60.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 25, 4.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 25, 72.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 25, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 25, 20.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 25, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 25, 4.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 25, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'OE Completeness Rate', NULL, NULL, 89.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'OE Response Rate', NULL, NULL, 71.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9161.00', 'Total Completed Questionnaires', NULL, 25, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Data Collection Mode', 'Paper', 28, 17.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Data Collection Mode', 'Web', 28, 82.1, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 28, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 28, 82.1, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 28, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 28, 17.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 28, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 28, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 28, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'OE Completeness Rate', NULL, NULL, 96.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'OE Response Rate', NULL, NULL, 61.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.01', 'Total Completed Questionnaires', NULL, 28, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Data Collection Mode', 'Paper', 77, 42.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Data Collection Mode', 'Web', 77, 57.1, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Employee Completeness Rate', NULL, NULL, 90.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Employee Response Rate', NULL, NULL, 67.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Establishment Eligibility Rate', NULL, NULL, 82.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Establishment Response Rate', NULL, NULL, 46.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'How Long at Current Job', '1-5 Years', 77, 26.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'How Long at Current Job', '10 Years or More', 77, 45.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'How Long at Current Job', '6-9 Years', 77, 22.1, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'How Long at Current Job', '<1 Year', 77, 6.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'How Long at Current Job', 'Missing', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 77, 10.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 77, 18.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 77, 19.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 77, 1.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 77, 36.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 77, 1.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 77, 9.1, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 77, 2.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 77, 1.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Accommodation and food services', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 77, 2.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Arts, entertainment, and recreation', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Construction', 77, 10.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Education services', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Finance and insurance', 77, 18.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Health care and social assistance', 77, 6.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Information', 77, 1.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Management of Companies and Enterprises', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Manufacturing', 77, 18.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Mining', 77, 1.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Other services, except public administration', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Public administration', 77, 36.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Real estate and rental and leasing', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Retail trade', 77, 1.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Transportation and warehousing', 77, 1.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Unclassified', 77, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Utilities', 77, 1.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'NAICS Sector', 'Wholesale trade', 77, 1.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'SOC Eligibility Rate', NULL, NULL, 14.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.02', 'Total Completed Questionnaires', NULL, 77, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'Data Collection Mode', 'Paper', 81, 56.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'Data Collection Mode', 'Web', 81, 43.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'Employee Completeness Rate', NULL, NULL, 95.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'Employee Response Rate', NULL, NULL, 66.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'Establishment Eligibility Rate', NULL, NULL, 78.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'Establishment Response Rate', NULL, NULL, 46.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'How Long at Current Job', '1-5 Years', 81, 25.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'How Long at Current Job', '10 Years or More', 81, 46.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'How Long at Current Job', '6-9 Years', 81, 22.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'How Long at Current Job', '<1 Year', 81, 3.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'How Long at Current Job', 'Missing', 81, 1.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 81, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Accommodation and food services', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Arts, entertainment, and recreation', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Construction', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Education services', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Finance and insurance', 81, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Health care and social assistance', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Information', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Management of Companies and Enterprises', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Manufacturing', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Mining', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Other services, except public administration', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Professional, Scientific and Technical Services', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Public administration', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Real estate and rental and leasing', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Retail trade', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Transportation and warehousing', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Unclassified', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Utilities', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'NAICS Sector', 'Wholesale trade', 81, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'SOC Eligibility Rate', NULL, NULL, 13.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.03', 'Total Completed Questionnaires', NULL, 81, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'Data Collection Mode', 'Paper', 21, 38.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'Data Collection Mode', 'Web', 21, 61.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 4.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 90.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 4.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'OE Completeness Rate', NULL, NULL, 87.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'OE Response Rate', NULL, NULL, 60.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.04', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.07', 'Data Collection Mode', 'Paper', 20, 45.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.07', 'Data Collection Mode', 'Web', 20, 55.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.07', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.07', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 90.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.07', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.07', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 10.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.07', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.07', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.07', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.07', 'OE Completeness Rate', NULL, NULL, 87.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.07', 'OE Response Rate', NULL, NULL, 67.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.07', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'Data Collection Mode', 'Paper', 22, 4.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'Data Collection Mode', 'Web', 22, 95.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 100.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'OE Response Rate', NULL, NULL, 44.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.08', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Data Collection Mode', 'Paper', 85, 57.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Data Collection Mode', 'Web', 85, 42.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Employee Completeness Rate', NULL, NULL, 98.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Employee Response Rate', NULL, NULL, 66.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Establishment Eligibility Rate', NULL, NULL, 86.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Establishment Response Rate', NULL, NULL, 79.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'How Long at Current Job', '1-5 Years', 85, 58.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'How Long at Current Job', '10 Years or More', 85, 9.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'How Long at Current Job', '6-9 Years', 85, 18.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'How Long at Current Job', '<1 Year', 85, 12.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'How Long at Current Job', 'Missing', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 85, 1.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 85, 2.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 85, 2.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 85, 1.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 85, 3.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 85, 89.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Accommodation and food services', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 85, 1.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Arts, entertainment, and recreation', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Construction', 85, 2.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Education services', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Finance and insurance', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Health care and social assistance', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Information', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Management of Companies and Enterprises', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Manufacturing', 85, 2.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Mining', 85, 1.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Other services, except public administration', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Professional, Scientific and Technical Services', 85, 3.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Public administration', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Real estate and rental and leasing', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Retail trade', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Transportation and warehousing', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Unclassified', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Utilities', 85, 89.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'NAICS Sector', 'Wholesale trade', 85, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'SOC Eligibility Rate', NULL, NULL, 8.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.09', 'Total Completed Questionnaires', NULL, 85, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Data Collection Mode', 'Paper', 53, 54.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Data Collection Mode', 'Web', 53, 45.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Employee Completeness Rate', NULL, NULL, 98.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Employee Response Rate', NULL, NULL, 62.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Establishment Eligibility Rate', NULL, NULL, 86.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Establishment Response Rate', NULL, NULL, 79.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'How Long at Current Job', '1-5 Years', 53, 64.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'How Long at Current Job', '10 Years or More', 53, 13.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'How Long at Current Job', '6-9 Years', 53, 13.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'How Long at Current Job', '<1 Year', 53, 7.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'How Long at Current Job', 'Missing', 53, 1.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 53, 7.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 53, 1.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 53, 7.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 53, 1.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 53, 81.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Accommodation and food services', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Arts, entertainment, and recreation', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Construction', 53, 7.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Education services', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Finance and insurance', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Health care and social assistance', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Information', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Management of Companies and Enterprises', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Manufacturing', 53, 1.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Mining', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Other services, except public administration', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Professional, Scientific and Technical Services', 53, 1.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Public administration', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Real estate and rental and leasing', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Retail trade', 53, 7.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Transportation and warehousing', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Unclassified', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Utilities', 53, 81.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'NAICS Sector', 'Wholesale trade', 53, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'SOC Eligibility Rate', NULL, NULL, 3.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.10', 'Total Completed Questionnaires', NULL, 53, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'Data Collection Mode', 'Paper', 25, 48.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'Data Collection Mode', 'Web', 25, 52.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'How Much Experience Performing Work in this Occupation', '10+ Years', 25, 84.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 25, 16.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'How Much Experience Performing Work in this Occupation', '<1 Year', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'How Much Experience Performing Work in this Occupation', 'Missing', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'OE Response Rate', NULL, NULL, 75.8, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('11-9199.11', 'Total Completed Questionnaires', NULL, 25, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Data Collection Mode', 'Paper', 136, 80.9, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Data Collection Mode', 'Web', 136, 19.1, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Employee Completeness Rate', NULL, NULL, 91.3, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Employee Response Rate', NULL, NULL, 54.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Establishment Eligibility Rate', NULL, NULL, 56.7, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Establishment Response Rate', NULL, NULL, 70.4, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'How Long at Current Job', '1-5 Years', 136, 26.5, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'How Long at Current Job', '10 Years or More', 136, 48.5, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'How Long at Current Job', '6-9 Years', 136, 15.4, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'How Long at Current Job', '<1 Year', 136, 7.4, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'How Long at Current Job', 'Missing', 136, 2.2, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 136, 0.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 136, 0.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 136, 0.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 136, 0.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 136, 0.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 136, 0.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 136, 0.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 136, 0.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 136, 100.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 136, 0.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 136, 0.0, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'SOC Eligibility Rate', NULL, NULL, 38.7, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1011.00', 'Total Completed Questionnaires', NULL, 136, NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Data Collection Mode', 'Paper', 71, 67.6, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Data Collection Mode', 'Web', 71, 32.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Employee Completeness Rate', NULL, NULL, 94.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Employee Response Rate', NULL, NULL, 70.8, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Establishment Eligibility Rate', NULL, NULL, 85.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Establishment Response Rate', NULL, NULL, 85.9, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'How Long at Current Job', '1-5 Years', 71, 28.2, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'How Long at Current Job', '10 Years or More', 71, 39.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'How Long at Current Job', '6-9 Years', 71, 19.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'How Long at Current Job', '<1 Year', 71, 12.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'How Long at Current Job', 'Missing', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 71, 22.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 71, 77.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Accommodation and food services', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Construction', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Education services', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Finance and insurance', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Health care and social assistance', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Information', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Management of Companies and Enterprises', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Manufacturing', 71, 22.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Mining', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Other services, except public administration', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Public administration', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Real estate and rental and leasing', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Retail trade', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Transportation and warehousing', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Unclassified', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Utilities', 71, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'NAICS Sector', 'Wholesale trade', 71, 77.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'SOC Eligibility Rate', NULL, NULL, 15.8, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1021.00', 'Total Completed Questionnaires', NULL, 71, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Data Collection Mode', 'Paper', 82, 74.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Data Collection Mode', 'Web', 82, 25.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Employee Completeness Rate', NULL, NULL, 92.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Employee Response Rate', NULL, NULL, 66.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Establishment Eligibility Rate', NULL, NULL, 85.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Establishment Response Rate', NULL, NULL, 64.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'How Long at Current Job', '1-5 Years', 82, 24.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'How Long at Current Job', '10 Years or More', 82, 51.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'How Long at Current Job', '6-9 Years', 82, 15.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'How Long at Current Job', '<1 Year', 82, 6.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'How Long at Current Job', 'Missing', 82, 2.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 82, 30.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 82, 69.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Accommodation and food services', 82, 3.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Construction', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Education services', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Finance and insurance', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Health care and social assistance', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Information', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Management of Companies and Enterprises', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Manufacturing', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Mining', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Other services, except public administration', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Public administration', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Real estate and rental and leasing', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Retail trade', 82, 26.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Transportation and warehousing', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Unclassified', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Utilities', 82, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'NAICS Sector', 'Wholesale trade', 82, 69.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'SOC Eligibility Rate', NULL, NULL, 11.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1022.00', 'Total Completed Questionnaires', NULL, 82, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Data Collection Mode', 'Paper', 23, 21.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Data Collection Mode', 'Web', 23, 78.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 87.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 13.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'OE Completeness Rate', NULL, NULL, 88.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'OE Response Rate', NULL, NULL, 51.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1023.00', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Data Collection Mode', 'Paper', 64, 81.2, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Data Collection Mode', 'Web', 64, 18.8, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Employee Completeness Rate', NULL, NULL, 95.5, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Employee Response Rate', NULL, NULL, 78.8, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Establishment Eligibility Rate', NULL, NULL, 77.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Establishment Response Rate', NULL, NULL, 52.6, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'How Long at Current Job', '1-5 Years', 64, 39.1, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'How Long at Current Job', '10 Years or More', 64, 35.9, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'How Long at Current Job', '6-9 Years', 64, 20.3, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'How Long at Current Job', '<1 Year', 64, 4.7, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'How Long at Current Job', 'Missing', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 64, 100.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Accommodation and food services', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Construction', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Education services', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Finance and insurance', 64, 100.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Health care and social assistance', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Information', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Management of Companies and Enterprises', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Manufacturing', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Mining', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Other services, except public administration', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Public administration', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Real estate and rental and leasing', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Retail trade', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Transportation and warehousing', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Unclassified', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Utilities', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'NAICS Sector', 'Wholesale trade', 64, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'SOC Eligibility Rate', NULL, NULL, 21.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.01', 'Total Completed Questionnaires', NULL, 64, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Data Collection Mode', 'Paper', 81, 69.1, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Data Collection Mode', 'Web', 81, 30.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Employee Completeness Rate', NULL, NULL, 95.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Employee Response Rate', NULL, NULL, 72.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Establishment Eligibility Rate', NULL, NULL, 78.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Establishment Response Rate', NULL, NULL, 39.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'How Long at Current Job', '1-5 Years', 81, 17.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'How Long at Current Job', '10 Years or More', 81, 66.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'How Long at Current Job', '6-9 Years', 81, 9.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'How Long at Current Job', '<1 Year', 81, 3.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'How Long at Current Job', 'Missing', 81, 2.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 81, 100.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Accommodation and food services', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Arts, entertainment, and recreation', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Construction', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Education services', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Finance and insurance', 81, 100.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Health care and social assistance', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Information', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Management of Companies and Enterprises', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Manufacturing', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Mining', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Other services, except public administration', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Public administration', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Real estate and rental and leasing', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Retail trade', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Transportation and warehousing', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Unclassified', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Utilities', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'NAICS Sector', 'Wholesale trade', 81, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'SOC Eligibility Rate', NULL, NULL, 16.1, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1031.02', 'Total Completed Questionnaires', NULL, 81, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Data Collection Mode', 'Paper', 57, 63.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Data Collection Mode', 'Web', 57, 36.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Employee Completeness Rate', NULL, NULL, 95.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Employee Response Rate', NULL, NULL, 63.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Establishment Eligibility Rate', NULL, NULL, 79.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Establishment Response Rate', NULL, NULL, 71.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'How Long at Current Job', '1-5 Years', 57, 21.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'How Long at Current Job', '10 Years or More', 57, 66.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'How Long at Current Job', '6-9 Years', 57, 8.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'How Long at Current Job', '<1 Year', 57, 3.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'How Long at Current Job', 'Missing', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 57, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Accommodation and food services', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Construction', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Education services', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Finance and insurance', 57, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Health care and social assistance', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Information', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Management of Companies and Enterprises', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Manufacturing', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Mining', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Other services, except public administration', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Public administration', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Real estate and rental and leasing', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Retail trade', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Transportation and warehousing', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Unclassified', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Utilities', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'NAICS Sector', 'Wholesale trade', 57, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'SOC Eligibility Rate', NULL, NULL, 8.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1032.00', 'Total Completed Questionnaires', NULL, 57, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Data Collection Mode', 'Paper', 21, 28.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Data Collection Mode', 'Web', 21, 71.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 90.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 9.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'OE Response Rate', NULL, NULL, 72.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.01', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Data Collection Mode', 'Paper', 79, 72.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Data Collection Mode', 'Web', 79, 27.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Employee Completeness Rate', NULL, NULL, 87.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Employee Response Rate', NULL, NULL, 67.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Establishment Eligibility Rate', NULL, NULL, 85.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Establishment Response Rate', NULL, NULL, 88.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'How Long at Current Job', '1-5 Years', 79, 26.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'How Long at Current Job', '10 Years or More', 79, 36.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'How Long at Current Job', '6-9 Years', 79, 26.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'How Long at Current Job', '<1 Year', 79, 8.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'How Long at Current Job', 'Missing', 79, 1.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 79, 100.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Accommodation and food services', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Arts, entertainment, and recreation', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Construction', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Education services', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Finance and insurance', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Health care and social assistance', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Information', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Management of Companies and Enterprises', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Manufacturing', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Mining', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Other services, except public administration', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Public administration', 79, 100.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Real estate and rental and leasing', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Retail trade', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Transportation and warehousing', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Unclassified', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Utilities', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'NAICS Sector', 'Wholesale trade', 79, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'SOC Eligibility Rate', NULL, NULL, 12.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.02', 'Total Completed Questionnaires', NULL, 79, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Data Collection Mode', 'Paper', 109, 61.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Data Collection Mode', 'Web', 109, 38.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Employee Completeness Rate', NULL, NULL, 90.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Employee Response Rate', NULL, NULL, 72.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Establishment Eligibility Rate', NULL, NULL, 90.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Establishment Response Rate', NULL, NULL, 87.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'How Long at Current Job', '1-5 Years', 109, 38.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'How Long at Current Job', '10 Years or More', 109, 43.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'How Long at Current Job', '6-9 Years', 109, 10.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'How Long at Current Job', '<1 Year', 109, 7.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'How Long at Current Job', 'Missing', 109, 0.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 109, 42.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 109, 57.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Accommodation and food services', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Arts, entertainment, and recreation', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Construction', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Education services', 109, 56.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Finance and insurance', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Health care and social assistance', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Information', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Management of Companies and Enterprises', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Manufacturing', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Mining', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Other services, except public administration', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Professional, Scientific and Technical Services', 109, 0.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Public administration', 109, 42.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Real estate and rental and leasing', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Retail trade', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Transportation and warehousing', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Unclassified', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Utilities', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'NAICS Sector', 'Wholesale trade', 109, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'SOC Eligibility Rate', NULL, NULL, 33.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.03', 'Total Completed Questionnaires', NULL, 109, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Data Collection Mode', 'Paper', 52, 53.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Data Collection Mode', 'Web', 52, 46.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Employee Completeness Rate', NULL, NULL, 81.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Employee Response Rate', NULL, NULL, 85.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Establishment Eligibility Rate', NULL, NULL, 93.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Establishment Response Rate', NULL, NULL, 87.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'How Long at Current Job', '1-5 Years', 52, 28.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'How Long at Current Job', '10 Years or More', 52, 34.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'How Long at Current Job', '6-9 Years', 52, 25.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'How Long at Current Job', '<1 Year', 52, 11.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'How Long at Current Job', 'Missing', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 52, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Accommodation and food services', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Arts, entertainment, and recreation', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Construction', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Education services', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Finance and insurance', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Health care and social assistance', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Information', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Management of Companies and Enterprises', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Manufacturing', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Mining', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Other services, except public administration', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Professional, Scientific and Technical Services', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Public administration', 52, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Real estate and rental and leasing', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Retail trade', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Transportation and warehousing', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Unclassified', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Utilities', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'NAICS Sector', 'Wholesale trade', 52, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'SOC Eligibility Rate', NULL, NULL, 10.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.04', 'Total Completed Questionnaires', NULL, 52, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Data Collection Mode', 'Paper', 31, 87.1, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Data Collection Mode', 'Web', 31, 12.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 31, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Much Experience Performing Work in this Occupation', '10+ Years', 31, 100.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 31, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 31, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Much Experience Performing Work in this Occupation', '<1 Year', 31, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Much Experience Performing Work in this Occupation', 'Missing', 31, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 31, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'OE Completeness Rate', NULL, NULL, 96.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'OE Response Rate', NULL, NULL, 84.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.06', 'Total Completed Questionnaires', NULL, 31, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Data Collection Mode', 'Paper', 20, 20.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Data Collection Mode', 'Web', 20, 80.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 50.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 5.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 45.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'OE Completeness Rate', NULL, NULL, 95.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'OE Response Rate', NULL, NULL, 51.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1041.07', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Data Collection Mode', 'Paper', 22, 50.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Data Collection Mode', 'Web', 22, 50.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 72.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 4.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 22.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'OE Completeness Rate', NULL, NULL, 95.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'OE Response Rate', NULL, NULL, 67.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1051.00', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Data Collection Mode', 'Paper', 125, 52.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Data Collection Mode', 'Web', 125, 47.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Employee Completeness Rate', NULL, NULL, 87.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Employee Response Rate', NULL, NULL, 74.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Establishment Eligibility Rate', NULL, NULL, 79.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Establishment Response Rate', NULL, NULL, 46.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'How Long at Current Job', '1-5 Years', 125, 36.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'How Long at Current Job', '10 Years or More', 125, 36.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'How Long at Current Job', '6-9 Years', 125, 18.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'How Long at Current Job', '<1 Year', 125, 8.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'How Long at Current Job', 'Missing', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 125, 8.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 125, 2.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 125, 5.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 125, 1.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 125, 53.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 125, 0.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 125, 22.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 125, 1.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 125, 3.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Accommodation and food services', 125, 4.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 125, 8.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 125, 1.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Construction', 125, 8.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Education services', 125, 5.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Finance and insurance', 125, 0.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Health care and social assistance', 125, 2.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Information', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Management of Companies and Enterprises', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Manufacturing', 125, 5.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Mining', 125, 1.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Other services, except public administration', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Public administration', 125, 53.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Real estate and rental and leasing', 125, 1.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Retail trade', 125, 0.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Transportation and warehousing', 125, 0.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Unclassified', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Utilities', 125, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'NAICS Sector', 'Wholesale trade', 125, 3.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'SOC Eligibility Rate', NULL, NULL, 20.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1071.00', 'Total Completed Questionnaires', NULL, 125, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Data Collection Mode', 'Paper', 57, 87.7, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Data Collection Mode', 'Web', 57, 12.3, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Employee Completeness Rate', NULL, NULL, 75.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Employee Response Rate', NULL, NULL, 59.8, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Establishment Eligibility Rate', NULL, NULL, 72.6, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Establishment Response Rate', NULL, NULL, 73.1, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'How Long at Current Job', '1-5 Years', 57, 15.8, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'How Long at Current Job', '10 Years or More', 57, 70.2, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'How Long at Current Job', '6-9 Years', 57, 10.5, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'How Long at Current Job', '<1 Year', 57, 3.5, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'How Long at Current Job', 'Missing', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 57, 98.2, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 57, 0.0, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 57, 1.8, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'SOC Eligibility Rate', NULL, NULL, 12.9, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1074.00', 'Total Completed Questionnaires', NULL, 57, NULL, TO_DATE('2008-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'Data Collection Mode', 'Paper', 20, 50.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'Data Collection Mode', 'Web', 20, 50.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 10.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 85.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 5.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'OE Completeness Rate', NULL, NULL, 87.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'OE Response Rate', NULL, NULL, 92.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1075.00', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Data Collection Mode', 'Paper', 24, 41.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Data Collection Mode', 'Web', 24, 58.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 24, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 24, 91.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 24, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 24, 8.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 24, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 24, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 24, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'OE Completeness Rate', NULL, NULL, 92.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'OE Response Rate', NULL, NULL, 53.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.00', 'Total Completed Questionnaires', NULL, 24, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Data Collection Mode', 'Paper', 22, 54.5, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Data Collection Mode', 'Web', 22, 45.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 90.9, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 9.1, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'OE Completeness Rate', NULL, NULL, 91.7, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'OE Response Rate', NULL, NULL, 80.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.01', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Data Collection Mode', 'Paper', 26, 50.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Data Collection Mode', 'Web', 26, 50.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 26, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 26, 80.8, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 26, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 26, 15.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 26, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 26, 3.8, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 26, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'OE Completeness Rate', NULL, NULL, 89.7, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'OE Response Rate', NULL, NULL, 65.9, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1081.02', 'Total Completed Questionnaires', NULL, 26, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Data Collection Mode', 'Paper', 26, 34.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Data Collection Mode', 'Web', 26, 65.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 26, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 26, 92.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 26, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 26, 7.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 26, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 26, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 26, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'OE Completeness Rate', NULL, NULL, 96.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'OE Response Rate', NULL, NULL, 77.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1111.00', 'Total Completed Questionnaires', NULL, 26, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Data Collection Mode', 'Paper', 66, 59.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Data Collection Mode', 'Web', 66, 40.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Employee Completeness Rate', NULL, NULL, 86.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Employee Response Rate', NULL, NULL, 62.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Establishment Eligibility Rate', NULL, NULL, 89.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Establishment Response Rate', NULL, NULL, 50.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'How Long at Current Job', '1-5 Years', 66, 40.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'How Long at Current Job', '10 Years or More', 66, 22.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'How Long at Current Job', '6-9 Years', 66, 22.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'How Long at Current Job', '<1 Year', 66, 13.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'How Long at Current Job', 'Missing', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 66, 4.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 66, 95.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Accommodation and food services', 66, 51.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 66, 3.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Construction', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Education services', 66, 34.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Finance and insurance', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Health care and social assistance', 66, 1.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Information', 66, 1.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Management of Companies and Enterprises', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Manufacturing', 66, 3.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Mining', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Other services, except public administration', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 66, 4.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Public administration', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Real estate and rental and leasing', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Retail trade', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Transportation and warehousing', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Unclassified', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Utilities', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'NAICS Sector', 'Wholesale trade', 66, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'SOC Eligibility Rate', NULL, NULL, 29.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1121.00', 'Total Completed Questionnaires', NULL, 66, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'Data Collection Mode', 'Paper', 32, 46.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'Data Collection Mode', 'Web', 32, 53.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 32, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 32, 87.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 32, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 32, 12.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 32, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 32, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 32, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'OE Completeness Rate', NULL, NULL, 97.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'OE Response Rate', NULL, NULL, 89.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1131.00', 'Total Completed Questionnaires', NULL, 32, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Data Collection Mode', 'Paper', 24, 29.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Data Collection Mode', 'Web', 24, 70.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 24, 75.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 24, 25.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'OE Completeness Rate', NULL, NULL, 88.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'OE Response Rate', NULL, NULL, 39.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1141.00', 'Total Completed Questionnaires', NULL, 24, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Data Collection Mode', 'Paper', 36, 38.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Data Collection Mode', 'Web', 36, 61.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 36, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 36, 97.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 36, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 36, 2.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 36, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 36, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 36, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'OE Response Rate', NULL, NULL, 92.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1151.00', 'Total Completed Questionnaires', NULL, 36, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Data Collection Mode', 'Paper', 23, 34.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Data Collection Mode', 'Web', 23, 65.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 87.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 13.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'OE Completeness Rate', NULL, NULL, 95.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'OE Response Rate', NULL, NULL, 72.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1161.00', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'Data Collection Mode', 'Paper', 22, 59.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'Data Collection Mode', 'Web', 22, 40.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 50.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 4.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 45.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'OE Response Rate', NULL, NULL, 78.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.01', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.02', 'Data Collection Mode', 'Paper', 26, 30.8, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.02', 'Data Collection Mode', 'Web', 26, 69.2, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 26, 3.8, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 26, 88.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 26, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 26, 7.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 26, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 26, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 26, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.02', 'OE Completeness Rate', NULL, NULL, 92.9, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.02', 'OE Response Rate', NULL, NULL, 75.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.02', 'Total Completed Questionnaires', NULL, 26, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'Data Collection Mode', 'Paper', 20, 40.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'Data Collection Mode', 'Web', 20, 60.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 95.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 5.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'OE Completeness Rate', NULL, NULL, 95.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'OE Response Rate', NULL, NULL, 53.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.03', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Data Collection Mode', 'Paper', 22, 22.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Data Collection Mode', 'Web', 22, 77.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 4.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 95.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'OE Completeness Rate', NULL, NULL, 91.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'OE Response Rate', NULL, NULL, 57.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.04', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'Data Collection Mode', 'Paper', 28, 53.6, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'Data Collection Mode', 'Web', 28, 46.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 28, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'How Much Experience Performing Work in this Occupation', '10+ Years', 28, 35.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 28, 17.8, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 28, 46.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'How Much Experience Performing Work in this Occupation', '<1 Year', 28, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'How Much Experience Performing Work in this Occupation', 'Missing', 28, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 28, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'OE Completeness Rate', NULL, NULL, 93.3, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'OE Response Rate', NULL, NULL, 75.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.05', 'Total Completed Questionnaires', NULL, 28, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Data Collection Mode', 'Paper', 75, 42.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Data Collection Mode', 'Web', 75, 57.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Employee Completeness Rate', NULL, NULL, 84.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Employee Response Rate', NULL, NULL, 65.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Establishment Eligibility Rate', NULL, NULL, 80.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Establishment Response Rate', NULL, NULL, 56.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'How Long at Current Job', '1-5 Years', 75, 44.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'How Long at Current Job', '10 Years or More', 75, 26.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'How Long at Current Job', '6-9 Years', 75, 20.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'How Long at Current Job', '<1 Year', 75, 9.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'How Long at Current Job', 'Missing', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 75, 4.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 75, 84.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 75, 8.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 75, 4.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Accommodation and food services', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 75, 5.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Arts, entertainment, and recreation', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Construction', 75, 4.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Education services', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Finance and insurance', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Health care and social assistance', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Information', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Management of Companies and Enterprises', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Manufacturing', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Mining', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Other services, except public administration', 75, 2.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Professional, Scientific and Technical Services', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Public administration', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Real estate and rental and leasing', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Retail trade', 75, 88.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Transportation and warehousing', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Unclassified', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Utilities', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'NAICS Sector', 'Wholesale trade', 75, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'SOC Eligibility Rate', NULL, NULL, 36.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-1199.06', 'Total Completed Questionnaires', NULL, 75, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Data Collection Mode', 'Paper', 133, 51.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Data Collection Mode', 'Web', 133, 48.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Employee Completeness Rate', NULL, NULL, 94.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Employee Response Rate', NULL, NULL, 63.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Establishment Eligibility Rate', NULL, NULL, 84.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Establishment Response Rate', NULL, NULL, 54.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'How Long at Current Job', '1-5 Years', 133, 27.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'How Long at Current Job', '10 Years or More', 133, 40.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'How Long at Current Job', '6-9 Years', 133, 18.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'How Long at Current Job', '<1 Year', 133, 14.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'How Long at Current Job', 'Missing', 133, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 133, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 133, 3.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 133, 8.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 133, 10.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 133, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 133, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 133, 5.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 133, 3.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 133, 55.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 133, 9.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 133, 3.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Accommodation and food services', 133, 8.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 133, 2.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 133, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 133, 9.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Construction', 133, 3.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Education services', 133, 0.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Finance and insurance', 133, 6.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Health care and social assistance', 133, 21.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Information', 133, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Management of Companies and Enterprises', 133, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Manufacturing', 133, 10.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Mining', 133, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Other services, except public administration', 133, 6.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 133, 6.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Public administration', 133, 5.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Real estate and rental and leasing', 133, 1.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Retail trade', 133, 3.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Transportation and warehousing', 133, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Unclassified', 133, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Utilities', 133, 9.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'NAICS Sector', 'Wholesale trade', 133, 3.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'SOC Eligibility Rate', NULL, NULL, 32.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.01', 'Total Completed Questionnaires', NULL, 133, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'Data Collection Mode', 'Paper', 21, 38.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'Data Collection Mode', 'Web', 21, 61.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'OE Response Rate', NULL, NULL, 72.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2011.02', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Data Collection Mode', 'Paper', 59, 67.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Data Collection Mode', 'Web', 59, 32.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Employee Completeness Rate', NULL, NULL, 95.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Employee Response Rate', NULL, NULL, 71.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Establishment Eligibility Rate', NULL, NULL, 50.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Establishment Response Rate', NULL, NULL, 66.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'How Long at Current Job', '1-5 Years', 59, 32.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'How Long at Current Job', '10 Years or More', 59, 39.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'How Long at Current Job', '6-9 Years', 59, 18.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'How Long at Current Job', '<1 Year', 59, 10.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'How Long at Current Job', 'Missing', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 59, 100.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Accommodation and food services', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Construction', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Education services', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Finance and insurance', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Health care and social assistance', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Information', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Management of Companies and Enterprises', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Manufacturing', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Mining', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Other services, except public administration', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Public administration', 59, 100.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Real estate and rental and leasing', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Retail trade', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Transportation and warehousing', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Unclassified', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Utilities', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'NAICS Sector', 'Wholesale trade', 59, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'SOC Eligibility Rate', NULL, NULL, 17.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.01', 'Total Completed Questionnaires', NULL, 59, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'Data Collection Mode', 'Paper', 20, 45.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'Data Collection Mode', 'Web', 20, 55.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'OE Completeness Rate', NULL, NULL, 90.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'OE Response Rate', NULL, NULL, 57.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2021.02', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Data Collection Mode', 'Paper', 113, 49.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Data Collection Mode', 'Web', 113, 50.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Employee Completeness Rate', NULL, NULL, 89.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Employee Response Rate', NULL, NULL, 58.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Establishment Eligibility Rate', NULL, NULL, 90.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Establishment Response Rate', NULL, NULL, 66.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'How Long at Current Job', '1-5 Years', 113, 32.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'How Long at Current Job', '10 Years or More', 113, 34.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'How Long at Current Job', '6-9 Years', 113, 15.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'How Long at Current Job', '<1 Year', 113, 15.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'How Long at Current Job', 'Missing', 113, 0.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 113, 1.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 113, 0.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 113, 8.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 113, 55.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 113, 0.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 113, 32.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Accommodation and food services', 113, 0.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 113, 1.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Construction', 113, 1.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Education services', 113, 22.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Finance and insurance', 113, 0.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Health care and social assistance', 113, 4.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Information', 113, 0.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Management of Companies and Enterprises', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Manufacturing', 113, 7.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Mining', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Other services, except public administration', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 113, 4.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Public administration', 113, 55.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Real estate and rental and leasing', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Retail trade', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Transportation and warehousing', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Unclassified', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Utilities', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'NAICS Sector', 'Wholesale trade', 113, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'SOC Eligibility Rate', NULL, NULL, 17.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2031.00', 'Total Completed Questionnaires', NULL, 113, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Data Collection Mode', 'Paper', 30, 60.0, TO_DATE('2009-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Data Collection Mode', 'Web', 30, 40.0, TO_DATE('2009-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 30, 0.0, TO_DATE('2009-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 30, 73.3, TO_DATE('2009-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 30, 6.7, TO_DATE('2009-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 30, 20.0, TO_DATE('2009-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 30, 0.0, TO_DATE('2009-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 30, 0.0, TO_DATE('2009-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 30, 0.0, TO_DATE('2009-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2009-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'OE Response Rate', NULL, NULL, 62.5, TO_DATE('2009-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2041.00', 'Total Completed Questionnaires', NULL, 30, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Data Collection Mode', 'Paper', 60, 43.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Data Collection Mode', 'Web', 60, 56.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Employee Completeness Rate', NULL, NULL, 76.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Employee Response Rate', NULL, NULL, 59.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Establishment Eligibility Rate', NULL, NULL, 81.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Establishment Response Rate', NULL, NULL, 46.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'How Long at Current Job', '1-5 Years', 60, 50.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'How Long at Current Job', '10 Years or More', 60, 28.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'How Long at Current Job', '6-9 Years', 60, 11.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'How Long at Current Job', '<1 Year', 60, 10.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'How Long at Current Job', 'Missing', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 60, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Accommodation and food services', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Construction', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Education services', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Finance and insurance', 60, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Health care and social assistance', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Information', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Management of Companies and Enterprises', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Manufacturing', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Mining', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Other services, except public administration', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Public administration', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Real estate and rental and leasing', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Retail trade', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Transportation and warehousing', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Unclassified', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Utilities', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'NAICS Sector', 'Wholesale trade', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'SOC Eligibility Rate', NULL, NULL, 13.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2051.00', 'Total Completed Questionnaires', NULL, 60, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Data Collection Mode', 'Paper', 28, 64.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Data Collection Mode', 'Web', 28, 35.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 28, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 28, 96.4, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 28, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 28, 3.6, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 28, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 28, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 28, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'OE Response Rate', NULL, NULL, 71.8, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2052.00', 'Total Completed Questionnaires', NULL, 28, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Data Collection Mode', 'Paper', 30, 33.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Data Collection Mode', 'Web', 30, 66.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 30, 93.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 30, 6.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'OE Completeness Rate', NULL, NULL, 90.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'OE Response Rate', NULL, NULL, 50.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2053.00', 'Total Completed Questionnaires', NULL, 30, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Data Collection Mode', 'Paper', 25, 40.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Data Collection Mode', 'Web', 25, 60.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 25, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 25, 92.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 25, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 25, 8.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 25, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 25, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 25, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'OE Completeness Rate', NULL, NULL, 96.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'OE Response Rate', NULL, NULL, 61.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2061.00', 'Total Completed Questionnaires', NULL, 25, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'Data Collection Mode', 'Paper', 33, 54.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'Data Collection Mode', 'Web', 33, 45.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 33, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 33, 66.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 33, 3.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 33, 30.3, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 33, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 33, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 33, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'OE Response Rate', NULL, NULL, 94.3, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.00', 'Total Completed Questionnaires', NULL, 33, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Data Collection Mode', 'Paper', 60, 48.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Data Collection Mode', 'Web', 60, 51.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Employee Completeness Rate', NULL, NULL, 89.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Employee Response Rate', NULL, NULL, 64.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Establishment Eligibility Rate', NULL, NULL, 89.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Establishment Response Rate', NULL, NULL, 67.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'How Long at Current Job', '1-5 Years', 60, 35.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'How Long at Current Job', '10 Years or More', 60, 40.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'How Long at Current Job', '6-9 Years', 60, 18.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'How Long at Current Job', '<1 Year', 60, 6.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'How Long at Current Job', 'Missing', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 60, 10.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 60, 13.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 60, 76.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Accommodation and food services', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Construction', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Education services', 60, 76.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Finance and insurance', 60, 10.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Health care and social assistance', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Information', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Management of Companies and Enterprises', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Manufacturing', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Mining', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Other services, except public administration', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Public administration', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Real estate and rental and leasing', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Retail trade', 60, 13.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Transportation and warehousing', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Unclassified', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Utilities', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'NAICS Sector', 'Wholesale trade', 60, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'SOC Eligibility Rate', NULL, NULL, 11.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2071.01', 'Total Completed Questionnaires', NULL, 60, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Data Collection Mode', 'Paper', 108, 86.1, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Data Collection Mode', 'Web', 108, 13.9, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Employee Completeness Rate', NULL, NULL, 95.6, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Employee Response Rate', NULL, NULL, 68.9, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Establishment Eligibility Rate', NULL, NULL, 50.9, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Establishment Response Rate', NULL, NULL, 63.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'How Long at Current Job', '1-5 Years', 108, 37.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'How Long at Current Job', '10 Years or More', 108, 37.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'How Long at Current Job', '6-9 Years', 108, 19.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'How Long at Current Job', '<1 Year', 108, 5.6, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'How Long at Current Job', 'Missing', 108, 0.9, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 108, 100.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Accommodation and food services', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Construction', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Education services', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Finance and insurance', 108, 100.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Health care and social assistance', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Information', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Management of Companies and Enterprises', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Manufacturing', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Mining', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Other services, except public administration', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Public administration', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Real estate and rental and leasing', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Retail trade', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Transportation and warehousing', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Unclassified', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Utilities', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'NAICS Sector', 'Wholesale trade', 108, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'SOC Eligibility Rate', NULL, NULL, 35.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2072.00', 'Total Completed Questionnaires', NULL, 108, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Data Collection Mode', 'Paper', 111, 82.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Data Collection Mode', 'Web', 111, 18.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Employee Completeness Rate', NULL, NULL, 85.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Employee Response Rate', NULL, NULL, 73.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Establishment Eligibility Rate', NULL, NULL, 81.5, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Establishment Response Rate', NULL, NULL, 74.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'How Long at Current Job', '1-5 Years', 111, 35.1, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'How Long at Current Job', '10 Years or More', 111, 44.1, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'How Long at Current Job', '6-9 Years', 111, 15.3, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'How Long at Current Job', '<1 Year', 111, 5.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'How Long at Current Job', 'Missing', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 111, 100.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Accommodation and food services', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Construction', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Education services', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Finance and insurance', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Health care and social assistance', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Information', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Management of Companies and Enterprises', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Manufacturing', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Mining', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Other services, except public administration', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Public administration', 111, 100.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Real estate and rental and leasing', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Retail trade', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Transportation and warehousing', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Unclassified', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Utilities', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'NAICS Sector', 'Wholesale trade', 111, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'SOC Eligibility Rate', NULL, NULL, 23.3, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2081.00', 'Total Completed Questionnaires', NULL, 111, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Data Collection Mode', 'Paper', 20, 50.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Data Collection Mode', 'Web', 20, 50.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 90.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 10.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'OE Completeness Rate', NULL, NULL, 90.9, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'OE Response Rate', NULL, NULL, 57.9, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2082.00', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'Data Collection Mode', 'Paper', 23, 43.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'Data Collection Mode', 'Web', 23, 56.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 95.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 4.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'OE Completeness Rate', NULL, NULL, 92.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'OE Response Rate', NULL, NULL, 69.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.01', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'Data Collection Mode', 'Paper', 21, 38.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'Data Collection Mode', 'Web', 21, 61.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 4.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 95.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'OE Response Rate', NULL, NULL, 46.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.02', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Data Collection Mode', 'Paper', 25, 52.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Data Collection Mode', 'Web', 25, 48.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 25, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Much Experience Performing Work in this Occupation', '10+ Years', 25, 96.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 25, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 25, 4.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Much Experience Performing Work in this Occupation', '<1 Year', 25, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Much Experience Performing Work in this Occupation', 'Missing', 25, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 25, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'OE Completeness Rate', NULL, NULL, 96.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'OE Response Rate', NULL, NULL, 44.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('13-2099.04', 'Total Completed Questionnaires', NULL, 25, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Data Collection Mode', 'Paper', 49, 40.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Data Collection Mode', 'Web', 49, 59.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Employee Completeness Rate', NULL, NULL, 94.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Employee Response Rate', NULL, NULL, 48.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Establishment Eligibility Rate', NULL, NULL, 71.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Establishment Response Rate', NULL, NULL, 73.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'How Long at Current Job', '1-5 Years', 49, 28.6, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'How Long at Current Job', '10 Years or More', 49, 40.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'How Long at Current Job', '6-9 Years', 49, 22.4, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'How Long at Current Job', '<1 Year', 49, 8.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'How Long at Current Job', 'Missing', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 49, 14.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 49, 2.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 49, 83.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Accommodation and food services', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Construction', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Education services', 49, 36.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Finance and insurance', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Health care and social assistance', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Information', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Management of Companies and Enterprises', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Manufacturing', 49, 14.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Mining', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Other services, except public administration', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 49, 46.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Public administration', 49, 2.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Real estate and rental and leasing', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Retail trade', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Transportation and warehousing', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Unclassified', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Utilities', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'NAICS Sector', 'Wholesale trade', 49, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'SOC Eligibility Rate', NULL, NULL, 4.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1111.00', 'Total Completed Questionnaires', NULL, 49, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Data Collection Mode', 'Paper', 101, 34.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Data Collection Mode', 'Web', 101, 65.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Employee Completeness Rate', NULL, NULL, 92.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Employee Response Rate', NULL, NULL, 56.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Establishment Eligibility Rate', NULL, NULL, 86.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Establishment Response Rate', NULL, NULL, 58.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'How Long at Current Job', '1-5 Years', 101, 28.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'How Long at Current Job', '10 Years or More', 101, 50.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'How Long at Current Job', '6-9 Years', 101, 14.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'How Long at Current Job', '<1 Year', 101, 5.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'How Long at Current Job', 'Missing', 101, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 101, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 101, 1.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 101, 7.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 101, 29.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 101, 8.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 101, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 101, 22.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 101, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 101, 27.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 101, 1.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 101, 1.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Accommodation and food services', 101, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 101, 1.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 101, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 101, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Construction', 101, 1.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Education services', 101, 11.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Finance and insurance', 101, 7.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Health care and social assistance', 101, 11.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Information', 101, 4.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Management of Companies and Enterprises', 101, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Manufacturing', 101, 29.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Mining', 101, 8.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Other services, except public administration', 101, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 101, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Public administration', 101, 22.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Real estate and rental and leasing', 101, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Retail trade', 101, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Transportation and warehousing', 101, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Unclassified', 101, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Utilities', 101, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'NAICS Sector', 'Wholesale trade', 101, 1.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'SOC Eligibility Rate', NULL, NULL, 7.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.00', 'Total Completed Questionnaires', NULL, 101, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'Data Collection Mode', 'Paper', 22, 18.2, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'Data Collection Mode', 'Web', 22, 81.8, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 77.3, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 22.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'OE Completeness Rate', NULL, NULL, 95.7, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'OE Response Rate', NULL, NULL, 46.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1121.01', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Data Collection Mode', 'Paper', 72, 27.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Data Collection Mode', 'Web', 72, 72.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Employee Completeness Rate', NULL, NULL, 85.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Employee Response Rate', NULL, NULL, 46.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Establishment Eligibility Rate', NULL, NULL, 85.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Establishment Response Rate', NULL, NULL, 57.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'How Long at Current Job', '1-5 Years', 72, 47.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'How Long at Current Job', '10 Years or More', 72, 25.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'How Long at Current Job', '6-9 Years', 72, 8.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'How Long at Current Job', '<1 Year', 72, 18.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'How Long at Current Job', 'Missing', 72, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 72, 9.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 72, 15.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 72, 19.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 72, 9.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 72, 20.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 72, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 72, 15.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 72, 8.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Accommodation and food services', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 72, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Construction', 72, 9.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Education services', 72, 11.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Finance and insurance', 72, 15.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Health care and social assistance', 72, 2.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Information', 72, 4.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Management of Companies and Enterprises', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Manufacturing', 72, 19.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Mining', 72, 9.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Other services, except public administration', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 72, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Public administration', 72, 20.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Real estate and rental and leasing', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Retail trade', 72, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Transportation and warehousing', 72, 2.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Unclassified', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Utilities', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'NAICS Sector', 'Wholesale trade', 72, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'SOC Eligibility Rate', NULL, NULL, 6.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1122.00', 'Total Completed Questionnaires', NULL, 72, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Data Collection Mode', 'Paper', 70, 27.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Data Collection Mode', 'Web', 70, 72.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Employee Completeness Rate', NULL, NULL, 82.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Employee Response Rate', NULL, NULL, 68.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Establishment Eligibility Rate', NULL, NULL, 82.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Establishment Response Rate', NULL, NULL, 52.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'How Long at Current Job', '1-5 Years', 70, 25.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'How Long at Current Job', '10 Years or More', 70, 41.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'How Long at Current Job', '6-9 Years', 70, 20.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'How Long at Current Job', '<1 Year', 70, 12.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'How Long at Current Job', 'Missing', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 70, 11.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 70, 15.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 70, 27.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 70, 44.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 70, 1.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Accommodation and food services', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Construction', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Education services', 70, 27.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Finance and insurance', 70, 5.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Health care and social assistance', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Information', 70, 4.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Management of Companies and Enterprises', 70, 5.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Manufacturing', 70, 15.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Mining', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Other services, except public administration', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 70, 14.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Public administration', 70, 27.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Real estate and rental and leasing', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Retail trade', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Transportation and warehousing', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Unclassified', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Utilities', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'NAICS Sector', 'Wholesale trade', 70, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'SOC Eligibility Rate', NULL, NULL, 12.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1131.00', 'Total Completed Questionnaires', NULL, 70, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Data Collection Mode', 'Paper', 89, 27.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Data Collection Mode', 'Web', 89, 73.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Employee Completeness Rate', NULL, NULL, 91.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Employee Response Rate', NULL, NULL, 64.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Establishment Eligibility Rate', NULL, NULL, 85.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Establishment Response Rate', NULL, NULL, 54.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'How Long at Current Job', '1-5 Years', 89, 28.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'How Long at Current Job', '10 Years or More', 89, 42.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'How Long at Current Job', '6-9 Years', 89, 15.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'How Long at Current Job', '<1 Year', 89, 12.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'How Long at Current Job', 'Missing', 89, 1.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 89, 1.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 89, 31.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 89, 7.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 89, 21.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 89, 33.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 89, 4.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Accommodation and food services', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Construction', 89, 1.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Education services', 89, 2.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Finance and insurance', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Health care and social assistance', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Information', 89, 10.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Management of Companies and Enterprises', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Manufacturing', 89, 31.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Mining', 89, 7.9, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Other services, except public administration', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 89, 25.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Public administration', 89, 21.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Real estate and rental and leasing', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Retail trade', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Transportation and warehousing', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Unclassified', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Utilities', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'NAICS Sector', 'Wholesale trade', 89, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'SOC Eligibility Rate', NULL, NULL, 7.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1132.00', 'Total Completed Questionnaires', NULL, 89, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Data Collection Mode', 'Paper', 116, 33.6, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Data Collection Mode', 'Web', 116, 66.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Employee Completeness Rate', NULL, NULL, 91.3, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Employee Response Rate', NULL, NULL, 66.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Establishment Eligibility Rate', NULL, NULL, 83.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Establishment Response Rate', NULL, NULL, 79.2, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'How Long at Current Job', '1-5 Years', 116, 34.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'How Long at Current Job', '10 Years or More', 116, 43.1, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'How Long at Current Job', '6-9 Years', 116, 18.1, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'How Long at Current Job', '<1 Year', 116, 2.6, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'How Long at Current Job', 'Missing', 116, 1.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 116, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 116, 2.6, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 116, 6.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 116, 16.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 116, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 116, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 116, 20.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 116, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 116, 52.6, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 116, 1.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 116, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Accommodation and food services', 116, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 116, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 116, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 116, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Construction', 116, 2.6, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Education services', 116, 8.6, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Finance and insurance', 116, 6.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Health care and social assistance', 116, 5.2, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Information', 116, 1.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Management of Companies and Enterprises', 116, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Manufacturing', 116, 16.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Mining', 116, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Other services, except public administration', 116, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 116, 38.8, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Public administration', 116, 20.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Real estate and rental and leasing', 116, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Retail trade', 116, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Transportation and warehousing', 116, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Unclassified', 116, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Utilities', 116, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'NAICS Sector', 'Wholesale trade', 116, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'SOC Eligibility Rate', NULL, NULL, 14.8, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1133.00', 'Total Completed Questionnaires', NULL, 116, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'Data Collection Mode', 'Paper', 24, 33.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'Data Collection Mode', 'Web', 24, 66.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 24, 4.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 24, 62.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 24, 4.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 24, 29.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 24, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'OE Completeness Rate', NULL, NULL, 92.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'OE Response Rate', NULL, NULL, 57.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1134.00', 'Total Completed Questionnaires', NULL, 24, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Data Collection Mode', 'Paper', 50, 34.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Data Collection Mode', 'Web', 50, 66.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Employee Completeness Rate', NULL, NULL, 71.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Employee Response Rate', NULL, NULL, 64.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Establishment Eligibility Rate', NULL, NULL, 85.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Establishment Response Rate', NULL, NULL, 53.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'How Long at Current Job', '1-5 Years', 50, 18.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'How Long at Current Job', '10 Years or More', 50, 52.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'How Long at Current Job', '6-9 Years', 50, 20.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'How Long at Current Job', '<1 Year', 50, 10.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'How Long at Current Job', 'Missing', 50, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 50, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 50, 4.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 50, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 50, 14.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 50, 8.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 50, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 50, 46.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 50, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 50, 26.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 50, 2.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 50, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Accommodation and food services', 50, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 50, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 50, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 50, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Construction', 50, 4.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Education services', 50, 20.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Finance and insurance', 50, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Health care and social assistance', 50, 2.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Information', 50, 2.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Management of Companies and Enterprises', 50, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Manufacturing', 50, 14.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Mining', 50, 8.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Other services, except public administration', 50, 2.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 50, 2.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Public administration', 50, 46.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Real estate and rental and leasing', 50, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Retail trade', 50, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Transportation and warehousing', 50, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Unclassified', 50, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Utilities', 50, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'NAICS Sector', 'Wholesale trade', 50, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'SOC Eligibility Rate', NULL, NULL, 6.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1141.00', 'Total Completed Questionnaires', NULL, 50, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Data Collection Mode', 'Paper', 123, 19.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Data Collection Mode', 'Web', 123, 80.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Employee Completeness Rate', NULL, NULL, 93.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Employee Response Rate', NULL, NULL, 64.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Establishment Eligibility Rate', NULL, NULL, 84.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Establishment Response Rate', NULL, NULL, 55.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'How Long at Current Job', '1-5 Years', 123, 26.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'How Long at Current Job', '10 Years or More', 123, 48.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'How Long at Current Job', '6-9 Years', 123, 16.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'How Long at Current Job', '<1 Year', 123, 8.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'How Long at Current Job', 'Missing', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 123, 8.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 123, 5.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 123, 20.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 123, 3.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 123, 22.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 123, 31.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 123, 7.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 123, 0.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Accommodation and food services', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Construction', 123, 9.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Education services', 123, 14.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Finance and insurance', 123, 4.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Health care and social assistance', 123, 5.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Information', 123, 9.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Management of Companies and Enterprises', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Manufacturing', 123, 17.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Mining', 123, 1.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Other services, except public administration', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 123, 8.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Public administration', 123, 22.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Real estate and rental and leasing', 123, 0.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Retail trade', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Transportation and warehousing', 123, 2.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Unclassified', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Utilities', 123, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'NAICS Sector', 'Wholesale trade', 123, 0.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'SOC Eligibility Rate', NULL, NULL, 15.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1142.00', 'Total Completed Questionnaires', NULL, 123, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.00', 'Data Collection Mode', 'Paper', 22, 13.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.00', 'Data Collection Mode', 'Web', 22, 86.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 4.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 68.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 9.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 18.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.00', 'OE Completeness Rate', NULL, NULL, 95.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.00', 'OE Response Rate', NULL, NULL, 39.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.00', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.01', 'Data Collection Mode', 'Paper', 23, 43.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.01', 'Data Collection Mode', 'Web', 23, 56.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 95.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 4.3, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.01', 'OE Completeness Rate', NULL, NULL, 85.2, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.01', 'OE Response Rate', NULL, NULL, 87.1, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1143.01', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Data Collection Mode', 'Paper', 116, 35.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Data Collection Mode', 'Web', 116, 64.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Employee Completeness Rate', NULL, NULL, 89.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Employee Response Rate', NULL, NULL, 54.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Establishment Eligibility Rate', NULL, NULL, 85.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Establishment Response Rate', NULL, NULL, 56.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'How Long at Current Job', '1-5 Years', 116, 38.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'How Long at Current Job', '10 Years or More', 116, 34.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'How Long at Current Job', '6-9 Years', 116, 12.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'How Long at Current Job', '<1 Year', 116, 12.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'How Long at Current Job', 'Missing', 116, 1.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 116, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 116, 5.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 116, 3.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 116, 12.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 116, 4.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 116, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 116, 37.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 116, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 116, 30.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 116, 5.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 116, 1.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Accommodation and food services', 116, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 116, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 116, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 116, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Construction', 116, 5.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Education services', 116, 16.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Finance and insurance', 116, 3.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Health care and social assistance', 116, 11.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Information', 116, 6.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Management of Companies and Enterprises', 116, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Manufacturing', 116, 11.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Mining', 116, 4.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Other services, except public administration', 116, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 116, 2.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Public administration', 116, 37.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Real estate and rental and leasing', 116, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Retail trade', 116, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Transportation and warehousing', 116, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Unclassified', 116, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Utilities', 116, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'NAICS Sector', 'Wholesale trade', 116, 1.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'SOC Eligibility Rate', NULL, NULL, 14.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1151.00', 'Total Completed Questionnaires', NULL, 116, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'Data Collection Mode', 'Paper', 118, 35.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'Data Collection Mode', 'Web', 118, 64.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'Employee Completeness Rate', NULL, NULL, 86.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'Employee Response Rate', NULL, NULL, 63.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'Establishment Eligibility Rate', NULL, NULL, 85.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'Establishment Response Rate', NULL, NULL, 62.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'How Long at Current Job', '1-5 Years', 118, 28.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'How Long at Current Job', '10 Years or More', 118, 42.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'How Long at Current Job', '6-9 Years', 118, 16.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'How Long at Current Job', '<1 Year', 118, 9.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'How Long at Current Job', 'Missing', 118, 2.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 118, 0.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 118, 2.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 118, 9.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 118, 12.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 118, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 118, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 118, 6.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 118, 2.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 118, 54.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 118, 8.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 118, 2.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Accommodation and food services', 118, 4.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 118, 4.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 118, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 118, 1.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Construction', 118, 2.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Education services', 118, 19.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Finance and insurance', 118, 5.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Health care and social assistance', 118, 1.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Information', 118, 5.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Management of Companies and Enterprises', 118, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Manufacturing', 118, 10.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Mining', 118, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Other services, except public administration', 118, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 118, 23.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Public administration', 118, 6.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Real estate and rental and leasing', 118, 3.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Retail trade', 118, 2.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Transportation and warehousing', 118, 5.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Unclassified', 118, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Utilities', 118, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'NAICS Sector', 'Wholesale trade', 118, 2.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'SOC Eligibility Rate', NULL, NULL, 24.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1152.00', 'Total Completed Questionnaires', NULL, 118, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'Data Collection Mode', 'Paper', 27, 37.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'Data Collection Mode', 'Web', 27, 63.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 27, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 27, 77.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 27, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 27, 22.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 27, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 27, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 27, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'OE Completeness Rate', NULL, NULL, 90.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'OE Response Rate', NULL, NULL, 81.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.01', 'Total Completed Questionnaires', NULL, 27, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'Data Collection Mode', 'Paper', 30, 16.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'Data Collection Mode', 'Web', 30, 83.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 30, 90.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 30, 6.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 30, 3.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 30, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'OE Completeness Rate', NULL, NULL, 85.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'OE Response Rate', NULL, NULL, 55.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.02', 'Total Completed Questionnaires', NULL, 30, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'Data Collection Mode', 'Paper', 20, 15.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'Data Collection Mode', 'Web', 20, 85.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 60.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 5.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 35.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'OE Completeness Rate', NULL, NULL, 74.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'OE Response Rate', NULL, NULL, 56.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.03', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'Data Collection Mode', 'Paper', 23, 43.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'Data Collection Mode', 'Web', 23, 56.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 82.6, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 17.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'OE Completeness Rate', NULL, NULL, 95.8, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'OE Response Rate', NULL, NULL, 75.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.04', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Data Collection Mode', 'Paper', 56, 58.9, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Data Collection Mode', 'Web', 56, 41.1, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Employee Completeness Rate', NULL, NULL, 100.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Employee Response Rate', NULL, NULL, 90.3, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Establishment Eligibility Rate', NULL, NULL, 88.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Establishment Response Rate', NULL, NULL, 88.3, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'How Long at Current Job', '1-5 Years', 56, 41.1, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'How Long at Current Job', '10 Years or More', 56, 33.9, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'How Long at Current Job', '6-9 Years', 56, 23.2, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'How Long at Current Job', '<1 Year', 56, 1.8, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'How Long at Current Job', 'Missing', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 56, 75.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 56, 25.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Accommodation and food services', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Arts, entertainment, and recreation', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Construction', 56, 3.6, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Education services', 56, 3.6, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Finance and insurance', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Health care and social assistance', 56, 1.8, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Information', 56, 1.8, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Management of Companies and Enterprises', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Manufacturing', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Mining', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Other services, except public administration', 56, 5.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Professional, Scientific and Technical Services', 56, 17.8, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Public administration', 56, 57.1, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Real estate and rental and leasing', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Retail trade', 56, 5.4, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Transportation and warehousing', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Unclassified', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Utilities', 56, 0.0, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'NAICS Sector', 'Wholesale trade', 56, 3.6, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'SOC Eligibility Rate', NULL, NULL, 13.2, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.05', 'Total Completed Questionnaires', NULL, 56, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.06', 'Data Collection Mode', 'Paper', 24, 33.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.06', 'Data Collection Mode', 'Web', 24, 66.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.06', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 24, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.06', 'How Much Experience Performing Work in this Occupation', '10+ Years', 24, 83.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.06', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 24, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.06', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 24, 16.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.06', 'How Much Experience Performing Work in this Occupation', '<1 Year', 24, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.06', 'How Much Experience Performing Work in this Occupation', 'Missing', 24, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.06', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 24, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.06', 'OE Completeness Rate', NULL, NULL, 88.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.06', 'OE Response Rate', NULL, NULL, 81.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.06', 'Total Completed Questionnaires', NULL, 24, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.07', 'Data Collection Mode', 'Paper', 23, 21.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.07', 'Data Collection Mode', 'Web', 23, 78.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.07', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 4.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.07', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 82.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.07', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.07', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 13.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.07', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.07', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.07', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.07', 'OE Completeness Rate', NULL, NULL, 79.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.07', 'OE Response Rate', NULL, NULL, 44.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.07', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.08', 'Data Collection Mode', 'Paper', 24, 29.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.08', 'Data Collection Mode', 'Web', 24, 70.8, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.08', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 24, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.08', 'How Much Experience Performing Work in this Occupation', '10+ Years', 24, 75.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.08', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 24, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.08', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 24, 25.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.08', 'How Much Experience Performing Work in this Occupation', '<1 Year', 24, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.08', 'How Much Experience Performing Work in this Occupation', 'Missing', 24, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.08', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 24, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.08', 'OE Completeness Rate', NULL, NULL, 96.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.08', 'OE Response Rate', NULL, NULL, 80.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.08', 'Total Completed Questionnaires', NULL, 24, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.09', 'Data Collection Mode', 'Paper', 21, 19.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.09', 'Data Collection Mode', 'Web', 21, 81.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.09', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.09', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 81.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.09', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.09', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 19.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.09', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.09', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.09', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.09', 'OE Completeness Rate', NULL, NULL, 87.5, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.09', 'OE Response Rate', NULL, NULL, 42.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.09', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.10', 'Data Collection Mode', 'Paper', 23, 21.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.10', 'Data Collection Mode', 'Web', 23, 78.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.10', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.10', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 73.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.10', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.10', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 26.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.10', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.10', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.10', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.10', 'OE Completeness Rate', NULL, NULL, 88.5, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.10', 'OE Response Rate', NULL, NULL, 68.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.10', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.11', 'Data Collection Mode', 'Paper', 21, 23.8, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.11', 'Data Collection Mode', 'Web', 21, 76.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.11', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 21, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.11', 'How Much Experience Performing Work in this Occupation', '10+ Years', 21, 47.6, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.11', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 21, 19.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.11', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 21, 33.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.11', 'How Much Experience Performing Work in this Occupation', '<1 Year', 21, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.11', 'How Much Experience Performing Work in this Occupation', 'Missing', 21, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.11', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 21, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.11', 'OE Completeness Rate', NULL, NULL, 84.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.11', 'OE Response Rate', NULL, NULL, 71.4, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.11', 'Total Completed Questionnaires', NULL, 21, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.12', 'Data Collection Mode', 'Paper', 25, 44.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.12', 'Data Collection Mode', 'Web', 25, 56.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.12', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.12', 'How Much Experience Performing Work in this Occupation', '10+ Years', 25, 84.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.12', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.12', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 25, 16.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.12', 'How Much Experience Performing Work in this Occupation', '<1 Year', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.12', 'How Much Experience Performing Work in this Occupation', 'Missing', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.12', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 25, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.12', 'OE Completeness Rate', NULL, NULL, 78.1, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.12', 'OE Response Rate', NULL, NULL, 84.2, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-1199.12', 'Total Completed Questionnaires', NULL, 25, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Data Collection Mode', 'Paper', 32, 31.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Data Collection Mode', 'Web', 32, 68.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 32, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 32, 84.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 32, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 32, 15.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 32, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 32, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 32, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'OE Completeness Rate', NULL, NULL, 97.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'OE Response Rate', NULL, NULL, 91.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2011.00', 'Total Completed Questionnaires', NULL, 32, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Data Collection Mode', 'Paper', 24, 29.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Data Collection Mode', 'Web', 24, 70.8, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 24, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 24, 95.8, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 24, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 24, 4.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 24, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 24, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 24, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'OE Completeness Rate', NULL, NULL, 92.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'OE Response Rate', NULL, NULL, 68.4, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2021.00', 'Total Completed Questionnaires', NULL, 24, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Data Collection Mode', 'Paper', 20, 45.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Data Collection Mode', 'Web', 20, 55.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 100.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'OE Completeness Rate', NULL, NULL, 90.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'OE Response Rate', NULL, NULL, 73.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2031.00', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Data Collection Mode', 'Paper', 20, 40.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Data Collection Mode', 'Web', 20, 60.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 90.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 10.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'OE Completeness Rate', NULL, NULL, 90.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'OE Response Rate', NULL, NULL, 62.9, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.00', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Data Collection Mode', 'Paper', 25, 36.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Data Collection Mode', 'Web', 25, 64.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 25, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 25, 92.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 25, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 25, 8.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 25, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 25, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 25, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'OE Completeness Rate', NULL, NULL, 89.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'OE Response Rate', NULL, NULL, 80.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.01', 'Total Completed Questionnaires', NULL, 25, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'Data Collection Mode', 'Paper', 20, 20.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'Data Collection Mode', 'Web', 20, 80.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 75.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 25.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'OE Response Rate', NULL, NULL, 62.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('15-2041.02', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Data Collection Mode', 'Paper', 27, 25.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Data Collection Mode', 'Web', 27, 74.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 27, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 27, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 27, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 27, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 27, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 27, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 27, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'OE Completeness Rate', NULL, NULL, 96.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'OE Response Rate', NULL, NULL, 71.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1011.00', 'Total Completed Questionnaires', NULL, 27, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Data Collection Mode', 'Paper', 28, 42.9, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Data Collection Mode', 'Web', 28, 57.1, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 28, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 28, 92.8, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 28, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 28, 3.6, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 28, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 28, 3.6, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 28, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'OE Response Rate', NULL, NULL, 71.8, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1012.00', 'Total Completed Questionnaires', NULL, 28, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Data Collection Mode', 'Paper', 60, 51.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Data Collection Mode', 'Web', 60, 48.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Employee Completeness Rate', NULL, NULL, 89.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Employee Response Rate', NULL, NULL, 70.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Establishment Eligibility Rate', NULL, NULL, 84.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Establishment Response Rate', NULL, NULL, 78.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'How Long at Current Job', '1-5 Years', 60, 10.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'How Long at Current Job', '10 Years or More', 60, 66.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'How Long at Current Job', '6-9 Years', 60, 20.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'How Long at Current Job', '<1 Year', 60, 3.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'How Long at Current Job', 'Missing', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 60, 46.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 60, 51.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 60, 1.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Accommodation and food services', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Construction', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Education services', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Finance and insurance', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Health care and social assistance', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Information', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Management of Companies and Enterprises', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Manufacturing', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Mining', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Other services, except public administration', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 60, 51.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Public administration', 60, 46.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Real estate and rental and leasing', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Retail trade', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Transportation and warehousing', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Unclassified', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Utilities', 60, 1.7, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'NAICS Sector', 'Wholesale trade', 60, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'SOC Eligibility Rate', NULL, NULL, 16.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1021.00', 'Total Completed Questionnaires', NULL, 60, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Data Collection Mode', 'Paper', 31, 54.8, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Data Collection Mode', 'Web', 31, 45.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 31, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 31, 100.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 31, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 31, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 31, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 31, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 31, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'OE Completeness Rate', NULL, NULL, 100.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'OE Response Rate', NULL, NULL, 79.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.00', 'Total Completed Questionnaires', NULL, 31, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Data Collection Mode', 'Paper', 20, 40.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Data Collection Mode', 'Web', 20, 60.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 85.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 15.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'OE Completeness Rate', NULL, NULL, 95.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'OE Response Rate', NULL, NULL, 75.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-1022.01', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Data Collection Mode', 'Paper', 72, 36.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Data Collection Mode', 'Web', 72, 63.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Employee Completeness Rate', NULL, NULL, 92.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Employee Response Rate', NULL, NULL, 67.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Establishment Eligibility Rate', NULL, NULL, 81.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Establishment Response Rate', NULL, NULL, 68.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'How Long at Current Job', '1-5 Years', 72, 37.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'How Long at Current Job', '10 Years or More', 72, 40.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'How Long at Current Job', '6-9 Years', 72, 11.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'How Long at Current Job', '<1 Year', 72, 9.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'How Long at Current Job', 'Missing', 72, 1.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 72, 80.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 72, 19.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Accommodation and food services', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Construction', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Education services', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Finance and insurance', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Health care and social assistance', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Information', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Management of Companies and Enterprises', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Manufacturing', 72, 80.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Mining', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Other services, except public administration', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 72, 19.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Public administration', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Real estate and rental and leasing', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Retail trade', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Transportation and warehousing', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Unclassified', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Utilities', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'NAICS Sector', 'Wholesale trade', 72, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'SOC Eligibility Rate', NULL, NULL, 11.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2011.00', 'Total Completed Questionnaires', NULL, 72, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Data Collection Mode', 'Paper', 26, 65.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Data Collection Mode', 'Web', 26, 34.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 26, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 26, 92.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 26, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 26, 7.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 26, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 26, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 26, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'OE Completeness Rate', NULL, NULL, 92.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'OE Response Rate', NULL, NULL, 87.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2021.00', 'Total Completed Questionnaires', NULL, 26, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Data Collection Mode', 'Paper', 30, 46.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Data Collection Mode', 'Web', 30, 53.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 30, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 30, 90.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 30, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 30, 10.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 30, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 30, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 30, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'OE Completeness Rate', NULL, NULL, 88.2, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'OE Response Rate', NULL, NULL, 60.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2031.00', 'Total Completed Questionnaires', NULL, 30, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Data Collection Mode', 'Paper', 22, 13.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Data Collection Mode', 'Web', 22, 86.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 4.5, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 86.4, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 9.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'OE Completeness Rate', NULL, NULL, 95.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'OE Response Rate', NULL, NULL, 69.7, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2041.00', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Data Collection Mode', 'Paper', 23, 82.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Data Collection Mode', 'Web', 23, 17.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 100.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'OE Completeness Rate', NULL, NULL, 79.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'OE Response Rate', NULL, NULL, 80.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.00', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Data Collection Mode', 'Paper', 22, 40.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Data Collection Mode', 'Web', 22, 59.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 90.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 9.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'OE Completeness Rate', NULL, NULL, 78.6, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'OE Response Rate', NULL, NULL, 58.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2051.01', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Data Collection Mode', 'Paper', 22, 22.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Data Collection Mode', 'Web', 22, 77.3, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 22, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 22, 81.8, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 22, 4.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 22, 9.1, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 22, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 22, 4.5, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 22, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'OE Completeness Rate', NULL, NULL, 95.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'OE Response Rate', NULL, NULL, 54.8, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2061.00', 'Total Completed Questionnaires', NULL, 22, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Data Collection Mode', 'Paper', 149, 52.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Data Collection Mode', 'Web', 149, 47.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Employee Completeness Rate', NULL, NULL, 91.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Employee Response Rate', NULL, NULL, 69.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Establishment Eligibility Rate', NULL, NULL, 85.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Establishment Response Rate', NULL, NULL, 56.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'How Long at Current Job', '1-5 Years', 149, 36.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'How Long at Current Job', '10 Years or More', 149, 44.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'How Long at Current Job', '6-9 Years', 149, 10.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'How Long at Current Job', '<1 Year', 149, 7.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'How Long at Current Job', 'Missing', 149, 0.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 149, 77.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 149, 15.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 149, 4.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 149, 3.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Accommodation and food services', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Construction', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Education services', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Finance and insurance', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Health care and social assistance', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Information', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Management of Companies and Enterprises', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Manufacturing', 149, 77.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Mining', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Other services, except public administration', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 149, 15.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Public administration', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Real estate and rental and leasing', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Retail trade', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Transportation and warehousing', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Unclassified', 149, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Utilities', 149, 4.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'NAICS Sector', 'Wholesale trade', 149, 3.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'SOC Eligibility Rate', NULL, NULL, 30.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2071.00', 'Total Completed Questionnaires', NULL, 149, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Data Collection Mode', 'Paper', 91, 51.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Data Collection Mode', 'Web', 91, 48.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Employee Completeness Rate', NULL, NULL, 94.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Employee Response Rate', NULL, NULL, 73.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Establishment Eligibility Rate', NULL, NULL, 75.8, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Establishment Response Rate', NULL, NULL, 65.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'How Long at Current Job', '1-5 Years', 91, 31.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'How Long at Current Job', '10 Years or More', 91, 48.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'How Long at Current Job', '6-9 Years', 91, 12.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'How Long at Current Job', '<1 Year', 91, 7.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'How Long at Current Job', 'Missing', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 91, 87.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 91, 12.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Accommodation and food services', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Construction', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Education services', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Finance and insurance', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Health care and social assistance', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Information', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Management of Companies and Enterprises', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Manufacturing', 91, 87.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Mining', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Other services, except public administration', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 91, 12.1, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Public administration', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Real estate and rental and leasing', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Retail trade', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Transportation and warehousing', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Unclassified', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Utilities', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'NAICS Sector', 'Wholesale trade', 91, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'SOC Eligibility Rate', NULL, NULL, 20.9, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.00', 'Total Completed Questionnaires', NULL, 91, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Data Collection Mode', 'Paper', 75, 36.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Data Collection Mode', 'Web', 75, 64.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Employee Completeness Rate', NULL, NULL, 90.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Employee Response Rate', NULL, NULL, 60.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Establishment Eligibility Rate', NULL, NULL, 80.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Establishment Response Rate', NULL, NULL, 79.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'How Long at Current Job', '1-5 Years', 75, 34.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'How Long at Current Job', '10 Years or More', 75, 33.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'How Long at Current Job', '6-9 Years', 75, 24.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'How Long at Current Job', '<1 Year', 75, 6.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'How Long at Current Job', 'Missing', 75, 1.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 75, 29.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 75, 62.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 75, 2.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 75, 5.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Accommodation and food services', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 75, 2.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Arts, entertainment, and recreation', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Construction', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Education services', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Finance and insurance', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Health care and social assistance', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Information', 75, 10.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Management of Companies and Enterprises', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Manufacturing', 75, 29.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Mining', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Other services, except public administration', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Professional, Scientific and Technical Services', 75, 52.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Public administration', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Real estate and rental and leasing', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Retail trade', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Transportation and warehousing', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Unclassified', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Utilities', 75, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'NAICS Sector', 'Wholesale trade', 75, 5.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'SOC Eligibility Rate', NULL, NULL, 5.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2072.01', 'Total Completed Questionnaires', NULL, 75, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Data Collection Mode', 'Paper', 27, 59.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Data Collection Mode', 'Web', 27, 40.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 27, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 27, 100.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 27, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 27, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 27, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 27, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 27, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'OE Completeness Rate', NULL, NULL, 93.1, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'OE Response Rate', NULL, NULL, 93.6, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.00', 'Total Completed Questionnaires', NULL, 27, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.01', 'Data Collection Mode', 'Paper', 29, 44.8, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.01', 'Data Collection Mode', 'Web', 29, 55.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 29, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 29, 93.1, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 29, 3.4, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 29, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 29, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 29, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 29, 3.4, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.01', 'OE Completeness Rate', NULL, NULL, 96.7, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.01', 'OE Response Rate', NULL, NULL, 81.1, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2081.01', 'Total Completed Questionnaires', NULL, 29, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'Data Collection Mode', 'Paper', 31, 29.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'Data Collection Mode', 'Web', 31, 71.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 31, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 31, 77.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 31, 6.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 31, 16.1, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 31, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 31, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 31, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'OE Completeness Rate', NULL, NULL, 96.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'OE Response Rate', NULL, NULL, 59.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.01', 'Total Completed Questionnaires', NULL, 31, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Data Collection Mode', 'Paper', 29, 41.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Data Collection Mode', 'Web', 29, 58.6, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 29, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 29, 89.6, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 29, 3.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 29, 3.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 29, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 29, 3.4, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 29, 0.0, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'OE Completeness Rate', NULL, NULL, 96.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'OE Response Rate', NULL, NULL, 85.7, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.02', 'Total Completed Questionnaires', NULL, 29, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'Data Collection Mode', 'Paper', 23, 56.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'Data Collection Mode', 'Web', 23, 43.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 78.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 4.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 17.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'OE Completeness Rate', NULL, NULL, 92.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'OE Response Rate', NULL, NULL, 64.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2111.03', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Data Collection Mode', 'Paper', 98, 69.4, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Data Collection Mode', 'Web', 98, 30.6, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Employee Completeness Rate', NULL, NULL, 93.3, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Employee Response Rate', NULL, NULL, 79.5, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Establishment Eligibility Rate', NULL, NULL, 83.3, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Establishment Response Rate', NULL, NULL, 84.5, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'How Long at Current Job', '1-5 Years', 98, 29.6, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'How Long at Current Job', '10 Years or More', 98, 48.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'How Long at Current Job', '6-9 Years', 98, 17.3, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'How Long at Current Job', '<1 Year', 98, 5.1, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'How Long at Current Job', 'Missing', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 98, 91.8, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 98, 8.2, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Accommodation and food services', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Construction', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Education services', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Finance and insurance', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Health care and social assistance', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Information', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Management of Companies and Enterprises', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Manufacturing', 98, 91.8, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Mining', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Other services, except public administration', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 98, 8.2, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Public administration', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Real estate and rental and leasing', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Retail trade', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Transportation and warehousing', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Unclassified', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Utilities', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'NAICS Sector', 'Wholesale trade', 98, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'SOC Eligibility Rate', NULL, NULL, 12.6, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.00', 'Total Completed Questionnaires', NULL, 98, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'Data Collection Mode', 'Paper', 24, 37.5, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'Data Collection Mode', 'Web', 24, 62.5, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 24, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 24, 95.8, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 24, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 24, 4.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 24, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 24, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 24, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'OE Completeness Rate', NULL, NULL, 92.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'OE Response Rate', NULL, NULL, 78.8, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2112.01', 'Total Completed Questionnaires', NULL, 24, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'Data Collection Mode', 'Paper', 23, 43.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'Data Collection Mode', 'Web', 23, 56.5, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 95.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 4.3, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'OE Completeness Rate', NULL, NULL, 82.1, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'OE Response Rate', NULL, NULL, 73.7, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.01', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Data Collection Mode', 'Paper', 77, 58.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Data Collection Mode', 'Web', 77, 41.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Employee Completeness Rate', NULL, NULL, 83.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Employee Response Rate', NULL, NULL, 70.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Establishment Eligibility Rate', NULL, NULL, 82.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Establishment Response Rate', NULL, NULL, 85.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'How Long at Current Job', '1-5 Years', 77, 23.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'How Long at Current Job', '10 Years or More', 77, 51.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'How Long at Current Job', '6-9 Years', 77, 11.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'How Long at Current Job', '<1 Year', 77, 13.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'How Long at Current Job', 'Missing', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 77, 61.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 77, 39.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Accommodation and food services', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Arts, entertainment, and recreation', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Construction', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Education services', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Finance and insurance', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Health care and social assistance', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Information', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Management of Companies and Enterprises', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Manufacturing', 77, 57.1, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Mining', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Other services, except public administration', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Professional, Scientific and Technical Services', 77, 41.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Public administration', 77, 1.3, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Real estate and rental and leasing', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Retail trade', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Transportation and warehousing', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Unclassified', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Utilities', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'NAICS Sector', 'Wholesale trade', 77, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'SOC Eligibility Rate', NULL, NULL, 8.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2121.02', 'Total Completed Questionnaires', NULL, 77, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Data Collection Mode', 'Paper', 39, 53.8, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Data Collection Mode', 'Web', 39, 46.2, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 39, 2.6, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 39, 92.3, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 39, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 39, 2.6, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 39, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 39, 2.6, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 39, 0.0, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'OE Completeness Rate', NULL, NULL, 92.9, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'OE Response Rate', NULL, NULL, 82.4, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2131.00', 'Total Completed Questionnaires', NULL, 39, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Data Collection Mode', 'Paper', 108, 56.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Data Collection Mode', 'Web', 108, 43.5, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Employee Completeness Rate', NULL, NULL, 94.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Employee Response Rate', NULL, NULL, 58.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Establishment Eligibility Rate', NULL, NULL, 86.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Establishment Response Rate', NULL, NULL, 60.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'How Long at Current Job', '1-5 Years', 108, 29.6, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'How Long at Current Job', '10 Years or More', 108, 45.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'How Long at Current Job', '6-9 Years', 108, 19.4, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'How Long at Current Job', '<1 Year', 108, 3.7, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'How Long at Current Job', 'Missing', 108, 1.9, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 108, 89.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 108, 10.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Accommodation and food services', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Construction', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Education services', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Finance and insurance', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Health care and social assistance', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Information', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Management of Companies and Enterprises', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Manufacturing', 108, 89.8, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Mining', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Other services, except public administration', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 108, 10.2, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Public administration', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Real estate and rental and leasing', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Retail trade', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Transportation and warehousing', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Unclassified', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Utilities', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'NAICS Sector', 'Wholesale trade', 108, 0.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'SOC Eligibility Rate', NULL, NULL, 26.0, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.00', 'Total Completed Questionnaires', NULL, 108, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'Data Collection Mode', 'Paper', 24, 41.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'Data Collection Mode', 'Web', 24, 58.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 24, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 24, 54.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 24, 4.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 24, 41.7, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 24, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 24, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 24, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'OE Completeness Rate', NULL, NULL, 92.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'OE Response Rate', NULL, NULL, 74.3, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.01', 'Total Completed Questionnaires', NULL, 24, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'Data Collection Mode', 'Paper', 23, 17.4, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'Data Collection Mode', 'Web', 23, 82.6, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 23, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 23, 87.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 23, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 23, 13.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 23, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 23, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 23, 0.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'OE Completeness Rate', NULL, NULL, 92.0, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'OE Response Rate', NULL, NULL, 86.2, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2141.02', 'Total Completed Questionnaires', NULL, 23, NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Data Collection Mode', 'Paper', 67, 61.2, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Data Collection Mode', 'Web', 67, 38.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Employee Completeness Rate', NULL, NULL, 91.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Employee Response Rate', NULL, NULL, 71.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Establishment Eligibility Rate', NULL, NULL, 77.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Establishment Response Rate', NULL, NULL, 62.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'How Long at Current Job', '1-5 Years', 67, 43.3, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'How Long at Current Job', '10 Years or More', 67, 32.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'How Long at Current Job', '6-9 Years', 67, 20.9, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'How Long at Current Job', '<1 Year', 67, 3.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'How Long at Current Job', 'Missing', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 67, 74.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 67, 25.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Accommodation and food services', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Construction', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Education services', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Finance and insurance', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Health care and social assistance', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Information', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Management of Companies and Enterprises', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Manufacturing', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Mining', 67, 74.6, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Other services, except public administration', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 67, 25.4, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Public administration', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Real estate and rental and leasing', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Retail trade', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Transportation and warehousing', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Unclassified', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Utilities', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'NAICS Sector', 'Wholesale trade', 67, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'SOC Eligibility Rate', NULL, NULL, 14.8, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2151.00', 'Total Completed Questionnaires', NULL, 67, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Data Collection Mode', 'Paper', 27, 37.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Data Collection Mode', 'Web', 27, 63.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 27, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Much Experience Performing Work in this Occupation', '10+ Years', 27, 88.9, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 27, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 27, 11.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Much Experience Performing Work in this Occupation', '<1 Year', 27, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Much Experience Performing Work in this Occupation', 'Missing', 27, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 27, 0.0, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'OE Completeness Rate', NULL, NULL, 93.1, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'OE Response Rate', NULL, NULL, 85.3, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2161.00', 'Total Completed Questionnaires', NULL, 27, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Data Collection Mode', 'Paper', 105, 66.7, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Data Collection Mode', 'Web', 105, 33.3, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Employee Completeness Rate', NULL, NULL, 94.6, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Employee Response Rate', NULL, NULL, 81.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Establishment Eligibility Rate', NULL, NULL, 83.5, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Establishment Response Rate', NULL, NULL, 81.3, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'How Long at Current Job', '1-5 Years', 105, 35.2, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'How Long at Current Job', '10 Years or More', 105, 50.5, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'How Long at Current Job', '6-9 Years', 105, 9.5, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'How Long at Current Job', '<1 Year', 105, 4.8, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'How Long at Current Job', 'Missing', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Agriculture, Forestry, Fishing (01-09)', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Construction (15-17)', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Financial, Insurance and Real Estate (60-67)', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Manufacturing (20-39)', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Mining (10-14)', 105, 75.2, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Non-Classifiable (99)', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Public Administration (90-97)', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Retail Trade (52-59)', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Services (70-89)', 105, 24.8, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Transportation, Communication, Electric, Gas, and Sanitary Services (40-49)', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Industry Division (Major Group Codes (SIC) within Division in parentheses)', 'Wholesale Trade (50-51)', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Accommodation and food services', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Administrative and support and waste management and remediation services', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Agriculture, forestry, fishing and hunting', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Arts, entertainment, and recreation', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Construction', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Education services', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Finance and insurance', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Health care and social assistance', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Information', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Management of Companies and Enterprises', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Manufacturing', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Mining', 105, 75.2, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Other services, except public administration', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Professional, Scientific and Technical Services', 105, 24.8, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Public administration', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Real estate and rental and leasing', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Retail trade', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Transportation and warehousing', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Unclassified', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Utilities', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'NAICS Sector', 'Wholesale trade', 105, 0.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'SOC Eligibility Rate', NULL, NULL, 12.0, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2171.00', 'Total Completed Questionnaires', NULL, 105, NULL, TO_DATE('2010-06-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'Data Collection Mode', 'Paper', 25, 56.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'Data Collection Mode', 'Web', 25, 44.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 25, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'How Much Experience Performing Work in this Occupation', '10+ Years', 25, 80.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 25, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 25, 20.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'How Much Experience Performing Work in this Occupation', '<1 Year', 25, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'How Much Experience Performing Work in this Occupation', 'Missing', 25, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 25, 0.0, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'OE Completeness Rate', NULL, NULL, 86.2, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'OE Response Rate', NULL, NULL, 78.4, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.01', 'Total Completed Questionnaires', NULL, 25, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'Data Collection Mode', 'Paper', 20, 25.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'Data Collection Mode', 'Web', 20, 75.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'How Much Experience Performing Work in this Occupation', '1-2 Years', 20, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'How Much Experience Performing Work in this Occupation', '10+ Years', 20, 95.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'How Much Experience Performing Work in this Occupation', '3-4 Years', 20, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'How Much Experience Performing Work in this Occupation', '5-9 Years', 20, 5.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'How Much Experience Performing Work in this Occupation', '<1 Year', 20, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'How Much Experience Performing Work in this Occupation', 'Missing', 20, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'How Much Experience Performing Work in this Occupation', 'Never performed work in the occupation', 20, 0.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'OE Completeness Rate', NULL, NULL, 80.0, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'OE Response Rate', NULL, NULL, 73.5, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metadata (onetsoc_code, item, response, n, percent, date_updated) VALUES ('17-2199.02', 'Total Completed Questionnaires', NULL, 20, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'));
INSERT INTO occupation_level_metada