CREATE TABLE technology_skills (
  onetsoc_code CHARACTER(10) NOT NULL,
  example CHARACTER VARYING(150) NOT NULL,
  commodity_code DECIMAL(8,0) NOT NULL,
  hot_technology CHARACTER(1) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (commodity_code) REFERENCES unspsc_reference(commodity_code));

INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'AdSense Tracker', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Atlassian JIRA', 43232201, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'ComputerEase Construction Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Database reporting software', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Databox', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Exact Software Macola ES Labor Performance', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Graphic presentation software', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Halogen e360', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Halogen ePraisal', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'HCSS HeavyBid', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'HCSS HeavyJob', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Human resource information system HRIS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Infor SSA Human Capital Management', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Listserv software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Lyris HQ Web-Analytics Solution', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Microsoft Dynamics AX', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Microsoft FRx', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Nedstat Sitestat', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Norchard Solutions Succession Wizard', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Online advertising reporting software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Oracle E-Business Suite', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Oracle Siebel Server Sync', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Relational database management software', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.03', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Teleconferencing software', 43233502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'ActionWare', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'AMG Teleran SalesInSync', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Apple Final Cut Pro', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Apple macOS', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Atlassian JIRA', 43232201, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Avidian Technologies Prophet', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Blackboard', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'CA Erwin Data Modeler', 43232310, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Calendar and scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Citrix', 43232901, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'CNC Mastercam', 43232612, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Computer aided manufacturing CAM software', 43232612, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Confluence', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Customer information control system CICS', 43232313, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Datawatch Monarch', 43232307, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Deacom ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Delphi Technology', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Dynamic Energy Systems MedAct', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Geographic information system GIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Google AdWords', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Google Analytics', 43232307, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Google Docs', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'HEAT Software GoldMine', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Human resources software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'IBM Domino', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'IBM InfoSphere DataStage', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'InnQuest Software roomMaster', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Inventory management software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Job control language JCL', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Kronos Workforce Payroll', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Kronos Workforce Timekeeper', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'LinkedIn', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'LSA Visual Easy Lean', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Marketo Marketing Automation', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Maximizer Software Maximizer Enterprise', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'McAfee', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Microsoft Exchange Server', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Microsoft FrontPage', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Mozilla Firefox', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Mozilla Thunderbird', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Nagios', 43232801, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'NetSuite NetCRM', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Oracle Eloqua', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Oracle Solaris', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Oracle Taleo', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Payroll software', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Personnel scheduling software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Point of sale POS software', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'PostgreSQL', 43232311, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Puppet', 43232401, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Realization Streamliner', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Sage ACT!', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Sage MAS 500', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Salesforce software', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Salesforce.com Salesforce CRM', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Savant MobileRanger', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'SeaMonkey', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Shell script', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Siemens NX for Manufacturing', 43232612, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Software on Sailboats Desktop Sales Manager', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Splunk Enterprise', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Sugar CRM', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Supervisory control and data acquisition SCADA software', 43232608, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Symantec', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Teradata Database', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Vanguard Software Vanguard Sales Manager', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Veritas NetBackup', 43233415, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'vtiger CRM', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Yardi', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1021.00', 'YouTube', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Adobe Systems Adobe FrameMaker', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Antenna House', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Apple iWork Keynote', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Apple Numbers for Mac', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Apple Pages for Mac', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Cisco AnyConnect', 43232901, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Cisco Systems WebEx', 43233502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Citrix GoToMeeting', 43233502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Corel WordPerfect Office Suite', 43231513, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'GoodReader', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'iAnnotate', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'IBM Domino', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Legislative Automative Workflow System LAWS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Mapping software', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Meeting scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Microsoft Exchange Server', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Penultimate', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'PTC Arbortext Editor', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Rocket/Folio NXT', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Windows Media Player', 43232005, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-1031.00', 'XMetaL Author', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Actuate BIRT', 43232314, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Adobe Systems Adobe AfterEffects', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Adobe Systems Adobe Creative Suite', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Adobe Systems Adobe Flash Player', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Adobe Systems Adobe PageMaker', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Adobe Systems Adobe Premiere Pro', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'AdRelevance', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Apple Final Cut Pro', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Apple iMovie', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Avid Media Composer', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Brainworks', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Business analysis software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Constant Contact', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Customer relationship management CRM software', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Data visualization software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Data warehousing software', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Experience in Software Webplanner', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Google AdWords', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Google Analytics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Google DoubleClick', 43232314, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'IBM Lotus Notes', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'JavaScript', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'LinkedIn', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'MarketSharp', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Microsoft Dynamics Marketing', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'PaloAlto Advertising Plan Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Quark', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Relex Weibull', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Salesforce software', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Structure query language SQL', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Webtrends software', 43231514, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.00', 'YouTube', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Adobe Systems Adobe Creative Suite', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Adobe Systems Adobe Experience Manager (AEM)', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Adobe Systems Adobe Reader', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Computer aided software engineering CASE tools', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Customer relationship management CRM software', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Drupal', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Google AdWords', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Google Analytics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Hootsuite', 43232403, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'HubSpot software', 43231514, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Inventory tracking software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'JavaScript', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'LinkedIn', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'MailChimp', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Marketo Marketing Automation', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Microsoft SQL Server', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Oracle Eloqua', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Pinterest', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Salesforce software', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Social media software', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Software development tools', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Structure query language SQL', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Twitter', 43233504, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Vimeo', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'WebTrends Analytics', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Webtrends software', 43231514, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'WordPress', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2011.01', 'YouTube', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Adobe Systems Adobe ActionScript', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Adobe Systems Adobe AfterEffects', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Adobe Systems Adobe Creative Cloud', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Adobe Systems Adobe Fireworks', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Adobe Systems Adobe Flash', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Adobe Systems Adobe Reader', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'AdSense Tracker', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'AEC Software FastTrack', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Apache Cassandra', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Apache Hive', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Apache Pig', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Apache Solr', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Apple Final Cut Pro', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Apple macOS', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Armand Morin MultiTrack Generator', 43232313, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Atlassian JIRA', 43232201, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'AWS Redshift', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Cascading Style Sheets CSS', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Citrix', 43232901, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'ClearEDGE', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Confluence', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Constant Contact', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Database reporting software', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Databox', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Delphi Technology', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Drupal', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Dynamic hypertext markup language DHTML', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Elasticsearch', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Extensible HyperText Markup Language XHTML', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Google AdWords', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Google Analytics', 43232307, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Google Docs', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'IBM Domino', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'IBM InfoSphere DataStage', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'JavaScript', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'LAMP Stack', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'LinkedIn', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Lyris HQ Web-Analytics Solution', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Marketo Marketing Automation', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'MarketSharp', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'McAfee', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Microsoft Visual Basic Scripting Edition VBScript', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'MySQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Nedstat Sitestat', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'NoSQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Online advertising reporting software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Oracle Beehive', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Oracle Eloqua', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Oracle JavaServer Pages JSP', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Oracle PL/SQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Oracle Siebel Server Sync', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'QAD Marketing Automation', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Ruby', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Ruby on Rails', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Sage SalesLogix', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Salesforce software', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Salesforce.com Salesforce CRM', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Splunk Enterprise', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Swift', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Symantec', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Teradata Database', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Yardi', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2021.00', 'YouTube', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Adobe Systems Adobe ActionScript', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Adobe Systems Adobe Creative Cloud', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Adobe Systems Adobe Flash', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Avidian Technologies Prophet', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Bentley MicroStation', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Contact management software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Delphi Discovery', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Delphi Technology', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Eclipse IDE', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Eden Sales Manager', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Google AdWords', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Google Analytics', 43232307, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Google Docs', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'HEAT Software GoldMine', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Inventory software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'LinkedIn', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Marketo Marketing Automation', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Maximizer Software Maximizer Enterprise', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'McAfee', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Microsoft Azure', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Microsoft Exchange Server', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'NetSuite NetCRM', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Oracle Eloqua', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Oracle Taleo', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Sage ACT!', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Salesforce software', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Salesforce.com Salesforce CRM', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Software on Sailboats Desktop Sales Manager', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Symantec', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Teradata Database', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Vanguard Software Vanguard Sales Manager', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Workforce management software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Yardi', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2022.00', 'YouTube', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Adobe Systems Adobe AfterEffects', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Adobe Systems Adobe Creative Cloud', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Adobe Systems Adobe Distiller', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Adobe Systems Adobe Fireworks', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Adobe Systems Adobe Flash', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Adobe Systems Adobe Flash Player', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Adobe Systems Adobe PageMaker', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Apple Final Cut Pro', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Apple iDVD', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Apple iMovie', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Blackbaud eTapestry', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Corel WordPerfect Office Suite', 43231513, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Drupal', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Google AdWords', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Google Analytics', 43232307, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Google Docs', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Google Gmail', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Instagram PeopleMap', 43231514, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'LinkedIn', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Marketo Marketing Automation', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Novell GroupWise', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Oracle Eloqua', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Oracle Siebel Server Sync', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'QuarkXPress', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Salesforce software', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Slack', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'YouTube', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-2031.00', 'zkipster', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Adobe Systems Adobe PageMaker', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'ADP Enterprise HRMS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Atlassian JIRA', 43232201, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Delphi Technology', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'LinkedIn', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Medical procedure coding software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Microsoft Windows XP', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Novell GroupWise', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'PracticeWorks Systems Kodak WINOMS CS', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Sage 300 Construction and Real Estate', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Sage MAS 200 ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Supervisory control and data acquisition SCADA software', 43232608, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Teradata Database', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Yardi', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'ACT! Premium', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Adobe Systems Adobe Distiller', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Adobe Systems Adobe Flash', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Adobe Systems Adobe Flex', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Advanced business application programming ABAP', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Alpha Four', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Apache Cassandra', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Apache HTTP Server', 43232312, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Apache Maven', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Apache Pig', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Apache Solr', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Apache Tomcat', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Apple Final Cut Pro', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Apple iMovie', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Apple iWork Keynote', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Apple iWork Numbers', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Apple iWork Pages', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Apple macOS', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Assembler', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Atlassian JIRA', 43232201, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Backbone.js', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Billing software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Blackboard', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Borland Paradox', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'C', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'C#', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'C++', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'CA Erwin Data Modeler', 43232310, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Cisco Systems WAN Manager', 43232909, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Citrix', 43232901, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Common business oriented language COBOL', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Corel Office Suite', 43231513, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Customer information control system CICS', 43232313, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Dartware InterMapper', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Drupal', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Dynamic hypertext markup language DHTML', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Eclipse IDE', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Embarcadero Delphi', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Enterprise JavaBeans', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Extensible HyperText Markup Language XHTML', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'File transfer protocol FTP software', 43233001, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Firewall software', 43233204, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Google Analytics', 43232307, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Help desk software', 43231501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Hewlett Packard HP-UX', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'IBM Domino', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'IBM InfoSphere DataStage', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'IBM iSeries Access', 43232915, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'IBM WebSphere', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Infor ERP Baan', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Integrated development environment IDE software', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'JavaScript', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'K2 Business Process Automation', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'KornShell', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'LAMP Stack', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'LAN software', 43232905, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Langlais Computer Consultants CalMan', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Linux-based email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Mac HelpMate', 43232901, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'McAfee', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft .NET Framework', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Active Server Pages ASP', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Azure', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Business Contact Manager', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Dynamics AX', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Dynamics CRM', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Dynamics NAV', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Entourage', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Exchange Server', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Front Page', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Office SharePoint Server MOSS', 43233503, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft SQL Server Reporting Services SSRS', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Visual Basic Scripting Edition VBScript', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Visual FoxPro', 43232311, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Visual Studio', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Windows Server', 43232701, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Mobile wireless network infrastructure software', 43232910, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'MongoDB', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'MySQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Nagios', 43232801, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Netscape Navigator', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Node.js', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'NoSQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Objective C', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Oracle DBMS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Oracle E-Business Suite', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Oracle Eloqua', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Oracle iPlanet Web Server', 43232312, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Oracle Java', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Oracle PL/SQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Oracle Primavera Systems', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Oracle Siebel Server Sync', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Oracle Solaris', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Oracle WebLogic Server', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Pegasus software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Perforce Helix software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Performance Solutions Technology ManagePro', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Pilgrim Quality Solutions SmartSolve', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'PostgreSQL', 43232311, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Practical extraction and reporting language Perl', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Progress OpenEdge ABL', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Progress OpenEdge Application Server', 43232701, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Progress OpenEdge Fathom Replication software', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Progress Sonic ESB', 43232403, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Progress WebSpeed Workshop', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Puppet', 43232401, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Python', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'QUALCOMM Eudora', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Red Hat Enterprise Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Red Hat WildFly', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Relational database management software', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Ruby on Rails', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Samba', 43233001, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Shell script', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'SolarWinds', 43232804, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'SOX COBIT', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Splunk Enterprise', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Spring Framework', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Symantec', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Symantec Veritas File System', 43233001, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Symantec Veritas Volume Manager', 43233001, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Telnet programs software', 43232911, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Teradata Database', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'TKSoftware', 43232404, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Unified modeling language UML', 43232407, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'UNIX', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Veritas NetBackup', 43233415, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Virtual private networking VPN software', 43233204, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Zephyr EXTRA! Terminal Emulation', 43232911, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'ADERANT Expert Back Office, Powered by Keystone', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'ADP software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Automatic Data Processing PC payroll for windows PCPW', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Corel QuattroPro', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Deltek', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Exact Software Macola ES', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Hyperion Enterprise', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Hyperion Solutions System 9 Planning', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'IBM Lotus 1-2-3', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Infor ERP SyteLine', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Job costing software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Microsoft Dynamics SL', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Microsoft FRx', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Microsoft Office SharePoint Server MOSS', 43233503, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'MYOB Premier Accounting Small Business Suite', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Oracle Hyperion Planning', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Sage Fixed Asset Solution FAS', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Sage MIP Fund Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Yardi', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Accounts receivable software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'ARES Corporation PRISM Project Estimator', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Credit management software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Delphi Technology', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Healthcare common procedure coding system HCPCS', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Human resource information system HRIS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Internet browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Marketo Marketing Automation', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Microsoft Exchange Server', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Moody''s KMV FAMAS', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Salesforce software', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Yardi', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'ABB Optimize IT Predict &'||' Control', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Adobe Systems Adobe AfterEffects', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Apple Final Cut Pro', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Citect IIM', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'CitectSCADA Reports', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Clockware', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Computer aided design CAD software', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Computer integrated manufacturing CIM software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Computer integrated manufacturing CIM time manager software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Computer integrated manufacturing CIM warehouse shipping manager software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Employee performance management system', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Exact Software JobBOSS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Financial planning software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'IBM Rational ClearQuest', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Industrial production manager and stock control software', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Intuit QuickBooks Manufacturing &'||' Wholesale', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Marel production system MPS', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Plant management software', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'ProcessPro Premier', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Prosys', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'PTC Creo Parametric', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'QUMAS', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Scadex Technologies MAESTRO', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Schneider Electric CitectSCADA', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Statistical process control SPC software', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Wonderware InTouch', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.00', 'WorkSchedule.net', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Abbot Informatics STARLIMS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'ASI DATAMYTE GageMetrics', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'ASI DATAMYTE QDA', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'ASIDATAMYTE DataMetrics', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Atlassian JIRA', 43232201, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'CAMA Software Quality Collaboration By Design QCBD', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'CEBOS MQ1 software', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Computing Solutions LabSoft LIMS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Core Informatics Laboratory Information Management System LIMS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'EtQ Reliance', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Harrington Group caWeb', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Harrington Group HQMS', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Hewlett Packard LoadRunner', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Illumina Laboratory Information Management System LIMS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Infinity QS ProFicient', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Lablite Laboratory Information Management Systems LIMS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Laboratory Automated Quality Control Systems LAQC', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Labvantage Solutions LIMS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'MasterControl software', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Oracle Java', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Pearson Education PHStat2', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'PQ Systems CHARTrunner Lean', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'PQ Systems GAGEpack', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'PQ Systems MEASUREspy', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'PQ Systems SQCpack', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Promium Element DataSystem LIMS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Quality Systems International WinLIMS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Selenium', 43232406, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Sparta Systems TrackWise', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Statgraphics', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Systat Software Lisa.lims', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Thermo Fisher Scientific Laboratory Information Management Systems LIMS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Vivaldi Software Vivaldi Quality Management', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Datalogging software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Infostat RIMBase', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Personnel scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Computerized maintenance management system CMMS', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Distributed control system DCS', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Employee scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Human machine interface HMI software', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Inventory control software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Computer aided design CAD software', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Computerized maintenance management system CMMS', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Distributed control system DCS', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Employee scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Inventory control software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Computerized maintenance management system CMMS', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Distributed control system DCS', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Employee scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Landfill gas analysis software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Landtec System Software LFG Pro', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.05', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.05', 'WorkTech MAXIMO', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Computerized maintenance management system CMMS', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Distributed control system DCS', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Personnel scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Supervisory control and data acquisition SCADA software', 43232608, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Ariba Spend Management Suite', 43231503, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Automated purchase order software', 43231503, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Bottomline Technologies Bottomline Sprinter Purchasing Manager', 43231503, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Bowen &'||' Groves M1 ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Corel Paradox', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Epicor Vantage ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'IBM Lotus Notes', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Infor Lawson Supply Chain Management', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Inventory management software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Materials requirement planning MRP software', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Oracle DBMS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Oracle PeopleSoft Enterprise Financial Management Solutions', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Oracle Primavera P6 Enterprise Portfolio Project Management', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Point of sale POS software', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Purchasing software', 43231503, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'PurchasingNet eProcurement', 43231503, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'ABOL Manifest Systems', 43231510, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Airline global distribution systems GDS software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'ALK Technologies FleetSuite', 43232504, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'ALK Technologies PC*Miler', 43232504, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Amber Road', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Argos Software ABECAS Insight Freight Management System FMS (accounting feature)', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Argos Software ABECAS Insight Freight Management System FMS (calendar and scheduling feature)', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Autodesk AutoCAD Civil 3D', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Automated expense reporting system software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Bentley MicroStation', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Bentley Transportation Data Manager', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Cadre Technologies Cadence Transportation Management System', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'CoPilot Truck', 43232504, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Eaton Fleet Advisor', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Fleetware software', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Freight Rail Crew Optimization Scheduling FRCOS software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Geometrix', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Graphics software', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'IBM i2 Transportation Manager', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'IBM Lotus Notes', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'IMSure Solutions SHIPflex', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Infosite Technologies Dispatch-Mate', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Integrated Decision Support Corporation Expert Fuel', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Integrated Decision Support Corporation Netwise Supply Chain', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Integrated Decision Support Corporation Route Advice', 43232504, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Integrated Decision Support Corporation Swap Advice', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Integrated Decision Support Match Advice', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Integrated Decision Support Netwise Enterprise', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Integrated Decision Support Netwise Frontline', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Intergraph GeoMedia Transportation Manager', 43232504, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Iptor Supply Chain', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Labelmaster Software REG-Trieve', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'QUALCOMM QTRACS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'QUALCOMM ViaWeb', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Scanlon Associates LogPak', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Shipping Solutions', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Spreadsheet software', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Summary Systems Fleet Commander', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Supply chain event management software', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'TMW PowerSuite', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.01', 'WorkForce Software EmpCenter Time and Attendance', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'ABOL Manifest Systems', 43231510, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Aljex Inventory', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'CA Erwin Data Modeler', 43232310, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Cadre Technologies Cadence Warehouse Management System', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Catalyst International CatalystConnect', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'DSA Foxware Warehouse Management', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Graphics software', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Hewlett Packard HP-UX', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'HighJump Software Warehouse Advantage', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'IBM i2 Transportation Manager', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'IBM Lotus Notes', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Infor ERP Baan', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Infosite Technologies DM Warehousing', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Integrated Decision Support Corporation Netwise Supply Chain', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Integrated Decision Support Corporation Swap Advice', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Integrated Decision Support Netwise Enterprise', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Integrated Decision Support Netwise Frontline', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'IntelliTrack Warehouse Management System', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Iptor Supply Chain', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Logility Voyager WarehousePRO', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Materials requirements planning logistics and supply chain software', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'MRA Technologies MRATrack Warehouse Management System', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'QUALCOMM QTRACS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'QUALCOMM ViaWeb', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Radio Beacon WMS', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'RedPrairie DLx Warehouse', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Scanlon Associates LogPak', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Sentai Pinpoint', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Spreadsheet software', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'SSA Global Warehouse Management System WMS', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Supply chain event management software', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'TECSYS EliteSeries', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'TECSYS PointForce Enterprise', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Veritas NetBackup', 43233415, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.02', 'WorkForce Software EmpCenter Time and Attendance', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', '3PL Central', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Cadre Technologies Accuplus Integrated Distribution Logistics System', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'ESRI ArcLogistics', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'FedEx Ship Manager', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Four Soft 4S eLog', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Four Soft 4S VisiLog', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Infor ERP Baan', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'IntelliTrack 3PL', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Inventory control software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Logisuite Enterprise', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Logisuite Forwarder', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Materials resource planning MRP software', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Microsoft Dynamics AX', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Optimization software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Oracle E-Business Suite Logistics', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Presentation software', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'SAP Business Objects', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'SAP ERP Operations', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Spreadsheet software', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Transportation management system TMS software', 43233511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Transtek Compass ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'UPS WorldShip', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'USPS.com', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Warehouse management system WMS', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', '!Trak-it Solutions !Trak-it HR', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Adobe Systems Adobe Flash Player', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Adobe Systems Adobe PageMaker', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'ADP Employease', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'ADP HR/Benefits Solution', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'AdRelevance', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Apex Business Software iHR', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Apple iMovie', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Ascentis HR', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'ASL HR Director', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Asure Software HCM', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Atlas Business Solutions Staff Files', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Auxillium West HRnetSource', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Blue Chip Computer Consultants HumaNET', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Brainworks', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Business analysis software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Ceridian', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Consultants in Data Processing HRnet', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Datamatics V-Core HR', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Deltek Costpoint', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'DenoSys HRiStragegy', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Document management system software', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'e-MDs Bill', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Experience in Software Webplanner', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'FSC Business Solutions Department Managers'' Toolkit', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Genesys PeopleComeFirst', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Global Groupware Solutions Limited Smiles ERM On-Demand', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'HarrisData Human Resources Information System HRIS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'HR-ease', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'HRMS Solutions iVantage', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'hSenid Business Solutions HRM Enterprise', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Human resource information system HRIS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Humanic Design Human Resources Management System', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'iEmployee', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Jenss &'||' Associates CompKeeper', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Lawson Human Resource Management', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Microsoft Dynamics Marketing', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'NOW Solutions emPath', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Nuview Systems Cort HCM', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'NuView Systems NuViewHR', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Oracle E-Business Suite', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'OrangeHRM', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'PaloAlto Advertising Plan Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'PDS Vista HRMS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'People-Trak HR Essentials', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'PerfectSoftware PerfectHR', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Piney Creek Digital Protocol System', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'PSTek', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Quadkey HR Server', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Quark', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Relex Weibull', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Sage Abra HRMS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Saigun Technologies EmpXtrack', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Sentient Online MarketPrice', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Trigon Road Forte Leave Management', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'UCN inContact Workforce Management Software WFM', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Ultimate Software UltiPro', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Vantage Point Software HRA', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'AASoftTech Web Organization Chart', 43232105, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'AccountantsWorld Payroll Relief', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'ADP Enterprise HR', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'ADP ezLaborManager', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'ADP HR/Benefits Solution', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'ADP HR/Profile', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'ADP Pay eXpert', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'AllNetic Working Time Tracker', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Applicant tracking software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Arrow Electronics N/Compass', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Atlas Business Solutions Staff Files', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Authoria Adviser', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Automation Centre Personnel Tracker', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Ceridian', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Corel WordPerfect', 43231513, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Data Management TimeClock Plus', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Defense Travel System', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Deltek Vision', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Exact Software Macola ES Labor Performance', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Fidelity HR/Payroll', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Halogen e360', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Halogen ePraisal', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Harpers Payroll Services HR la Carte', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Human resource information system HRIS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'IBM Lotus 1-2-3', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Inception Technologies InfiniTime', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Infor ERP SyteLine', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Infor SSA Human Capital Management', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Infotronics Attendance Enterprise', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'interactive Personnel Electronic Records Management System iPERMS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'iSystems Evolution Payroll and Tax Management', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Jantek Electronics Jupiter Time &'||' Attendance', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Kronos Enterprise Workforce Management', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Kronos Workforce Timekeeper', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Lawson Human Resource Management', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Lawson Human Resources Suite', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'LinkedIn', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Microsoft Office SharePoint Server MOSS', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Midrange Software XpertHire', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'New World Systems Logos.NET', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Norchard Solutions Succession Wizard', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Nuvosoft Rwiz', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Oracle HRIS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Oracle Taleo', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Paychex', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Paycor payroll management', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Paylocity Web Pay', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'PDF readers', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'People-Trak software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'peoplefluent Performance', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'peoplefluent Recruiting', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Pereless Systems software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Qqest TimeForce', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'QuestionMark', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Sage Abra HRMS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Savitr RecruitX', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Soft Trac Microix Timesheet', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Standard Installation and Division Personnel Reporting System SIDPERS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Stratitec TimeIPS', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Stromberg Enterprise', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Taleo Enterprise Talent Management Suite', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Tesseract Benefits Manager', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Tesseract Human Resources Manager', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Total Officer Personnel Management Information System TOPMIS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Training software', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Tyler Technologies MUNIS', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'UCN inContact Workforce Management Software WFM', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Ultimate Software UltiPro Workplace', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Unicorn HRO Open4', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'UniFocus Watson Human Resources Manager', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'WhizLabs', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3121.00', 'WinOcular', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Adobe Systems Adobe ActionScript', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Adobe Systems Adobe Captivate', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Adobe Systems Adobe Fireworks', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Adobe Systems Adobe Flash', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Adobe Systems Adobe Flash Player', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Adobe Systems Adobe Presenter', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'AgileView Software SmartView', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Alchemy Systems SISTEM', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Apache Cassandra', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Articulate Rapid E-Learning Studio', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Beeline Learning Management System LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Blackboard', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Blatant Media Absorb LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Brainshark Rapid Learning', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Caliban Mindwear HyperGASP', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Cisco Systems WebEx', 43233502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Cobent Learning and Compliance Suite LCS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Computer Generated Solutions Learning Management System', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Cornerstone OnDemand Cornerstone Learning', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Dazzlersoft DazzlerMax', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'dominKnow Learning Center', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Eedo Knowledgeware Eedo Force Ten', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'ElearningForce JoomlaLMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Epic Systems', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'eXe', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'EZ LCMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'FlexTraining Total e-Learning Solution', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Flying PopCorn', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Freeze.com Ovation Studio Pro', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'FunEducation Outstart Trainer', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'G-Cube Solutions Wizdom Web LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'GeoMetrix Data Systems Training Partner', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'HP Trim', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'HunterStone THESIS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'ICS Learning Group Inquisiq EX', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Ikonami AT-Learning Tool', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'iLinc Communications LearnLinc', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Inspired eLearning iLMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Intelladon Enterprise Knowledge Platform EKP', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Intelligent Information Conversion Technologies MeritScholar', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Intellum Rollbook', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'JavaScript', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Kookaburra Studios Knowledge Presenter', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'LeanForward LearnPoint', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Learn HQ Activate LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Learn.com CourseMaker Studio', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Learn.com LearnCenter Talent Management Suite', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Linspire Nvu', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Magenta MultiMedia Tools Magenta II', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'MediaChance Multimedia Builder', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Medworxx Learning Management System', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Microsoft FrontPage', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Moodle', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Mzinga On-Demand Learning Suite', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'NetDimensions Enterprise Knowledge Platform EKP', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'OnPoint Digital OnPoint Learning &'||' Performance Suite', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Open e-LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Operitel LearnFlex', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Pathlore LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Plateau Learning Management System LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'PRO-ductivity Systems Compliance Training Manager Web', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Rapid Intake Unison', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Right Reason Technologies RightTrack', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'RISC Virtual Training Assistant', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Saba Centra', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'SAFARI Video Networks eZediaQTI', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'SkillSoft SkillPort', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'SumTotal Systems ToolBook', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'SumTotal Systems TotalLMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'SyberWorks Training Center', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'techniques.org knowledgeWorks LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Telania eLeaP Learning Management System LMS/LCMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'The Human Equation InSite LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'TrainCaster LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'TrainOnTrack Learning Management System LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Trivantis Lectora', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Upside Learning UpsideLMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'WBT Systems TopClass', 43233502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Xerceo Learn', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Xyleme Learning Content Management System LCMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Ziiva Prosperity LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Argos Software ABECAS Insight', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Innovative Software Solutions Picas', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Accutech Systems Corporation AccuFarm-MGR', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Advanced Veterinary Services Ranch Vision', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Ag Connections Land.db', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Ag Leader Technology SMS Advanced', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'AGCO Advanced Technology Solutions Fieldstar', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'AgData Blue Skies Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Agevo Farm Manager', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'AgriSoft/CMC AgriSoft/ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'AgTerra Technologies AgTrac', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Alua Software Paddock Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Brihzon Solutions SMART Dairy Resource Planning', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Cattlesoft CattleMax', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'CattleWorks', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'CDA International Manifold System', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Countryside Data Ag Payroll', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Custom Software Group CSG AgroSys', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Datatech The Farmer''s Office', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Delta Data Systems AGIS', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'DIVA-GIS', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'ESRI ArcPad', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'EZ-Ranch', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Farm Business Software Systems Smart Feeder', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Farm Files Crops', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Farm Files Livestock', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Geographic resources analysis support system GRASS', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Global Mapper Software Global Mapper', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Global positioning system GPS software', 43233511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'i.Agri LandMark Farm', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'International Response Technologies CowChip - Ranch House', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'John Deere Apex Farm Management', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'KELTEC Systems HerdMaster', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Lion Edge Technologies Ranch Manager', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'MapInfo', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'MapShots EASi Suite', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Midwest MicroSystems Cow Sense', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Payroll software', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Pear Technology Fieldman Farmer', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'PigCHAMP Care 3000', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'ProducePak Mobile Farm Management', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Red Wing Software CenterPoint Accounting for Agriculture', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Sanders Software Consulting FarmBooks', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Specialized Data Systems Ultra Farm', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'SST Development Group SSToolbox', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'SST Development Group Stratus', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Stenco Technologies Farm Trends', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Sunrise Software CropSave', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'TapLogic FarmLogic', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'TatukGIS Editor', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Trimble AgGPS EZ-Map', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Trimble Farm Works', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Vertical Solutions Easy-Farm Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.02', 'ZedX AgFleet', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.03', 'AquaSoft Farm Manager', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Fish stocking databases', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Hatchery database systems', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Staff scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Statistical analysis software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Time reporting software', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Adobe Systems Adobe Creative Cloud', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'AEC Software FastTrack Schedule', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'ArenaSoft Estimating', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Autodesk AutoCAD Civil 3D', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Autodesk Revit', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Axios Systems assyst', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Bechtel Software SETROUTE', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Cadsoft Design/Build', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'CBS ProLog Manager', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Computer aided design and drafting software CADD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'CSI WSE CodeBuddy', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Daily Manager', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Drone image capturing software', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Explorer Engineer', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'HCSS HeavyBid', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'HCSS HeavyJob', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'IMPACT software', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Integrated construction management software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Internet browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Intuit QuickBase', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'ISS Construction Manager', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Jobber Computer Plus', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Lombardi Teamworks', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Presentation software', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Profitool GearWatch', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Profitool software (human resources feature)', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Profitool software (time accounting feature)', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Quantum Software Solutions Quantum Project Manager', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Sage 100 Contractor', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Sage 300 Construction and Real Estate', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Site Manager', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'SRC Cash Flow Forecasting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Supervisory control and data acquisition SCADA software', 43232608, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Trimble SketchUp Pro', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'UDA Technologies ConstructionSuite', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'VirtualBoss', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Yardi', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'ACS Technologies HeadMaster', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Auburn Software Debit Square', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'B&'||'I Computer Consultants Childcare Sage', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Cirrus Group Daycare Works', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'eChurch.com SchoolPerfect', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Emerging Technologies Office Center', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Intuit Quicken', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Jackrabbit Technologies Jackrabbit Care', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Kressa Software SchoolLeader', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'MAGGEY Child Care Management Software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Mount Taylor Programs Private Advantage', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'OnCare Advantage', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'ONE Software KidsONE', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Orgmation iCare', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Personalized Software Childcare Manager', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'PraxiPower PraxiSchool', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Professional Solutions ProCare', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'ScholarCare', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'SDS Software Solutions DayCare Information Systems PRO', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'SoftCare CenterCare', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'SofterWare EZ-CARE2', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'The Gallagher Group DataCare', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'ACS Technologies HeadMaster', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Apache Cassandra', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Attendance tracking software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Blackbaud The Education Edge', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Blackboard', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Computer Resources MMS', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'eDistrict Internet Solutions eDistrict Unified', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Effexoft EASI', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Gmail', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Google Calendar', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Google Drive', 43231513, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'IBM Domino', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'L-Systems X-ONE', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'LogicalBit Eimas', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Pearson PowerSchool', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'RecordKeeper Software School RecordKeeper', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Rediker Software School Office Suite', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Robust Software Overseer Suite', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'School Attendance Keeper', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'SchoolDESX', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Seasia Consulting School Wizard', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Skyward School Management System', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Specialized Data Systems School Office', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'SunGard Public Sector IFAS', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Thinc Technologies Virtual School', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Wilcomp Software RenWeb', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Blackboard', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'CollegeNET Schedule 25', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Ellucian Colleague', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Ellucian Degree Works', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Enterprise resource planning ERP system', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Google Docs', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Jenzabar EX', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'LinkedIn', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Nolij Corporation Nolij Transfer', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Student and Exchange Visitor Information System SEVIS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Student information systems SIS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'SunGard Higher Education Banner Unified Digital Campus', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9033.00', 'YouTube', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Adobe Systems Adobe Captivate', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Adobe Systems Adobe Connect', 43233503, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Adobe Systems Adobe Creative Suite', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Adobe Systems Adobe Flash', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Articulate Storyline', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Blackboard', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'C#', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'C++', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Campus Cruiser LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Cisco Systems WebEx', 43233502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'ConferenceEdge', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Instructure Canvas', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'LinkedIn', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Microsoft .NET Framework', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Moodle', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Oracle Java', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Podcasting software', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'RISC Virtual Training Assistant', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Twitter', 43233504, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Videoconferencing software', 43233502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Web conferencing software', 43233502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.01', 'YouTube', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.02', 'MicroFit HealthWizard', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Payroll software', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Work scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Adobe Systems Adobe Acrobat Pro Extended', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Adobe Systems Adobe LifeCycle ES', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Agile Product Lifecyle Management PLM', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Ansible software', 43231511, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Apache Cassandra', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Apache Hive', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Apache Kafka', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Apache Maven', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Apache Pig', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Apache Solr', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Apple macOS', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Aptean Made2Manage', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Atlassian JIRA', 43232201, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Autodesk AutoCAD Civil 3D', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Autodesk Buzzsaw', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Autodesk Revit', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Autodesk VIZ', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'AWS Redshift', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Backbone.js', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Bash', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Bentley MicroStation', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'C', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'C#', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'C++', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Chef', 43232401, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Cisco Systems IOS', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Citrix', 43232901, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Computer aided design and drafting software CADD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Computer aided manufacturing CAM software', 43232612, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Confluence', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Customer information control system CICS', 43232313, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Dassault Systemes CATIA', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Dassault Systemes SOLIDWORKS', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Delcam PowerMILL', 43232612, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Django', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Docker', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Drawing and drafting software', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Elasticsearch', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'ESRI ArcView', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Geographic information system GIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Geometric CAMWorks', 43232612, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Git', 43232203, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'GitHub', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'HEC RAS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'HEC-1', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Hewlett Packard LoadRunner', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Hewlett-Packard HP SolidDesigner', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Inventory management software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'JavaScript', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Kronos Workforce Timekeeper', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'LAMP Stack', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'LSA Visual Easy Lean', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Maintenance scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Microsoft Azure', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Microsoft Dynamics NAV', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'MongoDB', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'MySQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Nagios', 43232801, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'National Instruments LabVIEW', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Node.js', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'NoSQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Objective C', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Open Mind hyperMILL', 43232612, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Oracle Java', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Oracle Solaris', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Perforce Helix software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'PostgreSQL', 43232311, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Practical extraction and reporting language Perl', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'PTC Creo Parametric', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Puppet', 43232401, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Python', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'React', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Realization Streamliner', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Relational database management software', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'RTA Fleet Management', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Ruby', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Ruby on Rails', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Scala', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Shell script', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Splunk Enterprise', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Spreadsheet software', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Supervisory control and data acquisition SCADA software', 43232608, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Swift', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Teradata Database', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'The Gordian Group PROGEN Online', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Trimble SketchUp Pro', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Ubuntu', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'UNIX', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Verilog', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Virtual private networking VPN software', 43233204, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Water surface pressure gradient WSPG software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Wireshark', 43232801, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Workflow software', 43232201, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Agilent ChemStation', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Computer aided design CAD software', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Fleet Asset Management and Optimization Solutions FAMOS PEPSE', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.01', 'GE Energy GateCycle', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.01', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Adobe Systems Adobe Flash', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Aestiva Employee Time Clock', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Apache Groovy', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Army Food Management Information System', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Aurora FoodPro', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'ChefDesk Chef''s Calculators', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'ClubSoft Food &'||' Beverage Point of Sale', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Culinary Software Services ChefTec', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'DataTeam Lunch Express', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Delphi Technology', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Dinerware Intuitive Restaurant', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'espSoftware Employee Schedule Partner', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Food Service Solutions FoodCo', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Food Service Solutions POSitive ID System', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Food Services Solutions DayCap', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Gift Certificates Plus Giftworks', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'IBM Domino', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'iMagic Restaurant Reservation', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Inventory management software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'IPro Restaurant Inventory, Recipe &'||' Menu Software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Oracle Taleo', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'ReServe Interactive', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Restaurant Manager', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'SoftCafe MenuPro', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'SweetWARE nutraCoster', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'ValuSoft MasterCook', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9061.00', 'CodeJam MemoriesOnTV', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9061.00', 'CSR Consultants Cemetery Management SC', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Financial reporting software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9061.00', 'FPA Software MACCS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9061.00', 'funeralOne Life Tributes', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9061.00', 'HMIS Advantage', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Mortware Professional', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Twin Tiers Technologies CIMS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Twin Tiers Technologies MIMS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Employee scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Human resources management system HRMS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Accounting software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Anand Systems ASI FrontDesk', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Delphi Technology', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Enablez ResortSuite', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'ePOS Business Solutions System 3 POS', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Execu/Tech Systems HOTEL Premium', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'GraceSoft Easy InnKeeping Suite', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Hotel management system software', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Housekeeping management software', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'INN-Client Server Systems ICSS Atrium', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'iRez Systems Rezware XP7', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'M-Tech Hotel Service Optimization System HotSOS', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'MICROS Systems OPERA Enterprise Solution OES', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Payroll software', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'RedSky IT Entirety e-Booking', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Silverbyte Systems Optima Property Management System PMS', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'TCS Hotel Software Guest Tracker', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'UniResMan', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', '3DGrid HIPAA Checkup', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'AcuStaf', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Adobe Systems Adobe Flash', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Allscripts Misys Healthcare Systems', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Alteer Office', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'American Medical Association CodeManager', 43232301, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Apache Maven', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Apache Pig', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'API Healthcare ActiveStaffer', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'ArticSoft FileAssurity', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Autodesk Revit', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Bed Management Suite', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Blackboard', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'CareCentric MestaMed', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Cerner ProFile', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Citrix', 43232901, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'CliniTrend', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'ColorSoft AutoMatch', 43232301, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'ConceptDraw', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Contract management software', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Current procedural terminology CPT software', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Delphi Technology', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Dental Common Access System DENCAS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'DxCG RiskSmart', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'e-MDs Bill', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'e-MDs Chart', 43232105, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'e-MDs DocMan', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'e-MDs Schedule', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Electronic medical record EMR software', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Emdeon HealthPro', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Epic Systems', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Expert Health Data Programming Vitalnet', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'GE Healthcare Centricity EMR', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Geographic information system GIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Google AdWords', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Google Docs', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Google Sheets', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Healthcare common procedure coding system HCPCS', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Henry Schein Dentrix', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'IBM Domino', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Integrated development environment IDE software', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Inventory management software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Kodak Dental Systems Kodak SOFTDENT Practice management software PMS', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'LinkedIn', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Marketo Marketing Automation', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'McKesson Horizon Ambulatory Care', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'MEDENT', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'MedFORCE Technologies WorkFLOW', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Medical condition coding software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Medical procedure coding software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'MEDITECH Medical and Practice Management MPM Suite', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'MEDITECH software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Microsoft Exchange Server', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Microsoft SQL Server Reporting Services', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Misys Healthcare Systems Misys Tiger', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Nuance PaperPort Professional', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Oracle Taleo', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'PCC EHR', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'PCC Pediatric Partner', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Relative Values for Physicians', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Salesforce software', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'TeleTracking PreAdmit-Tracking', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Teradata Database', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Trimble SketchUp Pro', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Veritas NetBackup', 43233415, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Yardi', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Yost Engineering ABN Assistant', 43232301, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Yost Engineering ClaimScrub', 43232301, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Yost Engineering CodeSearch Pro', 43232301, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Yost Engineering EpiCoder', 43232301, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Yost Engineering EPStaffCheck', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Graphics software', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'IBM Lotus 1-2-3', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Laboratory information management system LIMS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Oracle DBMS', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'STATISTICA', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', '5AM Glassbox Translational Research', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Budgeting software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'ClearTrial', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Clinical data management system CDMS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Drug coding software', 43232301, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'DZS Software Solutions ClinPlus', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Electronic data capture EDC software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'ePharmaSolutions eMVR', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'InferMed MACRO Electronic Data Capture', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'InforSense InforSense', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Invivo Data EPX ePRO Management System', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'KIKA Veracity', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Online data collection systems', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'OpenClinica', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Oracle Clinical', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Patient tracking software', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'PercipEnz Technologies OnCore-Clinical Research Management OnCore-CRM', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Phase Forward InForm GTM', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'PPD eLoader', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'PPD Patient Profiles', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Project management software', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Qualitative analysis software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Sierra Scientific Software CRIS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'StudyManager Sponsor Edition', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'SyMetric Sciences SyMetric', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'TOPAZ Enterprise Software Suite', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'DHI MIKE URBAN', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'ESRI ArcGIS Spatial Analyst', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'ESRI ArcInfo', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'ESRI ArcPad', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'ESRI ArcView', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'ESRI ArcView 3D Analyst', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'FishXing', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Global positioning system GPS software', 43233511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Google Earth Pro', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'HEC-HMS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'HEC-RAS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Laboratory information management system LIMS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'MWH Soft H2ONET MSX', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'MWH Soft InfoSWMM', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Scientific Software Group RIVERMorph', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'TIBCO Spotfire S+', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Wallingford Software InfoSewer', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Wallingford Software InfoWater', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Wallingford Software InfoWorks CS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Wallingford Software InfoWorks WS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Water flow modeling software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Collection Point Management System CPMS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9131.00', 'eBuy', 43231503, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Facility database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Payroll software', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Personnel management software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Personnel scheduling software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Point of sale POS software', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Postal boundary mapping software', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Postal tracking software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9131.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Vehicle management software', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Web Box Activity Tracing System WebBATS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Advantos Systems DataTrust Enterprise', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Biometric reader software', 43232901, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Bostonpost Technology Property Manager', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Calendar and scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Card key management software', 43232901, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Domin-8 Enterprise Solutions RentRight', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Domin-8 Enterprise Solutions Tenant Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'FullHouse Software Investment Property Manager', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Google Analytics', 43232307, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Google Docs', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'IDEAS Software &'||' Training IDEAS Property Clerk', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Infor Global Solutions eSITE', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Intuit MRI Residential', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Intuit Quicken Rental Property Manager', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'iRealty Manager', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Jenark Business Systems', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Just So Software The Property Manager', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'LandlordMax', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Landport Systems Landport', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'LinkedIn', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'London Computer Systems Rent Manager', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'O''Brien Grasso RE Software Property Master', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Property Boulevard', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Property Solutions International ResidentPortal', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'PropertyThree', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'PropertyView Solutions Remanage', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Propertyware', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'PT Software Solutions PT Rental Assistant', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Qualitica RentBoss', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'RealEasyBooks ezREB', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'RealPage OneSite', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'SpiritWorks Software Development Rental Property Tracker Plus', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Spreadsheet software', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'SS&'||'C Technologies Skyline Property Management', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'TCG Technologies i-CAM', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'TrackPro Services TrackPro Manager', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Turtle Creek Software Goldenseal', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'W G Software Tenant File', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Yardi', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Yardi Systems Yardi Enterprise', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Yardi Systems Yardi Voyager Commercial', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Yardi Systems Yardi Voyager Condo, Co-op, and HOA', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Yardi Systems Yardi Voyager Residential', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9141.00', 'YouTube', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Client information databases', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Corel QuattroPro', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Corel WordPerfect Office Suite', 43231513, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Financial accounting software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Healthcare common procedure coding system HCPCS', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'IBM Lotus 1-2-3', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Microsoft Visual FoxPro', 43232311, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Oracle Reports', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'PointClickCare HER', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Presentation software', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Alert Technologies OpsCenter', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Desktop publishing software', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Digital Engineering Corporation E-MAPS', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Emergency Managers Weather Information Network EMWIN', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Emergency Services Integrators ESi WebEOC', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Federal Emergency Management Information System FEMIS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Geographic information system GIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Graphics software', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'IBM Lotus Notes', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'MapInfo Professional', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'McAfee', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'National Center for Crisis and Continuity Coordination NC4 E Team', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Relational database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'SoftRisk Technologies SoftRisk SQL', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Statistical software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'SunGard Assurance', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Adlib Express', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Analyse-it', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Aris Global Register', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Axway eSubmissions', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Datafarm a-Pulse', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Datafarm eCTDGatekeeper', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Datafarm eCTDViewer', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Datafarm S-Cubed', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Dialog DialogLink', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Document publishing software', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'DoubleBridge ROSETTA Phoenix eCTD Viewer', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'DoubleBridge ROSETTA Pyramid', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'DoubleBridge ROSETTA Sceptre', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'DoubleBridge ROSETTA Scribe', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Electronic common technical document eCTD software', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Electronic common technical document eCTD validating software', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Electronic common technical document eCTD viewing software', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Electronic document management system EDMS', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Enterprise content management ECM software', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Extedo DOCvalidator', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Extedo eCTDmanager Suite', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Extedo PLmanager', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'GlobalSubmit REVIEW', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'GlobalSubmit VALIDATE', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Image Solutions eCTDXpress', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Image Solutions ISIPublisher', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Integrated development environment IDE software', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Lorenz DocuBridge', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Lorenz eValidator', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Lorenz labelBridge', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'MasterControl software', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'MediRegs E-dition Compliance Monitor', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'MediRegs Pharmaceutical Regulation Suite', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'MediRegs Regulation and Reimbursement Suite', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'MediRegs Risk Assessment Manager', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'MedXView eCTDauditor', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Octagon StartingPoint', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Octagon ViewPoint eCTD Complete', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Pilgrim Regulatory Submission', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Risk management software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Samarind RMS', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'SAP EHS Management', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Spreadsheet software', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Statistical analysis software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Take Solutions PharmaReady Document Management System', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Thomson Reuters Liquent CoreDossier Submission Accelerator for eCTD', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Thomson Reuters Liquent InSight Suite', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Total quality management TQM software', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Virtify eCTD', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.01', 'XML authoring software', 43232403, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', '80-20 Software Leaders4', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Actimize Brokerage Compliance Solutions', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Agiliance Compliance Manager', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Aline GRC', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Apple Safari', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'ARC Logics Sword', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Archer Compliance Management', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'AssurX CATSWeb', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'AssurX Financial Services Compliance Management System', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Audit2 AdaptiveGRC', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Axentis Compliance Management', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'BPS Compliance', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'BWise Compliance Management', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'CMO Compliance Regulatory Compliance Solution', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Compliance 360', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Compliance11 Supervisory Suite', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'ComplianceBridge Total Compliance', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'ControlCase Compliance Manager', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Cura Software Solutions Cura for Compliance Management', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Data analysis software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Database management software', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Desktop publishing software', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'DoubleCheck GRC&'||'T Platform', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'EtQ Environmental Health and Safety Software', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'EtQ FDA cGxP Compliance Software for Life Sciences', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Fidessa Compliance Manager', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'FRSGlobal RegPro', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Governance, risk, and compliance GRC software', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Guideline Risk Technologies RUBI', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Healthcare common procedure coding system HCPCS', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Horwath Software Magique', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Human resource information system HRIS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Keane SCORE', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'LRN Ethics and Compliance Alliance', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'MasterControl MD', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'MasterControl TotalPharma', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'MediRegs ComplyTrack', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Methodware ERA', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'MetricStream Compliance Management', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'MetricStream Enterprise Compliance Platform', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'MetricStream Regulatory Reporting', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Modulo Risk Manager', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Mozilla Firefox', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'MyComplianceOffice Compliance Operations Management System', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Neohapsis Certus GRC', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Oracle Enterprise Governance, Risk, and Compliance Manager', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Oracle Insurance Compliance Tracker', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'policyIQ', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Protiviti Governance Portal', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'QUMAS Compliance Solution', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Resolve Legislative Compliance Management', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'RVR Systems Compliance', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'SAP BEx Report Designer', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Spreadsheet software', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Sword Achiever Compliance Portal Dashboard', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Tax accounting software', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'The Garland Group RiskKey', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Thomson Reuters Paisley Enterprise GRC', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Autodesk AutoCAD Blue Sky', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Financial accounting software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Microsoft MapPoint', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Portfolio analysis software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'ReadSoft', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Risk analysis software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Statistical analysis software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'SunGard Financial Systems AddVantage', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Adexa Supply Chain Planning', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Advanced business application programming ABAP', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Aldata Warehouse Management', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'CDC Supply Chain', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Dex Warehouse', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Epicor SRM', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Epicor WMS', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Graphics software', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'HighJump Software Supply Chain Advantage', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'HighJump Warehouse Advantage', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'i2 Collaborative Supply Execution', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'i2 Intelligence', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'i2 Supply Chain Visibility', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'IBM ILOG Inventory Analyst', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'IBM ILOG LogicNet Plus XE', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'IBS MRP', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'IBS Supply Chain Management', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'IFS Applications for Supply Chain Management', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Infor Lawson Supply Chain Management', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Infor SCM', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'JDA Master Planning', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Lawson S3 Supply Chain Management', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Manhattan Scale', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Manhattan Supply Chain Process Platform', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Master scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'MEDITECH software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Microsoft Dynamics AX', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Oracle e-Business Suite Supply Chain Management', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Oracle Inventory', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Purchasing software', 43231503, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'QAD MFG Pro', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Red Prarie Warehouse Management', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'SAP APO', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'SAP SCM', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Simulation and modeling software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Swisslog WarehouseManager', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Warehouse management system WMS', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Alarm system software', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Computer aided design CAD software', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Corel WordPerfect Office Suite', 43231513, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Emergency notification system software', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'FieldSoft AIMSonScene', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Graphics software', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Human resources management system HRMS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Incident command system ICS software', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Inventory tracking software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Maintenance management software', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Mapping software', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'McAfee', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Payroll software', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Physical access management software', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Symantec', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Twitter', 43233504, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Work scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Enabl-u Technologies APIS', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Financial accounting software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'IBM Lotus Notes', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Inventory tracking software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'MICROS XBR Loss Prevention', 43232314, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Microsoft operating system', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'MySQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Personnel management software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Point of sale POS software programs', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Time reporting software', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Work scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Computerized diagnostic software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Computerized maintenance management system CMMS', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Employee scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Gensuite', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'IBM Lotus Notes', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Inventory control software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Local area network LAN software', 43232905, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Oracle Enterprise Asset Management eAM', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Programmable logic controller PLC software', 43232608, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Supervisory control and data acquisition SCADA software', 43232608, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Time and payroll management software', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'WebEx WebOffice', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Wide area network WAN software', 43232909, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.10', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Oracle Primavera Systems', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.10', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Web conferencing software', 43233502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Calendar management software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.11', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.11', 'ESRI ArcMap', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.11', 'ESRI ArcView', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Maptek Vulcan', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.11', 'MineSight', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Financial accounting software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Spreadsheet software', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Statistical analysis software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Tax planning software', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Twitter', 43233504, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Videoconferencing software', 43233502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Deltek Costpoint', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Enterprise resource planning ERP system', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1021.00', 'IBM Lotus Notes', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Inventory management systems', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Product producer databases', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1021.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Accounting software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Advanced Retail Management Systems Retail Pro', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Biztrak Business Solutions Biztrak', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'CAM Commerce Solutions Retail STAR Point of Sale POS', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Claritas ConsumerPoint', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Contact management software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Eclipse IDE', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Enterprise risk management software ERMS', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Graphics software', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Infor Supply Chain Management', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Inventory control systems', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'JDA Software Group Advanced Warehouse Replenishment by E3', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'JDA Software Group Assortment Planning by Arthur', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Kliger-Weiss Infosystems', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'LinkedIn', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Materials requirement planning MRP software', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Millennium Software Atrex', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Oracle', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Oracle Advanced Procurement', 43231503, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Oracle PeopleSoft Enterprise Supply Planning Multi-Site Material Planner', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Oracle Taleo', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Plexis Software Plexis POS', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Point of sale POS software', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'POSitive Software POSitive for Windows', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Presentation software', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Product development management software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Project management software', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Sage ERP Accpac', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'SAP POS Data Management', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'SAP software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Scheduling software', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Sourcing Simulator', 43231503, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Specialized Business Solutions Keystroke POS', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Spreadsheet software', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Windward Software Windward System Five', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Accounting software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Apple AppleWorks', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Assured Software JPP', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Choice Job Cost', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Construction Management Software ProEst', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Corel QuattroPro', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Cost accounting software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Cost estimation software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'CPR International GeneralCOST Estimator', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'CPR Visual Estimator', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Data base reporting software', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Dexter + Cheney Spectrum Construction Software', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Financial analysis software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Galorath SEER-SEM', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Google AdWords', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Google Docs', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'IBM Costimater', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'IBM Lotus 1-2-3', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Infor ERP SyteLine', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Inventory management systems', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'QSM SLIM', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Resources Calculations Incorporated SoftCost', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Sage 100 Contractor', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Softstar Costar COCOMO II', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Software AG', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'WinEstimator WinEst', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Xactware Xactimate', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Agency Management Systems AMS 360', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'AutoClaims Direct DirectLink', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Automatic Data Processing Autosource', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Automatic Data Processing Claims Manager &'||' Dispatch', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Axonwave Fraud and Abuse Management System', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'BCCORP W5 for Adjusters', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Bill review software', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Bramerhill ClaimsTech', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Bridium Claims 3', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Brightwork Alyce Claims Systems', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Captiva InputAccel', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Castek Insure3 Claims', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'CCC EZNet electronic communications network', 43232901, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'CCC GuidePost Decision Support', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'CCC Pathways Appraisal Quality Solution', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'CCC Pathways Image Management Solution', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'CCC TL2000 Solution', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'CGI INSideOUT', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Claims processing administration and management software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Clear Technology Tranzax', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Computerized voice stress analyzer CVSA software', 43232703, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Corporate Systems ClaimsPro', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Covansys ClaimConnect', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'CSC Automated Work Distributor AWD', 43232901, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'CSC Fault Evaluator', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Datanex ClaimTrac', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Document management system software', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Fair Isaac Claims Advisor', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Fair Isaac SmartAdvisor', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'First Notice Systems ClaimCapture', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Healthcare common procedure coding system HCPCS', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Hummingbird Legal Bill Review', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Hyland OnBase Enterprise Content Management', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'IBM Fraud and Abuse Management System', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Insurance claims fraud detection software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'InSystems Calligo Document Management System', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'ISO ClaimSearch', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'ISO NetMap for Claims', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'LexisNexis RiskWise', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Magnify Predictive Targeting System', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Medical condition coding software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Medical procedure coding software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'StrataCare StrataWare eReview', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Tropics Claims Reserve Management', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', '4n6xprt Systems StiffCalcs', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'ADP software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Agency Management Systems AMS 360', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'ARSoftware WinSMAC', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Autoclaims Direct DirectLink', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Automatic Data Processing Autosource', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Automatic Data Processing Claims Manager &'||' Dispatch', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Automatic Data Processing Estimating', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Axonwave Fraud and Abuse Management System', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'BCCORP Burkitt W5', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Bill review software', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Bramerhill ClaimsTech', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Bridium Claims 3', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Brightwork Alyce Claims Systems', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'CAD Zone Insurance', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Captiva InputAccel', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Castek Insure3 Claims', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'CCC EZNet electronic communications network', 43232901, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'CCC GuidePost Decision Support', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'CCC Pathways Appraisal Quality Solution', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'CCC Pathways Image Management Solution', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'CCC TL2000 Solution', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'CGI INSideOUT', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'CGI-AMS BureauLink Enterprise', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Claims processing administration and management software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Clear Technology Tranzax', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Computerized voice stress analyzer CVSA software', 43232703, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Corporate Systems ClaimsPro', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Covansys ClaimConnect', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'CSC Automated Work Distributor AWD', 43232901, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'CSC Colossus', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'CSC Fault Evaluator', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Datanex ClaimTrac', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Document management system software', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Fair Isaac SmartAdvisor', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'First Notice Systems ClaimCapture', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Healthcare common procedure coding system HCPCS', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Hummingbird Legal Bill Review', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Hyland OnBase Enterprise Content Management', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'IBM Fraud and Abuse Management System', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Injury Sciences EDR InSight', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Insurance claims fraud detection software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'InSystems Calligo Document Management System', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'ISO ClaimSearch', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'ISO NetMap for Claims', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'LexisNexis RiskWise', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Magnify Predictive Targeting System', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'MapScenes Evidence Recorder', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'MapScenes Pro', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'PhotoModeler', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Property damage, bodily injury, and liability estimation software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'QwikQuote software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Simsol for Adjusters', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'StrataCare StrataWare eReview', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Turtle Creek Software Goldenseal Architect', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Visual Statement Investigator Suite', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1032.00', 'A-T Solutions Easy Street Draw', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1032.00', 'App Software Associations AppTrak.net', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Cost estimating software', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Information Services Inc. CCC Pathways Appraisal Solution', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Meridian Technologies SurePoint', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Mitchell International Mitchell WorkCenter', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1032.00', 'NCH Software Express Invoice', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Solera Audatex Estimating', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Swan River Software Estimiser Pro', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Vertafore ImageRight', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Web-Est', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'DQO-PRO', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Environmental Knowledge and Assessment Tool EKAT', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Field Operations and Records Management System (FORMS) II Lite', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Fully Integrated Environmental Location Decision Support FIELDS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Geographic information system GIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'HRS Quickscore', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Mass Flux Toolkit', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Monitoring and Remediation Optimization System MAROS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Rapid Assessment Tools R.A.T.', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Salesforce software', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'SAP software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Scribe', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Spatial Analysis and Decision Assistance SADA', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Sustainable Management Approaches and Revitalization Tools SMARTe', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'UNIX', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Commercial driver''s license information system CDLIS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Computer-assisted testing software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Digital imaging system software', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Document scanning software', 43232111, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Driving simulators', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.02', 'National Driver Register NDR', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Safety Status Measurement System SafeStat', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Traffic record databases', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Bashen EEOFedSoft', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Bashen EEOSoft', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Bashen LinkLine', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Berkshire Associates BALANCEaap', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Biddle Adverse Impact Toolkit', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Biddle AutoAAP', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Corel WordPerfect', 43231513, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'EEO Made Simple AAPMaker', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'EEO Made Simple AppTrac', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Equal employment opportunity EEO compliance software', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Equitas EEOStat', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Gerstco AAPBase', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'IBM Lotus 1-2-3', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Microsoft operating system', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Peopleclick AAPlanner', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Peopleclick CAAMS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Peopleclick Monitor', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Peopleclick PayStat', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Speediware SpeedEEO', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Yocum &'||' McKee The Complete AAP', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Adobe Systems Adobe Creative Suite', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Autodesk AutoCAD Civil 3D', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Bentley Microstation', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'BrioQuery', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Coeus', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Deltek Costpoint', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Esri ArcGIS', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Inventory control system software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Microsoft NetMeeting', 43233502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Peninsula Software Quicktrack Pro', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Plant Clearance Automated Reutilization Screening System PCARSS', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Radio frequency identification RFID software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Records management software', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Shipping software', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Unique Identification UID system databases', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Wide Area Workflow WAWF system', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', '3D graphics software', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Alcestis', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Autopsy information databases', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Bite analysis software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Corel WordPerfect', 43231513, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Douglas Associates Forensic Filer', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Fingerprint databases', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Genetic database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Graphics software', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Ingenuware CoronerBase', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Mideo Systems EZDoc Plus', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Rapid Medical Examiners System', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Spreadsheet software', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Toxicology databases', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Analyse-it', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Atrion Intelligent Authoring', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'DataVision', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Healthcare common procedure coding system HCPCS', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Integrated development environment IDE software', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'McAfee', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Medical procedure coding software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Relational database management software', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Statistical software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Yardi', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Apple AppleWorks', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Assured Software JPP', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Autodesk Revit', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Choice Job Cost', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Computer aided design and drafting CADD software', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'ConEst BidTrac', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'ConEst Electrical Formulas', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'ConEst Intellibid', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'ConEst IntelliBid Design Build', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'ConEst JobTrac', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'ConEst Permit Trac', 43231512, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'ConEst SureCount', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'ConEst T&'||'M Billing Manager', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Construction Management Software ProEst', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Corel QuattroPro', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Cost accounting software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Cost estimation software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'CPR International GeneralCOST Estimator', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'CPR Visual Estimator', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Dassault Systemes CATIA', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Decisioneering Crystal Ball', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'EFI Hagen OA', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Galorath SEER', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Galorath SEER-SEM', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'HCSS HeavyBid', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'HCSS HeavyJob', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'IBM Costimater', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'IBM Lotus 1-2-3', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Laserfiche Avante', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Logic Software Easy Projects.NET', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Microsoft Business Contact Manager', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Oracle Hyperion', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Palisade @Risk', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'PRICE Sytems TruePlanning', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Primavera Cost Management', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'QSM SLIM', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Resources Calculations Incorporated SoftCost', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Sage 100 Contractor', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Sage 300 Construction and Real Estate', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Softstar Costar COCOMO II', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Software AG', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Trimble SketchUp Pro', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'WinEstimator WinEst', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Xactware Xactimate', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Ad Cast', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Adobe Systems Adobe Creative Cloud', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Adobe Systems Adobe Fireworks', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Adobe Systems Adobe Flash', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Adobe Systems Adobe Human Capital Application Solution Accelerator', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Adobe Systems Adobe LifeCycle Enterprise Suite', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Advanced business application programming ABAP', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Apple Final Cut Pro', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Applicant tracking software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Arbita OnePost', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Arbita OneWorld', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Assessment software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'AST Staff Matrix', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Background checking software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Blackboard', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Blackdog', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'BlackDog Recruiting', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Bond International Adapt Staffing', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Bond International Software Bond StaffSuite', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'BrightMove Applicant Tracking System', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Bullhorn', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Bullhorn Applicant Tracking System', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Candidate screening software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Candidate tracking software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Careerbuilder.com', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Cluen', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Cluen Encore', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'COATS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'COATSsql', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'CVTracer', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Data Frenzy', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'DGCC.com RecruitTrack', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Drupal', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Ellucian Banner Human Resources', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Enterprise JavaBeans', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'eQuest', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'GoBackgrounds', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Google', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Google AdWords', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Google Analytics', 43232307, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Google Docs', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'HireAbility ResumeParser', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'HireLogic PowerPlace', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'HRM Direct', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'HRMDirect', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Human resource information system HRIS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'iApplicants', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'IBM Domino', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'IBM InfoSphere DataStage', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'ICIMS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Industrial Code Recruitpoint.net', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'InfoGIST Platinum Recruiter', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Intelius', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Intelligent Algorithms InfoGIST Platinum Recruiter', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Job Match iApplicants', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Job posting software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Kronos Workforce HR', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Kronos Workforce Payroll', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Lawson Human Resource Management Suite', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'LinkedIn', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Main Sequence Technologies PCRecruiter', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Main Sequence Technologies PCRecruiter ResumeInhaler', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Marketo Marketing Automation', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'MEDITECH software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Micro J Systems PcHunter', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Microj Systems PcHunter', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Microsoft SQL Server Reporting Services', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Monster.com', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'MPAY Millennium', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Online databases', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Oracle Eloqua', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Oracle PeopleSoft Human Capital Management', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Oracle Solaris', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Oracle Taleo', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Oracle WebLogic Server', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Perforce Helix software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Post My Jobs', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Post Once', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'PostingPal', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'PowerPlace Professional', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Recruiting Wizard', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Recruitment management software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Recruitpoint.net', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'RecruitTrack', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Resource Edge TalentHook Sphere', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Resume converter software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Resume extraction and search software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Resume processing software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'ResumeRobot', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Safari Software Products Safari', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Salesforce software', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'SAP ERP Human Capital Management', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Sendouts Recruiting', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Silk Road technology OpenHire', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Staffing Solutions Enterprises Staff Matrix', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'StaffingSoft Staffing Edition', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Talent Technology HireDesk', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Talent Technology Resume Mirror', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Talent Technology Talemetry', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'TalentHook', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Taleo Enterprise Talent Management Suite', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technomedia Hodes iQ', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'TempWorks', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Trovix', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Trovix Recruit', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'VCG Pointwing', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Vendor management system software', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Walling Info Systems Recruiting Wizard', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1071.00', 'YouTube', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Bookkeeping software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1074.00', 'E-Verify', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Financial accounting software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Internet Grievance System IGS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1075.00', 'LaborSoft LaborForce Arbitration/Appeals Manager module', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1075.00', 'LaborSoft LaborForce Discipline Manager module', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1075.00', 'LaborSoft LaborForce EEO Claims Manager module', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1075.00', 'LaborSoft LaborForce Grievance Manager module', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1075.00', 'LaborSoft LaborForce Incident Tracking module', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1075.00', 'LaborSoft LaborForce Personnel Manager module', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1075.00', 'LaborSoft LaborForce Reporting/Dashboard Manager module', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Micropact entellitrak Labor Relations Edition', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Customer relationship management CRM software', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Oracle E-Business Suite', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Order management software', 43231503, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Purchasing software', 43231503, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Radio frequency identification RFID software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'RedPrairie E2e', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Warehouse management system WMS', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'C++', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Failure modes and effects analysis FMEA software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'i2 Transportation Modeler', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'IBM ILOG CPLEX/Dispatcher', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'ITEM Software ITEM ToolKit', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'ITEM Software Spare Cost', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'JDA Manugistics', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'JMS Software RCM WorkSaver', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Logistics Cost Estimating Tool', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Logistics management information LMI database software', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Logistics Support Analysts SmartLogic', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'LOGSA COMPASS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'LOGSA SYSPARS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Oracle Java', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Prolog', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Relex FMEA', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Reliability centered maintenance RCM software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'ReliaSoft RCM++', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'ReliaSoft XFMEA', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Reliass EAGLE', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Warehouse management system WMS', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', '3PL Central', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Advanced business application programming ABAP', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Cadre Technologies Accuplus Integrated Distribution Logistics System', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'ESRI ArcLogistics', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Fleet management software', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Flow chart software', 43232101, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Four Soft 4S eLog', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Four Soft 4S VisiLog', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Graphics software', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'IntelliTrack 3PL', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Inventory control software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Logisuite Enterprise', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Logisuite Forwarder', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Optimization software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Oracle E-Business Suite Logistics', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Reporting software', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Spreadsheet software', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Warehouse management system WMS', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Adobe Systems Adobe ActionScript', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Adobe Systems Adobe Fireworks', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Adobe Systems Adobe Flash', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Advanced business application programming ABAP', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'AJAX', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Ansible software', 43231511, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Apache Ant', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Apache Cassandra', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Apache Groovy', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Apache Hive', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Apache HTTP Server', 43232312, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Apache Kafka', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Apache Maven', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Apache Pig', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Apache Solr', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Apache Struts', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Apache Subversion SVN', 43232203, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Apache Tomcat', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Apple macOS', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Atlassian Bamboo', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Atlassian JIRA', 43232201, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'AWS Redshift', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Bash', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Blackboard', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'C#', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'C++', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'CA Erwin Data Modeler', 43232310, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Ceridian', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Chef', 43232401, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Citrix', 43232901, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Common business oriented language COBOL', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Confluence', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Customer information control system CICS', 43232313, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Delphi Technology', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Drupal', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Dynamic hypertext markup language DHTML', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Eclipse IDE', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Elasticsearch', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Enterprise JavaBeans', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Epic Systems', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Ext JS', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Extensible HyperText Markup Language XHTML', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Git', 43232203, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'GitHub', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Google Analytics', 43232307, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Google AngularJS', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Google Docs', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Healthcare common procedure coding system HCPCS', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Hewlett Packard HP-UX', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Hewlett Packard LoadRunner', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Hibernate ORM', 43232311, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'IBM Cognos ReportNet', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'IBM Domino', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'IBM InfoSphere DataStage', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'IBM Rational RequisitePro', 43232407, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'IBM WebSphere', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Information Builders WebFOCUS', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Integrated development environment IDE software', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'JavaScript', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'JavaScript Object Notation JSON', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Job control language JCL', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'jQuery', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'JUnit', 43232406, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'KornShell', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Marketo Marketing Automation', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'McAfee', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Medical procedure coding software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'MEDITECH software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft .NET Framework', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Active Server Pages ASP', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft ActiveX', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft ASP.NET', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft ASP.NET Core MVC', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Azure', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Business Intelligence BI', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Exchange Server', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft PowerShell', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft SQL Server Reporting Services', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Team Foundation Server', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Visual Basic Scripting Edition VBScript', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Visual Studio', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'MongoDB', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'MySQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Nagios', 43232801, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Node.js', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'NoSQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Novell GroupWise', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Oracle Agile Product Lifecycle Management PLM', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Oracle Business Intelligence Publisher', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Oracle Eloqua', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Oracle Java', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Oracle JavaServer Pages JSP', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Oracle JDBC', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Oracle PL/SQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Oracle Solaris', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Oracle Taleo', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Oracle WebLogic Server', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Perforce Helix software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'PostgreSQL', 43232311, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Practical extraction and reporting language Perl', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Python', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Red Hat Enterprise Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Red Hat WildFly', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Relational database management software', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Ruby', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Ruby on Rails', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Salesforce software', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Scala', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Selenium', 43232406, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Shell script', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Splunk Enterprise', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Spring Framework', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Supervisory control and data acquisition SCADA software', 43232608, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Swift', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Symantec', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Teradata Database', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Transact-SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Trimble SketchUp Pro', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Ubuntu', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Unified modeling language UML', 43232407, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'UNIX', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Veritas NetBackup', 43233415, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Virtual private networking VPN software', 43233204, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Wireshark', 43232801, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Active Network EventRegister', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Adobe Systems Adobe Creative Cloud', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Certain', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Convention Industry Council CIC APEX Toolbox', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Dean Evans &'||' Associates EMS Professional', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Delphi Discovery', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Delphi Technology', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Geographic information system GIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Google Docs', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'IBM Lotus Notes', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Lenos', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Marketo Marketing Automation', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'MeetingMatrix International', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'MemberClicks COMPLETE', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Microsoft Dynamics', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'NSF Hospitality Rendezvous Events', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Oracle Eloqua', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Planstone', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Spreadsheet software', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Trimble SketchUp Pro', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Adobe Systems Adobe PageMaker', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'AudienceView Ticketing', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Blackbaud eTapestry', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Blackbaud Luminate CRM', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Constant Contact', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Corel CorelDraw Graphics Suite', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Foundatino Directory Online (FDO)', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Microsoft Dynamics', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'SofterWare DonorPerfect', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Tessitura Network Tessitura Software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Twitter', 43233504, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'WealthEngine Findwealth', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Actuarial Systems Corporation AIM', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Actuarial Systems Corporation Compliance Testing System', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Actuarial Systems Corporation Defined Benefit System', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Actuarial Systems Corporation Document Generation and Management System', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Actuarial Systems Corporation DV Direct', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'ADP Enterprise eTime', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Apex Business Software iBenefits', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Ascentis Employee Self-Service', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Ascentis HR', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Bargaining Power', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'BEMAS PayDirect', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Benaissance COBRApoint', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'BenAssist', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Benefit Plan Systems Corporation The Plan Administrator', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Benefit Software Fringe Facts', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'BenefitFocus HR in Touch', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'BeneLink Connect', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Benelogic', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'BeneXL Technologies Pension Administration System', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Byrne Software Technologies Visual HCS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Callidus TrueComp', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Ceridian', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Clayton Wallis CompGeo Online Professional Forecast Library', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'DataPath dpiSuite', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Document management system software', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Ebenefits Solutions Benefits Management', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Employee self-service software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Halogen eCompensation', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Healthcare common procedure coding system HCPCS', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Human resource information system HRIS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Humanic Design Employmee Self-Service', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Humanic Design Human Resources Management System', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'IBM Cognos', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Incentive management system software', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'InfinityHR', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Kronos Workforce Timekeeper', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Lawson ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Lynchval Systems Lvadmin', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Lynchval Systems Lvval', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Lynchval Systems Lvxact', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Medical condition coding software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Medical procedure coding software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'NPKTools Comp Analytics', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'NPKTools CompXpert', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'O*NET OnLine', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'OnQue Technologies COBRA OnOne', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Oracle E-Business Suite Human Resources Management System', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Project planning software', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Relational database management software', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Sage Abra', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Salary.com', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'SAP ERP Human Capital Management', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'SBC Systems Benefits Workstation', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Stroud &'||' Associates Employee Benefits Administration System', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Survey Sense', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Synygy', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Transcend Technologies Group benefitsCONNECT', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Travis Software TravisFlex', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Ultimate Software UltiPro Workplace', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Vebnet FIX&'||'FLEX', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Virtual Benefits Administrator', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Vitech Systems Group V3 Benefits Administration System', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'VUE Benefits Manager', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'VUE Compensation Management', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Watson Wyatt CompQuest On-Line', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Watson Wyatt Global Grading System', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Watson Wyatt Reward', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Workscape Outsourced Employee Benefits Administration', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Xactly Compel', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Adobe Systems Adobe ActionScript', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Adobe Systems Adobe AfterEffects', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Adobe Systems Adobe Authorware', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Adobe Systems Adobe Captivate', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Adobe Systems Adobe Creative Cloud', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Adobe Systems Adobe Fireworks', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Adobe Systems Adobe Flash', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Adobe Systems Adobe Presenter', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Advanced business application programming ABAP', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Alchemy Systems SISTEM', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Apple Final Cut Pro', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Articulate Rapid E-Learning Studio', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Backbone.js', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Beeline Learning Management System LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Blackboard', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Blatant Media Absorb LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Brainshark Rapid Learning', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Cisco Systems WebEx', 43233502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Citrix', 43232901, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Cobent Learning and Compliance Suite LCS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Computer Generated Solutions Learning Management System', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'dominKnow Learning Center', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Drupal', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Eedo Knowledgeware Eedo Force Ten', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'ElearningForce JoomlaLMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Epic Systems', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'EZ LCMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'FlexTraining Total e-Learning Solution', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'G-Cube Solutions Wizdom Web LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'GeoMetrix Data Systems Training Partner', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Halogen eLMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'HP Trim', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'ICS Learning Group Inquisiq EX', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Ikonami AT-Learning Tool', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Inspired eLearning iLMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Intelladon Enterprise Knowledge Platform EKP', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Intelligent Information Conversion Technologies MeritScholar', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Intellum Rollbook', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Interwoven software', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'JavaScript', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Learn HQ Activate LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Medworxx Learning Management System', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Microsoft Dynamics', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Microsoft NetMeeting', 43233502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'MySQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Mzinga On-Demand Learning Suite', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'NetDimensions Enterprise Knowledge Platform EKP', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'OnPoint Digital OnPoint Learning &'||' Performance Suite', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Operitel LearnFlex', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Oracle PL/SQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Oracle Solaris', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Oracle Taleo', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Oracle WebLogic Server', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Pathlore LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Plateau Learning Management System LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Prezi', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'PRO-ductivity Systems Compliance Training Manager Web', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Qarbon ViewletBuilder Professional', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Right Reason Technologies RightTrack', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'RISC Virtual Training Assistant', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'SkillSoft SkillPort', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'SumTotal Systems ToolBook', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'SumTotal Systems TotalLMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'techniques.org knowledgeWorks LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Telania eLeaP Learning Management System LMS/LCMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'The Human Equation InSite LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'TrainCaster LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'TrainOnTrack Learning Management System LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Upside Learning UpsideLMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Xerceo Learn', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Xyleme Learning Content Management System LCMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Ziiva Prosperity LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', '37Signals Basecamp', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'AcaStat Software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Adaptive conjoint analysis ACA software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Adobe Systems Adobe ActionScript', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Adobe Systems Adobe AfterEffects', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Adobe Systems Adobe Creative Cloud', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Adobe Systems Adobe Fireworks', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Adobe Systems Adobe Flash', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Adobe Systems Adobe Flash Player', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Adxstudio, for Microsoft', 43232201, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'AndersonBell Abstat', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Apache Hive', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Apache Pig', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Apple Final Cut Pro', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Apple macOS', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Aprimo Marketing', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Cascading Style Sheets CSS', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'ClassApps SelectSurveyASP', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Cytel LogXact', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Cytel Software XLMiner', 43232307, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Data analysis software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Delphi Technology', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Digivey software (expert system feature)', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Digivey software (point of sale feature)', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Drupal', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Dynamic hypertext markup language DHTML', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Extensible HyperText Markup Language XHTML', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Factiva', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'FedBizOps', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Financial planning software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Galilee Enterprise TargetPro', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Geographic information system GIS marketing software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'GLOBE Claritas', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'GMI NET-MR', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Google AdWords', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Google Analytics', 43232307, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Google Docs', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'IBM IMS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'IBM Intelligent Miner', 43232307, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Insightful Corporation Confirmit', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Insightful S-PLUS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Intellimed', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'JavaScript', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'LinkedIn', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'LogiXML Ad-HOC', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Map Maker', 43232301, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Marketo Marketing Automation', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Medstat/INFORUM', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Mintel Reports', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'MySQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'NCR Teradata Warehouse Miner', 43232307, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Neoforma Healthcare Products Information Services HPIS Market Intelligence', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Oracle Darwin', 43232307, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Oracle Eloqua', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Palisade StatTools', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Perseus SurveySolutions', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Presentation software', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Provalis Research Simstat', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Sage ACT!', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Salesforce software', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Sawtooth Choice-Base Conjoint CBS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Sawtooth Composite Product Mapping CPM', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Sawtooth SSI Web', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'StatPac', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Survey software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Symantec', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'TechExcel ServiceWise', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Teradata Database', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Thomson Dialog', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Thomson Financial Investext', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'TNS MarketWhys', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'TNS Miriad', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'TranspoLink BidLeads', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'UNISTAT Statistical Package', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Vantage MCIF', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Verispan Patient Parameters', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Walmart Retail Link', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'WinCross', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'WorldAPP KeySurvey Suite', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1161.00', 'YouTube', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Abraxas Energy Consulting Metrix', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'ACCA Manual J', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Architectural Energy Corporation ENFORMA Building Diagnostics', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Architectural Energy Corporation REM/Rate', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'C++', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Computer aided design CAD software', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Cool Roof Calculator', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Customer relationship management CRM software', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'dBASE', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'DesignBuilder Software DesignBuilder', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'EffTec EffTrack', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Ekotrope RATER', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Elite Software Energy Audit', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Enercom Energy Depot for Business', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Enercom Energy Depot for Homes', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Energy Efficient Rehab Advisor', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'EnergyPlus', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'ESRI ArcGIS', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Facility Energy Decision Systems FEDS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Federal Renewable Energy Screening Assistant FRESA', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Fielding Data Labs OptoMizer', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Fundamental Objects foAudits', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Good Steward Software EnergyCAP', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Home Energy Efficient Design HEED', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'InterEnergy Software Building Energy Analyzer PRO', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Itron Enterprise Energy Management EEM Suite', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Microsoft .NET Framework', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Microsoft Visual FoxPro', 43232311, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'MotorMaster+', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Onset Computer Corporation HOBOware', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Performance Systems Development TREAT', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Program for Energy Analysis of Residences PEAR', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Psychrometric chart software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Python', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'REScheck', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Retrofit Energy Savings Estimation Model RESEM', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Salesforce', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Snugg Home Snugg Pro', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'The Weatherization Assistant', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Trane TRACE', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'UNIX', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Wolfram Research Mathematica', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'AccessData FTK', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Adobe Systems Adobe ActionScript', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Adobe Systems Adobe ColdFusion', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Advanced business application programming ABAP', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'ArcSight Enterprise Threat and Risk Management', 43233701, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'C', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'C#', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'C++', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Chinotec Technologies Paros', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Cisco Systems CiscoWorks', 43232804, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Citrix', 43232901, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Customer information control system CICS', 43232313, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'e-fense Helix3', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Enterprise JavaBeans', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Firewall software', 43233204, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Guidance Software EnCase Forensic', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Hewlett Packard HP-UX', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'IBM Informix', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Intrusion prevention system IPS', 43233203, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'JavaScript', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Kismet', 43233204, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Live memory collection software', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'McAfee', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Metasploit', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Microsoft .NET Framework', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Microsoft Windows PowerShell', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'MySQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Nessus', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Nmap', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Oracle Java', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Oracle Java EE', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Oracle JavaServer Pages JSP', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Oracle Solaris', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Photo editing software', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Physical access management software', 43232603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Practical extraction and reporting language Perl', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Python', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Ruby', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Secure web gateway software', 43232912, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Social networking software', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Splunk Enterprise', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Symantec', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Symantec PGP', 43233204, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Tivoli', 43232901, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'TrueCrypt', 43233204, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'UNIX', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Videoconferencing software', 43233502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Virtual private networking VPN software', 43233204, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Volatile Systems Volatility', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Wireshark', 43232801, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Automated commercial environment software ACE', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Automated system for customs data ASYCUDA', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Customs records databases', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Electronic data interchange EDI software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Materials requirement planning MRP software', 43231506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Optical character reader OCR software', 43232111, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Parts classification databases', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.03', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.03', 'SAP Customs Management', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Tariff databases', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Actuate BIRT', 43232314, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Atlassian JIRA', 43232201, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Business continuity software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'CA Clarity PPM', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Computer operating systems', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Confluence', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'COOP Systems myCOOP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'EMC RSA Archer Business Continuity Management', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Emergency notification system software', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Enterprise backup systems', 43233415, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Jaspersoft Business Intelligence Suite', 43232314, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Local area network LAN software', 43232905, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Microsoft Office SharePoint Server MOSS', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'MIR3 Intelligent Notification', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'RecoveryPlanner RPX', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Strategic BCP ResilienceONE', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Sungard Assurance', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'SunGard NotiFind', 43233002, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Virtual Corporation Sustainable Planner', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Autodesk Revit', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Geographic information system GIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Google Analytics', 43232307, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Life cycle assessment LCA software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Online database search and retrieval software', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'PE INTERNATIONAL GaBi software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'PE INTERNATIONAL SoFi software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'PRe Consultants SimaPro', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Quark', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Adobe Systems Adobe Fireworks', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'AJAX', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Apache Solr', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Apache Struts', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Apple macOS', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Bing Ads', 43231514, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Bing for Power BI', 43232307, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Blogging software', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'C#', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'CCBill', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Content management systems CMS', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Drupal', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Dynamic hypertext markup language DHTML', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'e-check software', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Enterprise JavaBeans', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Extensible HyperText Markup Language XHTML', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Financial accounting software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Google AdWords', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Google Analytics', 43232307, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Google Checkout', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'IBM Digital Analytics', 43232314, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'IBM Domino', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'IBM InfoSphere DataStage', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'IBM WebSphere', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Intuit QuickBoooks Payments', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Inventory tracking software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'JavaScript', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'jQuery', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'LAMP Stack', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Magento Analytics', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Microsoft .NET Framework', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Microsoft Dynamics', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Microsoft Visual Studio', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Mobile application software', 43233508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'MyCommerce RegNow', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'MySQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Oracle Java', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Oracle JavaServer Pages JSP', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'PayPal', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'PayPal Here', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'ProPay', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Relational database management software', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Search engine marketing SEM software', 43231514, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Search engine optimization SEO software', 43232314, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Search engine results pages SERP software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Shipment processing software', 43231515, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Snorasson Holdings CCNow', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Square', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Twitter', 43233504, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Webtrends software', 43231514, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'WordPress', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-1199.06', 'YouTube', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', '1099 ProsSoftware', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Abacus Tax', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Accountants Templates JAZZ-It!', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Accounting compliance software', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Accounting fraud detection software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Accounts payable software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Accounts receivable software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'ACCUCert', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Accurate NXG', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'AcornSystems Corporate Performance Management', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'AcorynSystems Activity Based Costing/Management ABC/M', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'AdaptaSoft CyberPay', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'ADP Super Report Writer', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Advanced Micro Systems 1099-Etc', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'American Riviera Magtax', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Asset management software', 43231508, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'ATX Total Accounting Office', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'ATX Total Engagement Office', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'ATX Total Tax Office', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'AuditWare', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Automation Counselors municiPAL', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Avalara AvaTax ST', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Best MIP Fund Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Best Software CPAPayroll', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Billing software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'BNA Estate and Gift Tax Suite', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'BNA Income Tax Planning Solutions', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'BNA Sales and Use Tax Rates and Forms', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Brentmark Estate Planning Quickview', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Cammack Computations Inter-Est', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Cartesis ES Magnitude', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Cartesis Magnitude iAnalysis', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'CCH ProSystem fx TAX', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'CCIS AccountAbility', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Cost accounting software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'CPSI EHR System', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Creative Solutions UltraTax 1040', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'CYMA IV Accounting for Windows', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Delphi Technology', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Document management system software', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Epic Systems', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Estate planning software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Evron Computer Systems SAGE PFW (Platinum For Windows)', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Exact Software Macola ES', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'eXtensible Business Reporting Language XBRL', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Financial reporting software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Financial statement software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Fixed-assets depreciation software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'FLS eDP PAYROLLtax', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'FRx Software Microsoft FRx', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'General ledger software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'H&'||'R Block Tax', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Healthcare common procedure coding system HCPCS', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Heron CrossTie General Ledger', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'IDMS Account Ability', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Income tax return preparation software', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Intrax ProcedureNet', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Intuit Lacerte', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Intuit ProSeries', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Intuit QuickBooks Premier', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Intuit TurboTax', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Invoice software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Iron Mountain Accutrac Records Management Software', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'KPB Associates TaxStream', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Lead Activity Analyzer', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Lead Business Analyzer', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Medical condition coding software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Medical procedure coding software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'MEDITECH software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'MethodWare ProAudit Advisor', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Micronetics Xpert Write-up', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Microsoft Dynamics NAV', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Microsoft Dynamics SL', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Microsoft Exchange Server', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Microsoft FRx', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Multiview Accounts Receivable', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'New Millennium Communications Genesis Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'NewPortWave Year End Solutions', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'OmniRIM Records Management Suite', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Orrtax Software IntelliTax Business for Windows', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Orrtax Software IntelliTax Classic', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'OSI TrustWise', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Paisley AutoAudit', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Paisley Cardmap', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Paisley Focus Control Assurance', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Paisley IssueTrack', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Paisley RiskNavigator', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Payroll software', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Pentana audit work system PAWS', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Practice management software PMS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Pro Systems Client Write-Up System for Windows', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Profit Developers Electronic File Interchange', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'PROPHIX Enterprise', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Roundtable Software Advantage Accounting System', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'RSM McGladrey Advanced Practice Solutions Paperless Audit', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'RSM McGladrey Auditor Assistant', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Sage 300 Construction and Real Estate', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Sage Abra HRMS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Sage BusinessWorks', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Sage CPAAccounts Payable', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Sage CPAAccounts Receivable', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Sage CPAClient Checkbook', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Sage CPADocument Manager', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Sage ERP Accpac', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Sage MAS 200', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Sage MAS 500', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Sage Platinum for Windows PFW', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'SAP BusinessObjects Data Integrator', 43232403, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Softrax Revenue Management', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Summit Software Summit Biofuels Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Swift', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Sync Essentials Trade Accountant', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Tax compliance property tax management software', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Thomson GoSystem Tax', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Tumbleweed SecureTransport', 43232313, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'UA Business Software Professional Edition', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Universal Tax Systems TaxWise', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Yardi', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Yardi Systems Yardi Enterprise', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Accounting compliance software', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Accounting fraud detection software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'ACL Audit Exchange', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'ACL Business Assurance Analytics', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Arbutus Analyzer', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Audit management software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Audit planning and control environment software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'AuditWare', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'AuditWare CaseWare Examiner', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Automated auditors fraud detector software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Bi3 Audit Intelligence', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Bi3 Financial Statement Fraud Analysis', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'BizBench', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'BNA Corporate Tax Audit Analyzer', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Brentmark Estate Planning Quickview', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Cammack Computations Inter-Est', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'CaseWare International IDEA', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'CaseWare International IDEA SmartAnalyzer', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'CaseWare Working Papers', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'CashFlow Guardian', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Cebos MQ1 Audit System', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Choice Technologies PowerBill +', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Client billing software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Corel WordPerfect Office Suite', 43231513, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Corporate Responsibility System Technologies Limited Compliance Positioning System', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'D''Arcangelo Galileo', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Data extraction software', 43232307, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Datavantage', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Digital analysis tests and statistics DATAS for Excel', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Digital analysis tests and statistics DATAS for SAS', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Financial Competence', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'FLS eDP PAYROLLtax', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Google Docs', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Google Sheets', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Google Slides', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Guidance Software EnCase Enterprise', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Healthcare common procedure coding system HCPCS', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'IAD Audit Leverage', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'InformationActive ActiveData for Excel', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Internal audit software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Intrax ProcedureNet', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Kirix ProffiPoint', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Lawson ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Lumigent Entegra', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Medical condition coding software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Medical procedure coding software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'MethodWare ProAudit Advisor', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Microsoft Works', 43231513, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'MRO Audit Tracker', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'OSI TrustWise', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Paisley AutoAudit', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Paisley Cardmap', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Paisley Focus Control Assurance', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Paisley IssueTrack', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Paisley RiskNavigator', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Palisade @Risk', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Pentana audit work system PAWS', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Pleier Audit Management System', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'PricewaterhouseCoopers TeamMate', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Recovery audit software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'RSM McGladrey Advanced Practice Solutions Paperless Audit', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'RSM McGladrey Auditor Assistant', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Sage HandiSoft HandiLedger', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Sageworks ProfitCents', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Sampson Data Pattern Index software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Solutions Technology &'||' Software HR Premier', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Spreadsheet software', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Star Software Fixed Asset Depreciation', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Star Software Materiality Calculator', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Symantec', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Tax compliance property tax management software', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'TechSmith Camtasia', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Thomson Creative Solutions Engagement CS', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Thomson Creative Solutions Financial Analysis CS', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Thomson PPC e-Tools Suite', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Thomson Reuters Risk Management', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'TimeValue software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'TopCAATs', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'TrendTracker Compliance Solution', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Tropics', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'UNIX', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'WizSoft WizRule', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'WizSoft WizWhy', 43232307, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2011.02', 'WorkForce Software EmpCenter Time and Attendance', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'a la mode Pocket TOTAL', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'a la mode WinTOTAL', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Apex IV Assessor', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Apex IV Fee Appraiser', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Apex MobileSketch', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Ascend Property Assessment', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Bradford ClickFORMS', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Bruno Realty eNeighboorhoods', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Business Management Systems Municipal Geographic Management System MGMS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Compass Municipal Services CAMAlot', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Computer assisted mass appraisal CAMA software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Concierge Systems Report Concierge', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Emerald Data Deed-Chek', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'eTrac', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'FBS Data Systems Flexmls', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'GCS Property Assessment and Tax Billing', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Geomechanical design analysis GDA software', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Govern Software GovMap', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Govern Software Land and Permits Management System', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Greenbrier Graphics Deed Plotter', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Hansen CAMA', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Howard and Friends Computer CMA Plus', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'HP 49G+ Appraiser Fee Calculator', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Informatik MapDraw Deed Mapper', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Manatron CustomCAMA', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Manatron MVP Tax', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Manatron ProVal Plus', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Mass appraisal records system MARS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'MicroSolve CAMA', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Modellium PariTOP', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Multiple listing service software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Online title search and property report software', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Real Edge', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'RealData Comparative Lease Analysis', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Realty Tools Toolkit for Market Share', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'REI Wise Commercial', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'RPIS Silent CMA', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Softree Technical Systems Terrain Tools', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'TietoEnator ProMatch', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'ValueTech Report Builder', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Visual PAMSPro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Wilson''s Computer Applications RealEasy Appraisals', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Wilson''s Computer Applications RealEasy Photos Plus', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.01', 'WinGap', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'a la mode Pocket TOTAL', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'a la mode WinTOTAL', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'ACI Appraiser''s Choice', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Apex IV Assessor', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Apex IV Fee Appraiser', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Apex MobileSketch', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Ascend Property Assessment', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Bradford ClickFORMS', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Bruno Realty eNeighboorhoods', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Business Management Systems Municipal Geographic Management System MGMS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Computer assisted mass appraisal CAMA software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Concierge Systems Report Concierge', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Construction Management Software ProEst', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Cost estimation software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'CPR International GeneralCOST Estimator', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'CPR Visual Estimator', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Emerald Data Deed-Chek', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'eTrac', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'FBS Data Systems Flexmls', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'GCS Property Assessment and Tax Billing', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Geomechanical design analysis GDA software', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Govern Software GovMap', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Govern Software Land and Permits Management System', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Greenbrier Graphics Deed Plotter', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Hansen CAMA', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Howard and Friends Computer CMA Plus', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'HP 49G+ Appraiser Fee Calculator', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Informatik MapDraw Deed Mapper', 43233506, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Manatron CustomCAMA', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Manatron ProVal Plus', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Manufacturing Technology Costimater', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Mass appraisal records system MARS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'MicroSolve CAMA', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Modellium PariTOP', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Multiple listing service software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Real Edge', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Real Estate Center Caparate Calculator', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'RealData Comparative Lease Analysis', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Realty Tools Toolkit for Market Share', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'RPIS Silent CMA', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Softree Technical Systems Terrain Tools', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'TietoEnator ProMatch', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'ValueTech Report Builder', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Visual PAMSPro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Wilson''s Computer Applications RealEasy Appraisals', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Wilson''s Computer Applications RealEasy Photos Plus', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'WinEstimator WinEst', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2021.02', 'WinGap', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Accounting software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Adaptive Planning', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Budget monitoring systems', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Budgeting, forecasting, and planning software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Business Objects Data Integrator', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Business performance management BPM software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Deltek Costpoint', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Everest Software Advanced', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Extensity MPC', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Financial reporting software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'FRx Software Microsoft Forecaster', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Graphics software', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Human resources management system HRMS', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Hyperion Enterprise', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'IBM Cognos Business Intelligence', 43232314, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'IBM Cognos Planning', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Lilly Software Associates VISUAL Enterprise', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Microsoft FRx', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Microsoft Sharepoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Microsoft Visual Basic.NET', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'NetSuite NetERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Online analytical processing OLAP software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Open Systems TRAVERSE', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Oracle PeopleSoft Enterprise', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Oracle Performance Management Suites', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'OutlookSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Payroll software', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Presentation software', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Relational database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Revelwood', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Sage Active Planner', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Sage ERP Accpac', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Sage MAS 200 ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Sage MAS 90 ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'SAP Business One', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'SAP Crystal Xcelsius', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Satori Group proCube', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Spreadsheet software', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Statistical software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Time and attendance software', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Ultimate Software UltiPro Workplace', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Valiant Vantage', 43231605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'CGI-AMS BureauLink Enterprise', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'CGI-AMS CACS Enterprise', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'CGI-AMS Strata', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Credit adjudication and lending management system CALMS', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Credit and risk analysis software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Credit fraud detection software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Dun and Bradstreet Global DecisionMaker', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'eCredit Enterprise', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Equifax Advanced Decisioning', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Equifax Application Engine', 43232201, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Equifax InterConnect', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Experian Credinomics', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Experian Detect', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Experian FraudShield', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Experian Quest', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Experian Retention Triggers', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Experian Strategy Management', 43231513, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Experian Transact SM', 43232201, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Fair Isaac Application Risk Model Software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Fair Isaac Capstone Decision Manager', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Fair Isaac Falcon ID', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Moody''s KMV CreditEdge', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Moody''s KMV Decisions', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Moody''s KMV Financial Analyst', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Moody''s KMV Risk Advisor', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Moody''s KMV Risk Analyst', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Advanced Portfolio Technologies Report Builder', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Advanced Portfolio Technologies Simulator', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Analyse-it', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'AnalyzerXL', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Annuities analysis software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Apache Hive', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Apache Pig', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Apple AppleWorks', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Aspen Graphics', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'BizBench', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'BizPricer', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Business Forecast Systems Forecast Pro', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Corel QuattroPro', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'dailyVest Investment Personalization Platform', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Data visualization software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'DealMaven Comparable Company Valuation Analysis', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'DealMaven M&'||'A Accretion/Dilution One-Pager', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'DealMaven Modeling ToolPack for Excel', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'DealMaven PresLink for PowerPoint and Word', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Decisioneering Crystal Ball', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Delphi Technology', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Derivatives Imagine Trading System', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Derivicom FinOptions XL', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Economic forecasting software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Epic Systems', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Experian Credinomics', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Express Business Valuations', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Financial modeling software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'FinEng Solutions PerfoRM', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'FinEng Solutions Quantis', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Fractal pattern analysis software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Genetic algorithm optimization software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Genetic algorithm software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Harland Financial Solutions DecisionPro', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Healthcare common procedure coding system HCPCS', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'I-flex Solutions Reveleus Investment Performance Measurement', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'IBM Lotus 1-2-3', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'IBM Lotus Approach', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Innova Financial Solutions Derivatives Expert', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Ivorix Neurostrategy Finance', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Keypoint DataDesk', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Leading Market Technologies EXPO', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Longview Consolidation', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Longview Performance Management Platform', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Longview Solutions Khalix', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Market forecast software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Marketo Marketing Automation', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Mathematical software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Matheny Pattern Forecaster Plus', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Medical condition coding software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Medical procedure coding software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'MEDITECH software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'MergerStat Control Premiums', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'MergerStat Price to Earnings Ratios', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Microsoft Exchange Server', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Microsoft Office SharePoint Server MOSS', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'MoneySoft Corporate Valuation', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Monte Carlo simulation software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Montgomery Investment Technology Bonds XL', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Montgomery Investment Technology Exotics XL', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Montgomery Investment Technology FinTools', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Montgomery Investment Technology Options XL', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Montgomery Investment Technology QuoteTools', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Montgomery Investment Technology Risk XL', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Montgomery Investment Technology SigTools', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Montgomery Investment Technology Utility XL', 43232105, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Moss Adams Profit Mentor', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Mutual fund analysis software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Neural network modeling software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'NeuroSolutions for MatLab', 43231511, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'NeuroSolutions Trading Solutions', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'OptionVue Options Analysis', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Palisade Bond @nalyst', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Palisade Evolver', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Palisade StatTools', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Pattern recognition software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Peer-to-Peer Financial Analysis', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Perforce Helix software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Pi Blue OptWorks Excel', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Portfolio management software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Pricing software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Quantifying marketability discount QMD modeling software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Report generation software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'RiskMetrics Group WealthBench', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Salesforce software', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'SAP BusinessObjects Data Integrator', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'SAS JMP', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Securities analysis software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Spreadware Business Financial Analysis', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Spreadware Business Valuator', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Spreadware Pro Forma', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'SSA Global Infinium Financial Management', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Steele Mutual Fund and Variable Annuity Expert', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'SunGard BancWare', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'SunGard Kiodex Risk Workbench', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'TechHackers Convertible Bond @nalyst', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'TechHackers Credit @nalyst', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'TechHackers Exotic @nalyst', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'TechHackers Financial @nalyst', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'TechHackers IRO @nalyst', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'TechHackers MBS @nalyst', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'TechHackers Swap @nalyst', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Teradata Database', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Tetrahex Fractal Finance', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'TickQuest NeoTicker', 43232105, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Tips Standard Securities Calculation Bond Analytics Module', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Tips Standard Securities Calculation Mortgage-Backed Analytics Module', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'TradeTools Financial Market Databases', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'TradeTools Monthly U.S. Economic Database', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Trendsetter Software ProAnalyst', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Unlimited Learning Resources Valusource Pro', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'ValuSource BIZCOMPS', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Ward Systems Group GeneHunter', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Ward Systems Group NeuralShell Predictor', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Ward Systems Group NeuroShell Trader', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Whitebirch Software Projected Financials', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Wolfram Research Derivatives', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Wolfram Research Mathematica', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Wolfram Research Mathematica Finance Essentials', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Wolfram Research Mathematica UnRisk Pricing Engine', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2051.00', 'Yardi', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'ACT! ACT4Advisors', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Advent Axys', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'AdviceAmerica AdvisorVision', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Advisory World ICE', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'ASI Client Acquisition Solution', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Asset allocation software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Automatic Data Processing ProxyEdge', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Brentmark Stock Option Risk Analyzer', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Cabinet NG CNG-SAFE', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Cheshire Financial Planning Suite', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'ComplianceMAX', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Corel QuattroPro', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'CRM Software Junxure', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'CRM Software Junxure-i', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Cygnus IncomeMax', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'DataViz Beyond Contacts', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Education planning software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'EISI NaviPlan', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'eMoneyAdvisor AdvisorPlatform', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Estate Capitol Needs Analysis', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Estate planning software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'ExpenseWatch', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'EZ-Data Client Data System', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Finance Logix Education Planner', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Finance Logix Insurance Planner', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Finance Logix Retirement Planner', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Financeware AASim', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Financeware Finance File Manager', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Financeware WealthSimulator', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Financial Planning Consultants Practice Builder', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Financial planning presentation software', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Financial planning software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Financial Profiles Profiles+ Professional', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Financial report generation software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Getting Things Done GTD software', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Host Analytics Host Budget', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Ibbotson Analyst', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Ibbotson Portfolio Strategist', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'IBM Domino', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'IBM Lotus 1-2-3', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Impact PlanLabX3', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'IMPACT Wealth Distribution Analysis', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Intuit Quicken', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Investigo', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Investment and business valuation template software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Investment tracking software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'J&'||'L Financial Planner', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'MasterPlan', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Microsoft Business Contact Manager', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Microsoft Money', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'MoneyTree Silver Financial Planner (financial analysis feature)', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'MoneyTree Silver Financial Planner (presentation feature)', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Monte Carlo simulation software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Morningstar Principia', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Needs analysis software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Net Worth Strategies Stock Opter Pro', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Optima IAS', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'PIE Technologies MoneyGuidePro', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Pimlico Software DateBk', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'PlanPlus Pro', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'PlanScan Portfolio Pathfinder', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Portfolio management software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Practice management software PMS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'ProTracker Advantage', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Redtail Technology Our Business Online', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Retirement planning software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Salesforce software', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Sawhney ExecPlan', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'ScanSoft PaperPort Pro', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'ScenarioNow RetireNow', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'SunGard Frontier', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'SunGard LockBox', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'SunGard PlanningStation', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'SunGard WebPlaid', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Swift', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Tax planning software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'The Omni Group OmniPlan', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Thomson ONE Advisor', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Torrid Retirement Planner', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Unger Software Methusaleh', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'WealthTec AllocationPro', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'WealthTec Foundations', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'WealthTec WealthMaster', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'Web Information Solutions Pocket Informant', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2052.00', 'World Software Corporation Worldox', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'Anodas Software Limited Phoenix', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'C++', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'Consilience Software Maven Insurance Automation Suite', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'CSC nbAccelerator', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'Database software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'Delphi Technology', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'Fair Isaac Enterprise Decision Management for Insurance', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'Fannie Mae Desktop Underwriter', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'FileNet Content Manager', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'Fiserv Advanced Underwriting', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'LabOne NET', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'NIIT Technologies WinRisk', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'QualCorp FormsPlus', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'RGA AURA', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'RGA Facultative Application Console', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'SIS SEMCI PARTNER', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'Skywire Software InsBridge', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'Spreadsheet software', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'Valen Technologies Risk Manager', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2053.00', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'ACL Analytics', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Auditing software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Financial compliance software', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Financial transaction analysis software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'General Examination System GENESYS', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Investigation management software', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'NILS INSource', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'ODEN Insurance Services State Rules &'||' Regulations', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Oversight Insights On Demand', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Presentation software', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'PricewaterhouseCoopers TeamMate', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Spreadsheet software', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'System for Electronic Rate and Form Filing SERFF', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Westlaw', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2061.00', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'Chat software', 43233503, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'Cooperative Processing Resources DMS Professional Suite', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'CoreLogic DebtorTrace', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'Freddie Mac Loan Prospector', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'ICCO CreditSoft', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'Integrant DebtLogic', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'LexisNexis Accurint', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'Merlin Information Services databases', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'Paragon Financial Services Paragon Financial System', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'Prime Debt Soft Debt Settlement', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'Prime Debt Software Credit Repair', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'Datatel Colleague', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'EDExpress', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'ELM Resources ELM', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'EMT Applications CounselorMax', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'Financial aid management system FAM', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'Student information systems SIS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'SunGard Higher Education Banner Financial Aid', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'Sungard Higher Education PowerFAIDS', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2071.01', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', '1003 Uniform Residential Loan Application', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Amortization loan software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Bankers Systems Rembrandt Lending System', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Bottom Line LoanMaster Loan Servicing', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'California Infinite LPS', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Calyx Point', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'CGI-AMS BureauLink Enterprise', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'CGI-AMS CACS Enterprise', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'CGI-AMS Strata', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Click1003 Online Mortgage Application', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Common business oriented language COBOL', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Credit and risk analysis software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Credit fraud detection software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Credit underwriting software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Customer information control system CICS', 43232313, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Delphi Discovery', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Dun and Bradstreet Global DecisionMaker', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Dynamic Loanledger', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'eCredit Enterprise', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Ellie Mae Contour', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Ellie Mae Genesis', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'eOriginal eCore Business Suite', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Equifax Advanced Decisioning', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Equifax Application Engine', 43232201, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Equifax InterConnect', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Experian Credinomics', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Experian Detect', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Experian FraudShield', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Experian Quest', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Experian Retention Triggers', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Experian Strategy Management', 43231513, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Experian Transact SM', 43232201, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Fair Isaac Application Risk Model Software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Fair Isaac Capstone Decision Manager', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Fair Isaac Falcon ID', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Fannie Mae Desktop Underwriter', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'FAS Loan Service Plus', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Financial Industry Computer Systems Loan Accountant', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Financial Industry Computer Systems Loan Originator', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Financial Industry Computer Systems Loan Producer', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Freddie Mac Loan Prospector', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Harland Financial Solutions DecisionPro', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Harland Interlinq MortgageWare', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'IA Systems StreamLend', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Indus Lending Solutions', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Integra Destiny Loan Origination', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'LA PRO Loan Administrator Pro', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Loan application processing software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Loan origination software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Microsoft Dynamics', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Moody''s KMV CreditEdge', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Moody''s KMV Decisions', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Moody''s KMV Financial Analyst', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Moody''s KMV Risk Advisor', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Moody''s KMV Risk Analyst', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Opportunity management system OMS', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Plimus Loan Artist', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'QuikDraw Loan Management System', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'RealBenefits Amortization Loan', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Technicost LOS', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'The Mortgage Office Loan Origination', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'The Mortgage Office Loan Servicing', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'VueCentric MortgageDashboard', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'White Clarke North America Credit Adjudication and Lending Management', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2072.00', 'Wolters Kluwer Financial Services ComplianceOne', 43232606, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2081.00', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2081.00', 'Automated tax system software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2081.00', 'Document management system software', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2081.00', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2081.00', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2081.00', 'Image processing systems', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2081.00', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2081.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2081.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2081.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2081.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2081.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2081.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2081.00', 'Online databases', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2081.00', 'Optical character recognition OCR software', 43232111, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2081.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2081.00', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2081.00', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'ACI TaskTracker', 43231507, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'ATX Total Accounting Office', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'ATX Total Tax Office', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'CCH ProSystem fx TAX', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Creative Solutions CPA Depreciation', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Creative Solutions UltraTax CS', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Datagroup ElectroFile 1040', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Datagroup ElectroFile ELF', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Datagroup ElectroFile ST', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Datair Employee Benefits Systems', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Electronic ToolKit for Tax Preparers', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'ExacTax PackageEX', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Greatland Corporation Winfiler', 43231505, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'GreatTax', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Intuit ProSeries', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Intuit Quicken', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Kleinrock Publishing', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'LaCerte 1040 Tax Analyzer', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Laserfiche Avante', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'M8 Client Billing', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Orrtax Software IntelliTax', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Petz Enterprises V-Tax', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Sage 50 Accounting', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Sales Tax Tools Sales Tax Researcher', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'ScheduleVIEW', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Sungard Relius', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Sync Essentials Trade Accountant', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Thomson GoSystem MyTaxInfo', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Thomson Reuters UltraTax CS', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Universal Tax Systems TaxWise', 43231603, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2082.00', 'Web page creation and editing software', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'Bloomberg Professional', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'C++', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'IBM Cognos Business Intelligence', 43232307, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'Insightful S-PLUS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'JavaScript', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'Microsoft Visual Basic for Applications VBA', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'Microsoft Visual C#', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'MicroStrategy Desktop', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'Practical extraction and reporting language Perl', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'Python', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'UNIX', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.01', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Apache Hive', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Apache Pig', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Aptech Systems GAUSS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'C++', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Factiva', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Insightful S-PLUS', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'McAfee', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Practical extraction and reporting language Perl', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Ruby', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'S&'||'P Capital IQ', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Standard &'||' Poor''s Capital IQ Compustat', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Teradata Database', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'UNIX', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.02', 'Wolfram Research Mathematica', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.03', 'Bloomberg Professional', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.03', 'Email software', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.03', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.03', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.03', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.03', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.03', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.03', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.03', 'Moody''s KMV CreditEdge', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.03', 'Moody''s RiskCalc', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.03', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'ArcSight Enterprise Threat and Risk Management', 43233701, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Bookkeeping software', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Business intelligence software', 43232314, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Electronic health record EHR software', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Guardian Analytics FraudMAP', 43232314, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'IBM Cognos', 43232314, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'PCG Software Virtual Examiner', 43231516, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Splunk Enterprise', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Symantec', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'TIBCO Spotfire', 43232314, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'TriZetto QNXT', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('13-2099.04', 'Vertafore ImageRight', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Ada', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Advanced numerical software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Algorithmic software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Apache Cassandra', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Apache Flume', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Apache Hive', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Apache HTTP Server', 43232312, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Apache Kafka', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Apache Pig', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Apache Solr', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Augmint', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Automated document generation software', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'AWS Redshift', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Bash', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'C', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'C#', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'C++', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'CA Erwin Data Modeler', 43232310, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Charm++', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Clustering software', 43232302, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Clustermatic', 43232302, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'CMAKE', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Computational statistics software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Computer aided design and drafting CADD software', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Data mining software', 43232307, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Data visualization software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Django', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Doxygen', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Eclipse IDE', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Eiffel', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Elasticsearch', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Embarcadero JBuilder', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Extensible stylesheet language transformations XSLT', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Formula translation/translator FORTRAN', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Git', 43232203, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'GitHub', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Google AdWords', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Google Analytics', 43232307, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Graphics pipelines', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Greenhills Ada compilers', 43232409, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'High-performance software libraries', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'IBM Domino', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'IBM InfoSphere DataStage', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'IBM Rational Apex', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'IBM Rational Rose', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Integrated development environment IDE software', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Intel Integrated Performance Primitives', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Intel Math Kernel Library', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'JavaScript', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'List processing language LISP', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Low-level virtual machine LLVM compilers', 43232409, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Mathematical software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Microsoft ActiveX', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Microsoft Azure', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Microsoft Visual Basic.NET', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Microsoft Visual C# .NET', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Microsoft Visual Studio', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Microsoft Visual Studio.NET', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Microsoft Windows XP', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'MongoDB', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Multisensory data representation software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'MySQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'National Instruments LabVIEW', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'NoSQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Object oriented development environment software', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Open Graphics Library OpenGL', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Optimization software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Oracle DBMS', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Oracle Java', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Oracle Solaris', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Parallel systems software', 43232302, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Perforce Software Configuration Management System', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Plug-in file software', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Polaris parallelizing compilers', 43232409, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Polhemus Fasttrack System', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'PostgreSQL', 43232311, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Practical extraction and reporting language Perl', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Prolog', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'PTC Creo Parametric', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Python', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Relational database management software', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Relational database management system software', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Rice Simulator for ILP Multiprocessors RSIM', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Ruby', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Scala', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Shell script', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Simulation software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Software libraries', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Source code management SCM software', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Splunk Enterprise', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Sun Microsystems Java 2 Platform Enterprise Edition J2EE', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Sun Microsystems Solaris', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Teradata Database', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Three-dimensional 3D graphics software', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Ubuntu', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Unified modeling language UML', 43232407, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'UNIX', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Verilog', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Video editing software', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'VME PowerPC VxWorks', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1111.00', 'Waikato Environment for Knowledge Analysis Weka', 43232404, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Access management software', 43232901, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'AcmeStudio', 43232407, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Active directory software', 43232704, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Ada', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Adobe ColdFusion', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Adobe Systems Adobe ActionScript', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Adobe Systems Adobe Fireworks', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Adobe Systems Adobe Flash', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Adobe Systems Adobe Flex', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Advanced business application programming ABAP', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'AJAX', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Ansible software', 43231511, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Apache Ant', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Apache Cassandra', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Apache Groovy', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Apache Hive', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Apache HTTP Server', 43232312, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Apache Kafka', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Apache Maven', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Apache Pig', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Apache Solr', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Apache Struts', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Apache Subversion SVN', 43232203, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Apache Tomcat', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Apple macOS', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Application management software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Architecture description language ADL', 43232407, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Atlassian Bamboo', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Atlassian JIRA', 43232201, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Automated installation software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'AWS Redshift', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Backbone.js', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Bash', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Blackboard', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Business intelligence system software', 43232314, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'C', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'C#', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'C++', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'CA Erwin Data Modeler', 43232310, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Cascading Style Sheets CSS', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Chef', 43232401, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Cisco Systems CiscoWorks', 43232804, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Citrix', 43232901, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Common business oriented language COBOL', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Compatibility testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Component object model COM software', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Computer aided design and drafting CADD software', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Confluence', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Cost estimation software', 43231604, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'CrossTec NetOp Remote Control', 43232702, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Customer information control system CICS', 43232313, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Dassault Systemes CATIA', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Data conversion software', 43233402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Defect tracking software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Delphi Technology', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Diagramming software', 43232101, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Distributed component object model DCOM software', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Django', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Docker', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Drupal', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Dynamic analysis software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Dynamic hypertext markup language DHTML', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Eclipse IDE', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Eiffel', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Elasticsearch', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Electronic design automation EDA software', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Element management software', 43232804, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Embarcadero JBuilder', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Enterprise JavaBeans', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Epic Systems', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Ext JS', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Extensible HyperText Markup Language XHTML', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Flow chart software', 43232101, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Formula translation/translator FORTRAN', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Functional testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Geographic information system GIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Git', 43232203, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'GitHub', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Google Analytics', 43232307, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Google AngularJS', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Healthcare common procedure coding system HCPCS', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Help desk software', 43231501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Hewlett Packard HP-UX', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Hewlett Packard LoadRunner', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Hibernate ORM', 43232311, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Hierarchical simulation program with integrated circuit emphasis HSPICE', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'HyperSpace', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'IBM DB2', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'IBM Domino', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'IBM InfoSphere DataStage', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'IBM Rational ClearCase', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'IBM Rational ClearQuest', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'IBM Rational PurifyPlus', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'IBM Rational Rose XDE Developer', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'IBM WebSphere', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Informatica Corporation PowerCenter', 43232310, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'InstallShield', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Integrated development environment IDE software', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Integration testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Interoperability testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'J', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'JavaScript', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'JavaScript Object Notation JSON', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Job control language JCL', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'jQuery', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'JUnit', 43232406, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'KornShell', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'LAMP Stack', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Load testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Marketo Marketing Automation', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'McAfee', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'MEDITECH software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft .NET Framework', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Active Server Pages ASP', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft ActiveX', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft ASP.NET', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft ASP.NET Core MVC', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Azure', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Exchange Server', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Internet Information Service IIS', 43232313, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft PowerShell', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft SQL Server Reporting Services', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Visual Basic Scripting Edition VBScript', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Visual Basic.NET', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Visual C# .NET', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Visual FoxPro', 43232311, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Visual Studio', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Migration testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'MongoDB', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Mutation testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'MySQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Nagios', 43232801, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'National Instruments LabVIEW', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Network intrusion prevention systems NIPS', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Node.js', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'NoSQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Objective C', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Omni Group OmniGraffle', 43232101, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle Application Server', 43232701, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle Business Intelligence Suite', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle DBMS', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle Eloqua', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle Fusion Middleware', 43232403, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle Java', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle Java 2 Platform Enterprise Edition J2EE', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle JavaServer Pages JSP', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle JDBC', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle Master Data Management MDM Suite', 43232310, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle PL/SQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle Solaris', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle Taleo', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Oracle WebLogic Server', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'OrCAD Capture', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Patch and update management software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Perforce Helix software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Personal computer diagnostic software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Popkin System Architect', 43232407, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'PostgreSQL', 43232311, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Practical extraction and reporting language Perl', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Puppet', 43232401, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Python', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Rapide', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'React', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Recovery testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Red Hat Enterprise Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Red Hat WildFly', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Regression testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Relational database management software', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Remote control software', 43232702, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Requirements management software', 43232407, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Ruby', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Ruby on Rails', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Salesforce software', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'SAP Adaptive Server Enterprise', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'SAP BusinessObjects Desktop Intelligence', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'SAP Master Data Management MDM', 43232310, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'SAP NetWeaver', 43232403, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'SAP Netweaver BW', 43232403, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Scala', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Security testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Selenium', 43232406, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Shell script', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Smalltalk', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Snort', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Software asset management SAM software', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Software distribution software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'SpectraQuest', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Splunk Enterprise', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Spring Boot', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Spring Framework', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Stac Software ReachOut', 43232702, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Static analysis software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Stress testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Structure prediction software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Sun Microsystems Sun ONE', 43232313, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Supervisory control and data acquisition SCADA software', 43232608, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Swift', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Symantec', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Symantec pcAnywhere', 43232702, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Symantec Visual Cafe', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'System and data disaster recovery software', 43233415, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'System testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Systems and application deployment and migration software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Teradata Database', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Test design software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Test implementation software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Time sharing option TSO software', 43232409, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Transact-SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Ubuntu', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Unified modeling language UML', 43232407, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Unit testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'UNIX', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Usability testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Verilog', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Veritas NetBackup', 43233415, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Version control software', 43232203, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Virtual private networking VPN software', 43233203, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Virus scanning software', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Web server software', 43232313, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'WebFOCUS', 43232403, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Wireshark', 43232801, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'Wise Solutions Wise for Windows Installer', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.00', 'YouTube', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Allscripts Professional EHR', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Allscripts Sunrise Clinical Manager', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Amkai AmkaiCharts', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Bizmatics PrognoCIS EMR System', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Cerner Millennium', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Cerner PowerChart', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'ChartWare EMR', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Computer aided software engineering CASE tools', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Computerized physician order entry CPOE software', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'e-MDs software', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'eClinicalWorks', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Electronic medical administration record eMAR software', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Epic Systems', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'GE Healthcare Centricity EMR', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Healthcare management system', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'JavaScript', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Learning management system LMS', 43232502, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'McKesson ANSOS One-Staff', 43232108, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'MEDITECH Healthcare Information System HCIS', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'MEDITECH software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Mediware ClosedLoop Clinical Systems', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Mediware Information Systems MediCOE', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Medscribbler Enterprise', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'MicroFour PracticeStudio.NET EMR', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Microsoft SQL Server Reporting Services SSRS', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Netsmart Technologies CareNet', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'NextGen Healthcare Information Systems EMR', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Picis CareSuite', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Practical extraction and reporting language Perl', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Python', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Qlik software', 43232314, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Salesforce software', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'SAS software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Seimens Healthineers', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'SOAPware EMR', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Software development tools', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'StatCom Patient Flow Logistics Enterprise Suite', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'SynaMed EMR', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Texas Medical Software SpringCharts EMR', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'UNIX', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'VISICU eICU Program', 43232610, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Web browser software', 43232705, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1121.01', 'Word processing software', 43232104, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Access management software', 43232901, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'AccessData FTK', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Active directory software', 43232704, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Adobe Systems Adobe ActionScript', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Adobe Systems Adobe Flash', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Advanced business application programming ABAP', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'AJAX', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Ansible software', 43231511, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Anti-phishing software', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Anti-spyware software', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Anti-Trojan software', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Apache Ant', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Apache Cassandra', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Apache Groovy', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Apache HTTP Server', 43232312, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Apache Kafka', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Apache Maven', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Apache Pig', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Apache Solr', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Apache Struts', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Apache Subversion SVN', 43232203, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Apache Tomcat', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Apple macOS', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'ArcSight Enterprise Threat and Risk Management', 43233701, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Atlassian Bamboo', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Atlassian JIRA', 43232201, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Automated audit trail analysis software', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Automated installation software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Automated media tracking software', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Backup and archival software', 43233415, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Bash', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Berkeley Internet Domain Name BIND', 43232704, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Blackboard', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'C', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'C#', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'C++', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Check Point Next Generation Secure Web Gateway', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Chef', 43232401, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Cisco Systems CiscoWorks', 43232804, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Citrix', 43232901, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Common business oriented language COBOL', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Computer forensic software', 43233001, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Confluence', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Conformance and validation testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Cryptographic key management software', 43233204, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Customer information control system CICS', 43232313, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Delphi Technology', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Diameter', 43233201, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Django', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Docker', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Domain name system DNS', 43232704, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Eclipse IDE', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Elasticsearch', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'End-to-end encryption software', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Enterprise JavaBeans', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Epic Systems', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Ethereal', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Extensible HyperText Markup Language XHTML', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Firewall software', 43233204, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Geographic information system GIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Git', 43232203, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'GitHub', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Guidance Software EnCase Forensic', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Hewlett Packard HP-UX', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Honeypot', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'HP Fortify', 43233203, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'HP WebInspect', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'IBM Domino', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'IBM QRadar SIEM', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'IBM Tivoli Access Management TAM', 43232901, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'IBM Tivoli Identity Management TIM', 43233201, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'IBM WebSphere', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Imperva SecureSphere', 43233204, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Integrated development environment IDE software', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Integrity verification software', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Intrusion detection system IDS', 43233203, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Intrusion prevention system IPS', 43233203, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'IpFilter', 43233204, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'IpTables', 43233204, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'ISS RealSecure', 43233203, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'JavaScript', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'JavaScript Object Notation JSON', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Job control language JCL', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Juniper Networks NetScreen-Security Manager', 43233204, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Kali Linux', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Keystroke monitoring software', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'KornShell', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'LAMP Stack', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'License management software', 43231512, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Link encryption software', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'McAfee', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'McAfee VirusScan', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Metasploit', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Micro Focus OpenView', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft .NET Framework', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft Active Server Pages ASP', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft ASP.NET', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft Azure', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft Exchange Server', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft Hyper-V Server', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft PowerShell', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft Visual Basic Scripting Edition VBScript', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'MongoDB', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'MySQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Nagios', 43232801, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'National Instruments LabVIEW', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Network and system vulnerability assessment software', 43233203, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Network directory services software', 43232704, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Network intrusion prevention systems NIPS', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Network security auditing software', 43233203, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Network, hardware, and software auditing software', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Node.js', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'NoSQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Objective C', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Oracle Java', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Oracle JavaServer Pages JSP', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Oracle JDBC', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Oracle Net Manager', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Oracle PL/SQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Oracle Solaris', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Oracle WebLogic Server', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Palo Alto Networks Next-Generation Security Platform', 43233204, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Password cracker software', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Password management software', 43233201, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Patch and update management software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Penetration testing software', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Perforce Helix software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Ping Identity', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Portswigger BurP Suite', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'PostgreSQL', 43232311, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Practical extraction and reporting language Perl', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Program checksumming software', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Puppet', 43232401, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Python', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Qualys Cloud Platform', 43233203, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Quest BigBrother', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Rapid7 Nexpose', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Red Hat Enterprise Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Red Hat WildFly', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Relational database management software', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Remote authentication dial-in user service RADIUS software', 43233201, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Root kit detection software', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Ruby', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Ruby on Rails', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Salesforce', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Scala', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Secure internet filtering software', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Secure shell SSH software', 43232702, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Security incident management software', 43233203, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Security risk assessment software', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'SeleniumHQ', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Shell script', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Smart card management software', 43232611, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Sniffer Investigator', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Snort', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Splunk Enterprise', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Stack smashing protection SSP software', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Supervisory control and data acquisition SCADA software', 43232608, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Swift', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Symantec', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Symantec Blue Coat Data Loss Prevention', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Symantec Endpoint Protection', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Symantec Norton Antivirus', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'System and data disaster recovery software', 43233415, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'System testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Tcpdump', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Tenable Nessus', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Teradata Database', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Trend Micro TippingPoint', 43233204, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Ubuntu', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Unified modeling language UML', 43232407, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'UNIX', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Veritas NetBackup', 43233415, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Virtual private networking VPN software', 43233204, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Virus scanning software', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'VMWare', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Voice over internet protocol VoiP system software', 43232805, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Websense Data Loss Prevention', 43233203, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'WinMerge', 43232203, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1122.00', 'Wireshark', 43232801, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'A programming language APL', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'ABC Compiler', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'ABC: the AspectBench Compiler for AspectJ', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Ada', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Adobe Systems Adobe ActionScript', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Adobe Systems Adobe ColdFusion', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Adobe Systems Adobe Fireworks', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Adobe Systems Adobe Flash', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Adobe Systems Adobe Flex', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Adobe Systems Adobe PostScript', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Advanced business application programming ABAP', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'AJAX', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Algorithmic language ALGOL', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Amazon Kinesis', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'American National Standards Institute ANSI C', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Ansible software', 43231511, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Apache Ant', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Apache Cassandra', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Apache Groovy', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Apache Hive', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Apache HTTP Server', 43232312, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Apache Kafka', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Apache Maven', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Apache Pig', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Apache Solr', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Apache Spark', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Apache Struts', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Apache Subversion SVN', 43232203, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Apache Tomcat', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Assembler', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Atlassian Bamboo', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Atlassian JIRA', 43232201, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'AWK', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'AWS Redshift', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'B-Method', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Backbone.js', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Bash', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Basis BBx VisualPRO/5', 43232404, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Beginner''s all-purpose symbolic instruction code BASIC', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Bentley MicroStation', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Bigloo Scheme', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Bourne Shell', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'C', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'C#', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'C++', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'CA Erwin Data Modeler', 43232310, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Call-processing language CPL', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Cascading Style Sheets CSS', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'CAST SQL Builder', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Chef', 43232401, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Citrix', 43232901, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Clipper', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Code generator software', 43232409, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Code munger software', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'CoffeeCup The HTML Editor', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Collaborative Application Markup Language CAML', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Command interpreters', 43232409, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Common business oriented language COBOL', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Common Lisp Object System CLOS', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Compilers', 43232409, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Computer aided design and drafting CADD software', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Computer Associates integrated data management system CA-IDMS', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Computer On-line Real-time Applications Language CORAL 66', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Confluence', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Corel CorelDraw Graphics Suite', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Customer information control system CICS', 43232313, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Dassault Systemes CATIA', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Data definition language DDL', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Data manipulation language DML', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'dBASE Plus', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Debugging software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Decompilers', 43232409, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Delphi Technology', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Django', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Docker', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Drupal', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Dynamic hypertext markup language DHTML', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'E++ pattern language', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Eclipse IDE', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Eiffel', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Elasticsearch', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Embarcadero Delphi', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Emerald Software Group Emerald Green Office', 43232201, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Enterprise JavaBeans', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Epic Systems', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Event-driven State-machines Programming', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Ext JS', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Extensible HyperText Markup Language XHTML', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Extensible stylesheet language XSL', 43232403, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Formula translation/translator FORTRAN', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Forth', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Gambit Scheme', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Geographic information system GIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Git', 43232203, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'GitHub', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Google Analytics', 43232307, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Google AngularJS', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Graphical user interfaces GUI', 43232404, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Greatis Object Inspector', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Haskell', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Hewlett Packard HP-UX', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Hewlett Packard LoadRunner', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Hibernate ORM', 43232311, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'IBM DB2', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'IBM Domino', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'IBM InfoSphere DataStage', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'IBM Rational ClearCase', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'IBM WebSphere', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'ICON programming language', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'IEA Software Emerald', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Incremental compiler software', 43232409, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Inline code expander software', 43232409, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Integrated development environment IDE software', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Interface definition language IDL', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Interpreter software', 43232409, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Interstate connection ICON', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'J', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'JavaScript', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'JavaScript Object Notation JSON', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Job control language JCL', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'jQuery', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'JUnit', 43232406, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Just-in-time compiler', 43232409, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'KornShell', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'LAMP Stack', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'List processing language LISP', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Logo', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Low-level debugger software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'McAfee', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft .NET Framework', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Active Server Pages ASP', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft ActiveX', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft ASP.NET', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft ASP.NET Core MVC', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Azure', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft ESP SDK', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Exchange Server', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Extensible Application Markup Language (XAML)', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft FrontPage', 43232107, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft PowerShell', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Silverlight', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft SQL Server Reporting Services', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Systems Management Server', 43233701, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Visual Basic Scripting Edition VBScript', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Visual Basic.NET', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Visual C#', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Visual C# .NET', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Visual FoxPro', 43232311, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Visual Studio', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Mixed code generator', 43232409, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Modula', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'MongoDB', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'MUMPS M', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'MySQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Nagios', 43232801, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'National Instruments LabVIEW', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Network intrusion prevention systems NIPS', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Node.js', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'NoSQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Oberon', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Objective C', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Objective Caml', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'One pass compiler software', 43232409, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Oracle Java', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Oracle JavaServer Pages JSP', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Oracle JDBC', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Oracle PL/SQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Oracle Solaris', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Oracle WebLogic Server', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Partial class generator software', 43232409, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Pascal', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Perforce Helix software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'PostgreSQL', 43232311, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'PowerSoft PowerBuilder', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Practical extraction and reporting language Perl', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Programming language one PL/I', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Progress OpenEdge ABL', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Progress Sonic ESB', 43232403, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Progress WebSpeed Workshop', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Prolog', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Puppet', 43232401, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Python', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'React', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'ReCrystallize Crystal Reports', 43232305, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Red Hat Enterprise Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Red Hat WildFly', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Relational database management software', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Restructured extended executor REXX', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Retargetable compiler', 43232409, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Revision control software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Ruby', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Ruby on Rails', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'SAP Adaptive Server Enterprise', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'SAP BusinessObjects Data Integrator', 43232403, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'SAP NetWeaver BW', 43232403, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Scala', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Scheme', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Selenium', 43232406, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Self', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Shell script', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Simulation program with integrated circuit emphasis SPICE', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Smalltalk', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Snort', 43232801, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Source code editor software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Source code migration software', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Splunk Enterprise', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Spring Boot', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Spring Framework', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Stage compiler', 43232409, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'String oriented symbolic language SNOBOL', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Structured Query Report SQR', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Supervisory control and data acquisition SCADA software', 43232608, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Swift', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Symantec Visual Cafe', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Symbolic debugger software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Teradata Database', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Threaded code compiler', 43232409, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Tier generator software', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Transact-SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Ubuntu', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Unified modeling language UML', 43232407, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'UNIX', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Verilog', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Veritas NetBackup', 43233415, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Virage VS Archive', 43232202, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Virtual private networking VPN software', 43233204, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Web service definition language WDSL', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Wireshark', 43232801, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Workflow software', 43232201, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1131.00', 'Xerces2 Java Parser', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'A programming language APL', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'ABC Compiler', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'ABC: the AspectBench Compiler for AspectJ', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Ada', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'ADO.NET', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Adobe Systems Adobe ActionScript', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Adobe Systems Adobe AfterEffects', 43232103, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Adobe Systems Adobe Creative Cloud', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Adobe Systems Adobe Fireworks', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Adobe Systems Adobe Flash', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Adobe Systems Adobe Flex', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Adobe Systems Adobe Photoshop', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Advanced business application programming ABAP', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'AJAX', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Algorithmic language ALGOL', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Allaire ColdFusion', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Amazon DynamoDB', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Amazon Kinesis', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'American National Standards Institute ANSI C', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Ansible software', 43231511, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apache Ant', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apache Avro', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apache Cassandra', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apache Flume', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apache Groovy', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apache Hbase', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apache Hive', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apache HTTP Server', 43232312, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apache Kafka', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apache Maven', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apache Oozie', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apache Pig', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apache Solr', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apache Spark', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apache Struts', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apache Subversion SVN', 43232203, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apache Tomcat', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apple Final Cut Pro', 43232103, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Apple macOS', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Atlassian Bamboo', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Atlassian JIRA', 43232201, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Autodesk AutoCAD Civil 3D', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Autodesk Revit', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Automated installation software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'AWK', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'AWS Redshift', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'B-Method', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Backbone.js', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Bash', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Beginner''s all-purpose symbolic instruction code BASIC', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Bentley MicroStation', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Bigloo Scheme', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Blackboard', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'C', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'C#', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'C++', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'CA Erwin Data Modeler', 43232310, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Call-processing language CPL', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Cascading Style Sheets CSS', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Chef', 43232401, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Citrix', 43232901, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Collaborative Application Markup Language CAML', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Common business oriented language COBOL', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Common Lisp Object System CLOS', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Component object model COM software', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Component-based Scalable Logical Architecture CSLA', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Computer aided design and drafting software CADD', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Computer assisted software engineering CASE software', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Computer Associates integrated data management system CA-IDMS', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Computer On-line Real-time Applications Language CORAL 66', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Confluence', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Customer information control system CICS', 43232313, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Dassault Systemes CATIA', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Dassault Systemes SOLIDWORKS', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Data analysis software', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Data definition language DDL', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Data entry software', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Data manipulation language DML', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Defect tracking software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Delphi Technology', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Deployment software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Distributed component object model DCOM software', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Django', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Docker', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Drupal', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Dynamic analysis software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Dynamic hypertext markup language DHTML', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'E++ pattern language', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Eclipse IDE', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Eiffel', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Elasticsearch', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Embarcadero Delphi', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Embarcadero JBuilder', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Embedded systems development software', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Emerald Software Group Emerald Green Office', 43232201, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Encryption software', 43233205, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Enterprise application integration EAI software', 43232403, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Enterprise JavaBeans', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Epic Systems', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Event-driven State-machines Programming', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'EXT js', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Extensible HyperText Markup Language XHTML', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Extensible stylesheet language transformations XSLT', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Facebook', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'FileMaker Pro', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Formula translation/translator FORTRAN', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Forth', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Functional testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Fund accounting software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Gambit Scheme', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Geographic information system GIS software', 43233506, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Git', 43232203, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'GitHub', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'GNU Image Manipulation Program GIMP', 43232102, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Google AdWords', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Google Analytics', 43232307, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Google AngularJS', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Google Docs', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Google Gmail', 43233501, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Google Sheets', 43232110, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Google Slides', 43232106, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Graphical user interface GUI builder software', 43232404, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Haskell', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Healthcare common procedure coding system HCPCS', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Hewlett Packard HP-UX', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Hewlett Packard LoadRunner', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Hibernate ORM', 43232311, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'IBM DB2', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'IBM Domino', 43232902, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'IBM InfoSphere DataStage', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'IBM Middleware', 43232313, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'IBM Notes', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'IBM Rational ClearCase', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'IBM Rational ClearQuest', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'IBM Rational PurifyPlus', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'IBM Rational Requisite Pro', 43232407, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'IBM Rational Rose XDE Developer', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'IBM SPSS Statistics', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'IBM WebSphere', 43232403, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'ICON programming language', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'IEA Software Emerald', 43232306, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Integrated development environment IDE software', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Integration testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Interface definition language IDL', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Interoperability testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Interstate connection ICON', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'J', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'JavaScript', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'JavaScript Object Notation JSON', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Job control language JCL', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'jQuery', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'JUnit', 43232406, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'KornShell', 43233004, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'LAMP Stack', 43232408, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'LexisNexis', 43232309, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'LibreOffice', 43231513, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'LinkedIn', 43232107, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'List processing language LISP', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Load testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Marketo Marketing Automation', 43231514, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'McAfee', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Medical procedure coding software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'MEDITECH software', 43232610, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft .NET Framework', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Access', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Active Server Pages ASP', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft ActiveX', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft ASP.NET', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft ASP.NET Core MVC', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Azure', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Dynamics', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft ESP SDK', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Exchange Server', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Internet Information Service IIS', 43232313, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Office', 43231513, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft PowerShell', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Project', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Publisher', 43232112, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft SharePoint', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft SQL Server', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft SQL Server Reporting Services', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Visual Basic Scripting Edition VBScript', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Visual Basic.NET', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Visual C# .NET', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Visual Studio', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Windows', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Microsoft Word', 43232104, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'MicroStrategy', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Migration software', 43232915, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Migration testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Minitab', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Modula', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'MongoDB', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'MUMPS M', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Mutation testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'MySQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Nagios', 43232801, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'National Instruments LabVIEW', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Node.js', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'NoSQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Oberon', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Object Management Group Object Request Broker', 43232313, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Objective C', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Objective Caml', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Oracle DBMS', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Oracle Eloqua', 43232303, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Oracle Fusion Applications', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Oracle Hyperion', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Oracle Java', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Oracle JavaServer Pages JSP', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Oracle JDBC', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Oracle PL/SQL', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Oracle Primavera Enterprise Project Portfolio Management', 43231507, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Oracle Solaris', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Oracle Taleo', 43231505, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Oracle WebLogic Server', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Pascal', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Patch management software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Perforce Helix software', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'PostgreSQL', 43232311, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Practical extraction and reporting language Perl', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Programming language one PL/I', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Prolog', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'PTC Creo Parametric', 43232604, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Puppet', 43232401, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'PuTTY', 43232901, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Python', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'R', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'React', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Recovery testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Red Hat Ansible Engine', 43232401, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Red Hat Enterprise Linux', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Red Hat WildFly', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Regression testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Relational database management software', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Requirements management software', 43232407, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Restructured extended executor REXX', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Ruby', 43232402, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Ruby on Rails', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Sage 50 Accounting', 43231601, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Salesforce software', 43232303, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'SAP', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'SAP Adaptive Server Enterprise', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'SAP Business Objects', 43231602, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'SAP Netweaver', 43232403, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'SAP PowerBuilder', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'SAS', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Scala', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Scheme programming language', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Security testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Selenium', 43232406, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Self', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Shell script', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Simulation program with integrated circuit emphasis SPICE', 43232605, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Smalltalk', 43232405, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Source code editor software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Splunk Enterprise', 43233701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Spring Boot', 43232701, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Spring Framework', 43232408, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Static analysis software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Stress testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'String oriented symbolic language SNOBOL', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Structured Query Report SQR', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Sun Microsystems Java 2 Platform Enterprise Edition J2EE', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Supervisory control and data acquisition SCADA software', 43232608, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Swift', 43232405, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Symantec', 43233205, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Symantec Visual Cafe', 43232402, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'System testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Tableau', 43232314, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Talend Big Data Integration', 43232304, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Talend Data Fabric', 43232310, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Tax software', 43231601, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Teradata Database', 43232304, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Test design software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Test implementation software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Transact-SQL', 43232306, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Trimble SketchUp Pro', 43232102, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Ubuntu', 43233004, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Unified modeling language UML', 43232407, 'Y');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'Unit testing software', 43232406, 'N');
INSERT INTO technology_skills (onetsoc_code, example, commodity_code, hot_technology) VALUES ('15-1132.00', 'UNIX', 4323300