CREATE TABLE task_ratings (
  onetsoc_code CHARACTER(10) NOT NULL,
  task_id DECIMAL(8,0) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  category DECIMAL(3,0),
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(5,2),
  lower_ci_bound DECIMAL(5,2),
  upper_ci_bound DECIMAL(5,2),
  recommend_suppress CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (task_id) REFERENCES task_statements(task_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id),
  FOREIGN KEY (scale_id, category) REFERENCES task_categories(scale_id, category));

INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 1, 4.34, 79, 2.48, 1.36, 12.96, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 2, 9.16, 79, 3.86, 3.86, 20.24, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 3, 11.04, 79, 3.44, 5.82, 19.95, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 4, 16.19, 79, 4.37, 9.24, 26.83, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 5, 46.67, 79, 6.03, 35.07, 58.64, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 6, 7.33, 79, 3.40, 2.83, 17.65, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 7, 5.26, 79, 4.30, 0.99, 23.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'IM', NULL, 4.54, 78, 0.08, 4.38, 4.71, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'RT', NULL, 94.19, 87, 3.35, 82.75, 98.21, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 1, 12.96, 83, 3.77, 7.12, 22.44, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 2, 16.77, 83, 4.67, 9.38, 28.15, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 3, 15.16, 83, 4.46, 8.22, 26.27, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 4, 15.18, 83, 4.41, 8.30, 26.13, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 5, 23.95, 83, 5.84, 14.27, 37.34, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 6, 15.36, 83, 5.37, 7.39, 29.21, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 7, 0.63, 83, 0.64, 0.08, 4.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'IM', NULL, 4.48, 82, 0.08, 4.31, 4.65, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'RT', NULL, 94.26, 87, 4.36, 76.81, 98.79, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 1, 0.00, 87, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 2, 19.04, 87, 5.69, 10.15, 32.88, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 3, 12.61, 87, 3.81, 6.76, 22.29, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 4, 18.96, 87, 4.97, 10.96, 30.79, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 5, 35.11, 87, 5.96, 24.34, 47.64, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 6, 10.56, 87, 3.79, 5.05, 20.77, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 7, 3.73, 87, 2.03, 1.24, 10.65, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'IM', NULL, 4.40, 86, 0.10, 4.21, 4.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'RT', NULL, 100.00, 87, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 1, 3.17, 84, 2.97, 0.48, 18.27, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 2, 9.27, 84, 3.97, 3.84, 20.71, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 3, 10.18, 84, 3.85, 4.68, 20.75, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 4, 23.83, 84, 6.25, 13.63, 38.28, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 5, 38.47, 84, 8.10, 24.04, 55.27, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 6, 8.70, 84, 3.65, 3.68, 19.22, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 7, 6.38, 84, 4.33, 1.58, 22.38, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'IM', NULL, 4.39, 84, 0.07, 4.24, 4.54, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'RT', NULL, 95.84, 87, 2.42, 87.35, 98.71, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 1, 24.24, 77, 5.84, 14.52, 37.62, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 2, 38.58, 77, 6.88, 26.05, 52.83, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 3, 18.43, 77, 5.57, 9.75, 32.09, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 4, 10.23, 77, 4.16, 4.42, 21.94, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 5, 7.87, 77, 3.45, 3.20, 18.07, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 6, 0.00, 77, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 7, 0.65, 77, 0.66, 0.09, 4.77, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'IM', NULL, 4.17, 76, 0.12, 3.93, 4.42, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'RT', NULL, 90.47, 87, 3.71, 80.13, 95.72, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 1, 1.59, 85, 1.49, 0.24, 9.68, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 2, 11.14, 85, 3.73, 5.60, 20.96, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 3, 27.41, 85, 6.06, 17.09, 40.89, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 4, 15.58, 85, 4.26, 8.84, 25.99, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 5, 25.27, 85, 6.81, 14.17, 40.92, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 6, 14.21, 85, 5.13, 6.69, 27.66, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 7, 4.81, 85, 3.46, 1.11, 18.50, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'IM', NULL, 4.15, 86, 0.14, 3.88, 4.43, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'RT', NULL, 98.79, 87, 1.22, 91.48, 99.84, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 1, 4.23, 85, 2.20, 1.47, 11.52, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 2, 28.68, 85, 7.08, 16.81, 44.46, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 3, 31.18, 85, 5.50, 21.39, 43.00, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 4, 15.91, 85, 5.32, 7.90, 29.45, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 5, 17.31, 85, 5.19, 9.24, 30.09, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 6, 2.08, 85, 1.58, 0.45, 9.02, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 7, 0.60, 85, 0.61, 0.08, 4.43, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'IM', NULL, 4.12, 85, 0.09, 3.94, 4.29, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'RT', NULL, 97.56, 87, 2.29, 85.54, 99.63, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 1, 14.66, 68, 7.65, 4.83, 36.78, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 2, 21.73, 68, 6.02, 12.05, 36.01, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 3, 28.95, 68, 6.30, 18.11, 42.88, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 4, 15.88, 68, 5.97, 7.19, 31.53, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 5, 8.27, 68, 3.94, 3.10, 20.27, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 6, 5.56, 68, 5.04, 0.86, 28.57, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 7, 4.94, 68, 4.07, 0.91, 22.67, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'IM', NULL, 4.02, 68, 0.13, 3.76, 4.28, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'RT', NULL, 78.78, 86, 5.68, 65.39, 87.95, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 1, 0.80, 76, 0.49, 0.24, 2.66, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 2, 36.06, 76, 5.74, 25.57, 48.07, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 3, 23.82, 76, 6.70, 13.03, 39.49, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 4, 19.72, 76, 5.88, 10.48, 33.99, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 5, 14.05, 76, 4.35, 7.39, 25.10, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 6, 5.55, 76, 3.99, 1.27, 21.14, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 7, 0.00, 76, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'IM', NULL, 3.96, 76, 0.12, 3.73, 4.20, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'RT', NULL, 84.86, 86, 5.50, 70.54, 92.92, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 1, 5.93, 65, 3.04, 2.08, 15.77, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 2, 31.14, 65, 7.78, 17.97, 48.28, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 3, 42.95, 65, 9.25, 26.15, 61.54, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 4, 12.69, 65, 4.83, 5.73, 25.79, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 5, 4.28, 65, 2.74, 1.16, 14.54, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 6, 3.02, 65, 2.30, 0.64, 12.99, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 7, 0.00, 65, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'IM', NULL, 3.96, 65, 0.11, 3.73, 4.19, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'RT', NULL, 72.72, 87, 5.75, 59.96, 82.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 1, 3.98, 72, 3.31, 0.73, 18.87, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 2, 23.93, 72, 6.98, 12.78, 40.31, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 3, 34.72, 72, 7.61, 21.40, 50.97, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 4, 19.51, 72, 6.82, 9.25, 36.55, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 5, 14.50, 72, 5.45, 6.59, 28.96, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 6, 2.68, 72, 1.90, 0.64, 10.55, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 7, 0.68, 72, 0.69, 0.09, 4.99, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'IM', NULL, 3.95, 72, 0.10, 3.75, 4.16, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'RT', NULL, 87.10, 87, 4.27, 76.02, 93.50, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 1, 7.89, 65, 3.36, 3.29, 17.74, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 2, 30.58, 65, 7.03, 18.52, 46.05, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 3, 26.86, 65, 8.67, 13.20, 47.00, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 4, 10.74, 65, 4.08, 4.89, 21.96, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 5, 23.18, 65, 6.02, 13.31, 37.21, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 6, 0.00, 65, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 7, 0.76, 65, 0.77, 0.10, 5.53, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'IM', NULL, 3.87, 66, 0.09, 3.69, 4.06, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'RT', NULL, 78.35, 87, 6.55, 62.68, 88.63, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 1, 1.86, 86, 1.86, 0.25, 12.62, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 2, 10.47, 86, 3.72, 5.04, 20.48, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 3, 33.75, 86, 8.45, 19.38, 51.93, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 4, 23.93, 86, 5.31, 14.98, 35.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 5, 26.31, 86, 5.58, 16.77, 38.75, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 6, 3.08, 86, 1.79, 0.95, 9.50, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 7, 0.60, 86, 0.61, 0.08, 4.37, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'IM', NULL, 3.82, 86, 0.13, 3.57, 4.07, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'RT', NULL, 98.87, 87, 1.12, 92.25, 99.84, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 1, 16.38, 72, 5.13, 8.49, 29.26, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 2, 33.48, 72, 9.29, 17.96, 53.63, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 3, 23.60, 72, 5.85, 13.92, 37.11, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 4, 16.26, 72, 5.47, 8.02, 30.19, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 5, 8.51, 72, 4.25, 3.04, 21.66, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 6, 1.76, 72, 1.78, 0.23, 12.25, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 7, 0.00, 72, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'IM', NULL, 3.73, 71, 0.14, 3.45, 4.01, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'RT', NULL, 85.82, 87, 4.54, 74.24, 92.70, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 1, 5.51, 72, 3.61, 1.44, 18.88, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 2, 28.39, 72, 5.71, 18.46, 40.97, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 3, 16.70, 72, 5.29, 8.59, 29.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 4, 28.19, 72, 6.62, 16.98, 42.97, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 5, 10.86, 72, 4.81, 4.32, 24.71, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 6, 9.64, 72, 5.59, 2.88, 27.74, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 7, 0.70, 72, 0.71, 0.09, 5.13, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'IM', NULL, 3.69, 72, 0.14, 3.42, 3.96, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'RT', NULL, 83.82, 87, 5.83, 68.78, 92.42, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 1, 10.60, 66, 4.98, 3.98, 25.30, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 2, 38.78, 66, 6.22, 27.30, 51.66, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 3, 28.91, 66, 8.21, 15.47, 47.45, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 4, 17.34, 66, 5.89, 8.46, 32.28, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 5, 1.43, 66, 1.43, 0.19, 9.84, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 6, 2.94, 66, 2.12, 0.68, 11.81, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 7, 0.00, 66, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'IM', NULL, 3.65, 66, 0.14, 3.36, 3.93, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'RT', NULL, 81.80, 86, 4.81, 70.28, 89.52, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 1, 8.52, 60, 3.68, 3.49, 19.33, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 2, 34.04, 60, 8.57, 19.38, 52.56, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 3, 34.66, 60, 9.24, 19.00, 54.54, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 4, 11.39, 60, 5.18, 4.40, 26.41, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 5, 4.74, 60, 3.24, 1.17, 17.31, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 6, 5.84, 60, 4.02, 1.41, 21.13, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 7, 0.81, 60, 0.82, 0.10, 5.94, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'IM', NULL, 3.64, 60, 0.15, 3.33, 3.95, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'RT', NULL, 73.15, 87, 6.14, 59.40, 83.53, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 1, 27.40, 63, 6.81, 15.99, 42.80, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 2, 24.79, 63, 7.31, 13.08, 41.92, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 3, 20.12, 63, 5.94, 10.74, 34.52, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 4, 6.56, 63, 3.15, 2.45, 16.40, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 5, 17.05, 63, 6.26, 7.82, 33.23, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 6, 1.61, 63, 1.61, 0.21, 11.14, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 7, 2.48, 63, 1.84, 0.56, 10.39, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'IM', NULL, 3.62, 63, 0.15, 3.32, 3.91, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'RT', NULL, 70.20, 87, 7.33, 54.00, 82.53, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 1, 22.51, 63, 6.55, 12.06, 38.10, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 2, 37.62, 63, 6.93, 25.04, 52.11, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 3, 30.50, 63, 7.66, 17.57, 47.47, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 4, 3.80, 63, 2.18, 1.19, 11.51, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 5, 4.58, 63, 4.25, 0.68, 25.14, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 6, 0.20, 63, 0.21, 0.03, 1.55, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 7, 0.79, 63, 0.80, 0.10, 5.80, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'IM', NULL, 3.33, 63, 0.15, 3.03, 3.63, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'RT', NULL, 75.11, 87, 5.23, 63.36, 84.04, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 1, 2.27, 58, 1.40, 0.66, 7.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 2, 3.09, 58, 3.06, 0.41, 19.83, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 3, 11.19, 58, 4.22, 5.11, 22.76, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 4, 18.37, 58, 6.65, 8.48, 35.34, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 5, 35.74, 58, 8.38, 21.12, 53.60, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 6, 8.07, 58, 4.27, 2.70, 21.74, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 7, 21.27, 58, 7.71, 9.71, 40.45, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'IM', NULL, 4.25, 58, 0.16, 3.93, 4.58, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'RT', NULL, 59.37, 87, 9.15, 40.74, 75.64, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 1, 20.38, 23, 8.92, 7.56, 44.47, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 2, 64.37, 23, 12.74, 36.35, 85.11, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 3, 11.89, 23, 8.41, 2.49, 41.61, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 4, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 5, 3.36, 23, 3.44, 0.38, 23.86, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 6, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 7, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'IM', NULL, 3.93, 23, 0.24, 3.42, 4.43, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'RT', NULL, 37.30, 87, 8.18, 22.88, 54.38, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 1, 21.34, 31, 8.38, 8.91, 42.93, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 2, 31.81, 31, 9.49, 16.03, 53.26, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 3, 37.97, 31, 10.34, 19.98, 60.01, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 4, 6.29, 31, 4.18, 1.55, 22.24, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 5, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 6, 2.60, 31, 2.64, 0.32, 18.30, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 7, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'IM', NULL, 3.92, 31, 0.22, 3.47, 4.37, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'RT', NULL, 46.48, 87, 7.71, 31.94, 61.65, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 1, 28.11, 35, 8.35, 14.45, 47.51, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 2, 31.45, 35, 10.05, 15.10, 54.19, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 3, 14.68, 35, 6.02, 6.08, 31.38, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 4, 4.17, 35, 3.63, 0.69, 21.56, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 5, 12.68, 35, 6.42, 4.27, 32.07, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 6, 7.45, 35, 4.71, 1.97, 24.39, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 7, 1.47, 35, 1.48, 0.18, 10.73, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'IM', NULL, 3.86, 35, 0.23, 3.38, 4.34, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'RT', NULL, 40.27, 87, 6.13, 28.88, 52.81, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 1, 23.63, 32, 9.18, 9.89, 46.61, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 2, 36.01, 32, 7.20, 22.94, 51.55, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 3, 29.19, 32, 7.21, 16.83, 45.65, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 4, 7.58, 32, 5.08, 1.83, 26.49, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 5, 0.87, 32, 0.91, 0.10, 6.97, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 6, 2.71, 32, 2.77, 0.33, 19.17, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 7, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'IM', NULL, 3.75, 32, 0.18, 3.38, 4.12, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'RT', NULL, 44.53, 87, 8.59, 28.67, 61.58, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 1, 6.54, 48, 3.62, 2.08, 18.73, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 2, 15.30, 48, 6.14, 6.51, 31.90, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 3, 32.80, 48, 7.31, 20.04, 48.75, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 4, 12.45, 48, 5.41, 4.98, 27.85, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 5, 29.57, 48, 6.53, 18.27, 44.09, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 6, 0.00, 48, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 7, 3.33, 48, 2.53, 0.71, 14.35, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'IM', NULL, 3.74, 48, 0.13, 3.47, 4.01, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'RT', NULL, 52.49, 87, 7.17, 38.42, 66.18, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 1, 46.77, 36, 11.64, 25.38, 69.41, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 2, 25.58, 36, 7.92, 12.87, 44.44, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 3, 4.05, 36, 3.64, 0.62, 22.08, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 4, 10.86, 36, 7.99, 2.23, 39.41, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 5, 11.35, 36, 5.09, 4.39, 26.32, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 6, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 7, 1.40, 36, 1.42, 0.17, 10.29, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'IM', NULL, 3.63, 36, 0.29, 3.04, 4.22, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'RT', NULL, 43.12, 86, 6.58, 30.79, 56.37, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 1, 2.04, 42, 2.06, 0.26, 14.31, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 2, 45.99, 42, 8.14, 30.52, 62.27, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 3, 34.81, 42, 7.80, 21.06, 51.67, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 4, 13.50, 42, 6.12, 5.14, 31.01, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 5, 2.48, 42, 2.19, 0.40, 13.72, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 6, 1.18, 42, 1.19, 0.15, 8.64, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 7, 0.00, 42, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'IM', NULL, 3.56, 42, 0.15, 3.26, 3.86, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'RT', NULL, 56.76, 87, 7.25, 42.19, 70.25, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 1, 19.24, 36, 7.48, 8.23, 38.75, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 2, 29.55, 36, 7.29, 17.08, 46.06, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 3, 41.61, 36, 8.63, 25.74, 59.44, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 4, 6.94, 36, 5.09, 1.48, 26.97, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 5, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 6, 2.67, 36, 2.69, 0.33, 18.37, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 7, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'IM', NULL, 3.37, 36, 0.19, 2.97, 3.76, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'RT', NULL, 45.98, 86, 7.93, 31.09, 61.62, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 1, 15.88, 50, 6.83, 6.33, 34.52, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 2, 46.33, 50, 6.82, 33.22, 59.95, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 3, 30.26, 50, 7.50, 17.53, 46.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 4, 5.54, 50, 3.94, 1.27, 21.05, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 5, 2.00, 50, 2.03, 0.25, 14.06, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 6, 0.00, 50, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 7, 0.00, 50, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'IM', NULL, 3.33, 50, 0.22, 2.88, 3.78, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'RT', NULL, 60.60, 86, 7.15, 45.89, 73.60, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 1, 24.80, 50, 7.83, 12.42, 43.39, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 2, 36.86, 50, 8.41, 22.02, 54.69, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 3, 29.12, 50, 7.29, 16.80, 45.52, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 4, 6.02, 50, 3.57, 1.77, 18.55, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 5, 1.05, 50, 1.06, 0.14, 7.62, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 6, 2.15, 50, 2.17, 0.28, 14.89, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 7, 0.00, 50, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'IM', NULL, 3.11, 50, 0.18, 2.74, 3.47, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'RT', NULL, 56.16, 87, 7.18, 41.78, 69.58, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 1, 50.29, 18, 14.65, 22.72, 77.69, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 2, 33.59, 18, 14.53, 11.35, 66.65, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 3, 11.63, 18, 8.43, 2.28, 42.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 4, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 5, 4.48, 18, 4.49, 0.51, 30.00, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 6, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 7, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'IM', NULL, 2.81, 18, 0.19, 2.41, 3.22, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'RT', NULL, 26.95, 87, 4.74, 18.61, 37.32, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 1, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 2, 19.23, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 3, 30.77, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 4, 19.23, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 5, 23.08, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 6, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 7, 7.69, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'IM', NULL, 4.19, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'RT', NULL, 100.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 1, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 2, 7.69, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 3, 19.23, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 4, 19.23, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 5, 34.62, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 6, 11.54, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 7, 7.69, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'IM', NULL, 4.04, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'RT', NULL, 100.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 1, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 2, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 3, 42.31, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 4, 19.23, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 5, 26.92, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 6, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 7, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'IM', NULL, 4.04, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'RT', NULL, 100.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 1, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 2, 44.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 3, 40.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 4, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 5, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 6, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 7, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'IM', NULL, 3.96, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'RT', NULL, 96.15, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 1, 11.54, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 2, 26.92, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 3, 30.77, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 4, 19.23, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 5, 11.54, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 6, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 7, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'IM', NULL, 3.92, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'RT', NULL, 100.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 1, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 2, 34.62, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 3, 30.77, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 4, 19.23, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 5, 7.69, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 6, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 7, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'IM', NULL, 3.88, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'RT', NULL, 100.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 1, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 2, 32.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 3, 32.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 4, 28.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 5, 8.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 6, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 7, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'IM', NULL, 3.88, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'RT', NULL, 96.15, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 1, 11.54, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 2, 46.15, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 3, 19.23, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 4, 15.38, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 5, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 6, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 7, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'IM', NULL, 3.81, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'RT', NULL, 100.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 1, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 2, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 3, 43.48, 23, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 4, 30.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 5, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'IM', NULL, 3.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'RT', NULL, 88.46, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 1, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 2, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 3, 33.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 4, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 5, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 6, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'IM', NULL, 3.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'RT', NULL, 92.31, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 1, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 2, 30.77, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 3, 46.15, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 4, 19.23, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 5, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 6, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 7, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'IM', NULL, 3.69, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'RT', NULL, 100.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 1, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 2, 42.31, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 3, 46.15, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 4, 11.54, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 5, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 6, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 7, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'IM', NULL, 3.65, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'RT', NULL, 100.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 1, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 2, 44.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 3, 24.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 4, 8.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 5, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 6, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 7, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'IM', NULL, 3.56, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'RT', NULL, 96.15, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 1, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 2, 41.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 3, 33.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 4, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 5, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'IM', NULL, 3.54, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'RT', NULL, 92.31, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 1, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 2, 45.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 3, 33.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 4, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 5, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'IM', NULL, 3.42, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'RT', NULL, 92.31, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 1, 17.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 2, 43.48, 23, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 3, 34.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 4, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 5, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'IM', NULL, 3.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'RT', NULL, 88.46, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 1, 22.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 2, 40.91, 22, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 3, 36.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 4, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 5, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 6, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'IM', NULL, 3.32, 22, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'RT', NULL, 84.62, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 1, 42.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 2, 52.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 3, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 4, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 5, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'IM', NULL, 3.15, 20, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'RT', NULL, 80.77, 26, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 1, 0.00, 147, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 2, 3.19, 147, 1.31, 1.41, 7.08, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 3, 20.90, 147, 5.81, 11.66, 34.59, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 4, 21.28, 147, 5.50, 12.37, 34.10, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 5, 36.99, 147, 5.51, 26.89, 48.37, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 6, 8.87, 147, 3.01, 4.46, 16.87, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 7, 8.78, 147, 3.80, 3.63, 19.74, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'IM', NULL, 4.09, 151, 0.09, 3.91, 4.28, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'RT', NULL, 95.28, 157, 2.50, 87.07, 98.37, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 1, 0.70, 134, 0.69, 0.10, 4.80, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 2, 2.17, 134, 1.31, 0.65, 7.01, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 3, 6.27, 134, 2.63, 2.69, 13.95, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 4, 10.30, 134, 4.05, 4.60, 21.47, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 5, 42.15, 134, 7.14, 28.99, 56.51, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 6, 25.54, 134, 5.14, 16.73, 36.94, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 7, 12.87, 134, 4.90, 5.86, 25.96, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'IM', NULL, 4.04, 137, 0.14, 3.77, 4.31, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'RT', NULL, 84.65, 157, 3.05, 77.61, 89.77, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 1, 0.00, 137, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 2, 1.74, 137, 1.57, 0.29, 9.86, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 3, 5.87, 137, 3.09, 2.03, 15.85, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 4, 8.23, 137, 3.22, 3.71, 17.24, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 5, 41.08, 137, 7.21, 27.90, 55.68, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 6, 26.16, 137, 5.80, 16.37, 39.08, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 7, 16.92, 137, 4.55, 9.69, 27.87, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'IM', NULL, 4.00, 140, 0.10, 3.79, 4.21, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'RT', NULL, 88.88, 156, 3.81, 78.87, 94.49, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 1, 2.20, 148, 2.13, 0.32, 13.69, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 2, 0.40, 148, 0.23, 0.13, 1.25, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 3, 20.64, 148, 4.34, 13.35, 30.51, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 4, 17.01, 148, 4.35, 10.03, 27.38, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 5, 40.80, 148, 5.46, 30.60, 51.85, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 6, 12.46, 148, 4.12, 6.33, 23.09, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 7, 6.48, 148, 2.54, 2.94, 13.68, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'IM', NULL, 3.93, 150, 0.12, 3.68, 4.17, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'RT', NULL, 96.78, 158, 2.08, 88.94, 99.12, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 1, 0.24, 119, 0.24, 0.03, 1.73, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 2, 14.42, 119, 3.92, 8.24, 24.03, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 3, 18.18, 119, 4.63, 10.72, 29.15, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 4, 18.39, 119, 5.22, 10.16, 30.99, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 5, 43.92, 119, 6.15, 32.32, 56.23, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 6, 4.84, 119, 2.44, 1.75, 12.69, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 7, 0.00, 119, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'IM', NULL, 3.89, 120, 0.13, 3.64, 4.15, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'RT', NULL, 77.15, 157, 5.95, 63.40, 86.80, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 1, 4.64, 126, 2.54, 1.53, 13.18, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 2, 20.77, 126, 6.31, 10.93, 35.88, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 3, 12.05, 126, 3.02, 7.23, 19.41, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 4, 29.63, 126, 6.27, 18.85, 43.28, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 5, 24.66, 126, 5.96, 14.78, 38.19, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 6, 7.58, 126, 2.97, 3.43, 15.94, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 7, 0.68, 126, 0.51, 0.15, 2.95, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'IM', NULL, 3.84, 129, 0.11, 3.63, 4.05, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'RT', NULL, 80.80, 157, 4.06, 71.51, 87.59, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 1, 7.99, 141, 4.94, 2.25, 24.69, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 2, 16.11, 141, 4.28, 9.31, 26.42, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 3, 33.56, 141, 5.60, 23.51, 45.37, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 4, 13.00, 141, 3.27, 7.77, 20.94, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 5, 21.96, 141, 5.00, 13.65, 33.37, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 6, 4.77, 141, 2.17, 1.91, 11.40, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 7, 2.61, 141, 1.82, 0.65, 9.92, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'IM', NULL, 3.75, 142, 0.13, 3.49, 4.01, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'RT', NULL, 92.91, 157, 3.09, 83.86, 97.06, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 1, 6.35, 147, 2.79, 2.62, 14.61, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 2, 30.67, 147, 4.79, 22.08, 40.85, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 3, 28.71, 147, 4.88, 20.09, 39.22, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 4, 16.67, 147, 4.71, 9.29, 28.10, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 5, 15.42, 147, 3.45, 9.76, 23.51, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 6, 0.14, 147, 0.14, 0.02, 1.03, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 7, 2.03, 147, 1.68, 0.39, 9.90, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'IM', NULL, 3.73, 151, 0.09, 3.56, 3.91, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'RT', NULL, 93.60, 158, 2.97, 84.59, 97.50, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 1, 12.23, 108, 4.04, 6.20, 22.71, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 2, 19.49, 108, 5.28, 11.05, 32.06, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 3, 26.41, 108, 6.73, 15.30, 41.63, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 4, 16.31, 108, 3.83, 10.05, 25.38, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 5, 21.53, 108, 4.14, 14.44, 30.85, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 6, 3.84, 108, 2.82, 0.87, 15.35, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 7, 0.18, 108, 0.18, 0.02, 1.34, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'IM', NULL, 3.51, 109, 0.12, 3.26, 3.75, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'RT', NULL, 73.46, 158, 5.68, 60.90, 83.10, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 1, 7.77, 82, 4.10, 2.63, 20.82, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 2, 19.67, 82, 5.29, 11.17, 32.28, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 3, 21.59, 82, 7.14, 10.64, 38.92, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 4, 20.15, 82, 6.40, 10.26, 35.78, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 5, 22.51, 82, 6.85, 11.74, 38.82, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 6, 8.07, 82, 4.15, 2.80, 21.10, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 7, 0.22, 82, 0.23, 0.03, 1.66, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'IM', NULL, 3.93, 84, 0.13, 3.68, 4.19, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'RT', NULL, 48.48, 158, 5.97, 36.97, 60.14, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 1, 1.99, 92, 1.45, 0.46, 8.15, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 2, 0.92, 92, 0.65, 0.23, 3.68, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 3, 18.15, 92, 5.88, 9.18, 32.74, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 4, 28.97, 92, 8.30, 15.47, 47.62, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 5, 32.54, 92, 7.28, 19.97, 48.25, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 6, 15.52, 92, 5.49, 7.41, 29.68, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 7, 1.90, 92, 1.07, 0.62, 5.68, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'IM', NULL, 3.83, 96, 0.15, 3.53, 4.12, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'RT', NULL, 53.53, 158, 6.14, 41.44, 65.23, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 1, 8.49, 86, 4.07, 3.17, 20.84, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 2, 10.14, 86, 3.99, 4.51, 21.21, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 3, 16.55, 86, 5.24, 8.53, 29.66, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 4, 12.11, 86, 4.79, 5.33, 25.23, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 5, 17.64, 86, 5.53, 9.13, 31.35, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 6, 8.76, 86, 4.54, 3.01, 22.90, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 7, 26.32, 86, 9.54, 11.84, 48.71, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'IM', NULL, 3.82, 88, 0.17, 3.49, 4.16, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'RT', NULL, 58.83, 158, 6.75, 45.17, 71.26, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 1, 16.65, 68, 7.37, 6.47, 36.59, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 2, 21.77, 68, 7.57, 10.29, 40.32, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 3, 31.87, 68, 7.82, 18.56, 48.99, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 4, 11.33, 68, 5.41, 4.18, 27.23, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 5, 10.40, 68, 4.46, 4.28, 23.17, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 6, 7.97, 68, 4.18, 2.71, 21.25, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 7, 0.00, 68, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'IM', NULL, 3.34, 70, 0.18, 2.98, 3.70, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'RT', NULL, 45.75, 158, 6.91, 32.74, 59.37, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 1, 42.80, 73, 8.61, 27.08, 60.13, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 2, 37.30, 73, 7.74, 23.52, 53.51, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 3, 8.47, 73, 3.63, 3.51, 19.05, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 4, 7.72, 73, 4.09, 2.60, 20.79, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 5, 3.70, 73, 3.35, 0.59, 20.04, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 6, 0.00, 73, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 7, 0.00, 73, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'IM', NULL, 3.28, 74, 0.15, 2.97, 3.59, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'RT', NULL, 39.91, 158, 5.16, 30.28, 50.38, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 1, 12.78, 88, 4.61, 6.05, 25.01, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 2, 34.20, 88, 8.33, 19.94, 52.02, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 3, 20.93, 88, 5.58, 11.92, 34.10, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 4, 9.99, 88, 4.88, 3.64, 24.61, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 5, 19.51, 88, 5.35, 10.97, 32.30, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 6, 1.30, 88, 1.27, 0.18, 8.59, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 7, 1.30, 88, 1.27, 0.18, 8.59, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'IM', NULL, 3.25, 92, 0.16, 2.94, 3.57, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'RT', NULL, 52.57, 157, 6.48, 39.88, 64.94, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 1, 3.74, 63, 1.83, 1.38, 9.71, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 2, 21.13, 63, 6.49, 10.96, 36.84, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 3, 29.95, 63, 9.44, 14.82, 51.23, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 4, 26.98, 63, 8.35, 13.67, 46.30, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 5, 17.30, 63, 7.16, 7.14, 36.25, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 6, 0.57, 63, 0.57, 0.07, 4.17, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 7, 0.34, 63, 0.34, 0.05, 2.52, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'IM', NULL, 3.24, 65, 0.16, 2.93, 3.56, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'RT', NULL, 42.57, 158, 6.96, 29.70, 56.53, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 1, 17.24, 39, 7.91, 6.35, 39.03, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 2, 25.05, 39, 10.37, 9.85, 50.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 3, 29.27, 39, 11.21, 12.15, 55.33, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 4, 10.79, 39, 6.42, 3.04, 31.80, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 5, 17.65, 39, 9.99, 5.06, 46.28, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 6, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 7, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'IM', NULL, 2.97, 41, 0.17, 2.62, 3.31, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'RT', NULL, 23.58, 158, 5.35, 14.66, 35.68, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 1, 1.02, 69, 1.02, 0.14, 7.20, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 2, 8.65, 69, 3.23, 4.02, 17.64, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 3, 23.65, 69, 5.21, 14.84, 35.51, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 4, 25.65, 69, 5.47, 16.29, 37.95, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 5, 25.51, 69, 4.68, 17.33, 35.88, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 6, 8.50, 69, 3.67, 3.50, 19.22, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 7, 7.01, 69, 3.28, 2.69, 17.07, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'IM', NULL, 4.13, 66, 0.12, 3.89, 4.36, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'RT', NULL, 96.37, 73, 2.29, 87.79, 98.99, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 1, 2.15, 64, 2.09, 0.30, 13.78, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 2, 9.79, 64, 3.49, 4.69, 19.31, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 3, 27.42, 64, 5.51, 17.84, 39.64, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 4, 21.09, 64, 5.50, 12.13, 34.09, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 5, 24.49, 64, 5.14, 15.69, 36.11, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 6, 9.57, 64, 3.47, 4.53, 19.09, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 7, 5.49, 64, 3.18, 1.68, 16.49, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'IM', NULL, 4.07, 60, 0.13, 3.80, 4.34, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'RT', NULL, 87.26, 72, 3.50, 78.52, 92.77, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'FT', 1, 40.61, 55, 7.82, 26.30, 56.71, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'FT', 2, 29.24, 55, 6.63, 17.86, 44.00, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'FT', 3, 22.35, 55, 6.38, 12.10, 37.55, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'FT', 4, 2.49, 55, 2.45, 0.34, 16.16, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'FT', 5, 4.09, 55, 2.41, 1.22, 12.77, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'FT', 6, 1.23, 55, 1.22, 0.17, 8.52, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'FT', 7, 0.00, 55, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'IM', NULL, 3.95, 53, 0.12, 3.70, 4.20, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'RT', NULL, 76.64, 72, 5.98, 62.77, 86.45, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 1, 0.00, 68, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 2, 17.06, 68, 4.24, 10.16, 27.22, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 3, 11.79, 68, 4.00, 5.84, 22.36, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 4, 21.68, 68, 5.23, 13.02, 33.85, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 5, 24.29, 68, 4.82, 15.98, 35.13, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 6, 20.26, 68, 5.23, 11.74, 32.66, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 7, 4.92, 68, 2.83, 1.52, 14.77, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'IM', NULL, 3.90, 69, 0.11, 3.67, 4.12, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'RT', NULL, 97.19, 72, 1.74, 90.69, 99.19, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 1, 3.55, 57, 3.40, 0.50, 21.18, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 2, 25.30, 57, 5.91, 15.33, 38.79, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 3, 27.69, 57, 5.74, 17.74, 40.48, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 4, 23.90, 57, 5.93, 14.06, 37.63, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 5, 14.70, 57, 4.99, 7.21, 27.67, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 6, 4.85, 57, 2.91, 1.42, 15.28, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 7, 0.00, 57, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'IM', NULL, 3.87, 54, 0.13, 3.60, 4.14, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'RT', NULL, 80.19, 71, 5.99, 65.62, 89.57, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 1, 0.00, 55, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 2, 6.17, 55, 3.22, 2.11, 16.72, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 3, 21.57, 55, 5.92, 11.99, 35.68, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 4, 25.90, 55, 6.21, 15.45, 40.08, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 5, 26.81, 55, 6.09, 16.43, 40.56, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 6, 17.74, 55, 5.25, 9.49, 30.74, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 7, 1.81, 55, 1.80, 0.24, 12.35, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'IM', NULL, 3.84, 53, 0.14, 3.57, 4.11, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'RT', NULL, 78.64, 71, 4.50, 68.33, 86.26, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 1, 1.78, 56, 1.78, 0.24, 12.17, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 2, 18.36, 56, 5.87, 9.31, 33.01, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 3, 20.34, 56, 4.90, 12.23, 31.88, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 4, 18.71, 56, 5.06, 10.56, 30.96, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 5, 28.41, 56, 6.14, 17.81, 42.10, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 6, 7.70, 56, 3.94, 2.67, 20.20, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 7, 4.69, 56, 3.29, 1.12, 17.67, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'IM', NULL, 3.81, 53, 0.13, 3.56, 4.07, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'RT', NULL, 78.17, 71, 4.91, 66.87, 86.40, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 1, 3.64, 58, 2.58, 0.86, 14.14, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 2, 11.74, 58, 4.35, 5.43, 23.56, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 3, 17.45, 58, 4.95, 9.61, 29.60, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 4, 25.23, 58, 5.86, 15.33, 38.60, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 5, 27.78, 58, 5.24, 18.57, 39.35, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 6, 12.14, 58, 4.26, 5.85, 23.51, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 7, 2.02, 58, 2.01, 0.27, 13.57, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'IM', NULL, 3.81, 59, 0.12, 3.57, 4.05, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'RT', NULL, 83.59, 72, 4.07, 73.81, 90.21, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'FT', 1, 0.00, 66, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'FT', 2, 26.12, 66, 5.46, 16.73, 38.36, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'FT', 3, 24.20, 66, 5.67, 14.68, 37.19, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'FT', 4, 17.62, 66, 4.46, 10.39, 28.31, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'FT', 5, 23.72, 66, 4.83, 15.43, 34.64, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'FT', 6, 6.40, 66, 3.20, 2.30, 16.58, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'FT', 7, 1.93, 66, 1.96, 0.25, 13.46, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'IM', NULL, 3.80, 64, 0.12, 3.57, 4.04, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'RT', NULL, 92.32, 72, 3.40, 82.22, 96.90, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 21038, 'FT', 1, 0.00, 56, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 21038, 'FT', 2, 25.79, 56, 5.63, 16.16, 38.52, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 21038, 'FT', 3, 23.18, 56, 5.66, 13.77, 36.32, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 21038, 'FT', 4, 30.48, 56, 5.90, 20.05, 43.38, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 21038, 'FT', 5, 17.36, 56, 5.30, 9.10, 30.58, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 21038, 'FT', 6, 1.20, 56, 1.19, 0.16, 8.34, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 21038, 'FT', 7, 2.00, 56, 1.99, 0.26, 13.58, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 21038, 'IM', NULL, 3.75, 55, 0.14, 3.46, 4.04, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 21038, 'RT', NULL, 76.54, 73, 4.83, 65.62, 84.80, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 1, 9.16, 58, 4.05, 3.66, 21.09, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 2, 36.44, 58, 6.04, 25.38, 49.15, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 3, 36.59, 58, 6.98, 24.01, 51.32, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 4, 14.28, 58, 5.14, 6.71, 27.84, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 5, 2.36, 58, 2.33, 0.32, 15.41, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 6, 1.17, 58, 1.16, 0.16, 8.10, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 7, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'IM', NULL, 3.67, 55, 0.12, 3.42, 3.91, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'RT', NULL, 81.73, 71, 4.85, 70.08, 89.52, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 1, 0.00, 56, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 2, 17.66, 56, 5.12, 9.58, 30.29, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 3, 22.85, 56, 6.51, 12.39, 38.29, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 4, 22.46, 56, 5.95, 12.74, 36.48, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 5, 27.16, 56, 6.45, 16.25, 41.74, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 6, 8.42, 56, 3.87, 3.26, 20.08, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 7, 1.45, 56, 1.44, 0.19, 10.07, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'IM', NULL, 3.61, 57, 0.14, 3.33, 3.89, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'RT', NULL, 79.02, 74, 4.50, 68.66, 86.62, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 1, 3.19, 56, 2.25, 0.76, 12.43, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 2, 16.15, 56, 4.92, 8.51, 28.52, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 3, 46.17, 56, 7.06, 32.67, 60.25, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 4, 14.89, 56, 4.38, 8.05, 25.91, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 5, 15.39, 56, 4.82, 7.97, 27.64, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 6, 3.01, 56, 2.37, 0.61, 13.65, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 7, 1.19, 56, 1.20, 0.16, 8.45, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'IM', NULL, 3.59, 54, 0.11, 3.37, 3.80, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'RT', NULL, 77.04, 71, 6.40, 62.00, 87.35, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 1, 4.41, 57, 3.10, 1.04, 16.75, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 2, 18.73, 57, 4.77, 10.96, 30.15, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 3, 19.86, 57, 5.25, 11.34, 32.44, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 4, 28.59, 57, 5.51, 18.91, 40.73, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 5, 19.96, 57, 5.22, 11.47, 32.42, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 6, 6.07, 57, 3.17, 2.08, 16.46, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 7, 2.37, 57, 2.29, 0.33, 14.95, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'IM', NULL, 3.55, 56, 0.13, 3.29, 3.81, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'RT', NULL, 78.24, 73, 5.42, 65.60, 87.15, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 1, 2.23, 51, 2.23, 0.29, 15.05, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 2, 34.26, 51, 6.79, 22.15, 48.85, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 3, 26.21, 51, 6.27, 15.63, 40.52, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 4, 14.93, 51, 5.51, 6.84, 29.54, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 5, 20.34, 51, 7.10, 9.57, 38.11, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 6, 2.02, 51, 1.52, 0.44, 8.77, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 7, 0.00, 51, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'IM', NULL, 3.54, 51, 0.13, 3.28, 3.79, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'RT', NULL, 69.28, 72, 6.27, 55.62, 80.23, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 1, 4.04, 63, 2.39, 1.21, 12.63, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 2, 9.46, 63, 3.87, 4.06, 20.49, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 3, 39.21, 63, 6.59, 27.07, 52.86, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 4, 20.90, 63, 5.26, 12.27, 33.30, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 5, 23.71, 63, 5.53, 14.43, 36.42, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 6, 2.68, 63, 1.91, 0.63, 10.63, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 7, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'IM', NULL, 3.25, 57, 0.13, 2.99, 3.51, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'RT', NULL, 86.55, 72, 4.49, 74.88, 93.28, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 1, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 2, 21.53, 30, 8.13, 9.30, 42.33, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 3, 19.07, 30, 7.28, 8.24, 38.22, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 4, 20.48, 30, 7.09, 9.56, 38.56, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 5, 18.13, 30, 9.20, 5.87, 44.03, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 6, 14.08, 30, 6.67, 5.03, 33.62, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 7, 6.71, 30, 4.66, 1.54, 24.81, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'IM', NULL, 3.89, 27, 0.20, 3.48, 4.29, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'RT', NULL, 41.07, 72, 6.29, 29.33, 53.92, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 1, 5.28, 47, 3.73, 1.23, 19.98, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 2, 36.15, 47, 8.30, 21.55, 53.86, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 3, 23.84, 47, 6.60, 13.08, 39.42, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 4, 13.04, 47, 5.65, 5.22, 29.00, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 5, 14.46, 47, 5.40, 6.56, 28.92, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 6, 5.80, 47, 3.92, 1.43, 20.68, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 7, 1.43, 47, 1.43, 0.19, 10.10, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'IM', NULL, 3.81, 44, 0.16, 3.50, 4.13, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'RT', NULL, 63.17, 72, 6.64, 49.26, 75.19, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 1, 4.34, 38, 3.01, 1.03, 16.49, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 2, 15.25, 38, 5.47, 7.10, 29.77, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 3, 36.91, 38, 9.01, 21.07, 56.17, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 4, 10.45, 38, 4.73, 4.02, 24.54, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 5, 20.62, 38, 6.80, 10.06, 37.61, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 6, 12.43, 38, 5.64, 4.74, 28.86, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 7, 0.00, 38, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'IM', NULL, 3.68, 38, 0.17, 3.33, 4.02, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'RT', NULL, 58.64, 69, 5.67, 47.07, 69.33, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 1, 2.36, 45, 2.35, 0.31, 15.88, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 2, 23.50, 45, 6.12, 13.40, 37.89, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 3, 18.69, 45, 5.71, 9.73, 32.89, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 4, 22.59, 45, 7.47, 10.97, 40.85, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 5, 16.24, 45, 5.05, 8.40, 29.06, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 6, 12.29, 45, 4.72, 5.48, 25.29, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 7, 4.33, 45, 3.13, 0.98, 17.19, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'IM', NULL, 3.62, 45, 0.16, 3.30, 3.94, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'RT', NULL, 61.21, 72, 6.54, 47.67, 73.21, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'FT', 1, 0.00, 41, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'FT', 2, 21.08, 41, 6.77, 10.50, 37.83, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'FT', 3, 12.00, 41, 5.02, 4.96, 26.26, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'FT', 4, 29.25, 41, 7.71, 16.30, 46.73, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'FT', 5, 22.51, 41, 5.61, 13.16, 35.77, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'FT', 6, 12.02, 41, 5.42, 4.62, 27.80, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'FT', 7, 3.14, 41, 2.99, 0.44, 19.15, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'IM', NULL, 3.62, 40, 0.16, 3.30, 3.94, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'RT', NULL, 57.82, 73, 5.73, 46.18, 68.65, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 1, 5.03, 46, 3.56, 1.17, 19.17, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 2, 26.30, 46, 6.55, 15.29, 41.35, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 3, 17.91, 46, 5.83, 8.94, 32.64, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 4, 27.42, 46, 6.35, 16.57, 41.82, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 5, 19.24, 46, 6.61, 9.19, 35.94, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 6, 4.10, 46, 2.94, 0.94, 16.16, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 7, 0.00, 46, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'IM', NULL, 3.61, 45, 0.14, 3.34, 3.89, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'RT', NULL, 62.26, 72, 5.72, 50.39, 72.82, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 1, 3.68, 46, 2.68, 0.83, 14.92, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 2, 26.13, 46, 6.20, 15.63, 40.32, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 3, 21.52, 46, 6.79, 10.87, 38.14, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 4, 22.45, 46, 5.77, 12.93, 36.07, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 5, 9.94, 46, 4.52, 3.84, 23.39, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 6, 16.28, 46, 6.11, 7.31, 32.41, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 7, 0.00, 46, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'IM', NULL, 3.50, 45, 0.12, 3.25, 3.75, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'RT', NULL, 63.96, 72, 6.30, 50.72, 75.37, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 1, 18.91, 45, 6.08, 9.49, 34.16, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 2, 62.00, 45, 7.03, 47.21, 74.85, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 3, 6.75, 45, 3.93, 2.02, 20.33, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 4, 10.87, 45, 4.51, 4.56, 23.75, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 5, 0.00, 45, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 6, 1.47, 45, 1.46, 0.20, 10.24, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 7, 0.00, 45, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'IM', NULL, 3.43, 47, 0.16, 3.11, 3.75, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'RT', NULL, 65.01, 74, 6.56, 51.11, 76.75, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 1, 13.66, 30, 6.84, 4.60, 34.14, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 2, 23.42, 30, 8.34, 10.57, 44.18, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 3, 32.29, 30, 8.01, 18.41, 50.22, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 4, 14.19, 30, 6.52, 5.24, 33.07, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 5, 14.11, 30, 6.12, 5.52, 31.59, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 6, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 7, 2.33, 30, 2.33, 0.29, 16.19, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'IM', NULL, 3.35, 29, 0.17, 2.99, 3.71, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'RT', NULL, 40.08, 71, 6.70, 27.72, 53.85, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'FT', 1, 4.61, 41, 3.15, 1.12, 17.04, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'FT', 2, 20.62, 41, 6.63, 10.28, 37.06, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'FT', 3, 45.18, 41, 8.27, 29.57, 61.81, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'FT', 4, 22.01, 41, 5.75, 12.55, 35.69, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'FT', 5, 5.92, 41, 4.10, 1.40, 21.79, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'FT', 6, 1.66, 41, 1.63, 0.22, 11.29, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'FT', 7, 0.00, 41, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'IM', NULL, 3.16, 40, 0.17, 2.82, 3.51, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'RT', NULL, 56.78, 72, 6.70, 43.26, 69.36, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 1, 0.64, 112, 0.64, 0.09, 4.59, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 2, 16.09, 112, 6.60, 6.79, 33.54, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 3, 20.94, 112, 5.01, 12.70, 32.53, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 4, 12.55, 112, 3.78, 6.76, 22.13, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 5, 29.28, 112, 4.06, 21.92, 37.92, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 6, 14.28, 112, 3.90, 8.13, 23.86, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 7, 6.23, 112, 3.68, 1.87, 18.81, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'IM', NULL, 4.30, 113, 0.12, 4.07, 4.53, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'RT', NULL, 98.32, 117, 1.13, 93.82, 99.56, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 1, 0.73, 113, 0.57, 0.16, 3.39, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 2, 10.56, 113, 3.96, 4.90, 21.31, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 3, 18.24, 113, 5.31, 9.92, 31.13, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 4, 8.28, 113, 2.97, 3.99, 16.39, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 5, 27.22, 113, 7.52, 14.99, 44.26, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 6, 25.05, 113, 6.03, 15.03, 38.70, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 7, 9.92, 113, 4.07, 4.27, 21.35, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'IM', NULL, 4.24, 114, 0.06, 4.11, 4.36, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'RT', NULL, 98.22, 117, 1.19, 93.46, 99.53, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 1, 1.26, 94, 0.94, 0.29, 5.38, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 2, 31.99, 94, 6.24, 21.02, 45.40, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 3, 21.05, 94, 7.61, 9.70, 39.83, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 4, 19.58, 94, 5.23, 11.18, 32.02, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 5, 16.90, 94, 4.71, 9.46, 28.35, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 6, 8.85, 94, 5.94, 2.20, 29.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 7, 0.37, 94, 0.37, 0.05, 2.71, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'IM', NULL, 3.99, 95, 0.13, 3.73, 4.26, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'RT', NULL, 81.95, 116, 4.22, 72.07, 88.88, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 1, 8.02, 92, 4.64, 2.44, 23.34, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 2, 19.12, 92, 6.71, 9.08, 35.87, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 3, 31.31, 92, 6.99, 19.30, 46.50, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 4, 22.41, 92, 6.34, 12.27, 37.35, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 5, 18.04, 92, 7.61, 7.33, 37.97, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 6, 0.69, 92, 0.50, 0.16, 2.91, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 7, 0.41, 92, 0.42, 0.06, 3.02, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'IM', NULL, 3.87, 93, 0.15, 3.57, 4.18, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'RT', NULL, 71.63, 117, 5.04, 60.70, 80.50, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 1, 4.22, 102, 2.05, 1.58, 10.75, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 2, 18.64, 102, 6.60, 8.81, 35.20, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 3, 32.85, 102, 5.94, 22.29, 45.48, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 4, 27.54, 102, 11.00, 11.30, 53.15, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 5, 9.74, 102, 4.18, 4.03, 21.71, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 6, 6.61, 102, 5.42, 1.23, 28.76, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 7, 0.39, 102, 0.36, 0.06, 2.44, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'IM', NULL, 3.70, 103, 0.16, 3.38, 4.02, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'RT', NULL, 84.10, 116, 5.92, 68.76, 92.70, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 1, 22.78, 80, 5.31, 13.92, 34.99, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 2, 19.76, 80, 6.30, 10.04, 35.19, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 3, 11.61, 80, 4.33, 5.36, 23.33, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 4, 10.29, 80, 5.27, 3.55, 26.34, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 5, 22.09, 80, 6.15, 12.22, 36.60, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 6, 6.93, 80, 3.63, 2.37, 18.58, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 7, 6.54, 80, 5.46, 1.17, 29.27, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'IM', NULL, 3.66, 81, 0.12, 3.42, 3.90, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'RT', NULL, 75.29, 117, 5.24, 63.55, 84.19, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 1, 14.04, 87, 6.06, 5.67, 30.72, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 2, 11.23, 87, 4.40, 5.00, 23.33, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 3, 35.29, 87, 7.55, 22.04, 51.26, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 4, 14.44, 87, 5.02, 7.00, 27.45, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 5, 22.44, 87, 5.39, 13.51, 34.88, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 6, 2.15, 87, 1.41, 0.58, 7.70, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 7, 0.42, 87, 0.42, 0.06, 3.08, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'IM', NULL, 3.65, 89, 0.16, 3.34, 3.96, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'RT', NULL, 74.34, 113, 6.91, 58.57, 85.58, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 1, 10.97, 102, 5.41, 3.95, 26.99, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 2, 29.43, 102, 6.65, 18.11, 44.04, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 3, 22.78, 102, 4.73, 14.75, 33.47, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 4, 17.63, 102, 4.75, 10.06, 29.06, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 5, 12.99, 102, 4.53, 6.32, 24.84, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 6, 5.85, 102, 4.83, 1.08, 26.13, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 7, 0.35, 102, 0.35, 0.05, 2.56, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'IM', NULL, 3.56, 104, 0.11, 3.33, 3.78, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'RT', NULL, 87.23, 116, 4.50, 75.42, 93.83, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 1, 10.31, 78, 4.88, 3.87, 24.74, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 2, 50.93, 78, 8.16, 35.13, 66.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 3, 24.10, 78, 9.51, 10.13, 47.22, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 4, 11.28, 78, 4.90, 4.58, 25.21, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 5, 3.38, 78, 2.96, 0.57, 17.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 6, 0.00, 78, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 7, 0.00, 78, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'IM', NULL, 3.53, 79, 0.18, 3.17, 3.88, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'RT', NULL, 72.90, 115, 4.25, 63.71, 80.47, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 1, 8.37, 113, 3.62, 3.46, 18.88, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 2, 34.79, 113, 10.99, 16.97, 58.21, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 3, 29.25, 113, 6.14, 18.68, 42.65, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 4, 22.58, 113, 6.76, 11.93, 38.56, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 5, 1.45, 113, 0.76, 0.50, 4.08, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 6, 3.26, 113, 1.86, 1.04, 9.77, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 7, 0.31, 113, 0.31, 0.04, 2.28, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'IM', NULL, 3.41, 114, 0.14, 3.12, 3.70, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'RT', NULL, 97.54, 116, 2.07, 87.82, 99.54, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 1, 11.59, 95, 4.18, 5.51, 22.75, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 2, 45.16, 95, 6.61, 32.65, 58.31, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 3, 20.43, 95, 7.54, 9.28, 39.20, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 4, 15.00, 95, 4.41, 8.15, 25.97, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 5, 6.37, 95, 3.68, 1.96, 18.78, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 6, 0.38, 95, 0.34, 0.06, 2.25, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 7, 1.07, 95, 0.82, 0.23, 4.84, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'IM', NULL, 3.40, 96, 0.10, 3.21, 3.60, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'RT', NULL, 88.47, 116, 3.59, 79.25, 93.91, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 1, 39.40, 71, 11.35, 20.12, 62.67, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 2, 33.39, 71, 9.93, 17.07, 54.97, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 3, 17.41, 71, 6.34, 8.04, 33.70, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 4, 9.80, 71, 6.40, 2.50, 31.50, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 5, 0.00, 71, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 6, 0.00, 71, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 7, 0.00, 71, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'IM', NULL, 3.14, 73, 0.12, 2.90, 3.37, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'RT', NULL, 67.35, 115, 5.24, 56.26, 76.79, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 1, 18.07, 70, 7.65, 7.29, 38.20, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 2, 25.68, 70, 6.83, 14.47, 41.37, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 3, 30.98, 70, 6.23, 20.07, 44.52, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 4, 12.27, 70, 5.69, 4.65, 28.64, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 5, 11.02, 70, 5.93, 3.57, 29.29, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 6, 1.50, 70, 1.53, 0.19, 10.73, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 7, 0.48, 70, 0.49, 0.06, 3.60, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'IM', NULL, 3.41, 72, 0.37, 2.67, 4.16, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'RT', NULL, 63.56, 116, 5.45, 52.25, 73.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 1, 18.07, 70, 7.65, 7.29, 38.20, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 2, 25.68, 70, 6.83, 14.47, 41.37, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 3, 30.98, 70, 6.23, 20.07, 44.52, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 4, 12.27, 70, 5.69, 4.65, 28.64, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 5, 11.02, 70, 5.93, 3.57, 29.29, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 6, 1.50, 70, 1.53, 0.19, 10.73, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 7, 0.48, 70, 0.49, 0.06, 3.60, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'IM', NULL, 3.41, 72, 0.37, 2.67, 4.16, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'RT', NULL, 63.56, 116, 5.45, 52.25, 73.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 1, 25.29, 71, 6.08, 15.12, 39.15, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 2, 43.41, 71, 6.37, 31.38, 56.28, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 3, 18.04, 71, 6.29, 8.61, 33.97, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 4, 10.43, 71, 5.62, 3.38, 27.89, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 5, 1.90, 71, 1.62, 0.34, 9.92, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 6, 0.46, 71, 0.47, 0.06, 3.47, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 7, 0.47, 71, 0.48, 0.06, 3.56, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'IM', NULL, 3.17, 72, 0.12, 2.93, 3.40, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'RT', NULL, 63.31, 116, 4.79, 53.42, 72.19, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 1, 14.48, 68, 5.38, 6.64, 28.71, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 2, 36.20, 68, 10.12, 19.14, 57.63, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 3, 38.96, 68, 10.41, 21.04, 60.46, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 4, 4.73, 68, 2.52, 1.60, 13.18, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 5, 5.19, 68, 2.14, 2.24, 11.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 6, 0.44, 68, 0.45, 0.06, 3.31, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 7, 0.00, 68, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'IM', NULL, 3.12, 68, 0.18, 2.76, 3.49, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'RT', NULL, 48.28, 116, 6.05, 36.62, 60.13, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 1, 15.93, 67, 8.29, 5.21, 39.48, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 2, 29.01, 67, 6.11, 18.44, 42.49, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 3, 40.44, 67, 8.72, 24.79, 58.32, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 4, 7.91, 67, 3.78, 2.95, 19.49, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 5, 4.28, 67, 2.17, 1.52, 11.42, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 6, 1.97, 67, 1.59, 0.39, 9.38, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 7, 0.47, 67, 0.48, 0.06, 3.50, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'IM', NULL, 3.06, 67, 0.22, 2.62, 3.51, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'RT', NULL, 66.15, 113, 4.67, 56.39, 74.72, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 1, 31.97, 88, 6.75, 20.22, 46.56, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 2, 34.68, 88, 8.46, 20.17, 52.72, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 3, 21.11, 88, 6.06, 11.49, 35.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 4, 11.21, 88, 4.73, 4.68, 24.53, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 5, 0.62, 88, 0.63, 0.08, 4.54, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 6, 0.00, 88, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 7, 0.40, 88, 0.41, 0.05, 2.98, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'IM', NULL, 2.70, 89, 0.15, 2.40, 3.01, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'RT', NULL, 74.62, 115, 4.41, 64.96, 82.34, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 1, 46.04, 48, 10.32, 27.01, 66.30, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 2, 37.45, 48, 8.50, 22.40, 55.40, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 3, 1.98, 48, 1.52, 0.42, 8.87, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 4, 13.92, 48, 6.82, 4.89, 33.71, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 5, 0.00, 48, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 6, 0.61, 48, 0.61, 0.08, 4.44, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 7, 0.00, 48, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'IM', NULL, 2.68, 50, 0.27, 2.12, 3.23, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'RT', NULL, 36.66, 115, 6.87, 24.36, 50.98, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 1, 44.79, 63, 12.41, 22.92, 68.88, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 2, 29.33, 63, 9.05, 14.78, 49.83, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 3, 14.54, 63, 5.32, 6.74, 28.60, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 4, 9.47, 63, 6.65, 2.17, 33.00, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 5, 1.40, 63, 1.07, 0.30, 6.24, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 6, 0.47, 63, 0.47, 0.06, 3.45, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 7, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'IM', NULL, 2.59, 65, 0.25, 2.09, 3.08, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'RT', NULL, 46.94, 116, 7.23, 33.24, 61.12, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 2, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 3, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 4, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 5, 34.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 6, 30.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 7, 17.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'IM', NULL, 4.22, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 2, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 3, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 4, 47.83, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 5, 21.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 6, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'IM', NULL, 4.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 2, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 3, 54.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 4, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 5, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 6, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'IM', NULL, 3.95, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'RT', NULL, 95.65, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 1, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 2, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 3, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 4, 35.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 5, 35.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 6, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'IM', NULL, 3.70, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'RT', NULL, 86.96, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 1, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 2, 30.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 3, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 4, 30.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 5, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 6, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'IM', NULL, 3.61, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 1, 17.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 2, 47.83, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 3, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 4, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 5, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 6, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'IM', NULL, 3.59, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 2, 36.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 3, 31.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 4, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 5, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 6, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 7, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'IM', NULL, 3.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'RT', NULL, 95.65, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 1, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 2, 54.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 3, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 4, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 5, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 6, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'IM', NULL, 3.50, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'RT', NULL, 100.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 2, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 3, 42.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 4, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 5, 33.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 6, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'IM', NULL, 3.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'RT', NULL, 91.30, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 1, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 2, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 3, 23.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 4, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 5, 38.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 6, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'IM', NULL, 3.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'RT', NULL, 91.30, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 1, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 2, 31.58, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 3, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 4, 26.32, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 5, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 6, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'IM', NULL, 3.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'RT', NULL, 82.61, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 1, 12.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 2, 18.75, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 3, 50.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 4, 12.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 5, 6.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 6, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 7, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'IM', NULL, 3.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'RT', NULL, 69.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 1, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 2, 47.62, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 3, 38.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 4, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 5, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'IM', NULL, 3.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'RT', NULL, 95.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 1, 0.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 2, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 3, 40.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 4, 33.33, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 5, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 6, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 7, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'IM', NULL, 4.07, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'RT', NULL, 65.22, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 1, 27.27, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 2, 18.18, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 3, 18.18, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 4, 9.09, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 5, 18.18, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 6, 9.09, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 7, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'IM', NULL, 3.55, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'RT', NULL, 50.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 1, 0.00, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 2, 44.44, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 3, 33.33, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 4, 11.11, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 5, 11.11, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 6, 0.00, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 7, 0.00, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'IM', NULL, 3.44, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'RT', NULL, 39.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 1, 12.50, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 2, 50.00, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 3, 25.00, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 4, 0.00, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 5, 12.50, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 6, 0.00, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 7, 0.00, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'IM', NULL, 3.14, 7, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'RT', NULL, 36.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'FT', 1, 1.88, 77, 1.46, 0.39, 8.52, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'FT', 2, 13.31, 77, 5.70, 5.42, 29.12, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'FT', 3, 31.69, 77, 6.95, 19.66, 46.79, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'FT', 4, 32.09, 77, 8.18, 18.29, 49.95, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'FT', 5, 14.13, 77, 4.98, 6.77, 27.15, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'FT', 6, 6.91, 77, 3.11, 2.75, 16.30, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'FT', 7, 0.00, 77, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'IM', NULL, 4.12, 77, 0.13, 3.86, 4.37, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'RT', NULL, 88.83, 91, 4.09, 77.82, 94.74, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'FT', 1, 3.31, 70, 2.22, 0.85, 12.04, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'FT', 2, 18.95, 70, 7.18, 8.42, 37.28, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'FT', 3, 11.26, 70, 4.55, 4.86, 23.96, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'FT', 4, 19.93, 70, 8.62, 7.80, 42.25, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'FT', 5, 35.60, 70, 8.02, 21.57, 52.62, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'FT', 6, 4.46, 70, 3.04, 1.11, 16.25, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'FT', 7, 6.50, 70, 3.38, 2.24, 17.44, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'IM', NULL, 4.03, 70, 0.18, 3.68, 4.39, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'RT', NULL, 79.16, 92, 6.61, 63.16, 89.38, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'FT', 1, 9.26, 79, 3.10, 4.67, 17.53, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'FT', 2, 38.60, 79, 7.63, 24.88, 54.40, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'FT', 3, 26.81, 79, 6.30, 16.20, 40.98, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'FT', 4, 16.40, 79, 7.86, 5.90, 38.05, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'FT', 5, 5.63, 79, 3.75, 1.44, 19.54, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'FT', 6, 1.43, 79, 1.08, 0.32, 6.22, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'FT', 7, 1.87, 79, 1.46, 0.39, 8.48, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'IM', NULL, 4.02, 79, 0.19, 3.65, 4.39, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'RT', NULL, 89.99, 92, 3.67, 80.01, 95.28, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'FT', 1, 0.95, 65, 0.57, 0.28, 3.14, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'FT', 2, 25.26, 65, 8.11, 12.54, 44.35, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'FT', 3, 31.84, 65, 7.49, 19.00, 48.20, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'FT', 4, 26.67, 65, 8.48, 13.26, 46.39, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'FT', 5, 8.92, 65, 4.23, 3.34, 21.71, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'FT', 6, 2.76, 65, 2.17, 0.56, 12.52, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'FT', 7, 3.60, 65, 2.60, 0.83, 14.28, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'IM', NULL, 3.96, 62, 0.17, 3.61, 4.30, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'RT', NULL, 82.94, 92, 6.10, 67.38, 91.96, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 20939, 'FT', 1, 0.23, 70, 0.24, 0.03, 1.78, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 20939, 'FT', 2, 33.79, 70, 7.41, 20.85, 49.71, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 20939, 'FT', 3, 27.60, 70, 7.43, 15.36, 44.46, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 20939, 'FT', 4, 25.63, 70, 7.90, 13.10, 44.07, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 20939, 'FT', 5, 5.48, 70, 2.93, 1.84, 15.21, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 20939, 'FT', 6, 3.43, 70, 2.12, 0.98, 11.31, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 20939, 'FT', 7, 3.85, 70, 2.72, 0.91, 14.80, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 20939, 'IM', NULL, 3.82, 69, 0.16, 3.51, 4.13, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 20939, 'RT', NULL, 82.00, 92, 4.56, 71.15, 89.37, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'FT', 1, 3.79, 80, 3.75, 0.51, 23.34, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'FT', 2, 18.54, 80, 8.36, 7.03, 40.65, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'FT', 3, 25.21, 80, 7.23, 13.57, 41.98, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'FT', 4, 16.83, 80, 6.00, 7.94, 32.21, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'FT', 5, 27.15, 80, 6.65, 16.02, 42.13, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'FT', 6, 6.29, 80, 2.78, 2.56, 14.66, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'FT', 7, 2.19, 80, 1.91, 0.38, 11.69, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'IM', NULL, 3.76, 80, 0.19, 3.38, 4.13, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'RT', NULL, 89.70, 92, 4.12, 78.23, 95.48, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'FT', 1, 8.60, 59, 6.12, 1.94, 30.91, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'FT', 2, 19.05, 59, 7.24, 8.43, 37.58, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'FT', 3, 43.50, 59, 8.52, 27.78, 60.64, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'FT', 4, 12.80, 59, 6.14, 4.66, 30.61, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'FT', 5, 15.61, 59, 5.41, 7.51, 29.63, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'FT', 6, 0.43, 59, 0.45, 0.06, 3.32, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'FT', 7, 0.00, 59, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'IM', NULL, 3.66, 58, 0.14, 3.38, 3.94, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'RT', NULL, 69.20, 91, 6.89, 54.19, 81.02, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'FT', 1, 3.05, 63, 2.44, 0.60, 14.05, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'FT', 2, 20.82, 63, 8.69, 8.40, 42.99, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'FT', 3, 21.40, 63, 7.47, 10.07, 39.83, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'FT', 4, 19.19, 63, 6.24, 9.60, 34.69, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'FT', 5, 28.63, 63, 7.01, 16.81, 44.34, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'FT', 6, 6.05, 63, 3.39, 1.91, 17.52, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'FT', 7, 0.86, 63, 0.64, 0.19, 3.73, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'IM', NULL, 3.64, 63, 0.17, 3.30, 3.99, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'RT', NULL, 70.55, 92, 6.38, 56.55, 81.52, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'FT', 1, 5.28, 60, 2.73, 1.83, 14.27, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'FT', 2, 13.39, 60, 4.16, 7.02, 24.06, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'FT', 3, 29.98, 60, 11.08, 12.96, 55.18, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'FT', 4, 15.88, 60, 4.52, 8.75, 27.09, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'FT', 5, 26.22, 60, 7.50, 14.06, 43.57, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'FT', 6, 2.93, 60, 2.61, 0.48, 15.90, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'FT', 7, 6.31, 60, 3.85, 1.79, 19.88, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'IM', NULL, 4.20, 62, 0.12, 3.97, 4.43, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'RT', NULL, 61.35, 92, 7.98, 44.86, 75.60, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'FT', 1, 13.78, 37, 8.96, 3.35, 42.44, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'FT', 2, 0.76, 37, 0.57, 0.17, 3.39, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'FT', 3, 18.20, 37, 6.55, 8.35, 35.18, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'FT', 4, 27.01, 37, 12.26, 9.49, 56.64, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'FT', 5, 23.59, 37, 8.64, 10.46, 44.94, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'FT', 6, 11.15, 37, 5.46, 3.94, 27.74, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'FT', 7, 5.51, 37, 3.64, 1.39, 19.43, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'IM', NULL, 3.71, 38, 0.30, 3.11, 4.32, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'RT', NULL, 43.87, 92, 6.26, 32.06, 56.43, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'FT', 1, 10.52, 55, 5.24, 3.70, 26.42, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'FT', 2, 9.36, 55, 3.87, 3.97, 20.50, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'FT', 3, 44.71, 55, 8.71, 28.51, 62.11, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'FT', 4, 15.78, 55, 6.59, 6.49, 33.62, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'FT', 5, 17.33, 55, 6.34, 7.94, 33.74, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'FT', 6, 2.31, 55, 2.07, 0.37, 12.97, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'FT', 7, 0.00, 55, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'IM', NULL, 3.69, 55, 0.20, 3.30, 4.08, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'RT', NULL, 65.88, 92, 6.30, 52.53, 77.11, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'FT', 1, 5.35, 59, 3.17, 1.59, 16.50, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'FT', 2, 37.41, 59, 9.38, 21.14, 57.13, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'FT', 3, 26.69, 59, 7.74, 14.15, 44.57, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'FT', 4, 22.31, 59, 9.60, 8.66, 46.53, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'FT', 5, 6.02, 59, 3.77, 1.66, 19.55, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'FT', 6, 2.21, 59, 1.93, 0.38, 11.87, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'FT', 7, 0.00, 59, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'IM', NULL, 3.64, 59, 0.21, 3.21, 4.06, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'RT', NULL, 64.06, 92, 7.26, 48.79, 76.93, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'FT', 1, 5.38, 59, 3.15, 1.62, 16.42, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'FT', 2, 24.57, 59, 9.32, 10.63, 47.13, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'FT', 3, 29.40, 59, 7.40, 16.94, 45.96, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'FT', 4, 22.03, 59, 6.86, 11.28, 38.59, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'FT', 5, 14.60, 59, 6.67, 5.54, 33.28, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'FT', 6, 0.94, 59, 0.96, 0.12, 7.03, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'FT', 7, 3.08, 59, 2.68, 0.52, 16.12, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'IM', NULL, 3.61, 57, 0.14, 3.34, 3.89, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'RT', NULL, 63.58, 92, 7.03, 48.86, 76.13, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'FT', 1, 2.61, 57, 2.17, 0.48, 12.89, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'FT', 2, 32.96, 57, 8.96, 17.91, 52.56, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'FT', 3, 30.83, 57, 8.13, 17.20, 48.88, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'FT', 4, 24.35, 57, 6.90, 13.19, 40.53, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'FT', 5, 8.91, 57, 4.28, 3.29, 21.95, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'FT', 6, 0.33, 57, 0.34, 0.04, 2.55, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'FT', 7, 0.00, 57, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'IM', NULL, 3.57, 57, 0.15, 3.28, 3.87, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'RT', NULL, 66.66, 92, 6.20, 53.46, 77.67, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 20940, 'FT', 1, 44.58, 44, 11.14, 24.48, 66.63, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 20940, 'FT', 2, 46.13, 44, 10.95, 26.05, 67.55, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 20940, 'FT', 3, 8.86, 44, 4.05, 3.41, 21.11, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 20940, 'FT', 4, 0.43, 44, 0.34, 0.09, 2.07, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 20940, 'FT', 5, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 20940, 'FT', 6, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 20940, 'FT', 7, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 20940, 'IM', NULL, 3.46, 46, 0.38, 2.70, 4.22, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 20940, 'RT', NULL, 56.61, 92, 8.98, 38.69, 72.95, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'FT', 1, 13.96, 44, 6.42, 5.23, 32.30, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'FT', 2, 47.69, 44, 9.55, 29.64, 66.37, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'FT', 3, 20.57, 44, 8.04, 8.76, 41.11, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'FT', 4, 13.82, 44, 6.48, 5.08, 32.44, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'FT', 5, 3.96, 44, 3.85, 0.53, 24.06, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'FT', 6, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'FT', 7, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'IM', NULL, 3.15, 44, 0.29, 2.56, 3.73, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'RT', NULL, 53.08, 92, 7.59, 38.18, 67.44, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'FT', 1, 25.29, 34, 10.71, 9.65, 51.74, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'FT', 2, 36.05, 34, 13.42, 14.72, 64.81, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'FT', 3, 21.70, 34, 9.46, 8.20, 46.24, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'FT', 4, 14.13, 34, 9.11, 3.45, 43.14, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'FT', 5, 2.83, 34, 2.86, 0.35, 19.50, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'FT', 6, 0.00, 34, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'FT', 7, 0.00, 34, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'IM', NULL, 3.06, 34, 0.24, 2.56, 3.56, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'RT', NULL, 48.11, 92, 8.69, 31.72, 64.93, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'FT', 1, 24.61, 24, 13.83, 6.53, 60.40, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'FT', 2, 35.95, 24, 13.05, 14.80, 64.45, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'FT', 3, 19.02, 24, 10.98, 5.10, 50.64, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'FT', 4, 20.01, 24, 10.46, 6.08, 49.16, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'FT', 5, 0.41, 24, 0.43, 0.05, 3.45, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'FT', 6, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'FT', 7, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'IM', NULL, 2.81, 25, 0.38, 2.02, 3.60, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'RT', NULL, 37.76, 91, 7.20, 24.82, 52.72, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'FT', 1, 26.65, 33, 12.16, 9.28, 56.33, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'FT', 2, 37.25, 33, 12.35, 16.82, 63.53, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'FT', 3, 26.86, 33, 10.40, 11.11, 51.91, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'FT', 4, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'FT', 5, 9.25, 33, 5.73, 2.47, 29.05, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'FT', 6, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'FT', 7, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'IM', NULL, 2.64, 34, 0.35, 1.92, 3.35, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'RT', NULL, 37.45, 92, 6.84, 25.11, 51.66, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'FT', 1, 6.75, 40, 6.05, 1.02, 33.62, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'FT', 2, 40.72, 40, 11.41, 20.89, 64.13, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'FT', 3, 34.51, 40, 8.50, 19.76, 52.99, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'FT', 4, 9.09, 40, 4.54, 3.19, 23.30, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'FT', 5, 7.86, 40, 4.41, 2.43, 22.62, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'FT', 6, 0.58, 40, 0.59, 0.07, 4.48, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'FT', 7, 0.48, 40, 0.50, 0.06, 3.84, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'IM', NULL, 2.59, 40, 0.22, 2.15, 3.03, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'RT', NULL, 50.41, 92, 7.58, 35.76, 64.99, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'FT', 1, 43.86, 22, 15.25, 17.74, 73.90, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'FT', 2, 18.01, 22, 12.47, 3.65, 56.00, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'FT', 3, 24.57, 22, 11.23, 8.46, 53.46, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'FT', 4, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'FT', 5, 13.55, 22, 10.62, 2.33, 50.80, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'FT', 6, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'FT', 7, 0.00, 22, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'IM', NULL, 2.59, 22, 0.47, 1.62, 3.56, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'RT', NULL, 30.91, 92, 7.67, 17.98, 47.74, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 18, 'FT', 1, 8.61, 106, 3.66, 3.61, 19.16, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 18, 'FT', 2, 11.76, 106, 3.80, 6.05, 21.59, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 18, 'FT', 3, 7.44, 106, 3.77, 2.64, 19.23, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 18, 'FT', 4, 8.66, 106, 2.99, 4.30, 16.70, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 18, 'FT', 5, 43.41, 106, 6.32, 31.53, 56.10, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 18, 'FT', 6, 11.43, 106, 3.83, 5.74, 21.47, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 18, 'FT', 7, 8.69, 106, 3.75, 3.59, 19.55, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 18, 'IM', NULL, 3.89, 102, 0.13, 3.63, 4.16, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 18, 'RT', NULL, 73.06, 133, 7.17, 56.88, 84.79, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 21, 'FT', 1, 8.10, 105, 3.40, 3.45, 17.90, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 21, 'FT', 2, 19.64, 105, 4.55, 12.13, 30.20, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 21, 'FT', 3, 16.00, 105, 5.33, 7.99, 29.49, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 21, 'FT', 4, 15.94, 105, 4.78, 8.55, 27.78, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 21, 'FT', 5, 35.45, 105, 8.05, 21.47, 52.45, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 21, 'FT', 6, 3.54, 105, 1.99, 1.14, 10.45, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 21, 'FT', 7, 1.31, 105, 1.32, 0.18, 9.11, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 21, 'IM', NULL, 3.71, 103, 0.17, 3.37, 4.05, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 21, 'RT', NULL, 77.98, 133, 4.39, 68.10, 85.45, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 20, 'FT', 1, 15.34, 123, 8.10, 5.01, 38.39, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 20, 'FT', 2, 24.95, 123, 6.39, 14.48, 39.50, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 20, 'FT', 3, 21.90, 123, 5.02, 13.56, 33.40, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 20, 'FT', 4, 8.62, 123, 2.68, 4.59, 15.60, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 20, 'FT', 5, 25.11, 123, 5.04, 16.48, 36.31, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 20, 'FT', 6, 1.74, 123, 1.07, 0.51, 5.74, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 20, 'FT', 7, 2.33, 123, 1.66, 0.56, 9.16, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 20, 'IM', NULL, 3.70, 122, 0.08, 3.54, 3.86, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 20, 'RT', NULL, 92.79, 133, 2.44, 86.20, 96.36, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 23, 'FT', 1, 6.06, 95, 2.52, 2.60, 13.46, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 23, 'FT', 2, 10.34, 95, 3.06, 5.65, 18.16, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 23, 'FT', 3, 22.25, 95, 5.60, 13.07, 35.25, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 23, 'FT', 4, 26.12, 95, 9.07, 12.20, 47.34, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 23, 'FT', 5, 32.91, 95, 5.71, 22.70, 45.04, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 23, 'FT', 6, 0.74, 95, 0.75, 0.10, 5.33, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 23, 'FT', 7, 1.59, 95, 1.61, 0.21, 11.02, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 23, 'IM', NULL, 3.38, 91, 0.11, 3.17, 3.59, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 23, 'RT', NULL, 71.93, 133, 5.48, 59.97, 81.43, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 22, 'FT', 1, 11.83, 126, 3.74, 6.19, 21.42, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 22, 'FT', 2, 33.82, 126, 7.21, 21.27, 49.15, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 22, 'FT', 3, 20.77, 126, 6.31, 10.93, 35.88, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 22, 'FT', 4, 13.24, 126, 3.21, 8.06, 20.98, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 22, 'FT', 5, 17.17, 126, 3.96, 10.68, 26.45, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 22, 'FT', 6, 3.15, 126, 1.43, 1.27, 7.59, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 22, 'FT', 7, 0.03, 126, 0.03, 0.00, 0.19, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 22, 'IM', NULL, 3.33, 122, 0.09, 3.15, 3.51, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 22, 'RT', NULL, 96.32, 134, 1.38, 92.37, 98.26, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 30, 'FT', 1, 26.98, 100, 6.28, 16.41, 41.03, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 30, 'FT', 2, 48.59, 100, 9.24, 31.21, 66.31, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 30, 'FT', 3, 21.23, 100, 4.93, 13.05, 32.61, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 30, 'FT', 4, 0.45, 100, 0.45, 0.06, 3.25, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 30, 'FT', 5, 2.74, 100, 1.70, 0.79, 9.06, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 30, 'FT', 6, 0.00, 100, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 30, 'FT', 7, 0.00, 100, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 30, 'IM', NULL, 3.19, 96, 0.11, 2.98, 3.41, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 30, 'RT', NULL, 74.75, 134, 5.74, 61.88, 84.38, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 24, 'FT', 1, 5.22, 98, 2.24, 2.19, 11.92, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 24, 'FT', 2, 21.83, 98, 5.53, 12.80, 34.69, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 24, 'FT', 3, 16.67, 98, 3.76, 10.46, 25.51, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 24, 'FT', 4, 12.28, 98, 3.73, 6.57, 21.78, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 24, 'FT', 5, 35.15, 98, 5.59, 24.98, 46.87, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 24, 'FT', 6, 2.06, 98, 1.21, 0.63, 6.49, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 24, 'FT', 7, 6.80, 98, 2.70, 3.04, 14.52, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 24, 'IM', NULL, 4.06, 99, 0.11, 3.85, 4.27, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 24, 'RT', NULL, 66.15, 133, 6.95, 51.40, 78.31, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 26, 'FT', 1, 50.82, 77, 7.22, 36.77, 64.74, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 26, 'FT', 2, 36.24, 77, 7.55, 22.87, 52.15, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 26, 'FT', 3, 5.24, 77, 2.96, 1.66, 15.37, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 26, 'FT', 4, 0.85, 77, 0.85, 0.12, 5.95, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 26, 'FT', 5, 4.80, 77, 2.98, 1.36, 15.62, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 26, 'FT', 6, 0.00, 77, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 26, 'FT', 7, 2.04, 77, 2.06, 0.27, 13.97, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 26, 'IM', NULL, 3.95, 74, 0.14, 3.67, 4.22, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 26, 'RT', NULL, 56.26, 133, 6.87, 42.55, 69.08, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 19, 'FT', 1, 4.44, 93, 2.44, 1.46, 12.73, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 19, 'FT', 2, 8.95, 93, 3.52, 3.99, 18.83, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 19, 'FT', 3, 9.29, 93, 3.53, 4.26, 19.06, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 19, 'FT', 4, 6.61, 93, 2.64, 2.94, 14.19, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 19, 'FT', 5, 47.35, 93, 7.44, 33.21, 61.93, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 19, 'FT', 6, 14.02, 93, 6.05, 5.68, 30.63, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 19, 'FT', 7, 9.34, 93, 4.59, 3.40, 23.20, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 19, 'IM', NULL, 3.92, 94, 0.12, 3.68, 4.15, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 19, 'RT', NULL, 63.80, 133, 6.62, 50.00, 75.65, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 25, 'FT', 1, 19.93, 62, 7.03, 9.35, 37.53, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 25, 'FT', 2, 22.87, 62, 5.77, 13.36, 36.31, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 25, 'FT', 3, 14.72, 62, 5.13, 7.09, 28.10, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 25, 'FT', 4, 6.85, 62, 3.33, 2.53, 17.28, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 25, 'FT', 5, 24.71, 62, 6.06, 14.61, 38.63, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 25, 'FT', 6, 5.05, 62, 4.91, 0.68, 29.17, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 25, 'FT', 7, 5.87, 62, 3.70, 1.61, 19.21, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 25, 'IM', NULL, 3.72, 62, 0.20, 3.33, 4.12, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 25, 'RT', NULL, 41.35, 134, 5.43, 31.17, 52.33, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 27, 'FT', 1, 6.80, 68, 3.86, 2.12, 19.74, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 27, 'FT', 2, 29.82, 68, 11.55, 12.37, 56.11, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 27, 'FT', 3, 24.34, 68, 7.21, 12.83, 41.29, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 27, 'FT', 4, 7.94, 68, 3.31, 3.38, 17.57, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 27, 'FT', 5, 17.70, 68, 5.02, 9.75, 29.97, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 27, 'FT', 6, 8.01, 68, 4.66, 2.40, 23.53, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 27, 'FT', 7, 5.39, 68, 2.75, 1.91, 14.30, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 27, 'IM', NULL, 3.70, 68, 0.18, 3.35, 4.06, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 27, 'RT', NULL, 53.71, 134, 6.27, 41.34, 65.64, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 28, 'FT', 1, 36.52, 30, 10.71, 18.28, 59.67, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 28, 'FT', 2, 26.42, 30, 9.81, 11.34, 50.20, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 28, 'FT', 3, 21.34, 30, 8.59, 8.70, 43.59, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 28, 'FT', 4, 1.44, 30, 1.43, 0.19, 10.32, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 28, 'FT', 5, 14.28, 30, 7.33, 4.67, 36.17, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 28, 'FT', 6, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 28, 'FT', 7, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 28, 'IM', NULL, 3.33, 30, 0.19, 2.95, 3.71, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 28, 'RT', NULL, 22.73, 131, 4.53, 15.02, 32.88, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 29, 'FT', 1, 24.55, 49, 5.54, 15.13, 37.26, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 29, 'FT', 2, 29.03, 49, 9.00, 14.53, 49.60, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 29, 'FT', 3, 22.74, 49, 8.07, 10.46, 42.58, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 29, 'FT', 4, 9.49, 49, 4.52, 3.52, 23.18, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 29, 'FT', 5, 14.18, 49, 7.44, 4.61, 36.10, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 29, 'FT', 6, 0.00, 49, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 29, 'FT', 7, 0.00, 49, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 29, 'IM', NULL, 3.33, 48, 0.13, 3.07, 3.59, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 29, 'RT', NULL, 30.73, 133, 4.90, 21.97, 41.15, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 31, 'FT', 1, 32.59, 74, 6.98, 20.42, 47.66, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 31, 'FT', 2, 33.12, 74, 6.14, 22.19, 46.24, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 31, 'FT', 3, 15.23, 74, 3.82, 9.05, 24.48, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 31, 'FT', 4, 6.75, 74, 3.87, 2.08, 19.76, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 31, 'FT', 5, 11.63, 74, 4.99, 4.76, 25.71, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 31, 'FT', 6, 0.69, 74, 0.69, 0.09, 4.99, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 31, 'FT', 7, 0.00, 74, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 31, 'IM', NULL, 2.72, 74, 0.10, 2.53, 2.91, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3011.00', 31, 'RT', NULL, 49.75, 134, 6.25, 37.64, 61.89, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 1, 0.00, 75, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 2, 4.62, 75, 2.91, 1.28, 15.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 3, 28.19, 75, 8.25, 14.83, 46.93, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 4, 9.83, 75, 4.02, 4.23, 21.19, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 5, 44.98, 75, 8.82, 28.66, 62.46, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 6, 9.35, 75, 4.21, 3.69, 21.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 7, 3.04, 75, 2.06, 0.78, 11.20, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'IM', NULL, 4.11, 74, 0.13, 3.85, 4.37, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'RT', NULL, 99.97, 76, 0.03, 99.80, 100.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 1, 0.00, 74, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 2, 5.66, 74, 3.39, 1.67, 17.52, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 3, 30.46, 74, 8.39, 16.59, 49.09, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 4, 36.39, 74, 8.54, 21.52, 54.41, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 5, 25.21, 74, 5.82, 15.42, 38.41, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 6, 2.27, 74, 1.70, 0.51, 9.62, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 7, 0.00, 74, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'IM', NULL, 4.10, 73, 0.11, 3.89, 4.31, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'RT', NULL, 94.97, 76, 4.65, 73.08, 99.24, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 1, 0.00, 74, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 2, 6.14, 74, 4.29, 1.46, 22.37, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 3, 33.54, 74, 7.86, 19.99, 50.48, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 4, 26.09, 74, 7.50, 13.98, 43.39, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 5, 32.93, 74, 7.61, 19.81, 49.39, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 6, 1.29, 74, 0.80, 0.37, 4.37, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 7, 0.00, 74, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'IM', NULL, 4.08, 74, 0.14, 3.80, 4.36, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'RT', NULL, 99.97, 75, 0.03, 99.78, 100.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 1, 0.00, 69, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 2, 0.48, 69, 0.36, 0.10, 2.17, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 3, 10.22, 69, 5.56, 3.28, 27.62, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 4, 32.97, 69, 10.98, 15.43, 57.01, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 5, 42.13, 69, 13.57, 19.33, 68.86, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 6, 12.84, 69, 6.04, 4.77, 30.20, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 7, 1.37, 69, 1.39, 0.18, 9.71, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'IM', NULL, 4.04, 69, 0.12, 3.81, 4.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'RT', NULL, 92.97, 76, 4.44, 77.38, 98.08, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 1, 0.00, 70, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 2, 7.60, 70, 4.31, 2.36, 21.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 3, 7.26, 70, 4.82, 1.84, 24.61, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 4, 22.95, 70, 7.89, 10.90, 42.04, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 5, 37.16, 70, 9.88, 20.27, 57.90, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 6, 13.37, 70, 6.95, 4.45, 33.82, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 7, 11.67, 70, 7.66, 2.91, 36.79, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'IM', NULL, 3.99, 70, 0.11, 3.76, 4.21, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'RT', NULL, 91.34, 76, 5.14, 74.28, 97.47, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 1, 10.05, 68, 7.54, 2.07, 37.14, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 2, 20.15, 68, 6.92, 9.66, 37.31, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 3, 29.74, 68, 9.53, 14.55, 51.26, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 4, 17.57, 68, 6.64, 7.86, 34.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 5, 17.82, 68, 8.90, 6.06, 42.18, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 6, 4.67, 68, 3.57, 0.98, 19.52, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 7, 0.00, 68, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'IM', NULL, 3.94, 68, 0.19, 3.57, 4.31, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'RT', NULL, 81.61, 76, 11.32, 49.68, 95.23, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 1, 26.07, 73, 10.00, 11.14, 49.79, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 2, 32.64, 73, 8.01, 18.98, 50.04, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 3, 6.07, 73, 3.17, 2.09, 16.35, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 4, 17.23, 73, 7.65, 6.67, 37.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 5, 15.84, 73, 7.13, 6.09, 35.33, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 6, 0.86, 73, 0.73, 0.16, 4.54, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 7, 1.30, 73, 1.31, 0.17, 9.18, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'IM', NULL, 3.88, 73, 0.15, 3.59, 4.18, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'RT', NULL, 98.01, 76, 1.61, 90.54, 99.61, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 1, 0.00, 76, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 2, 12.03, 76, 5.78, 4.40, 28.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 3, 24.84, 76, 7.69, 12.70, 42.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 4, 34.60, 76, 8.13, 20.54, 51.98, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 5, 23.49, 76, 6.26, 13.29, 38.07, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 6, 4.73, 76, 3.81, 0.91, 21.12, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 7, 0.32, 76, 0.32, 0.04, 2.35, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'IM', NULL, 3.88, 76, 0.21, 3.46, 4.31, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'RT', NULL, 100.00, 76, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 1, 0.33, 72, 0.33, 0.04, 2.44, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 2, 5.64, 72, 3.63, 1.51, 18.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 3, 49.62, 72, 8.54, 33.27, 66.05, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 4, 26.17, 72, 7.54, 14.00, 43.57, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 5, 13.71, 72, 4.28, 7.16, 24.64, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 6, 4.18, 72, 2.49, 1.25, 13.08, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 7, 0.36, 72, 0.36, 0.05, 2.66, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'IM', NULL, 3.85, 72, 0.14, 3.57, 4.12, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'RT', NULL, 85.98, 76, 6.77, 66.71, 94.94, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 1, 0.65, 72, 0.45, 0.16, 2.55, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 2, 17.79, 72, 8.58, 6.30, 41.08, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 3, 38.33, 72, 8.09, 23.91, 55.16, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 4, 30.41, 72, 8.53, 16.36, 49.39, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 5, 11.16, 72, 3.95, 5.37, 21.76, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 6, 0.00, 72, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 7, 1.66, 72, 1.41, 0.30, 8.66, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'IM', NULL, 3.70, 72, 0.17, 3.37, 4.03, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'RT', NULL, 93.86, 76, 3.68, 81.05, 98.20, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 1, 7.33, 75, 4.00, 2.39, 20.39, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 2, 29.73, 75, 7.70, 16.87, 46.87, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 3, 27.04, 75, 8.13, 14.02, 45.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 4, 13.87, 75, 6.12, 5.48, 30.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 5, 12.71, 75, 6.12, 4.62, 30.43, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 6, 9.31, 75, 6.80, 2.02, 33.83, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 7, 0.00, 75, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'IM', NULL, 3.70, 75, 0.25, 3.20, 4.20, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'RT', NULL, 97.24, 76, 2.81, 81.41, 99.65, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 1, 3.15, 66, 2.81, 0.51, 16.98, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 2, 8.11, 66, 3.60, 3.26, 18.79, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 3, 48.13, 66, 8.19, 32.51, 64.11, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 4, 31.09, 66, 9.93, 15.16, 53.24, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 5, 6.51, 66, 3.41, 2.22, 17.60, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 6, 3.01, 66, 2.04, 0.77, 11.12, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 7, 0.00, 66, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'IM', NULL, 3.68, 66, 0.15, 3.37, 3.99, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'RT', NULL, 87.19, 76, 6.33, 68.78, 95.46, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 1, 1.77, 74, 1.63, 0.28, 10.39, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 2, 10.01, 74, 6.93, 2.34, 34.01, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 3, 24.34, 74, 8.50, 11.37, 44.66, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 4, 26.60, 74, 7.01, 15.05, 42.57, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 5, 35.79, 74, 8.85, 20.55, 54.57, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 6, 0.63, 74, 0.60, 0.09, 4.14, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 7, 0.86, 74, 0.65, 0.19, 3.80, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'IM', NULL, 3.63, 74, 0.21, 3.22, 4.04, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'RT', NULL, 95.71, 76, 3.63, 79.32, 99.24, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 1, 0.82, 58, 0.82, 0.11, 5.87, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 2, 20.07, 58, 7.01, 9.47, 37.60, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 3, 61.75, 58, 9.10, 42.73, 77.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 4, 9.28, 58, 3.44, 4.32, 18.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 5, 7.62, 58, 3.86, 2.67, 19.85, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 6, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 7, 0.45, 58, 0.46, 0.06, 3.31, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'IM', NULL, 3.59, 60, 0.16, 3.28, 3.91, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'RT', NULL, 70.83, 76, 10.37, 47.19, 86.83, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 1, 16.44, 68, 8.99, 5.06, 42.06, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 2, 15.54, 68, 5.30, 7.59, 29.19, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 3, 32.15, 68, 9.53, 16.54, 53.12, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 4, 17.90, 68, 6.90, 7.87, 35.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 5, 17.96, 68, 7.69, 7.18, 38.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 6, 0.00, 68, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 7, 0.00, 68, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'IM', NULL, 3.53, 68, 0.23, 3.07, 4.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'RT', NULL, 84.33, 76, 11.07, 50.37, 96.61, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 1, 14.32, 67, 7.65, 4.59, 36.73, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 2, 31.00, 67, 10.64, 14.27, 54.80, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 3, 28.72, 67, 8.39, 15.09, 47.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 4, 21.33, 67, 9.06, 8.45, 44.36, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 5, 4.59, 67, 3.12, 1.15, 16.62, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 6, 0.03, 67, 0.03, 0.00, 0.23, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 7, 0.00, 67, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'IM', NULL, 3.39, 67, 0.22, 2.95, 3.82, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'RT', NULL, 88.84, 76, 7.10, 65.67, 97.07, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 1, 0.00, 60, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 2, 10.59, 60, 7.07, 2.59, 34.54, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 3, 4.90, 60, 2.53, 1.71, 13.23, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 4, 15.14, 60, 7.00, 5.66, 34.69, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 5, 46.91, 60, 10.24, 27.96, 66.79, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 6, 9.81, 60, 7.04, 2.17, 34.82, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 7, 12.66, 60, 5.75, 4.86, 29.11, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'IM', NULL, 4.19, 60, 0.20, 3.78, 4.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'RT', NULL, 65.58, 76, 13.98, 35.69, 86.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 1, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 2, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 3, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 4, 3.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 5, 50.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 6, 33.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 7, 13.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'IM', NULL, 4.53, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'RT', NULL, 100.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 1, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 2, 16.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 3, 16.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 4, 26.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 5, 33.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 6, 3.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 7, 3.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'IM', NULL, 4.40, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'RT', NULL, 100.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 1, 6.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 2, 40.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 3, 26.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 4, 20.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 5, 6.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 6, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 7, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'IM', NULL, 4.38, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'RT', NULL, 100.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 1, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 2, 3.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 3, 40.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 4, 20.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 5, 26.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 6, 3.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 7, 6.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'IM', NULL, 4.37, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'RT', NULL, 100.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 1, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 2, 6.90, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 3, 55.17, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 4, 17.24, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 5, 20.69, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 6, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 7, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'IM', NULL, 4.34, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'RT', NULL, 100.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 1, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 2, 3.45, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 3, 20.69, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 4, 34.48, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 5, 34.48, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 6, 6.90, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 7, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'IM', NULL, 4.28, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'RT', NULL, 96.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 1, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 2, 13.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 3, 56.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 4, 20.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 5, 10.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 6, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 7, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'IM', NULL, 4.27, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'RT', NULL, 100.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 1, 3.45, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 2, 34.48, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 3, 34.48, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 4, 13.79, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 5, 13.79, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 6, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 7, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'IM', NULL, 4.14, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'RT', NULL, 96.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 1, 6.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 2, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 3, 43.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 4, 13.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 5, 36.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 6, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 7, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'IM', NULL, 4.13, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'RT', NULL, 100.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 1, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 2, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 3, 40.74, 27, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 4, 22.22, 27, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 5, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 6, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'IM', NULL, 4.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'RT', NULL, 90.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 1, 3.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 2, 43.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 3, 30.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 4, 3.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 5, 20.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 6, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 7, 0.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'IM', NULL, 3.90, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'RT', NULL, 100.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 1, 3.45, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 2, 27.59, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 3, 37.93, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 4, 24.14, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 5, 6.90, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 6, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 7, 0.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'IM', NULL, 3.86, 29, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'RT', NULL, 96.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 1, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 2, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 3, 15.38, 26, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 4, 30.77, 26, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 5, 53.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 6, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 7, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'IM', NULL, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'RT', NULL, 86.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 1, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 2, 29.63, 27, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 3, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 4, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 5, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 6, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'IM', NULL, 3.81, 26, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'RT', NULL, 90.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 1, 15.38, 26, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 2, 42.31, 26, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 3, 26.92, 26, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 4, 15.38, 26, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 5, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 6, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 7, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'IM', NULL, 3.62, 26, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'RT', NULL, 86.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 1, 17.86, 28, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 2, 46.43, 28, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 3, 28.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 4, 3.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 5, 3.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 6, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 7, 0.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'IM', NULL, 3.29, 28, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'RT', NULL, 93.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 1, 16.67, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 2, 72.22, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 3, 11.11, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 4, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 5, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 6, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'IM', NULL, 3.94, 17, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'RT', NULL, 60.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 1, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 2, 0.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 3, 73.33, 15, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 4, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 5, 13.33, 15, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 6, 0.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 7, 0.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'IM', NULL, 3.80, 15, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'RT', NULL, 50.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 1, 5.56, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 2, 55.56, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 3, 33.33, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 4, 5.56, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 5, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 6, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'IM', NULL, 3.33, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'RT', NULL, 60.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 1, 26.32, 19, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 2, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 3, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 4, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 5, 42.11, 19, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 6, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'IM', NULL, 3.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'RT', NULL, 66.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 1, 11.11, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 2, 38.89, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 3, 44.44, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 4, 5.56, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 5, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 6, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 7, 0.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'IM', NULL, 3.22, 18, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'RT', NULL, 60.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 1, 17.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 2, 47.83, 23, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 3, 30.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 4, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 5, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'IM', NULL, 2.91, 23, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'RT', NULL, 76.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'FT', 1, 0.00, 76, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'FT', 2, 5.23, 76, 3.41, 1.38, 17.87, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'FT', 3, 10.67, 76, 4.29, 4.64, 22.65, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'FT', 4, 5.79, 76, 2.80, 2.16, 14.61, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'FT', 5, 44.61, 76, 8.44, 28.97, 61.38, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'FT', 6, 10.63, 76, 4.38, 4.54, 22.95, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'FT', 7, 23.07, 76, 9.11, 9.73, 45.48, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'IM', NULL, 4.14, 78, 0.18, 3.78, 4.51, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'RT', NULL, 89.61, 86, 3.90, 78.93, 95.21, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'FT', 1, 0.00, 76, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'FT', 2, 0.00, 76, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'FT', 3, 28.43, 76, 9.84, 13.17, 50.99, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'FT', 4, 7.10, 76, 4.27, 2.06, 21.74, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'FT', 5, 41.79, 76, 9.67, 24.54, 61.30, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'FT', 6, 13.66, 76, 4.61, 6.77, 25.63, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'FT', 7, 9.02, 76, 4.11, 3.53, 21.19, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'IM', NULL, 4.14, 78, 0.10, 3.94, 4.33, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'RT', NULL, 90.45, 86, 4.38, 77.58, 96.29, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 20462, 'FT', 1, 19.74, 68, 6.40, 9.89, 35.51, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 20462, 'FT', 2, 63.24, 68, 8.26, 45.83, 77.76, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 20462, 'FT', 3, 7.08, 68, 3.78, 2.36, 19.35, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 20462, 'FT', 4, 3.32, 68, 3.31, 0.44, 21.22, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 20462, 'FT', 5, 3.92, 68, 3.42, 0.66, 19.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 20462, 'FT', 6, 2.70, 68, 2.37, 0.46, 14.34, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 20462, 'FT', 7, 0.00, 68, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 20462, 'IM', NULL, 3.63, 70, 0.12, 3.38, 3.88, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 20462, 'RT', NULL, 83.08, 86, 5.98, 67.82, 91.96, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'FT', 1, 6.54, 59, 3.79, 1.98, 19.51, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'FT', 2, 19.46, 59, 6.89, 9.11, 36.81, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'FT', 3, 48.18, 59, 11.65, 26.76, 70.28, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'FT', 4, 18.52, 59, 6.10, 9.19, 33.81, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'FT', 5, 6.26, 59, 3.27, 2.14, 16.93, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'FT', 6, 0.60, 59, 0.47, 0.13, 2.85, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'FT', 7, 0.43, 59, 0.45, 0.05, 3.34, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'IM', NULL, 3.56, 59, 0.12, 3.32, 3.80, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'RT', NULL, 69.50, 86, 9.11, 49.23, 84.26, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'FT', 1, 14.84, 63, 6.45, 5.92, 32.57, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'FT', 2, 36.55, 63, 13.00, 15.82, 63.84, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'FT', 3, 26.04, 63, 7.17, 14.34, 42.57, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'FT', 4, 6.42, 63, 3.24, 2.28, 16.76, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'FT', 5, 10.27, 63, 5.76, 3.18, 28.52, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'FT', 6, 4.42, 63, 4.15, 0.64, 24.78, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'FT', 7, 1.45, 63, 1.29, 0.24, 8.20, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'IM', NULL, 3.49, 65, 0.11, 3.26, 3.72, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'RT', NULL, 69.12, 86, 12.45, 41.24, 87.72, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 20463, 'FT', 1, 7.27, 55, 3.58, 2.63, 18.54, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 20463, 'FT', 2, 47.00, 55, 9.22, 29.69, 65.07, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 20463, 'FT', 3, 20.54, 55, 4.97, 12.31, 32.26, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 20463, 'FT', 4, 10.86, 55, 5.74, 3.58, 28.55, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 20463, 'FT', 5, 14.32, 55, 8.06, 4.29, 38.41, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 20463, 'FT', 6, 0.00, 55, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 20463, 'FT', 7, 0.00, 55, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 20463, 'IM', NULL, 3.47, 55, 0.22, 3.04, 3.90, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 20463, 'RT', NULL, 69.51, 86, 8.57, 50.50, 83.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'FT', 1, 0.58, 50, 0.58, 0.08, 4.26, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'FT', 2, 3.48, 50, 3.18, 0.53, 19.47, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'FT', 3, 13.44, 50, 5.55, 5.62, 28.82, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'FT', 4, 9.05, 50, 4.52, 3.20, 23.06, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'FT', 5, 17.63, 50, 7.75, 6.82, 38.49, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'FT', 6, 38.69, 50, 10.47, 20.63, 60.51, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'FT', 7, 17.13, 50, 8.32, 5.98, 40.18, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'IM', NULL, 4.39, 52, 0.09, 4.20, 4.58, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'RT', NULL, 42.61, 85, 9.81, 25.06, 62.24, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'FT', 1, 0.00, 47, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'FT', 2, 3.16, 47, 2.94, 0.47, 18.42, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'FT', 3, 12.83, 47, 5.64, 5.06, 28.90, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'FT', 4, 16.47, 47, 7.60, 6.09, 37.49, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'FT', 5, 19.90, 47, 9.35, 7.09, 44.72, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'FT', 6, 34.32, 47, 12.68, 14.42, 61.84, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'FT', 7, 13.32, 47, 7.87, 3.75, 37.73, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'IM', NULL, 4.33, 49, 0.12, 4.09, 4.58, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'RT', NULL, 46.35, 85, 10.34, 27.43, 66.39, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'FT', 1, 3.44, 46, 3.49, 0.43, 22.85, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'FT', 2, 0.00, 46, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'FT', 3, 11.65, 46, 6.25, 3.74, 30.93, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'FT', 4, 6.12, 46, 3.72, 1.74, 19.36, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'FT', 5, 68.80, 46, 9.22, 48.14, 83.97, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'FT', 6, 2.63, 46, 1.63, 0.75, 8.86, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'FT', 7, 7.36, 46, 5.56, 1.52, 29.08, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'IM', NULL, 4.05, 46, 0.12, 3.81, 4.30, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'RT', NULL, 48.64, 85, 10.91, 28.44, 69.30, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'FT', 1, 11.24, 48, 6.44, 3.34, 31.68, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'FT', 2, 19.67, 48, 9.18, 7.07, 44.06, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'FT', 3, 44.12, 48, 12.03, 22.83, 67.82, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'FT', 4, 6.81, 48, 5.09, 1.43, 26.87, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'FT', 5, 17.33, 48, 12.09, 3.70, 53.36, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'FT', 6, 0.57, 48, 0.59, 0.07, 4.48, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'FT', 7, 0.26, 48, 0.28, 0.03, 2.17, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'IM', NULL, 3.99, 47, 0.14, 3.70, 4.27, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'RT', NULL, 57.00, 86, 8.22, 40.48, 72.09, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'FT', 1, 0.52, 54, 0.54, 0.07, 4.03, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'FT', 2, 8.26, 54, 4.13, 2.93, 21.18, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'FT', 3, 24.10, 54, 6.78, 13.11, 40.04, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'FT', 4, 5.81, 54, 3.36, 1.77, 17.44, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'FT', 5, 45.99, 54, 11.66, 24.93, 68.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'FT', 6, 11.80, 54, 8.08, 2.74, 38.84, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'FT', 7, 3.51, 54, 1.98, 1.11, 10.54, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'IM', NULL, 3.92, 57, 0.10, 3.72, 4.11, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'RT', NULL, 56.60, 86, 10.09, 36.57, 74.69, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'FT', 1, 12.20, 15, 11.96, 1.25, 60.35, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'FT', 2, 24.41, 15, 13.38, 6.38, 60.46, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'FT', 3, 37.65, 15, 15.23, 13.06, 70.83, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'FT', 4, 13.53, 15, 10.00, 2.44, 49.45, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'FT', 5, 12.20, 15, 10.03, 1.83, 50.84, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'FT', 6, 0.00, 15, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'FT', 7, 0.00, 15, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'IM', NULL, 3.61, 15, 0.27, 3.02, 4.19, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'RT', NULL, 22.85, 86, 6.69, 12.22, 38.64, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'FT', 1, 11.15, 51, 5.84, 3.70, 29.09, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'FT', 2, 13.79, 51, 4.79, 6.65, 26.43, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'FT', 3, 37.89, 51, 13.77, 15.85, 66.40, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'FT', 4, 16.04, 51, 6.68, 6.59, 34.08, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'FT', 5, 10.08, 51, 5.95, 2.91, 29.51, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'FT', 6, 10.81, 51, 6.03, 3.34, 29.85, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'FT', 7, 0.25, 51, 0.26, 0.03, 1.95, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'IM', NULL, 3.57, 52, 0.16, 3.25, 3.89, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'RT', NULL, 59.78, 86, 7.80, 43.81, 73.91, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'FT', 1, 2.03, 30, 1.81, 0.32, 11.77, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'FT', 2, 10.81, 30, 6.79, 2.79, 33.84, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'FT', 3, 48.98, 30, 16.91, 19.39, 79.30, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'FT', 4, 6.50, 30, 4.19, 1.66, 22.19, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'FT', 5, 30.23, 30, 13.49, 10.49, 61.57, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'FT', 6, 0.36, 30, 0.38, 0.04, 2.97, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'FT', 7, 1.09, 30, 1.13, 0.13, 8.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'IM', NULL, 3.55, 31, 0.27, 3.00, 4.10, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'RT', NULL, 41.55, 86, 8.01, 26.95, 57.81, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'FT', 1, 6.64, 52, 5.34, 1.25, 28.62, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'FT', 2, 15.68, 52, 6.41, 6.57, 32.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'FT', 3, 29.00, 52, 9.86, 13.51, 51.64, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'FT', 4, 29.34, 52, 10.69, 12.85, 53.91, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'FT', 5, 17.94, 52, 7.48, 7.31, 37.73, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'FT', 6, 0.28, 52, 0.28, 0.04, 2.11, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'FT', 7, 1.12, 52, 0.83, 0.25, 4.89, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'IM', NULL, 3.54, 54, 0.15, 3.24, 3.85, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'RT', NULL, 55.27, 85, 10.32, 35.00, 73.92, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'FT', 1, 7.23, 45, 6.76, 1.01, 37.31, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'FT', 2, 9.48, 45, 4.36, 3.63, 22.56, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'FT', 3, 15.75, 45, 9.09, 4.49, 42.66, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'FT', 4, 38.49, 45, 10.01, 21.06, 59.47, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'FT', 5, 28.51, 45, 8.48, 14.70, 47.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'FT', 6, 0.54, 45, 0.55, 0.07, 4.00, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'FT', 7, 0.00, 45, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'IM', NULL, 3.53, 46, 0.14, 3.25, 3.81, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'RT', NULL, 40.46, 86, 9.08, 24.30, 58.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'FT', 1, 11.57, 43, 5.53, 4.21, 28.03, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'FT', 2, 51.85, 43, 13.40, 26.71, 76.08, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'FT', 3, 20.66, 43, 9.12, 7.81, 44.46, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'FT', 4, 1.23, 43, 0.83, 0.31, 4.70, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'FT', 5, 7.81, 43, 5.83, 1.63, 30.26, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'FT', 6, 1.30, 43, 1.09, 0.23, 6.85, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'FT', 7, 5.59, 43, 5.22, 0.80, 30.34, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'IM', NULL, 3.45, 45, 0.20, 3.04, 3.86, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'RT', NULL, 49.47, 86, 9.79, 31.00, 68.08, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'FT', 1, 12.60, 23, 10.01, 2.14, 48.69, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'FT', 2, 39.56, 23, 11.33, 19.68, 63.63, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'FT', 3, 10.14, 23, 9.38, 1.32, 48.81, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'FT', 4, 9.62, 23, 9.51, 1.09, 50.68, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'FT', 5, 24.66, 23, 7.59, 12.30, 43.31, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'FT', 6, 1.81, 23, 1.43, 0.35, 8.92, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'FT', 7, 1.60, 23, 1.68, 0.18, 12.95, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'IM', NULL, 3.44, 24, 0.25, 2.93, 3.96, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'RT', NULL, 29.10, 86, 6.90, 17.43, 44.37, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'FT', 1, 10.07, 26, 7.78, 1.87, 39.64, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'FT', 2, 2.19, 26, 1.47, 0.54, 8.46, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'FT', 3, 60.42, 26, 14.32, 30.78, 83.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'FT', 4, 19.85, 26, 11.04, 5.60, 50.84, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'FT', 5, 7.08, 26, 5.21, 1.47, 28.00, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'FT', 6, 0.39, 26, 0.42, 0.04, 3.49, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'FT', 7, 0.00, 26, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'IM', NULL, 3.29, 27, 0.17, 2.95, 3.63, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'RT', NULL, 39.47, 85, 8.97, 23.61, 57.91, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'FT', 1, 38.16, 12, 19.38, 9.20, 78.99, 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'FT', 2, 7.86, 12, 6.24, 1.26, 36.22, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'FT', 3, 26.69, 12, 17.34, 4.92, 71.91, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'FT', 4, 20.25, 12, 15.61, 2.94, 68.06, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'FT', 5, 4.02, 12, 3.96, 0.44, 28.58, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'FT', 6, 0.00, 12, 0.00, NULL, NULL, 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'FT', 7, 3.01, 12, 3.09, 0.30, 24.11, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'IM', NULL, 3.28, 13, 0.33, 2.55, 4.01, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'RT', NULL, 15.33, 86, 5.30, 7.44, 28.97, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'FT', 1, 12.47, 24, 10.20, 2.02, 49.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'FT', 2, 54.40, 24, 19.34, 19.21, 85.69, 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'FT', 3, 23.12, 24, 11.52, 7.30, 53.47, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'FT', 4, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'FT', 5, 10.00, 24, 9.85, 1.14, 51.66, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'FT', 6, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'FT', 7, 0.00, 24, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'IM', NULL, 3.17, 26, 0.16, 2.83, 3.50, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'RT', NULL, 27.91, 86, 10.55, 12.01, 52.34, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 1, 0.00, 114, 0.00, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 2, 2.15, 114, 1.91, 0.36, 11.76, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 3, 4.86, 114, 2.50, 1.72, 12.99, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 4, 11.96, 114, 4.63, 5.38, 24.49, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 5, 51.42, 114, 5.66, 40.32, 62.38, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 6, 21.66, 114, 3.52, 15.49, 29.43, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 7, 7.95, 114, 2.95, 3.74, 16.09, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'IM', NULL, 4.24, 115, 0.09, 4.05, 4.42, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'RT', NULL, 100.00, 117, 0.00, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 1, 0.00, 98, 0.00, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 2, 1.24, 98, 0.91, 0.28, 5.23, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 3, 13.47, 98, 4.92, 6.31, 26.46, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 4, 7.05, 98, 3.28, 2.73, 17.00, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 5, 43.03, 98, 5.70, 32.25, 54.52, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 6, 15.30, 98, 3.49, 9.57, 23.57, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 7, 19.91, 98, 5.01, 11.76, 31.69, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'IM', NULL, 4.22, 98, 0.09, 4.04, 4.41, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'RT', NULL, 85.26, 116, 3.75, 76.19, 91.26, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 1, 1.93, 109, 1.93, 0.26, 12.98, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 2, 3.73, 109, 2.43, 1.01, 12.88, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 3, 15.29, 109, 3.79, 9.19, 24.38, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 4, 18.77, 109, 4.03, 12.04, 28.06, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 5, 35.48, 109, 6.43, 23.97, 48.95, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 6, 17.60, 109, 4.69, 10.12, 28.84, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 7, 7.20, 109, 3.19, 2.92, 16.67, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'IM', NULL, 4.22, 109, 0.09, 4.05, 4.39, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'RT', NULL, 95.94, 118, 2.00, 89.51, 98.49, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 1, 0.00, 114, 0.00, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 2, 0.00, 114, 0.00, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 3, 8.14, 114, 3.04, 3.81, 16.55, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 4, 19.67, 114, 4.84, 11.78, 30.99, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 5, 41.74, 114, 6.10, 30.35, 54.08, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 6, 21.66, 114, 4.72, 13.75, 32.41, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 7, 8.79, 114, 2.82, 4.57, 16.22, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'IM', NULL, 4.17, 115, 0.10, 3.98, 4.37, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'RT', NULL, 100.00, 117, 0.00, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 1, 3.71, 112, 2.27, 1.08, 11.96, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 2, 25.20, 112, 5.34, 16.12, 37.14, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 3, 26.50, 112, 5.23, 17.48, 38.03, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 4, 16.05, 112, 4.23, 9.30, 26.27, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 5, 19.81, 112, 4.28, 12.66, 29.64, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 6, 5.99, 112, 2.26, 2.80, 12.37, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 7, 2.74, 112, 1.81, 0.73, 9.76, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'IM', NULL, 4.00, 114, 0.09, 3.82, 4.18, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'RT', NULL, 99.43, 117, 0.58, 95.81, 99.92, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 1, 1.77, 110, 1.30, 0.41, 7.38, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 2, 6.20, 110, 3.06, 2.28, 15.78, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 3, 19.42, 110, 4.67, 11.77, 30.33, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 4, 23.28, 110, 6.25, 13.17, 37.78, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 5, 34.32, 110, 6.47, 22.82, 48.00, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 6, 10.51, 110, 4.21, 4.61, 22.18, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 7, 4.50, 110, 2.60, 1.40, 13.49, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'IM', NULL, 3.99, 109, 0.11, 3.78, 4.21, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'RT', NULL, 95.50, 117, 2.64, 86.27, 98.62, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 1, 1.94, 98, 1.43, 0.45, 8.06, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 2, 3.95, 98, 1.84, 1.54, 9.74, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 3, 16.55, 98, 5.34, 8.43, 29.93, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 4, 10.38, 98, 3.73, 4.97, 20.44, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 5, 32.75, 98, 5.88, 22.29, 45.27, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 6, 26.69, 98, 5.33, 17.50, 38.45, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 7, 7.73, 98, 3.57, 3.01, 18.43, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'IM', NULL, 3.97, 100, 0.10, 3.77, 4.17, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'RT', NULL, 86.32, 118, 4.33, 75.33, 92.88, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 1, 2.05, 98, 1.51, 0.47, 8.47, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 2, 15.19, 98, 5.06, 7.59, 28.08, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 3, 11.87, 98, 4.14, 5.79, 22.80, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 4, 15.90, 98, 3.88, 9.60, 25.17, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 5, 43.27, 98, 6.91, 30.37, 57.15, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 6, 8.63, 98, 3.06, 4.19, 16.96, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 7, 3.08, 98, 2.39, 0.65, 13.46, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'IM', NULL, 3.95, 98, 0.10, 3.76, 4.14, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'RT', NULL, 86.95, 117, 4.14, 76.39, 93.21, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 1, 6.17, 100, 2.92, 2.36, 15.17, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 2, 21.64, 100, 4.22, 14.41, 31.16, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 3, 22.13, 100, 4.76, 14.12, 32.96, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 4, 18.11, 100, 4.91, 10.29, 29.90, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 5, 29.41, 100, 5.08, 20.41, 40.38, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 6, 0.38, 100, 0.39, 0.05, 2.82, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 7, 2.16, 100, 2.15, 0.29, 14.31, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'IM', NULL, 3.80, 100, 0.09, 3.63, 3.97, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'RT', NULL, 86.49, 117, 3.97, 76.56, 92.61, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 1, 1.87, 103, 1.70, 0.30, 10.74, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 2, 30.40, 103, 4.72, 21.91, 40.47, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 3, 32.78, 103, 5.33, 23.19, 44.07, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 4, 16.55, 103, 4.12, 9.89, 26.39, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 5, 12.77, 103, 3.28, 7.54, 20.80, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 6, 5.42, 103, 2.83, 1.88, 14.63, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 7, 0.21, 103, 0.21, 0.03, 1.55, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'IM', NULL, 3.72, 103, 0.10, 3.52, 3.91, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'RT', NULL, 88.61, 118, 3.28, 80.33, 93.68, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 1, 2.89, 93, 2.44, 0.53, 14.36, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 2, 27.04, 93, 6.92, 15.59, 42.66, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 3, 24.10, 93, 5.46, 14.93, 36.48, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 4, 32.58, 93, 7.52, 19.67, 48.81, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 5, 9.60, 93, 3.45, 4.60, 18.94, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 6, 3.29, 93, 1.51, 1.31, 8.01, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 7, 0.50, 93, 0.51, 0.07, 3.64, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'IM', NULL, 3.57, 93, 0.13, 3.32, 3.83, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'RT', NULL, 77.46, 118, 7.89, 58.42, 89.37, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 42, 'FT', 1, 10.37, 100, 3.97, 4.72, 21.27, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 42, 'FT', 2, 21.32, 100, 5.07, 12.94, 33.06, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 42, 'FT', 3, 29.13, 100, 5.34, 19.75, 40.71, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 42, 'FT', 4, 14.93, 100, 4.38, 8.13, 25.81, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 42, 'FT', 5, 23.88, 100, 4.60, 15.95, 34.15, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 42, 'FT', 6, 0.38, 100, 0.38, 0.05, 2.78, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 42, 'FT', 7, 0.00, 100, 0.00, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 42, 'IM', NULL, 3.50, 102, 0.12, 3.27, 3.73, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 42, 'RT', NULL, 88.17, 117, 3.73, 78.58, 93.81, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 1, 6.27, 95, 3.69, 1.89, 18.86, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 2, 24.03, 95, 5.48, 14.84, 36.47, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 3, 34.48, 95, 6.10, 23.54, 47.37, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 4, 11.91, 95, 3.89, 6.08, 22.01, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 5, 18.86, 95, 5.35, 10.40, 31.76, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 6, 2.25, 95, 2.24, 0.30, 14.86, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 7, 2.20, 95, 1.25, 0.71, 6.63, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'IM', NULL, 3.46, 97, 0.13, 3.20, 3.72, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'RT', NULL, 83.87, 117, 4.25, 73.61, 90.64, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 1, 14.03, 47, 5.54, 6.08, 29.15, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 2, 26.30, 47, 8.42, 12.95, 46.12, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 3, 32.56, 47, 7.81, 19.09, 49.69, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 4, 13.09, 47, 6.34, 4.68, 31.62, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 5, 9.50, 47, 6.14, 2.43, 30.65, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 6, 0.00, 47, 0.00, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 7, 4.52, 47, 4.45, 0.59, 27.41, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'IM', NULL, 3.46, 51, 0.18, 3.09, 3.83, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'RT', NULL, 44.78, 118, 6.76, 32.06, 58.23, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 1, 0.69, 49, 0.71, 0.09, 5.25, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 2, 0.73, 49, 0.54, 0.16, 3.18, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 3, 1.10, 49, 0.80, 0.26, 4.61, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 4, 0.64, 49, 0.43, 0.16, 2.45, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 5, 21.88, 49, 13.08, 5.67, 56.62, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 6, 64.47, 49, 14.46, 33.78, 86.59, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 7, 10.48, 49, 9.05, 1.66, 44.88, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'IM', NULL, 4.85, 49, 0.10, 4.66, 5.00, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'RT', NULL, 88.58, 60, 9.58, 53.86, 98.10, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 1, 0.00, 57, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 2, 0.12, 57, 0.07, 0.03, 0.42, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 3, 11.82, 57, 9.63, 2.07, 46.02, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 4, 1.17, 57, 0.60, 0.42, 3.23, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 5, 50.25, 57, 15.02, 23.26, 77.10, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 6, 27.43, 57, 12.65, 9.57, 57.45, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 7, 9.20, 57, 8.04, 1.45, 41.05, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'IM', NULL, 4.59, 57, 0.15, 4.29, 4.90, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'RT', NULL, 99.53, 60, 0.40, 97.44, 99.92, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 1, 42.99, 52, 14.83, 18.29, 71.75, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 2, 14.16, 52, 10.63, 2.77, 48.84, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 3, 21.22, 52, 13.34, 5.14, 57.21, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 4, 11.12, 52, 10.61, 1.43, 51.92, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 5, 10.51, 52, 8.82, 1.75, 43.58, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 6, 0.00, 52, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 7, 0.00, 52, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'IM', NULL, 4.57, 52, 0.22, 4.14, 5.00, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'RT', NULL, 90.30, 60, 8.05, 59.66, 98.32, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 1, 0.04, 59, 0.04, 0.01, 0.31, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 2, 0.77, 59, 0.54, 0.19, 3.08, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 3, 1.80, 59, 0.93, 0.64, 4.98, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 4, 11.69, 59, 9.40, 2.09, 45.02, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 5, 56.32, 59, 13.82, 29.51, 79.88, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 6, 29.38, 59, 13.73, 9.96, 61.01, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 7, 0.00, 59, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'IM', NULL, 4.32, 58, 0.20, 3.93, 4.71, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'RT', NULL, 99.95, 60, 0.05, 99.64, 99.99, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 1, 0.00, 60, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 2, 0.28, 60, 0.12, 0.12, 0.67, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 3, 11.72, 60, 9.58, 2.04, 45.86, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 4, 44.09, 60, 15.70, 18.06, 73.83, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 5, 31.43, 60, 13.96, 11.14, 62.62, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 6, 12.48, 60, 9.75, 2.33, 46.00, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 7, 0.00, 60, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'IM', NULL, 4.17, 59, 0.21, 3.75, 4.59, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'RT', NULL, 100.00, 60, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 1, 10.15, 58, 9.62, 1.35, 48.27, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 2, 9.28, 58, 8.04, 1.49, 40.89, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 3, 22.68, 58, 13.15, 6.13, 56.84, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 4, 28.88, 58, 12.69, 10.54, 58.33, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 5, 28.28, 58, 12.44, 10.35, 57.37, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 6, 0.73, 58, 0.58, 0.15, 3.55, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 7, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'IM', NULL, 4.15, 58, 0.26, 3.62, 4.67, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'RT', NULL, 99.58, 60, 0.40, 97.30, 99.93, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 1, 10.05, 59, 9.72, 1.28, 49.02, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 2, 0.52, 59, 0.37, 0.13, 2.12, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 3, 27.39, 59, 13.70, 8.68, 59.96, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 4, 38.92, 59, 15.52, 14.72, 70.18, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 5, 22.11, 59, 11.93, 6.62, 53.17, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 6, 1.00, 59, 0.75, 0.22, 4.39, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 7, 0.00, 59, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'IM', NULL, 4.14, 59, 0.23, 3.68, 4.60, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'RT', NULL, 99.94, 60, 0.06, 99.57, 99.99, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 1, 11.95, 43, 10.20, 1.88, 48.97, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 2, 13.44, 43, 10.27, 2.55, 47.96, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 3, 28.18, 43, 15.40, 7.79, 64.58, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 4, 33.57, 43, 16.91, 9.86, 70.00, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 5, 12.86, 43, 12.05, 1.66, 56.40, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 6, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 7, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'IM', NULL, 4.11, 43, 0.26, 3.58, 4.64, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'RT', NULL, 78.11, 60, 10.35, 51.54, 92.29, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 1, 1.06, 60, 0.70, 0.28, 3.89, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 2, 2.05, 60, 1.22, 0.62, 6.59, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 3, 19.83, 60, 11.51, 5.49, 51.29, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 4, 57.76, 60, 13.55, 31.04, 80.60, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 5, 9.29, 60, 8.02, 1.50, 40.73, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 6, 10.01, 60, 9.42, 1.35, 47.42, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 7, 0.00, 60, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'IM', NULL, 4.08, 60, 0.27, 3.54, 4.62, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'RT', NULL, 100.00, 60, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 1, 11.12, 49, 8.82, 2.04, 42.93, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 2, 23.90, 49, 13.47, 6.61, 58.20, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 3, 33.29, 49, 14.99, 11.39, 65.97, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 4, 30.86, 49, 15.36, 9.50, 65.49, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 5, 0.09, 49, 0.07, 0.02, 0.40, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 6, 0.74, 49, 0.64, 0.13, 4.11, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 7, 0.00, 49, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'IM', NULL, 4.04, 49, 0.33, 3.38, 4.70, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'RT', NULL, 90.92, 60, 7.99, 59.07, 98.58, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 1, 1.05, 59, 0.73, 0.26, 4.13, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 2, 20.14, 59, 12.15, 5.26, 53.37, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 3, 22.67, 59, 12.83, 6.34, 55.92, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 4, 37.36, 59, 14.85, 14.34, 68.00, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 5, 18.15, 59, 11.48, 4.51, 51.03, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 6, 0.04, 59, 0.04, 0.01, 0.31, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 7, 0.59, 59, 0.57, 0.09, 3.94, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'IM', NULL, 4.04, 59, 0.20, 3.63, 4.44, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'RT', NULL, 99.96, 60, 0.04, 99.69, 99.99, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 1, 0.04, 56, 0.04, 0.01, 0.31, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 2, 0.16, 56, 0.09, 0.05, 0.48, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 3, 0.12, 56, 0.07, 0.03, 0.42, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 4, 26.88, 56, 13.75, 8.30, 59.89, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 5, 25.06, 56, 12.89, 7.79, 56.96, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 6, 38.71, 56, 15.61, 14.46, 70.25, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 7, 9.03, 56, 8.03, 1.38, 41.31, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'IM', NULL, 3.95, 56, 0.30, 3.35, 4.55, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'RT', NULL, 99.50, 60, 0.41, 97.48, 99.90, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 1, 0.10, 60, 0.08, 0.02, 0.45, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 2, 0.61, 60, 0.41, 0.16, 2.34, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 3, 22.10, 60, 12.60, 6.15, 55.10, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 4, 29.40, 60, 14.27, 9.52, 62.24, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 5, 30.42, 60, 12.72, 11.61, 59.27, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 6, 17.30, 60, 11.47, 4.03, 51.00, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 7, 0.08, 60, 0.08, 0.01, 0.61, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'IM', NULL, 3.94, 60, 0.22, 3.49, 4.38, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'RT', NULL, 100.00, 60, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 1, 16.97, 59, 10.57, 4.36, 47.84, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 2, 1.82, 59, 0.86, 0.70, 4.63, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 3, 52.40, 59, 14.40, 25.74, 77.75, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 4, 9.49, 59, 8.02, 1.59, 40.44, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 5, 19.32, 59, 12.50, 4.59, 54.38, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 6, 0.00, 59, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 7, 0.00, 59, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'IM', NULL, 3.86, 59, 0.31, 3.25, 4.48, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'RT', NULL, 99.94, 60, 0.06, 99.54, 99.99, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 1, 0.08, 59, 0.06, 0.02, 0.35, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 2, 8.96, 59, 8.01, 1.36, 41.24, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 3, 32.50, 59, 12.82, 13.00, 60.80, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 4, 45.74, 59, 14.02, 21.39, 72.31, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 5, 12.72, 59, 9.74, 2.45, 45.76, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 6, 0.00, 59, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 7, 0.00, 59, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'IM', NULL, 3.84, 58, 0.31, 3.21, 4.46, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'RT', NULL, 99.96, 60, 0.04, 99.69, 99.99, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 1, 1.29, 54, 0.88, 0.33, 4.95, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 2, 10.05, 54, 8.85, 1.54, 44.33, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 3, 12.27, 54, 10.55, 1.92, 49.98, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 4, 22.52, 54, 13.47, 5.82, 57.75, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 5, 23.06, 54, 12.83, 6.57, 56.11, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 6, 20.71, 54, 12.78, 5.20, 55.43, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 7, 10.10, 54, 8.90, 1.55, 44.49, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'IM', NULL, 3.70, 53, 0.32, 3.07, 4.34, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'RT', NULL, 90.26, 60, 8.72, 56.00, 98.54, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 1, 9.05, 54, 8.93, 1.12, 46.74, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 2, 14.62, 54, 10.70, 2.98, 48.87, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 3, 24.09, 54, 14.53, 6.06, 60.96, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 4, 40.73, 54, 15.13, 16.35, 70.72, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 5, 10.89, 54, 9.02, 1.86, 44.11, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 6, 0.62, 54, 0.63, 0.08, 4.64, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 7, 0.00, 54, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'IM', NULL, 3.70, 54, 0.30, 3.10, 4.29, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'RT', NULL, 88.91, 60, 9.39, 54.36, 98.18, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 1, 34.21, 51, 15.81, 11.25, 68.07, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 2, 2.13, 51, 0.99, 0.83, 5.33, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 3, 30.51, 51, 14.08, 10.37, 62.51, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 4, 32.44, 51, 15.82, 10.13, 67.17, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 5, 0.71, 51, 0.64, 0.12, 4.17, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 6, 0.00, 51, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 7, 0.00, 51, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'IM', NULL, 3.69, 51, 0.31, 3.06, 4.32, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'RT', NULL, 88.83, 60, 9.40, 54.43, 98.15, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 1, 10.23, 55, 9.54, 1.40, 47.78, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 2, 16.49, 55, 10.67, 4.01, 48.30, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 3, 12.50, 55, 9.71, 2.35, 45.84, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 4, 19.85, 55, 12.31, 4.98, 53.90, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 5, 29.67, 55, 13.92, 9.97, 61.65, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 6, 11.27, 55, 9.83, 1.74, 47.69, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 7, 0.00, 55, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'IM', NULL, 3.66, 55, 0.20, 3.26, 4.06, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'RT', NULL, 98.64, 60, 0.79, 95.70, 99.58, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 1, 11.35, 55, 8.74, 2.19, 42.20, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 2, 38.66, 55, 14.88, 15.19, 68.91, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 3, 10.62, 55, 8.09, 2.11, 39.63, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 4, 39.29, 55, 15.65, 14.80, 70.69, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 5, 0.08, 55, 0.06, 0.02, 0.35, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 6, 0.00, 55, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 7, 0.00, 55, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'IM', NULL, 3.54, 55, 0.19, 3.15, 3.92, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'RT', NULL, 99.80, 60, 0.10, 99.46, 99.93, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 1, 0.18, 46, 0.10, 0.06, 0.56, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 2, 10.34, 46, 9.16, 1.55, 45.79, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 3, 24.19, 46, 14.12, 6.33, 60.09, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 4, 20.80, 46, 13.53, 4.79, 57.85, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 5, 21.73, 46, 13.08, 5.57, 56.66, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 6, 21.98, 46, 13.26, 5.60, 57.22, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 7, 0.77, 46, 0.66, 0.14, 4.24, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'IM', NULL, 3.48, 46, 0.35, 2.77, 4.18, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'RT', NULL, 97.51, 59, 1.20, 93.57, 99.06, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 1, 53.30, 44, 18.91, 19.78, 84.08, 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 2, 16.92, 44, 13.58, 2.82, 58.82, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 3, 13.03, 44, 11.31, 1.96, 52.84, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 4, 16.70, 44, 13.49, 2.75, 58.64, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 5, 0.06, 44, 0.06, 0.01, 0.46, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 6, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 7, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'IM', NULL, 3.11, 44, 0.48, 2.14, 4.08, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'RT', NULL, 69.67, 60, 12.35, 41.63, 88.09, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 1, 10.89, 52, 8.15, 2.21, 39.74, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 2, 40.37, 52, 15.41, 15.78, 70.99, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 3, 30.30, 52, 14.82, 9.60, 64.02, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 4, 8.18, 52, 8.01, 1.04, 43.13, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 5, 10.21, 52, 9.78, 1.32, 49.21, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 6, 0.00, 52, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 7, 0.04, 52, 0.04, 0.01, 0.31, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'IM', NULL, 3.05, 52, 0.35, 2.35, 3.76, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'RT', NULL, 99.31, 60, 0.43, 97.64, 99.80, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 1, 29.00, 34, 17.21, 6.94, 69.11, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 2, 31.76, 34, 19.26, 7.09, 73.95, 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 3, 4.54, 34, 2.35, 1.56, 12.53, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 4, 34.40, 34, 20.19, 7.83, 76.41, 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 5, 0.30, 34, 0.18, 0.09, 1.02, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 6, 0.00, 34, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 7, 0.00, 34, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'IM', NULL, 3.94, 34, 0.39, 3.14, 4.74, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'RT', NULL, 59.51, 60, 14.48, 30.63, 83.03, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 1, 17.98, 39, 13.42, 3.36, 58.03, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 2, 30.81, 39, 16.63, 8.40, 68.37, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 3, 3.35, 39, 1.72, 1.17, 9.22, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 4, 47.02, 39, 17.53, 17.60, 78.67, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 5, 0.85, 39, 0.71, 0.15, 4.57, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 6, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 7, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'IM', NULL, 3.81, 39, 0.37, 3.06, 4.56, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'RT', NULL, 61.16, 60, 14.45, 31.79, 84.18, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 1, 49.27, 33, 28.52, 8.68, 90.85, 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 2, 45.13, 33, 28.62, 7.24, 89.65, 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 3, 5.29, 33, 4.18, 1.01, 23.43, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 4, 0.16, 33, 0.18, 0.02, 1.65, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 5, 0.16, 33, 0.19, 0.02, 1.66, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 6, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 7, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'IM', NULL, 2.74, 33, 0.32, 2.09, 3.40, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'RT', NULL, 27.04, 59, 14.09, 8.15, 60.75, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 1, 76.31, 39, 18.33, 29.26, 96.17, 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 2, 21.71, 39, 18.29, 3.04, 71.02, 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 3, 1.78, 39, 1.23, 0.44, 6.97, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 4, 0.19, 39, 0.16, 0.04, 0.98, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 5, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 6, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 7, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'IM', NULL, 2.34, 39, 0.30, 1.74, 2.94, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'RT', NULL, 50.70, 60, 14.08, 24.98, 76.05, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 1, 0.00, 46, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 2, 0.00, 46, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 3, 1.38, 46, 1.42, 0.17, 10.21, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 4, 3.61, 46, 3.56, 0.47, 22.74, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 5, 46.31, 46, 7.16, 32.57, 60.63, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 6, 25.10, 46, 6.01, 14.96, 38.96, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 7, 23.60, 46, 5.53, 14.27, 36.43, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'IM', NULL, 4.36, 47, 0.09, 4.18, 4.53, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'RT', NULL, 90.22, 51, 5.99, 70.25, 97.30, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 1, 0.00, 47, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 2, 3.46, 47, 3.16, 0.53, 19.44, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 3, 8.48, 47, 4.47, 2.83, 22.79, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 4, 10.87, 47, 4.39, 4.67, 23.27, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 5, 44.01, 47, 5.69, 33.06, 55.58, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 6, 23.48, 47, 5.49, 14.23, 36.20, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 7, 9.70, 47, 6.28, 2.47, 31.28, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'IM', NULL, 4.34, 49, 0.08, 4.19, 4.50, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'RT', NULL, 98.67, 50, 1.36, 90.20, 99.83, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 1, 0.00, 47, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 2, 0.00, 47, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 3, 10.52, 47, 3.50, 5.27, 19.90, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 4, 14.68, 47, 6.09, 6.08, 31.40, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 5, 54.06, 47, 6.44, 41.12, 66.48, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 6, 19.34, 47, 4.54, 11.77, 30.12, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 7, 1.39, 47, 1.43, 0.17, 10.27, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'IM', NULL, 4.09, 48, 0.12, 3.84, 4.33, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'RT', NULL, 94.36, 51, 3.26, 83.04, 98.28, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 1, 2.25, 49, 2.23, 0.30, 15.05, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 2, 6.59, 49, 3.60, 2.13, 18.63, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 3, 19.99, 49, 7.79, 8.58, 39.95, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 4, 23.35, 49, 5.54, 14.06, 36.20, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 5, 35.25, 49, 8.35, 20.69, 53.19, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 6, 7.92, 49, 6.12, 1.57, 31.72, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 7, 4.64, 49, 3.06, 1.20, 16.37, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'IM', NULL, 4.01, 50, 0.17, 3.67, 4.36, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'RT', NULL, 98.70, 51, 1.33, 90.40, 99.84, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 1, 0.00, 45, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 2, 13.16, 45, 5.38, 5.54, 28.13, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 3, 2.84, 45, 2.08, 0.64, 11.79, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 4, 35.30, 45, 7.04, 22.67, 50.39, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 5, 34.40, 45, 7.47, 21.20, 50.55, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 6, 14.29, 45, 4.57, 7.29, 26.12, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 7, 0.00, 45, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'IM', NULL, 4.00, 46, 0.08, 3.84, 4.16, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'RT', NULL, 90.70, 51, 4.37, 77.51, 96.50, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 1, 3.60, 45, 3.28, 0.55, 20.09, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 2, 6.59, 45, 4.00, 1.87, 20.70, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 3, 9.93, 45, 5.47, 3.11, 27.45, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 4, 33.40, 45, 4.95, 24.26, 43.99, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 5, 30.35, 45, 7.31, 17.84, 46.66, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 6, 12.53, 45, 4.86, 5.54, 25.93, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 7, 3.60, 45, 3.13, 0.60, 18.72, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'IM', NULL, 3.95, 46, 0.11, 3.72, 4.17, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'RT', NULL, 90.54, 51, 4.75, 75.84, 96.69, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 1, 8.26, 45, 4.32, 2.78, 22.12, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 2, 18.27, 45, 6.20, 8.82, 34.05, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 3, 4.07, 45, 2.92, 0.93, 16.08, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 4, 26.57, 45, 6.53, 15.56, 41.52, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 5, 35.52, 45, 8.17, 21.17, 53.06, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 6, 1.93, 45, 1.89, 0.26, 12.84, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 7, 5.38, 45, 3.78, 1.26, 20.24, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'IM', NULL, 3.93, 46, 0.15, 3.63, 4.24, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'RT', NULL, 83.92, 52, 6.65, 66.00, 93.34, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 1, 28.13, 40, 8.13, 14.79, 46.88, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 2, 14.27, 40, 5.97, 5.84, 30.88, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 3, 24.27, 40, 5.08, 15.48, 35.92, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 4, 15.89, 40, 5.31, 7.80, 29.66, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 5, 17.45, 40, 10.92, 4.36, 49.49, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 6, 0.00, 40, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 7, 0.00, 40, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'IM', NULL, 3.91, 40, 0.16, 3.58, 4.24, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'RT', NULL, 80.04, 51, 5.17, 67.66, 88.49, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 1, 6.39, 44, 3.58, 2.00, 18.57, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 2, 7.68, 44, 4.34, 2.36, 22.23, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 3, 14.74, 44, 5.99, 6.20, 31.12, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 4, 26.59, 44, 7.81, 13.91, 44.80, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 5, 30.98, 44, 6.54, 19.49, 45.41, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 6, 9.83, 44, 3.73, 4.46, 20.30, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 7, 3.79, 44, 3.26, 0.65, 19.27, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'IM', NULL, 3.89, 45, 0.10, 3.69, 4.09, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'RT', NULL, 84.50, 52, 5.49, 70.16, 92.67, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 1, 3.75, 44, 3.70, 0.49, 23.52, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 2, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 3, 4.22, 44, 3.19, 0.89, 17.77, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 4, 16.77, 44, 7.11, 6.72, 36.01, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 5, 57.70, 44, 8.22, 40.88, 72.91, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 6, 10.76, 44, 4.65, 4.34, 24.25, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 7, 6.80, 44, 3.46, 2.37, 17.98, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'IM', NULL, 3.85, 45, 0.14, 3.57, 4.12, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'RT', NULL, 86.79, 51, 6.11, 69.26, 95.04, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 1, 0.00, 37, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 2, 12.64, 37, 5.26, 5.22, 27.55, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 3, 13.62, 37, 6.68, 4.75, 33.29, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 4, 4.79, 37, 3.53, 1.04, 19.46, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 5, 34.28, 37, 7.77, 20.58, 51.21, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 6, 16.48, 37, 6.45, 7.09, 33.80, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 7, 18.19, 37, 8.52, 6.50, 41.53, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'IM', NULL, 3.77, 38, 0.21, 3.36, 4.19, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'RT', NULL, 71.19, 51, 5.70, 58.56, 81.20, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 1, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 2, 21.47, 43, 5.93, 11.85, 35.75, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 3, 25.63, 43, 7.55, 13.42, 43.40, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 4, 33.03, 43, 6.64, 21.20, 47.48, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 5, 10.77, 43, 4.12, 4.84, 22.29, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 6, 9.09, 43, 6.46, 2.03, 32.61, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 7, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'IM', NULL, 3.77, 43, 0.15, 3.46, 4.09, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'RT', NULL, 86.33, 51, 5.57, 70.98, 94.23, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 1, 0.00, 46, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 2, 26.16, 46, 5.16, 17.13, 37.77, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 3, 24.22, 46, 6.07, 14.11, 38.35, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 4, 18.88, 46, 5.39, 10.28, 32.11, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 5, 25.79, 46, 5.29, 16.61, 37.75, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 6, 0.00, 46, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 7, 4.95, 46, 3.35, 1.23, 17.92, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'IM', NULL, 3.67, 47, 0.14, 3.38, 3.96, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'RT', NULL, 92.69, 51, 3.67, 81.04, 97.41, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 1, 9.74, 30, 5.36, 3.01, 27.29, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 2, 46.57, 30, 8.70, 29.89, 64.06, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 3, 28.62, 30, 7.71, 15.64, 46.45, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 4, 9.93, 30, 6.09, 2.66, 30.76, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 5, 5.14, 30, 3.44, 1.26, 18.65, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 6, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 7, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'IM', NULL, 4.29, 31, 0.10, 4.08, 4.51, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'RT', NULL, 55.79, 52, 6.70, 42.24, 68.53, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 1, 43.71, 16, 12.83, 20.35, 70.24, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 2, 32.01, 16, 9.40, 15.79, 54.16, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 3, 9.41, 16, 6.72, 1.90, 35.79, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 4, 14.88, 16, 9.30, 3.52, 45.55, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 5, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 6, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 7, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'IM', NULL, 4.16, 17, 0.23, 3.67, 4.66, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'RT', NULL, 31.92, 50, 5.99, 21.22, 44.94, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 1, 33.28, 25, 10.32, 16.05, 56.55, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 2, 33.93, 25, 8.00, 19.73, 51.74, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 3, 30.33, 25, 9.73, 14.40, 52.97, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 4, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 5, 2.47, 25, 2.51, 0.29, 17.86, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 6, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 7, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'IM', NULL, 3.92, 26, 0.21, 3.49, 4.36, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'RT', NULL, 50.34, 52, 6.74, 37.10, 63.53, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 1, 13.35, 33, 7.77, 3.77, 37.70, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 2, 20.56, 33, 5.64, 11.35, 34.35, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 3, 26.92, 33, 9.80, 11.78, 50.39, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 4, 9.64, 33, 4.95, 3.24, 25.36, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 5, 17.42, 33, 8.27, 6.14, 40.48, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 6, 7.13, 33, 5.51, 1.39, 29.51, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 7, 4.99, 33, 4.19, 0.86, 24.13, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'IM', NULL, 3.46, 34, 0.22, 3.02, 3.90, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'RT', NULL, 65.57, 51, 7.40, 49.64, 78.62, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 1, 0.00, 61, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 2, 2.44, 61, 2.31, 0.36, 14.83, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 3, 1.09, 61, 1.08, 0.15, 7.62, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 4, 1.27, 61, 1.27, 0.17, 8.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 5, 53.16, 61, 6.82, 39.63, 66.25, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 6, 23.76, 61, 5.97, 13.88, 37.61, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 7, 18.28, 61, 5.30, 9.90, 31.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'IM', NULL, 4.41, 61, 0.09, 4.23, 4.58, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'RT', NULL, 97.80, 63, 1.54, 91.39, 99.46, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 1, 0.00, 61, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 2, 2.74, 61, 1.84, 0.70, 10.09, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 3, 3.71, 61, 2.60, 0.89, 14.16, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 4, 0.00, 61, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 5, 32.90, 61, 6.32, 21.66, 46.50, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 6, 33.57, 61, 7.62, 20.32, 50.03, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 7, 27.09, 61, 6.02, 16.81, 40.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'IM', NULL, 4.32, 60, 0.13, 4.06, 4.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'RT', NULL, 94.47, 65, 3.27, 83.03, 98.35, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 1, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 2, 2.39, 63, 2.26, 0.35, 14.56, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 3, 9.97, 63, 4.65, 3.79, 23.77, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 4, 16.90, 63, 5.62, 8.38, 31.14, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 5, 53.32, 63, 7.77, 37.97, 68.07, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 6, 11.60, 63, 4.38, 5.29, 23.58, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 7, 5.81, 63, 3.16, 1.91, 16.35, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'IM', NULL, 4.30, 63, 0.10, 4.10, 4.51, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'RT', NULL, 98.84, 64, 1.13, 92.25, 99.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 1, 0.00, 59, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 2, 1.29, 59, 1.33, 0.16, 9.55, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 3, 9.39, 59, 4.02, 3.87, 21.05, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 4, 13.81, 59, 4.00, 7.56, 23.91, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 5, 65.65, 59, 6.95, 50.77, 77.99, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 6, 7.39, 59, 3.94, 2.46, 20.15, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 7, 2.46, 59, 2.33, 0.36, 14.94, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'IM', NULL, 4.29, 58, 0.09, 4.11, 4.47, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'RT', NULL, 96.17, 62, 2.71, 85.21, 99.10, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 1, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 2, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 3, 6.76, 63, 3.67, 2.22, 18.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 4, 6.76, 63, 3.10, 2.64, 16.22, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 5, 55.14, 63, 6.95, 41.21, 68.31, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 6, 29.55, 63, 6.23, 18.74, 43.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 7, 1.79, 63, 1.53, 0.32, 9.39, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'IM', NULL, 4.25, 63, 0.11, 4.03, 4.47, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'RT', NULL, 100.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 1, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 2, 2.39, 63, 2.26, 0.35, 14.52, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 3, 4.38, 63, 3.13, 1.02, 16.93, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 4, 9.12, 63, 5.06, 2.87, 25.40, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 5, 20.44, 63, 5.60, 11.44, 33.82, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 6, 35.10, 63, 7.23, 22.28, 50.49, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 7, 28.57, 63, 7.30, 16.37, 44.99, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'IM', NULL, 4.22, 62, 0.12, 3.97, 4.46, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'RT', NULL, 94.54, 65, 3.61, 81.08, 98.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 1, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 2, 3.13, 58, 2.28, 0.71, 12.68, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 3, 16.66, 58, 4.96, 8.91, 29.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 4, 15.76, 58, 4.90, 8.21, 28.15, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 5, 29.89, 58, 6.46, 18.69, 44.16, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 6, 15.27, 58, 4.91, 7.78, 27.83, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 7, 19.28, 58, 6.56, 9.31, 35.71, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'IM', NULL, 4.22, 58, 0.12, 3.97, 4.46, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'RT', NULL, 89.02, 63, 5.25, 73.48, 95.95, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 1, 0.00, 64, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 2, 10.93, 64, 3.76, 5.37, 20.98, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 3, 37.19, 64, 8.07, 22.90, 54.14, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 4, 19.96, 64, 5.30, 11.39, 32.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 5, 22.41, 64, 6.68, 11.82, 38.36, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 6, 7.36, 64, 4.41, 2.13, 22.44, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 7, 2.15, 64, 1.48, 0.54, 8.24, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'IM', NULL, 4.04, 63, 0.13, 3.78, 4.31, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'RT', NULL, 100.00, 64, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 1, 7.65, 62, 3.67, 2.85, 18.96, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 2, 38.95, 62, 6.27, 27.35, 51.94, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 3, 32.89, 62, 6.60, 21.23, 47.12, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 4, 10.23, 62, 3.98, 4.57, 21.32, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 5, 9.20, 62, 4.24, 3.54, 21.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 6, 1.08, 62, 1.05, 0.15, 7.24, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 7, 0.00, 62, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'IM', NULL, 4.00, 61, 0.15, 3.71, 4.30, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'RT', NULL, 95.82, 64, 2.63, 86.07, 98.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 1, 3.87, 56, 2.92, 0.83, 16.23, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 2, 4.63, 56, 2.46, 1.57, 12.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 3, 29.24, 56, 8.74, 15.05, 49.08, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 4, 11.15, 56, 4.70, 4.62, 24.50, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 5, 42.27, 56, 8.46, 26.76, 59.47, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 6, 8.84, 56, 3.94, 3.52, 20.53, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 7, 0.00, 56, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'IM', NULL, 3.98, 56, 0.14, 3.70, 4.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'RT', NULL, 88.99, 63, 4.26, 77.20, 95.08, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 1, 5.56, 53, 3.72, 1.40, 19.61, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 2, 8.55, 53, 3.98, 3.26, 20.62, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 3, 19.35, 53, 6.41, 9.52, 35.36, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 4, 8.12, 53, 4.43, 2.61, 22.56, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 5, 21.06, 53, 6.07, 11.37, 35.69, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 6, 20.86, 53, 5.87, 11.44, 34.98, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 7, 16.50, 53, 4.91, 8.81, 28.77, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'IM', NULL, 3.93, 52, 0.18, 3.57, 4.29, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'RT', NULL, 82.35, 64, 6.23, 66.45, 91.66, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 1, 5.69, 49, 2.92, 1.98, 15.29, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 2, 21.65, 49, 6.25, 11.64, 36.70, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 3, 32.50, 49, 6.23, 21.39, 46.01, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 4, 16.88, 49, 5.88, 8.04, 32.05, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 5, 17.53, 49, 5.62, 8.87, 31.70, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 6, 4.41, 49, 3.06, 1.06, 16.56, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 7, 1.34, 49, 1.34, 0.17, 9.48, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'IM', NULL, 3.72, 49, 0.13, 3.47, 3.98, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'RT', NULL, 77.55, 63, 7.80, 58.51, 89.43, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 1, 18.87, 50, 5.22, 10.50, 31.57, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 2, 15.12, 50, 5.91, 6.59, 31.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 3, 24.16, 50, 6.79, 13.14, 40.16, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 4, 26.46, 50, 7.85, 13.79, 44.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 5, 11.95, 50, 6.39, 3.85, 31.50, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 6, 0.00, 50, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 7, 3.44, 50, 2.51, 0.77, 14.02, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'IM', NULL, 3.56, 50, 0.10, 3.36, 3.76, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'RT', NULL, 78.88, 65, 7.01, 61.71, 89.64, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 1, 4.43, 50, 3.33, 0.95, 18.35, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 2, 22.48, 50, 4.57, 14.62, 32.95, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 3, 41.66, 50, 7.01, 28.57, 56.04, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 4, 14.18, 50, 5.11, 6.63, 27.77, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 5, 10.55, 50, 5.06, 3.86, 25.71, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 6, 5.36, 50, 3.56, 1.36, 18.83, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 7, 1.34, 50, 1.35, 0.18, 9.50, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'IM', NULL, 3.56, 50, 0.12, 3.32, 3.79, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'RT', NULL, 78.28, 63, 7.82, 58.97, 90.04, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 1, 0.11, 131, 0.12, 0.01, 0.91, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 2, 3.91, 131, 3.45, 0.66, 19.99, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 3, 0.67, 131, 0.37, 0.22, 1.99, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 4, 0.91, 131, 0.45, 0.34, 2.42, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 5, 56.62, 131, 10.93, 35.12, 75.89, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 6, 35.04, 131, 8.76, 20.12, 53.60, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 7, 2.74, 131, 2.17, 0.56, 12.35, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'IM', NULL, 4.37, 131, 0.14, 4.09, 4.64, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'RT', NULL, 89.50, 138, 4.76, 75.80, 95.86, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 1, 3.91, 126, 3.60, 0.61, 21.31, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 2, 1.13, 126, 0.51, 0.46, 2.73, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 3, 5.12, 126, 3.86, 1.11, 20.63, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 4, 11.37, 126, 5.91, 3.86, 29.06, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 5, 60.65, 126, 8.62, 42.98, 75.90, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 6, 7.01, 126, 5.60, 1.36, 29.23, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 7, 10.81, 126, 4.61, 4.50, 23.78, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'IM', NULL, 4.36, 126, 0.13, 4.11, 4.62, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'RT', NULL, 89.26, 137, 4.23, 77.65, 95.21, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 1, 0.10, 131, 0.11, 0.01, 0.82, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 2, 2.46, 131, 2.16, 0.42, 13.03, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 3, 3.94, 131, 3.48, 0.66, 20.19, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 4, 6.36, 131, 3.89, 1.83, 19.82, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 5, 58.81, 131, 8.70, 41.24, 74.40, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 6, 17.49, 131, 5.65, 8.90, 31.50, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 7, 10.84, 131, 5.70, 3.65, 28.10, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'IM', NULL, 4.35, 133, 0.12, 4.11, 4.59, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'RT', NULL, 99.50, 138, 0.27, 98.56, 99.83, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 1, 1.52, 116, 0.72, 0.60, 3.83, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 2, 28.47, 116, 8.93, 14.31, 48.68, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 3, 37.21, 116, 9.05, 21.57, 56.07, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 4, 6.13, 116, 3.98, 1.63, 20.44, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 5, 16.66, 116, 11.73, 3.61, 51.59, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 6, 0.14, 116, 0.15, 0.02, 1.11, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 7, 9.88, 116, 8.58, 1.60, 42.51, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'IM', NULL, 4.31, 117, 0.10, 4.12, 4.51, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'RT', NULL, 74.44, 137, 10.08, 50.54, 89.24, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 1, 0.00, 129, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 2, 0.00, 129, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 3, 0.37, 129, 0.25, 0.10, 1.38, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 4, 5.11, 129, 4.21, 0.96, 23.09, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 5, 58.92, 129, 11.52, 35.86, 78.63, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 6, 17.31, 129, 6.77, 7.59, 34.79, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 7, 18.29, 129, 7.31, 7.83, 37.09, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'IM', NULL, 4.20, 130, 0.21, 3.79, 4.61, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'RT', NULL, 85.82, 137, 8.88, 58.86, 96.24, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 1, 0.16, 115, 0.17, 0.02, 1.31, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 2, 5.55, 115, 4.36, 1.12, 23.41, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 3, 1.02, 115, 0.55, 0.35, 2.92, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 4, 20.92, 115, 9.79, 7.58, 46.07, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 5, 31.33, 115, 7.96, 17.98, 48.70, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 6, 21.64, 115, 8.67, 9.11, 43.20, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 7, 19.38, 115, 8.76, 7.33, 42.19, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'IM', NULL, 4.13, 115, 0.24, 3.65, 4.61, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'RT', NULL, 72.58, 137, 6.79, 57.41, 83.87, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 1, 12.85, 103, 8.31, 3.27, 39.14, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 2, 17.08, 103, 8.68, 5.75, 40.99, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 3, 5.50, 103, 4.08, 1.21, 21.64, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 4, 12.14, 103, 4.83, 5.32, 25.34, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 5, 27.17, 103, 9.24, 12.88, 48.51, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 6, 15.99, 103, 6.17, 7.11, 32.12, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 7, 9.28, 103, 4.01, 3.83, 20.82, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'IM', NULL, 3.99, 104, 0.17, 3.65, 4.32, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'RT', NULL, 84.35, 138, 5.50, 70.29, 92.48, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 1, 0.11, 126, 0.11, 0.01, 0.85, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 2, 4.18, 126, 3.41, 0.80, 19.02, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 3, 20.35, 126, 6.58, 10.26, 36.33, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 4, 25.77, 126, 6.86, 14.58, 41.38, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 5, 33.34, 126, 7.90, 19.83, 50.28, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 6, 8.54, 126, 5.28, 2.40, 26.22, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 7, 7.72, 126, 4.48, 2.35, 22.53, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'IM', NULL, 3.98, 127, 0.20, 3.59, 4.37, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'RT', NULL, 95.77, 137, 3.08, 83.39, 99.03, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 1, 0.00, 130, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 2, 0.25, 130, 0.19, 0.05, 1.13, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 3, 13.11, 130, 6.09, 4.98, 30.28, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 4, 17.25, 130, 5.88, 8.44, 32.03, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 5, 54.30, 130, 6.99, 40.49, 67.49, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 6, 12.05, 130, 6.19, 4.13, 30.34, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 7, 3.04, 130, 2.23, 0.69, 12.32, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'IM', NULL, 3.87, 131, 0.20, 3.47, 4.26, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'RT', NULL, 87.45, 138, 5.59, 71.81, 95.02, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 1, 5.47, 106, 4.72, 0.94, 26.13, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 2, 6.01, 106, 4.82, 1.17, 25.77, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 3, 23.07, 106, 12.94, 6.60, 56.00, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 4, 13.46, 106, 6.30, 5.05, 31.24, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 5, 32.77, 106, 9.72, 16.89, 53.89, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 6, 3.97, 106, 2.72, 1.00, 14.52, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 7, 15.25, 106, 9.28, 4.15, 42.75, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'IM', NULL, 3.79, 106, 0.16, 3.48, 4.11, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'RT', NULL, 69.90, 137, 7.23, 54.05, 82.09, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 1, 3.67, 129, 3.49, 0.54, 21.22, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 2, 8.42, 129, 5.02, 2.47, 24.99, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 3, 17.34, 129, 7.76, 6.71, 37.97, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 4, 35.56, 129, 8.87, 20.42, 54.27, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 5, 24.82, 129, 5.80, 15.15, 37.92, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 6, 0.22, 129, 0.17, 0.05, 1.01, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 7, 9.96, 129, 7.31, 2.16, 35.70, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'IM', NULL, 3.73, 129, 0.21, 3.31, 4.15, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'RT', NULL, 92.39, 137, 3.26, 82.93, 96.81, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 1, 4.91, 112, 4.57, 0.73, 26.46, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 2, 10.44, 112, 7.04, 2.56, 34.12, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 3, 8.48, 112, 4.54, 2.82, 22.80, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 4, 34.48, 112, 14.09, 13.26, 64.43, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 5, 20.16, 112, 8.31, 8.32, 41.26, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 6, 8.46, 112, 4.88, 2.58, 24.37, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 7, 13.08, 112, 8.68, 3.21, 40.58, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'IM', NULL, 3.71, 112, 0.23, 3.26, 4.15, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'RT', NULL, 71.52, 137, 8.98, 51.21, 85.73, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 1, 0.42, 103, 0.45, 0.05, 3.38, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 2, 0.67, 103, 0.46, 0.17, 2.61, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 3, 5.24, 103, 4.37, 0.95, 24.09, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 4, 13.16, 103, 8.21, 3.52, 38.64, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 5, 50.16, 103, 7.64, 35.44, 64.85, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 6, 15.67, 103, 6.53, 6.51, 33.12, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 7, 14.68, 103, 6.58, 5.72, 32.79, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'IM', NULL, 3.56, 104, 0.13, 3.30, 3.82, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'RT', NULL, 72.29, 137, 9.72, 49.99, 87.20, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 1, 0.33, 98, 0.26, 0.07, 1.54, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 2, 2.50, 98, 1.14, 1.01, 6.08, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 3, 16.70, 98, 7.98, 6.03, 38.51, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 4, 15.80, 98, 7.49, 5.78, 36.47, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 5, 41.80, 98, 11.02, 22.61, 63.83, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 6, 1.00, 98, 0.66, 0.27, 3.63, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 7, 21.86, 98, 8.88, 9.07, 43.98, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'IM', NULL, 4.05, 97, 0.18, 3.69, 4.41, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'RT', NULL, 60.25, 137, 10.65, 38.63, 78.50, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 1, 9.98, 87, 6.34, 2.65, 31.10, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 2, 58.58, 87, 7.54, 43.26, 72.40, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 3, 4.99, 87, 2.98, 1.48, 15.47, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 4, 11.42, 87, 6.06, 3.78, 29.77, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 5, 5.73, 87, 4.71, 1.06, 25.63, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 6, 0.00, 87, 0.00, NULL, NULL, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 7, 9.30, 87, 5.41, 2.79, 26.82, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'IM', NULL, 4.01, 87, 0.20, 3.61, 4.41, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'RT', NULL, 62.19, 137, 8.62, 44.35, 77.25, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 1, 12.32, 77, 9.04, 2.58, 42.67, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 2, 18.90, 77, 10.12, 5.89, 46.46, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 3, 9.53, 77, 5.42, 2.92, 26.93, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 4, 23.52, 77, 12.13, 7.44, 54.09, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 5, 22.92, 77, 12.26, 6.95, 54.21, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 6, 0.88, 77, 0.58, 0.23, 3.24, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 7, 11.93, 77, 6.14, 4.06, 30.26, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'IM', NULL, 3.80, 79, 0.26, 3.29, 4.32, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'RT', NULL, 34.58, 138, 6.40, 23.19, 48.06, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 1, 4.12, 73, 4.02, 0.56, 24.60, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 2, 9.52, 73, 6.88, 2.10, 34.07, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 3, 16.54, 73, 8.43, 5.54, 40.10, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 4, 19.20, 73, 8.59, 7.31, 41.73, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 5, 37.42, 73, 11.66, 18.14, 61.74, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 6, 0.79, 73, 0.46, 0.24, 2.52, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 7, 12.42, 73, 6.44, 4.17, 31.59, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'IM', NULL, 3.73, 73, 0.15, 3.43, 4.03, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'RT', NULL, 51.05, 137, 5.49, 40.30, 61.70, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 1, 28.56, 87, 9.51, 13.66, 50.25, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 2, 14.42, 87, 7.20, 5.01, 34.97, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 3, 6.81, 87, 4.63, 1.68, 23.77, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 4, 1.64, 87, 0.94, 0.52, 5.05, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 5, 30.23, 87, 11.55, 12.74, 56.27, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 6, 1.07, 87, 0.60, 0.35, 3.25, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 7, 17.26, 87, 9.39, 5.35, 43.52, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'IM', NULL, 3.25, 88, 0.23, 2.79, 3.72, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'RT', NULL, 49.15, 138, 10.39, 29.82, 68.74, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 1, 0.00, 84, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 2, 3.36, 84, 2.05, 0.98, 10.91, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 3, 8.26, 84, 3.37, 3.58, 17.91, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 4, 7.07, 84, 2.77, 3.18, 14.97, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 5, 62.05, 84, 5.93, 49.77, 72.95, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 6, 10.60, 84, 3.96, 4.91, 21.38, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 7, 8.68, 84, 2.96, 4.32, 16.64, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'IM', NULL, 4.48, 82, 0.06, 4.36, 4.60, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'RT', NULL, 97.71, 86, 1.61, 91.06, 99.44, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 1, 29.75, 68, 5.92, 19.40, 42.71, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 2, 25.06, 68, 5.41, 15.84, 37.26, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 3, 14.31, 68, 4.73, 7.18, 26.50, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 4, 6.53, 68, 3.03, 2.53, 15.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 5, 21.15, 68, 5.18, 12.61, 33.26, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 6, 0.00, 68, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 7, 3.20, 68, 2.19, 0.80, 11.92, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'IM', NULL, 4.23, 68, 0.12, 3.98, 4.47, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'RT', NULL, 77.46, 86, 4.66, 66.90, 85.39, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 1, 2.43, 85, 1.77, 0.56, 9.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 2, 4.49, 85, 2.48, 1.47, 12.93, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 3, 10.60, 85, 3.72, 5.15, 20.56, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 4, 12.28, 85, 3.57, 6.76, 21.29, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 5, 56.41, 85, 5.34, 45.65, 66.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 6, 5.91, 85, 2.42, 2.58, 13.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 7, 7.88, 85, 3.59, 3.10, 18.63, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'IM', NULL, 4.16, 85, 0.08, 4.01, 4.31, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'RT', NULL, 98.54, 86, 1.44, 90.21, 99.80, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 1, 28.81, 78, 5.33, 19.43, 40.45, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 2, 25.15, 78, 5.18, 16.27, 36.75, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 3, 12.89, 78, 4.17, 6.60, 23.67, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 4, 15.70, 78, 4.56, 8.57, 27.01, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 5, 13.61, 78, 3.78, 7.66, 23.01, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 6, 2.15, 78, 1.51, 0.52, 8.40, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 7, 1.69, 78, 1.61, 0.25, 10.55, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'IM', NULL, 4.14, 77, 0.12, 3.91, 4.38, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'RT', NULL, 89.23, 86, 3.53, 79.95, 94.51, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 1, 2.19, 86, 1.66, 0.48, 9.45, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 2, 15.30, 86, 4.43, 8.38, 26.29, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 3, 11.90, 86, 3.39, 6.64, 20.43, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 4, 18.65, 86, 3.91, 12.07, 27.68, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 5, 40.10, 86, 5.02, 30.64, 50.36, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 6, 8.85, 86, 2.93, 4.50, 16.66, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 7, 3.01, 86, 2.89, 0.43, 18.12, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'IM', NULL, 4.14, 86, 0.10, 3.95, 4.33, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'RT', NULL, 100.00, 86, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 1, 0.00, 83, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 2, 9.89, 83, 3.69, 4.59, 20.01, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 3, 20.61, 83, 4.75, 12.71, 31.63, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 4, 14.91, 83, 3.85, 8.74, 24.28, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 5, 43.43, 83, 5.29, 33.35, 54.10, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 6, 6.90, 83, 2.91, 2.93, 15.42, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 7, 4.25, 83, 3.10, 0.97, 16.78, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'IM', NULL, 4.13, 81, 0.10, 3.94, 4.33, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'RT', NULL, 96.79, 85, 2.26, 87.67, 99.22, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 1, 0.89, 81, 0.88, 0.12, 6.15, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 2, 10.40, 81, 3.76, 4.94, 20.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 3, 12.20, 81, 3.27, 7.04, 20.32, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 4, 13.16, 81, 3.82, 7.23, 22.75, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 5, 57.08, 81, 5.52, 45.94, 67.56, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 6, 3.07, 81, 1.77, 0.96, 9.38, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 7, 3.19, 81, 3.05, 0.46, 19.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'IM', NULL, 4.13, 81, 0.09, 3.95, 4.31, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'RT', NULL, 94.39, 86, 3.21, 83.43, 98.25, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 1, 0.88, 68, 0.87, 0.12, 6.20, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 2, 13.43, 68, 4.47, 6.71, 25.06, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 3, 11.97, 68, 4.28, 5.69, 23.43, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 4, 13.54, 68, 4.18, 7.13, 24.21, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 5, 54.94, 68, 6.22, 42.48, 66.81, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 6, 2.00, 68, 1.92, 0.29, 12.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 7, 3.24, 68, 2.18, 0.83, 11.83, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'IM', NULL, 4.09, 68, 0.09, 3.91, 4.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'RT', NULL, 80.30, 85, 4.41, 70.06, 87.65, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 1, 1.87, 73, 1.86, 0.25, 12.56, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 2, 13.98, 73, 4.24, 7.45, 24.70, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 3, 9.22, 73, 3.60, 4.13, 19.32, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 4, 14.24, 73, 4.04, 7.91, 24.30, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 5, 46.63, 73, 5.51, 35.98, 57.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 6, 8.66, 73, 2.92, 4.35, 16.51, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 7, 5.40, 73, 3.70, 1.33, 19.48, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'IM', NULL, 4.07, 73, 0.11, 3.84, 4.29, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'RT', NULL, 86.02, 85, 5.11, 72.53, 93.48, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 1, 6.20, 82, 2.74, 2.52, 14.44, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 2, 30.70, 82, 5.33, 21.20, 42.18, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 3, 16.82, 82, 4.01, 10.26, 26.35, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 4, 18.00, 82, 5.01, 10.05, 30.15, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 5, 25.84, 82, 4.28, 18.27, 35.20, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 6, 2.44, 82, 1.75, 0.57, 9.79, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 7, 0.00, 82, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'IM', NULL, 3.88, 81, 0.09, 3.70, 4.07, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'RT', NULL, 94.36, 86, 2.56, 86.52, 97.76, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 1, 18.22, 82, 4.39, 11.03, 28.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 2, 27.99, 82, 5.05, 19.10, 39.03, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 3, 15.14, 82, 4.90, 7.71, 27.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 4, 14.17, 82, 4.26, 7.60, 24.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 5, 19.47, 82, 4.69, 11.77, 30.47, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 6, 1.77, 82, 1.25, 0.43, 7.02, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 7, 3.23, 82, 2.13, 0.85, 11.46, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'IM', NULL, 3.81, 81, 0.09, 3.63, 4.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'RT', NULL, 95.22, 86, 2.24, 88.23, 98.15, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 1, 7.52, 82, 3.18, 3.17, 16.82, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 2, 23.32, 82, 4.84, 15.08, 34.25, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 3, 23.36, 82, 5.62, 14.03, 36.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 4, 18.98, 82, 4.41, 11.69, 29.30, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 5, 21.48, 82, 4.48, 13.89, 31.69, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 6, 2.63, 82, 1.85, 0.64, 10.20, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 7, 2.70, 82, 1.86, 0.68, 10.17, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'IM', NULL, 3.81, 82, 0.11, 3.58, 4.03, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'RT', NULL, 95.53, 86, 2.10, 88.91, 98.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 1, 30.97, 79, 5.74, 20.82, 43.35, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 2, 29.62, 79, 5.03, 20.66, 40.49, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 3, 21.20, 79, 4.59, 13.47, 31.73, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 4, 8.11, 79, 3.09, 3.72, 16.77, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 5, 8.45, 79, 2.96, 4.13, 16.49, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 6, 0.00, 79, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 7, 1.66, 79, 1.66, 0.22, 11.37, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'IM', NULL, 3.79, 78, 0.13, 3.54, 4.04, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'RT', NULL, 91.62, 85, 4.58, 76.94, 97.29, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 1, 16.99, 60, 5.73, 8.32, 31.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 2, 28.61, 60, 6.21, 17.91, 42.40, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 3, 21.20, 60, 5.44, 12.30, 34.05, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 4, 16.82, 60, 5.66, 8.26, 31.24, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 5, 14.88, 60, 4.42, 8.01, 26.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 6, 1.50, 60, 1.48, 0.20, 10.22, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 7, 0.00, 60, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'IM', NULL, 3.62, 60, 0.15, 3.32, 3.91, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'RT', NULL, 68.82, 86, 5.49, 57.03, 78.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 1, 13.61, 72, 4.57, 6.76, 25.49, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 2, 28.19, 72, 5.22, 19.01, 39.62, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 3, 25.46, 72, 5.27, 16.42, 37.26, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 4, 18.16, 72, 4.69, 10.58, 29.38, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 5, 14.58, 72, 4.63, 7.52, 26.39, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 6, 0.00, 72, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 7, 0.00, 72, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'IM', NULL, 3.61, 72, 0.12, 3.38, 3.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'RT', NULL, 81.54, 86, 5.71, 67.49, 90.38, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 1, 15.53, 79, 4.49, 8.51, 26.65, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 2, 29.37, 79, 5.56, 19.61, 41.49, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 3, 24.13, 79, 4.84, 15.82, 35.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 4, 10.66, 79, 3.40, 5.54, 19.53, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 5, 14.05, 79, 3.94, 7.86, 23.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 6, 2.79, 79, 1.92, 0.70, 10.49, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 7, 3.47, 79, 2.27, 0.92, 12.17, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'IM', NULL, 3.60, 78, 0.10, 3.40, 3.81, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'RT', NULL, 91.04, 86, 3.91, 79.67, 96.34, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 1, 8.34, 44, 4.20, 2.92, 21.62, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 2, 30.61, 44, 7.02, 18.46, 46.22, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 3, 5.09, 44, 2.98, 1.52, 15.67, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 4, 9.66, 44, 4.86, 3.37, 24.72, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 5, 43.42, 44, 7.09, 30.02, 57.86, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 6, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 7, 2.88, 44, 2.60, 0.45, 16.22, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'IM', NULL, 4.06, 44, 0.16, 3.75, 4.38, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'RT', NULL, 52.37, 86, 6.25, 40.05, 64.41, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 1, 14.01, 35, 6.52, 5.15, 32.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 2, 25.46, 35, 8.84, 11.71, 46.81, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 3, 11.44, 35, 5.56, 4.07, 28.25, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 4, 2.12, 35, 2.12, 0.27, 14.66, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 5, 34.87, 35, 7.92, 20.86, 52.10, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 6, 2.12, 35, 2.13, 0.27, 14.86, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 7, 9.96, 35, 6.90, 2.26, 34.58, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'IM', NULL, 3.67, 35, 0.19, 3.30, 4.05, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'RT', NULL, 40.10, 85, 5.66, 29.53, 51.68, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'FT', 1, 77.39, 9, 14.72, 32.98, 95.97, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'FT', 2, 8.12, 9, 8.00, 0.74, 51.16, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'FT', 3, 0.00, 9, 0.00, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'FT', 4, 0.00, 9, 0.00, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'FT', 5, 14.49, 9, 13.25, 1.42, 66.60, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'FT', 6, 0.00, 9, 0.00, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'FT', 7, 0.00, 9, 0.00, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'IM', NULL, 3.44, 9, 0.44, 2.43, 4.45, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'RT', NULL, 10.49, 85, 3.33, 5.46, 19.19, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 1, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 2, 11.76, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 3, 41.18, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 4, 0.00, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 5, 23.53, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 6, 17.65, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 7, 0.00, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'IM', NULL, 4.47, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'RT', NULL, 80.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 1, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 2, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 3, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 4, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 5, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 6, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'IM', NULL, 4.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'RT', NULL, 95.24, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 1, 28.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 2, 33.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 3, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 4, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 5, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 6, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 7, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'IM', NULL, 4.24, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'RT', NULL, 100.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 1, 12.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 2, 31.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 3, 37.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 4, 6.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 5, 6.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 6, 6.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 7, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'IM', NULL, 4.19, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'RT', NULL, 76.19, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 2, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 3, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 4, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 5, 47.62, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 6, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 7, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'IM', NULL, 4.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'RT', NULL, 100.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 2, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 3, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 4, 38.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 5, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 6, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'IM', NULL, 4.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'RT', NULL, 100.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 1, 36.84, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 2, 42.11, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 3, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 4, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 5, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 6, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'IM', NULL, 4.05, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'RT', NULL, 90.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 1, 5.56, 18, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 2, 5.56, 18, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 3, 11.11, 18, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 4, 5.56, 18, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 5, 27.78, 18, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 6, 33.33, 18, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 7, 11.11, 18, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'IM', NULL, 4.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'RT', NULL, 85.71, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 1, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 2, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 3, 36.84, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 4, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 5, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 6, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'IM', NULL, 3.95, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'RT', NULL, 90.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 1, 0.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 2, 33.33, 15, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 3, 26.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 4, 13.33, 15, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 5, 20.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 6, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 7, 0.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'IM', NULL, 3.80, 15, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'RT', NULL, 71.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 1, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 2, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 3, 40.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 4, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 5, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 6, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 7, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'IM', NULL, 3.80, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'RT', NULL, 95.24, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 1, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 2, 52.63, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 3, 21.05, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 4, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 5, 26.32, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 6, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'IM', NULL, 3.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'RT', NULL, 90.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 1, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 2, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 3, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 4, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 5, 36.84, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 6, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 7, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'IM', NULL, 3.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'RT', NULL, 90.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 1, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 2, 25.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 3, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 4, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 5, 50.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 6, 12.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 7, 12.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'IM', NULL, 3.76, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'RT', NULL, 80.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 1, 6.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 2, 25.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 3, 37.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 4, 12.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 5, 18.75, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 6, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 7, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'IM', NULL, 3.56, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'RT', NULL, 80.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 1, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 2, 23.53, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 3, 35.29, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 4, 23.53, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 5, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 6, 0.00, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 7, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'IM', NULL, 3.47, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'RT', NULL, 80.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 1, 0.00, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 2, 35.29, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 3, 41.18, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 4, 11.76, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 5, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 6, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 7, 0.00, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'IM', NULL, 3.41, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'RT', NULL, 80.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 1, 41.67, 12, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 2, 33.33, 12, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 3, 16.67, 12, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 4, 0.00, 12, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 5, 0.00, 12, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 6, 8.33, 12, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 7, 0.00, 12, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'IM', NULL, 2.86, 14, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'RT', NULL, 66.67, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'FT', 1, 0.00, 91, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'FT', 2, 0.00, 91, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'FT', 3, 3.10, 91, 1.63, 1.08, 8.57, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'FT', 4, 7.15, 91, 2.52, 3.50, 14.08, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'FT', 5, 54.25, 91, 8.67, 37.20, 70.36, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'FT', 6, 18.99, 91, 5.06, 10.87, 31.07, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'FT', 7, 16.50, 91, 7.59, 6.21, 37.11, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'IM', NULL, 4.29, 91, 0.08, 4.13, 4.45, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'RT', NULL, 97.17, 96, 1.76, 90.61, 99.19, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'FT', 1, 0.00, 71, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'FT', 2, 1.81, 71, 1.27, 0.44, 7.10, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'FT', 3, 4.72, 71, 2.67, 1.49, 13.95, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'FT', 4, 5.95, 71, 2.51, 2.52, 13.41, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'FT', 5, 45.87, 71, 9.92, 27.64, 65.28, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'FT', 6, 15.92, 71, 6.09, 7.11, 31.92, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'FT', 7, 25.72, 71, 9.45, 11.43, 48.15, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'IM', NULL, 4.26, 71, 0.11, 4.04, 4.48, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'RT', NULL, 78.76, 96, 6.37, 63.53, 88.76, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20464, 'FT', 1, 0.00, 89, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20464, 'FT', 2, 3.40, 89, 2.21, 0.92, 11.80, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20464, 'FT', 3, 9.41, 89, 3.86, 4.05, 20.35, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20464, 'FT', 4, 4.13, 89, 2.58, 1.17, 13.61, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20464, 'FT', 5, 51.87, 89, 8.52, 35.36, 67.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20464, 'FT', 6, 22.26, 89, 8.17, 10.08, 42.24, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20464, 'FT', 7, 8.93, 89, 3.45, 4.05, 18.57, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20464, 'IM', NULL, 4.05, 88, 0.13, 3.80, 4.30, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20464, 'RT', NULL, 90.75, 98, 3.71, 80.33, 95.93, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'FT', 1, 2.63, 72, 2.22, 0.48, 13.22, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'FT', 2, 1.82, 72, 1.42, 0.38, 8.30, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'FT', 3, 7.53, 72, 3.82, 2.66, 19.54, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'FT', 4, 9.97, 72, 3.80, 4.55, 20.47, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'FT', 5, 47.93, 72, 9.51, 30.11, 66.30, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'FT', 6, 5.27, 72, 4.25, 1.01, 23.27, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'FT', 7, 24.84, 72, 9.62, 10.58, 48.02, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'IM', NULL, 4.04, 71, 0.15, 3.75, 4.33, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'RT', NULL, 76.36, 96, 4.94, 65.22, 84.77, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20465, 'FT', 1, 6.30, 90, 2.96, 2.43, 15.40, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20465, 'FT', 2, 14.45, 90, 4.24, 7.87, 25.04, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20465, 'FT', 3, 8.38, 90, 3.25, 3.80, 17.49, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20465, 'FT', 4, 10.94, 90, 3.67, 5.50, 20.60, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20465, 'FT', 5, 33.10, 90, 8.85, 18.28, 52.26, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20465, 'FT', 6, 14.97, 90, 4.62, 7.89, 26.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20465, 'FT', 7, 11.85, 90, 7.41, 3.18, 35.48, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20465, 'IM', NULL, 4.00, 87, 0.11, 3.78, 4.22, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20465, 'RT', NULL, 91.14, 98, 3.74, 80.41, 96.26, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'FT', 1, 0.85, 81, 0.85, 0.11, 5.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'FT', 2, 3.29, 81, 1.54, 1.28, 8.19, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'FT', 3, 24.02, 81, 8.87, 10.73, 45.40, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'FT', 4, 21.17, 81, 8.30, 9.07, 41.94, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'FT', 5, 44.31, 81, 9.12, 27.62, 62.41, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'FT', 6, 4.87, 81, 3.81, 0.99, 20.81, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'FT', 7, 1.49, 81, 1.17, 0.31, 6.91, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'IM', NULL, 3.96, 81, 0.16, 3.63, 4.28, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'RT', NULL, 89.47, 96, 3.05, 81.72, 94.16, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'FT', 1, 3.51, 83, 1.78, 1.27, 9.36, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'FT', 2, 23.79, 83, 8.50, 10.94, 44.23, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'FT', 3, 37.50, 83, 8.44, 22.66, 55.12, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'FT', 4, 13.35, 83, 7.58, 4.01, 36.21, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'FT', 5, 14.70, 83, 4.47, 7.82, 25.93, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'FT', 6, 4.59, 83, 2.68, 1.41, 13.99, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'FT', 7, 2.56, 83, 1.43, 0.83, 7.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'IM', NULL, 3.84, 83, 0.15, 3.55, 4.13, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'RT', NULL, 90.01, 97, 3.29, 81.34, 94.91, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'FT', 1, 7.47, 76, 2.73, 3.54, 15.07, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'FT', 2, 19.88, 76, 5.25, 11.40, 32.36, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'FT', 3, 14.22, 76, 4.58, 7.28, 25.93, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'FT', 4, 27.14, 76, 10.03, 11.95, 50.57, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'FT', 5, 11.11, 76, 3.68, 5.62, 20.80, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'FT', 6, 9.52, 76, 3.96, 4.05, 20.81, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'FT', 7, 10.65, 76, 8.34, 2.04, 40.56, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'IM', NULL, 3.83, 72, 0.18, 3.47, 4.19, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'RT', NULL, 79.50, 98, 4.78, 68.41, 87.40, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'FT', 1, 0.53, 81, 0.53, 0.07, 3.88, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'FT', 2, 6.62, 81, 2.83, 2.77, 14.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'FT', 3, 41.90, 81, 8.57, 26.35, 59.24, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'FT', 4, 28.70, 81, 7.80, 15.86, 46.23, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'FT', 5, 17.99, 81, 4.77, 10.34, 29.44, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'FT', 6, 2.20, 81, 1.85, 0.40, 11.05, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'FT', 7, 2.06, 81, 1.37, 0.55, 7.49, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'IM', NULL, 3.82, 81, 0.11, 3.60, 4.03, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'RT', NULL, 89.44, 96, 3.28, 80.97, 94.41, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20466, 'FT', 1, 1.31, 79, 1.02, 0.27, 6.03, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20466, 'FT', 2, 6.55, 79, 3.10, 2.50, 16.10, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20466, 'FT', 3, 5.44, 79, 2.12, 2.47, 11.56, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20466, 'FT', 4, 11.28, 79, 4.03, 5.40, 22.08, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20466, 'FT', 5, 49.00, 79, 9.05, 31.85, 66.39, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20466, 'FT', 6, 16.58, 79, 5.72, 8.03, 31.15, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20466, 'FT', 7, 9.85, 79, 4.09, 4.18, 21.47, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20466, 'IM', NULL, 3.77, 78, 0.12, 3.52, 4.01, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 20466, 'RT', NULL, 78.56, 96, 6.96, 61.74, 89.28, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'FT', 1, 3.26, 74, 1.68, 1.15, 8.89, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'FT', 2, 11.52, 74, 3.54, 6.12, 20.64, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'FT', 3, 43.59, 74, 8.52, 27.92, 60.65, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'FT', 4, 19.17, 74, 5.53, 10.44, 32.56, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'FT', 5, 19.98, 74, 5.13, 11.64, 32.14, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'FT', 6, 2.46, 74, 2.10, 0.44, 12.56, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'FT', 7, 0.00, 74, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'IM', NULL, 3.74, 74, 0.18, 3.39, 4.10, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'RT', NULL, 80.50, 96, 5.68, 66.81, 89.44, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1042, 'FT', 1, 3.36, 90, 2.06, 0.97, 10.93, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.01', 1042, 'FT', 2, 4.50, 90, 2.14, 1.72, 11.26, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppr