/*! START TRANSACTION */;
CREATE TABLE work_context (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  category DECIMAL(3,0),
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(5,2),
  lower_ci_bound DECIMAL(5,2),
  upper_ci_bound DECIMAL(5,2),
  recommend_suppress CHARACTER(1),
  not_relevant CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id),
  FOREIGN KEY (element_id, scale_id, category) REFERENCES work_context_categories(element_id, scale_id, category));
/*! COMMIT */;
/*! START TRANSACTION */;

INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.c', 'CX', NULL, 3.39, 25, 0.22, 2.93, 3.86, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.c', 'CXP', 1, 6.02, 25, 5.14, 0.97, 29.49, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.c', 'CXP', 2, 12.40, 25, 7.33, 3.39, 36.32, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.c', 'CXP', 3, 23.36, 25, 10.36, 8.45, 50.16, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.c', 'CXP', 4, 52.55, 25, 12.13, 28.87, 75.14, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.c', 'CXP', 5, 5.67, 25, 5.53, 0.70, 33.73, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.f', 'CX', NULL, 5.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.f', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.f', 'CXP', 5, 100.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.h', 'CX', NULL, 5.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.h', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.h', 'CXP', 5, 100.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.j', 'CX', NULL, 4.33, 25, 0.19, 3.94, 4.73, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.j', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.j', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.j', 'CXP', 3, 20.06, 25, 9.09, 7.22, 44.72, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.j', 'CXP', 4, 26.54, 25, 10.75, 10.37, 53.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.j', 'CXP', 5, 53.40, 25, 12.57, 28.78, 76.47, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.l', 'CX', NULL, 4.98, 25, 0.01, 4.95, 5.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.l', 'CXP', 3, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.l', 'CXP', 4, 1.98, 25, 1.47, 0.42, 8.84, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.2.l', 'CXP', 5, 98.02, 25, 1.47, 91.16, 99.58, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.4', 'CX', NULL, 4.80, 25, 0.09, 4.61, 4.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.4', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.4', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.4', 'CXP', 3, 2.68, 25, 2.62, 0.34, 17.99, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.4', 'CXP', 4, 14.83, 25, 7.76, 4.67, 38.24, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.a.4', 'CXP', 5, 82.49, 25, 7.98, 60.11, 93.64, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.e', 'CX', NULL, 4.74, 25, 0.11, 4.51, 4.97, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.e', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.e', 'CXP', 3, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.e', 'CXP', 4, 26.23, 25, 11.06, 9.85, 53.63, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.e', 'CXP', 5, 73.77, 25, 11.06, 46.37, 90.15, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.f', 'CX', NULL, 4.33, 25, 0.20, 3.91, 4.75, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.f', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.f', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.f', 'CXP', 3, 19.62, 25, 10.59, 5.76, 49.39, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.f', 'CXP', 4, 27.76, 25, 10.85, 11.18, 54.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.f', 'CXP', 5, 52.62, 25, 12.33, 28.57, 75.50, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.g', 'CX', NULL, 4.69, 25, 0.13, 4.42, 4.96, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.g', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.g', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.g', 'CXP', 3, 7.18, 25, 5.45, 1.41, 29.48, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.g', 'CXP', 4, 16.53, 25, 8.19, 5.49, 40.28, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.b.1.g', 'CXP', 5, 76.30, 25, 9.39, 52.43, 90.39, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.1', 'CX', NULL, 3.80, 25, 0.31, 3.16, 4.43, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.1', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.1', 'CXP', 2, 21.46, 25, 10.57, 6.97, 49.92, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.1', 'CXP', 3, 23.08, 25, 10.74, 7.93, 51.11, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.1', 'CXP', 4, 9.86, 25, 6.03, 2.62, 30.72, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.1', 'CXP', 5, 45.61, 25, 12.21, 23.29, 69.84, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.2', 'CX', NULL, 4.45, 25, 0.18, 4.08, 4.82, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.2', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.2', 'CXP', 2, 7.86, 25, 5.61, 1.70, 29.66, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.2', 'CXP', 3, 2.00, 25, 2.02, 0.24, 14.69, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.2', 'CXP', 4, 27.49, 25, 11.33, 10.50, 55.06, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.c.2', 'CXP', 5, 62.65, 25, 11.41, 38.00, 82.11, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.1', 'CX', NULL, 4.06, 25, 0.17, 3.70, 4.41, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.1', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.1', 'CXP', 2, 5.18, 25, 5.07, 0.64, 31.52, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.1', 'CXP', 3, 9.74, 25, 6.23, 2.44, 31.76, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.1', 'CXP', 4, 59.40, 25, 11.88, 34.60, 80.18, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.1', 'CXP', 5, 25.69, 25, 10.58, 9.92, 52.04, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.2', 'CX', NULL, 3.57, 25, 0.24, 3.07, 4.08, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.2', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.2', 'CXP', 2, 12.72, 25, 8.76, 2.78, 42.64, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.2', 'CXP', 3, 40.82, 25, 12.17, 19.61, 66.10, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.2', 'CXP', 4, 22.82, 25, 9.46, 8.90, 47.24, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.2', 'CXP', 5, 23.64, 25, 10.56, 8.47, 50.88, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.3', 'CX', NULL, 1.86, 25, 0.23, 1.40, 2.33, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.3', 'CXP', 1, 46.45, 25, 12.21, 23.95, 70.49, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.3', 'CXP', 2, 27.73, 25, 10.26, 11.78, 52.46, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.3', 'CXP', 3, 21.86, 25, 10.99, 6.91, 51.35, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.3', 'CXP', 4, 1.00, 25, 1.02, 0.12, 7.84, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.1.d.3', 'CXP', 5, 2.96, 25, 2.98, 0.36, 20.66, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.a', 'CX', NULL, 4.90, 25, 0.06, 4.78, 5.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.a', 'CXP', 1, 0.77, 25, 0.78, 0.09, 6.08, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.a', 'CXP', 2, 1.00, 25, 1.02, 0.12, 7.84, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.a', 'CXP', 3, 1.43, 25, 1.46, 0.17, 10.94, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.a', 'CXP', 4, 1.13, 25, 1.16, 0.13, 8.85, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.a', 'CXP', 5, 95.67, 25, 2.37, 87.14, 98.63, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.b', 'CX', NULL, 2.26, 25, 0.32, 1.60, 2.93, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.b', 'CXP', 1, 45.17, 25, 12.18, 22.99, 69.45, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.b', 'CXP', 2, 15.12, 25, 8.19, 4.55, 39.95, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.b', 'CXP', 3, 13.03, 25, 7.99, 3.38, 39.08, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.b', 'CXP', 4, 21.75, 25, 10.83, 6.96, 50.82, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.b', 'CXP', 5, 4.93, 25, 3.38, 1.16, 18.69, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.c', 'CX', NULL, 2.21, 25, 0.32, 1.54, 2.87, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.c', 'CXP', 1, 46.93, 25, 12.52, 23.86, 71.39, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.c', 'CXP', 2, 14.13, 25, 8.07, 4.00, 39.38, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.c', 'CXP', 3, 13.36, 25, 8.91, 3.06, 43.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.c', 'CXP', 4, 22.62, 25, 10.82, 7.54, 51.16, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.c', 'CXP', 5, 2.96, 25, 2.98, 0.36, 20.66, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.d', 'CX', NULL, 1.65, 25, 0.22, 1.20, 2.11, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.d', 'CXP', 1, 63.67, 25, 11.63, 38.30, 83.18, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.d', 'CXP', 2, 18.77, 25, 9.21, 6.23, 44.58, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.d', 'CXP', 3, 9.01, 25, 7.32, 1.54, 38.48, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.d', 'CXP', 4, 5.59, 25, 4.77, 0.91, 27.64, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.d', 'CXP', 5, 2.96, 25, 2.98, 0.36, 20.66, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.e', 'CX', NULL, 1.60, 25, 0.30, 1.00, 2.22, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.e', 'CXP', 1, 75.73, 25, 10.94, 47.73, 91.43, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.e', 'CXP', 2, 4.74, 25, 4.68, 0.58, 29.70, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.e', 'CXP', 3, 6.62, 25, 5.78, 1.02, 32.77, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.e', 'CXP', 4, 9.94, 25, 9.21, 1.30, 47.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.e', 'CXP', 5, 2.96, 25, 2.98, 0.36, 20.66, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.f', 'CX', NULL, 3.04, 25, 0.33, 2.37, 3.71, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.f', 'CXP', 1, 24.49, 25, 9.37, 10.23, 48.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.f', 'CXP', 2, 9.31, 25, 6.25, 2.18, 32.10, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.f', 'CXP', 3, 23.41, 25, 11.39, 7.61, 53.14, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.f', 'CXP', 4, 23.62, 25, 11.61, 7.57, 53.85, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.1.f', 'CXP', 5, 19.18, 25, 8.79, 6.86, 43.34, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.3', 'CX', NULL, 2.73, 24, 0.29, 2.14, 3.33, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.3', 'CXP', 1, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.3', 'CXP', 2, 71.10, 24, 10.68, 45.63, 87.82, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.3', 'CXP', 3, 1.55, 24, 1.57, 0.19, 11.70, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.3', 'CXP', 4, 10.50, 24, 6.90, 2.51, 34.90, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.a.3', 'CXP', 5, 16.85, 24, 9.16, 4.98, 43.95, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.a', 'CX', NULL, 2.94, 24, 0.32, 2.29, 3.59, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.a', 'CXP', 1, 17.79, 24, 8.53, 6.08, 41.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.a', 'CXP', 2, 25.97, 24, 11.70, 9.06, 55.27, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.a', 'CXP', 3, 16.09, 24, 8.73, 4.79, 42.20, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.a', 'CXP', 4, 24.77, 24, 12.25, 7.79, 56.20, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.a', 'CXP', 5, 15.38, 24, 7.92, 4.91, 39.01, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.b', 'CX', NULL, 2.03, 25, 0.34, 1.32, 2.74, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.b', 'CXP', 1, 59.48, 25, 12.12, 34.20, 80.57, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.b', 'CXP', 2, 12.29, 25, 7.84, 3.03, 38.59, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.b', 'CXP', 3, 1.43, 25, 1.46, 0.17, 10.94, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.b', 'CXP', 4, 19.10, 25, 10.43, 5.53, 48.75, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.b', 'CXP', 5, 7.70, 25, 5.01, 1.91, 26.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.c', 'CX', NULL, 1.88, 25, 0.32, 1.21, 2.54, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.c', 'CXP', 1, 63.74, 25, 12.09, 37.39, 83.81, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.c', 'CXP', 2, 10.27, 25, 8.51, 1.67, 43.51, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.c', 'CXP', 3, 8.34, 25, 6.03, 1.76, 31.64, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.c', 'CXP', 4, 9.94, 25, 9.21, 1.30, 47.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.c', 'CXP', 5, 7.70, 25, 5.01, 1.91, 26.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.d', 'CX', NULL, 2.30, 25, 0.31, 1.66, 2.94, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.d', 'CXP', 1, 36.11, 25, 11.68, 16.59, 61.63, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.d', 'CXP', 2, 28.63, 25, 11.34, 11.32, 55.77, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.d', 'CXP', 3, 12.44, 25, 7.94, 3.06, 38.99, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.d', 'CXP', 4, 15.12, 25, 10.06, 3.41, 47.30, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.d', 'CXP', 5, 7.70, 25, 5.01, 1.91, 26.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.e', 'CX', NULL, 1.45, 25, 0.21, 1.02, 1.89, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.e', 'CXP', 1, 74.30, 25, 11.00, 46.82, 90.47, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.e', 'CXP', 2, 11.95, 25, 7.44, 3.06, 36.88, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.e', 'CXP', 3, 10.79, 25, 9.20, 1.65, 46.54, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.e', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.e', 'CXP', 5, 2.96, 25, 2.98, 0.36, 20.66, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.f', 'CX', NULL, 1.61, 25, 0.32, 1.00, 2.27, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.f', 'CXP', 1, 82.36, 25, 9.91, 53.31, 95.02, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.f', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.f', 'CXP', 3, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.f', 'CXP', 4, 9.94, 25, 9.21, 1.30, 47.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.b.1.f', 'CXP', 5, 7.70, 25, 5.01, 1.91, 26.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.a', 'CX', NULL, 1.06, 25, 0.05, 1.00, 1.16, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.a', 'CXP', 1, 94.26, 25, 4.80, 72.46, 99.03, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.a', 'CXP', 2, 5.74, 25, 4.80, 0.97, 27.54, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.b', 'CX', NULL, 1.72, 25, 0.22, 1.26, 2.17, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.b', 'CXP', 1, 61.16, 25, 12.16, 35.38, 81.91, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.b', 'CXP', 2, 11.83, 25, 8.84, 2.28, 43.54, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.b', 'CXP', 3, 22.33, 25, 11.08, 7.14, 51.81, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.b', 'CXP', 4, 3.68, 25, 2.78, 0.75, 16.18, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.b', 'CXP', 5, 1.00, 25, 1.02, 0.12, 7.84, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.c', 'CX', NULL, 1.48, 25, 0.21, 1.04, 1.92, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.c', 'CXP', 1, 75.85, 25, 10.77, 48.27, 91.35, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.c', 'CXP', 2, 15.61, 25, 10.24, 3.58, 47.92, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.c', 'CXP', 3, 0.84, 25, 0.86, 0.10, 6.65, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.c', 'CXP', 5, 7.70, 25, 5.01, 1.91, 26.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.d', 'CX', NULL, 1.65, 25, 0.23, 1.18, 2.13, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.d', 'CXP', 1, 65.84, 25, 11.75, 39.61, 84.99, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.d', 'CXP', 2, 19.95, 25, 10.91, 5.74, 50.52, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.d', 'CXP', 3, 5.67, 25, 5.53, 0.70, 33.73, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.d', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.d', 'CXP', 5, 8.54, 25, 5.10, 2.37, 26.44, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.e', 'CX', NULL, 2.16, 24, 0.36, 1.42, 2.91, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.e', 'CXP', 1, 53.28, 24, 12.62, 28.55, 76.50, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.e', 'CXP', 2, 12.94, 24, 8.16, 3.21, 39.95, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.e', 'CXP', 3, 8.66, 24, 7.43, 1.34, 39.83, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.e', 'CXP', 4, 14.42, 24, 9.75, 3.18, 46.33, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.e', 'CXP', 5, 10.69, 24, 7.30, 2.41, 36.78, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.f', 'CX', NULL, 1.49, 25, 0.25, 1.00, 2.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.f', 'CXP', 1, 75.58, 25, 10.96, 47.61, 91.33, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.f', 'CXP', 2, 9.74, 25, 6.53, 2.27, 33.33, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.f', 'CXP', 3, 9.94, 25, 9.21, 1.30, 47.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.f', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.c.1.f', 'CXP', 5, 4.74, 25, 4.68, 0.58, 29.70, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.a', 'CX', NULL, 3.83, 25, 0.20, 3.42, 4.23, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.a', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.a', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.a', 'CXP', 3, 38.61, 25, 12.42, 17.58, 64.97, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.a', 'CXP', 4, 40.21, 25, 12.36, 18.88, 66.02, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.a', 'CXP', 5, 21.18, 25, 10.76, 6.64, 50.40, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.b', 'CX', NULL, 2.34, 25, 0.12, 2.10, 2.59, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.b', 'CXP', 1, 0.84, 25, 0.85, 0.10, 6.53, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.b', 'CXP', 2, 64.13, 25, 11.78, 38.33, 83.72, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.b', 'CXP', 3, 35.03, 25, 11.79, 15.62, 61.10, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.b', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.b', 'CXP', 5, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.c', 'CX', NULL, 1.24, 25, 0.11, 1.02, 1.47, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.c', 'CXP', 1, 75.73, 25, 10.94, 47.73, 91.43, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.c', 'CXP', 2, 24.27, 25, 10.94, 8.57, 52.27, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.d', 'CX', NULL, 2.14, 25, 0.11, 1.92, 2.36, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.d', 'CXP', 1, 2.84, 25, 2.22, 0.55, 13.30, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.d', 'CXP', 2, 80.55, 25, 10.31, 51.56, 94.16, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.d', 'CXP', 3, 16.61, 25, 10.25, 4.14, 47.83, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.d', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.e', 'CX', NULL, 1.43, 25, 0.19, 1.05, 1.82, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.e', 'CXP', 1, 66.88, 25, 11.45, 40.99, 85.44, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.e', 'CXP', 2, 23.18, 25, 9.15, 9.46, 46.56, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.e', 'CXP', 3, 9.94, 25, 9.21, 1.30, 47.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.f', 'CX', NULL, 1.34, 25, 0.19, 1.00, 1.73, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.f', 'CXP', 1, 75.73, 25, 10.94, 47.73, 91.43, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.f', 'CXP', 2, 14.33, 25, 7.55, 4.48, 37.32, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.f', 'CXP', 3, 9.94, 25, 9.21, 1.30, 47.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.f', 'CXP', 5, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.g', 'CX', NULL, 1.86, 25, 0.25, 1.36, 2.37, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.g', 'CXP', 1, 48.35, 25, 12.18, 25.49, 71.92, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.g', 'CXP', 2, 29.22, 25, 10.98, 12.12, 55.27, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.g', 'CXP', 3, 10.04, 25, 8.61, 1.54, 44.37, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.g', 'CXP', 4, 12.39, 25, 7.55, 3.26, 37.26, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.g', 'CXP', 5, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.h', 'CX', NULL, 1.48, 24, 0.21, 1.05, 1.92, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.h', 'CXP', 1, 67.48, 24, 11.67, 40.85, 86.18, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.h', 'CXP', 2, 16.68, 24, 7.46, 6.19, 37.79, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.h', 'CXP', 3, 15.84, 24, 10.45, 3.59, 48.80, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.h', 'CXP', 4, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.i', 'CX', NULL, 2.19, 25, 0.28, 1.61, 2.77, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.i', 'CXP', 1, 37.98, 25, 11.71, 18.00, 63.07, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.i', 'CXP', 2, 24.46, 25, 9.44, 10.14, 48.16, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.i', 'CXP', 3, 24.96, 25, 12.11, 8.05, 55.80, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.i', 'CXP', 4, 5.95, 25, 5.13, 0.94, 29.58, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.d.1.i', 'CXP', 5, 6.66, 25, 5.63, 1.09, 31.61, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.d', 'CX', NULL, 2.01, 25, 0.29, 1.41, 2.61, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.d', 'CXP', 1, 47.09, 25, 12.52, 23.98, 71.51, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.d', 'CXP', 2, 31.05, 25, 11.55, 12.88, 57.83, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.d', 'CXP', 3, 0.84, 25, 0.85, 0.10, 6.53, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.d', 'CXP', 4, 16.08, 25, 9.96, 4.01, 46.79, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.d', 'CXP', 5, 4.93, 25, 3.38, 1.16, 18.69, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.e', 'CX', NULL, 1.35, 25, 0.17, 1.00, 1.71, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.e', 'CXP', 1, 84.28, 25, 7.70, 61.75, 94.68, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.e', 'CXP', 2, 7.18, 25, 5.88, 1.24, 32.34, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.e', 'CXP', 3, 0.84, 25, 0.86, 0.10, 6.65, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.e', 'CXP', 4, 4.74, 25, 4.68, 0.58, 29.70, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.2.e.1.e', 'CXP', 5, 2.96, 25, 2.98, 0.36, 20.66, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.1', 'CX', NULL, 3.45, 25, 0.38, 2.66, 4.24, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.1', 'CXP', 1, 18.54, 25, 9.88, 5.57, 46.77, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.1', 'CXP', 2, 11.17, 25, 8.65, 2.04, 43.20, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.1', 'CXP', 3, 15.53, 25, 9.80, 3.79, 46.22, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.1', 'CXP', 4, 16.26, 25, 8.24, 5.27, 40.39, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.1', 'CXP', 5, 38.49, 25, 11.76, 18.34, 63.55, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.a', 'CX', NULL, 4.87, 25, 0.09, 4.69, 5.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.a', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.a', 'CXP', 3, 0.84, 25, 0.86, 0.10, 6.65, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.a', 'CXP', 4, 11.70, 25, 8.61, 2.32, 42.51, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.a', 'CXP', 5, 87.46, 25, 8.64, 57.86, 97.25, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.b', 'CX', NULL, 4.91, 25, 0.06, 4.79, 5.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.b', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.b', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.b', 'CXP', 3, 3.52, 25, 2.76, 0.68, 16.33, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.b', 'CXP', 4, 2.24, 25, 1.67, 0.47, 9.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.2.b', 'CXP', 5, 94.23, 25, 3.22, 82.79, 98.23, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.4', 'CX', NULL, 4.91, 25, 0.06, 4.79, 5.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.4', 'CXP', 1, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.4', 'CXP', 2, 0.00, 25, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.4', 'CXP', 3, 1.00, 25, 1.02, 0.12, 7.84, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.4', 'CXP', 4, 6.62, 25, 5.78, 1.02, 32.77, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.a.4', 'CXP', 5, 92.38, 25, 5.88, 68.36, 98.55, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.2', 'CX', NULL, 2.68, 24, 0.26, 2.13, 3.22, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.2', 'CXP', 1, 22.82, 24, 8.64, 9.67, 44.94, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.2', 'CXP', 2, 22.62, 24, 10.49, 7.80, 50.25, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.2', 'CXP', 3, 18.66, 24, 11.50, 4.56, 52.37, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.2', 'CXP', 4, 35.91, 24, 11.74, 16.32, 61.67, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.2', 'CXP', 5, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.4', 'CX', NULL, 4.16, 24, 0.20, 3.75, 4.57, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.4', 'CXP', 1, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.4', 'CXP', 2, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.4', 'CXP', 3, 24.43, 24, 10.35, 9.21, 50.75, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.4', 'CXP', 4, 35.09, 24, 12.11, 15.26, 61.88, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.4', 'CXP', 5, 40.47, 24, 12.87, 18.38, 67.24, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.7', 'CX', NULL, 3.23, 24, 0.30, 2.60, 3.86, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.7', 'CXP', 1, 14.93, 24, 8.16, 4.44, 39.86, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.7', 'CXP', 2, 15.11, 24, 8.13, 4.58, 39.77, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.7', 'CXP', 3, 17.19, 24, 10.42, 4.37, 48.54, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.7', 'CXP', 4, 37.40, 24, 12.47, 16.57, 64.25, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.7', 'CXP', 5, 15.37, 24, 8.56, 4.45, 41.47, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.8', 'CX', NULL, 4.98, 24, 0.01, 4.95, 5.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.8', 'CXP', 1, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.8', 'CXP', 2, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.8', 'CXP', 3, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.8', 'CXP', 4, 1.96, 24, 1.45, 0.42, 8.71, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.b.8', 'CXP', 5, 98.04, 24, 1.45, 91.29, 99.58, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.c.1', 'CX', NULL, 4.18, 24, 0.25, 3.66, 4.70, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.c.1', 'CXP', 1, 2.85, 24, 2.78, 0.37, 18.97, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.c.1', 'CXP', 2, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.c.1', 'CXP', 3, 27.44, 24, 12.26, 9.57, 57.47, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.c.1', 'CXP', 4, 15.74, 24, 8.18, 4.96, 40.09, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.c.1', 'CXP', 5, 53.96, 24, 12.94, 28.53, 77.49, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.1', 'CX', NULL, 4.20, 24, 0.22, 3.75, 4.65, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.1', 'CXP', 1, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.1', 'CXP', 2, 0.00, 24, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.1', 'CXP', 3, 27.13, 24, 11.41, 10.13, 55.13, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.1', 'CXP', 4, 25.70, 24, 10.26, 10.22, 51.25, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.1', 'CXP', 5, 47.17, 24, 12.74, 23.67, 72.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.3', 'CX', NULL, 1.66, 24, 0.24, 1.17, 2.15, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.3', 'CXP', 1, 66.77, 24, 12.26, 39.06, 86.30, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.3', 'CXP', 2, 11.79, 24, 9.77, 1.88, 48.25, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.3', 'CXP', 3, 13.24, 24, 8.43, 3.24, 41.04, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.3', 'CXP', 4, 5.05, 24, 4.98, 0.62, 31.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.3', 'CXP', 5, 3.15, 24, 3.18, 0.38, 21.91, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.4', 'CT', NULL, 1.30, 24, 0.13, 1.03, 1.57, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.4', 'CTP', 1, 74.85, 24, 10.59, 48.17, 90.51, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.4', 'CTP', 2, 20.10, 24, 10.03, 6.47, 47.80, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.4', 'CTP', 3, 5.05, 24, 4.98, 0.62, 31.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.8', 'CT', NULL, 2.89, 23, 0.11, 2.66, 3.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.8', 'CTP', 1, 5.61, 23, 5.49, 0.69, 33.79, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.8', 'CTP', 2, 0.00, 23, 0.00, NULL, NULL, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.C.3.d.8', 'CTP', 3, 94.39, 23, 5.49, 66.21, 99.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.c', 'CX', NULL, 2.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.c', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.c', 'CXP', 2, 30.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.c', 'CXP', 3, 61.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.c', 'CXP', 4, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.c', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.f', 'CX', NULL, 4.88, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.f', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.f', 'CXP', 2, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.f', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.f', 'CXP', 4, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.f', 'CXP', 5, 88.46, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.h', 'CX', NULL, 4.96, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.h', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.h', 'CXP', 2, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.h', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.h', 'CXP', 4, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.h', 'CXP', 5, 96.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.j', 'CX', NULL, 3.96, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.j', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.j', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.j', 'CXP', 3, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.j', 'CXP', 4, 60.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.j', 'CXP', 5, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.l', 'CX', NULL, 4.76, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.l', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.l', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.l', 'CXP', 3, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.l', 'CXP', 4, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.2.l', 'CXP', 5, 80.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.4', 'CX', NULL, 4.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.4', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.4', 'CXP', 2, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.4', 'CXP', 3, 15.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.4', 'CXP', 4, 30.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.a.4', 'CXP', 5, 53.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.e', 'CX', NULL, 4.48, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.e', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.e', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.e', 'CXP', 3, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.e', 'CXP', 4, 44.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.e', 'CXP', 5, 52.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.f', 'CX', NULL, 3.73, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.f', 'CXP', 1, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.f', 'CXP', 2, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.f', 'CXP', 3, 15.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.f', 'CXP', 4, 46.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.f', 'CXP', 5, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.g', 'CX', NULL, 4.12, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.g', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.g', 'CXP', 2, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.g', 'CXP', 3, 19.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.g', 'CXP', 4, 50.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.b.1.g', 'CXP', 5, 30.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.1', 'CX', NULL, 2.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.1', 'CXP', 1, 19.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.1', 'CXP', 2, 42.31, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.1', 'CXP', 3, 15.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.1', 'CXP', 4, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.1', 'CXP', 5, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.2', 'CX', NULL, 3.36, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.2', 'CXP', 1, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.2', 'CXP', 2, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.2', 'CXP', 3, 40.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.2', 'CXP', 4, 44.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.c.2', 'CXP', 5, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.1', 'CX', NULL, 2.76, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.1', 'CXP', 1, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.1', 'CXP', 2, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.1', 'CXP', 3, 32.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.1', 'CXP', 4, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.1', 'CXP', 5, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.2', 'CX', NULL, 2.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.2', 'CXP', 1, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.2', 'CXP', 2, 53.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.2', 'CXP', 3, 30.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.2', 'CXP', 4, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.2', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.3', 'CX', NULL, 1.04, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.3', 'CXP', 1, 96.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.3', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.3', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.3', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.1.d.3', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.a', 'CX', NULL, 4.46, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.a', 'CXP', 1, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.a', 'CXP', 2, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.a', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.a', 'CXP', 4, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.a', 'CXP', 5, 76.92, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.b', 'CX', NULL, 2.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.b', 'CXP', 1, 26.92, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.b', 'CXP', 2, 46.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.b', 'CXP', 3, 19.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.b', 'CXP', 4, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.b', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.c', 'CX', NULL, 1.92, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.c', 'CXP', 1, 34.62, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.c', 'CXP', 2, 46.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.c', 'CXP', 3, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.c', 'CXP', 4, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.c', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.d', 'CX', NULL, 1.84, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.d', 'CXP', 1, 40.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.d', 'CXP', 2, 40.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.d', 'CXP', 3, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.d', 'CXP', 4, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.d', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.e', 'CX', NULL, 1.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.e', 'CXP', 1, 100.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.e', 'CXP', 2, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.e', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.e', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.e', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.f', 'CX', NULL, 2.72, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.f', 'CXP', 1, 32.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.f', 'CXP', 2, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.f', 'CXP', 3, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.f', 'CXP', 4, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.1.f', 'CXP', 5, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.3', 'CX', NULL, 2.92, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.3', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.3', 'CXP', 2, 26.92, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.3', 'CXP', 3, 61.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.3', 'CXP', 4, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.a.3', 'CXP', 5, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.a', 'CX', NULL, 2.04, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.a', 'CXP', 1, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.a', 'CXP', 2, 32.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.a', 'CXP', 3, 24.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.a', 'CXP', 4, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.a', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.b', 'CX', NULL, 1.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.b', 'CXP', 1, 42.31, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.b', 'CXP', 2, 50.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.b', 'CXP', 3, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.b', 'CXP', 4, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.b', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.c', 'CX', NULL, 1.42, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.c', 'CXP', 1, 57.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.c', 'CXP', 2, 42.31, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.c', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.c', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.c', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.d', 'CX', NULL, 1.65, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.d', 'CXP', 1, 46.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.d', 'CXP', 2, 42.31, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.d', 'CXP', 3, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.d', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.d', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.e', 'CX', NULL, 1.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.e', 'CXP', 1, 65.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.e', 'CXP', 2, 30.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.e', 'CXP', 3, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.e', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.e', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.f', 'CX', NULL, 1.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.f', 'CXP', 1, 92.31, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.f', 'CXP', 2, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.f', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.f', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.b.1.f', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.a', 'CX', NULL, 1.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.a', 'CXP', 1, 96.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.a', 'CXP', 2, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.a', 'CXP', 3, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.a', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.a', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.b', 'CX', NULL, 1.12, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.b', 'CXP', 1, 88.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.b', 'CXP', 2, 12.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.b', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.b', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.b', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.c', 'CX', NULL, 1.50, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.c', 'CXP', 1, 50.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.c', 'CXP', 2, 50.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.c', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.c', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.c', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.d', 'CX', NULL, 1.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.d', 'CXP', 1, 76.92, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.d', 'CXP', 2, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.d', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.d', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.d', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.e', 'CX', NULL, 1.17, 24, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.e', 'CXP', 1, 87.50, 24, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.e', 'CXP', 2, 8.33, 24, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.e', 'CXP', 3, 4.17, 24, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.e', 'CXP', 4, 0.00, 24, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.e', 'CXP', 5, 0.00, 24, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.f', 'CX', NULL, 1.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.f', 'CXP', 1, 84.62, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.f', 'CXP', 2, 15.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.f', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.f', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.c.1.f', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.a', 'CX', NULL, 4.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.a', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.a', 'CXP', 2, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.a', 'CXP', 3, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.a', 'CXP', 4, 46.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.a', 'CXP', 5, 46.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.b', 'CX', NULL, 1.96, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.b', 'CXP', 1, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.b', 'CXP', 2, 88.46, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.b', 'CXP', 3, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.b', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.b', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.c', 'CX', NULL, 1.36, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.c', 'CXP', 1, 64.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.c', 'CXP', 2, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.c', 'CXP', 3, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.c', 'CXP', 4, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.c', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.d', 'CX', NULL, 1.92, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.d', 'CXP', 1, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.d', 'CXP', 2, 69.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.d', 'CXP', 3, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.d', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.d', 'CXP', 5, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.e', 'CX', NULL, 1.12, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.e', 'CXP', 1, 88.46, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.e', 'CXP', 2, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.e', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.e', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.e', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.f', 'CX', NULL, 1.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.f', 'CXP', 1, 92.31, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.f', 'CXP', 2, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.f', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.f', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.f', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.g', 'CX', NULL, 1.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.g', 'CXP', 1, 73.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.g', 'CXP', 2, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.g', 'CXP', 3, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.g', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.g', 'CXP', 5, 15.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.h', 'CX', NULL, 1.19, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.h', 'CXP', 1, 80.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.h', 'CXP', 2, 19.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.h', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.h', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.h', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.i', 'CX', NULL, 2.35, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.i', 'CXP', 1, 53.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.i', 'CXP', 2, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.i', 'CXP', 3, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.i', 'CXP', 4, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.d.1.i', 'CXP', 5, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.d', 'CX', NULL, 2.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.d', 'CXP', 1, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.d', 'CXP', 2, 46.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.d', 'CXP', 3, 19.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.d', 'CXP', 4, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.d', 'CXP', 5, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.e', 'CX', NULL, 1.42, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.e', 'CXP', 1, 73.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.e', 'CXP', 2, 19.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.e', 'CXP', 3, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.e', 'CXP', 4, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.2.e.1.e', 'CXP', 5, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.1', 'CX', NULL, 2.35, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.1', 'CXP', 1, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.1', 'CXP', 2, 34.62, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.1', 'CXP', 3, 26.92, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.1', 'CXP', 4, 15.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.1', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.a', 'CX', NULL, 3.92, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.a', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.a', 'CXP', 2, 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.a', 'CXP', 3, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.a', 'CXP', 4, 56.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.a', 'CXP', 5, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.b', 'CX', NULL, 3.60, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.b', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.b', 'CXP', 2, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.b', 'CXP', 3, 24.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.b', 'CXP', 4, 44.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.2.b', 'CXP', 5, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.4', 'CX', NULL, 4.42, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.4', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.4', 'CXP', 2, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.4', 'CXP', 3, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.4', 'CXP', 4, 34.62, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.a.4', 'CXP', 5, 53.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.2', 'CX', NULL, 1.72, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.2', 'CXP', 1, 60.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.2', 'CXP', 2, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.2', 'CXP', 3, 16.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.2', 'CXP', 4, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.2', 'CXP', 5, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.4', 'CX', NULL, 3.42, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.4', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.4', 'CXP', 2, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.4', 'CXP', 3, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.4', 'CXP', 4, 42.31, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.4', 'CXP', 5, 11.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.7', 'CX', NULL, 2.24, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.7', 'CXP', 1, 36.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.7', 'CXP', 2, 28.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.7', 'CXP', 3, 20.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.7', 'CXP', 4, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.7', 'CXP', 5, 8.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.8', 'CX', NULL, 4.36, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.8', 'CXP', 1, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.8', 'CXP', 2, 0.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.8', 'CXP', 3, 12.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.8', 'CXP', 4, 40.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.b.8', 'CXP', 5, 48.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.c.1', 'CX', NULL, 3.46, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.c.1', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.c.1', 'CXP', 2, 15.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.c.1', 'CXP', 3, 30.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.c.1', 'CXP', 4, 46.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.c.1', 'CXP', 5, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.1', 'CX', NULL, 3.65, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.1', 'CXP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.1', 'CXP', 2, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.1', 'CXP', 3, 34.62, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.1', 'CXP', 4, 53.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.1', 'CXP', 5, 7.69, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.3', 'CX', NULL, 1.12, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.3', 'CXP', 1, 96.15, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.3', 'CXP', 2, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.3', 'CXP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.3', 'CXP', 4, 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.3', 'CXP', 5, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.4', 'CT', NULL, 1.35, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.4', 'CTP', 1, 65.38, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.4', 'CTP', 2, 34.62, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.4', 'CTP', 3, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.8', 'CT', NULL, 2.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.8', 'CTP', 1, 0.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.8', 'CTP', 2, 23.08, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.C.3.d.8', 'CTP', 3, 76.92, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.c', 'CX', NULL, 2.87, 52, 0.22, 2.43, 3.32, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.c', 'CXP', 1, 16.09, 52, 6.27, 7.02, 32.76, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.c', 'CXP', 2, 22.63, 52, 8.23, 10.22, 42.91, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.c', 'CXP', 3, 27.67, 52, 8.61, 13.90, 47.56, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.c', 'CXP', 4, 25.15, 52, 9.44, 10.93, 47.90, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.c', 'CXP', 5, 8.45, 52, 4.87, 2.55, 24.61, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.f', 'CX', NULL, 4.93, 52, 0.04, 4.85, 5.00, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.f', 'CXP', 1, 0.71, 52, 0.52, 0.16, 3.04, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.f', 'CXP', 3, 1.43, 52, 1.43, 0.19, 10.08, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.f', 'CXP', 4, 1.52, 52, 1.14, 0.33, 6.68, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.f', 'CXP', 5, 96.34, 52, 1.94, 89.74, 98.75, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.h', 'CX', NULL, 4.85, 52, 0.08, 4.69, 5.00, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.h', 'CXP', 1, 2.03, 52, 1.74, 0.36, 10.68, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.h', 'CXP', 4, 6.53, 52, 4.44, 1.59, 23.14, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.h', 'CXP', 5, 91.44, 52, 4.77, 75.86, 97.32, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.j', 'CX', NULL, 3.95, 51, 0.18, 3.59, 4.31, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.j', 'CXP', 1, 3.59, 51, 1.92, 1.21, 10.18, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.j', 'CXP', 2, 5.20, 51, 4.30, 0.94, 24.01, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.j', 'CXP', 3, 17.73, 51, 7.35, 7.26, 37.23, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.j', 'CXP', 4, 39.50, 51, 9.59, 22.57, 59.38, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.j', 'CXP', 5, 33.99, 51, 9.61, 17.88, 54.90, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.l', 'CX', NULL, 4.95, 52, 0.03, 4.90, 5.00, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.l', 'CXP', 3, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.l', 'CXP', 4, 4.52, 52, 2.94, 1.20, 15.65, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.2.l', 'CXP', 5, 95.48, 52, 2.94, 84.35, 98.80, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.4', 'CX', NULL, 4.79, 52, 0.06, 4.67, 4.92, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.4', 'CXP', 1, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.4', 'CXP', 2, 0.38, 52, 0.38, 0.05, 2.84, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.4', 'CXP', 3, 0.20, 52, 0.20, 0.03, 1.53, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.4', 'CXP', 4, 19.09, 52, 6.15, 9.59, 34.41, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.a.4', 'CXP', 5, 80.33, 52, 6.17, 65.09, 89.94, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.e', 'CX', NULL, 4.79, 52, 0.08, 4.64, 4.95, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.e', 'CXP', 2, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.e', 'CXP', 3, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.e', 'CXP', 4, 20.53, 52, 7.79, 9.02, 40.24, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.e', 'CXP', 5, 79.47, 52, 7.79, 59.76, 90.98, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.f', 'CX', NULL, 4.13, 51, 0.23, 3.67, 4.60, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.f', 'CXP', 1, 5.77, 51, 5.10, 0.92, 28.68, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.f', 'CXP', 2, 3.76, 51, 2.96, 0.75, 16.82, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.f', 'CXP', 3, 13.47, 51, 6.49, 4.84, 32.27, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.f', 'CXP', 4, 25.41, 51, 8.96, 11.65, 46.83, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.f', 'CXP', 5, 51.59, 51, 10.07, 32.17, 70.54, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.g', 'CX', NULL, 4.41, 50, 0.15, 4.11, 4.71, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.g', 'CXP', 1, 0.32, 50, 0.32, 0.04, 2.40, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.g', 'CXP', 2, 0.21, 50, 0.22, 0.03, 1.62, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.g', 'CXP', 3, 13.03, 50, 6.96, 4.17, 34.00, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.g', 'CXP', 4, 31.38, 50, 9.32, 16.09, 52.17, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.b.1.g', 'CXP', 5, 55.06, 50, 10.22, 34.82, 73.75, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.1', 'CX', NULL, 4.23, 51, 0.26, 3.71, 4.75, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.1', 'CXP', 1, 6.58, 51, 6.26, 0.90, 35.28, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.1', 'CXP', 2, 1.14, 51, 1.15, 0.15, 8.24, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.1', 'CXP', 3, 14.21, 51, 6.88, 5.06, 33.98, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.1', 'CXP', 4, 19.15, 51, 7.29, 8.42, 37.87, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.1', 'CXP', 5, 58.92, 51, 9.53, 39.41, 75.98, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.2', 'CX', NULL, 4.55, 51, 0.17, 4.21, 4.88, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.2', 'CXP', 1, 0.00, 51, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.2', 'CXP', 2, 5.35, 51, 5.26, 0.70, 31.30, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.2', 'CXP', 3, 0.21, 51, 0.21, 0.03, 1.61, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.2', 'CXP', 4, 28.96, 51, 9.03, 14.44, 49.60, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.c.2', 'CXP', 5, 65.48, 51, 9.67, 44.55, 81.75, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.1', 'CX', NULL, 3.73, 51, 0.17, 3.38, 4.08, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.1', 'CXP', 1, 0.35, 51, 0.36, 0.05, 2.66, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.1', 'CXP', 2, 9.55, 51, 5.87, 2.63, 29.27, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.1', 'CXP', 3, 27.28, 51, 9.44, 12.60, 49.39, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.1', 'CXP', 4, 42.44, 51, 9.83, 24.73, 62.34, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.1', 'CXP', 5, 20.37, 51, 7.33, 9.36, 38.81, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.2', 'CX', NULL, 3.44, 51, 0.21, 3.02, 3.86, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.2', 'CXP', 1, 2.19, 51, 1.43, 0.58, 7.87, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.2', 'CXP', 2, 21.20, 51, 8.74, 8.60, 43.49, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.2', 'CXP', 3, 22.93, 51, 8.65, 10.02, 44.30, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.2', 'CXP', 4, 37.67, 51, 9.35, 21.36, 57.35, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.2', 'CXP', 5, 16.01, 51, 6.83, 6.43, 34.59, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.3', 'CX', NULL, 1.44, 51, 0.12, 1.20, 1.67, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.3', 'CXP', 1, 62.40, 51, 9.05, 43.33, 78.27, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.3', 'CXP', 2, 32.72, 51, 8.30, 18.57, 50.91, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.3', 'CXP', 3, 4.35, 51, 4.33, 0.56, 26.86, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.3', 'CXP', 4, 0.00, 51, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.1.d.3', 'CXP', 5, 0.52, 51, 0.39, 0.12, 2.31, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.a', 'CX', NULL, 4.65, 50, 0.18, 4.29, 5.00, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.a', 'CXP', 1, 8.03, 50, 4.35, 2.60, 22.19, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.a', 'CXP', 2, 0.36, 50, 0.36, 0.05, 2.69, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.a', 'CXP', 3, 0.00, 50, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.a', 'CXP', 4, 2.23, 50, 1.55, 0.54, 8.72, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.a', 'CXP', 5, 89.39, 50, 4.64, 75.90, 95.75, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.b', 'CX', NULL, 2.32, 51, 0.32, 1.69, 2.96, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.b', 'CXP', 1, 53.70, 51, 10.21, 33.69, 72.58, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.b', 'CXP', 2, 15.00, 51, 7.26, 5.33, 35.63, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.b', 'CXP', 3, 0.06, 51, 0.06, 0.01, 0.49, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.b', 'CXP', 4, 7.89, 51, 5.43, 1.87, 27.78, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.b', 'CXP', 5, 23.35, 51, 7.29, 11.85, 40.83, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.c', 'CX', NULL, 1.96, 52, 0.24, 1.48, 2.44, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.c', 'CXP', 1, 57.69, 52, 9.71, 38.02, 75.19, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.c', 'CXP', 2, 9.05, 52, 6.30, 2.10, 31.63, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.c', 'CXP', 3, 20.03, 52, 7.51, 8.89, 39.11, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.c', 'CXP', 4, 5.89, 52, 4.31, 1.30, 22.95, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.c', 'CXP', 5, 7.35, 52, 4.40, 2.12, 22.52, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.d', 'CX', NULL, 1.41, 51, 0.13, 1.15, 1.66, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.d', 'CXP', 1, 78.03, 51, 6.91, 61.25, 88.87, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.d', 'CXP', 2, 6.15, 51, 3.88, 1.67, 20.18, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.d', 'CXP', 3, 13.44, 51, 5.82, 5.38, 29.78, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.d', 'CXP', 4, 1.73, 51, 1.20, 0.43, 6.76, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.d', 'CXP', 5, 0.64, 51, 0.46, 0.15, 2.71, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.e', 'CX', NULL, 1.31, 52, 0.11, 1.08, 1.53, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.e', 'CXP', 1, 82.34, 52, 7.13, 63.55, 92.57, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.e', 'CXP', 2, 9.46, 52, 5.85, 2.58, 29.17, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.e', 'CXP', 3, 4.96, 52, 4.08, 0.91, 22.89, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.e', 'CXP', 4, 1.84, 52, 1.19, 0.49, 6.60, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.e', 'CXP', 5, 1.41, 52, 1.17, 0.26, 7.16, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.f', 'CX', NULL, 2.13, 51, 0.26, 1.60, 2.66, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.f', 'CXP', 1, 49.34, 51, 10.39, 29.70, 69.19, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.f', 'CXP', 2, 17.11, 51, 7.57, 6.59, 37.63, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.f', 'CXP', 3, 12.88, 51, 5.92, 4.87, 29.91, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.f', 'CXP', 4, 12.95, 51, 6.94, 4.14, 33.90, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.1.f', 'CXP', 5, 7.72, 51, 4.47, 2.32, 22.76, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.3', 'CX', NULL, 3.21, 51, 0.22, 2.76, 3.65, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.3', 'CXP', 1, 0.00, 51, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.3', 'CXP', 2, 37.21, 51, 9.74, 20.41, 57.79, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.3', 'CXP', 3, 21.07, 51, 8.33, 8.89, 42.21, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.3', 'CXP', 4, 25.44, 51, 8.12, 12.62, 44.64, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.a.3', 'CXP', 5, 16.28, 51, 7.71, 5.87, 37.72, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.a', 'CX', NULL, 3.22, 52, 0.29, 2.64, 3.81, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.a', 'CXP', 1, 19.56, 52, 8.20, 7.86, 40.92, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.a', 'CXP', 2, 15.43, 52, 7.43, 5.50, 36.38, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.a', 'CXP', 3, 11.71, 52, 6.28, 3.78, 30.97, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.a', 'CXP', 4, 29.78, 52, 9.74, 14.27, 51.94, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.a', 'CXP', 5, 23.52, 52, 7.98, 11.20, 42.85, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.b', 'CX', NULL, 1.94, 51, 0.20, 1.53, 2.35, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.b', 'CXP', 1, 43.99, 51, 10.50, 25.02, 64.89, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.b', 'CXP', 2, 35.73, 51, 9.83, 19.05, 56.76, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.b', 'CXP', 3, 5.46, 51, 4.11, 1.15, 22.26, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.b', 'CXP', 4, 11.64, 51, 5.96, 3.95, 29.68, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.b', 'CXP', 5, 3.19, 51, 1.91, 0.94, 10.26, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.c', 'CX', NULL, 1.36, 52, 0.14, 1.07, 1.65, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.c', 'CXP', 1, 84.79, 52, 5.93, 68.88, 93.35, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.c', 'CXP', 2, 4.75, 52, 3.70, 0.96, 20.49, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.c', 'CXP', 3, 5.24, 52, 4.14, 1.02, 22.78, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.c', 'CXP', 4, 0.50, 52, 0.37, 0.11, 2.19, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.c', 'CXP', 5, 4.72, 52, 3.06, 1.25, 16.27, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.d', 'CX', NULL, 2.31, 51, 0.33, 1.65, 2.97, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.d', 'CXP', 1, 57.32, 51, 9.01, 39.06, 73.79, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.d', 'CXP', 2, 10.02, 51, 5.87, 2.92, 29.18, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.d', 'CXP', 3, 4.33, 51, 4.03, 0.64, 24.21, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.d', 'CXP', 4, 1.25, 51, 0.80, 0.34, 4.44, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.d', 'CXP', 5, 27.08, 51, 8.60, 13.41, 47.11, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.e', 'CX', NULL, 1.53, 51, 0.17, 1.18, 1.87, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.e', 'CXP', 1, 73.19, 51, 8.25, 53.98, 86.40, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.e', 'CXP', 2, 9.75, 51, 5.01, 3.33, 25.31, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.e', 'CXP', 3, 12.54, 51, 6.62, 4.09, 32.52, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.e', 'CXP', 4, 0.39, 51, 0.40, 0.05, 2.96, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.e', 'CXP', 5, 4.13, 51, 3.05, 0.91, 16.86, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.f', 'CX', NULL, 1.03, 51, 0.02, 1.00, 1.06, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.f', 'CXP', 1, 96.91, 51, 1.64, 91.25, 98.95, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.f', 'CXP', 2, 3.09, 51, 1.64, 1.05, 8.75, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.f', 'CXP', 3, 0.00, 51, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 51, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 51, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.a', 'CX', NULL, 1.09, 51, 0.09, 1.00, 1.27, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.a', 'CXP', 1, 97.77, 51, 2.19, 85.32, 99.70, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.a', 'CXP', 2, 0.00, 51, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 51, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 51, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.a', 'CXP', 5, 2.23, 51, 2.19, 0.30, 14.68, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.b', 'CX', NULL, 1.56, 51, 0.22, 1.11, 2.01, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.b', 'CXP', 1, 74.70, 51, 7.72, 56.52, 87.03, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.b', 'CXP', 2, 12.00, 51, 5.81, 4.32, 29.18, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.b', 'CXP', 3, 4.57, 51, 4.54, 0.59, 27.94, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.b', 'CXP', 4, 0.00, 51, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.b', 'CXP', 5, 8.73, 51, 6.11, 2.01, 30.84, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.c', 'CX', NULL, 1.84, 51, 0.17, 1.49, 2.19, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.c', 'CXP', 1, 43.95, 51, 9.69, 26.24, 63.34, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.c', 'CXP', 2, 33.59, 51, 9.88, 17.21, 55.18, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.c', 'CXP', 3, 16.92, 51, 7.88, 6.20, 38.56, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.c', 'CXP', 4, 5.54, 51, 4.17, 1.17, 22.52, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 51, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.d', 'CX', NULL, 1.64, 51, 0.18, 1.29, 2.00, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.d', 'CXP', 1, 67.13, 51, 8.74, 47.96, 81.90, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.d', 'CXP', 2, 9.02, 51, 5.36, 2.60, 26.91, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.d', 'CXP', 3, 18.87, 51, 6.93, 8.57, 36.60, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.d', 'CXP', 4, 2.23, 51, 1.56, 0.54, 8.76, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.d', 'CXP', 5, 2.76, 51, 1.60, 0.85, 8.62, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.e', 'CX', NULL, 2.66, 51, 0.33, 1.99, 3.33, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.e', 'CXP', 1, 45.21, 51, 10.02, 26.80, 65.03, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.e', 'CXP', 2, 5.51, 51, 3.82, 1.32, 20.29, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.e', 'CXP', 3, 13.89, 51, 7.21, 4.58, 35.14, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.e', 'CXP', 4, 9.01, 51, 5.82, 2.32, 29.20, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.e', 'CXP', 5, 26.38, 51, 8.43, 13.03, 46.13, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.f', 'CX', NULL, 1.77, 52, 0.16, 1.45, 2.09, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.f', 'CXP', 1, 55.62, 52, 9.02, 37.58, 72.29, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.f', 'CXP', 2, 17.95, 52, 7.51, 7.29, 37.84, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.f', 'CXP', 3, 22.39, 52, 7.38, 10.96, 40.35, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.f', 'CXP', 4, 1.50, 52, 1.19, 0.30, 7.15, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.c.1.f', 'CXP', 5, 2.54, 52, 1.79, 0.60, 10.04, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.a', 'CX', NULL, 3.56, 52, 0.22, 3.13, 3.99, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.a', 'CXP', 1, 1.73, 52, 1.47, 0.31, 9.11, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.a', 'CXP', 2, 19.11, 52, 6.85, 8.84, 36.51, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.a', 'CXP', 3, 23.60, 52, 7.62, 11.68, 41.91, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.a', 'CXP', 4, 32.73, 52, 9.30, 17.24, 53.18, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.a', 'CXP', 5, 22.84, 52, 9.25, 9.35, 45.93, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.b', 'CX', NULL, 2.80, 52, 0.23, 2.34, 3.25, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.b', 'CXP', 1, 7.68, 52, 6.04, 1.48, 31.53, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.b', 'CXP', 2, 43.11, 52, 9.82, 25.32, 62.88, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.b', 'CXP', 3, 22.38, 52, 7.57, 10.73, 40.88, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.b', 'CXP', 4, 15.70, 52, 7.49, 5.64, 36.72, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.b', 'CXP', 5, 11.14, 52, 5.75, 3.76, 28.69, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.c', 'CX', NULL, 1.35, 52, 0.09, 1.17, 1.53, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.c', 'CXP', 1, 64.94, 52, 8.91, 45.79, 80.25, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.c', 'CXP', 2, 35.06, 52, 8.91, 19.75, 54.21, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.d', 'CX', NULL, 2.22, 51, 0.20, 1.83, 2.62, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.d', 'CXP', 1, 18.40, 51, 8.31, 6.91, 40.65, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.d', 'CXP', 2, 59.73, 51, 9.71, 39.72, 76.95, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.d', 'CXP', 3, 10.20, 51, 5.07, 3.60, 25.69, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.d', 'CXP', 4, 4.60, 51, 4.20, 0.70, 24.80, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.d', 'CXP', 5, 7.07, 51, 4.52, 1.88, 23.26, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.e', 'CX', NULL, 1.46, 52, 0.12, 1.23, 1.69, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.e', 'CXP', 1, 59.78, 52, 9.35, 40.50, 76.44, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.e', 'CXP', 2, 35.29, 52, 9.00, 19.82, 54.60, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.e', 'CXP', 3, 4.54, 52, 4.15, 0.69, 24.54, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.e', 'CXP', 5, 0.39, 52, 0.40, 0.05, 2.95, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.f', 'CX', NULL, 1.28, 52, 0.12, 1.03, 1.52, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.f', 'CXP', 1, 86.13, 52, 6.65, 67.02, 94.99, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.f', 'CXP', 2, 5.30, 52, 4.56, 0.90, 25.76, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.f', 'CXP', 3, 5.26, 52, 4.25, 0.99, 23.50, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.f', 'CXP', 4, 1.50, 52, 1.16, 0.31, 6.88, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.f', 'CXP', 5, 1.80, 52, 1.48, 0.34, 8.91, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.g', 'CX', NULL, 2.42, 51, 0.29, 1.84, 2.99, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.g', 'CXP', 1, 38.45, 51, 9.56, 21.72, 58.44, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.g', 'CXP', 2, 29.16, 51, 8.24, 15.59, 47.84, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.g', 'CXP', 3, 2.39, 51, 1.35, 0.76, 7.27, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.g', 'CXP', 4, 12.22, 51, 6.53, 3.93, 32.11, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.g', 'CXP', 5, 17.79, 51, 7.00, 7.64, 36.13, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.h', 'CX', NULL, 1.64, 52, 0.12, 1.39, 1.89, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.h', 'CXP', 1, 46.12, 52, 9.43, 28.56, 64.71, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.h', 'CXP', 2, 47.31, 52, 9.23, 29.93, 65.37, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.h', 'CXP', 3, 4.75, 52, 4.16, 0.78, 24.01, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.h', 'CXP', 4, 0.39, 52, 0.40, 0.05, 2.95, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.h', 'CXP', 5, 1.43, 52, 1.43, 0.19, 10.08, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.i', 'CX', NULL, 2.44, 52, 0.28, 1.88, 3.00, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.i', 'CXP', 1, 27.72, 52, 8.95, 13.53, 48.45, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.i', 'CXP', 2, 38.47, 52, 9.30, 22.12, 57.91, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.i', 'CXP', 3, 3.87, 52, 2.80, 0.88, 15.41, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.i', 'CXP', 4, 21.89, 52, 9.18, 8.71, 45.15, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.d.1.i', 'CXP', 5, 8.05, 52, 5.88, 1.75, 30.12, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.d', 'CX', NULL, 2.85, 52, 0.32, 2.22, 3.48, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.d', 'CXP', 1, 31.24, 52, 9.59, 15.64, 52.68, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.d', 'CXP', 2, 16.17, 52, 7.58, 5.91, 37.20, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.d', 'CXP', 3, 19.18, 52, 8.47, 7.35, 41.53, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.d', 'CXP', 4, 3.15, 52, 1.62, 1.11, 8.61, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.d', 'CXP', 5, 30.26, 52, 8.64, 16.01, 49.68, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.e', 'CX', NULL, 1.38, 52, 0.13, 1.11, 1.65, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.e', 'CXP', 1, 74.83, 52, 7.31, 57.70, 86.62, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.e', 'CXP', 2, 18.45, 52, 7.42, 7.76, 37.84, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.e', 'CXP', 3, 0.50, 52, 0.36, 0.12, 2.10, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.e', 'CXP', 4, 5.88, 52, 4.64, 1.15, 25.13, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.2.e.1.e', 'CXP', 5, 0.34, 52, 0.34, 0.04, 2.53, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.1', 'CX', NULL, 3.28, 50, 0.23, 2.82, 3.75, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.1', 'CXP', 1, 11.14, 50, 5.43, 3.99, 27.42, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.1', 'CXP', 2, 11.74, 50, 6.30, 3.77, 31.10, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.1', 'CXP', 3, 30.15, 50, 8.58, 16.00, 49.46, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.1', 'CXP', 4, 31.64, 50, 9.06, 16.63, 51.78, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.1', 'CXP', 5, 15.32, 50, 6.86, 5.89, 34.37, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.a', 'CX', NULL, 4.53, 51, 0.09, 4.34, 4.72, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 51, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.a', 'CXP', 2, 0.31, 51, 0.32, 0.04, 2.36, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.a', 'CXP', 3, 0.00, 51, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.a', 'CXP', 4, 46.24, 51, 9.41, 28.68, 64.79, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.a', 'CXP', 5, 53.45, 51, 9.41, 34.94, 71.06, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.b', 'CX', NULL, 4.54, 52, 0.16, 4.21, 4.86, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.b', 'CXP', 1, 0.34, 52, 0.34, 0.04, 2.53, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.b', 'CXP', 2, 4.45, 52, 4.14, 0.66, 24.76, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.b', 'CXP', 3, 5.66, 52, 4.66, 1.03, 25.71, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.b', 'CXP', 4, 20.39, 52, 7.88, 8.81, 40.44, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.2.b', 'CXP', 5, 69.16, 52, 9.24, 48.44, 84.26, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.4', 'CX', NULL, 4.78, 52, 0.09, 4.61, 4.95, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.4', 'CXP', 1, 0.34, 52, 0.34, 0.04, 2.53, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.4', 'CXP', 2, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.4', 'CXP', 3, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.4', 'CXP', 4, 20.75, 52, 8.49, 8.50, 42.46, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.a.4', 'CXP', 5, 78.91, 52, 8.49, 57.33, 91.25, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.2', 'CX', NULL, 2.27, 50, 0.22, 1.82, 2.72, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.2', 'CXP', 1, 31.13, 50, 9.08, 16.17, 51.43, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.2', 'CXP', 2, 30.83, 50, 9.70, 15.15, 52.66, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.2', 'CXP', 3, 17.62, 50, 6.62, 7.88, 34.85, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.2', 'CXP', 4, 20.43, 50, 8.57, 8.17, 42.53, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.2', 'CXP', 5, 0.00, 50, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.4', 'CX', NULL, 3.99, 52, 0.19, 3.61, 4.38, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.4', 'CXP', 1, 5.11, 52, 5.02, 0.67, 30.12, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.4', 'CXP', 2, 1.61, 52, 1.19, 0.36, 6.85, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.4', 'CXP', 3, 10.41, 52, 5.11, 3.72, 25.87, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.4', 'CXP', 4, 54.43, 52, 9.30, 36.00, 71.71, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.4', 'CXP', 5, 28.45, 52, 8.41, 14.78, 47.68, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.7', 'CX', NULL, 3.59, 51, 0.27, 3.04, 4.13, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.7', 'CXP', 1, 8.55, 51, 5.07, 2.48, 25.61, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.7', 'CXP', 2, 13.83, 51, 7.05, 4.67, 34.48, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.7', 'CXP', 3, 23.59, 51, 8.29, 10.92, 43.74, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.7', 'CXP', 4, 18.57, 51, 6.71, 8.56, 35.73, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.7', 'CXP', 5, 35.46, 51, 9.62, 19.10, 56.11, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.8', 'CX', NULL, 4.80, 52, 0.07, 4.66, 4.95, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.8', 'CXP', 1, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.8', 'CXP', 2, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.8', 'CXP', 3, 1.02, 52, 0.62, 0.30, 3.42, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.8', 'CXP', 4, 17.59, 52, 7.08, 7.41, 36.27, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.b.8', 'CXP', 5, 81.39, 52, 7.12, 62.99, 91.83, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.c.1', 'CX', NULL, 3.44, 52, 0.25, 2.94, 3.95, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.c.1', 'CXP', 1, 15.12, 52, 7.64, 5.11, 37.05, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.c.1', 'CXP', 2, 5.41, 52, 5.03, 0.79, 29.17, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.c.1', 'CXP', 3, 14.43, 52, 5.98, 6.00, 30.83, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.c.1', 'CXP', 4, 50.16, 52, 9.78, 31.46, 68.81, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.c.1', 'CXP', 5, 14.89, 52, 6.08, 6.26, 31.42, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.1', 'CX', NULL, 4.22, 52, 0.16, 3.90, 4.54, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.1', 'CXP', 1, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.1', 'CXP', 2, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.1', 'CXP', 3, 25.81, 52, 8.60, 12.37, 46.16, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.1', 'CXP', 4, 26.56, 52, 8.93, 12.61, 47.54, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.1', 'CXP', 5, 47.64, 52, 9.73, 29.36, 66.57, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.3', 'CX', NULL, 1.60, 51, 0.22, 1.16, 2.04, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.3', 'CXP', 1, 74.55, 51, 8.68, 53.89, 88.01, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.3', 'CXP', 2, 11.19, 51, 6.85, 3.06, 33.48, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.3', 'CXP', 3, 3.24, 51, 1.69, 1.13, 8.97, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.3', 'CXP', 4, 1.66, 51, 1.23, 0.37, 7.12, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.3', 'CXP', 5, 9.35, 51, 4.80, 3.21, 24.33, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.4', 'CT', NULL, 1.15, 51, 0.07, 1.01, 1.29, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.4', 'CTP', 1, 84.94, 51, 6.88, 65.70, 94.32, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.4', 'CTP', 2, 15.00, 51, 6.88, 5.64, 34.27, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.4', 'CTP', 3, 0.06, 51, 0.06, 0.01, 0.47, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.8', 'CT', NULL, 2.86, 52, 0.06, 2.74, 2.98, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.8', 'CTP', 1, 0.00, 52, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.8', 'CTP', 2, 14.20, 52, 6.10, 5.71, 31.15, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.C.3.d.8', 'CTP', 3, 85.80, 52, 6.10, 68.85, 94.29, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.c', 'CX', NULL, 2.37, 19, 0.41, 1.50, 3.25, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.c', 'CXP', 1, 26.46, 19, 20.25, 3.89, 76.20, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.c', 'CXP', 2, 35.62, 19, 14.86, 12.41, 68.34, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.c', 'CXP', 3, 14.94, 19, 8.94, 3.85, 43.51, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.c', 'CXP', 4, 19.98, 19, 10.52, 5.90, 49.86, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.c', 'CXP', 5, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.f', 'CX', NULL, 5.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.f', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.f', 'CXP', 5, 100.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.h', 'CX', NULL, 5.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.h', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.h', 'CXP', 5, 100.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.j', 'CX', NULL, 3.50, 19, 0.25, 2.97, 4.04, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.j', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.j', 'CXP', 2, 16.34, 19, 9.78, 4.17, 46.74, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.j', 'CXP', 3, 31.48, 19, 14.47, 10.10, 65.28, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.j', 'CXP', 4, 37.86, 19, 18.47, 10.48, 76.03, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.j', 'CXP', 5, 14.31, 19, 8.94, 3.48, 43.60, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.l', 'CX', NULL, 4.56, 19, 0.18, 4.18, 4.94, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.l', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.l', 'CXP', 4, 43.66, 19, 18.08, 14.19, 78.40, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.2.l', 'CXP', 5, 56.34, 19, 18.08, 21.60, 85.81, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.4', 'CX', NULL, 4.65, 19, 0.19, 4.25, 5.00, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.4', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.4', 'CXP', 2, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.4', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.4', 'CXP', 4, 34.79, 19, 18.96, 8.44, 75.54, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.a.4', 'CXP', 5, 65.21, 19, 18.96, 24.46, 91.56, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.e', 'CX', NULL, 3.99, 19, 0.33, 3.30, 4.69, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.e', 'CXP', 2, 2.90, 19, 2.98, 0.32, 21.68, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.e', 'CXP', 3, 40.84, 19, 18.36, 12.27, 77.31, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.e', 'CXP', 4, 10.15, 19, 8.76, 1.48, 45.96, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.e', 'CXP', 5, 46.12, 19, 16.28, 17.77, 77.22, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.f', 'CX', NULL, 3.89, 19, 0.35, 3.16, 4.62, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.f', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.f', 'CXP', 2, 11.95, 19, 9.18, 2.12, 45.89, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.f', 'CXP', 3, 31.28, 19, 19.54, 6.31, 75.45, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.f', 'CXP', 4, 13.04, 19, 9.26, 2.63, 45.45, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.f', 'CXP', 5, 43.73, 19, 15.93, 16.63, 75.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.g', 'CX', NULL, 4.12, 19, 0.23, 3.65, 4.60, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.g', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.g', 'CXP', 2, 10.15, 19, 8.76, 1.48, 45.96, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.g', 'CXP', 3, 1.58, 19, 1.64, 0.17, 12.88, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.g', 'CXP', 4, 53.92, 19, 16.30, 22.77, 82.29, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.b.1.g', 'CXP', 5, 34.35, 19, 13.82, 12.62, 65.47, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.1', 'CX', NULL, 1.83, 19, 0.28, 1.24, 2.42, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.1', 'CXP', 1, 46.67, 19, 17.48, 16.68, 79.28, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.1', 'CXP', 2, 25.21, 19, 12.53, 7.70, 57.67, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.1', 'CXP', 3, 26.92, 19, 12.46, 8.88, 58.22, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.1', 'CXP', 4, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.1', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.2', 'CX', NULL, 3.71, 19, 0.28, 3.13, 4.29, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.2', 'CXP', 1, 10.15, 19, 8.76, 1.48, 45.96, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.2', 'CXP', 2, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.2', 'CXP', 3, 10.15, 19, 8.74, 1.48, 45.85, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.2', 'CXP', 4, 68.07, 19, 13.76, 36.06, 88.96, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.c.2', 'CXP', 5, 11.63, 19, 6.40, 3.43, 32.76, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.1', 'CX', NULL, 2.94, 19, 0.32, 2.28, 3.61, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.1', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.1', 'CXP', 2, 44.35, 19, 17.96, 14.73, 78.62, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.1', 'CXP', 3, 21.21, 19, 10.52, 6.69, 50.27, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.1', 'CXP', 4, 30.20, 19, 13.33, 10.28, 62.03, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.1', 'CXP', 5, 4.24, 19, 3.48, 0.73, 21.13, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.2', 'CX', NULL, 2.73, 19, 0.26, 2.19, 3.27, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.2', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.2', 'CXP', 2, 53.88, 19, 16.23, 22.85, 82.17, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.2', 'CXP', 3, 20.80, 19, 12.00, 5.38, 54.81, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.2', 'CXP', 4, 24.11, 19, 11.17, 8.10, 53.39, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.2', 'CXP', 5, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.3', 'CX', NULL, 1.29, 19, 0.13, 1.01, 1.56, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.3', 'CXP', 1, 74.58, 19, 12.11, 43.40, 91.82, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.3', 'CXP', 2, 22.23, 19, 11.71, 6.45, 54.25, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.3', 'CXP', 3, 3.19, 19, 2.52, 0.59, 15.50, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.3', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.1.d.3', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.a', 'CX', NULL, 4.84, 19, 0.11, 4.61, 5.00, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.a', 'CXP', 1, 1.20, 19, 1.26, 0.13, 10.13, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.a', 'CXP', 2, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.a', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.a', 'CXP', 4, 1.98, 19, 2.08, 0.21, 16.01, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.a', 'CXP', 5, 93.81, 19, 4.14, 77.19, 98.55, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.b', 'CX', NULL, 1.83, 19, 0.39, 1.01, 2.65, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.b', 'CXP', 1, 56.38, 19, 16.12, 24.60, 83.66, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.b', 'CXP', 2, 23.33, 19, 11.74, 7.11, 54.71, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.b', 'CXP', 3, 10.15, 19, 8.74, 1.48, 45.85, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.b', 'CXP', 4, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.b', 'CXP', 5, 8.94, 19, 8.65, 1.04, 47.79, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.c', 'CX', NULL, 1.66, 19, 0.26, 1.12, 2.20, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.c', 'CXP', 1, 57.59, 19, 15.75, 25.94, 84.04, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.c', 'CXP', 2, 20.37, 19, 10.85, 5.90, 51.04, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.c', 'CXP', 3, 20.84, 19, 11.43, 5.78, 53.02, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.c', 'CXP', 4, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.c', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.d', 'CX', NULL, 1.57, 19, 0.23, 1.09, 2.06, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.d', 'CXP', 1, 61.82, 19, 14.88, 30.11, 85.89, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.d', 'CXP', 2, 20.37, 19, 10.85, 5.90, 51.04, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.d', 'CXP', 3, 16.60, 19, 9.81, 4.30, 46.87, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.d', 'CXP', 4, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.d', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.e', 'CX', NULL, 1.04, 19, 0.03, 1.00, 1.11, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.e', 'CXP', 1, 95.79, 19, 3.42, 79.28, 99.27, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.e', 'CXP', 2, 4.21, 19, 3.42, 0.73, 20.72, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.e', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.e', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.f', 'CX', NULL, 1.95, 19, 0.38, 1.16, 2.73, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.f', 'CXP', 1, 54.60, 19, 15.97, 23.71, 82.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.f', 'CXP', 2, 14.98, 19, 9.77, 3.40, 46.90, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.f', 'CXP', 3, 18.71, 19, 8.68, 6.48, 43.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.f', 'CXP', 4, 4.58, 19, 3.59, 0.85, 21.25, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.1.f', 'CXP', 5, 7.13, 19, 7.07, 0.81, 41.99, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.3', 'CX', NULL, 2.60, 19, 0.26, 2.04, 3.15, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.3', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.3', 'CXP', 2, 62.61, 19, 15.05, 30.27, 86.60, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.3', 'CXP', 3, 22.05, 19, 12.45, 5.82, 56.44, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.3', 'CXP', 4, 8.21, 19, 4.84, 2.27, 25.62, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.a.3', 'CXP', 5, 7.13, 19, 7.07, 0.81, 41.99, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.a', 'CX', NULL, 2.49, 19, 0.54, 1.34, 3.63, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.a', 'CXP', 1, 46.69, 19, 17.42, 16.76, 79.21, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.a', 'CXP', 2, 13.51, 19, 9.14, 2.93, 44.70, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.a', 'CXP', 3, 7.24, 19, 4.87, 1.67, 26.38, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.a', 'CXP', 4, 9.50, 19, 9.13, 1.11, 49.44, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.a', 'CXP', 5, 23.06, 19, 11.90, 6.82, 55.08, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.b', 'CX', NULL, 1.29, 19, 0.13, 1.02, 1.57, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.b', 'CXP', 1, 74.58, 19, 11.84, 44.15, 91.59, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.b', 'CXP', 2, 22.63, 19, 11.43, 6.91, 53.54, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.b', 'CXP', 3, 1.58, 19, 1.64, 0.17, 12.88, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.b', 'CXP', 4, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.b', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.c', 'CX', NULL, 1.39, 19, 0.29, 1.00, 2.00, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.c', 'CXP', 1, 83.48, 19, 9.05, 56.02, 95.25, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.c', 'CXP', 2, 8.19, 19, 5.37, 1.95, 28.55, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.c', 'CXP', 3, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.c', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.c', 'CXP', 5, 7.13, 19, 7.07, 0.81, 41.99, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.d', 'CX', NULL, 1.12, 19, 0.08, 1.00, 1.29, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.d', 'CXP', 1, 91.79, 19, 4.84, 74.38, 97.73, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.d', 'CXP', 2, 4.00, 19, 3.09, 0.76, 18.46, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.d', 'CXP', 3, 4.21, 19, 3.42, 0.73, 20.72, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.d', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.d', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.e', 'CX', NULL, 1.53, 19, 0.18, 1.16, 1.91, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.e', 'CXP', 1, 56.38, 19, 17.91, 21.86, 85.65, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.e', 'CXP', 2, 35.41, 19, 19.27, 8.54, 76.30, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.e', 'CXP', 3, 6.63, 19, 4.37, 1.59, 23.83, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.e', 'CXP', 4, 1.58, 19, 1.64, 0.17, 12.88, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.e', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.f', 'CX', NULL, 1.03, 19, 0.03, 1.00, 1.09, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.f', 'CXP', 1, 97.00, 19, 3.09, 77.69, 99.67, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.f', 'CXP', 2, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.f', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.a', 'CX', NULL, 1.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.a', 'CXP', 1, 100.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.a', 'CXP', 2, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.b', 'CX', NULL, 1.17, 19, 0.12, 1.00, 1.42, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.b', 'CXP', 1, 82.56, 19, 11.57, 46.66, 96.24, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.b', 'CXP', 2, 17.44, 19, 11.57, 3.76, 53.34, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.b', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.b', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.b', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.c', 'CX', NULL, 1.12, 19, 0.09, 1.00, 1.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.c', 'CXP', 1, 88.05, 19, 9.18, 54.11, 97.88, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.c', 'CXP', 2, 11.95, 19, 9.18, 2.12, 45.89, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.c', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.d', 'CX', NULL, 1.03, 19, 0.03, 1.00, 1.09, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.d', 'CXP', 1, 97.00, 19, 3.09, 77.69, 99.67, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.d', 'CXP', 2, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.d', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.d', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.d', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.e', 'CX', NULL, 1.11, 19, 0.09, 1.00, 1.29, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.e', 'CXP', 1, 89.48, 19, 8.82, 54.29, 98.38, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.e', 'CXP', 2, 10.52, 19, 8.82, 1.62, 45.71, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.e', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.e', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.e', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.f', 'CX', NULL, 1.31, 19, 0.20, 1.00, 1.72, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.f', 'CXP', 1, 69.33, 19, 19.57, 24.63, 93.99, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.f', 'CXP', 2, 30.67, 19, 19.57, 6.01, 75.37, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.f', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.f', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.c.1.f', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.a', 'CX', NULL, 4.24, 19, 0.17, 3.89, 4.59, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.a', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.a', 'CXP', 2, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.a', 'CXP', 3, 9.53, 19, 7.38, 1.71, 38.90, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.a', 'CXP', 4, 56.87, 19, 16.09, 24.94, 83.95, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.a', 'CXP', 5, 33.60, 19, 14.71, 11.24, 66.91, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.b', 'CX', NULL, 1.99, 19, 0.12, 1.74, 2.24, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.b', 'CXP', 1, 10.70, 19, 9.23, 1.55, 47.69, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.b', 'CXP', 2, 79.77, 19, 11.62, 46.50, 94.70, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.b', 'CXP', 3, 9.53, 19, 7.38, 1.71, 38.90, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.b', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.b', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.c', 'CX', NULL, 1.06, 19, 0.04, 1.00, 1.14, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.c', 'CXP', 1, 94.22, 19, 3.93, 78.20, 98.67, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.c', 'CXP', 2, 5.78, 19, 3.93, 1.33, 21.80, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.d', 'CX', NULL, 2.30, 19, 0.22, 1.84, 2.76, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.d', 'CXP', 1, 9.62, 19, 5.90, 2.50, 30.69, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.d', 'CXP', 2, 53.78, 19, 17.52, 20.92, 83.66, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.d', 'CXP', 3, 33.59, 19, 19.46, 7.48, 75.97, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.d', 'CXP', 4, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.e', 'CX', NULL, 1.41, 19, 0.19, 1.02, 1.80, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.e', 'CXP', 1, 62.32, 19, 18.51, 24.00, 89.65, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.e', 'CXP', 2, 34.67, 19, 18.94, 8.39, 75.46, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.e', 'CXP', 3, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.f', 'CX', NULL, 1.32, 19, 0.29, 1.00, 1.91, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.f', 'CXP', 1, 89.87, 19, 7.77, 59.60, 98.16, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.f', 'CXP', 2, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.f', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.f', 'CXP', 5, 7.13, 19, 7.07, 0.81, 41.99, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.g', 'CX', NULL, 2.94, 19, 0.47, 1.95, 3.94, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.g', 'CXP', 1, 32.60, 19, 14.00, 11.26, 64.84, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.g', 'CXP', 2, 11.73, 19, 8.93, 2.12, 44.84, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.g', 'CXP', 3, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.g', 'CXP', 4, 34.17, 19, 19.09, 8.03, 75.53, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.g', 'CXP', 5, 18.50, 19, 11.27, 4.50, 52.20, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.h', 'CX', NULL, 1.37, 19, 0.19, 1.00, 1.77, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.h', 'CXP', 1, 65.33, 19, 18.94, 24.54, 91.61, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.h', 'CXP', 2, 33.47, 19, 19.13, 7.65, 75.35, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.h', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.h', 'CXP', 4, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.i', 'CX', NULL, 2.61, 19, 0.49, 1.57, 3.64, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.i', 'CXP', 1, 41.32, 19, 15.97, 15.01, 73.75, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.i', 'CXP', 2, 7.74, 19, 5.23, 1.77, 28.11, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.i', 'CXP', 3, 1.20, 19, 1.24, 0.14, 9.87, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.i', 'CXP', 4, 48.53, 19, 17.25, 18.10, 80.09, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.d.1.i', 'CXP', 5, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.d', 'CX', NULL, 1.14, 19, 0.10, 1.00, 1.34, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.d', 'CXP', 1, 90.03, 19, 6.00, 68.93, 97.35, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.d', 'CXP', 2, 5.78, 19, 3.93, 1.33, 21.80, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.d', 'CXP', 3, 4.18, 19, 4.25, 0.47, 28.79, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.d', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.d', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.e', 'CX', NULL, 1.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.e', 'CXP', 1, 100.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.e', 'CXP', 2, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.e', 'CXP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.1', 'CX', NULL, 2.06, 19, 0.24, 1.56, 2.55, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.1', 'CXP', 1, 34.30, 19, 14.82, 11.60, 67.52, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.1', 'CXP', 2, 35.40, 19, 18.82, 8.86, 75.54, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.1', 'CXP', 3, 23.69, 19, 12.02, 7.13, 55.66, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.1', 'CXP', 4, 3.61, 19, 3.72, 0.40, 26.10, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.1', 'CXP', 5, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.a', 'CX', NULL, 4.14, 19, 0.24, 3.63, 4.65, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.a', 'CXP', 1, 1.20, 19, 1.26, 0.13, 10.13, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.a', 'CXP', 2, 8.94, 19, 8.65, 1.04, 47.79, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.a', 'CXP', 3, 2.90, 19, 2.98, 0.32, 21.68, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.a', 'CXP', 4, 48.51, 19, 17.23, 18.12, 80.05, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.a', 'CXP', 5, 38.44, 19, 15.04, 14.11, 70.36, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.b', 'CX', NULL, 4.07, 19, 0.35, 3.34, 4.80, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.b', 'CXP', 1, 1.20, 19, 1.26, 0.13, 10.13, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.b', 'CXP', 2, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.b', 'CXP', 3, 40.73, 19, 18.39, 12.18, 77.30, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.b', 'CXP', 4, 6.96, 19, 4.88, 1.52, 26.69, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.2.b', 'CXP', 5, 51.10, 19, 17.08, 19.92, 81.46, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.4', 'CX', NULL, 4.15, 19, 0.30, 3.52, 4.77, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.4', 'CXP', 1, 3.00, 19, 3.09, 0.33, 22.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.4', 'CXP', 2, 1.20, 19, 1.26, 0.13, 10.13, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.4', 'CXP', 3, 22.06, 19, 11.28, 6.66, 52.91, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.4', 'CXP', 4, 25.44, 19, 12.42, 7.94, 57.46, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.a.4', 'CXP', 5, 48.29, 19, 17.25, 17.95, 79.95, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.2', 'CX', NULL, 2.56, 18, 0.19, 2.17, 2.96, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.2', 'CXP', 1, 8.67, 18, 5.83, 1.97, 30.97, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.2', 'CXP', 2, 30.70, 18, 13.95, 10.00, 63.86, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.2', 'CXP', 3, 56.11, 18, 16.33, 23.99, 83.81, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.2', 'CXP', 4, 4.52, 18, 3.04, 1.06, 17.33, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.2', 'CXP', 5, 0.00, 18, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.4', 'CX', NULL, 3.98, 19, 0.41, 3.11, 4.85, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.4', 'CXP', 1, 8.49, 19, 8.26, 0.99, 46.37, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.4', 'CXP', 2, 4.10, 19, 3.32, 0.72, 20.12, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.4', 'CXP', 3, 19.64, 19, 12.16, 4.62, 55.22, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.4', 'CXP', 4, 16.35, 19, 8.83, 4.79, 43.16, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.4', 'CXP', 5, 51.41, 19, 16.78, 20.50, 81.27, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.7', 'CX', NULL, 3.12, 19, 0.38, 2.31, 3.92, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.7', 'CXP', 1, 23.42, 19, 11.36, 7.48, 53.65, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.7', 'CXP', 2, 6.56, 19, 4.32, 1.57, 23.58, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.7', 'CXP', 3, 14.36, 19, 9.44, 3.23, 45.67, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.7', 'CXP', 4, 46.11, 19, 17.61, 16.18, 79.13, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.7', 'CXP', 5, 9.55, 19, 7.56, 1.65, 39.92, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.8', 'CX', NULL, 4.41, 19, 0.20, 4.00, 4.83, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.8', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.8', 'CXP', 2, 4.21, 19, 3.39, 0.74, 20.48, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.8', 'CXP', 3, 8.93, 19, 5.68, 2.21, 29.86, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.8', 'CXP', 4, 28.04, 19, 19.97, 4.65, 75.71, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.b.8', 'CXP', 5, 58.82, 19, 18.12, 22.88, 87.30, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.c.1', 'CX', NULL, 3.12, 19, 0.26, 2.58, 3.66, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.c.1', 'CXP', 1, 10.15, 19, 8.76, 1.48, 45.96, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.c.1', 'CXP', 2, 10.70, 19, 9.21, 1.56, 47.58, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.c.1', 'CXP', 3, 45.02, 19, 17.71, 15.41, 78.64, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.c.1', 'CXP', 4, 25.69, 19, 12.14, 8.33, 56.80, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.c.1', 'CXP', 5, 8.45, 19, 5.11, 2.25, 27.00, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.1', 'CX', NULL, 4.67, 19, 0.15, 4.36, 4.97, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.1', 'CXP', 1, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.1', 'CXP', 2, 1.20, 19, 1.26, 0.13, 10.13, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.1', 'CXP', 3, 2.43, 19, 2.51, 0.27, 18.74, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.1', 'CXP', 4, 24.97, 19, 12.84, 7.31, 58.40, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.1', 'CXP', 5, 71.40, 19, 13.30, 38.85, 90.75, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.3', 'CX', NULL, 1.93, 19, 0.41, 1.07, 2.78, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.3', 'CXP', 1, 60.63, 19, 18.55, 23.12, 88.74, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.3', 'CXP', 2, 1.58, 19, 1.64, 0.17, 12.88, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.3', 'CXP', 3, 29.47, 19, 19.77, 5.36, 75.51, 'Y', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.3', 'CXP', 4, 1.20, 19, 1.26, 0.13, 10.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.3', 'CXP', 5, 7.13, 19, 7.07, 0.81, 41.99, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.4', 'CT', NULL, 1.04, 19, 0.03, 1.00, 1.09, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.4', 'CTP', 1, 96.02, 19, 2.59, 85.32, 99.01, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.4', 'CTP', 2, 3.98, 19, 2.59, 0.99, 14.68, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.4', 'CTP', 3, 0.00, 19, 0.00, NULL, NULL, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.8', 'CT', NULL, 2.51, 18, 0.14, 2.20, 2.81, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.8', 'CTP', 1, 1.64, 18, 1.65, 0.19, 12.64, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.8', 'CTP', 2, 46.12, 18, 14.67, 19.76, 74.83, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.C.3.d.8', 'CTP', 3, 52.25, 18, 14.47, 24.35, 78.81, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.c', 'CX', NULL, 3.35, 40, 0.17, 3.00, 3.70, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.c', 'CXP', 1, 3.00, 40, 2.42, 0.57, 14.24, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.c', 'CXP', 2, 15.19, 40, 5.91, 6.61, 31.19, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.c', 'CXP', 3, 26.90, 40, 9.66, 11.99, 49.84, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.c', 'CXP', 4, 53.83, 40, 11.94, 30.61, 75.50, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.c', 'CXP', 5, 1.08, 40, 0.83, 0.22, 5.02, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.f', 'CX', NULL, 4.92, 40, 0.07, 4.78, 5.00, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.f', 'CXP', 4, 8.10, 40, 7.06, 1.28, 37.49, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.f', 'CXP', 5, 91.90, 40, 7.06, 62.51, 98.72, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.h', 'CX', NULL, 5.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.h', 'CXP', 4, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.h', 'CXP', 5, 100.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.j', 'CX', NULL, 3.52, 40, 0.21, 3.10, 3.93, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.j', 'CXP', 1, 1.59, 40, 1.59, 0.21, 11.23, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.j', 'CXP', 2, 17.57, 40, 8.07, 6.46, 39.70, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.j', 'CXP', 3, 24.05, 40, 12.97, 7.00, 57.11, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.j', 'CXP', 4, 41.09, 40, 12.10, 20.24, 65.72, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.j', 'CXP', 5, 15.70, 40, 7.78, 5.37, 37.95, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.l', 'CX', NULL, 4.76, 39, 0.13, 4.49, 5.00, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 39, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 39, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.l', 'CXP', 3, 3.08, 39, 2.48, 0.59, 14.58, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.l', 'CXP', 4, 17.72, 39, 13.30, 3.29, 57.71, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.2.l', 'CXP', 5, 79.20, 39, 13.15, 43.08, 95.04, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.4', 'CX', NULL, 4.61, 40, 0.16, 4.28, 4.93, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.4', 'CXP', 1, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.4', 'CXP', 2, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.4', 'CXP', 3, 7.93, 40, 6.94, 1.25, 37.06, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.4', 'CXP', 4, 23.43, 40, 10.51, 8.55, 50.03, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.a.4', 'CXP', 5, 68.64, 40, 11.66, 42.26, 86.74, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.e', 'CX', NULL, 4.67, 40, 0.12, 4.44, 4.91, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.e', 'CXP', 2, 1.10, 40, 1.13, 0.14, 8.26, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.e', 'CXP', 3, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.e', 'CXP', 4, 29.35, 40, 11.04, 12.40, 54.95, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.e', 'CXP', 5, 69.55, 40, 11.09, 44.20, 86.82, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.f', 'CX', NULL, 4.25, 40, 0.19, 3.87, 4.63, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.f', 'CXP', 1, 3.01, 40, 2.43, 0.58, 14.28, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.f', 'CXP', 2, 4.67, 40, 3.36, 1.05, 18.40, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.f', 'CXP', 3, 5.69, 40, 3.02, 1.90, 15.84, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.f', 'CXP', 4, 37.25, 40, 11.84, 17.56, 62.32, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.f', 'CXP', 5, 49.38, 40, 12.50, 26.19, 72.84, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.g', 'CX', NULL, 4.32, 40, 0.21, 3.90, 4.73, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.g', 'CXP', 1, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.g', 'CXP', 2, 1.10, 40, 1.13, 0.14, 8.26, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.g', 'CXP', 3, 16.89, 40, 10.26, 4.43, 47.13, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.g', 'CXP', 4, 31.05, 40, 10.27, 14.58, 54.30, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.b.1.g', 'CXP', 5, 50.95, 40, 12.51, 27.41, 74.08, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.1', 'CX', NULL, 2.21, 40, 0.27, 1.66, 2.75, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.1', 'CXP', 1, 29.21, 40, 12.79, 10.56, 59.05, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.1', 'CXP', 2, 39.07, 40, 11.88, 18.94, 63.76, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.1', 'CXP', 3, 13.61, 40, 7.45, 4.19, 36.20, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.1', 'CXP', 4, 18.12, 40, 8.85, 6.21, 42.50, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.1', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.2', 'CX', NULL, 4.04, 40, 0.19, 3.66, 4.42, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.2', 'CXP', 1, 2.25, 40, 2.27, 0.28, 15.69, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.2', 'CXP', 2, 0.82, 40, 0.84, 0.10, 6.23, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.2', 'CXP', 3, 20.31, 40, 10.55, 6.38, 48.79, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.2', 'CXP', 4, 44.06, 40, 12.59, 21.89, 68.87, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.c.2', 'CXP', 5, 32.57, 40, 11.04, 14.87, 57.18, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.1', 'CX', NULL, 3.18, 40, 0.32, 2.54, 3.82, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.1', 'CXP', 1, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.1', 'CXP', 2, 34.34, 40, 10.76, 16.61, 57.85, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.1', 'CXP', 3, 29.67, 40, 11.60, 12.05, 56.50, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.1', 'CXP', 4, 19.37, 40, 8.06, 7.80, 40.55, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.1', 'CXP', 5, 16.63, 40, 12.99, 2.91, 57.03, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.2', 'CX', NULL, 2.74, 40, 0.11, 2.51, 2.97, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.2', 'CXP', 1, 2.24, 40, 2.26, 0.28, 15.59, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.2', 'CXP', 2, 29.20, 40, 10.15, 13.25, 52.68, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.2', 'CXP', 3, 60.96, 40, 11.13, 37.75, 80.08, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.2', 'CXP', 4, 7.60, 40, 3.56, 2.87, 18.64, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.2', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.3', 'CX', NULL, 1.16, 40, 0.08, 1.00, 1.32, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.3', 'CXP', 1, 84.24, 40, 7.83, 61.86, 94.63, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.3', 'CXP', 2, 15.76, 40, 7.83, 5.37, 38.14, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.3', 'CXP', 3, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.3', 'CXP', 4, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.1.d.3', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.a', 'CX', NULL, 4.53, 40, 0.24, 4.05, 5.00, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.a', 'CXP', 1, 2.24, 40, 2.26, 0.28, 15.65, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.a', 'CXP', 2, 10.35, 40, 7.27, 2.31, 36.01, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.a', 'CXP', 3, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.a', 'CXP', 4, 7.30, 40, 5.42, 1.53, 28.46, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.a', 'CXP', 5, 80.11, 40, 9.04, 56.10, 92.70, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.b', 'CX', NULL, 1.86, 40, 0.21, 1.43, 2.29, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.b', 'CXP', 1, 47.14, 40, 12.65, 24.21, 71.34, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.b', 'CXP', 2, 35.12, 40, 12.32, 15.35, 61.78, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.b', 'CXP', 3, 2.60, 40, 1.46, 0.83, 7.89, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.b', 'CXP', 4, 15.14, 40, 6.66, 5.88, 33.75, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.b', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.c', 'CX', NULL, 1.38, 39, 0.12, 1.14, 1.62, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.c', 'CXP', 1, 67.86, 39, 10.55, 44.24, 84.89, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.c', 'CXP', 2, 27.66, 39, 10.12, 12.07, 51.57, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.c', 'CXP', 3, 3.26, 39, 2.32, 0.76, 12.98, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.c', 'CXP', 4, 1.22, 39, 1.09, 0.20, 7.18, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.c', 'CXP', 5, 0.00, 39, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.d', 'CX', NULL, 1.25, 39, 0.09, 1.06, 1.44, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.d', 'CXP', 1, 75.18, 39, 9.31, 52.45, 89.27, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.d', 'CXP', 2, 24.65, 39, 9.30, 10.61, 47.40, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.d', 'CXP', 3, 0.18, 39, 0.18, 0.02, 1.41, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.d', 'CXP', 4, 0.00, 39, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.d', 'CXP', 5, 0.00, 39, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.e', 'CX', NULL, 1.08, 39, 0.06, 1.00, 1.20, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.e', 'CXP', 1, 97.08, 39, 2.22, 87.20, 99.39, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.e', 'CXP', 2, 0.00, 39, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.e', 'CXP', 3, 1.04, 39, 1.07, 0.13, 7.88, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.e', 'CXP', 4, 1.88, 39, 1.91, 0.24, 13.45, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 39, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.f', 'CX', NULL, 2.26, 39, 0.35, 1.55, 2.98, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.f', 'CXP', 1, 44.63, 39, 12.91, 21.88, 69.89, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.f', 'CXP', 2, 13.89, 39, 7.84, 4.11, 37.80, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.f', 'CXP', 3, 17.14, 39, 8.06, 6.15, 39.50, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.f', 'CXP', 4, 19.06, 39, 10.78, 5.41, 49.22, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.1.f', 'CXP', 5, 5.28, 39, 5.06, 0.71, 30.16, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.3', 'CX', NULL, 2.89, 39, 0.17, 2.54, 3.24, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.3', 'CXP', 1, 0.00, 39, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.3', 'CXP', 2, 34.63, 39, 10.52, 17.14, 57.57, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.3', 'CXP', 3, 44.67, 39, 13.09, 21.64, 70.23, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.3', 'CXP', 4, 18.05, 39, 11.04, 4.63, 49.95, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.a.3', 'CXP', 5, 2.66, 39, 2.10, 0.53, 12.34, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.a', 'CX', NULL, 2.40, 39, 0.27, 1.85, 2.95, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.a', 'CXP', 1, 33.63, 39, 12.55, 13.97, 61.27, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.a', 'CXP', 2, 15.43, 39, 5.88, 6.83, 31.24, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.a', 'CXP', 3, 33.12, 39, 13.47, 12.64, 62.90, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.a', 'CXP', 4, 12.85, 39, 5.38, 5.28, 28.04, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.a', 'CXP', 5, 4.97, 39, 2.78, 1.57, 14.67, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.b', 'CX', NULL, 1.50, 39, 0.19, 1.12, 1.88, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.b', 'CXP', 1, 66.03, 39, 10.72, 42.48, 83.64, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.b', 'CXP', 2, 23.11, 39, 8.94, 9.79, 45.43, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.b', 'CXP', 3, 5.53, 39, 3.79, 1.33, 20.28, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.b', 'CXP', 4, 5.34, 39, 5.06, 0.74, 29.99, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.b', 'CXP', 5, 0.00, 39, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.c', 'CX', NULL, 1.34, 39, 0.13, 1.08, 1.61, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.c', 'CXP', 1, 74.47, 39, 9.71, 50.93, 89.13, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.c', 'CXP', 2, 19.95, 39, 9.03, 7.34, 43.92, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.c', 'CXP', 3, 2.38, 39, 2.29, 0.33, 15.20, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.c', 'CXP', 4, 3.20, 39, 2.64, 0.59, 15.62, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.c', 'CXP', 5, 0.00, 39, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.d', 'CX', NULL, 1.54, 40, 0.17, 1.19, 1.89, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.d', 'CXP', 1, 68.31, 40, 9.94, 45.98, 84.52, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.d', 'CXP', 2, 20.23, 40, 8.58, 7.96, 42.65, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.d', 'CXP', 3, 5.71, 40, 3.22, 1.77, 16.89, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.d', 'CXP', 4, 0.94, 40, 0.96, 0.12, 7.10, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.d', 'CXP', 5, 4.81, 40, 3.07, 1.28, 16.42, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.e', 'CX', NULL, 1.20, 40, 0.11, 1.00, 1.43, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.e', 'CXP', 1, 88.53, 40, 6.34, 68.60, 96.46, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.e', 'CXP', 2, 3.30, 40, 3.11, 0.47, 19.69, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.e', 'CXP', 3, 8.18, 40, 5.55, 1.96, 28.43, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.e', 'CXP', 4, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.e', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.f', 'CX', NULL, 1.02, 40, 0.02, 1.00, 1.06, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.f', 'CXP', 1, 98.98, 40, 1.04, 92.32, 99.87, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.f', 'CXP', 2, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.f', 'CXP', 3, 1.02, 40, 1.04, 0.13, 7.68, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.a', 'CX', NULL, 1.33, 40, 0.26, 1.00, 1.86, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.a', 'CXP', 1, 84.20, 40, 13.05, 42.29, 97.48, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.a', 'CXP', 2, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.a', 'CXP', 3, 15.04, 40, 13.11, 2.17, 58.51, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.a', 'CXP', 5, 0.76, 40, 0.78, 0.10, 5.81, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.b', 'CX', NULL, 1.07, 40, 0.04, 1.00, 1.15, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.b', 'CXP', 1, 96.41, 40, 2.26, 87.74, 99.02, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.b', 'CXP', 2, 1.75, 40, 1.77, 0.22, 12.56, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.b', 'CXP', 3, 0.71, 40, 0.72, 0.09, 5.43, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.b', 'CXP', 4, 1.13, 40, 1.15, 0.14, 8.44, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.b', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.c', 'CX', NULL, 1.08, 40, 0.05, 1.00, 1.17, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.c', 'CXP', 1, 94.14, 40, 3.32, 82.60, 98.20, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.c', 'CXP', 2, 4.02, 40, 2.67, 1.02, 14.52, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.c', 'CXP', 3, 1.84, 40, 1.86, 0.23, 13.15, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.d', 'CX', NULL, 1.06, 40, 0.03, 1.00, 1.11, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.d', 'CXP', 1, 95.52, 40, 2.34, 87.58, 98.47, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.d', 'CXP', 2, 3.42, 40, 2.05, 1.00, 11.04, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.d', 'CXP', 3, 1.05, 40, 0.97, 0.16, 6.56, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.d', 'CXP', 4, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.d', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.e', 'CX', NULL, 1.46, 40, 0.25, 1.00, 1.97, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.e', 'CXP', 1, 76.60, 40, 12.69, 43.89, 93.20, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.e', 'CXP', 2, 3.69, 40, 2.73, 0.80, 15.38, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.e', 'CXP', 3, 16.93, 40, 12.97, 3.06, 56.82, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.e', 'CXP', 4, 2.77, 40, 2.10, 0.59, 12.13, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.e', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.f', 'CX', NULL, 1.09, 38, 0.04, 1.00, 1.18, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.f', 'CXP', 1, 91.20, 38, 4.38, 77.41, 96.91, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.f', 'CXP', 2, 8.80, 38, 4.38, 3.09, 22.59, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.f', 'CXP', 3, 0.00, 38, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.f', 'CXP', 4, 0.00, 38, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.c.1.f', 'CXP', 5, 0.00, 38, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.a', 'CX', NULL, 4.36, 38, 0.19, 3.97, 4.75, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.a', 'CXP', 1, 0.00, 38, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.a', 'CXP', 2, 5.12, 38, 5.02, 0.66, 30.45, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.a', 'CXP', 3, 6.21, 38, 3.67, 1.82, 19.16, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.a', 'CXP', 4, 36.27, 38, 11.63, 17.03, 61.21, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.a', 'CXP', 5, 52.40, 38, 12.54, 28.44, 75.30, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.b', 'CX', NULL, 2.09, 38, 0.13, 1.82, 2.36, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.b', 'CXP', 1, 10.33, 38, 5.16, 3.59, 26.28, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.b', 'CXP', 2, 75.62, 38, 9.57, 52.01, 89.87, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.b', 'CXP', 3, 8.93, 38, 7.15, 1.62, 36.80, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.b', 'CXP', 4, 5.12, 38, 5.02, 0.66, 30.45, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.b', 'CXP', 5, 0.00, 38, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.c', 'CX', NULL, 1.02, 37, 0.02, 1.00, 1.06, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.c', 'CXP', 1, 97.65, 37, 1.66, 90.53, 99.45, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.c', 'CXP', 2, 2.35, 37, 1.66, 0.55, 9.47, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 37, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 37, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 37, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.d', 'CX', NULL, 1.95, 38, 0.12, 1.70, 2.20, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.d', 'CXP', 1, 17.36, 38, 6.87, 7.37, 35.66, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.d', 'CXP', 2, 76.31, 38, 8.56, 55.23, 89.37, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.d', 'CXP', 3, 0.00, 38, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.d', 'CXP', 4, 6.33, 38, 5.14, 1.15, 28.14, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 38, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.e', 'CX', NULL, 1.26, 38, 0.13, 1.00, 1.53, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.e', 'CXP', 1, 73.77, 38, 13.06, 41.74, 91.70, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.e', 'CXP', 2, 26.23, 38, 13.06, 8.30, 58.26, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.e', 'CXP', 3, 0.00, 38, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 38, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 38, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.f', 'CX', NULL, 1.19, 38, 0.13, 1.00, 1.45, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.f', 'CXP', 1, 81.41, 38, 13.11, 43.09, 96.20, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.f', 'CXP', 2, 18.59, 38, 13.11, 3.80, 56.91, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.f', 'CXP', 3, 0.00, 38, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 38, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.f', 'CXP', 5, 0.00, 38, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.g', 'CX', NULL, 2.31, 38, 0.47, 1.36, 3.25, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.g', 'CXP', 1, 47.24, 38, 12.37, 24.66, 71.00, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.g', 'CXP', 2, 25.19, 38, 11.26, 9.12, 53.05, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.g', 'CXP', 3, 1.03, 38, 1.06, 0.13, 7.84, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.g', 'CXP', 4, 2.90, 38, 2.15, 0.63, 12.29, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.g', 'CXP', 5, 23.64, 38, 12.88, 6.80, 56.79, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.h', 'CX', NULL, 1.22, 40, 0.08, 1.06, 1.38, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.h', 'CXP', 1, 78.75, 40, 7.74, 59.25, 90.43, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.h', 'CXP', 2, 20.49, 40, 7.65, 9.07, 39.97, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.h', 'CXP', 3, 0.76, 40, 0.78, 0.10, 5.81, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.h', 'CXP', 4, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.i', 'CX', NULL, 2.73, 39, 0.44, 1.84, 3.62, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.i', 'CXP', 1, 28.12, 39, 11.17, 11.34, 54.49, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.i', 'CXP', 2, 25.25, 39, 9.67, 10.69, 48.80, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.i', 'CXP', 3, 11.13, 39, 7.45, 2.65, 36.53, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.i', 'CXP', 4, 16.51, 39, 8.20, 5.60, 39.72, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.d.1.i', 'CXP', 5, 18.99, 39, 13.21, 3.96, 57.14, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.d', 'CX', NULL, 1.30, 40, 0.12, 1.07, 1.54, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.d', 'CXP', 1, 79.03, 40, 8.35, 57.64, 91.26, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.d', 'CXP', 2, 15.33, 40, 7.69, 5.18, 37.50, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.d', 'CXP', 3, 1.81, 40, 1.28, 0.43, 7.29, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.d', 'CXP', 4, 3.82, 40, 2.59, 0.94, 14.22, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.d', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.e', 'CX', NULL, 1.04, 40, 0.03, 1.00, 1.09, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.e', 'CXP', 1, 96.92, 40, 2.42, 85.93, 99.39, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.e', 'CXP', 2, 2.37, 40, 2.28, 0.33, 15.14, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.e', 'CXP', 3, 0.71, 40, 0.72, 0.09, 5.43, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.1', 'CX', NULL, 2.76, 40, 0.33, 2.10, 3.42, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.1', 'CXP', 1, 25.36, 40, 9.02, 11.47, 47.10, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.1', 'CXP', 2, 22.74, 40, 10.58, 8.01, 49.87, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.1', 'CXP', 3, 11.13, 40, 7.30, 2.74, 35.78, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.1', 'CXP', 4, 31.98, 40, 12.76, 12.56, 60.63, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.1', 'CXP', 5, 8.79, 40, 7.15, 1.56, 36.91, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.a', 'CX', NULL, 4.15, 40, 0.21, 3.71, 4.58, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.a', 'CXP', 2, 5.08, 40, 3.26, 1.35, 17.36, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.a', 'CXP', 3, 16.04, 40, 10.27, 3.93, 47.17, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.a', 'CXP', 4, 38.06, 40, 11.18, 19.06, 61.58, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.a', 'CXP', 5, 40.82, 40, 12.73, 19.19, 66.71, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.b', 'CX', NULL, 4.10, 40, 0.23, 3.63, 4.58, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.b', 'CXP', 1, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.b', 'CXP', 2, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.b', 'CXP', 3, 31.58, 40, 12.19, 12.85, 59.10, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.b', 'CXP', 4, 26.59, 40, 8.33, 13.25, 46.21, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.2.b', 'CXP', 5, 41.83, 40, 12.64, 20.09, 67.28, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.4', 'CX', NULL, 4.42, 40, 0.13, 4.16, 4.69, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.4', 'CXP', 1, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.4', 'CXP', 2, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.4', 'CXP', 3, 4.15, 40, 3.47, 0.74, 20.18, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.4', 'CXP', 4, 49.32, 40, 12.55, 26.07, 72.87, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.a.4', 'CXP', 5, 46.53, 40, 12.26, 24.31, 70.22, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.2', 'CX', NULL, 2.10, 40, 0.18, 1.74, 2.46, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.2', 'CXP', 1, 27.91, 40, 9.46, 13.02, 50.05, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.2', 'CXP', 2, 34.42, 40, 12.66, 14.44, 62.02, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.2', 'CXP', 3, 37.33, 40, 12.14, 17.26, 62.97, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.2', 'CXP', 4, 0.34, 40, 0.35, 0.04, 2.68, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.2', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.4', 'CX', NULL, 3.81, 40, 0.14, 3.53, 4.10, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.4', 'CXP', 1, 2.06, 40, 2.08, 0.26, 14.50, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.4', 'CXP', 2, 5.54, 40, 3.42, 1.54, 18.01, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.4', 'CXP', 3, 18.58, 40, 8.21, 7.08, 40.60, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.4', 'CXP', 4, 56.90, 40, 11.52, 33.80, 77.34, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.4', 'CXP', 5, 16.93, 40, 6.84, 7.08, 35.28, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.7', 'CX', NULL, 2.78, 40, 0.41, 1.94, 3.62, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.7', 'CXP', 1, 28.48, 40, 10.82, 11.97, 53.85, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.7', 'CXP', 2, 14.64, 40, 6.67, 5.50, 33.56, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.7', 'CXP', 3, 26.86, 40, 10.87, 10.71, 52.92, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.7', 'CXP', 4, 10.41, 40, 4.33, 4.34, 22.92, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.7', 'CXP', 5, 19.61, 40, 12.92, 4.44, 56.14, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.8', 'CX', NULL, 4.63, 40, 0.13, 4.37, 4.89, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.8', 'CXP', 1, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.8', 'CXP', 2, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.8', 'CXP', 3, 0.82, 40, 0.84, 0.10, 6.23, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.8', 'CXP', 4, 35.55, 40, 12.97, 14.93, 63.42, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.b.8', 'CXP', 5, 63.64, 40, 12.93, 36.11, 84.42, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.c.1', 'CX', NULL, 3.95, 40, 0.28, 3.38, 4.52, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.c.1', 'CXP', 1, 2.24, 40, 2.26, 0.28, 15.59, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.c.1', 'CXP', 2, 12.33, 40, 7.71, 3.22, 37.30, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.c.1', 'CXP', 3, 17.81, 40, 6.62, 7.99, 35.09, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.c.1', 'CXP', 4, 23.47, 40, 8.58, 10.45, 44.62, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.c.1', 'CXP', 5, 44.15, 40, 12.99, 21.41, 69.65, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.1', 'CX', NULL, 4.21, 40, 0.15, 3.90, 4.52, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.1', 'CXP', 1, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.1', 'CXP', 2, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.1', 'CXP', 3, 11.97, 40, 5.25, 4.72, 27.16, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.1', 'CXP', 4, 55.16, 40, 12.53, 30.62, 77.42, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.1', 'CXP', 5, 32.87, 40, 12.97, 12.99, 61.65, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.3', 'CX', NULL, 1.02, 40, 0.02, 1.00, 1.07, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.3', 'CXP', 1, 97.58, 40, 2.45, 83.25, 99.69, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.3', 'CXP', 2, 2.42, 40, 2.45, 0.31, 16.75, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.3', 'CXP', 3, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.3', 'CXP', 4, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.3', 'CXP', 5, 0.00, 40, 0.00, NULL, NULL, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.4', 'CT', NULL, 1.26, 40, 0.13, 1.00, 1.53, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.4', 'CTP', 1, 74.76, 40, 12.94, 42.53, 92.22, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.4', 'CTP', 2, 24.18, 40, 13.00, 7.06, 57.25, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.4', 'CTP', 3, 1.06, 40, 1.08, 0.13, 7.92, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.8', 'CT', NULL, 2.78, 40, 0.09, 2.60, 2.97, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.8', 'CTP', 1, 2.24, 40, 2.26, 0.28, 15.59, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.8', 'CTP', 2, 17.17, 40, 8.15, 6.11, 39.79, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.C.3.d.8', 'CTP', 3, 80.58, 40, 8.45, 58.20, 92.52, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.c', 'CX', NULL, 3.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.c', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.c', 'CXP', 2, 34.78, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.c', 'CXP', 3, 43.48, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.c', 'CXP', 4, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.c', 'CXP', 5, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.f', 'CX', NULL, 5.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.f', 'CXP', 4, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.f', 'CXP', 5, 100.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.h', 'CX', NULL, 5.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.h', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.h', 'CXP', 5, 100.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.j', 'CX', NULL, 4.22, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.j', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.j', 'CXP', 2, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.j', 'CXP', 3, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.j', 'CXP', 4, 47.83, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.j', 'CXP', 5, 39.13, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.l', 'CX', NULL, 4.32, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.l', 'CXP', 2, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.l', 'CXP', 3, 18.18, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.l', 'CXP', 4, 18.18, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.2.l', 'CXP', 5, 59.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.4', 'CX', NULL, 4.83, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.4', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.4', 'CXP', 2, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.4', 'CXP', 3, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.4', 'CXP', 4, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.a.4', 'CXP', 5, 86.96, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.e', 'CX', NULL, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.e', 'CXP', 2, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.e', 'CXP', 3, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.e', 'CXP', 4, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.e', 'CXP', 5, 52.17, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.f', 'CX', NULL, 4.26, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.f', 'CXP', 1, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.f', 'CXP', 2, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.f', 'CXP', 3, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.f', 'CXP', 4, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.f', 'CXP', 5, 65.22, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.g', 'CX', NULL, 3.87, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.g', 'CXP', 1, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.g', 'CXP', 2, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.g', 'CXP', 3, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.g', 'CXP', 4, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.b.1.g', 'CXP', 5, 39.13, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.1', 'CX', NULL, 2.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.1', 'CXP', 1, 39.13, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.1', 'CXP', 2, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.1', 'CXP', 3, 34.78, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.1', 'CXP', 4, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.1', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.2', 'CX', NULL, 3.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.2', 'CXP', 1, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.2', 'CXP', 2, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.2', 'CXP', 3, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.2', 'CXP', 4, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.c.2', 'CXP', 5, 43.48, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.1', 'CX', NULL, 3.22, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.1', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.1', 'CXP', 2, 26.09, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.1', 'CXP', 3, 34.78, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.1', 'CXP', 4, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.1', 'CXP', 5, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.2', 'CX', NULL, 3.23, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.2', 'CXP', 1, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.2', 'CXP', 2, 22.73, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.2', 'CXP', 3, 36.36, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.2', 'CXP', 4, 36.36, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.2', 'CXP', 5, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.3', 'CX', NULL, 1.32, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.3', 'CXP', 1, 77.27, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.3', 'CXP', 2, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.3', 'CXP', 3, 9.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.3', 'CXP', 4, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.1.d.3', 'CXP', 5, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.a', 'CX', NULL, 3.50, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.a', 'CXP', 1, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.a', 'CXP', 2, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.a', 'CXP', 3, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.a', 'CXP', 4, 27.27, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.a', 'CXP', 5, 31.82, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.b', 'CX', NULL, 1.91, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.b', 'CXP', 1, 47.83, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.b', 'CXP', 2, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.b', 'CXP', 3, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.b', 'CXP', 4, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.b', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.c', 'CX', NULL, 2.17, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.c', 'CXP', 1, 43.48, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.c', 'CXP', 2, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.c', 'CXP', 3, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.c', 'CXP', 4, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.c', 'CXP', 5, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.d', 'CX', NULL, 1.96, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.d', 'CXP', 1, 47.83, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.d', 'CXP', 2, 26.09, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.d', 'CXP', 3, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.d', 'CXP', 4, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.d', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.e', 'CX', NULL, 1.18, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.e', 'CXP', 1, 86.36, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.e', 'CXP', 2, 9.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.e', 'CXP', 3, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.e', 'CXP', 4, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.f', 'CX', NULL, 3.32, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.f', 'CXP', 1, 27.27, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.f', 'CXP', 2, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.f', 'CXP', 3, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.f', 'CXP', 4, 31.82, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.1.f', 'CXP', 5, 27.27, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.3', 'CX', NULL, 2.91, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.3', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.3', 'CXP', 2, 43.48, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.3', 'CXP', 3, 26.09, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.3', 'CXP', 4, 26.09, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.a.3', 'CXP', 5, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.a', 'CX', NULL, 2.65, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.a', 'CXP', 1, 34.78, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.a', 'CXP', 2, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.a', 'CXP', 3, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.a', 'CXP', 4, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.a', 'CXP', 5, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.b', 'CX', NULL, 1.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.b', 'CXP', 1, 60.87, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.b', 'CXP', 2, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.b', 'CXP', 3, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.b', 'CXP', 4, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.b', 'CXP', 5, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.c', 'CX', NULL, 1.50, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.c', 'CXP', 1, 68.18, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.c', 'CXP', 2, 22.73, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.c', 'CXP', 3, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.c', 'CXP', 4, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.c', 'CXP', 5, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.d', 'CX', NULL, 1.57, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.d', 'CXP', 1, 65.22, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.d', 'CXP', 2, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.d', 'CXP', 3, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.d', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.d', 'CXP', 5, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.e', 'CX', NULL, 1.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.e', 'CXP', 1, 73.91, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.e', 'CXP', 2, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.e', 'CXP', 3, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.e', 'CXP', 4, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.e', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.f', 'CX', NULL, 1.05, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.f', 'CXP', 1, 95.45, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.f', 'CXP', 2, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.f', 'CXP', 3, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.a', 'CX', NULL, 1.05, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.a', 'CXP', 1, 95.45, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.a', 'CXP', 2, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.b', 'CX', NULL, 1.13, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.b', 'CXP', 1, 95.65, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.b', 'CXP', 2, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.b', 'CXP', 3, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.b', 'CXP', 4, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.b', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.c', 'CX', NULL, 1.09, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.c', 'CXP', 1, 91.30, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.c', 'CXP', 2, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.c', 'CXP', 3, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.d', 'CX', NULL, 1.26, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.d', 'CXP', 1, 78.26, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.d', 'CXP', 2, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.d', 'CXP', 3, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.d', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.d', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.e', 'CX', NULL, 1.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.e', 'CXP', 1, 73.91, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.e', 'CXP', 2, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.e', 'CXP', 3, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.e', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.e', 'CXP', 5, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.f', 'CX', NULL, 1.23, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.f', 'CXP', 1, 81.82, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.f', 'CXP', 2, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.f', 'CXP', 3, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.f', 'CXP', 4, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.c.1.f', 'CXP', 5, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.a', 'CX', NULL, 3.65, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.a', 'CXP', 1, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.a', 'CXP', 2, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.a', 'CXP', 3, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.a', 'CXP', 4, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.a', 'CXP', 5, 26.09, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.b', 'CX', NULL, 2.57, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.b', 'CXP', 1, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.b', 'CXP', 2, 43.48, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.b', 'CXP', 3, 34.78, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.b', 'CXP', 4, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.b', 'CXP', 5, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.c', 'CX', NULL, 1.09, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.c', 'CXP', 1, 91.30, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.c', 'CXP', 2, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.d', 'CX', NULL, 2.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.d', 'CXP', 1, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.d', 'CXP', 2, 60.87, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.d', 'CXP', 3, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.d', 'CXP', 4, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.e', 'CX', NULL, 1.30, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.e', 'CXP', 1, 69.57, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.e', 'CXP', 2, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.e', 'CXP', 3, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.f', 'CX', NULL, 1.26, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.f', 'CXP', 1, 86.96, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.f', 'CXP', 2, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.f', 'CXP', 3, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.f', 'CXP', 5, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.g', 'CX', NULL, 1.52, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.g', 'CXP', 1, 69.57, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.g', 'CXP', 2, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.g', 'CXP', 3, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.g', 'CXP', 4, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.g', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.h', 'CX', NULL, 1.22, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.h', 'CXP', 1, 78.26, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.h', 'CXP', 2, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.h', 'CXP', 3, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.h', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.i', 'CX', NULL, 1.61, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.i', 'CXP', 1, 56.52, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.i', 'CXP', 2, 26.09, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.i', 'CXP', 3, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.i', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.d.1.i', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.d', 'CX', NULL, 1.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.d', 'CXP', 1, 73.91, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.d', 'CXP', 2, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.d', 'CXP', 3, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.d', 'CXP', 4, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.d', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.e', 'CX', NULL, 1.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.e', 'CXP', 1, 95.65, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.e', 'CXP', 2, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.e', 'CXP', 3, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.1', 'CX', NULL, 1.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.1', 'CXP', 1, 52.17, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.1', 'CXP', 2, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.1', 'CXP', 3, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.1', 'CXP', 4, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.1', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.a', 'CX', NULL, 3.65, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.a', 'CXP', 2, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.a', 'CXP', 3, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.a', 'CXP', 4, 60.87, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.a', 'CXP', 5, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.b', 'CX', NULL, 3.65, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.b', 'CXP', 1, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.b', 'CXP', 2, 8.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.b', 'CXP', 3, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.b', 'CXP', 4, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.2.b', 'CXP', 5, 30.43, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.4', 'CX', NULL, 4.13, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.4', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.4', 'CXP', 2, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.4', 'CXP', 3, 13.04, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.4', 'CXP', 4, 47.83, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.a.4', 'CXP', 5, 34.78, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.2', 'CX', NULL, 2.27, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.2', 'CXP', 1, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.2', 'CXP', 2, 59.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.2', 'CXP', 3, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.2', 'CXP', 4, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.2', 'CXP', 5, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.4', 'CX', NULL, 3.73, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.4', 'CXP', 1, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.4', 'CXP', 2, 13.64, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.4', 'CXP', 3, 27.27, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.4', 'CXP', 4, 31.82, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.4', 'CXP', 5, 27.27, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.7', 'CX', NULL, 2.59, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.7', 'CXP', 1, 22.73, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.7', 'CXP', 2, 22.73, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.7', 'CXP', 3, 31.82, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.7', 'CXP', 4, 18.18, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.7', 'CXP', 5, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.8', 'CX', NULL, 4.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.8', 'CXP', 1, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.8', 'CXP', 2, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.8', 'CXP', 3, 9.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
/*! COMMIT */;
/*! START TRANSACTION */;
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.8', 'CXP', 4, 59.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.b.8', 'CXP', 5, 27.27, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.c.1', 'CX', NULL, 4.14, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.c.1', 'CXP', 1, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.c.1', 'CXP', 2, 0.00, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.c.1', 'CXP', 3, 9.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.c.1', 'CXP', 4, 68.18, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.c.1', 'CXP', 5, 22.73, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.1', 'CX', NULL, 3.70, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.1', 'CXP', 1, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.1', 'CXP', 2, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.1', 'CXP', 3, 47.83, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.1', 'CXP', 4, 34.78, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.1', 'CXP', 5, 17.39, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.3', 'CX', NULL, 1.09, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.3', 'CXP', 1, 95.65, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.3', 'CXP', 2, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.3', 'CXP', 3, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.3', 'CXP', 4, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.3', 'CXP', 5, 0.00, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.4', 'CT', NULL, 1.30, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.4', 'CTP', 1, 73.91, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.4', 'CTP', 2, 21.74, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.4', 'CTP', 3, 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.8', 'CT', NULL, 2.82, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.8', 'CTP', 1, 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.8', 'CTP', 2, 9.09, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.C.3.d.8', 'CTP', 3, 86.36, 22, NULL, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.c', 'CX', NULL, 3.11, 35, 0.21, 2.68, 3.54, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.c', 'CXP', 1, 0.41, 35, 0.43, 0.05, 3.26, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.c', 'CXP', 2, 27.68, 35, 9.86, 12.34, 51.01, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.c', 'CXP', 3, 32.39, 35, 11.70, 13.92, 58.66, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.c', 'CXP', 4, 39.52, 35, 13.79, 16.82, 67.86, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.c', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.f', 'CX', NULL, 4.90, 35, 0.06, 4.78, 5.00, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.f', 'CXP', 4, 9.76, 35, 6.27, 2.48, 31.47, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.f', 'CXP', 5, 90.24, 35, 6.27, 68.53, 97.52, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.h', 'CX', NULL, 5.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.h', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.h', 'CXP', 5, 100.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.j', 'CX', NULL, 4.19, 35, 0.20, 3.78, 4.60, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.j', 'CXP', 1, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.j', 'CXP', 2, 0.41, 35, 0.43, 0.05, 3.26, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.j', 'CXP', 3, 26.89, 35, 10.03, 11.54, 50.91, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.j', 'CXP', 4, 25.94, 35, 12.29, 8.71, 56.25, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.j', 'CXP', 5, 46.76, 35, 13.35, 22.81, 72.30, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.l', 'CX', NULL, 4.98, 34, 0.01, 4.96, 5.00, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 34, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 34, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.l', 'CXP', 3, 0.00, 34, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.l', 'CXP', 4, 1.68, 34, 1.04, 0.47, 5.83, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.2.l', 'CXP', 5, 98.32, 34, 1.04, 94.17, 99.53, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.4', 'CX', NULL, 4.87, 35, 0.07, 4.72, 5.00, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.4', 'CXP', 1, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.4', 'CXP', 2, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.4', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.4', 'CXP', 4, 13.25, 35, 7.05, 4.21, 34.69, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.a.4', 'CXP', 5, 86.75, 35, 7.05, 65.31, 95.79, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.e', 'CX', NULL, 4.76, 35, 0.12, 4.51, 5.00, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.e', 'CXP', 2, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.e', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.e', 'CXP', 4, 23.74, 35, 12.34, 7.22, 55.44, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.e', 'CXP', 5, 76.26, 35, 12.34, 44.56, 92.78, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.f', 'CX', NULL, 4.59, 35, 0.13, 4.32, 4.86, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.f', 'CXP', 1, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.f', 'CXP', 2, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.f', 'CXP', 3, 3.43, 35, 2.59, 0.72, 14.79, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.f', 'CXP', 4, 34.43, 35, 12.82, 14.20, 62.49, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.f', 'CXP', 5, 62.14, 35, 12.82, 35.17, 83.24, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.g', 'CX', NULL, 4.29, 35, 0.25, 3.79, 4.79, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.g', 'CXP', 1, 0.83, 35, 0.61, 0.18, 3.65, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.g', 'CXP', 2, 1.02, 35, 0.76, 0.22, 4.55, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.g', 'CXP', 3, 25.75, 35, 12.58, 8.34, 56.91, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.g', 'CXP', 4, 13.36, 35, 7.29, 4.11, 35.69, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.b.1.g', 'CXP', 5, 59.05, 35, 13.05, 32.50, 81.19, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.1', 'CX', NULL, 2.92, 35, 0.42, 2.06, 3.78, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.1', 'CXP', 1, 23.39, 35, 12.03, 7.24, 54.43, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.1', 'CXP', 2, 19.04, 35, 8.16, 7.42, 40.83, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.1', 'CXP', 3, 20.94, 35, 10.55, 6.77, 49.16, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.1', 'CXP', 4, 15.55, 35, 7.32, 5.60, 36.37, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.1', 'CXP', 5, 21.07, 35, 12.44, 5.52, 54.98, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.2', 'CX', NULL, 4.02, 35, 0.34, 3.33, 4.72, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.2', 'CXP', 1, 0.41, 35, 0.43, 0.05, 3.26, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.2', 'CXP', 2, 18.55, 35, 11.80, 4.45, 52.68, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.2', 'CXP', 3, 12.03, 35, 6.74, 3.61, 33.29, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.2', 'CXP', 4, 16.35, 35, 8.00, 5.62, 39.09, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.c.2', 'CXP', 5, 52.66, 35, 13.07, 27.71, 76.35, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.1', 'CX', NULL, 3.33, 35, 0.25, 2.82, 3.83, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.1', 'CXP', 1, 0.83, 35, 0.61, 0.18, 3.65, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.1', 'CXP', 2, 22.68, 35, 12.12, 6.72, 54.44, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.1', 'CXP', 3, 29.02, 35, 11.10, 12.03, 55.00, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.1', 'CXP', 4, 37.99, 35, 12.97, 16.68, 65.22, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.1', 'CXP', 5, 9.47, 35, 6.63, 2.13, 33.50, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.2', 'CX', NULL, 3.20, 35, 0.18, 2.83, 3.58, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.2', 'CXP', 1, 0.41, 35, 0.43, 0.05, 3.32, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.2', 'CXP', 2, 26.81, 35, 8.62, 13.05, 47.20, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.2', 'CXP', 3, 29.90, 35, 12.85, 10.93, 59.72, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.2', 'CXP', 4, 37.92, 35, 12.28, 17.46, 63.81, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.2', 'CXP', 5, 4.96, 35, 4.94, 0.62, 30.53, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.3', 'CX', NULL, 1.22, 34, 0.13, 1.00, 1.49, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.3', 'CXP', 1, 82.75, 34, 10.99, 50.03, 95.83, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.3', 'CXP', 2, 12.21, 34, 10.69, 1.80, 51.39, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.3', 'CXP', 3, 5.04, 34, 4.61, 0.74, 27.35, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.3', 'CXP', 4, 0.00, 34, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.1.d.3', 'CXP', 5, 0.00, 34, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.a', 'CX', NULL, 4.95, 35, 0.03, 4.89, 5.00, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.a', 'CXP', 1, 0.99, 35, 0.74, 0.21, 4.46, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.a', 'CXP', 2, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.a', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.a', 'CXP', 4, 0.61, 35, 0.63, 0.08, 4.77, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.a', 'CXP', 5, 98.40, 35, 0.99, 94.47, 99.55, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.b', 'CX', NULL, 1.51, 35, 0.14, 1.24, 1.79, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.b', 'CXP', 1, 52.61, 35, 13.21, 27.44, 76.52, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.b', 'CXP', 2, 44.14, 35, 13.40, 20.76, 70.45, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.b', 'CXP', 3, 2.83, 35, 2.49, 0.46, 15.51, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.b', 'CXP', 4, 0.41, 35, 0.43, 0.05, 3.29, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.b', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.c', 'CX', NULL, 1.66, 35, 0.12, 1.42, 1.90, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.c', 'CXP', 1, 36.63, 35, 11.52, 17.41, 61.32, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.c', 'CXP', 2, 60.83, 35, 11.84, 36.13, 81.00, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.c', 'CXP', 3, 2.54, 35, 2.16, 0.44, 13.30, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.c', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.c', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.d', 'CX', NULL, 1.72, 35, 0.10, 1.51, 1.92, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.d', 'CXP', 1, 28.41, 35, 10.19, 12.54, 52.35, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.d', 'CXP', 2, 71.59, 35, 10.19, 47.65, 87.46, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.d', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.d', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.d', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.e', 'CX', NULL, 1.01, 35, 0.01, 1.00, 1.03, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.e', 'CXP', 1, 99.59, 35, 0.43, 96.68, 99.95, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.e', 'CXP', 2, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.e', 'CXP', 3, 0.41, 35, 0.43, 0.05, 3.32, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.e', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.f', 'CX', NULL, 2.50, 35, 0.16, 2.17, 2.83, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.f', 'CXP', 1, 7.71, 35, 4.32, 2.37, 22.32, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.f', 'CXP', 2, 48.14, 35, 11.95, 25.97, 71.06, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.f', 'CXP', 3, 33.11, 35, 12.93, 13.13, 61.86, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.f', 'CXP', 4, 8.63, 35, 5.04, 2.51, 25.71, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.1.f', 'CXP', 5, 2.41, 35, 2.44, 0.30, 16.82, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.3', 'CX', NULL, 2.50, 35, 0.24, 2.01, 3.00, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.3', 'CXP', 1, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.3', 'CXP', 2, 68.11, 35, 12.48, 39.91, 87.29, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.3', 'CXP', 3, 13.41, 35, 5.92, 5.21, 30.38, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.3', 'CXP', 4, 18.48, 35, 12.51, 4.02, 55.08, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.a.3', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.a', 'CX', NULL, 2.32, 35, 0.16, 1.99, 2.65, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.a', 'CXP', 1, 13.67, 35, 6.08, 5.27, 31.08, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.a', 'CXP', 2, 43.01, 35, 12.95, 20.50, 68.84, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.a', 'CXP', 3, 41.83, 35, 13.59, 18.78, 69.10, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.a', 'CXP', 4, 0.91, 35, 0.68, 0.20, 4.08, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.a', 'CXP', 5, 0.58, 35, 0.59, 0.07, 4.55, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.b', 'CX', NULL, 1.41, 35, 0.13, 1.14, 1.68, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.b', 'CXP', 1, 63.40, 35, 12.69, 36.30, 84.04, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.b', 'CXP', 2, 33.19, 35, 12.67, 13.46, 61.35, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.b', 'CXP', 3, 2.83, 35, 2.49, 0.46, 15.51, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.b', 'CXP', 4, 0.58, 35, 0.59, 0.07, 4.55, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.b', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.c', 'CX', NULL, 1.29, 35, 0.13, 1.02, 1.55, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.c', 'CXP', 1, 76.62, 35, 12.38, 44.59, 93.03, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.c', 'CXP', 2, 19.95, 35, 12.41, 4.88, 54.74, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.c', 'CXP', 3, 2.41, 35, 2.44, 0.30, 16.82, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.c', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.c', 'CXP', 5, 1.02, 35, 0.76, 0.22, 4.55, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.d', 'CX', NULL, 1.40, 35, 0.21, 1.00, 1.81, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.d', 'CXP', 1, 76.57, 35, 8.92, 54.34, 89.98, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.d', 'CXP', 2, 18.05, 35, 7.96, 6.87, 39.68, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.d', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.d', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.d', 'CXP', 5, 5.37, 35, 4.97, 0.77, 29.28, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.e', 'CX', NULL, 1.07, 35, 0.05, 1.00, 1.19, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.e', 'CXP', 1, 94.99, 35, 3.49, 81.06, 98.82, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.e', 'CXP', 2, 2.63, 35, 2.45, 0.38, 15.93, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.e', 'CXP', 3, 2.38, 35, 2.41, 0.29, 16.74, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.e', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.e', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.f', 'CX', NULL, 1.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.f', 'CXP', 1, 100.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.f', 'CXP', 2, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.f', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.a', 'CX', NULL, 1.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.a', 'CXP', 1, 100.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.a', 'CXP', 2, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.b', 'CX', NULL, 1.53, 35, 0.26, 1.00, 2.05, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.b', 'CXP', 1, 65.82, 35, 14.34, 34.53, 87.55, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.b', 'CXP', 2, 24.98, 35, 14.15, 6.70, 60.71, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.b', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.b', 'CXP', 4, 9.20, 35, 8.64, 1.23, 45.30, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.b', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.c', 'CX', NULL, 1.07, 35, 0.06, 1.00, 1.19, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.c', 'CXP', 1, 92.63, 35, 5.52, 70.84, 98.48, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.c', 'CXP', 2, 7.37, 35, 5.52, 1.52, 29.16, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.c', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.d', 'CX', NULL, 1.01, 35, 0.01, 1.00, 1.04, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.d', 'CXP', 1, 99.59, 35, 0.43, 96.71, 99.95, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.d', 'CXP', 2, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.d', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.d', 'CXP', 4, 0.41, 35, 0.43, 0.05, 3.29, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.d', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.e', 'CX', NULL, 1.03, 35, 0.02, 1.00, 1.08, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.e', 'CXP', 1, 97.17, 35, 2.49, 84.51, 99.54, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.e', 'CXP', 2, 2.83, 35, 2.49, 0.46, 15.49, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.e', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.e', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.e', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.f', 'CX', NULL, 1.18, 35, 0.12, 1.00, 1.42, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.f', 'CXP', 1, 82.32, 35, 11.94, 46.78, 96.10, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.f', 'CXP', 2, 17.68, 35, 11.94, 3.90, 53.22, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.f', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.f', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.c.1.f', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.a', 'CX', NULL, 4.16, 35, 0.24, 3.68, 4.63, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.a', 'CXP', 1, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.a', 'CXP', 2, 0.41, 35, 0.43, 0.05, 3.29, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.a', 'CXP', 3, 29.94, 35, 13.74, 10.14, 61.79, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.a', 'CXP', 4, 23.34, 35, 9.51, 9.37, 47.28, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.a', 'CXP', 5, 46.31, 35, 11.68, 24.93, 69.14, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.b', 'CX', NULL, 2.28, 35, 0.14, 1.99, 2.56, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.b', 'CXP', 1, 3.24, 35, 1.98, 0.92, 10.76, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.b', 'CXP', 2, 66.41, 35, 13.42, 36.79, 87.04, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.b', 'CXP', 3, 29.94, 35, 13.74, 10.14, 61.79, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.b', 'CXP', 4, 0.41, 35, 0.43, 0.05, 3.29, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.b', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.c', 'CX', NULL, 1.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.c', 'CXP', 1, 100.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.c', 'CXP', 2, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.d', 'CX', NULL, 1.92, 35, 0.15, 1.62, 2.22, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.d', 'CXP', 1, 19.56, 35, 7.88, 8.08, 40.21, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.d', 'CXP', 2, 68.98, 35, 11.26, 43.28, 86.63, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.d', 'CXP', 3, 11.45, 35, 10.50, 1.56, 51.44, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.d', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.e', 'CX', NULL, 1.17, 35, 0.12, 1.00, 1.42, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.e', 'CXP', 1, 82.62, 35, 11.97, 46.61, 96.28, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.e', 'CXP', 2, 17.38, 35, 11.97, 3.72, 53.39, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.e', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.f', 'CX', NULL, 1.14, 35, 0.12, 1.00, 1.38, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.f', 'CXP', 1, 86.48, 35, 12.09, 43.90, 98.12, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.f', 'CXP', 2, 13.52, 35, 12.09, 1.88, 56.10, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.f', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.f', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.g', 'CX', NULL, 1.84, 35, 0.26, 1.31, 2.37, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.g', 'CXP', 1, 54.17, 35, 13.18, 28.66, 77.66, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.g', 'CXP', 2, 21.46, 35, 12.43, 5.76, 55.01, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.g', 'CXP', 3, 17.39, 35, 9.44, 5.25, 44.44, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.g', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.g', 'CXP', 5, 6.98, 35, 5.26, 1.43, 28.03, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.h', 'CX', NULL, 1.26, 35, 0.13, 1.00, 1.51, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.h', 'CXP', 1, 74.44, 35, 12.59, 43.16, 91.78, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.h', 'CXP', 2, 25.56, 35, 12.59, 8.22, 56.84, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.h', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.h', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.i', 'CX', NULL, 2.41, 35, 0.30, 1.80, 3.02, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.i', 'CXP', 1, 33.38, 35, 11.50, 14.90, 58.91, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.i', 'CXP', 2, 33.17, 35, 13.49, 12.60, 63.10, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.i', 'CXP', 3, 4.96, 35, 4.67, 0.69, 28.14, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.i', 'CXP', 4, 16.10, 35, 7.99, 5.45, 38.97, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.d.1.i', 'CXP', 5, 12.39, 35, 6.58, 3.96, 32.63, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.d', 'CX', NULL, 1.20, 35, 0.08, 1.03, 1.37, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.d', 'CXP', 1, 80.11, 35, 8.23, 58.50, 92.01, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.d', 'CXP', 2, 19.89, 35, 8.23, 7.99, 41.50, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.d', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.d', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.d', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.e', 'CX', NULL, 1.00, 35, 0.00, 1.00, 1.01, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.e', 'CXP', 1, 99.59, 35, 0.43, 96.68, 99.95, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.e', 'CXP', 2, 0.41, 35, 0.43, 0.05, 3.32, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.e', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.1', 'CX', NULL, 3.13, 35, 0.21, 2.71, 3.55, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.1', 'CXP', 1, 1.64, 35, 1.34, 0.31, 8.26, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.1', 'CXP', 2, 34.61, 35, 10.76, 16.77, 58.17, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.1', 'CXP', 3, 24.88, 35, 12.50, 7.84, 56.33, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.1', 'CXP', 4, 27.16, 35, 12.07, 9.74, 56.30, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.1', 'CXP', 5, 11.70, 35, 6.24, 3.74, 31.14, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.a', 'CX', NULL, 4.33, 35, 0.23, 3.86, 4.80, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.a', 'CXP', 2, 0.41, 35, 0.43, 0.05, 3.26, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.a', 'CXP', 3, 25.35, 35, 12.18, 8.41, 55.66, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.a', 'CXP', 4, 15.38, 35, 7.17, 5.60, 35.75, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.a', 'CXP', 5, 58.85, 35, 12.05, 34.22, 79.73, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.b', 'CX', NULL, 4.43, 35, 0.23, 3.96, 4.90, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.b', 'CXP', 1, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.b', 'CXP', 2, 0.61, 35, 0.63, 0.08, 4.77, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.b', 'CXP', 3, 21.73, 35, 12.00, 6.21, 53.80, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.b', 'CXP', 4, 11.42, 35, 6.37, 3.46, 31.66, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.2.b', 'CXP', 5, 66.25, 35, 12.11, 39.49, 85.51, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.4', 'CX', NULL, 4.30, 35, 0.23, 3.84, 4.77, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.4', 'CXP', 1, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.4', 'CXP', 2, 2.41, 35, 2.44, 0.30, 16.82, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.4', 'CXP', 3, 14.75, 35, 12.02, 2.42, 54.68, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.4', 'CXP', 4, 32.86, 35, 11.59, 14.40, 58.73, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.a.4', 'CXP', 5, 49.98, 35, 13.13, 25.59, 74.39, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.2', 'CX', NULL, 1.63, 35, 0.23, 1.16, 2.10, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.2', 'CXP', 1, 56.98, 35, 12.17, 32.56, 78.42, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.2', 'CXP', 2, 23.91, 35, 8.57, 10.76, 45.01, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.2', 'CXP', 3, 18.62, 35, 12.51, 4.10, 55.05, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.2', 'CXP', 4, 0.50, 35, 0.51, 0.06, 3.94, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.2', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.4', 'CX', NULL, 4.43, 35, 0.23, 3.96, 4.91, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.4', 'CXP', 1, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.4', 'CXP', 2, 0.60, 35, 0.62, 0.07, 4.69, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.4', 'CXP', 3, 19.00, 35, 12.11, 4.52, 53.71, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.4', 'CXP', 4, 16.70, 35, 7.89, 5.95, 38.85, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.4', 'CXP', 5, 63.70, 35, 12.71, 36.48, 84.28, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.7', 'CX', NULL, 2.72, 35, 0.37, 1.96, 3.48, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.7', 'CXP', 1, 32.61, 35, 13.17, 12.52, 62.05, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.7', 'CXP', 2, 14.26, 35, 6.87, 5.04, 34.24, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.7', 'CXP', 3, 15.20, 35, 7.97, 4.85, 38.65, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.7', 'CXP', 4, 24.17, 35, 11.27, 8.37, 52.65, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.7', 'CXP', 5, 13.77, 35, 6.67, 4.85, 33.33, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.8', 'CX', NULL, 4.46, 35, 0.22, 4.01, 4.92, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.8', 'CXP', 1, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.8', 'CXP', 2, 0.41, 35, 0.43, 0.05, 3.26, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.8', 'CXP', 3, 14.19, 35, 12.04, 2.17, 55.22, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.8', 'CXP', 4, 24.27, 35, 8.56, 11.06, 45.22, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.b.8', 'CXP', 5, 61.13, 35, 11.99, 36.07, 81.43, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.c.1', 'CX', NULL, 3.41, 35, 0.25, 2.90, 3.92, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.c.1', 'CXP', 1, 4.44, 35, 3.02, 1.08, 16.50, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.c.1', 'CXP', 2, 16.68, 35, 11.92, 3.38, 53.37, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.c.1', 'CXP', 3, 22.15, 35, 8.43, 9.53, 43.44, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.c.1', 'CXP', 4, 46.85, 35, 12.19, 24.58, 70.44, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.c.1', 'CXP', 5, 9.89, 35, 6.66, 2.35, 33.39, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.1', 'CX', NULL, 4.45, 35, 0.16, 4.13, 4.77, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.1', 'CXP', 1, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.1', 'CXP', 2, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.1', 'CXP', 3, 6.45, 35, 4.73, 1.38, 25.31, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.1', 'CXP', 4, 41.99, 35, 12.00, 21.01, 66.34, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.1', 'CXP', 5, 51.55, 35, 13.13, 26.77, 75.60, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.3', 'CX', NULL, 1.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.3', 'CXP', 1, 100.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.3', 'CXP', 2, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.3', 'CXP', 3, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.3', 'CXP', 4, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.3', 'CXP', 5, 0.00, 35, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.4', 'CT', NULL, 1.19, 34, 0.12, 1.00, 1.43, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.4', 'CTP', 1, 80.98, 34, 12.01, 46.57, 95.41, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.4', 'CTP', 2, 19.02, 34, 12.01, 4.59, 53.43, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.4', 'CTP', 3, 0.00, 34, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.8', 'CT', NULL, 2.68, 35, 0.12, 2.43, 2.94, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.8', 'CTP', 1, 0.58, 35, 0.59, 0.07, 4.55, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.8', 'CTP', 2, 30.49, 35, 12.44, 11.74, 59.12, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.C.3.d.8', 'CTP', 3, 68.94, 35, 12.42, 40.57, 87.83, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.c', 'CX', NULL, 2.28, 44, 0.20, 1.89, 2.67, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.c', 'CXP', 1, 24.67, 44, 7.61, 12.53, 42.80, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.c', 'CXP', 2, 43.64, 44, 9.20, 26.69, 62.22, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.c', 'CXP', 3, 16.39, 44, 6.08, 7.42, 32.43, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.c', 'CXP', 4, 9.59, 44, 4.39, 3.68, 22.74, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.c', 'CXP', 5, 5.71, 44, 4.53, 1.10, 24.86, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.f', 'CX', NULL, 4.78, 45, 0.09, 4.61, 4.95, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.f', 'CXP', 3, 2.20, 45, 2.20, 0.29, 14.96, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.f', 'CXP', 4, 17.63, 45, 7.83, 6.73, 38.82, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.f', 'CXP', 5, 80.17, 45, 7.89, 59.78, 91.66, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.h', 'CX', NULL, 4.96, 45, 0.04, 4.89, 5.00, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.h', 'CXP', 4, 3.86, 45, 3.78, 0.51, 23.85, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.h', 'CXP', 5, 96.14, 45, 3.78, 76.15, 99.49, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.j', 'CX', NULL, 3.55, 45, 0.22, 3.10, 3.99, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.j', 'CXP', 1, 5.41, 45, 3.65, 1.34, 19.43, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.j', 'CXP', 2, 14.30, 45, 4.89, 6.94, 27.17, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.j', 'CXP', 3, 33.73, 45, 9.01, 18.42, 53.43, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.j', 'CXP', 4, 13.37, 45, 5.49, 5.61, 28.63, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.j', 'CXP', 5, 33.19, 45, 8.57, 18.57, 51.97, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.l', 'CX', NULL, 4.90, 45, 0.05, 4.80, 5.00, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.l', 'CXP', 3, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.l', 'CXP', 4, 9.90, 45, 5.08, 3.37, 25.73, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.2.l', 'CXP', 5, 90.10, 45, 5.08, 74.27, 96.63, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.4', 'CX', NULL, 4.50, 45, 0.12, 4.27, 4.74, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.4', 'CXP', 1, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.4', 'CXP', 2, 2.56, 45, 2.47, 0.36, 16.22, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.4', 'CXP', 3, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.4', 'CXP', 4, 42.04, 45, 8.88, 25.82, 60.18, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.a.4', 'CXP', 5, 55.40, 45, 9.21, 36.96, 72.46, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.e', 'CX', NULL, 4.57, 44, 0.10, 4.38, 4.76, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.e', 'CXP', 2, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.e', 'CXP', 3, 3.55, 44, 2.59, 0.79, 14.47, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.e', 'CXP', 4, 36.02, 44, 8.64, 20.92, 54.52, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.e', 'CXP', 5, 60.43, 44, 8.75, 42.20, 76.15, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.f', 'CX', NULL, 4.12, 44, 0.19, 3.75, 4.49, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.f', 'CXP', 1, 4.30, 44, 3.21, 0.92, 17.83, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.f', 'CXP', 2, 4.22, 44, 2.98, 0.99, 16.33, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.f', 'CXP', 3, 15.76, 44, 6.07, 6.92, 32.01, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.f', 'CXP', 4, 26.59, 44, 7.57, 14.22, 44.18, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.f', 'CXP', 5, 49.12, 44, 9.20, 31.49, 66.98, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.g', 'CX', NULL, 3.90, 45, 0.20, 3.50, 4.29, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.g', 'CXP', 1, 8.35, 45, 4.84, 2.48, 24.58, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.g', 'CXP', 2, 1.21, 45, 1.20, 0.16, 8.48, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.g', 'CXP', 3, 21.55, 45, 7.37, 10.24, 39.81, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.g', 'CXP', 4, 30.32, 45, 8.28, 16.49, 48.95, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.b.1.g', 'CXP', 5, 38.57, 45, 8.23, 23.76, 55.85, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.1', 'CX', NULL, 4.03, 45, 0.19, 3.64, 4.41, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.1', 'CXP', 1, 3.86, 45, 3.78, 0.51, 23.85, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.1', 'CXP', 2, 1.38, 45, 1.30, 0.20, 8.75, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.1', 'CXP', 3, 26.48, 45, 8.33, 13.19, 46.04, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.1', 'CXP', 4, 24.80, 45, 7.24, 13.11, 41.90, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.1', 'CXP', 5, 43.48, 45, 8.59, 27.55, 60.88, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.2', 'CX', NULL, 4.04, 45, 0.19, 3.67, 4.42, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.2', 'CXP', 1, 3.86, 45, 3.78, 0.51, 23.85, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.2', 'CXP', 2, 2.85, 45, 2.82, 0.38, 18.53, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.2', 'CXP', 3, 23.17, 45, 7.40, 11.54, 41.08, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.2', 'CXP', 4, 25.25, 45, 8.19, 12.35, 44.74, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.c.2', 'CXP', 5, 44.87, 45, 8.44, 29.03, 61.82, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.1', 'CX', NULL, 3.20, 45, 0.13, 2.94, 3.47, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.1', 'CXP', 1, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.1', 'CXP', 2, 22.21, 45, 6.88, 11.35, 38.90, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.1', 'CXP', 3, 38.01, 45, 9.04, 22.06, 57.05, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.1', 'CXP', 4, 37.08, 45, 8.71, 21.73, 55.57, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.1', 'CXP', 5, 2.70, 45, 1.81, 0.69, 10.02, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.2', 'CX', NULL, 3.08, 45, 0.16, 2.76, 3.41, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.2', 'CXP', 1, 2.20, 45, 2.20, 0.29, 14.96, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.2', 'CXP', 2, 27.80, 45, 8.21, 14.45, 46.75, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.2', 'CXP', 3, 34.01, 45, 8.03, 20.05, 51.45, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.2', 'CXP', 4, 31.45, 45, 8.72, 16.88, 50.89, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.2', 'CXP', 5, 4.53, 45, 2.60, 1.40, 13.73, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.3', 'CX', NULL, 1.75, 45, 0.18, 1.40, 2.11, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.3', 'CXP', 1, 52.65, 45, 8.77, 35.38, 69.31, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.3', 'CXP', 2, 27.68, 45, 7.85, 14.79, 45.76, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.3', 'CXP', 3, 11.49, 45, 5.25, 4.38, 26.89, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.3', 'CXP', 4, 8.18, 45, 5.51, 1.99, 28.12, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.1.d.3', 'CXP', 5, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.a', 'CX', NULL, 4.26, 45, 0.26, 3.74, 4.79, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.a', 'CXP', 1, 14.72, 45, 6.55, 5.69, 33.06, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.a', 'CXP', 2, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.a', 'CXP', 3, 3.86, 45, 3.78, 0.51, 23.85, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.a', 'CXP', 4, 7.07, 45, 6.69, 0.97, 37.18, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.a', 'CXP', 5, 74.35, 45, 8.85, 53.21, 88.08, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.b', 'CX', NULL, 1.90, 45, 0.24, 1.41, 2.40, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.b', 'CXP', 1, 60.61, 45, 8.50, 42.88, 75.93, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.b', 'CXP', 2, 17.78, 45, 7.21, 7.41, 36.89, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.b', 'CXP', 3, 5.15, 45, 3.98, 1.04, 21.93, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.b', 'CXP', 4, 3.48, 45, 2.53, 0.79, 14.12, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.b', 'CXP', 5, 12.98, 45, 6.06, 4.82, 30.54, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.c', 'CX', NULL, 1.79, 45, 0.24, 1.31, 2.27, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.c', 'CXP', 1, 62.88, 45, 8.33, 45.21, 77.68, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.c', 'CXP', 2, 18.50, 45, 6.62, 8.57, 35.47, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.c', 'CXP', 3, 5.64, 45, 3.28, 1.69, 17.17, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.c', 'CXP', 4, 2.83, 45, 2.01, 0.66, 11.30, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.c', 'CXP', 5, 10.15, 45, 5.77, 3.06, 28.77, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.d', 'CX', NULL, 1.69, 44, 0.20, 1.28, 2.10, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.d', 'CXP', 1, 61.23, 44, 8.52, 43.36, 76.51, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.d', 'CXP', 2, 23.59, 44, 7.45, 11.83, 41.54, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.d', 'CXP', 3, 6.63, 44, 3.37, 2.31, 17.56, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.d', 'CXP', 4, 2.08, 44, 2.07, 0.27, 14.20, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.d', 'CXP', 5, 6.47, 44, 4.74, 1.41, 25.12, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.e', 'CX', NULL, 1.51, 44, 0.17, 1.17, 1.85, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.e', 'CXP', 1, 72.14, 44, 8.70, 51.95, 86.11, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.e', 'CXP', 2, 12.71, 44, 7.28, 3.73, 35.33, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.e', 'CXP', 3, 7.50, 44, 4.60, 2.08, 23.60, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.e', 'CXP', 4, 7.66, 44, 4.81, 2.06, 24.66, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.f', 'CX', NULL, 2.14, 45, 0.22, 1.69, 2.59, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.f', 'CXP', 1, 45.96, 45, 9.03, 29.02, 63.89, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.f', 'CXP', 2, 20.73, 45, 7.14, 9.83, 38.56, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.f', 'CXP', 3, 15.99, 45, 7.42, 5.88, 36.68, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.f', 'CXP', 4, 7.84, 45, 3.96, 2.75, 20.41, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.1.f', 'CXP', 5, 9.48, 45, 5.05, 3.10, 25.53, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.3', 'CX', NULL, 2.80, 44, 0.14, 2.51, 3.09, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.3', 'CXP', 1, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.3', 'CXP', 2, 44.49, 44, 8.98, 27.79, 62.54, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.3', 'CXP', 3, 33.13, 44, 8.74, 18.27, 52.33, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.3', 'CXP', 4, 20.12, 44, 6.85, 9.64, 37.31, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.a.3', 'CXP', 5, 2.26, 44, 2.25, 0.29, 15.32, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.a', 'CX', NULL, 2.73, 44, 0.27, 2.20, 3.27, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.a', 'CXP', 1, 25.68, 44, 8.79, 12.01, 46.67, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.a', 'CXP', 2, 21.70, 44, 7.55, 10.16, 40.44, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.a', 'CXP', 3, 20.60, 44, 7.42, 9.41, 39.31, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.a', 'CXP', 4, 17.50, 44, 6.30, 8.08, 33.85, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.a', 'CXP', 5, 14.52, 44, 6.64, 5.46, 33.34, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.b', 'CX', NULL, 1.82, 45, 0.20, 1.42, 2.21, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.b', 'CXP', 1, 54.85, 45, 9.00, 36.86, 71.65, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.b', 'CXP', 2, 25.00, 45, 8.13, 12.22, 44.40, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.b', 'CXP', 3, 6.16, 45, 3.18, 2.12, 16.61, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.b', 'CXP', 4, 11.37, 45, 5.88, 3.80, 29.39, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.b', 'CXP', 5, 2.63, 45, 2.47, 0.38, 15.91, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.c', 'CX', NULL, 1.59, 45, 0.19, 1.21, 1.97, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.c', 'CXP', 1, 68.49, 45, 8.34, 49.94, 82.57, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.c', 'CXP', 2, 18.30, 45, 7.70, 7.36, 38.73, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.c', 'CXP', 3, 4.98, 45, 2.90, 1.50, 15.27, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.c', 'CXP', 4, 2.56, 45, 2.47, 0.36, 16.22, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.c', 'CXP', 5, 5.67, 45, 4.37, 1.14, 23.78, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.d', 'CX', NULL, 2.12, 44, 0.27, 1.57, 2.67, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.d', 'CXP', 1, 49.62, 44, 8.62, 32.94, 66.38, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.d', 'CXP', 2, 23.91, 44, 8.08, 11.37, 43.50, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.d', 'CXP', 3, 6.37, 44, 3.15, 2.29, 16.50, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.d', 'CXP', 4, 5.23, 44, 3.04, 1.58, 15.96, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.d', 'CXP', 5, 14.88, 44, 7.21, 5.26, 35.51, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.e', 'CX', NULL, 1.52, 44, 0.16, 1.19, 1.85, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.e', 'CXP', 1, 69.69, 44, 8.05, 51.60, 83.22, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.e', 'CXP', 2, 14.58, 44, 5.67, 6.37, 29.95, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.e', 'CXP', 3, 10.04, 44, 5.08, 3.47, 25.76, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.e', 'CXP', 4, 5.69, 44, 4.44, 1.13, 24.24, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.e', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.f', 'CX', NULL, 1.03, 45, 0.02, 1.00, 1.08, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.f', 'CXP', 1, 96.82, 45, 2.24, 87.54, 99.25, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.f', 'CXP', 2, 3.18, 45, 2.24, 0.75, 12.46, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.f', 'CXP', 3, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.a', 'CX', NULL, 1.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.a', 'CXP', 1, 100.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.a', 'CXP', 2, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.b', 'CX', NULL, 1.93, 45, 0.25, 1.42, 2.43, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.b', 'CXP', 1, 56.76, 45, 8.96, 38.61, 73.26, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.b', 'CXP', 2, 18.33, 45, 6.19, 8.89, 34.05, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.b', 'CXP', 3, 4.09, 45, 2.35, 1.26, 12.50, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.b', 'CXP', 4, 16.96, 45, 7.62, 6.42, 37.80, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.b', 'CXP', 5, 3.86, 45, 3.78, 0.51, 23.85, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.c', 'CX', NULL, 1.43, 44, 0.13, 1.17, 1.70, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.c', 'CXP', 1, 70.44, 44, 8.53, 51.04, 84.48, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.c', 'CXP', 2, 15.80, 44, 7.25, 5.88, 36.02, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.c', 'CXP', 3, 13.77, 44, 6.27, 5.21, 31.67, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.d', 'CX', NULL, 1.43, 45, 0.17, 1.09, 1.78, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.d', 'CXP', 1, 74.49, 45, 7.18, 57.69, 86.21, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.d', 'CXP', 2, 17.52, 45, 5.93, 8.50, 32.71, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.d', 'CXP', 3, 1.97, 45, 1.90, 0.28, 12.78, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.d', 'CXP', 4, 2.16, 45, 2.15, 0.28, 14.69, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.d', 'CXP', 5, 3.86, 45, 3.78, 0.51, 23.85, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.e', 'CX', NULL, 1.49, 45, 0.16, 1.17, 1.81, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.e', 'CXP', 1, 71.52, 45, 8.49, 52.03, 85.33, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.e', 'CXP', 2, 16.42, 45, 7.62, 6.03, 37.56, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.e', 'CXP', 3, 4.55, 45, 3.11, 1.11, 16.82, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.e', 'CXP', 4, 6.22, 45, 4.56, 1.35, 24.29, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.e', 'CXP', 5, 1.28, 45, 1.29, 0.17, 9.23, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.f', 'CX', NULL, 1.74, 45, 0.17, 1.39, 2.09, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.f', 'CXP', 1, 53.74, 45, 8.90, 36.10, 70.50, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.f', 'CXP', 2, 23.94, 45, 7.63, 11.92, 42.27, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.f', 'CXP', 3, 16.96, 45, 7.62, 6.42, 37.80, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.f', 'CXP', 4, 5.36, 45, 4.17, 1.07, 22.88, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.c.1.f', 'CXP', 5, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.a', 'CX', NULL, 3.66, 44, 0.18, 3.29, 4.03, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.a', 'CXP', 1, 3.94, 44, 3.86, 0.52, 24.28, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.a', 'CXP', 2, 10.88, 44, 5.43, 3.80, 27.40, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.a', 'CXP', 3, 20.95, 44, 7.06, 10.09, 38.49, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.a', 'CXP', 4, 43.50, 44, 8.91, 27.03, 61.53, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.a', 'CXP', 5, 20.74, 44, 6.31, 10.76, 36.21, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.b', 'CX', NULL, 2.49, 44, 0.15, 2.19, 2.78, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.b', 'CXP', 1, 6.47, 44, 4.24, 1.65, 22.13, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.b', 'CXP', 2, 53.19, 44, 8.83, 35.72, 69.91, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.b', 'CXP', 3, 25.27, 44, 7.38, 13.32, 42.65, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.b', 'CXP', 4, 15.08, 44, 6.46, 6.03, 32.93, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.b', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.c', 'CX', NULL, 1.33, 45, 0.11, 1.12, 1.55, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.c', 'CXP', 1, 72.38, 45, 8.51, 52.64, 86.08, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.c', 'CXP', 2, 21.75, 45, 8.05, 9.68, 41.90, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.c', 'CXP', 3, 5.86, 45, 4.23, 1.31, 22.63, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.d', 'CX', NULL, 2.48, 45, 0.15, 2.18, 2.78, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.d', 'CXP', 1, 5.35, 45, 3.34, 1.47, 17.61, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.d', 'CXP', 2, 56.02, 45, 8.98, 37.92, 72.64, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.d', 'CXP', 3, 27.89, 45, 8.26, 14.46, 46.96, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.d', 'CXP', 4, 6.88, 45, 3.57, 2.35, 18.52, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.d', 'CXP', 5, 3.86, 45, 3.78, 0.51, 23.85, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.e', 'CX', NULL, 1.67, 45, 0.10, 1.48, 1.87, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.e', 'CXP', 1, 36.76, 45, 8.26, 22.13, 54.33, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.e', 'CXP', 2, 59.37, 45, 8.46, 41.89, 74.76, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.e', 'CXP', 3, 3.86, 45, 3.78, 0.51, 23.85, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.f', 'CX', NULL, 1.31, 44, 0.09, 1.12, 1.50, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.f', 'CXP', 1, 71.54, 44, 8.58, 51.79, 85.47, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.f', 'CXP', 2, 27.17, 44, 8.55, 13.50, 47.12, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.f', 'CXP', 3, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.f', 'CXP', 4, 1.29, 44, 1.30, 0.17, 9.32, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.f', 'CXP', 5, 0.00, 44, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.g', 'CX', NULL, 2.24, 45, 0.23, 1.78, 2.70, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.g', 'CXP', 1, 37.63, 45, 8.51, 22.52, 55.61, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.g', 'CXP', 2, 33.30, 45, 8.03, 19.41, 50.86, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.g', 'CXP', 3, 9.39, 45, 4.90, 3.14, 24.86, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.g', 'CXP', 4, 6.55, 45, 4.97, 1.34, 26.48, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.g', 'CXP', 5, 13.13, 45, 5.34, 5.56, 27.97, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.h', 'CX', NULL, 1.71, 45, 0.14, 1.44, 1.99, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.h', 'CXP', 1, 43.66, 45, 9.02, 27.01, 61.88, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.h', 'CXP', 2, 45.21, 45, 9.16, 28.13, 63.48, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.h', 'CXP', 3, 7.27, 45, 3.71, 2.52, 19.21, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.h', 'CXP', 4, 3.86, 45, 3.78, 0.51, 23.85, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.i', 'CX', NULL, 2.76, 44, 0.22, 2.32, 3.20, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.i', 'CXP', 1, 17.94, 44, 6.57, 8.16, 34.98, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.i', 'CXP', 2, 27.66, 44, 7.75, 14.89, 45.51, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.i', 'CXP', 3, 26.52, 44, 8.84, 12.63, 47.40, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.i', 'CXP', 4, 16.43, 44, 6.63, 6.91, 34.25, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.d.1.i', 'CXP', 5, 11.44, 44, 5.20, 4.39, 26.68, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.d', 'CX', NULL, 1.82, 45, 0.20, 1.42, 2.21, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.d', 'CXP', 1, 58.55, 45, 9.03, 40.02, 74.94, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.d', 'CXP', 2, 15.83, 45, 5.20, 7.88, 29.24, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.d', 'CXP', 3, 16.60, 45, 8.14, 5.74, 39.42, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.d', 'CXP', 4, 3.54, 45, 2.48, 0.84, 13.66, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.d', 'CXP', 5, 5.49, 45, 3.21, 1.64, 16.82, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.e', 'CX', NULL, 1.14, 45, 0.06, 1.03, 1.26, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.e', 'CXP', 1, 85.53, 45, 5.80, 69.67, 93.84, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.e', 'CXP', 2, 14.47, 45, 5.80, 6.16, 30.33, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.e', 'CXP', 3, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.1', 'CX', NULL, 2.77, 45, 0.27, 2.24, 3.31, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.1', 'CXP', 1, 27.51, 45, 7.81, 14.70, 45.53, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.1', 'CXP', 2, 14.96, 45, 5.89, 6.46, 30.91, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.1', 'CXP', 3, 21.70, 45, 6.31, 11.59, 36.95, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.1', 'CXP', 4, 24.50, 45, 8.31, 11.60, 44.52, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.1', 'CXP', 5, 11.34, 45, 6.22, 3.54, 30.81, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.a', 'CX', NULL, 3.85, 44, 0.23, 3.39, 4.30, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.a', 'CXP', 1, 6.78, 44, 4.87, 1.51, 25.59, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.a', 'CXP', 2, 11.96, 44, 5.29, 4.70, 27.25, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.a', 'CXP', 3, 9.99, 44, 4.88, 3.58, 24.91, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.a', 'CXP', 4, 32.30, 44, 8.83, 17.45, 51.85, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.a', 'CXP', 5, 38.96, 44, 8.99, 22.95, 57.76, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.b', 'CX', NULL, 3.90, 44, 0.21, 3.47, 4.33, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.b', 'CXP', 1, 6.78, 44, 4.87, 1.51, 25.59, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.b', 'CXP', 2, 8.10, 44, 4.28, 2.69, 21.94, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.b', 'CXP', 3, 15.26, 44, 5.25, 7.35, 29.00, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.b', 'CXP', 4, 28.03, 44, 8.87, 13.84, 48.59, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.2.b', 'CXP', 5, 41.83, 44, 8.52, 26.19, 59.30, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.4', 'CX', NULL, 4.12, 44, 0.22, 3.67, 4.58, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.4', 'CXP', 1, 5.82, 44, 4.55, 1.15, 24.76, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.4', 'CXP', 2, 5.56, 44, 3.85, 1.32, 20.53, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.4', 'CXP', 3, 13.50, 44, 7.49, 4.10, 36.28, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.4', 'CXP', 4, 20.79, 44, 6.85, 10.19, 37.79, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.a.4', 'CXP', 5, 54.32, 44, 8.99, 36.43, 71.17, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.2', 'CX', NULL, 2.14, 45, 0.16, 1.82, 2.46, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.2', 'CXP', 1, 31.19, 45, 8.19, 17.36, 49.44, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.2', 'CXP', 2, 30.13, 45, 8.36, 16.23, 48.98, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.2', 'CXP', 3, 31.85, 45, 8.77, 17.15, 51.35, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.2', 'CXP', 4, 6.82, 45, 3.45, 2.40, 17.92, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.2', 'CXP', 5, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.4', 'CX', NULL, 4.15, 45, 0.14, 3.87, 4.42, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.4', 'CXP', 1, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.4', 'CXP', 2, 5.77, 45, 3.42, 1.69, 17.88, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.4', 'CXP', 3, 12.42, 45, 5.40, 4.95, 27.83, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.4', 'CXP', 4, 43.24, 45, 8.56, 27.38, 60.61, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.4', 'CXP', 5, 38.58, 45, 8.52, 23.34, 56.45, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.7', 'CX', NULL, 3.36, 45, 0.26, 2.83, 3.89, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.7', 'CXP', 1, 17.33, 45, 6.60, 7.65, 34.66, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.7', 'CXP', 2, 17.98, 45, 6.71, 8.06, 35.41, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.7', 'CXP', 3, 11.23, 45, 4.48, 4.86, 23.84, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.7', 'CXP', 4, 18.65, 45, 7.68, 7.64, 38.87, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.7', 'CXP', 5, 34.81, 45, 8.16, 20.55, 52.43, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.8', 'CX', NULL, 4.03, 45, 0.20, 3.62, 4.45, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.8', 'CXP', 1, 3.86, 45, 3.78, 0.51, 23.85, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.8', 'CXP', 2, 8.45, 45, 5.11, 2.38, 25.90, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.8', 'CXP', 3, 10.84, 45, 7.01, 2.74, 34.42, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.8', 'CXP', 4, 34.09, 45, 8.26, 19.78, 52.03, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.b.8', 'CXP', 5, 42.75, 45, 8.48, 27.08, 60.02, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.c.1', 'CX', NULL, 2.48, 44, 0.21, 2.06, 2.90, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.c.1', 'CXP', 1, 24.97, 44, 7.52, 12.90, 42.79, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.c.1', 'CXP', 2, 26.98, 44, 7.91, 14.12, 45.38, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.c.1', 'CXP', 3, 31.21, 44, 8.44, 17.04, 50.07, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.c.1', 'CXP', 4, 8.68, 44, 4.88, 2.68, 24.74, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.c.1', 'CXP', 5, 8.15, 44, 4.95, 2.29, 25.17, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.1', 'CX', NULL, 3.70, 45, 0.12, 3.45, 3.94, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.1', 'CXP', 1, 0.00, 45, 0.00, NULL, NULL, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.1', 'CXP', 2, 11.00, 45, 4.90, 4.31, 25.33, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.1', 'CXP', 3, 21.20, 45, 6.85, 10.54, 38.07, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.1', 'CXP', 4, 55.07, 45, 9.00, 37.07, 71.84, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.1', 'CXP', 5, 12.72, 45, 4.75, 5.79, 25.67, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.3', 'CX', NULL, 1.48, 45, 0.15, 1.17, 1.78, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.3', 'CXP', 1, 73.31, 45, 8.01, 54.61, 86.24, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.3', 'CXP', 2, 9.90, 45, 5.15, 3.32, 26.04, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.3', 'CXP', 3, 13.99, 45, 6.74, 4.99, 33.48, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.3', 'CXP', 4, 1.21, 45, 1.20, 0.16, 8.48, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.3', 'CXP', 5, 1.60, 45, 1.60, 0.21, 11.25, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.4', 'CT', NULL, 1.11, 44, 0.06, 1.00, 1.23, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.4', 'CTP', 1, 89.75, 44, 5.31, 73.23, 96.55, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.4', 'CTP', 2, 9.01, 44, 4.91, 2.87, 24.89, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.4', 'CTP', 3, 1.24, 44, 1.23, 0.17, 8.69, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.8', 'CT', NULL, 2.23, 45, 0.13, 1.96, 2.49, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.8', 'CTP', 1, 16.87, 45, 7.10, 6.82, 36.01, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.8', 'CTP', 2, 43.76, 45, 9.00, 27.13, 61.92, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.C.3.d.8', 'CTP', 3, 39.37, 45, 8.81, 23.58, 57.75, 'N', NULL, '2017-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.c', 'CX', NULL, 2.08, 21, 0.20, 1.66, 2.49, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.c', 'CXP', 1, 17.48, 21, 13.84, 2.78, 61.05, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.c', 'CXP', 2, 63.33, 21, 15.48, 30.07, 87.40, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.c', 'CXP', 3, 13.23, 21, 6.48, 4.48, 33.12, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.c', 'CXP', 4, 5.96, 21, 4.74, 1.08, 26.98, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.c', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.f', 'CX', NULL, 4.48, 21, 0.17, 4.13, 4.84, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.f', 'CXP', 1, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.f', 'CXP', 2, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.f', 'CXP', 3, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.f', 'CXP', 4, 51.91, 21, 17.04, 20.63, 81.77, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.f', 'CXP', 5, 48.09, 21, 17.04, 18.23, 79.37, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.h', 'CX', NULL, 5.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.h', 'CXP', 1, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.h', 'CXP', 2, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.h', 'CXP', 3, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.h', 'CXP', 4, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.h', 'CXP', 5, 100.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.j', 'CX', NULL, 3.01, 21, 0.51, 1.94, 4.07, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.j', 'CXP', 1, 14.23, 21, 12.99, 1.77, 60.45, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.j', 'CXP', 2, 35.88, 21, 18.33, 9.60, 74.68, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.j', 'CXP', 3, 10.99, 21, 6.87, 2.78, 34.81, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.j', 'CXP', 4, 12.83, 21, 7.04, 3.80, 35.38, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.j', 'CXP', 5, 26.07, 21, 14.61, 6.77, 63.14, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.l', 'CX', NULL, 4.63, 21, 0.18, 4.25, 5.00, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.l', 'CXP', 1, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.l', 'CXP', 2, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.l', 'CXP', 3, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.l', 'CXP', 4, 36.95, 21, 18.20, 10.30, 74.94, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.2.l', 'CXP', 5, 63.05, 21, 18.20, 25.06, 89.70, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.4', 'CX', NULL, 4.58, 21, 0.18, 4.21, 4.95, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.4', 'CXP', 1, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.4', 'CXP', 2, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.4', 'CXP', 3, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.4', 'CXP', 4, 42.06, 21, 17.85, 13.60, 76.99, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.a.4', 'CXP', 5, 57.94, 21, 17.85, 23.01, 86.40, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.e', 'CX', NULL, 4.75, 21, 0.12, 4.51, 5.00, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.e', 'CXP', 1, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.e', 'CXP', 2, 0.15, 21, 0.15, 0.02, 1.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.e', 'CXP', 3, 2.67, 21, 2.76, 0.30, 20.16, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.e', 'CXP', 4, 18.80, 21, 10.05, 5.54, 47.75, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.e', 'CXP', 5, 78.39, 21, 10.64, 49.45, 93.08, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.f', 'CX', NULL, 3.02, 21, 0.35, 2.30, 3.75, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.f', 'CXP', 1, 3.04, 21, 3.01, 0.37, 20.84, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.f', 'CXP', 2, 32.79, 21, 15.32, 10.27, 67.53, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.f', 'CXP', 3, 40.29, 21, 17.93, 12.48, 76.15, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.f', 'CXP', 4, 6.55, 21, 4.15, 1.67, 22.38, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.f', 'CXP', 5, 17.33, 21, 13.21, 2.98, 58.91, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.g', 'CX', NULL, 4.55, 21, 0.18, 4.17, 4.92, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.g', 'CXP', 1, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.g', 'CXP', 2, 1.86, 21, 1.80, 0.24, 12.98, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.g', 'CXP', 3, 5.33, 21, 3.95, 1.09, 22.34, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.g', 'CXP', 4, 29.20, 21, 14.77, 8.50, 64.67, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.b.1.g', 'CXP', 5, 63.61, 21, 15.53, 30.14, 87.63, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.1', 'CX', NULL, 2.94, 21, 0.30, 2.31, 3.57, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.1', 'CXP', 1, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.1', 'CXP', 2, 40.32, 21, 17.99, 12.44, 76.26, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.1', 'CXP', 3, 27.46, 21, 14.30, 7.81, 62.85, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.1', 'CXP', 4, 29.88, 21, 14.87, 8.83, 65.20, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.1', 'CXP', 5, 2.34, 21, 1.85, 0.44, 11.47, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.2', 'CX', NULL, 4.54, 20, 0.21, 4.11, 4.98, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.2', 'CXP', 1, 1.79, 20, 1.84, 0.20, 14.01, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.2', 'CXP', 2, 2.94, 20, 2.92, 0.35, 20.46, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.2', 'CXP', 3, 4.81, 20, 4.93, 0.53, 32.46, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.2', 'CXP', 4, 20.17, 20, 14.43, 3.72, 62.25, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.c.2', 'CXP', 5, 70.30, 20, 15.30, 33.80, 91.65, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.1', 'CX', NULL, 3.30, 21, 0.20, 2.87, 3.72, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.1', 'CXP', 1, 2.81, 21, 2.78, 0.35, 19.46, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.1', 'CXP', 2, 11.59, 21, 7.23, 2.92, 36.38, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.1', 'CXP', 3, 38.86, 21, 18.11, 11.47, 75.71, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.1', 'CXP', 4, 46.73, 21, 17.23, 17.16, 78.80, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.1', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.2', 'CX', NULL, 2.95, 21, 0.34, 2.24, 3.67, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.2', 'CXP', 1, 0.15, 21, 0.15, 0.02, 1.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.2', 'CXP', 2, 52.29, 21, 17.16, 20.69, 82.15, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.2', 'CXP', 3, 1.71, 21, 1.78, 0.19, 13.72, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.2', 'CXP', 4, 43.69, 21, 17.03, 15.48, 76.68, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.2', 'CXP', 5, 2.17, 21, 2.12, 0.27, 15.16, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.3', 'CX', NULL, 1.09, 21, 0.05, 1.00, 1.21, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.3', 'CXP', 1, 90.96, 21, 5.46, 71.55, 97.58, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.3', 'CXP', 2, 8.89, 21, 5.44, 2.35, 28.38, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.3', 'CXP', 3, 0.15, 21, 0.15, 0.02, 1.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.3', 'CXP', 4, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.1.d.3', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.a', 'CX', NULL, 3.80, 21, 0.73, 2.28, 5.00, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.a', 'CXP', 1, 28.56, 21, 18.51, 5.69, 72.62, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.a', 'CXP', 2, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.a', 'CXP', 3, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.a', 'CXP', 4, 5.52, 21, 4.87, 0.83, 29.04, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.a', 'CXP', 5, 65.92, 21, 18.15, 26.39, 91.25, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.b', 'CX', NULL, 1.66, 20, 0.20, 1.24, 2.09, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.b', 'CXP', 1, 41.50, 20, 18.26, 12.82, 77.39, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.b', 'CXP', 2, 53.59, 20, 18.01, 20.23, 84.02, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.b', 'CXP', 3, 2.12, 20, 2.08, 0.26, 14.99, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.b', 'CXP', 4, 2.80, 20, 2.91, 0.31, 21.26, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.b', 'CXP', 5, 0.00, 20, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.c', 'CX', NULL, 1.17, 21, 0.10, 1.00, 1.38, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.c', 'CXP', 1, 82.98, 21, 10.29, 51.60, 95.71, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.c', 'CXP', 2, 17.02, 21, 10.29, 4.29, 48.40, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.c', 'CXP', 3, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.c', 'CXP', 4, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.c', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.d', 'CX', NULL, 1.13, 21, 0.07, 1.00, 1.28, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.d', 'CXP', 1, 87.12, 21, 7.32, 63.41, 96.35, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.d', 'CXP', 2, 12.73, 21, 7.30, 3.57, 36.49, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.d', 'CXP', 3, 0.15, 21, 0.15, 0.02, 1.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.d', 'CXP', 4, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.d', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.e', 'CX', NULL, 1.09, 21, 0.08, 1.00, 1.26, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.e', 'CXP', 1, 90.85, 21, 8.17, 56.07, 98.72, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.e', 'CXP', 2, 9.15, 21, 8.17, 1.28, 43.93, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.e', 'CXP', 3, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.e', 'CXP', 4, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.e', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.f', 'CX', NULL, 1.27, 21, 0.13, 1.00, 1.53, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.f', 'CXP', 1, 79.14, 21, 10.41, 50.46, 93.39, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.f', 'CXP', 2, 15.27, 21, 9.30, 3.87, 44.66, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.f', 'CXP', 3, 5.45, 21, 3.73, 1.26, 20.69, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.f', 'CXP', 4, 0.15, 21, 0.15, 0.02, 1.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.1.f', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.3', 'CX', NULL, 2.63, 21, 0.30, 2.00, 3.25, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.3', 'CXP', 1, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.3', 'CXP', 2, 65.10, 21, 15.79, 30.45, 88.82, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.3', 'CXP', 3, 10.40, 21, 8.41, 1.74, 43.28, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.3', 'CXP', 4, 21.39, 21, 14.14, 4.50, 61.13, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.a.3', 'CXP', 5, 3.10, 21, 3.20, 0.35, 22.75, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.a', 'CX', NULL, 2.31, 21, 0.48, 1.30, 3.33, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.a', 'CXP', 1, 46.36, 21, 17.76, 16.30, 79.32, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.a', 'CXP', 2, 16.52, 21, 8.72, 5.02, 42.52, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.a', 'CXP', 3, 2.67, 21, 2.76, 0.30, 20.16, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.a', 'CXP', 4, 28.28, 21, 14.80, 7.92, 64.37, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.a', 'CXP', 5, 6.18, 21, 4.18, 1.44, 22.86, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.b', 'CX', NULL, 1.22, 21, 0.12, 1.00, 1.48, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.b', 'CXP', 1, 81.90, 21, 10.58, 50.51, 95.25, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.b', 'CXP', 2, 13.94, 21, 9.85, 2.84, 47.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.b', 'CXP', 3, 4.16, 21, 3.43, 0.72, 20.68, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.b', 'CXP', 4, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.b', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.c', 'CX', NULL, 1.33, 21, 0.15, 1.01, 1.65, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.c', 'CXP', 1, 74.28, 21, 11.85, 44.19, 91.33, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.c', 'CXP', 2, 22.64, 21, 11.29, 7.09, 52.89, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.c', 'CXP', 3, 0.91, 21, 0.96, 0.10, 7.75, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.c', 'CXP', 4, 0.15, 21, 0.15, 0.02, 1.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.c', 'CXP', 5, 2.02, 21, 2.10, 0.22, 15.89, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.d', 'CX', NULL, 1.49, 21, 0.23, 1.00, 1.97, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.d', 'CXP', 1, 73.37, 21, 12.01, 43.32, 90.85, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.d', 'CXP', 2, 10.86, 21, 6.81, 2.73, 34.59, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.d', 'CXP', 3, 10.26, 21, 8.40, 1.68, 43.41, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.d', 'CXP', 4, 4.60, 21, 4.70, 0.51, 31.07, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.d', 'CXP', 5, 0.91, 21, 0.96, 0.10, 7.75, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.e', 'CX', NULL, 1.57, 21, 0.28, 1.00, 2.15, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.e', 'CXP', 1, 64.21, 21, 15.68, 30.18, 88.16, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.e', 'CXP', 2, 25.39, 21, 14.06, 6.75, 61.54, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.e', 'CXP', 3, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.e', 'CXP', 4, 10.26, 21, 8.40, 1.68, 43.41, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.e', 'CXP', 5, 0.15, 21, 0.15, 0.02, 1.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.f', 'CX', NULL, 1.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.f', 'CXP', 1, 100.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.f', 'CXP', 2, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.f', 'CXP', 3, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.f', 'CXP', 4, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.b.1.f', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.a', 'CX', NULL, 1.02, 21, 0.02, 1.00, 1.06, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.a', 'CXP', 1, 98.13, 21, 1.95, 85.11, 99.79, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.a', 'CXP', 2, 1.87, 21, 1.95, 0.21, 14.89, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.a', 'CXP', 3, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.a', 'CXP', 4, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.a', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.b', 'CX', NULL, 1.05, 21, 0.04, 1.00, 1.15, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.b', 'CXP', 1, 96.41, 21, 2.71, 83.99, 99.28, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.b', 'CXP', 2, 1.71, 21, 1.76, 0.20, 13.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.b', 'CXP', 3, 1.87, 21, 1.95, 0.21, 14.89, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.b', 'CXP', 4, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.b', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.c', 'CX', NULL, 1.27, 21, 0.18, 1.00, 1.64, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.c', 'CXP', 1, 81.10, 21, 10.59, 50.37, 94.78, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.c', 'CXP', 2, 10.66, 21, 6.78, 2.63, 34.50, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.c', 'CXP', 3, 8.24, 21, 8.09, 0.95, 45.54, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.c', 'CXP', 4, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.c', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.d', 'CX', NULL, 1.36, 21, 0.20, 1.00, 1.78, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.d', 'CXP', 1, 72.72, 21, 15.23, 34.95, 92.97, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.d', 'CXP', 2, 18.90, 21, 13.91, 3.39, 60.76, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.d', 'CXP', 3, 8.24, 21, 8.09, 0.95, 45.54, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.d', 'CXP', 4, 0.15, 21, 0.15, 0.02, 1.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.d', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.e', 'CX', NULL, 1.15, 21, 0.10, 1.00, 1.36, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.e', 'CXP', 1, 85.00, 21, 9.96, 52.61, 96.66, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.e', 'CXP', 2, 14.86, 21, 9.95, 3.27, 47.38, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.e', 'CXP', 3, 0.15, 21, 0.15, 0.02, 1.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.e', 'CXP', 4, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.e', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.f', 'CX', NULL, 1.32, 21, 0.15, 1.00, 1.65, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.f', 'CXP', 1, 67.74, 21, 15.47, 32.42, 90.19, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.f', 'CXP', 2, 32.26, 21, 15.47, 9.81, 67.58, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.f', 'CXP', 3, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.f', 'CXP', 4, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.c.1.f', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.a', 'CX', NULL, 4.58, 21, 0.16, 4.24, 4.92, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.a', 'CXP', 1, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.a', 'CXP', 2, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.a', 'CXP', 3, 0.91, 21, 0.96, 0.10, 7.75, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.a', 'CXP', 4, 40.22, 21, 15.82, 14.57, 72.63, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.a', 'CXP', 5, 58.87, 21, 15.93, 26.62, 84.95, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.b', 'CX', NULL, 1.57, 21, 0.19, 1.19, 1.96, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.b', 'CXP', 1, 44.23, 21, 18.06, 14.69, 78.51, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.b', 'CXP', 2, 54.06, 21, 17.72, 20.98, 83.91, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.b', 'CXP', 3, 1.71, 21, 1.76, 0.20, 13.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.b', 'CXP', 4, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.b', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.c', 'CX', NULL, 1.15, 20, 0.09, 1.00, 1.34, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.c', 'CXP', 1, 85.49, 20, 9.46, 54.42, 96.68, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.c', 'CXP', 2, 14.51, 20, 9.46, 3.32, 45.58, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.c', 'CXP', 3, 0.00, 20, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.c', 'CXP', 4, 0.00, 20, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.c', 'CXP', 5, 0.00, 20, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.d', 'CX', NULL, 1.64, 20, 0.19, 1.25, 2.04, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.d', 'CXP', 1, 35.54, 20, 19.08, 8.80, 75.92, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.d', 'CXP', 2, 64.46, 20, 19.08, 24.08, 91.20, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.d', 'CXP', 3, 0.00, 20, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.d', 'CXP', 4, 0.00, 20, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.d', 'CXP', 5, 0.00, 20, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.e', 'CX', NULL, 1.32, 20, 0.16, 1.00, 1.65, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.e', 'CXP', 1, 67.94, 20, 15.89, 31.53, 90.70, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.e', 'CXP', 2, 32.06, 20, 15.89, 9.30, 68.47, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.e', 'CXP', 3, 0.00, 20, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.e', 'CXP', 4, 0.00, 20, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.e', 'CXP', 5, 0.00, 20, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.f', 'CX', NULL, 1.11, 21, 0.08, 1.00, 1.29, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.f', 'CXP', 1, 88.83, 21, 8.48, 57.21, 97.93, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.f', 'CXP', 2, 11.17, 21, 8.48, 2.07, 42.79, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.f', 'CXP', 3, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.f', 'CXP', 4, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.f', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.g', 'CX', NULL, 2.94, 21, 0.60, 1.69, 4.20, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.g', 'CXP', 1, 29.10, 21, 14.37, 8.76, 63.70, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.g', 'CXP', 2, 18.71, 21, 9.89, 5.60, 47.18, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.g', 'CXP', 3, 15.32, 21, 13.80, 1.93, 62.47, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.g', 'CXP', 4, 2.67, 21, 2.76, 0.30, 20.16, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.g', 'CXP', 5, 34.21, 21, 18.22, 8.76, 73.79, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.h', 'CX', NULL, 1.26, 21, 0.12, 1.01, 1.50, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.h', 'CXP', 1, 74.34, 21, 11.81, 44.33, 91.34, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.h', 'CXP', 2, 25.66, 21, 11.81, 8.66, 55.67, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.h', 'CXP', 3, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.h', 'CXP', 4, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.h', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.i', 'CX', NULL, 3.61, 21, 0.44, 2.68, 4.53, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.i', 'CXP', 1, 4.38, 21, 3.36, 0.85, 19.63, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.i', 'CXP', 2, 32.27, 21, 13.36, 11.75, 63.02, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.i', 'CXP', 3, 2.90, 21, 2.99, 0.32, 21.52, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.i', 'CXP', 4, 19.06, 21, 13.87, 3.48, 60.57, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.d.1.i', 'CXP', 5, 41.40, 21, 18.25, 12.82, 77.24, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.d', 'CX', NULL, 1.51, 21, 0.26, 1.00, 2.04, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.d', 'CXP', 1, 75.34, 21, 11.66, 45.21, 91.88, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.d', 'CXP', 2, 11.69, 21, 8.58, 2.28, 42.85, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.d', 'CXP', 3, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.d', 'CXP', 4, 12.98, 21, 8.07, 3.25, 39.85, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.d', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.e', 'CX', NULL, 1.06, 21, 0.06, 1.00, 1.18, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.e', 'CXP', 1, 94.15, 21, 5.74, 64.64, 99.30, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.e', 'CXP', 2, 5.85, 21, 5.74, 0.70, 35.36, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.e', 'CXP', 3, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.e', 'CXP', 4, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.2.e.1.e', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.1', 'CX', NULL, 3.72, 20, 0.35, 2.99, 4.44, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.1', 'CXP', 1, 1.92, 20, 1.84, 0.25, 13.11, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.1', 'CXP', 2, 8.68, 20, 6.09, 1.87, 32.17, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.1', 'CXP', 3, 42.73, 20, 18.59, 13.21, 78.53, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.1', 'CXP', 4, 8.91, 20, 5.20, 2.50, 27.21, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.1', 'CXP', 5, 37.76, 20, 16.63, 12.12, 72.74, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.a', 'CX', NULL, 4.34, 21, 0.19, 3.94, 4.74, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.a', 'CXP', 1, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.a', 'CXP', 2, 1.71, 21, 1.76, 0.20, 13.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.a', 'CXP', 3, 8.18, 21, 5.76, 1.77, 30.61, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.a', 'CXP', 4, 44.39, 21, 17.62, 15.26, 77.96, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.a', 'CXP', 5, 45.72, 21, 17.10, 16.68, 77.99, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.b', 'CX', NULL, 3.93, 21, 0.36, 3.19, 4.68, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.b', 'CXP', 1, 1.71, 21, 1.76, 0.20, 13.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.b', 'CXP', 2, 7.42, 21, 5.61, 1.44, 30.55, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.b', 'CXP', 3, 31.14, 21, 18.23, 7.13, 72.71, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.b', 'CXP', 4, 15.21, 21, 8.14, 4.59, 40.09, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.2.b', 'CXP', 5, 44.52, 21, 17.23, 15.77, 77.47, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.4', 'CX', NULL, 4.42, 21, 0.19, 4.02, 4.83, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.4', 'CXP', 1, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.4', 'CXP', 2, 2.17, 21, 2.12, 0.27, 15.16, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.4', 'CXP', 3, 6.87, 21, 4.90, 1.47, 26.74, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.4', 'CXP', 4, 37.41, 21, 16.76, 11.83, 72.69, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.a.4', 'CXP', 5, 53.55, 21, 16.96, 21.76, 82.70, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.2', 'CX', NULL, 2.56, 21, 0.46, 1.61, 3.51, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.2', 'CXP', 1, 34.44, 21, 15.67, 11.00, 69.08, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.2', 'CXP', 2, 8.70, 21, 5.03, 2.48, 26.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.2', 'CXP', 3, 23.76, 21, 14.35, 5.63, 61.94, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.2', 'CXP', 4, 32.94, 21, 18.11, 8.16, 73.09, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.2', 'CXP', 5, 0.15, 21, 0.15, 0.02, 1.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.4', 'CX', NULL, 4.04, 21, 0.25, 3.52, 4.57, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.4', 'CXP', 1, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.4', 'CXP', 2, 6.25, 21, 4.04, 1.56, 21.94, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.4', 'CXP', 3, 21.73, 21, 13.76, 4.89, 60.00, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.4', 'CXP', 4, 33.40, 21, 18.13, 8.39, 73.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.4', 'CXP', 5, 38.62, 21, 16.17, 13.17, 72.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.7', 'CX', NULL, 3.88, 21, 0.37, 3.10, 4.66, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.7', 'CXP', 1, 4.61, 21, 3.55, 0.89, 20.68, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.7', 'CXP', 2, 7.39, 21, 5.38, 1.52, 29.13, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.7', 'CXP', 3, 26.72, 21, 14.88, 6.95, 64.01, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.7', 'CXP', 4, 17.88, 21, 8.69, 5.96, 42.81, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.7', 'CXP', 5, 43.40, 21, 18.07, 14.19, 78.06, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.8', 'CX', NULL, 4.75, 21, 0.13, 4.47, 5.00, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.8', 'CXP', 1, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.8', 'CXP', 2, 2.02, 21, 2.10, 0.22, 15.89, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.8', 'CXP', 3, 4.40, 21, 4.34, 0.53, 28.39, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.8', 'CXP', 4, 10.33, 21, 6.36, 2.68, 32.56, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.b.8', 'CXP', 5, 83.25, 21, 8.45, 58.42, 94.62, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.c.1', 'CX', NULL, 3.65, 21, 0.38, 2.86, 4.44, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.c.1', 'CXP', 1, 2.67, 21, 2.76, 0.30, 20.16, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.c.1', 'CXP', 2, 14.07, 21, 9.11, 3.29, 44.07, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.c.1', 'CXP', 3, 22.34, 21, 13.51, 5.36, 59.35, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.c.1', 'CXP', 4, 37.18, 21, 15.85, 12.56, 70.92, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.c.1', 'CXP', 5, 23.75, 21, 19.05, 3.36, 73.64, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.1', 'CX', NULL, 3.37, 21, 0.37, 2.61, 4.13, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.1', 'CXP', 1, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.1', 'CXP', 2, 23.75, 21, 19.05, 3.36, 73.64, 'Y', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.1', 'CXP', 3, 24.60, 21, 13.70, 6.53, 60.37, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.1', 'CXP', 4, 42.51, 21, 16.55, 15.26, 75.23, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.1', 'CXP', 5, 9.14, 21, 6.55, 1.91, 34.25, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.3', 'CX', NULL, 1.28, 21, 0.16, 1.00, 1.61, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.3', 'CXP', 1, 77.66, 21, 14.19, 38.71, 95.04, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.3', 'CXP', 2, 17.03, 21, 13.82, 2.60, 61.23, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.3', 'CXP', 3, 5.16, 21, 4.49, 0.80, 26.96, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.3', 'CXP', 4, 0.15, 21, 0.15, 0.02, 1.31, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.3', 'CXP', 5, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.4', 'CT', NULL, 1.23, 21, 0.14, 1.00, 1.52, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.4', 'CTP', 1, 76.93, 21, 13.82, 39.64, 94.42, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.4', 'CTP', 2, 23.07, 21, 13.82, 5.58, 60.36, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.4', 'CTP', 3, 0.00, 21, 0.00, NULL, NULL, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.8', 'CT', NULL, 2.63, 21, 0.18, 2.26, 3.00, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.8', 'CTP', 1, 1.82, 21, 1.40, 0.36, 8.67, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.8', 'CTP', 2, 33.12, 21, 18.15, 8.23, 73.23, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.C.3.d.8', 'CTP', 3, 65.05, 21, 17.97, 26.37, 90.63, 'N', NULL, '2016-07-01', 'Incumbent');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.c', 'CX', NULL, 2.57, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.c', 'CXP', 1, 6.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.c', 'CXP', 2, 46.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.c', 'CXP', 3, 33.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.c', 'CXP', 4, 10.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.c', 'CXP', 5, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.f', 'CX', NULL, 4.97, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.f', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.f', 'CXP', 2, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.f', 'CXP', 3, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.f', 'CXP', 4, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.f', 'CXP', 5, 96.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.h', 'CX', NULL, 4.97, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.h', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.h', 'CXP', 2, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.h', 'CXP', 3, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.h', 'CXP', 4, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.h', 'CXP', 5, 96.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.j', 'CX', NULL, 4.17, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.j', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.j', 'CXP', 2, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.j', 'CXP', 3, 20.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.j', 'CXP', 4, 43.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.j', 'CXP', 5, 36.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.l', 'CX', NULL, 4.93, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.l', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.l', 'CXP', 2, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.l', 'CXP', 3, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.l', 'CXP', 4, 6.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.2.l', 'CXP', 5, 93.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.4', 'CX', NULL, 4.27, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.4', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.4', 'CXP', 2, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.4', 'CXP', 3, 16.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.4', 'CXP', 4, 30.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.a.4', 'CXP', 5, 50.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.e', 'CX', NULL, 4.37, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.e', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.e', 'CXP', 2, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.e', 'CXP', 3, 6.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.e', 'CXP', 4, 50.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.e', 'CXP', 5, 43.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.f', 'CX', NULL, 3.17, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.f', 'CXP', 1, 10.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.f', 'CXP', 2, 26.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.f', 'CXP', 3, 20.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.f', 'CXP', 4, 23.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.f', 'CXP', 5, 20.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.g', 'CX', NULL, 3.97, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.g', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.g', 'CXP', 2, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.g', 'CXP', 3, 20.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.g', 'CXP', 4, 53.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.b.1.g', 'CXP', 5, 23.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.1', 'CX', NULL, 2.43, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.1', 'CXP', 1, 10.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.1', 'CXP', 2, 56.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.1', 'CXP', 3, 16.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.1', 'CXP', 4, 13.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.1', 'CXP', 5, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.2', 'CX', NULL, 4.13, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.2', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.2', 'CXP', 2, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.2', 'CXP', 3, 6.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.2', 'CXP', 4, 63.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.c.2', 'CXP', 5, 26.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.1', 'CX', NULL, 3.07, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.1', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.1', 'CXP', 2, 30.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.1', 'CXP', 3, 40.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.1', 'CXP', 4, 23.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.1', 'CXP', 5, 6.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.2', 'CX', NULL, 2.70, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.2', 'CXP', 1, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.2', 'CXP', 2, 36.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.2', 'CXP', 3, 46.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.2', 'CXP', 4, 13.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.2', 'CXP', 5, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.3', 'CX', NULL, 1.30, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.3', 'CXP', 1, 76.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.3', 'CXP', 2, 16.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.3', 'CXP', 3, 6.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.3', 'CXP', 4, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.1.d.3', 'CXP', 5, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.a', 'CX', NULL, 5.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.a', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.a', 'CXP', 2, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.a', 'CXP', 3, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.a', 'CXP', 4, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.a', 'CXP', 5, 100.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.b', 'CX', NULL, 1.37, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.b', 'CXP', 1, 63.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.b', 'CXP', 2, 36.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.b', 'CXP', 3, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.b', 'CXP', 4, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.b', 'CXP', 5, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.c', 'CX', NULL, 1.17, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.c', 'CXP', 1, 86.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.c', 'CXP', 2, 10.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.c', 'CXP', 3, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.c', 'CXP', 4, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.c', 'CXP', 5, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.d', 'CX', NULL, 1.10, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.d', 'CXP', 1, 90.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.d', 'CXP', 2, 10.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.d', 'CXP', 3, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.d', 'CXP', 4, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.d', 'CXP', 5, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.e', 'CX', NULL, 1.03, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.e', 'CXP', 1, 96.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.e', 'CXP', 2, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.e', 'CXP', 3, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.e', 'CXP', 4, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.e', 'CXP', 5, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.f', 'CX', NULL, 1.83, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.f', 'CXP', 1, 53.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.f', 'CXP', 2, 20.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.f', 'CXP', 3, 20.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.f', 'CXP', 4, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.1.f', 'CXP', 5, 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.3', 'CX', NULL, 2.40, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.3', 'CXP', 1, 0.00, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.C.2.a.3', 'CXP', 2, 76.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_context (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, low