CREATE TABLE emerging_tasks (
  onetsoc_code CHARACTER(10) NOT NULL,
  task CHARACTER VARYING(1000) NOT NULL,
  category CHARACTER VARYING(8) NOT NULL,
  original_task_id DECIMAL(8,0),
  writein_total DECIMAL(3,0) NOT NULL,
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (original_task_id) REFERENCES task_statements(task_id));
GO

INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('11-2011.00', 'Create media notices about events.', 'New', NULL, 5, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('11-3051.02', 'Conduct employee safety training.', 'New', NULL, 9, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('11-3051.04', 'Manage safety programs at power generation facilities.', 'New', NULL, 5, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('11-3051.06', 'Train employees in power plant operations.', 'New', NULL, 5, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('11-3061.00', 'Develop cost reduction strategies and savings plans.', 'New', NULL, 10, '2009-06-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('11-9032.00', 'Create school improvement plans by using student performance data.', 'New', NULL, 5, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('11-9033.00', 'Design or use assessments to monitor student learning outcomes.', 'New', NULL, 8, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('11-9033.00', 'Prepare reports on academic or institutional data.', 'New', NULL, 6, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('11-9039.02', 'Evaluate fitness and wellness programs to determine their effectiveness.', 'New', NULL, 6, '2015-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('11-9061.00', 'Deliver death certificates to medical facilities or offices to obtain signatures from legally authorized persons.', 'New', NULL, 6, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('11-9071.00', 'Monitor the performance of the gaming floor, relocating games and installing new games as necessary.', 'New', NULL, 6, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('11-9199.11', 'Identify and apply for project funding.', 'New', NULL, 8, '2013-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1011.00', 'Send samples of clients'' work and other promotional material to potential employers to obtain auditions, sponsorships and endorsement deals.', 'New', NULL, 9, '2007-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1031.01', 'Attend mediations or trials.', 'New', NULL, 5, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1032.00', 'Contact vendors to locate replacement parts for vehicles.', 'New', NULL, 5, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1032.00', 'Discuss insurance claims with customers or damage claimants.', 'New', NULL, 13, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1032.00', 'Review repair cost estimates and negotiate with automobile repair shops to secure agreement on cost of repairs.', 'Revision', 7247, 5, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1041.03', 'Develop guidelines for nondiscriminatory employment practices, such as affirmative action plans and equal opportunity employment policies.', 'Revision', 20722, 13, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1041.03', 'Train employees on equal opportunity laws, guidelines, or policies, such as discrimination, diversity, harassment, or affirmative action.', 'New', NULL, 13, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1071.00', 'Administer employee benefit plans.', 'New', NULL, 9, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1121.00', 'Contact potential clients, meet with professional and trade associations, and produce brochures and other publications to promote conference, convention, and trade show services.', 'Revision', 1228, 8, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1121.00', 'Plan and develop programs, agendas, budgets, menus, and services according to customer requirements.', 'Revision', 1213, 7, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1141.00', 'Develop and administer compensation programs such as merit or incentive pay.', 'New', NULL, 11, '2017-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-2011.01', 'Prepare adjusting journal entries.', 'New', NULL, 5, '2009-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-2011.01', 'Review accounts for discrepancies and reconcile differences.', 'New', NULL, 6, '2009-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-2021.01', 'Assist in the training of new staff.', 'New', NULL, 6, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-2021.01', 'Explain real and personal property taxes to property owners.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-2041.00', 'Contact customers regarding delinquent accounts to collect payments.', 'New', NULL, 8, '2009-06-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-2053.00', 'Examine documents to determine degree of risk from factors such as applicant health, financial standing and value, and condition of property.', 'Revision', 1260, 7, '2009-06-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-2082.00', 'Schedule appointments with clients.', 'New', NULL, 5, '2013-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('15-1131.00', 'Develop websites.', 'New', NULL, 6, '2009-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('15-1131.00', 'Train users on the use and function of computer programs.', 'New', NULL, 7, '2009-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('15-2031.00', 'Review research literature.', 'New', NULL, 4, '2017-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('15-2041.00', 'Determine whether statistical methods are appropriate based on user needs or on research questions of interest.', 'Revision', 8962, 5, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('15-2041.00', 'Prepare and structure data warehouses for storing data.', 'New', NULL, 6, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2011.00', 'Develop software for aerospace systems.', 'New', NULL, 6, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2031.00', 'Design and deliver technology, such as prosthetic devices, to assist people with disabilities.', 'Revision', 8977, 4, '2017-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2041.00', 'Develop computer models of chemical processes.', 'New', NULL, 4, '2017-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2071.00', 'Develop software to control electrical systems.', 'New', NULL, 9, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2081.01', 'Evaluate the operation and maintenance of water/wastewater systems to identify ways to improve their efficiency.', 'New', NULL, 5, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2111.02', 'Direct the purchase, modification, installation, testing, maintenance, and operation of fire prevention and protection systems.', 'Revision', 8987, 6, '2013-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2121.02', 'Conduct analyses of ships, such as stability, structural, weight, or vibration analyses.', 'Revision', 20732, 20, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2131.00', 'Present technical information at conferences.', 'New', NULL, 5, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2199.10', 'Analyze meteorological data.', 'New', NULL, 7, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2199.10', 'Design electrical interconnections.', 'New', NULL, 5, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2199.10', 'Design wind turbine components.', 'New', NULL, 7, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2199.10', 'Estimate energy production by analyzing wind data.', 'New', NULL, 15, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-3013.00', 'Create bills of materials.', 'New', NULL, 5, '2017-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-3021.00', 'Design electrical and mechanical systems used for avionic instrumentation applications.', 'New', NULL, 5, '2006-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-3026.00', 'Create engineering drawings, schematics or blueprints.', 'New', NULL, 5, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-3031.01', 'Adjust and operate surveying instruments such as prisms, theodolites, electronic distance measuring equipment, or electronic data collectors.', 'Revision', 5394, 4, '2017-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-3031.01', 'Conduct surveys to ascertain the locations of natural features and man-made structures on the Earth''s surface, underground, and underwater, using electronic distance-measuring equipment, such as GPS, and other surveying instruments.', 'Revision', 5400, 6, '2017-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-3031.02', 'Prepare cost estimates for mapping projects.', 'New', NULL, 6, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1013.00', 'Conduct experiments to investigate the underlying mechanisms involved in plant growth and plant responses to the environment.', 'New', NULL, 8, '2014-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1020.01', 'Write grant proposals to obtain funding for biological research.', 'New', NULL, 5, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1021.00', 'Write grant proposals to obtain funding for research.', 'New', NULL, 8, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1029.02', 'Prepare or review reports, manuscripts, or meeting presentations.', 'Revision', 16803, 4, '2016-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1029.02', 'Write grant applications to obtain funding.', 'New', NULL, 5, '2016-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1031.01', 'Develop soil maps.', 'New', NULL, 6, '2011-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1031.02', 'Coordinate with federal land managers and other agencies and organizations to manage and protect rangelands.', 'New', NULL, 15, '2005-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1031.02', 'Regulate grazing (e.g., by issuing permits and checking for compliance with standards), and help ranchers plan and organize grazing systems in order to manage, improve and protect rangelands and maximize their use.', 'Revision', 7496, 20, '2005-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1031.03', 'Provide care for park program animals.', 'New', NULL, 6, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1031.03', 'Train staff on park programs.', 'New', NULL, 6, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1041.00', 'Write articles for publication in professional journals.', 'New', NULL, 5, '2016-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1041.00', 'Write grant applications for funding epidemiologic research.', 'New', NULL, 6, '2016-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1042.00', 'Write applications for research grants.', 'New', NULL, 12, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-2011.00', 'Conduct question and answer presentations on astronomy topics with public audiences.', 'New', NULL, 7, '2011-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-2011.00', 'Mentor graduate students and junior colleagues.', 'New', NULL, 7, '2011-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-2011.00', 'Supervise students'' research on celestial and astronomical phenomena.', 'New', NULL, 4, '2011-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-2012.00', 'Write research proposals to receive funding.', 'New', NULL, 8, '2006-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-2021.00', 'Develop and deliver training on weather topics.', 'New', NULL, 10, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-2021.00', 'Develop computer programs to collect meteorological data or to present meteorological information.', 'New', NULL, 6, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-2021.00', 'Speak to the public to discuss weather topics or answer questions.', 'New', NULL, 8, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-2032.00', 'Write research papers for publication in scientific journals.', 'New', NULL, 18, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-2041.02', 'Write grants to obtain funding for restoration projects.', 'New', NULL, 4, '2013-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-2042.00', 'Review environmental, historical, or technical reports and publications for accuracy.', 'New', NULL, 4, '2013-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-3011.00', 'Explain economic impact of policies to the public.', 'New', NULL, 11, '2011-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-3011.01', 'Teach courses in environmental economics.', 'New', NULL, 7, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-3022.00', 'Write proposals to win new projects.', 'New', NULL, 5, '2011-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-3031.02', 'Conduct assessments of patients'' risk for harm to self or others.', 'New', NULL, 5, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-3031.02', 'Prepare written evaluations of individuals'' psychological competence for court hearings.', 'New', NULL, 8, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-3031.03', 'Supervise and train interns, clinicians in training, and other counselors.', 'Revision', 20219, 8, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-3041.00', 'Explain sociological research to the general public.', 'New', NULL, 6, '2016-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-3041.00', 'Write grants to obtain funding for research projects.', 'New', NULL, 4, '2016-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-3091.02', 'Design exhibits of artifacts.', 'New', NULL, 4, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-3091.02', 'Educate the public about archeology.', 'New', NULL, 11, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-3091.02', 'Mentor archeology students.', 'New', NULL, 4, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-3094.00', 'Advise political science students.', 'New', NULL, 10, '2017-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-3094.00', 'Serve on committees.', 'New', NULL, 4, '2017-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4011.02', 'Supervise other food science technicians.', 'New', NULL, 5, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4041.01', 'Evaluate and interpret seismic data with the aid of computers.', 'New', NULL, 8, '2006-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4041.01', 'Record geological data in a database.', 'New', NULL, 6, '2006-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4051.02', 'Calibrate, maintain, and repair chemical instrumentation sensing elements and sampling system equipment, using calibration instruments and hand tools.', 'Revision', 7608, 11, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4051.02', 'Document results from radiation and contamination surveys.', 'New', NULL, 5, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4051.02', 'Inspect, test, and maintain respiratory protection equipment.', 'New', NULL, 9, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4051.02', 'Write radiological work permits.', 'New', NULL, 7, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4092.00', 'Analyze data from computers or other digital media sources for evidence related to criminal activity.', 'New', NULL, 7, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4092.00', 'Analyze DNA data to identify DNA donor profiles.', 'New', NULL, 9, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4092.00', 'Examine footwear, tire tracks or other types of impressions.', 'New', NULL, 7, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4092.00', 'Examine physical evidence, such as hair, biological fluids, fiber, wood, or soil residues to obtain information about its source and composition.', 'Revision', 1585, 6, '2013-07-01', 'Incumbent');
GO
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4092.00', 'Measure and sketch crime scenes to document evidence.', 'New', NULL, 14, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4092.00', 'Train others, such as new personnel, on crime scene investigation techniques, including the collection and packaging of evidence.', 'New', NULL, 9, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4093.00', 'Map forest tract data using digital mapping systems.', 'New', NULL, 4, '2010-06-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('21-1014.00', 'Collaborate with mental health professionals and other staff members to perform clinical assessments or develop treatment plans.', 'Revision', 1599, 7, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('21-1014.00', 'Perform crisis interventions to help ensure the safety of the patients and others.', 'New', NULL, 8, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('21-1015.00', 'Supervise rehabilitation counselors and staff.', 'New', NULL, 5, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('21-1022.00', 'Educate clients about end of life symptoms and options to assist them in making informed decisions.', 'New', NULL, 5, '2014-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('21-1093.00', 'Assess clients'' cognitive abilities, and physical and emotional needs to determine appropriate interventions.', 'New', NULL, 8, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('21-1093.00', 'Develop and implement behavioral management and care plans for clients.', 'New', NULL, 6, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('23-1011.00', 'Negotiate contractual agreements.', 'New', NULL, 6, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('23-1011.00', 'Work in environmental law, representing the state, federal agencies, public interest groups, waste disposal companies, or construction firms.', 'Revision', 3794, 6, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('23-1021.00', 'Schedule hearings.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('23-1023.00', 'Issue arrest warrants.', 'New', NULL, 6, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('23-2011.00', 'Investigate facts and law of cases and search pertinent sources, such as public records and internet sources, to determine causes of action and to prepare cases.', 'Revision', 18495, 7, '2009-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('23-2091.00', 'Log and store exhibits from court proceedings.', 'New', NULL, 14, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('23-2091.00', 'Proofread transcripts for correct spelling of words.', 'New', NULL, 35, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('23-2091.00', 'Type court orders for judges.', 'New', NULL, 6, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1011.00', 'Mentor new faculty.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1021.00', 'Develop and maintain website for on-line courses.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1022.00', 'Conduct faculty performance evaluations.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1022.00', 'Develop department and course schedules.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1032.00', 'Review manuscripts for professional journals.', 'New', NULL, 6, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1042.00', 'Maintain or repair lab equipment.', 'New', NULL, 8, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1052.00', 'Clean laboratory facilities.', 'New', NULL, 6, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1052.00', 'Write letters of recommendation for students.', 'New', NULL, 7, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1053.00', 'Write letters of recommendation for students.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1061.00', 'Conduct ethnographic field research.', 'New', NULL, 6, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1061.00', 'Write letters of recommendation for students.', 'New', NULL, 6, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1066.00', 'Recruit and hire new faculty.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1066.00', 'Write letters of recommendation for students.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1067.00', 'Mentor new faculty.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1072.00', 'Conduct faculty performance evaluations.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1082.00', 'Select and invite guest speakers to speak to classes.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1111.00', 'Write letters of recommendation for students.', 'New', NULL, 6, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1113.00', 'Mentor new faculty members.', 'New', NULL, 5, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1121.00', 'Maintain or repair studio facilities.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1122.00', 'Direct theatre productions and projects.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1123.00', 'Review manuscripts for publication in professional journals.', 'New', NULL, 7, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1123.00', 'Schedule courses.', 'New', NULL, 6, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1123.00', 'Teach writing or communication classes.', 'Revision', 20092, 12, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1123.00', 'Write letters of recommendation for students.', 'New', NULL, 12, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1124.00', 'Write letters of recommendation for students.', 'New', NULL, 6, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1191.00', 'Correspond with students through email to address their questions and concerns.', 'New', NULL, 8, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1192.00', 'Conduct faculty performance evaluations.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1193.00', 'Coach athletic teams.', 'New', NULL, 8, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-2053.00', 'Collaborate with other teachers that provide instruction to special education students to ensure that the students receive appropriate supports.', 'New', NULL, 5, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-2053.00', 'Develop or write Individualized Education Programs (IEPs) for students.', 'New', NULL, 5, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-2059.01', 'Collaborate with other educational personnel to provide inclusive activities or programs for children with disabilities.', 'New', NULL, 8, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-4013.00', 'Enter information on museum collections into computer databases.', 'New', NULL, 5, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-4031.00', 'Open and close the library.', 'New', NULL, 6, '2017-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-9011.00', 'Edit audiovisual material to enhance viewing quality.', 'New', NULL, 10, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-9011.00', 'Maintain inventory of audiovisual equipment.', 'New', NULL, 8, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-9011.00', 'Supervise student workers.', 'New', NULL, 6, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-9011.00', 'Train faculty and media staff on the use of audiovisual equipment.', 'New', NULL, 6, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-9011.00', 'Troubleshoot problems with audiovisual equipment.', 'New', NULL, 6, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-9041.00', 'Clean classrooms.', 'New', NULL, 6, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-9041.00', 'Teach social skills to students.', 'New', NULL, 9, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-1012.00', 'Pack products for shipping.', 'New', NULL, 4, '2016-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-1024.00', 'Prepare digital files for printing.', 'New', NULL, 4, '2016-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-1024.00', 'Research the target audience of projects.', 'New', NULL, 4, '2016-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-1024.00', 'Write or edit copy for clients.', 'New', NULL, 5, '2016-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-1025.00', 'Research health and safety code requirements to inform design.', 'New', NULL, 8, '2017-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-2012.01', 'Monitor time during live broadcasts.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-2012.01', 'Schedule guests to appear on shows.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-2012.01', 'Select news content that is relevant and important to viewers.', 'New', NULL, 10, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-2012.04', 'Direct shows, productions, and plays.', 'New', NULL, 5, '2006-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-2012.04', 'Teach acting classes.', 'New', NULL, 5, '2006-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-2023.00', 'Inspect game sites for compliance with regulations or safety requirements.', 'New', NULL, 4, '2014-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-2031.00', 'Prepare pointe shoes (e.g., by sewing) for use in rehearsals and performance.', 'New', NULL, 10, '2005-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-2041.01', 'Compose instrumental or vocal music.', 'New', NULL, 6, '2017-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-2041.01', 'Practice playing musical instruments.', 'New', NULL, 8, '2017-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-2041.04', 'Produce recordings of music.', 'New', NULL, 8, '2007-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-2041.04', 'Stay abreast of the latest trends in music and music technology.', 'New', NULL, 9, '2007-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-3031.00', 'Post and update content on the company''s website and social media outlets.', 'Revision', 20556, 5, '2014-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-3041.00', 'Respond to questions from the public.', 'New', NULL, 8, '2017-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-3041.00', 'Write text, such as headlines, stories, articles, editorials, or newsletters.', 'Revision', 21000, 31, '2017-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-3043.04', 'Work with staff to develop advertising concepts.', 'New', NULL, 5, '2009-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1011.00', 'Provide guidance to patients on exercises they can perform to improve mobility.', 'New', NULL, 5, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1011.00', 'Take x-rays.', 'New', NULL, 6, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1022.00', 'Evaluate and treat problems related to the temperomandibular joint (TMJ).', 'New', NULL, 7, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1023.00', 'Advise patients to comply with treatment plans.', 'New', NULL, 13, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1024.00', 'Examine patients to diagnose oral health conditions and diseases.', 'New', NULL, 11, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1061.00', 'Place invasive intravascular monitors into patients.', 'New', NULL, 5, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1061.00', 'Teach anesthesiology principles to residents.', 'New', NULL, 12, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1065.00', 'Teach residents or medical students about pediatric topics.', 'New', NULL, 13, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1066.00', 'Perform mental health evaluations to provide information to courts of law on patients'' mental states.', 'New', NULL, 6, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1069.03', 'Direct or support quality improvement projects or safety programs.', 'New', NULL, 14, '2014-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1122.01', 'Teach self-advocacy skills to clients.', 'New', NULL, 6, '2014-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1126.00', 'Attend high-risk and caesarian section infant deliveries to provide neonatal respiratory care as needed.', 'New', NULL, 5, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1127.00', 'Evaluate oral motor function in infants.', 'New', NULL, 13, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1127.00', 'Supervise students or assistants.', 'New', NULL, 9, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1141.04', 'Provide coaching and mentoring to other caregivers to help facilitate their professional growth and development.', 'New', NULL, 4, '2013-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1161.00', 'Instruct student nurse-midwives, medical students, or residents on the birthing process.', 'New', NULL, 14, '2014-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2011.03', 'Archive diagnostic material, such as histologic slides and blocks.', 'New', NULL, 4, '2014-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2012.00', 'Perform quality control analyses to ensure accuracy of test results.', 'New', NULL, 8, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2021.00', 'Attend continuing education courses to maintain or update skills.', 'New', NULL, 7, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2031.00', 'Perform general administrative tasks, such as answering telephones, scheduling appointments, or ordering supplies or equipment.', 'Revision', 15234, 7, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2033.00', 'Schedule patients for nuclear medicine exams and procedures.', 'New', NULL, 8, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2035.00', 'Comfort patients during exams or request sedatives or other medication from physicians for patients with anxiety or claustrophobia.', 'Revision', 19234, 4, '2017-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2035.00', 'Review physicians'' orders to confirm prescribed exams.', 'New', NULL, 5, '2017-07-01', 'Occupational Expert');
GO
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2051.00', 'Attend interdisciplinary meetings with other health care professionals to discuss patient care.', 'New', NULL, 7, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2051.00', 'Observe and monitor patient food intake and body weight, and report changes, progress, and dietary problems to dietician.', 'Revision', 4164, 7, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2052.00', 'Enter prescription information into computer databases.', 'New', NULL, 5, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2054.00', 'Assist with intubations.', 'New', NULL, 6, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2055.00', 'Schedule surgical procedures for patients.', 'New', NULL, 5, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2055.00', 'Transport patients to and from the operating room.', 'New', NULL, 5, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2071.00', 'Scan patients'' health records into electronic formats.', 'New', NULL, 6, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2071.00', 'Schedule medical appointments for patients.', 'New', NULL, 5, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2092.00', 'Counsel patients and families on communication strategies and the effects of hearing loss.', 'New', NULL, 9, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2099.05', 'Educate patients on ophthalmic medical procedures, conditions of the eye, and appropriate use of medications.', 'New', NULL, 4, '2013-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2099.05', 'Perform ophthalmic triage in the office or via phone to assess severity of patients'' conditions.', 'New', NULL, 5, '2013-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-9011.00', 'Analyze incident data to identify trends in injuries, illnesses, accidents or other hazards.', 'New', NULL, 7, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-9091.00', 'Clean and sanitize athletic training rooms.', 'New', NULL, 5, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-9099.01', 'Perform annual gynecologic exams, including pap smears and breast exams.', 'New', NULL, 10, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-9099.01', 'Provide patients with contraceptive and family planning information.', 'Revision', 17497, 5, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('31-1011.00', 'Assist patients with toileting and incontinent care.', 'New', NULL, 7, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('31-1011.00', 'Feed patients.', 'New', NULL, 6, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('31-2021.00', 'Document patient information, such as notes on their progress.', 'New', NULL, 8, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('31-2021.00', 'Instruct patients in proper body mechanics and in ways to improve functional mobility, such as aquatic exercise.', 'New', NULL, 13, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('31-2021.00', 'Perform therapeutic wound care.', 'New', NULL, 7, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('31-9011.00', 'Maintain massage areas by restocking supplies or sanitizing equipment.', 'New', NULL, 6, '2015-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('31-9093.00', 'Order medical supplies for healthcare facilities or laboratories.', 'New', NULL, 6, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('31-9096.00', 'Place orders to restock inventory of hospital or laboratory supplies.', 'New', NULL, 6, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-1011.00', 'Conduct evaluations of employees'' performance.', 'New', NULL, 5, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-1021.02', 'Analyze burn conditions and results, and prepare postburn reports.', 'Revision', 7896, 5, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-1021.02', 'Plan, direct, and supervise prescribed burn projects.', 'Revision', 7896, 5, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-2011.01', 'Administer first aid and cardiopulmonary resuscitation to injured persons or provide emergency medical care such as basic or advanced life support.', 'Revision', 2063, 14, '2017-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-2011.02', 'Train new employees to control and suppress forest fires.', 'New', NULL, 6, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-2021.02', 'Teach fire investigation techniques to other firefighter personnel.', 'New', NULL, 8, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-2022.00', 'Conduct wildland firefighting training.', 'New', NULL, 7, '2006-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-2022.00', 'Educate the public about fire safety and prevention.', 'New', NULL, 9, '2006-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-3011.00', 'Arrest persons in court when arrest warrants have been issued.', 'New', NULL, 6, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-3011.00', 'Provide assistance to the public, such as directions to court offices.', 'New', NULL, 6, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-3012.00', 'Take fingerprints of arrestees, prisoners, or the general public.', 'New', NULL, 9, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-3021.02', 'Analyze and process evidence at crime scenes, during autopsies, or in the laboratory, wearing protective equipment and using powders and chemicals.', 'Revision', 2124, 13, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-3021.02', 'Create sketches and diagrams by hand or with computer software to depict crime scenes.', 'New', NULL, 5, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-3021.06', 'Analyze intelligence data to identify patterns and trends in criminal activity.', 'New', NULL, 4, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-3021.06', 'Conduct presentations of analytic findings.', 'New', NULL, 4, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-3041.00', 'Perform traffic control duties such as setting up barricades and temporary signs, placing bags on parking meters to limit their use, or directing traffic or pedestrians.', 'Revision', 7949, 5, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-3051.03', 'Conduct community programs for all ages concerning topics such as drugs and violence.', 'New', NULL, 7, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-9021.00', 'Serve documents to parties named in legal proceedings.', 'New', NULL, 5, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-9031.00', 'Develop and maintain log of surveillance observations.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-9031.00', 'Inspect and monitor audio or video surveillance equipment to ensure it is working appropriately.', 'New', NULL, 24, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-9031.00', 'Review video surveillance footage.', 'New', NULL, 12, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('35-2012.00', 'Monitor and record food temperatures to ensure safety of food.', 'New', NULL, 12, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('35-2012.00', 'Rotate and store food supplies.', 'New', NULL, 7, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('35-3011.00', 'Provide customers with directions or answers to questions.', 'New', NULL, 18, '2017-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('35-3021.00', 'Clean and organize eating, service, and kitchen areas and sweep and mop floors.', 'Revision', 18736, 27, '2017-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('35-9011.00', 'Greet and seat customers.', 'New', NULL, 5, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('35-9031.00', 'Assist other restaurant workers by serving food and beverages, or by bussing tables.', 'Revision', 18755, 9, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('37-3011.00', 'Move furniture.', 'New', NULL, 8, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('37-3012.00', 'Establish driving routes for pesticide applications.', 'New', NULL, 7, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('37-3012.00', 'Record information about pesticide applications, such as the type used and amount applied.', 'New', NULL, 9, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-2011.00', 'Teach owners how to train their dogs.', 'New', NULL, 13, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-2011.00', 'Teach people with visual impairments to use guide dogs.', 'New', NULL, 22, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-2021.00', 'Advise pet owners on how to care for their pets'' health.', 'New', NULL, 7, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-3011.00', 'Greet customers and make them feel welcome.', 'New', NULL, 21, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-3012.00', 'Provide race or game information to patrons.', 'New', NULL, 7, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-3012.00', 'Serve drinks to patrons.', 'New', NULL, 7, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-3021.00', 'Clean the projection booth.', 'New', NULL, 9, '2005-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-3021.00', 'Perform regular maintenance tasks such as rotating or replacing xenon bulbs, cleaning projectors and lenses, lubricating machinery, and keeping electrical contacts clean and tight.', 'Revision', 8036, 10, '2005-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-3092.00', 'Create patterns for costumes based on designer''s drawings.', 'New', NULL, 12, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-3092.00', 'Schedule costume fittings for actors.', 'New', NULL, 7, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-3093.00', 'Maintain or repair athletic equipment.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-4011.00', 'Clean and disinfect areas in which bodies are prepared and embalmed.', 'New', NULL, 10, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-5093.00', 'Assist hair stylists with chemical services, such as neutralizing perms and applying hair color.', 'New', NULL, 7, '2008-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-5093.00', 'Launder and fold the towels that are used for drying customers'' hair.', 'New', NULL, 11, '2008-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-5093.00', 'Refill and stock work stations with supplies, such as shampoos and conditioners.', 'New', NULL, 7, '2008-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-5093.00', 'Rinse out hair color or permanent solutions from customers'' hair.', 'New', NULL, 10, '2008-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-5093.00', 'Sweep hair from the salon floor.', 'New', NULL, 7, '2008-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-6012.00', 'Order flowers for guests.', 'New', NULL, 4, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-9011.01', 'Shop for groceries, clothing, and other items needed for children''s care.', 'New', NULL, 8, '2004-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-9021.00', 'Administer bedside or personal care, such as assistance with ambulation, dressing, feeding, or personal hygiene.', 'Revision', 2370, 18, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('41-2011.00', 'Answer incoming phone calls.', 'New', NULL, 7, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('41-2011.00', 'Help customers find the location of products.', 'New', NULL, 6, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('41-2011.00', 'Stock shelves, sort and re-shelve returned items, and mark prices on items and shelves.', 'Revision', 2420, 10, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('41-2012.00', 'Check identifications to verify age of players.', 'New', NULL, 6, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('41-2012.00', 'Clean casino areas.', 'New', NULL, 10, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('41-2012.00', 'Exchange money, credit, tickets, or casino chips and make change for customers.', 'Revision', 7000, 7, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('41-9012.00', 'Pose for artists and photographers either with or without clothes.', 'Revision', 13214, 5, '2007-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('41-9022.00', 'Contact previous clients for prospecting of referral business.', 'New', NULL, 6, '2009-06-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-3021.01', 'Return checks to customers or retrieve checks returned to customers in error, adjusting accounts and answering inquiries about errors as necessary.', 'Revision', 8141, 9, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-3021.02', 'Perform general administrative tasks, such as answering telephones, scheduling appointments, or ordering supplies or equipment.', 'New', NULL, 5, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-3051.00', 'Prepare and file payroll tax returns.', 'New', NULL, 5, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-3071.00', 'Answer telephones and assist customers with their questions.', 'New', NULL, 6, '2009-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-4041.01', 'Call customers to collect payment on delinquent accounts.', 'New', NULL, 8, '2005-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-4041.02', 'Call customers to collect past due payments.', 'New', NULL, 6, '2005-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-4111.00', 'Recruit participants for focus groups.', 'New', NULL, 5, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-4121.00', 'Plan or participate in library events and programs, such as story time with children.', 'New', NULL, 8, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-4171.00', 'Enter and update databases of contact information, such as names, addresses, and phone numbers.', 'New', NULL, 7, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-5041.00', 'Dig dirt away from meters to take readings.', 'New', NULL, 10, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-5041.00', 'Install new or replace broken meters.', 'New', NULL, 14, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-5051.00', 'Stock lobby with retail merchandise.', 'New', NULL, 7, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-5081.01', 'Receive, unload, open, unpack, or issue sales floor merchandise.', 'Revision', 2741, 7, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-5081.02', 'Arrange merchandise on sales floor for sale.', 'New', NULL, 12, '2006-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-5081.03', 'Operate equipment such as forklifts.', 'New', NULL, 6, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-5081.03', 'Rotate stock.', 'New', NULL, 5, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-5081.04', 'Stock bins or shelves.', 'New', NULL, 6, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-6011.00', 'Keep track of employees'' time.', 'New', NULL, 5, '2017-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-6012.00', 'Make travel arrangements for attorneys.', 'New', NULL, 7, '2010-06-01', 'Incumbent');
GO
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-6012.00', 'Prepare, proofread, or process legal documents, such as summonses, subpoenas, complaints, appeals, motions, or pretrial agreements.', 'Revision', 763, 6, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-9041.01', 'Enter insurance and claims related information into database systems.', 'Revision', 20787, 9, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-9081.00', 'Check the facts of stories using the internet.', 'New', NULL, 8, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-9081.00', 'Design page layouts using text, photographs, graphics, and other elements.', 'New', NULL, 11, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-9111.00', 'Present results of statistical analyses to stakeholders.', 'New', NULL, 10, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-9111.00', 'Write code for statistical applications.', 'New', NULL, 7, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('45-2021.00', 'Bathe and groom animals.', 'New', NULL, 7, '2005-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('45-2021.00', 'Exercise animals to keep them in healthy condition.', 'New', NULL, 8, '2005-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('45-2021.00', 'Purchase and stock supplies of feed and medicines.', 'New', NULL, 5, '2005-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('45-2092.01', 'Plant, spray, weed, fertilize, water, and prune plants, shrubs, and trees, using gardening tools.', 'Revision', 13372, 7, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('45-4011.00', 'Create field maps using geographic information systems technology.', 'New', NULL, 10, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('45-4023.00', 'Move logs using heavy equipment such as log loaders.', 'New', NULL, 7, '2017-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2011.00', 'Conduct pressure tests on vessels, such as boilers.', 'New', NULL, 7, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2041.00', 'Cut and install vinyl composition tile or vinyl base.', 'New', NULL, 13, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2043.00', 'Buff and vacuum floors to ensure their cleanliness prior to the application of finish.', 'New', NULL, 7, '2008-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2141.00', 'Clean tools and equipment, such as brushes and rollers.', 'New', NULL, 7, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2141.00', 'Hang wallpaper.', 'New', NULL, 7, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2152.01', 'Repair hydraulic or air pumps.', 'New', NULL, 5, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2152.01', 'Repair or remove and replace system components.', 'Revision', 4827, 8, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2171.00', 'Unload rebar from trucks.', 'New', NULL, 5, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2171.00', 'Use forklifts or cranes to move construction material, such as rebar.', 'New', NULL, 20, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2221.00', 'Assemble or inspect hoisting equipment or rigging, such as cables, pulleys, or hooks, to move heavy equipment or materials.', 'Revision', 11554, 5, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2221.00', 'Lift steel beams, girders, or columns using cranes or forklifts, or by signaling hoisting equipment operators to lift or position structural steel members.', 'Revision', 20795, 10, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-3012.00', 'Cut or weld metal.', 'New', NULL, 5, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-3013.00', 'Operate heavy equipment, such as backhoes.', 'New', NULL, 7, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-4071.00', 'Pump, clean, and repair septic tanks, sewer lines, or related structures such as manholes, culverts, and catch basins.', 'Revision', 11610, 5, '2017-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-4099.03', 'Determine amount of air leakage in buildings using a blower door machine.', 'New', NULL, 6, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-4099.03', 'Test combustible appliances, such as gas appliances.', 'New', NULL, 4, '2012-07-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-5013.00', 'Maintain and perform safety inspections on rigs, equipment, and other tools.', 'Revision', 20451, 7, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-5042.00', 'Monitor methane gas levels in mines to avoid carbon monoxide poisoning.', 'New', NULL, 12, '2005-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-5061.00', 'Check roof or ribs for hazardous conditions.', 'New', NULL, 10, '2017-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-5061.00', 'Clean equipment, such as dust collectors.', 'New', NULL, 7, '2017-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-5071.00', 'Clean trucks used in the fields.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-5071.00', 'Lay gas and oil pipelines.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-2095.00', 'Calibrate instruments, such as transmitters.', 'New', NULL, 6, '2017-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-3023.02', 'Perform motor oil changes.', 'New', NULL, 8, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-3023.02', 'Repair or rebuild transmissions.', 'New', NULL, 10, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-3031.00', 'Dismount, mount, and repair or replace tires.', 'New', NULL, 6, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-3051.00', 'Explain repair procedures to customers.', 'New', NULL, 6, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-3051.00', 'Repair or replace engine mechanical equipment, such as power tilts, water pumps, bilge pumps, or power take-offs.', 'Revision', 13770, 5, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-3052.00', 'Install motorcycle accessories.', 'New', NULL, 6, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-3091.00', 'Estimate costs of repairing bicycles and write service tickets.', 'New', NULL, 6, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-3091.00', 'Make adjustments to bicycles to improve customer fit and riding position.', 'New', NULL, 7, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-9041.00', 'Assign work schedules to work crews.', 'New', NULL, 8, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-9044.00', 'Align machines or equipment, using hoists, jacks, hand tools, squares, rules, micrometers, lasers, or plumb bobs.', 'Revision', 3042, 5, '2010-06-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-9045.00', 'Reline furnaces using ramming material.', 'New', NULL, 8, '2007-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-9052.00', 'Set up service for customers, installing, connecting, testing, or adjusting equipment, such as digital subscriber line modems.', 'Revision', 11850, 8, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-9061.00', 'Adjust or repair cameras, photographic mechanisms, or equipment such as range and view finders, shutters, light meters, or lens systems, using hand tools.', 'Revision', 8437, 15, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-9062.00', 'Inspect, test, or troubleshoot malfunctioning medical or related equipment, following manufacturers'' specifications and using test and analysis instruments.', 'Revision', 3061, 9, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-9062.00', 'Install medical equipment.', 'New', NULL, 6, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-9064.00', 'Order supplies, including replacement parts, for timing instruments.', 'New', NULL, 5, '2008-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-9096.00', 'Load machines onto trucks to prepare for transportation.', 'New', NULL, 6, '2007-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-9097.00', 'Test and repair track circuits.', 'New', NULL, 5, '2007-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-1011.00', 'Evaluate employee performance.', 'New', NULL, 12, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-3021.00', 'Clean and sanitize meat cases and cutting equipment.', 'New', NULL, 15, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-3022.00', 'Clean meat cutting equipment.', 'New', NULL, 11, '2017-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-4012.00', 'Order tooling for jobs.', 'New', NULL, 8, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-4031.00', 'Use equipment designed to join sheet metal, such as spot welders.', 'New', NULL, 6, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-4034.00', 'Clean work area.', 'New', NULL, 14, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-4034.00', 'Program computer numerical control machines.', 'New', NULL, 5, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-4081.00', 'Write programs for computer numerical control (CNC) machines to cut metal and plastic materials.', 'New', NULL, 7, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-4111.00', 'Fit and assemble parts to make, repair, or modify dies, jigs, gauges, and tools, using machine tools, hand tools, or welders.', 'Revision', 8494, 7, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-5111.00', 'Correct color in photographs or digital images.', 'New', NULL, 7, '2016-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-6042.00', 'Inspect finished products to ensure that shoes have been completed according to specifications.', 'New', NULL, 6, '2007-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-6051.00', 'Fit garments on clients, altering as needed.', 'New', NULL, 8, '2007-06-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-6061.00', 'Weigh ingredients, such as dye, to be mixed together for use in textile processing.', 'Revision', 14135, 5, '2007-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-6062.00', 'Inspect products to ensure that the quality standards and specifications are met.', 'Revision', 14151, 6, '2007-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-8099.03', 'Operate heavy equipment, such as bulldozers and front-end loaders.', 'New', NULL, 5, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-8099.03', 'Perform tests of water chemistry in boilers.', 'New', NULL, 6, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9011.00', 'Load products into tanks for shipment.', 'New', NULL, 5, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9023.00', 'Clean work areas.', 'New', NULL, 9, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9082.00', 'Order parts or supplies for orthotic or prosthetic devices.', 'New', NULL, 8, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9083.00', 'Tint lenses according to customer specifications.', 'New', NULL, 6, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9151.00', 'Adjust digital images using software.', 'New', NULL, 10, '2017-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9195.05', 'Attach handles to pottery pieces.', 'New', NULL, 6, '2008-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9195.05', 'Design spaces to display pottery for sale.', 'New', NULL, 5, '2008-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9195.05', 'Load glazed pieces into kilns for firing and unload finished pieces.', 'Revision', 15116, 10, '2008-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9195.05', 'Mix and apply glazes to pottery pieces using tools such as spray guns.', 'Revision', 15116, 10, '2008-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9195.05', 'Operate gas or electric kilns to fire pottery pieces.', 'New', NULL, 9, '2008-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9195.05', 'Pack and ship pottery to stores or galleries for retail.', 'New', NULL, 11, '2008-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9197.00', 'Buff tires according to specifications for width and undertread depth.', 'New', NULL, 6, '2007-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-2021.00', 'Monitor, direct, or sequence the movement of aircraft within an assigned air space or on the ground at airports to minimize delays and maximize safety.', 'Revision', 12729, 5, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-2022.00', 'Conduct inspections of the airport property and perimeter to maintain controlled access to airfields.', 'New', NULL, 7, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-2022.00', 'Initiate or conduct airport-wide coordination of snow removal on runways and taxiways.', 'New', NULL, 6, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-2022.00', 'Inspect airfield conditions to ensure compliance with federal regulatory requirements.', 'New', NULL, 21, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-2031.00', 'Monitor passenger behavior to identify threats to the safety of the crew and other passengers.', 'New', NULL, 13, '2012-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-3021.00', 'Announce stops to passengers.', 'New', NULL, 6, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-3021.00', 'Read maps to plan bus routes.', 'New', NULL, 6, '2010-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-3022.00', 'Record bus routes.', 'New', NULL, 7, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-3022.00', 'Report delinquent student behaviors to school administration.', 'New', NULL, 5, '2011-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-3032.00', 'Perform basic vehicle maintenance tasks, such as adding oil, fuel, or radiator fluid, performing minor repairs, or washing trucks.', 'Revision', 10653, 5, '2014-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-4012.00', 'Operate locomotives under the instruction of engineers.', 'New', NULL, 5, '2009-06-01', 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-4021.00', 'Conduct brake tests to determine the condition of brakes on trains.', 'New', NULL, 6, '2007-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-5021.02', 'Conduct safety drills such as man overboard or fire drills.', 'New', NULL, 6, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-6051.08', 'Visually inspect cargo for damage upon arrival or discharge.', 'New', NULL, 6, '2008-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-7021.00', 'Inspect crane site conditions to determine ground stability.', 'New', NULL, 6, '2015-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-7031.00', 'Perform maintenance on dredge equipment, such as changing engine oil.', 'New', NULL, 6, '2008-06-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-7062.00', 'Check freight, stock, or other materials for damage.', 'New', NULL, 6, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-7062.00', 'Take inventory of freight, stock, or other materials used on site.', 'New', NULL, 5, '2013-07-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-7064.00', 'Examine and inspect containers, materials, or products to ensure that product quality and packing specifications are met.', 'Revision', 3213, 7, '2011-07-01', 'Incumbent');
GO
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-7073.00', 'Change water filters.', 'New', NULL, 5, '2004-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-7073.00', 'Gauge oil and gas production.', 'New', NULL, 14, '2004-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-7073.00', 'Monitor pumps and flow lines for gas and fluid leaks.', 'New', NULL, 7, '2004-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-7111.00', 'Clean, fuel, service, and perform safety checks on all equipment, and repair and replace parts as necessary.', 'Revision', 5028, 16, '2004-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-7111.00', 'Examine roadway and clear obstructions from the path of travel.', 'New', NULL, 8, '2004-12-01', 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-7111.00', 'Handle high voltage sources and hang electrical cables.', 'New', NULL, 8, '2004-12-01', 'Incumbent');
GO

