CREATE TABLE tools_and_technology (
  onetsoc_code CHARACTER(10) NOT NULL,
  t2_type CHARACTER VARYING(10) NOT NULL,
  t2_example CHARACTER VARYING(150) NOT NULL,
  commodity_code DECIMAL(8,0) NOT NULL,
  hot_technology CHARACTER(1) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (commodity_code) REFERENCES unspsc_reference(commodity_code));
GO

INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Tools', 'Smartphones', 43191501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Tools', 'Universal serial bus USB flash drives', 43201813, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Adobe Systems Adobe Acrobat software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'AdSense Tracker', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'ComputerEase Construction Accounting', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Database reporting software', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Databox software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Exact Software Macola ES Labor Performance', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Graphic presentation software', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Halogen e360', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Halogen ePraisal', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'HCSS HeavyBid', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'HCSS HeavyJob', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Human resource information system HRIS software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Infor SSA Human Capital Management', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Intuit QuickBooks software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Listserv software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Lyris HQ Web-Analytics Solution', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Microsoft Dynamics AX', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Microsoft FRx', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Microsoft Great Plains software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Nedstat Sitestat', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Norchard Solutions Succession Wizard', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Online advertising reporting software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Oracle E-Business Suite', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Oracle Siebel Server Sync', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Sage Peachtree software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Tools', 'Computer data input scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Tools', 'Handheld computers', 43211715, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Tools', 'Smartphones', 43191501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Tools', 'Video teleconferencing systems', 45111902, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Technology', 'Microsoft Great Plains software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Technology', 'Scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Technology', 'Teleconferencing software', 43233502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1011.03', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tools', 'Cell phones', 43191501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tools', 'Computer scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tools', 'Credit card processing machines', 43211702, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tools', 'Digital cameras', 45121504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tools', 'Handtrucks', 24101504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tools', 'Humidity test chambers', 41103418, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tools', 'Magnetic card readers', 43211702, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tools', 'Point of sale POS systems', 43211505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tools', 'Profilometers', 41114508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tools', 'Spectrometers', 41115403, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tools', 'Surveillance cameras', 46171610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Tools', 'Vacuum test chambers', 41103305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'ActionWare', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Adobe Systems Adobe Photoshop software', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'AMG Teleran SalesInSync', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Apple Final Cut Pro', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Autodesk AutoCAD software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Avidian Technologies Prophet', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Calendar and scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Citrix software', 43232901, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'CNC Mastercam', 43232612, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Computer aided manufacturing CAM software', 43232612, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Customer information control system CICS', 43232313, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Datawatch Monarch', 43232307, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Deacom ERP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Dynamic Energy Systems MedAct', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'FrontRange Solutions Goldmine software', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Fund accounting software', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Google AdWords', 43231514, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Google Analytics', 43232307, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Human resources software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'IBM Notes', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'InnQuest Software roomMaster', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Inventory management software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Kronos Workforce Payroll', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Kronos Workforce Timekeeper', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'LexisNexis software', 43232309, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'LSA Visual Easy Lean', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Maximizer Software Maximizer Enterprise', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Microsoft Dynamics software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Microsoft Exchange Server', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Microsoft FrontPage', 43232107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'MicroStrategy software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Minitab software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Mozilla Firefox', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Mozilla Thunderbird', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Nagios', 43232801, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'NetSuite NetCRM', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Oracle Eloqua software', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Oracle Hyperion software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Oracle Primavera Enterprise Project Portfolio Management software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Payroll software', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Personnel scheduling software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Point of sale POS software', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'PostgreSQL software', 43232311, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Puppet', 43232401, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'R', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Realization Streamliner', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Sage 50 Accounting', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Sage ACT!', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Sage MAS 500', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Salesforce software', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Salesforce.com Salesforce CRM', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'SAP Business Objects software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'SAS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Savant MobileRanger', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'SeaMonkey', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Siemens NX for Manufacturing', 43232612, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Software on Sailboats Desktop Sales Manager', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Splunk Enterprise', 43233701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'SPSS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Sugar CRM software', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Sybase software', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Symantec security software', 43233205, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Tableau software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Tax software', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Vanguard Software Vanguard Sales Manager', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'vtiger CRM', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1021.00', 'Technology', 'Yardi software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Tools', 'Computer laser printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Tools', 'Wireless desktop printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Adobe Systems Adobe Acrobat software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Adobe Systems Adobe FrameMaker', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Antenna House software', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Apple iWork Keynote', 43232106, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Apple Numbers for Mac', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Apple Pages for Mac', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Cisco AnyConnect', 43232901, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Cisco Systems WebEx', 43233502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Citrix GoToMeeting', 43233502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Corel WordPerfect Office Suite', 43231513, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'GoodReader', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'iAnnotate', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'IBM Domino', 43232902, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Legislative Automative Workflow System LAWS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Mapping software', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Meeting scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Microsoft Exchange Server', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Microsoft SQL Server software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Penultimate', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'PTC Arbortext Editor', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Rocket/Folio NXT', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'Windows Media Player', 43232005, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-1031.00', 'Technology', 'XMetaL Author', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Tools', 'Notebook computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Tools', 'Scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Actuate software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Adobe Systems Adobe AfterEffects', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Adobe Systems Adobe Creative Suite software', 43232402, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Adobe Systems Adobe Flash Player', 43232107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Adobe Systems Adobe PageMaker', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Adobe Systems Adobe Photoshop software', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Adobe Systems Adobe Premiere Pro software', 43232103, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'AdRelevance software', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Apple Final Cut Pro', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Apple iMovie', 43232103, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Avid Media Composer', 43232103, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Brainworks software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Business analysis software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'ClarityBlue software', 43232307, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Constant Contact software', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Data warehousing software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Database software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Experience in Software Webplanner', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Google AdWords', 43231514, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Google DoubleClick', 43232314, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'IBM Lotus Notes', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'JavaScript', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'MarketSharp software', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Media Professional software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Mediamix software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Microsoft Marketing Pilot software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'PaloAlto Advertising Plan Pro', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Quark software', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Relex Weibull', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Tools', 'Computer data input scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Tools', 'Handheld computers', 43211715, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'Adobe Systems Adobe Photoshop software', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'Adobe Systems Adobe Reader', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'Facebook', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'Inventory tracking software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'LinkedIn', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'Microsoft SQL Server', 43232304, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'Scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'Twitter', 43233504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2011.01', 'Technology', 'WordPress', 43232107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Tools', 'Desktop computers', 43211507, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Tools', 'Notebook computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Tools', 'Photocopiers', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Tools', 'Scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Adobe Systems Adobe ActionScript', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Adobe Systems Adobe AfterEffects', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Adobe Systems Adobe Fireworks', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Adobe Systems Adobe Flash', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Adobe Systems Adobe Photoshop software', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Adobe Systems Adobe Reader', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'AdSense Tracker', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Apache Cassandra', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Apache Hive', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Apache Pig', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Apple Final Cut Pro', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Armand Morin MultiTrack Generator', 43232313, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Cascading Style Sheets CSS', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Citrix software', 43232901, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'ClearEDGE software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Constant Contact software', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Database reporting software', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Databox software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Delphi software', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Drupal', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Dynamic hypertext markup language DHTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Extensible HyperText Markup Language XHTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Facebook', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Fast Track Systems software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Google AdWords', 43231514, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Google Analytics', 43232307, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'IBM Notes', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'JavaScript', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'LexisNexis software', 43232309, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'LinkedIn', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Lyris HQ Web-Analytics Solution', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'MarketSharp software', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'McAfee software', 43233205, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Microsoft Dynamics software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'MicroStrategy software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Minitab software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'MySQL software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Nedstat Sitestat', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'NoSQL software', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Online advertising reporting software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Oracle Beehive', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Oracle Eloqua software', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Oracle JavaServer Pages JSP', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Oracle PL/SQL', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Oracle Siebel Server Sync', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'QAD Marketing Automation', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'R', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Sage SalesLogix', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Salesforce software', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Salesforce.com Salesforce CRM', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'SAP Business Objects software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'SAS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Splunk Enterprise', 43233701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'SPSS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Swift', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Symantec security software', 43233205, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Tableau software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Teradata Database', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'Yardi software', 43232306, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2021.00', 'Technology', 'YouTube', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Tools', 'Notebook computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Tools', 'Scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Adobe Systems Adobe Flash', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Avidian Technologies Prophet', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Bentley MicroStation', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Contact management software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Delphi Discovery', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Delphi software', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Eclipse software', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Eden Sales Manager', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Facebook', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'FrontRange Solutions Goldmine software', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Google AdWords', 43231514, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Google Analytics', 43232307, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Hewlett-Packard HP TCM software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'IBM Notes', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Inventory software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'LexisNexis software', 43232309, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'LinkedIn', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Maximizer Software Maximizer Enterprise', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Microsoft Dynamics software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'MicroStrategy software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Minitab software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'NetSuite NetCRM', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Oracle Eloqua software', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Oracle Hyperion software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Oracle Primavera Enterprise Project Portfolio Management software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Sage 50 Accounting', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Sage ACT!', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Salesforce software', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Salesforce.com Salesforce CRM', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'SAP Business Objects software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'SAS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Software on Sailboats Desktop Sales Manager', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'SPSS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Symantec security software', 43233205, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Tableau software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Tax software', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Vanguard Software Vanguard Sales Manager', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Workforce management software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'Yardi software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2022.00', 'Technology', 'YouTube', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Tools', 'Computer scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Adobe Systems Adobe Acrobat software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Adobe Systems Adobe Distiller', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Adobe Systems Adobe Fireworks', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Adobe Systems Adobe Flash Player', 43232107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Adobe Systems Adobe PageMaker', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Adobe Systems Adobe Photoshop software', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Apple Final Cut Pro', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Apple iDVD', 43232103, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Apple iMovie', 43232103, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Blackbaud eTapestry', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Corel WordPerfect Office Suite', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Drupal', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Facebook', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Google AdWords', 43231514, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Google Analytics', 43232307, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Google Gmail', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'IBM Notes', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'LinkedIn', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Novell GroupWise', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Oracle Eloqua software', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Oracle Siebel Server Sync', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'QuarkXPress', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Salesforce software', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-2031.00', 'Technology', 'YouTube', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Tools', 'Mobile phones', 43191501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Tools', 'Notebook computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Tools', 'Scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Adobe Systems Adobe Acrobat software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Adobe Systems Adobe PageMaker', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'ADP Enterprise HRMS', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Autodesk AutoCAD software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Delphi software', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Fund accounting software', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'IBM Notes', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Microsoft Windows XP', 43233004, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Minitab software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Novell GroupWise', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'PracticeWorks Systems Kodak WINOMS CS', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Sage 300 Construction and Real Estate', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Sage 50 Accounting', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Sage MAS 200 ERP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Sage Peachtree software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'SPSS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3011.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Access servers', 43222625, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Computer servers', 43211501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Computer tool kits', 27113203, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'File servers', 43211501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Industry standard architecture/peripheral component interconnect ISA/PCI cards', 43201407, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Inkjet printers', 43212104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Internet Information Services IIS Servers', 43211501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Laser printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Mainframe computers', 43211512, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Mid-range computers', 43211501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Minicomputers', 43211501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Netware servers', 43211501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Network analyzers', 41113711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Network interface cards NIC', 43201404, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Network routers', 43222609, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Network switches', 43222612, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Photocopiers', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Print servers', 43201537, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Punchdown tools', 27111505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Robot automation tool', 43222627, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Screwdrivers', 27111701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Storage servers', 43211501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Teleconferencing equipment', 43221522, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Web servers', 43211501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Tools', 'Workstations', 43211502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'ACT! software', 43232303, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Adobe Systems Adobe Distiller', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Adobe Systems Adobe Flex', 43232408, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Advanced business application programming ABAP', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'AlphaFour software', 43232304, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Apache Cassandra', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Apache HTTP Server', 43232312, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Apache Pig', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Apache Solr', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Apache Tomcat', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Apple Final Cut Pro', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Apple iMovie', 43232103, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Apple iWork Keynote', 43232106, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Apple iWork Numbers', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Apple iWork Pages', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Apple Macintosh OS/X', 43233004, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Assembler', 43232402, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Billing software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Blackboard software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Borland Paradox', 43232405, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'C', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'C#', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'C++', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'CA Erwin Data Modeler', 43232310, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Cisco Systems WAN Manager', 43232909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Citrix software', 43232901, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Common business oriented language COBOL', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Corel Office Suite', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Customer information control system CICS', 43232313, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Dartware InterMapper', 43232801, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Drupal', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Dynamic hypertext markup language DHTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Eclipse software', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Embarcadero Delphi', 43232405, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Enterprise JavaBeans', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Extensible HyperText Markup Language XHTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Firewall software', 43233204, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Ftp program software', 43233001, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Google Analytics', 43232307, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Help desk software', 43231501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Hewlett Packard HP-UX', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Hyperion software', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'IBM InfoSphere DataStage', 43232403, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'IBM iSeries Access', 43232915, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'IBM WebSphere', 43232403, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Infor ERP Baan', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'iPlanet Web Server software', 43232312, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'JavaScript', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'K2 Business Process Automation', 43232402, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'KornShell', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'LAMP Stack', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'LAN software', 43232905, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Langlais Computer Consultants CalMan', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Linux', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Linux-based email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Mac HelpMate', 43232901, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'McAfee software', 43233205, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft .NET Framework', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Active Server Pages ASP', 43232408, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Business Contact Manager', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Dynamics AX', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Dynamics CRM', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Dynamics NAV', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Dynamics software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Entourage', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Exchange Server', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Front Page', 43232107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Office SharePoint Server MOSS', 43233503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft SQL Server Reporting Services SSRS', 43232405, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft SQL Server software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Visual Basic Scripting Edition VBScript', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Visual FoxPro', 43232311, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Visual Studio', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Windows Server', 43232701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'MicroStrategy software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Mobile wireless network infrastructure software', 43232910, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'MongoDB', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'MySQL software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Nagios', 43232801, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Netscape Navigator', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Node.js', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'NoSQL software', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Novell network software', 43233002, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Objective C', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Oracle DBMS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Oracle E-Business Suite', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Oracle Eloqua software', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Oracle Hyperion software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Oracle Java', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Oracle PL/SQL', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Oracle Primavera Systems software', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Oracle Siebel Server Sync', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Oracle Solaris', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Oracle WebLogic Server', 43232701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Pegasus software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Performance Solutions Technology ManagePro', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Pilgrim Software Pilgrim SmartSolve software', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Plumtree software', 43232312, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'PostgreSQL software', 43232311, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Practical extraction and reporting language Perl', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Progress OpenEdge ABL', 43232402, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Progress OpenEdge Application Server', 43232701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Progress OpenEdge Fathom Replication software', 43232304, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Progress Sonic ESB', 43232403, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Progress WebSpeed Workshop', 43232408, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Puppet', 43232401, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Python', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'QUALCOMM Eudora', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'R', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Red Hat Enterprise Linux', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Red Hat WildFly', 43232701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Relational database management software', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Ruby on Rails', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Samba', 43233001, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'SAP Business Objects software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'SAS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'SolarWinds software', 43232804, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'SOX COBIT', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Splunk Enterprise', 43233701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'SPSS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Sybase software', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Symantec security software', 43233205, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Symantec Veritas File System', 43233001, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Symantec Veritas Volume Manager', 43233001, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Tableau software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Telnet programs software', 43232911, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Teradata Database', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Tk software', 43232404, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Unified modeling language UML', 43232407, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'UNIX', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Veritas NetBackup', 43233415, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Virtual private networking VPN software', 43233204, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3021.00', 'Technology', 'Zephyr EXTRA! Terminal Emulation', 43232911, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Tools', 'Notebook computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'ADERANT Expert Back Office, Powered by Keystone', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Automatic Data Processing EasyPay software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Automatic Data Processing PC payroll for windows PCPW', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Corel QuattroPro', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Deltek software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Exact Software Macola ES', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'FRx Software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Fund accounting software', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Hyperion Enterprise', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Hyperion Pillar software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Hyperion Solutions System 9 Planning', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'IBM Lotus 1-2-3', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Infor ERP SyteLine', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Job costing software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Microsoft Dynamics software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Microsoft Office SharePoint Server MOSS', 43233503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'MYOB Premier Accounting Small Business Suite', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Oracle Hyperion software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Oracle PeopleSoft Financials', 43231602, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Oracle Primavera Enterprise Project Portfolio Management software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Sage 50 Accounting', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Sage Fixed Asset Solution FAS', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Sage MIP Fund Accounting', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Solomon Software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.01', 'Technology', 'Yardi software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Tools', 'Notebook computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Tools', 'Scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Accounts receivable software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'ARES Corporation PRISM Project Estimator', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Credit management software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Delphi software', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Fund accounting software', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Healthcare common procedure coding system HCPCS software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Human resource information system HRIS software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'IBM Notes', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Internet browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'LexisNexis software', 43232309, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Microsoft Dynamics software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'MicroStrategy software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Moody''s KMV FAMAS', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Oracle Hyperion software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Sage 50 Accounting', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Salesforce software', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'SAP Business Objects software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'SAS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'SPSS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Tableau software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Tax software', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Word processing software', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3031.02', 'Technology', 'Yardi software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Tools', 'Forklifts', 24101603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Tools', 'Notebook computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Tools', 'Scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Tools', 'Squares', 27111803, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Tools', 'Tape measures', 27111801, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Tools', 'Taper gauges', 41111648, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Tools', 'Vernier calipers', 41111621, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'ABB Optimize software', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Adobe Systems Adobe AfterEffects', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Adobe Systems Adobe Photoshop software', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Apple Final Cut Pro', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Citect IIM', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'CitectSCADA Reports', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'CitectSCADA software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Clockware software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Computer aided design CAD software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Computer integrated manufacturing CIM software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Computer integrated manufacturing CIM time manager software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Computer integrated manufacturing CIM warehouse shipping manager software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'CorVu software', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Database software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Employee performance management software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Exact Software JobBOSS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Financial planning software', 43231604, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'IBM Rational ClearQuest', 43232402, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Industrial production manager and stock control software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Intuit QuickBooks Manufacturing & Wholesale software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Marel production system MPS software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Minitab software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Plant management software', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'ProcessPro Premier', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Prosys software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'QUMAS software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'SAP inventory software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Scadex Technologies MAESTRO', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Statistical process control software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'Wonderware DT Analyst Plant Productivity Improvement Software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.00', 'Technology', 'WorkSchedule software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Tools', 'Automated diluters', 41121502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Tools', 'Automated microplate ELISA readers', 41113037, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Tools', 'Cellular assay equipment', 41115819, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Tools', 'Computer inkjet printers', 43212104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Tools', 'Electrophoresis equipment', 41105307, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Tools', 'Fourier transfer infrared FTIR spectrometers', 41115408, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Tools', 'Gas chromatography equipment', 41115703, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Tools', 'Handheld data collectors', 43211715, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Tools', 'Infrared spectroscopic equipment', 41115403, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Tools', 'Laboratory analytical balances', 41111517, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Tools', 'Laboratory benchtop centrifuges', 41103903, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Tools', 'Laboratory extraction equipment', 41104806, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Tools', 'Laboratory moisture balances', 41111513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Tools', 'Liquid chromatography equipment', 41115705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Tools', 'pH analyzers', 41115603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Tools', 'Titrators', 41115602, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Adobe Systems Adobe Acrobat software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'ASI DATAMYTE GageMetrics', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'ASI DATAMYTE QDA software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'ASIDATAMYTE DataMetrics', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Atlassian JIRA software', 43232201, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'CAMA Software Quality Collaboration By Design software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'CEBOS MQ1 software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Computing Solutions LabSoft LIMS', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Core Informatics Laboratory Information Management System LIMS software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'EtQ Reliance software', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Harrington Group caWeb software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Harrington Group HQMS software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Hewlett Packard LoadRunner', 43232406, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Illumina Laboratory Information Management System LIMS software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Infinity QS ProFicient software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Lablite Laboratory Information Management Systems LIMS software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Laboratory Automated Quality Control Systems LAQC software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Labvantage Solutions LIMS', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Linux', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'MasterControl software', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Minitab software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Oracle Java', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Pearson Education PHStat2', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'PQ Systems CHARTrunner Lean', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'PQ Systems GAGEpack', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'PQ Systems MEASUREspy', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'PQ Systems SQCpack', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Promium Element DataSystem LIMS', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Quality Systems International WinLIMS', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Sparta Systems TrackWise', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'STARLIMS software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'StatGraphics software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Systat Software Lisa.lims', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Thermo Fisher Scientific Laboratory Information Management Systems (LIMS) software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Vivaldi Software Vivaldi Quality Management Software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.01', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Tools', 'Dataloggers', 43211715, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Tools', 'Diesel-powered generators', 26111601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Tools', 'Forklifts', 24101603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Tools', 'Large volume water pumps', 40151510, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Tools', 'Material moving cranes', 24101623, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Tools', 'Mobile radios', 43191510, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Tools', 'Programmable logic controllers PLC', 32101628, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Technology', 'Datalogging software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Technology', 'Infostat RIMBase', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.02', 'Technology', 'Personnel scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Air monitoring equipment', 41104008, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Ball valves', 40141607, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Belt conveyor systems', 24101712, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Dust and particulate respirators', 46182002, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Electric timing devices', 46171603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Emergency alarm systems', 46171604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Fermentation processing vessels', 41104301, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Flow control valves FCV', 40141609, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Forklifts', 24101603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Gate butterfly valves', 40141613, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Glass graduated cylinders', 41121805, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Gravity convection ovens', 41104501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Hand sampling pumps', 40151506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Hazardous material spill kits', 47131905, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Mobile radios', 43191510, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Moisture analyzers', 41112304, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Mole sieves', 41105003, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'pH probes', 41115603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Reaction flasks', 41121804, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Sample ports', 41104015, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Self-contained breathing apparatus', 46182004, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Stop valves', 40141611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Tools', 'Throttle control valves TCV', 40141609, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Technology', 'Autodesk AutoCAD software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Technology', 'Computerized maintenance management system CMMS software', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Technology', 'Distributed control systems DCS software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Technology', 'Employee scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Technology', 'Human machine interface HMI software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Technology', 'Inventory control software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.03', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Tools', 'Biomass boilers', 40102001, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Tools', 'Bubbling fluidized bed boilers', 40102001, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Tools', 'Circulating fluidized bed boilers', 40102001, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Tools', 'Cooling towers', 40101703, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Tools', 'Heat recovery steam generators', 26111608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Tools', 'Radial stackers', 24101708, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Tools', 'Steam boilers', 40102002, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Tools', 'Steam turbines', 26101505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Tools', 'Water samplers', 41104007, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Tools', 'Wood feed systems', 22101715, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Technology', 'Computer aided design CAD software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Technology', 'Computerized maintenance management system CMMS software', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Technology', 'Distributed control systems DCS software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Technology', 'Employee scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Technology', 'Inventory control software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.04', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Tools', 'Air samplers', 41104008, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Tools', 'All terrain vehicles ATV', 25101905, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Tools', 'Combustible gas monitors', 26131701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Tools', 'Diesel reciprocating engine generator sets', 26111601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Tools', 'Enclosed flares', 26131608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Tools', 'Gas leak detectors', 46171613, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Tools', 'Gas reciprocating engine generator sets', 26111604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Tools', 'Micro anemometers', 41114401, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Tools', 'Multiple gas monitors', 41113118, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Tools', 'Notebook computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Tools', 'Open flares', 26131608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Tools', 'Oxygen analyzers', 41113110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Tools', 'Pressure gauges', 41111927, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Tools', 'Pressure valves', 40141604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Tools', 'Utility trucks', 25101507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Technology', 'Computerized maintenance management system CMMS software', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Technology', 'Distributed control systems DCS software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Technology', 'Employee scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Technology', 'Landfill gas analysis software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Technology', 'Landtec System Software LFG Pro', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.05', 'Technology', 'WorkTech MAXIMO', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Tools', 'Dam water flow controls', 40142207, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Tools', 'Desktop computers', 43211507, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Tools', 'Electrical circuit breakers', 39121601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Tools', 'Electrical switch gear', 26131808, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Tools', 'Hydraulic power generation equipment', 26111606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Tools', 'Hydroelectric power generator controls', 26131803, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Tools', 'Impulse turbines', 26101506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Tools', 'Mobile radios', 43191510, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Tools', 'Power transformers', 39121002, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Tools', 'Protective ear muffs', 46181902, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Tools', 'Protective respirators', 46182002, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Tools', 'Reaction turbines', 26101506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Tools', 'Safety glasses', 46181802, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Tools', 'Turbine generators', 26101506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Technology', 'Computerized maintenance management system CMMS software', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Technology', 'Distributed control systems DCS software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Technology', 'Personnel scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3051.06', 'Technology', 'Supervisory control and data acquisition SCADA software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Ariba Spend Management Suite', 43231503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Automated purchase order software', 43231503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Bottomline Technologies Bottomline Sprinter Purchasing Manager', 43231503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Bowen & Groves M1 ERP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Corel Paradox', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Database software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Epicor Vantage ERP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'IBM Lotus Notes', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Infor Lawson Supply Chain Management', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Inventory management software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Material requirement planning MRP software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Oracle DBMS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Oracle PeopleSoft', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Oracle PeopleSoft Enterprise Financial Management Solutions', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Oracle Primavera P6 Enterprise Portfolio Project Management', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Point of sale POS software', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Purchasing software', 43231503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'PurchasingNet eProcurement', 43231503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3061.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Tools', 'Barcode scanners', 43211701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Tools', 'Barcoding labels', 55121608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Tools', 'Forklifts', 24101603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Tools', 'Radio frequency handheld terminals', 43221721, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Tools', 'Radio frequency identification RFID devices', 43211710, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Tools', 'Radio frequency truck-mounted terminals', 43221721, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Tools', 'Wireless communication and satellite positioning tools', 43223209, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'ABOL Manifest Systems', 43231510, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Airline Global Distribution System GDS software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'ALK Technologies FleetSuite', 43232504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'ALK Technologies PC*Miler', 43232504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Amber Road software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Argos Software ABECAS Insight Freight Management System FMS (accounting feature)', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Argos Software ABECAS Insight Freight Management System FMS (calendar and scheduling feature)', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Automated expense reporting system software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Bentley MicroStation', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Bentley Transportation Data Manager', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Cadre Technologies Cadence Transportation Management System', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'CoPilot Truck', 43232504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Eaton Fleet Advisor', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Fleetware software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Freight Rail Crew Optimization Scheduling FRCOS software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Geometrix', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Graphics software', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'IBM i2 Transportation Manager', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'IBM Lotus Notes', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'IMSure Solutions SHIPflex', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Infosite Technologies Dispatch-Mate', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Integrated Decision Support Corporation Expert Fuel', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Integrated Decision Support Corporation Netwise Supply Chain', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Integrated Decision Support Corporation Route Advice', 43232504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Integrated Decision Support Corporation Swap Advice', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Integrated Decision Support Match Advice', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Integrated Decision Support Netwise Enterprise', 43232605, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Integrated Decision Support Netwise Frontline', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Intergraph GeoMedia Transportation Manager', 43232504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'International Business Systems software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Labelmaster Software REG-Trieve', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'QUALCOMM QTRACS', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'QUALCOMM ViaWeb', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Scanlon Associates LogPak', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Shipping Solutions software', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Spreadsheet software', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Summary Systems Fleet Commander', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Supply chain event management software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'TMW PowerSuite', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'Word processing software', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.01', 'Technology', 'WorkForce Software EmpCenter Time and Attendance', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Tools', 'Barcode scanners', 43211701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Tools', 'Barcoding labels', 55121608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Tools', 'Cell phones', 43191501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Tools', 'Digital cameras', 45121504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Tools', 'Forklifts', 24101603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Tools', 'Global positioning systems GPS', 25173107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Tools', 'Pallet jacks', 24101505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Tools', 'Radio frequency handheld terminals', 43221721, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Tools', 'Radio frequency identification RFID devices', 43211710, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Tools', 'Radio frequency truck-mounted terminals', 43221721, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Tools', 'Wireless communication and satellite positioning tools', 43223209, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'ABOL Manifest Systems', 43231510, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Aljex Inventory', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Cadre Technologies Cadence Warehouse Management System', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Catalyst International CatalystConnect', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'DSA Foxware Warehouse Management', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Graphics software', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Hewlett Packard HP-UX', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'HighJump Software Warehouse Advantage', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'IBM i2 Transportation Manager', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'IBM Lotus Notes', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Infor ERP Baan', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Infosite Technologies DM Warehousing', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Integrated Decision Support Corporation Netwise Supply Chain', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Integrated Decision Support Corporation Swap Advice', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Integrated Decision Support Netwise Enterprise', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Integrated Decision Support Netwise Frontline', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'IntelliTrack Warehouse Management System', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'International Business Systems software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Logility Voyager WarehousePRO', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Materials requirements planning logistics and supply chain software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Microsoft Great Plains software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'MRA Technologies MRATrack Warehouse Management System', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'QUALCOMM QTRACS', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'QUALCOMM ViaWeb', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Radio Beacon WMS', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'RedPrairie DLx Warehouse', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Scanlon Associates LogPak', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Sentai Pinpoint', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Spreadsheet software', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'SSA Global Warehouse Management System WMS', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Supply chain event management software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'TECSYS EliteSeries', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'TECSYS PointForce Enterprise', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Veritas NetBackup', 43233415, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'Word processing software', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.02', 'Technology', 'WorkForce Software EmpCenter Time and Attendance', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Tools', 'Personal protective equipment', 46181509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Tools', 'Photocopiers', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', '3PL Central', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Cadre Technologies Accuplus Integrated Distribution Logistics System', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Database software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'ESRI ArcLogistics', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'FedEx Ship Manager', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Four Soft 4S eLog', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Four Soft 4S VisiLog', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Infor ERP Baan', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'IntelliTrack 3PL', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Inventory control software', 43231508, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Logisuite Enterprise', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Logisuite Forwarder', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Materials resource planning MRP software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Microsoft Dynamics AX', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Microsoft SQL Server', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Optimization software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Oracle E-Business Suite Logistics', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Presentation software', 43232106, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'SAP BusinessObjects software', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'SAP ERP Operations', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Spreadsheet software', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Transportation management system TMS software', 43233511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Transtek Compass ERP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'UPS WorldShip', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'USPS.com', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3071.03', 'Technology', 'Warehouse management system WMS software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Tools', 'Liquid crystal display LCD video projectors', 45111614, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Tools', 'Notebook computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Tools', 'Optical disk drives', 43201811, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Tools', 'Scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Tools', 'Universal serial bus USB flash drives', 43201813, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', '!Trak-it Solutions !Trak-it HR', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Adobe Systems Adobe Flash Player', 43232107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Adobe Systems Adobe PageMaker', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Adobe Systems Adobe Photoshop software', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'ADP Employease', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'ADP HR/Benefits Solution', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'AdRelevance software', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Apex Business Software iHR', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Apple iMovie', 43232103, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Ascentis HR', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'ASL HR Director', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Atlas Business Solutions Staff Files', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Auxillium West HRnetSource', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Blue Chip Computer Consultants HumaNET', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Brainworks software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Business analysis software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Ceridian software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'ClarityBlue software', 43232307, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Consultants in Data Processing HRnet', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Datamatics V-Core HR', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Deltek Costpoint', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'DenoSys HRiStragegy', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Document management system software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'e-MDs Bill', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Experience in Software Webplanner', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'FSC Business Solutions Department Managers'' Toolkit', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Genesys PeopleComeFirst', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Global Groupware Solutions Limited Smiles ERM On-Demand', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'HarrisData Human Resources Information System HRIS', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'HR-ease', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'HRMS Solutions iVantage', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'hSenid Business Solutions HRM Enterprise', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Human resource information system HRIS software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Humanic Design Human Resources Management System', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'IBM Notes', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'iEmployee', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Intuit QuickBooks software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Jenss & Associates CompKeeper', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Lawson Human Resource Management', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Mangrove Software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'McKesson NDCLytec software', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Media Professional software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Mediamix software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Microsoft Great Plains software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Microsoft Marketing Pilot software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'NOW Solutions emPath', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Nuview Systems Cort HCM', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'NuView Systems NuViewHR', 43231505, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Oracle E-Business Suite', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Oracle Hyperion software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'OrangeHRM', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'PaloAlto Advertising Plan Pro', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'PDS Vista HRMS', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'People-Trak HR Essentials', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'PerfectSoftware PerfectHR', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Piney Creek Digital Protocol System', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'PSTek software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Quadkey HR Server', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Quark software', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Relex Weibull', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Sage Abra HRMS', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Saigun Technologies EmpXtrack', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Sentient Online MarketPrice', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Trigon Road Forte Leave Management', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'UCN inContact Workforce Management Software WFM', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Ultimate Software UltiPro', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Vantage Point Software HRA', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3111.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Tools', 'Audio recording equipment', 46171621, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Tools', 'Notebook computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Tools', 'Scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'AASoftTech Web Organization Chart', 43232105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'AccountantsWorld Payroll Relief', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'ADP Enterprise HR', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'ADP ezLaborManager', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'ADP HR/Benefits Solution', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'ADP HR/Profile', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'ADP Pay eXpert', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'AllNetic Working Time Tracker', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Applicant Tracking Systems ATS software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Arrow Electronics N/Compass', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Atlas Business Solutions Staff Files', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Authoria Adviser', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Automation Centre Personnel Tracker', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Ceridian software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Corel WordPerfect software', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Data Management TimeClock Plus software', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Defense Travel System', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Deltek Vision', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Exact Software Macola ES Labor Performance', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Fidelity HR/Payroll', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Focus software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Halogen e360', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Halogen ePraisal', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Harpers Payroll Services HR la Carte', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Human resource information system HRIS software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'IBM Lotus 1-2-3', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'IBM Notes', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Inception Technologies InfiniTime', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Infor ERP SyteLine', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Infor SSA Human Capital Management', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Infotronics Attendance Enterprise', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'interactive Personnel Electronic Records Management System iPERMS', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Intuit QuickBooks software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'iSystems Evolution Payroll and Tax Management', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Jantek Electronics Jupiter Time & Attendance', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Kronos Enterprise Workforce Management', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Kronos Workforce Timekeeper', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Lawson Human Resource Management', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Lawson Human Resources Suite', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'LinkedIn', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Microsoft Great Plains software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Microsoft Office SharePoint Server MOSS', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Midrange Software XpertHire', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'New World Systems Logos.NET', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Norchard Solutions Succession Wizard', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Nuvosoft Rwiz', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Oracle HRIS', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Paychex software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Paycor Payroll Management software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Paylocity Web Pay', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'PDF readers', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'People-Trak software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'peoplefluent Performance', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'peoplefluent Recruiting', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Pereless Systems software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Qqest TimeForce', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'QuestionMark software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Qwiz software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Sage Abra HRMS', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Sage Peachtree software', 43231601, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Savitr RecruitX', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Soft Trac Microix Timesheet', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Standard Installation and Division Personnel Reporting System SIDPERS', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Stratitec TimeIPS', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Stromberg Enterprise', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Taleo Enterprise Talent Management Suite', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Tesseract Benefits Manager', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Tesseract Human Resources Manager', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Total Officer Personnel Management Information System TOPMIS', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Training software', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Tyler Technologies MUNIS', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'UCN inContact Workforce Management Software WFM', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Ultimate Software UltiPro Workplace', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Unicorn HRO Open4', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'UniFocus Watson Human Resources Manager', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'WhizLabs software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3121.00', 'Technology', 'WinOcular software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Tools', 'Liquid crystal display LCD video projectors', 45111614, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Tools', 'MP3 players', 52161543, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Tools', 'Universal serial bus USB flash drives', 43201813, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Tools', 'Videoconferencing equipment', 45111902, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Adobe Systems Adobe Acrobat software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Adobe Systems Adobe Captivate', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Adobe Systems Adobe Fireworks', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Adobe Systems Adobe Flash', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Adobe Systems Adobe Flash Player', 43232107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Adobe Systems Adobe Photoshop software', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Adobe Systems Adobe Presenter', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'AgileView Software SmartView', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Alchemy Systems SISTEM', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Apache Cassandra', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Articulate Rapid E-Learning Studio', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Beeline Learning Management System LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Blackboard software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Blatant Media Absorb LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Brainshark Rapid Learning', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Caliban Mindwear HyperGASP', 43232106, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Cisco Systems WebEx', 43233502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Cobent Learning and Compliance Suite LCS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Computer Generated Solutions Learning Management System', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Cornerstone OnDemand Cornerstone Learning', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Dazzlersoft DazzlerMax', 43232106, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'dominKnow Learning Center', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Eedo Knowledgeware Eedo Force Ten', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'ElearningForce JoomlaLMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'eXe', 43232107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'EZ LCMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'FlexTraining Total e-Learning Solution', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Flying PopCorn', 43232106, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Freeze.com Ovation Studio Pro', 43232106, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'FunEducation Outstart Trainer', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'G-Cube Solutions Wizdom Web LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'GeoMetrix Data Systems Training Partner', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'HP TRIM software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'HunterStone THESIS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'ICS Learning Group Inquisiq EX', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Ikonami AT-Learning Tool', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'iLinc Communications LearnLinc', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Inspired eLearning iLMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Intelladon Enterprise Knowledge Platform EKP', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Intelligent Information Conversion Technologies MeritScholar', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Intellum Rollbook', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'JavaScript', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Kookaburra Studios Knowledge Presenter', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'LeanForward LearnPoint', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Learn HQ Activate LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Learn.com CourseMaker Studio', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Learn.com LearnCenter Talent Management Suite', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Linspire Nvu', 43232107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Magenta MultiMedia Tools Magenta II', 43232106, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'MediaChance Multimedia Builder', 43232106, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Medworxx Learning Management System', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Microsoft FrontPage', 43232107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Moodle', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Mzinga On-Demand Learning Suite', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'NetDimensions Enterprise Knowledge Platform EKP', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'OnPoint Digital OnPoint Learning & Performance Suite', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Open e-LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Operitel LearnFlex', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Pathlore LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Plateau Learning Management System LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'PRO-ductivity Systems Compliance Training Manager Web', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Rapid Intake Unison', 43232502, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Right Reason Technologies RightTrack', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'RISC Virtual Training Assistant', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Saba Centra', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'SAFARI Video Networks eZediaQTI', 43232107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'SkillSoft SkillPort', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'SumTotal Systems ToolBook', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'SumTotal Systems TotalLMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'SyberWorks Training Center', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'techniques.org knowledgeWorks LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Telania eLeaP Learning Management System LMS/LCMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'The Human Equation InSite LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'TrainCaster LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'TrainOnTrack Learning Management System LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Trivantis Lectora', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Upside Learning UpsideLMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'WBT Systems TopClass', 43233502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Xerceo Learn', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Xyleme Learning Content Management System LCMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-3131.00', 'Technology', 'Ziiva Prosperity LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Aerosol foggers', 21101805, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Backhoe attachments', 22101713, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Bar code readers', 43211701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Bench scales', 41111507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Carbon dioxide systems', 21102303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Chemical sprayers', 21101801, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Chipping equipment', 27112715, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Composting equipment', 21101806, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Cordless power drills', 27112703, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Dew point meters', 41112302, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Drainage pumps', 40151531, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Drip emitters', 21101511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Electric timing devices', 46171603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Extended pole pruners', 27112007, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Extension ladders', 30191501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Fertigation equipment', 21102301, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Fertilizer injectors', 21101804, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Forklifts', 24101603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Fumigation equipment', 21101801, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Grease guns', 27112901, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Handsaws', 27111508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Humidifiers', 21102303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Humidity meters', 41112301, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Hydroponic equipment', 21102302, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Impact sprinklers', 21101803, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Lawn edgers', 27112015, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Lawn mowers', 27112014, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Light evaluation meters', 41115308, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Line cutters', 27112015, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Materials conveyors', 24101712, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Mechanized tilling equipment', 21101503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Microsprinklers', 21101803, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Mist control systems', 21102301, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Mulch spreaders', 27112907, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Multipurpose tractors', 25101901, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Overhead sprinklers', 21101803, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'pH indicators', 41115603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Pneumatic cutters', 27112007, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Pneumatic pruners', 27112007, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Pop-up sprinklers', 21101803, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Portable air compressors', 40151601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Portable dataloggers', 43211715, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Power augers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Power monitors', 41113708, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Powered trailers', 25181701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Pruning tools', 27112007, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Radiant heaters', 41102404, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Security alarm systems', 46171604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Skid steer machines', 22101529, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Soil electrical conductivity measurement devices', 41115609, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Soil mixers', 41103801, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Soil pasteurizers', 21102302, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Soil thermometers', 41112213, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Sport utility vehicles SUVs', 25101507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Steam sterilizers', 42281508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Stereo light microscopes', 41111703, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Transplanting equipment', 21101602, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Trenchers', 22101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Tools', 'Trickle irrigators', 21101511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Technology', 'Argos Software ABECAS Insight Nursery and Greenhouse Management software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Technology', 'Innovative Software Solutions Picas', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.01', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Adjustable widemouth pliers', 27112107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Animal blood collection syringes', 42121507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Animal feeders', 21101902, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Animal transportation trailers', 25181703, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Animal vaccination syringes', 42121507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Artificial insemination kits', 21101902, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Backhoes', 22101509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Belt conveyor systems', 24101712, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Branding equipment', 21101905, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Brush mowers', 21101701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Chain saws', 27112709, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Circular saws', 27112709, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Claw hammers', 27111618, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Corn pickers', 21101703, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Dump trucks', 25101601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Egg gathering equipment', 21101906, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Extension ladders', 30191501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Farm tractors', 25101901, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Farm trucks', 25101507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Field cultivators', 21101503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Field watering systems', 21101512, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Four wheel drive 4WD trucks', 25101507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Garden hoes', 27112008, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Gardening shovels', 27112004, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Global positioning system GPS receivers', 52161518, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Grain combines', 21101704, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Grain drills', 21101604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Grain dryers', 23201202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Grain scales', 41111509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Grease guns', 27112901, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Handheld computers', 43211715, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Hay balers', 21101702, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Hay mowing machines', 21101702, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Hay trucks', 25101611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Lawn mowers', 27112014, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Livestock castration equipment', 42121513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Manure spreaders', 21101804, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Milking equipment', 21101901, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Mowing equipment', 21101701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Oil dispensing cans', 27112905, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Portable welding equipment', 23271406, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Poultry incubators', 21101903, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Snow blowers', 22101531, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Snowplow attachments', 22101710, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Spray attachments', 21101801, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Tools', 'Weedeaters', 21101504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Accutech Systems Corporation AccuFarm-MGR', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Advanced Veterinary Services Ranch Vision', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Ag Connections Land.db', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Ag Leader Technology SMS Advanced', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'AGCO Advanced Technology Solutions Fieldstar', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'AgData Blue Skies Accounting', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Agevo Farm Manager', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'AgriSoft/CMC AgriSoft/ERP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'AgTerra Technologies AgTrac', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Alua Software Paddock Pro', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Brihzon Solutions SMART Dairy Resource Planning', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Cattlesoft CattleMax', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'CattleWorks', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'CDA International Manifold System', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Countryside Data Ag Payroll', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Custom Software Group CSG AgroSys', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Datatech The Farmer''s Office', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Delta Data Systems AGIS', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'DIVA-GIS', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'ESRI ArcPad', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'EZ-Ranch Cattle Management Software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Farm Business Software Systems Smart Feeder', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Farm Files Crops', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Farm Files Livestock', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Geographic resources analysis support system GRASS software', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Global Mapper Software Global Mapper', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Global positioning system GPS software', 43233511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'i.Agri LandMark Farm', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'International Response Technologies CowChip - Ranch House', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'John Deere Apex Farm Management', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'KELTEC Systems HerdMaster', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Lion Edge Technologies Ranch Manager software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'MapInfo software', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'MapShots EASi Suite', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Midwest MicroSystems Cow Sense', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Payroll software', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Pear Technology Fieldman Farmer', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'PigCHAMP Care 3000', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'ProducePak Mobile Farm Management', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Red Wing Software CenterPoint Farm Accounting Software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Sanders Software Consulting FarmBooks Accounting Software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Specialized Data Systems Ultra Farm', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'SST Development Group SSToolbox', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'SST Development Group Stratus', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Stenco Technologies Farm Trends', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Sunrise Software CropSave', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'TapLogic FarmLogic', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'TatukGIS Editor', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Trimble AgGPS EZ-Map', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Trimble Farm Works software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Vertical Solutions Easy-Farm Accounting', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.02', 'Technology', 'ZedX AgFleet', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Adjustable hand wrenches', 27111707, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Aeration pumps', 40151501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Air compression equipment', 40151601, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Aquaculture tanks', 21111601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Biological filters', 40161808, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Cage nets', 21111601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Centrifugal water pumps', 40151503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Claw hammers', 27111618, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Clockwork belt feeders', 21111601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Cordless power drills', 27112703, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Digital flowmeters', 41112501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Dip nets', 21111504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Fish collection nets', 21111601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Fish counters', 41111902, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Fish crowders', 21111601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Fish egg counters', 21111601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Fish egg sorters', 21111601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Fish feeders', 21111601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Fish graders', 21111601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Fish holding pens', 10131601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Fish incubators', 21111601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Fish transfer pumps', 21111601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Fish traps', 21111601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Fry nets', 21111504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Gas-powered generators', 26111604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Hacksaws', 27111559, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Handheld dissolved oxygen meters', 41115611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Layout squares', 27111803, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Multipurpose pliers', 27112107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Multipurpose tractors', 25101901, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Ozone generators', 47101541, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'pH probes', 41115603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Phillips screwdrivers', 27111701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Pipe wrenches', 27111749, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Portable power saws', 27112709, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Power mowers', 27112014, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Power nail guns', 27112716, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Power nail pullers', 27131528, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Propane torches', 23271702, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Round metal files', 27111930, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Safety gloves', 46181504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Screen filters', 40161502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Seine reels', 21111502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Straight screwdrivers', 27111701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Tanker trucks', 25101610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Temperature monitors', 41112509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Tongue and groove pliers', 27112112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Tubing cutters', 23241610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Turbine water pumps', 40151526, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Ultraviolet light UV water disinfection systems', 47101517, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Utility forklifts', 24101603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Utility knives', 27111503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Water filters', 40161502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Water level monitors', 41112504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Water test kits', 41113319, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Tools', 'Woodworking chisels', 27111906, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Technology', 'AquaSoft Farm Manager', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Technology', 'Fish stocking databases', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Technology', 'Hatchery database systems', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Technology', 'Staff scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Technology', 'Statistical analysis software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Technology', 'Time reporting software', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9013.03', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Tools', 'Large-format scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Tools', 'Lasers', 41115307, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Tools', 'Levels', 27111802, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Tools', 'Pocket personal computers PC', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Tools', 'Transit levels', 41111938, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'AEC Software FastTrack Schedule', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'ArenaSoft Estimating', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Autodesk Revit', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Axios Systems assyst', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Bechtel Software SETROUTE', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Cadsoft Design/Build', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'CBS ProLog Manager', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Computer aided design and drafting software CADD', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'CSI WSE CodeBuddy', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Daily Manager', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Database software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Explorer Engineer', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'HCSS HeavyBid', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'HCSS HeavyJob', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'IMPACT software', 43232107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Integrated construction management software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Internet browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Intuit QuickBase', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'ISS Construction Manager', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Jobber Computer Plus', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Lombardi Teamworks', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Oracle Primavera Enterprise Project Portfolio Management software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Presentation software', 43232106, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Profitool GearWatch', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Profitool software (human resources feature)', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Profitool software (time accounting feature)', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Quantum Software Solutions Quantum Project Manager', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Sage 100 Contractor', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Sage 300 Construction and Real Estate', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'Site Manager', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'SRC Cash Flow Forecasting', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'UDA Technologies ConstructionSuite', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9021.00', 'Technology', 'VirtualBoss', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Tools', 'Compact digital cameras', 45121504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Tools', 'Computer laser printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Tools', 'Emergency first aid kits', 42172001, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'ACS Technologies HeadMaster', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'Auburn Software Debit Square', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'B&I Computer Consultants Childcare Sage', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'Cirrus Group Daycare Works', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'eChurch.com SchoolPerfect', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'Emerging Technologies Office Center', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'Intuit QuickBooks software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'Intuit Quicken software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'Jackrabbit Technologies Jackrabbit Care', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'Kressa Software SchoolLeader', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'MAGGEY software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'Mount Taylor Programs Private Advantage', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'OnCare Advantage', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'ONE Software KidsONE', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'Orgmation iCare', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'Personalized Software Childcare Manager', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'PraxiPower PraxiSchool', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'Professional Solutions ProCare', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'ScholarCare', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'SDS Software Solutions DayCare Information Systems PRO', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'SoftCare CenterCare', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'SofterWare EZ-CARE2', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'The Gallagher Group DataCare', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9031.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Tools', 'Digital projectors', 45111614, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Tools', 'Fire alarm systems', 46171604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Tools', 'Interactive whiteboards', 43211903, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Tools', 'Public address PA systems', 45111705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Tools', 'Security alarm systems', 46171604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Tools', 'Two way radios', 43191510, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'ACS Technologies HeadMaster', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Attendance tracking software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Blackbaud The Education Edge', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Computer Resources MMS', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'eDistrict Internet Solutions eDistrict Unified', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Effexoft EASI', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Gmail', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Google Calendar', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Google Drive', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'L-Systems X-ONE', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'LogicalBit Eimas', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Pearson PowerSchool', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Principle Data Systems School Management Software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'RecordKeeper Software School RecordKeeper', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Rediker Software School Office Suite', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Robust Software Overseer Suite', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'School Attendance Keeper', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'SchoolDESX', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Seasia Consulting School Wizard', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Skyward School Management System', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Specialized Data Systems School Office', 43231602, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'SunGard Public Sector IFAS', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Thinc Technologies Virtual School', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9032.00', 'Technology', 'Wilcomp Software RenWeb', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Tools', 'Liquid crystal display LCD video projectors', 45111614, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Tools', 'Universal serial bus USB flash drives', 43201813, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Blackboard software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'CollegeNET Schedule 25', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Ellucian Colleague', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Ellucian Degree Works', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Enterprise resource planning ERP system software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Fund accounting software', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Jenzabar EX', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Minitab software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Nolij Corporation Nolij Transfer', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Sage 50 Accounting', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'SAS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'SPSS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Student and Exchange Visitor Information System SEVIS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Student information systems SIS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'SunGard Higher Education Banner Unified Digital Campus', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9033.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Tools', 'Digital video disk DVD players', 52161516, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Tools', 'Teleconferencing equipment', 43221522, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Tools', 'Webinar equipment', 45111902, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Adobe Systems Adobe Acrobat software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Adobe Systems Adobe Captivate', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Adobe Systems Adobe Connect', 43233503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Adobe Systems Adobe Creative Suite software', 43232402, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Adobe Systems Adobe Flash', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Articulate Storyline', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Blackboard software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'C#', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'C++', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Campus Cruiser LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Cisco Systems WebEx', 43233502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'ConferenceEdge software', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Facebook', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Instructure Canvas', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'LinkedIn', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Microsoft .NET Framework', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Moodle', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Oracle Java', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Podcasting software', 43232103, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'RISC Virtual Training Assistant', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Twitter', 43233504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Videoconferencing software', 43233502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'Web conferencing software', 43233502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.01', 'Technology', 'YouTube', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Tools', 'Automated external defibrillators AED', 42172101, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Tools', 'Automatic blood pressure cuffs', 42181602, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Tools', 'Body fat calipers', 42182704, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Tools', 'Computer laser printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Tools', 'Elliptical trainers', 49201516, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Tools', 'Emergency medical aid kits', 42172001, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Tools', 'Exercise treadmills', 49201501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Tools', 'Free weights', 49201606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Tools', 'Height measurement rulers', 42182703, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Tools', 'Lower body weight machines', 49201603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Tools', 'Manual blood pressure cuffs', 42181603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Tools', 'Measuring tapes', 27111801, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Tools', 'Stationary exercise bicycles', 49201503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Tools', 'Teleconferencing equipment', 43221522, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Tools', 'Upper body weight machines', 49201605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Tools', 'Weight measurement scales', 41111508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Technology', 'Adobe Systems Adobe Acrobat software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Technology', 'MicroFit HealthWizard', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Technology', 'Payroll software', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9039.02', 'Technology', 'Work scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Tools', 'Drawing tablets', 43211712, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Tools', 'Notebook computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Tools', 'Scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Adobe Systems Adobe Acrobat Pro Extended', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Adobe Systems Adobe LifeCycle ES', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Agile Product Lifecyle Management PLM', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Apache Cassandra', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Apache Maven', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Apache Pig', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Apache Solr', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Autodesk AutoCAD Civil 3D', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Autodesk Buzzsaw', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Autodesk Revit', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Autodesk VIZ', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Bentley MicroStation', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'C', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'C#', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'C++', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Cisco Systems IOS software', 43233004, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Computer aided design and drafting software CADD', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Computer aided manufacturing CAM software', 43232612, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Dassault Systemes CATIA software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Delcam PowerMILL', 43232612, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Drawing and drafting software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'ESRI ArcView', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Geographic information system GIS software', 43233506, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Geometric CAMWorks', 43232612, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'HEC RAS', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'HEC-1', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Hewlett-Packard HP SolidDesigner', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Inventory management software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'JavaScript', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Kronos Workforce Timekeeper', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'LAMP Stack', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Linux', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'LSA Visual Easy Lean', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Made2Manage software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Maintenance scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Microsoft Dynamics NAV', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Minitab software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'MongoDB', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'MySQL software', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'National Instruments LabVIEW', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Node.js', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'NoSQL software', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Objective C', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Open Mind hyperMILL', 43232612, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Oracle Java', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Oracle Primavera Enterprise Project Portfolio Management software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'PostgreSQL software', 43232311, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Practical extraction and reporting language Perl', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Pro-E CAD software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'PTC Creo Parametric', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Puppet', 43232401, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Python', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Realization Streamliner', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'RTA Fleet Management', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Ruby on Rails', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'SolidWorks CAD software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Splunk Enterprise', 43233701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Spreadsheet software', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'SPSS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Structured query language SQL', 43232306, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'The Gordian Group PROGEN Online', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'UNIX', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Verilog', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Water surface pressure gradient WSPG software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Wireshark', 43232801, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Word processing software', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.00', 'Technology', 'Workflow software', 43232201, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Absorption equipment', 47101503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Autosamplers', 41115714, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Bioreactors', 41104307, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Biosafety cabinets', 41103507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Dissolved oxygen monitors', 41115611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Distillation equipment', 41104802, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Extraction equipment', 41104806, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Fermentation systems', 41104301, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Flocculators', 47101512, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Flow indicators', 41111931, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Forced convection incubators', 41104402, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Gas chromatograph mass spectrometers GC-MS', 41115404, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Gas chromatographs GC', 41115703, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Gel electrophoresis equipment', 41105314, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Glass flasks', 41121804, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'High pressure liquid chromatographs HPLC', 41115707, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Inverted compound microscopes', 41111712, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Level indicators', 41111938, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Mass spectrometers', 41115404, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Orbital incubating shakers', 41104405, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'pH indicators', 41115603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Polymerase chain reaction PCR equipment', 41106312, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Pressure indicators', 41112403, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Safety glasses', 46181802, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Safety gloves', 46181504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Spectrophotometers', 41115406, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Temperature probes', 41112210, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Tools', 'Top-loading autoclaves', 42281508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Technology', 'Agilent ChemStation', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Technology', 'Computer aided design CAD software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Technology', 'Fleet Asset Management and Optimization Solutions FAMOS PEPSE', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Technology', 'GE Energy GateCycle', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9041.01', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Tools', 'Computerized cash registers', 44101804, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Tools', 'Laser printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Tools', 'Notebook computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Adobe Systems Adobe Flash', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Aestiva Employee Time Clock', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Army Food Management Information System software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Aurora FoodPro', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'ChefDesk Chef''s Calculators', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'ChefTec software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'ClubSoft Food & Beverage Point of Sale', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Database software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'DataTeam Lunch Express', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Delphi software', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Dinerware Intuitive Restaurant Software', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'espSoftware Employee Schedule Partner', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Food Service Solutions FoodCo', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Food Service Solutions POSitive ID System', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Food Services Solutions DayCap', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Food Software.com IPro Restaurant Inventory, Recipe & Menu Software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Gift Certificates Plus Giftworks', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'IBM Domino', 43232902, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'iMagic Restaurant Reservation', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Intuit QuickBooks software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Inventory management software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'ReServe Interactive Catering Software', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Restaurant Manager software', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'SoftCafe software', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'SweetWARE nutraCoster', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'ValuSoft MasterCook', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9051.00', 'Technology', 'Word processing software', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Airbrushing devices', 60121253, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Arterial tubes', 42262004, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Body bridges', 42261703, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Cannula sets', 42142402, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Casket carriages', 42261809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Casket lowering devices', 42261809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Centrifugal force pumps', 40151503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Chemical pillows', 47131908, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Compaction tampers', 22101507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Cremation stands', 42261802, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Curved suture needles', 42312206, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Dump trailers', 25181701, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Electric mortuary aspirators', 42262104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Embalming machines', 40151564, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Embalming tables', 42261703, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Funeral church trucks', 42261809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Head blocks', 42261604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Hearses', 25101506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Hydro-electric aspirators', 42262104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Hypodermic syringes', 42142609, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Jugular drain tubes', 42262002, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Ligators', 42291802, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Local exhaust ventilation LEV systems', 40101502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Mausoleum lifts', 42261809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Monument lifts', 22101803, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Mortuary bier pins', 31162407, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Mortuary cots', 42261802, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Mortuary dressing tables', 42261703, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Mortuary lift systems', 42261809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Mortuary operating tables', 42261703, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Mortuary roller systems', 24101701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Mortuary vans', 25101505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Mouth formers', 42262102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Needle injector guns', 42262007, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Nitrile gloves', 46181504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Numbering machines', 44102402, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Pallbearer casket carriages', 42261809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Passenger vehicles', 25101503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Personal protective equipment', 46181509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Protective latex gloves', 46181504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Respirators', 46182002, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Scalpels', 42261505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Sink covers', 42262005, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Trocars', 42291620, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Vault lowering devices', 42261809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Tools', 'Viscera bags', 42261607, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Technology', 'CodeJam MemoriesOnTV', 43232103, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Technology', 'CSR Consultants Cemetery Management SC', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Technology', 'Financial reporting software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Technology', 'FPA Software MACCS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Technology', 'funeralOne Life Tributes', 43232106, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Technology', 'HMIS Advantage', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Technology', 'Mortware Professional', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Technology', 'Twin Tiers Technologies CIMS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Technology', 'Twin Tiers Technologies MIMS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9061.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Tools', 'Security alarm systems', 46171604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Tools', 'Two way radios', 43191510, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Tools', 'Video surveillance systems', 46171612, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Technology', 'Employee scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Technology', 'Human resources management system HRMS software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9071.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Tools', 'Cash registers', 44101804, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Tools', 'Credit card processing machines', 43211702, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Tools', 'Handheld computers', 43211715, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Tools', 'Private automatic branch exchange PABX systems', 43221504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Tools', 'Voice mail systems', 43221519, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'Accounting software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'Anand Systems ASI FrontDesk', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'Delphi software', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'Enablez ResortSuite', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'ePOS Business Solutions System 3 POS', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'Execu/Tech Systems HOTEL Premium', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'GraceSoft Easy InnKeeping Suite', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'GuestClick software', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'Hotel management system software', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'Housekeeping management software', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'INN-Client Server Systems ICSS Atrium', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'iRez Systems Rezware XP7', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'M-Tech Hotel Service Optimization System HotSOS', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'MICROS Systems OPERA Enterprise Solution OES', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'Payroll software', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'RedSky IT Entirety e-Booking', 43232603, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'Silverbyte Systems Optima Property Management System PMS', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'TCS Hotel Software Guest Tracker', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9081.00', 'Technology', 'UniResMan software', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Tools', 'Scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', '3DGrid HIPAA Checkup', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'AcuStaf Software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Adobe Systems Adobe Acrobat software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Adobe Systems Adobe Flash', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Alteer Office', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'American Medical Association CodeManager', 43232301, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Apache Pig', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'API Healthcare ActiveStaffer', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'ArticSoft FileAssurity', 43233205, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Bed Management Suite', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Blackboard software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'CareCentric MestaMed software', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Cerner ProFile', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'CliniTrend software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'ColorSoft AutoMatch', 43232301, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'ConceptDraw software', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Contract management software', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Current Professional Terminology CPT software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Dental Common Access System DENCAS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'DxCG RiskSmart', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'e-MDs Bill', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'e-MDs Chart', 43232105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'e-MDs DocMan', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'e-MDs Schedule', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Electronic medical record EMR software', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Elekta Impac Practice Management Software', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Emdeon HealthPro', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Epic Systems software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Expert Health Data Programming Vitalnet', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'GE Healthcare Centricity EMR', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Geographic information system GIS software', 43233506, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Google AdWords', 43231514, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Google Sheets', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Healthcare common procedure coding system HCPCS software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Henry Schein Dentrix software', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'IBM Domino', 43232902, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'IBM Notes', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Integrated development environment IDE software', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Intuit QuickBooks software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Inventory management software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Kodak Dental Systems Kodak SOFTDENT Practice management software PMS', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'LexisNexis software', 43232309, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'McKesson Horizon Ambulatory Care', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'MEDENT', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'MedFORCE Technologies WorkFLOW', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Medical condition coding software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Medical procedure coding software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'MEDITECH Medical and Practice Management MPM Suite', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'MEDITECH software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Microsoft Exchange Server', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Minitab software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Misys Healthcare Systems Misys Tiger', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Misys Healthcare Systems software', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'NDCLytec software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Nuance PaperPort Professional', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Oracle Hyperion software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Oracle Primavera Enterprise Project Portfolio Management software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'PCC EHR', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'PCC Pediatric Partner', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Relative Values for Physicians software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Sage 50 Accounting', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Salesforce software', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'SAP Business Objects software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'SAS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'SPSS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'TeleTracking PreAdmit-Tracking', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Yost Engineering ABN Assistant', 43232301, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Yost Engineering ClaimScrub', 43232301, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Yost Engineering CodeSearch Pro', 43232301, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Yost Engineering EpiCoder', 43232301, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9111.00', 'Technology', 'Yost Engineering EPStaffCheck', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Tools', 'Color plotters', 43212107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Tools', 'Liquid crystal display LCD video projectors', 45111614, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Tools', 'Universal serial bus USB flash drives', 43201813, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'Adobe Systems Adobe Photoshop software', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'Graphics software', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'IBM Lotus 1-2-3', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'Laboratory information management system LIMS software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'Oracle DBMS', 43232304, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'SAS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'SPSS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'StatSoft STATISTICA software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Tools', 'Digital video equipment', 45121516, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Tools', 'Photocopiers', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Tools', 'Smartphones', 43191501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', '5AM Glassbox Translational Research', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Budgeting software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'ClearTrial', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Clinical data management system CDMS software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Drug coding software', 43232301, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'DZS Software Solutions ClinPlus', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Electronic data capture EDC software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'ePharmaSolutions eMVR', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'InferMed MACRO Electronic Data Capture', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'InforSense InforSense', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Invivo Data EPX ePRO Management System', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'KIKA Veracity', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Online data collection systems', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'OpenClinica', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Oracle Clinical', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Patient tracking software', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'PercipEnz Technologies OnCore-Clinical Research Management OnCore-CRM', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Phase Forward InForm GTM', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'PPD eLoader', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'PPD Patient Profiles', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Project management software', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Qualitative analysis software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'SAS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Sierra Scientific Software CRIS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'SPSS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'StudyManager Sponsor Edition', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'SyMetric Sciences SyMetric', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'TOPAZ Enterprise Software Suite', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.01', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Automated water sampling equipment', 41104007, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Binocular light compound microscopes', 41111709, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Chlorine testers', 41113117, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Digital pH meters', 41115603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Dissolved oxygen indicators', 41115611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Global positioning system GPS receivers', 52161518, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Grab samplers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Gravitational field indicators', 41113808, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Mobile radios', 43191510, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Multiparameter water probes', 41113319, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Nitrate meters', 41113322, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Nitrite meters', 41113322, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Plankton nets', 21111504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Rain gauges', 41114405, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Seines', 21111504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Stream flow gauges', 41114301, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Temperature gauges', 41112222, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Titrators', 41115602, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Total dissolved solids TDS meters', 41104007, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Total stations', 41114204, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Turbidimeters', 47101516, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Water conductivity testers', 41115609, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Water flow meters', 41111931, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Water quality test kits', 41113319, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Tools', 'Water samplers', 41104007, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'Database software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'DHI MIKE URBAN', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'ESRI ArcGIS Spatial Analyst', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'ESRI ArcInfo', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'ESRI ArcPad', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'ESRI ArcView', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'ESRI ArcView 3D Analyst', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'FishXing software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'Global positioning system GPS software', 43233511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'Google Earth Pro', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'HEC-HMS', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'HEC-RAS', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'Laboratory information management system LIMS software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'MWH Soft H2ONET MSX', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'MWH Soft InfoSWMM', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'Scientific Software Group RIVERMorph', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'TIBCO Spotfire S+', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'Wallingford Software InfoSewer', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'Wallingford Software InfoWater', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'Wallingford Software InfoWorks CS', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'Wallingford Software InfoWorks WS', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'Water flow modeling software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9121.02', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Barcode scanners', 43211701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Computer data input scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Computer laser printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Credit card machines', 43211702, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Date stamps', 44103202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Digital postal scales', 41111510, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Electronic cash registers', 44101804, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Mail delivery trucks', 25101604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Mail sorting equipment', 44102502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Measuring tapes', 27111801, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Multiline telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Point of sale POS computer terminals', 43211505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Postage canceling machines', 44102104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Postage meters', 44102101, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Postage validation imprinters', 44102101, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Security alarm systems', 46171604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Time clocks', 44103207, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Video monitoring systems', 46171612, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Tools', 'Warning flares', 39111714, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Technology', 'Collection Point Management System CPMS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Technology', 'eBuy', 43231503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Technology', 'Facility database software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Technology', 'Payroll software', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Technology', 'Personnel management software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Technology', 'Personnel scheduling software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Technology', 'Point of sale POS software', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Technology', 'Postal boundary mapping software', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Technology', 'Postal tracking software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Technology', 'Vehicle management software', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Technology', 'Web Box Activity Tracing System WebBATS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9131.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Tools', 'Computer laser printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Tools', 'Digital cameras', 45121504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Tools', 'Golf carts', 25101904, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Tools', 'Handheld calculators', 44101807, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Tools', 'Lenel Onguard', 46171619, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Tools', 'Photocopiers', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Tools', 'Scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Tools', 'Smartphones', 43191501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Tools', 'Step ladders', 30191501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Tools', 'Two way radios', 43191510, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Tools', 'Video surveillance cameras', 45121516, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Advantos Systems DataTrust Enterprise', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Biometric reader software', 43232901, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Bostonpost Technology Property Manager', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Calendar and scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Card key management software', 43232901, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Domin-8 Enterprise Solutions RentRight', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Domin-8 Enterprise Solutions Tenant Pro', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Facebook', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'FullHouse Software Investment Property Manager', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Google Analytics', 43232307, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'IDEAS Software & Training IDEAS Property Clerk', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Infor Global Solutions eSITE', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Intuit MRI Residential', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Intuit QuickBooks software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Intuit Quicken Rental Property Manager', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'iRealty Manager', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Jenark Business Systems software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Just So Software The Property Manager', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'LandlordMax', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Landport Systems Landport', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'London Computer Systems Rent Manager', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'O''Brien Grasso RE Software Property Master', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Property Boulevard', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Property Solutions International ResidentPortal', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'PropertyThree', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'PropertyView Solutions Remanage', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Propertyware', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'PT Software Solutions PT Rental Assistant', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Qualitica RentBoss', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'RealEasyBooks ezREB', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'RealPage OneSite', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Sage 50 Accounting', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'SpiritWorks Software Development Rental Property Tracker Plus', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Spreadsheet software', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'SS&C Technologies Skyline Property Management', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'TCG Technologies i-CAM', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'TrackPro Services TrackPro Manager', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Turtle Creek Software Goldenseal', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'W G Software Tenant File', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Yardi software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Yardi Systems Yardi Enterprise', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Yardi Systems Yardi Voyager Commercial', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Yardi Systems Yardi Voyager Condo, Co-op, and HOA', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'Yardi Systems Yardi Voyager Residential', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9141.00', 'Technology', 'YouTube', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'Client information databases', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'Corel QuattroPro', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'Corel WordPerfect Office Suite', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'Financial accounting software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'Healthcare common procedure coding system HCPCS software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'IBM Lotus 1-2-3', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'Microsoft Visual FoxPro', 43232311, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'Oracle Reports', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'PointClickCare software', 43232610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'Presentation software', 43232106, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9151.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Tools', 'Chemical protective boots', 46181602, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Tools', 'Chemical protective clothing', 46181509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Tools', 'Emergency alert notification systems', 43221502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Tools', 'Hard hats', 46181701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Tools', 'Protective hoods', 46181522, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Tools', 'Radiation detectors', 41111929, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Tools', 'Safety gloves', 46181504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Tools', 'Self-contained breathing apparatus', 46182004, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Tools', 'Two way radios', 43191510, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'Alert Technologies OpsCenter', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'Desktop publishing software', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'Digital Engineering Corporation E-MAPS', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'Emergency Managers Weather Information Network EMWIN', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'Emergency Services Integrators ESi WebEOC', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'Federal Emergency Management Information System FEMIS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'Geographic information system GIS software', 43233506, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'Graphics software', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'IBM Lotus Notes', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'MapInfo Professional', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'National Center for Crisis and Continuity Coordination NC4 E Team', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'Relational database software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'SoftRisk Technologies SoftRisk SQL', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'Statistical software', 43232605, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'SunGard Assurance', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9161.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Tools', 'Computer laser printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Adlib Express', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Adobe Systems Adobe Acrobat software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Analyse-it', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Aris Global Register', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Axway eSubmissions', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Database software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Datafarm a-Pulse', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Datafarm eCTDGatekeeper', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Datafarm eCTDViewer', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Datafarm S-Cubed', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Dialog DialogLink', 43232309, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Document publishing software', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'DoubleBridge ROSETTA Phoenix eCTD Viewer', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'DoubleBridge ROSETTA Pyramid', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'DoubleBridge ROSETTA Sceptre', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'DoubleBridge ROSETTA Scribe', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Electronic common technical document eCTD software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Electronic common technical document eCTD validating software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Electronic common technical document eCTD viewing software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Electronic document management system EDMS software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Enterprise content management ECM software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Extedo DOCvalidator', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Extedo eCTDmanager Suite', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Extedo PLmanager', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'GlobalSubmit REVIEW', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'GlobalSubmit VALIDATE', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Image Solutions eCTDXpress', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Image Solutions ISIPublisher', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Integrated development environment IDE software', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Lorenz DocuBridge', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Lorenz eValidator', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Lorenz labelBridge', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'MasterControl software', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'MediRegs E-dition Compliance Monitor', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'MediRegs Pharmaceutical Regulation Suite', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'MediRegs Regulation and Reimbursement Suite', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'MediRegs Risk Assessment Manager', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'MedXView eCTDauditor', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Microsoft Windows', 43233004, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Octagon StartingPoint', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Octagon ViewPoint eCTD Complete', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Pilgrim Regulatory Submission', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Risk management software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Samarind RMS', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'SAP EHS Management', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Spreadsheet software', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Statistical analysis software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Take Solutions PharmaReady Document Management System', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Thomson Reuters Liquent CoreDossier Submission Accelerator for eCTD', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Thomson Reuters Liquent InSight Suite', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Total quality management TQM software', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Virtify eCTD', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'Word processing software', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.01', 'Technology', 'XML authoring software', 43232403, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Tools', 'Computer laser printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', '80-20 Software Leaders4', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Actimize Brokerage Compliance Solutions', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Adobe Systems Adobe Acrobat software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Agiliance Compliance Manager', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Aline GRC', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Apple Safari', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'ARC Logics Sword', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Archer Compliance Management', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'AssurX CATSWeb', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'AssurX Financial Services Compliance Management System', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Audit2 AdaptiveGRC', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Axentis Compliance Management', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'BPS Compliance', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'BWise Compliance Management', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'CMO Compliance Regulatory Compliance Solution', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Compliance 360', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Compliance11 Supervisory Suite', 43232606, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'ComplianceBridge Total Compliance', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'ControlCase Compliance Manager', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Cura Software Solutions Cura for Compliance Management', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Data analysis software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Database management software', 43232304, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Desktop publishing software', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'DoubleCheck GRC&T Platform', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'ember ec3 HeatShield software', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'EtQ Environmental Health and Safety Software', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'EtQ FDA cGxP Compliance Software for Life Sciences', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Fidessa Compliance Manager', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'FRSGlobal RegPro', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Governance, risk, and compliance GRC software', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Guideline Risk Technologies RUBI', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Healthcare common procedure coding system HCPCS software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Horwath Software Magique', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Human resource information system HRIS software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'IBM Notes', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Keane SCORE', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'LexisNexis software', 43232309, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'LRN Ethics and Compliance Alliance', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'MasterControl MD', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'MasterControl TotalPharma', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'MediRegs ComplyTrack', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Methodware ERA', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'MetricStream Compliance Management', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'MetricStream Enterprise Compliance Platform', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'MetricStream Regulatory Reporting', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Microsoft Windows', 43233004, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Modulo Risk Manager', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Mozilla Firefox', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'MyComplianceOffice Compliance Operations Management System', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Neohapsis Certus GRC', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Oracle Enterprise Governance, Risk, and Compliance Manager', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Oracle Insurance Compliance Tracker', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'policyIQ', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Protiviti Governance Portal', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'QUMAS Compliance Solution', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Resolve Legislative Compliance Management', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'RVR Systems Compliance', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'SAP BEx Report Designer', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Spreadsheet software', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Sword Achiever Compliance Portal Dashboard', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Tax accounting software', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'The Garland Group RiskKey', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Thomson Reuters Paisley Enterprise GRC', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.02', 'Technology', 'Word processing software', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Tools', 'Multiline telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Tools', 'Teleconferencing equipment', 43221522, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Tools', 'Videoconferencing equipment', 45111902, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'Autodesk AutoCAD Blue Sky', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'Financial accounting software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'Microsoft MapPoint', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'Oracle Hyperion software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'Portfolio analysis software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'ReadSoft software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'Risk analysis software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'SAS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'Statistical analysis software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'SunGard Financial Systems AddVantage', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.03', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Tools', 'Radio frequency identification RFID scanners', 52161522, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Adexa Supply Chain Planning', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Aldata Warehouse Management', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'CDC Supply Chain', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Dex Warehouse', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Epicor SRM', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Epicor WMS', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Graphics software', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'HighJump Software Supply Chain Advantage', 43231506, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'HighJump Warehouse Advantage', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'i2 Collaborative Supply Execution', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'i2 Intelligence', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'i2 Supply Chain Visibility', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'IBM ILOG Inventory Analyst', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'IBM ILOG LogicNet Plus XE', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'IBS MRP', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'IBS Supply Chain Management', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'IFS Applications for Supply Chain Management Software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Infor Lawson Supply Chain Management', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Infor SCM', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'JDA Master Planning', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Lawson S3 Supply Chain Management', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Manhattan Scale', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Manhattan Supply Chain Process Platform', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Master scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Microsoft Dynamics AX', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Oracle e-Business Suite Supply Chain Management', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Oracle Hyperion software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Oracle Inventory', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Purchasing software', 43231503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'QAD MFG Pro', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Red Prarie Warehouse Management', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'SAP APO', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'SAP SCM', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Simulation and modeling software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Swisslog WarehouseManager', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.04', 'Technology', 'Warehouse management system WMS software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Tools', 'Approach detection systems', 46171608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Tools', 'Computer laser printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Tools', 'Explosives detectors', 46171635, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Tools', 'Fire alarm systems', 46171604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Tools', 'Keyless entry systems', 46171619, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Tools', 'Multiline telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Tools', 'Physical access control systems', 46171619, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Tools', 'Security alarm systems', 46171604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Tools', 'Teleconferencing equipment', 43221522, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Tools', 'Video surveillance systems', 46171612, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Tools', 'Videoconferencing equipment', 45111902, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Alarm system software', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Computer aided design CAD software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Corel WordPerfect Office Suite', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Emergency notification system software', 43232902, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Facebook', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'FieldSoft AIMSonScene', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Graphics software', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Human resources management system HRMS software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Incident command system ICS software', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Inventory tracking software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Maintenance management software', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Mapping software', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'McAfee software', 43233205, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Payroll software', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Physical access management software', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Twitter', 43233504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.07', 'Technology', 'Work scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Tools', 'Closed circuit television CCTV monitoring systems', 46171622, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Tools', 'Fire alarm monitoring systems', 46182504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Tools', 'Multiline telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Tools', 'Physical access control systems', 46171619, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Tools', 'Security alarm systems', 46171604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Tools', 'Video surveillance systems', 46171612, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'Enabl-u Technologies APIS', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'Financial accounting software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'IBM Lotus Notes', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'Inventory tracking software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'MICROS XBR Loss Prevention', 43232314, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'MySQL software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'Personnel management software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'Point of sale POS software programs', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'Time reporting software', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.08', 'Technology', 'Work scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Adjustable widemouth pliers', 27112107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Adjustable wrenches', 27111707, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Amp clamp meters', 41113601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Digital calipers', 41111621, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Digital micrometers', 41111601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Digital oscilloscopes', 41113638, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Fall arrest systems', 46182306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Field forklifts', 24101603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Hard hats', 46181701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Hydraulic torque machines', 27112720, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Infrared thermography cameras', 41115321, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Lubricant oil sampling kits', 41113320, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Manual torque wrenches', 27111715, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Megohmmeters', 41113628, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Mobile radios', 43191510, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Phillips head screwdrivers', 27111701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Programmable logic controllers PLC', 32101628, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Protective ear muffs', 46181902, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Recording anemometers', 41114401, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Rigging equipment', 24101611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Safety glasses', 46181802, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Safety line evacuation kits', 46191609, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Straight screwdrivers', 27111701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Tower cranes', 24101623, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Vibration analyis equipment', 41114624, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Tools', 'Voltage testers', 41113637, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Autodesk AutoCAD software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Computerized diagnostic software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Computerized maintenance management system CMMS software', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Employee scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Gensuite software', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'IBM Lotus Notes', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Inventory control software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Local area network LAN software', 43232905, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Oracle Enterprise Asset Management eAM', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Programmable logic controller PLC software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Supervisory control and data acquisition SCADA software', 43232608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Time and payroll management software', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'WebEx WebOffice', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.09', 'Technology', 'Wide area network WAN software', 43232909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Tools', 'Barometric pressure sensors', 41114402, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Tools', 'Cup anemometers', 41114401, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Tools', 'Dataloggers', 43211715, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Tools', 'Digital still cameras', 45121504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Tools', 'Digital video cameras', 45121516, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Tools', 'Electronic temperature sensors', 41112105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Tools', 'Handheld global positioning system GPS units', 52161518, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Tools', 'Portable meteorological stations', 41114410, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Tools', 'Propeller anemometers', 41114401, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Tools', 'Pyranometers', 41114407, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Tools', 'Recording anemometers', 41114401, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Tools', 'Soil samplers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Tools', 'Wind vanes', 41114409, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Technology', 'Autodesk AutoCAD software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Technology', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Technology', 'Oracle Primavera Systems software', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.10', 'Technology', 'Web conferencing software', 43233502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Tools', 'Computer data input scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Tools', 'Digital cameras', 45121504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Tools', 'Global positioning system GPS receivers', 52161518, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Tools', 'Personal computers', 43211508, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Tools', 'Subcentimeter global positioning system GPS units', 52161518, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Technology', 'Calendar management software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Technology', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Technology', 'ESRI ArcMap', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Technology', 'ESRI ArcView', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Technology', 'Maptek Vulcan', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Technology', 'MineSight software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('11-9199.11', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Tools', 'Computer data input scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Tools', 'Digital video cameras', 45121516, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Tools', 'Multiline telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Tools', 'Teleconferencing equipment', 43221522, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Tools', 'Videoconferencing equipment', 45111902, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Technology', 'Adobe Systems Adobe Photoshop software', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Technology', 'Database software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Technology', 'Facebook', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Technology', 'Financial accounting software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Technology', 'Spreadsheet software', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Technology', 'Statistical analysis software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Technology', 'Tax planning software', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Technology', 'Twitter', 43233504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Technology', 'Videoconferencing software', 43233502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1011.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Tools', 'Bulk weighing systems', 41111509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Tools', 'Digital micrometers', 41111601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Tools', 'Grain testers', 41112701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Tools', 'Livestock scales', 41111506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Tools', 'Precision rulers', 41111604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Technology', 'Deltek Costpoint', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Technology', 'Enterprise resource planning ERP system software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Technology', 'IBM Lotus Notes', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Technology', 'Inventory management system software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Technology', 'Microsoft Great Plains software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Technology', 'Product producer databases', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1021.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Tools', 'Point of sale POS systems', 43211505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Accounting software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Advanced Retail Management Systems Retail Pro', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Biztrak Business Solutions Biztrak', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'CAM Commerce Solutions Retail STAR Point of Sale POS', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Claritas ConsumerPoint', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Contact management software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Eclipse software', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Enterprise risk management software ERMS', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Graphics software', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Infor Supply Chain Management', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Intuit QuickBooks software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Inventory control systems', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'JDA Software Group Advanced Warehouse Replenishment by E3', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'JDA Software Group Assortment Planning by Arthur', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Kliger-Weiss Infosystems software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Material requirement planning MRP software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Millennium Software Atrex', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Oracle Advanced Procurement', 43231503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Oracle PeopleSoft Enterprise Supply Planning Multi-Site Material Planner', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Plexis Software Plexis POS', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Point of sale POS software', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'POSitive Software POSitive for Windows', 43232611, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Presentation software', 43232106, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Product development management software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Project management software', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Sage ERP Accpac', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'SAP POS Data Management', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Scheduling software', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Sourcing Simulator', 43231503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Specialized Business Solutions Keystroke POS', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Spreadsheet software', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Windward Software Windward System Five', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1022.00', 'Technology', 'Word processing software', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Tools', 'Scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Accounting software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Apple AppleWorks', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Assured Software JPP', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Choice Job Cost', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Construction Management Software ProEst', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Corel QuattroPro', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Cost accounting software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Cost estimation software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'CPR International GeneralCOST Estimator', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'CPR Visual Estimator', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Data base reporting software', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Dexter + Cheney Spectrum Construction Software', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Financial analysis software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Galorath SEER-SEM', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Google AdWords', 43231514, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'IBM Costimater', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'IBM Lotus 1-2-3', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'IBM Notes', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Infor ERP SyteLine', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Intuit QuickBooks software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Inventory management system software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Microsoft Great Plains software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'National Job Cost software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'QSM SLIM', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Resources Calculations Incorporated SoftCost', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Sage 100 Contractor', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Softstar Costar COCOMO II', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Software AG software', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'WinEstimator WinEst', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1023.00', 'Technology', 'Xactware Xactimate', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Tools', 'Notebook computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Tools', 'Scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Agency Management Systems AMS 360', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'AutoClaims Direct DirectLink', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Automatic Data Processing Autosource', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Automatic Data Processing Claims Manager & Dispatch', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Axonwave Fraud and Abuse Management System', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'BCCORP W5 for Adjusters', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Bill review software', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Bramerhill ClaimsTech', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Bridium Claims 3', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Brightwork Alyce Claims Systems', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Captiva InputAccel', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Castek Insure3 Claims', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'CCC EZNet electronic communications network', 43232901, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'CCC GuidePost Decision Support', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'CCC Pathways Appraisal Quality Solution', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'CCC Pathways Image Management Solution', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'CCC TL2000 Solution', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'CGI INSideOUT', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Claims processing administration and management software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Clear Technology Tranzax', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Computerized voice stress analyzer CVSA software', 43232703, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Corporate Systems ClaimsPro', 43232305, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Covansys ClaimConnect', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'CSC Automated Work Distributor AWD', 43232901, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'CSC Fault Evaluator', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Datanex ClaimTrac', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Document management system software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Fair Isaac Claims Advisor', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Fair Isaac SmartAdvisor', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'First Notice Systems ClaimCapture', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Healthcare common procedure coding system HCPCS software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Hummingbird Legal Bill Review', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Hyland OnBase Enterprise Content Management', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'IBM Fraud and Abuse Management System', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Insurance claims fraud detection software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'InSystems Calligo Document Management System', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'ISO ClaimSearch', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'ISO NetMap for Claims', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'LexisNexis RiskWise', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Magnify Predictive Targeting System', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Medical condition coding software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Medical procedure coding software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'StrataCare StrataWare eReview', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.01', 'Technology', 'Tropics Claims Reserve Management', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Tools', 'Data collectors', 43211715, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Tools', 'Event data recorders', 25173303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Tools', 'Field computers', 43211715, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Tools', 'Handheld computers', 43211715, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Tools', 'Measure markers', 41111616, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Tools', 'Mobile wireless handheld communication devices', 43211715, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Tools', 'Total stations', 41114204, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', '4n6xprt Systems StiffCalcs', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Agency Management Systems AMS 360', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'ARSoftware WinSMAC', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Autoclaims Direct DirectLink', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Automatic Data Processing Autosource', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Automatic Data Processing Claims Manager & Dispatch', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Automatic Data Processing Estimating', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Automatic Data Processing software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Axonwave Fraud and Abuse Management System', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'BCCORP Burkitt W5', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Bill review software', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Bramerhill ClaimsTech', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Bridium Claims 3', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Brightwork Alyce Claims Systems', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'CAD Zone Insurance', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Captiva InputAccel', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Castek Insure3 Claims', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'CCC EZNet electronic communications network', 43232901, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'CCC GuidePost Decision Support', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'CCC Pathways Appraisal Quality Solution', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'CCC Pathways Image Management Solution', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'CCC TL2000 Solution', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'CGI INSideOUT', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'CGI-AMS BureauLink Enterprise', 43232309, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Claims processing administration and management software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Clear Technology Tranzax', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Computerized voice stress analyzer CVSA software', 43232703, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Corporate Systems ClaimsPro', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Covansys ClaimConnect', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'CSC Automated Work Distributor AWD', 43232901, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'CSC Colossus', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'CSC Fault Evaluator', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Datanex ClaimTrac', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Document management system software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Fair Isaac SmartAdvisor', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'First Notice Systems ClaimCapture', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Hummingbird Legal Bill Review', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Hyland OnBase Enterprise Content Management', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'IBM Fraud and Abuse Management System', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Injury Sciences EDR InSight', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Insurance claims fraud detection software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'InSystems Calligo Document Management System', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'ISO ClaimSearch', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'ISO NetMap for Claims', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'LexisNexis RiskWise', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Magnify Predictive Targeting System', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'MapScenes Evidence Recorder', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'MapScenes Pro', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'PhotoModeler software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Property damage, bodily injury, and liability estimation software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'QwikQuote software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Simsol for Adjusters', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'StrataCare StrataWare eReview', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Turtle Creek Software Goldenseal Architect', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1031.02', 'Technology', 'Visual Statement Investigator Suite', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Tools', 'Compact digital cameras', 45121504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Tools', 'Computer laser printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Tools', 'Electronic digital theodolites', 41114204, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Tools', 'Hand calculators', 44101807, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Tools', 'Laser facsimile machines"', 44101508, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Tools', 'Measure markers', 41111616, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Tools', 'Measuring tapes', 27111801, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Tools', 'Tire tread depth gauges', 41111614, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Technology', 'A-T Solutions Easy Street Draw', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Technology', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Technology', 'App Software Associations AppTrak.net', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Technology', 'Cost estimating software', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Technology', 'Information Services Inc. CCC Pathways Appraisal Solution', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Technology', 'Meridian Technologies SurePoint', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Technology', 'Mitchell International Mitchell WorkCenter', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Technology', 'NCH Software Express Invoice', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Technology', 'Solera Audatex Estimating', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Technology', 'Swan River Software Estimiser Pro', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Technology', 'Vertafore ImageRight', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1032.00', 'Technology', 'Web-Est', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Aluminum ladders', 30191501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Atmosphere monitors', 41104008, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Bacon bomb samplers', 41104004, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Benthic grab samplers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Bladder pumps', 40151520, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Bottom fill bailers', 41104005, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Box corers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Bucket augers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Centrifugal water sampling pumps', 40151520, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Chlorine samplers', 41113117, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Chlorophyll-a probes', 41113002, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Colorimetric field sampling devices', 41115318, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Composite liquid waste samplers COLIWASA', 41104006, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Conductance meters', 41115609, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Continuous flame ionization detectors FID', 41113004, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Continuous water quality monitors', 41113319, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Dataloggers', 43211715, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Differential photometers', 41115311, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Dissolved oxygen probes', 41115611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Double check valve bailers', 41104005, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Ekman grab samplers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Enzyme immunoassay kits', 41113309, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Extractive Fourier transform infrared FTIR spectrometers', 41115408, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Flowmeters', 41112501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Fuel fluorescence detectors FFD', 41113105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Graphite furnace atomic absorption GFAA spectrometers', 41115407, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Gravity corers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Ground penetrating radar GPR', 41115201, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Groundwater sampling peristaltic pumps', 41105102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Hand corers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Hand sampling pumps', 40151506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Headspace vials', 41121806, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Helium-neon lasers', 41115307, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Hydraulic vibracorers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Inductively coupled plasma ICP spectrophotometers', 41115411, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Infrared IR spectrometers', 41115408, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Interferometers', 41115306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Ion selective electrode ISE testers', 41115606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Kemmerer depth samplers', 41104007, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Laboratory analytical balances', 41111517, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Laboratory dropping pipettes', 41121513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Laser-induced breakdown spectrometers LIBS', 41115403, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Laser-induced fluorescence LIF instruments', 41113105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Liquid chromatographs LC', 41115705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Liquid grab samplers', 41104007, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Magnetic locators', 41113806, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Mass spectrometers', 41115404, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Measuring cylinders', 41121805, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Membrane interface probes MIP', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Mercury vapor analyzers', 41113117, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Mobile cone penetrometer MCP systems', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Optical beamsplitting devices', 31242201, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Passive diffusion bag PDB samplers', 41104007, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'pH indicators', 41115603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Photoionization detectors PID', 41113005, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Piezoelectric sensors', 41112101, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Ponar dredge samplers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Pond samplers', 41104007, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Portable gas chromatographs GC', 41115703, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Portable mass spectrometers MS', 41115404, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Portable two way radios', 43191510, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Power augers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Progressive cavity sampling pumps', 40151553, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Reciprocating piston sampling pumps', 40151557, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Rotary hammer systems', 20111608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Russian peat borers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Sample bottles', 41104017, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Sample collection chambers', 41104017, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Sampling triers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Sand corers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Scaffolding', 30191502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Sediment sieves', 41105003, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Shelby tube samplers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Specific conductance probes', 41115609, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Spectrophotometers', 41115406, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Split core samplers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Split spoon samplers', 41113909, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Suction-lift pumps', 41105102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Surface acoustic wave sensors SAWS', 41111939, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Syringe pumps', 41105104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Thief samplers', 41104005, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Total petroleum hydrocarbon TPH analyzers', 41113105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Turbidity probes', 47101516, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Ultraviolet fluorescence UVF test kits', 41113105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Van Dorn samplers', 41104007, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Van Veen grab samplers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Volatile organic compound VOC measurement devices', 41113315, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Waste pile samplers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Wastewater samplers', 41104007, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Water quality data sondes', 41113319, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Water sampling gear pumps', 40151551, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Weighted bottle samplers', 41104007, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Wheaton dip samplers', 41104007, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'Wireline samplers', 41113909, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Tools', 'X ray fluorescence XRF spectrometers', 41115401, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Technology', 'Adobe Systems Adobe Acrobat software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Technology', 'Database software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Technology', 'DQO-PRO', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Technology', 'Environmental Knowledge and Assessment Tool EKAT', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Technology', 'Field Operations and Records Management System (FORMS) II Lite', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Technology', 'Fully Integrated Environmental Location Decision Support FIELDS', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Technology', 'Geographic information system GIS software', 43233506, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Technology', 'HRS Quickscore', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Technology', 'Mass Flux Toolkit', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Technology', 'Monitoring and Remediation Optimization System MAROS', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Technology', 'Rapid Assessment Tools R.A.T.', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Technology', 'Scribe', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Technology', 'Spatial Analysis and Decision Assistance SADA', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.01', 'Technology', 'Sustainable Management Approaches and Revitalization Tools SMARTe', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Tools', 'Barcode scanners', 43211701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Tools', 'Digital cameras', 45121504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Tools', 'Document scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Tools', 'Electric typewriters', 44102602, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Tools', 'Facial recognition systems', 43211714, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Tools', 'Fingerprint capture devices', 43211714, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Tools', 'Fingerprint recognition systems', 43211714, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Tools', 'Iris recognition systems', 43211714, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Tools', 'License or identification card printers', 43212110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Tools', 'Magnetic stripe readers', 43211702, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Tools', 'Magnifying glasses', 41111713, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Tools', 'Point of sale POS receipt printers', 43212112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Tools', 'Snellen eye charts', 42183001, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Tools', 'Testing workstations', 43211510, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Tools', 'Ultraviolet UV lights', 39101616, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Tools', 'Vision screening equipment', 42183034, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Technology', 'Commercial driver''s license information system CDLIS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Technology', 'Computer-assisted testing software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Technology', 'Database software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Technology', 'Digital imaging system software', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Technology', 'Document scanning software', 43232111, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Technology', 'Driving simulators', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Technology', 'National Driver Register NDR', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Technology', 'Safety Status Measurement System SafeStat', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.02', 'Technology', 'Traffic record databases', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Bashen EEOFedSoft', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Bashen EEOSoft', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Bashen LinkLine', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Berkshire Associates BALANCEaap', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Biddle Adverse Impact Toolkit', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Biddle AutoAAP', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Corel WordPerfect software', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Database software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'EEO Made Simple AAPMaker', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'EEO Made Simple Applicant Tracking Software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Equal employment opportunity EEO compliance software', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Equitas EEOStat', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Gerstco AAPBase', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'IBM Lotus 1-2-3', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Peopleclick AAPlanner', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Peopleclick CAAMS', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Peopleclick Monitor', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Peopleclick PayStat', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Speediware SpeedEEO', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.03', 'Technology', 'Yocum & McKee The Complete AAP', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Tools', 'Radio frequency identification RFID scanners', 52161522, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'BrioQuery', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Coeus', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Database software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Deltek Costpoint', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Inventory control system software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Microsoft NetMeeting', 43233502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Peninsula Software Quicktrack Pro', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Plant Clearance Automated Reutilization Screening System PCARSS', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Radio frequency identification RFID software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Records management software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Shipping software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Unique Identification UID system databases', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.04', 'Technology', 'Wide Area Workflow WAWF system', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', '35 millimeter cameras', 45121501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Autopsy bone saws', 42261512, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Autopsy evidence collection kits', 42261904, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Autopsy fluid collection vacuum aspirators', 42261610, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Autopsy knives', 42261505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Autopsy saws', 42261512, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Autopsy scissors', 42261501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Binocular light compound microscopes', 41111709, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Bone cutters', 42261512, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Bone dust collectors', 42261601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Cadaver lifts', 42261809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Dictation equipment', 44102605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Digital autopsy scales', 42261606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Digital cameras', 45121504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Digital video cameras', 45121516, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Dissecting knives', 42261505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Dissection forceps', 42261502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Dissection scissors', 42261501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Enterotomes', 42261501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Floor scales', 41111509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Microscope slides', 41122601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Portable x ray machines', 42201815, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Postmortem blood drawing syringes', 42261903, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Postmortem fingerprint equipment', 42261901, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Postmortem suturing needles', 42261508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Protective coveralls', 42131605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Protective eye shields', 46181702, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Rib cutters', 42261512, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Skull chisels', 42261506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Specimen collection containers', 42261607, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Specimen scales', 42261606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Staining dishes', 41121810, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Stryker saws', 42261512, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Surgical gloves', 42132205, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Surgical masks', 42131606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Surgical scalpels', 42291613, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Tabletop centrifuges', 41103903, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Toothed forceps', 42261502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Tools', 'Triple beam balances', 41111512, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', '3D graphics software', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Alcestis', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Autopsy information databases', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Bite analysis software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Corel WordPerfect software', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Douglas Associates Forensic Filer', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Fingerprint databases', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Genetic database software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Graphics software', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Ingenuware CoronerBase', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Mideo Systems EZDoc Plus', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Rapid Medical Examiners System', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Spreadsheet software', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Toxicology databases', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.06', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Tools', 'Computer data input scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Adobe Systems Adobe Acrobat software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Analyse-it', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Atrion Intelligent Authoring', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'DataVision software', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Healthcare common procedure coding system HCPCS software', 43232610, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Integrated development environment IDE software', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'LexisNexis software', 43232309, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Medical procedure coding software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'MicroStrategy software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Statistical software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1041.07', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Tools', 'Notebook computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Tools', 'Scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Apple AppleWorks', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Assured Software JPP', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Autodesk AutoCAD', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Autodesk Revit', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Choice Job Cost', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Computer aided design and drafting CADD software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'ConEst BidTrac', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'ConEst Electrical Formulas', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'ConEst Intellibid', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'ConEst IntelliBid Design Build', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'ConEst JobTrac', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'ConEst Permit Trac', 43231512, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'ConEst SureCount', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'ConEst T&M Billing Manager', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Construction Management Software ProEst', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Corel QuattroPro', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Cost accounting software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Cost estimation software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'CPR International GeneralCOST Estimator', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'CPR Visual Estimator', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Dassault Systemes CATIA software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Decisioneering Crystal Ball', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'EFI Hagen OA', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Galorath SEER software', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Galorath SEER-SEM', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'HCSS HeavyBid', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'HCSS HeavyJob', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Hyperion software', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'IBM Costimater', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'IBM Lotus 1-2-3', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Intuit QuickBooks software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'JD Edwards software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Laserfiche Avante', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Logic Software Easy Projects.NET', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Microsoft Business Contact Manager', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'National Job Cost software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Oracle Primavera Enterprise Project Portfolio Management software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Palisade @Risk', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'PRICE Sytems TruePlanning', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Primavera Cost Management', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'QSM SLIM', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Resources Calculations Incorporated SoftCost', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Sage 100 Contractor', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Sage 300 Construction and Real Estate', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Softstar Costar COCOMO II', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Software AG software', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'WinEstimator WinEst', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1051.00', 'Technology', 'Xactware Xactimate', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Tools', 'Computer scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Tools', 'Digital audio recorders', 52161535, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Tools', 'Digital video disk DVD players', 52161516, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Tools', 'Liquid crystal display LCD projectors', 45111614, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Tools', 'Office inkjet printers', 43212104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Tools', 'Video projectors', 45111609, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Tools', 'Web conferencing cameras', 45121506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Ad Cast', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Adobe Systems Adobe Fireworks', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Adobe Systems Adobe Human Capital Application Solution Accelerator', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Adobe Systems Adobe LifeCycle Enterprise Suite', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Adobe Systems Adobe Photoshop software', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Advanced business application programming ABAP', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Apple Final Cut Pro', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Applicant tracking software', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Arbita OnePost', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Arbita OneWorld', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Assessment software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'AST Staff Matrix', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Background checking software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Blackdog', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'BlackDog Recruiting Software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Bond International Adapt Staffing', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Bond International Software Bond StaffSuite', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'BrightMove Applicant Tracking System', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Bullhorn', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Bullhorn Applicant Tracking System', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Candidate screening software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Candidate tracking software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Careerbuilder.com', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Cluen', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Cluen Encore', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'COATS', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'COATSsql', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'CVTracer', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Data Frenzy software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'DGCC.com RecruitTrack', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Drupal', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Ellucian Banner Human Resources', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Enterprise JavaBeans', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'eQuest', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Facebook', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'GoBackgrounds', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Google', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Google AdWords', 43231514, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Google Analytics', 43232307, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'HireAbility ResumeParser', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'HireLogic PowerPlace', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'HodesiQ software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'HRMDirect', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'HRMDirect software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Human resource information system HRIS software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'iApplicants', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'IBM Notes', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'ICIMS', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Industrial Code Recruitpoint.net', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'InfoGIST Platinum Recruiter', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Intelius', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Intelligent Algorithms InfoGIST Platinum Recruiter', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Job Match iApplicants', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Job posting software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Kronos Workforce HR', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Kronos Workforce Payroll', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Lawson Human Resource Management Suite', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'LexisNexis software', 43232309, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'LinkedIn', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Main Sequence Technologies PCRecruiter', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Main Sequence Technologies PCRecruiter ResumeInhaler', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'MEDITECH software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Micro J Systems PcHunter', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Microj Systems PcHunter', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Microsoft Dynamics software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Microsoft SharePoint', 43233503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'MicroStrategy software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Monster.com', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'MPAY Millennium', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Online databases', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Oracle Eloqua software', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Oracle PeopleSoft Human Capital Management', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Oracle Primavera Enterprise Project Portfolio Management software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Oracle Solaris', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Oracle WebLogic Server', 43232701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Post My Jobs', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Post Once', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'PostingPal', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'PowerPlace Professional', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Recruiting Wizard', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Recruitment management software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Recruitpoint.net', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'RecruitTrack', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Resource Edge TalentHook Sphere', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Resume converter software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Resume extraction and search software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Resume processing software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'ResumeRobot', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Safari Software Products Safari Staffing Software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Safari Staffing Software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Sage 50 Accounting', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Salesforce software', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'SAP Business Objects software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'SAP ERP Human Capital Management', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'SAS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Sendouts Pro Recruiting Software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Sendouts Recruiting Software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Silk Road technology OpenHire', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'SPSS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Staffing Solutions Enterprises Staff Matrix', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'StaffingSoft Staffing Edition', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Tableau software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Talent Technology HireDesk', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Talent Technology Resume Mirror', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Talent Technology Talemetry', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'TalentHook', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Taleo Enterprise Talent Management Suite', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Technomedia Hodes iQ', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'TempWorks', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'TempWorks software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Trovix', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Trovix Recruit', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'VCG Pointwing', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'VCT StaffSuite', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Vendor management system software', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Walling Info Systems Recruiting Wizard', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1071.00', 'Technology', 'YouTube', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Tools', 'Computer data input scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Tools', 'Handheld calculators', 44101807, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Tools', 'Passenger cars', 25101503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Tools', 'Pickup trucks', 25101507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Tools', 'Smart phones', 43191501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Technology', 'Bookkeeping software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Technology', 'E-Verify', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Technology', 'Financial accounting software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1074.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Tools', 'Digital copiers', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Tools', 'Handheld calculators', 44101807, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Tools', 'Image scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Tools', 'Office inkjet printers', 43212104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Technology', 'Internet Grievance System IGS', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Technology', 'LaborSoft LaborForce Arbitration/Appeals Manager module', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Technology', 'LaborSoft LaborForce Discipline Manager module', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Technology', 'LaborSoft LaborForce EEO Claims Manager module', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Technology', 'LaborSoft LaborForce Grievance Manager module', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Technology', 'LaborSoft LaborForce Incident Tracking module', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Technology', 'LaborSoft LaborForce Personnel Manager module', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Technology', 'LaborSoft LaborForce Reporting/Dashboard Manager module', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Technology', 'Micropact entellitrak Labor Relations Edition', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1075.00', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Tools', 'Liquid crystal display LCD video projectors', 45111614, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Tools', 'Personal computer platforms', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Tools', 'Teradyne Catalyst', 41113706, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Tools', 'Teradyne J750 testers', 41113706, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Tools', 'Universal serial bus USB flash drives', 43201813, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Tools', 'Workstation platforms', 43211508, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Autodesk AutoCAD software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Customer relationship management CRM software', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Intuit QuickBooks software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Oracle E-Business Suite', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Oracle Primavera Enterprise Project Portfolio Management software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Order management software', 43231503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Purchasing software', 43231503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Radio frequency identification RFID software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'RedPrairie E2e', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Warehouse management system WMS software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Tools', 'Computer laser printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Tools', 'Digital cameras', 45121504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Tools', 'Multimedia projection equipment', 45111609, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Tools', 'Multimedia projectors', 45111609, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Autodesk AutoCAD software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'C++', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Failure modes and effects analysis FMEA software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'i2 Transportation Modeler', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'IBM ILOG CPLEX/Dispatcher', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'IBM Notes', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'ITEM Software ITEM ToolKit', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'ITEM Software Spare Cost', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'JDA Manugistics software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'JMS Software RCM WorkSaver', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Logistics Cost Estimating Tool', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Logistics management information LMI database software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Logistics Support Analysts SmartLogic', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'LOGSA COMPASS', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'LOGSA SYSPARS', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Minitab software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Oracle Hyperion software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Oracle Java', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Oracle Primavera Enterprise Project Portfolio Management software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Prolog', 43232402, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Relex FMEA', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Reliability centered maintenance RCM software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'ReliaSoft RCM++', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'ReliaSoft XFMEA', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Reliass EAGLE', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'SAP Business Objects software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.01', 'Technology', 'Warehouse management system WMS software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Tools', 'Computer data input scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Tools', 'Computer laser printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Tools', 'Photocopiers', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', '3PL Central', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Advanced business application programming ABAP', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Cadre Technologies Accuplus Integrated Distribution Logistics System', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'ESRI ArcLogistics', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Fleet management software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Flow chart software', 43232101, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Four Soft 4S eLog', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Four Soft 4S VisiLog', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Graphics software', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'IntelliTrack 3PL', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Inventory control software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Logisuite Enterprise', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Logisuite Forwarder', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Microsoft SQL Server software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Microsoft Windows', 43233004, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'MicroStrategy software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Minitab software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Optimization software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Oracle E-Business Suite Logistics', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Oracle Hyperion software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Oracle Primavera Enterprise Project Portfolio Management software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Reporting software', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'SAP Business Objects software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Spreadsheet software', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'SPSS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Tableau software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1081.02', 'Technology', 'Warehouse management system WMS software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Tools', 'Liquid crystal display LCD video projectors', 45111614, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Tools', 'Universal serial bus USB flash drives', 43201813, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Adobe Systems Adobe Fireworks', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Advanced business application programming ABAP', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Apache Cassandra', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Apache Hive', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Apache Maven', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Apache Pig', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Apache Solr', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Apache Tomcat', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'C#', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'C++', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'CA Erwin Data Modeler', 43232310, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Ceridian software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Citrix software', 43232901, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Common business oriented language COBOL', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Customer information control system CICS', 43232313, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Delphi software', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Drupal', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Dynamic hypertext markup language DHTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Eclipse software', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Enterprise JavaBeans', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Epic Systems software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Fund accounting software', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Git', 43232203, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Google Analytics', 43232307, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Healthcare common procedure coding system HCPCS software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Hewlett Packard HP-UX', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Hewlett Packard LoadRunner', 43232406, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'IBM Cognos ReportNet', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'IBM Domino', 43232902, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'IBM InfoSphere DataStage', 43232403, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'IBM Notes', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'IBM Rational RequisitePro', 43232407, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'IBM WebSphere', 43232403, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Information Builders WebFOCUS', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Integrated development environment IDE software', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'JavaScript', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Job control language JCL', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'LexisNexis software', 43232309, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Linux', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Medical procedure coding software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft Business Intelligence BI', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft Dynamics software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft Exchange Server', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft SQL Server Reporting Services', 43232305, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft SQL Server software', 43232306, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft Team Foundation Server', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft Visual Basic Scripting Edition VBScript', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft Visual Studio', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'MicroStrategy software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Minitab software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'MongoDB', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Novell GroupWise', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Oracle Agile Product Lifecycle Management PLM', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Oracle Business Intelligence Publisher', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Oracle Eloqua software', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Oracle Hyperion software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Oracle Java', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Oracle JavaServer Pages JSP', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Oracle PL/SQL', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Oracle Primavera Enterprise Project Portfolio Management software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Oracle Solaris', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Oracle WebLogic Server', 43232701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Perforce Helix software', 43232401, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Practical extraction and reporting language Perl', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Python', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'R', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Red Hat Enterprise Linux', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Red Hat WildFly', 43232701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Relational database management software', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Ruby on Rails', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Sage 50 Accounting', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Salesforce software', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'SAP Business Objects software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'SAS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Splunk Enterprise', 43233701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'SPSS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Sybase software', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Symantec security software', 43233205, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Tableau software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Tax software', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Teradata Database', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Transact-SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Unified modeling language UML', 43232407, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'UNIX', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1111.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Tools', 'Overhead display projectors', 45111607, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Tools', 'Public address PA systems', 45111705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Tools', 'Two way radios', 43191510, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Tools', 'Video projectors', 45111609, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Tools', 'Videoconferencing equipment', 45111902, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Active Network EventRegister', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Adobe Systems Adobe Photoshop software', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Certain software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Convention Industry Council CIC APEX Toolbox', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Dean Evans & Associates EMS Professional', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Delphi Discovery', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Delphi software', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'IBM Lotus Notes', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Lenos software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'MeetingMatrix International software', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'MemberClicks COMPLETE', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'NSF Hospitality Rendezvous Events', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Oracle Primavera Enterprise Project Portfolio Management software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Planstone software', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Spreadsheet software', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1121.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Tools', 'Computer laser printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Tools', 'Passenger cars', 25101503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Tools', 'Tablet computers', 43211509, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Adobe Systems Adobe PageMaker', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'AudienceView Ticketing', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Blackbaud eTapestry', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Blackbaud Luminate CRM', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Constant Contact software', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Corel CorelDraw Graphics Suite', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Facebook', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Foundatino Directory Online (FDO)', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'SofterWare DonorPerfect', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Tessitura Network Tessitura Software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'TheaterMania OvationTix', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Twitter', 43233504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'WealthEngine Findwealth', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1131.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Tools', 'Electronic storage devices', 43201803, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Actuarial Systems Corporation AIM', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Actuarial Systems Corporation Compliance Testing System', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Actuarial Systems Corporation Defined Benefit System', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Actuarial Systems Corporation Document Generation and Management System', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Actuarial Systems Corporation DV Direct', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'ADP Enterprise eTime', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Apex Business Software iBenefits', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Ascentis Employee Self-Service', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Ascentis HR', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Bargaining Power', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'BEMAS Benefit Management Software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'BEMAS PayDirect', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Benaissance COBRApoint', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'BenAssist', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Benefit Plan Systems Corporation The Plan Administrator', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Benefit Software Fringe Facts', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'BenefitFocus HR in Touch', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'BeneLink Connect', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Benelogic', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'BeneXL Technologies Pension Administration System', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Byrne Software Technologies Visual HCS', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Callidus TrueComp', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Ceridian software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Clayton Wallis CompGeo Online Professional Forecast Library', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'DataPath dpiSuite', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Document management system software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Ebenefits Solutions Benefits Management', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Employee self-service software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Halogen eCompensation', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Healthcare common procedure coding system HCPCS software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Human resource information system HRIS software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Humanic Design Employmee Self-Service', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Humanic Design Human Resources Management System', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'IBM Cognos', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Incentive management system software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'InfinityHR', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Kronos Workforce Timekeeper', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Lawson software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Lynchval Systems Lvadmin', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Lynchval Systems Lvval', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Lynchval Systems Lvxact', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Medical condition coding software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Medical procedure coding software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'NPKTools Comp Analytics', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'NPKTools CompXpert', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'O*NET OnLine', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'OnQue Technologies COBRA OnOne', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Oracle E-Business Suite Human Resources Management System', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Project planning software', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Relational database management software', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Sage Abra', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Salary.com', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'SAP ERP Human Capital Management', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'SAS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'SBC Systems Benefits Workstation', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Stroud & Associates Employee Benefits Administration System', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Survey Sense', 43231505, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Synygy', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Transcend Technologies Group benefitsCONNECT', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Travis Software TravisFlex', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Ultimate Software UltiPro Workplace', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Vebnet FIX&FLEX', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Virtual Benefits Administrator', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Vitech Systems Group V3 Benefits Administration System', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'VUE Benefits Manager', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'VUE Compensation Management', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Watson Wyatt CompQuest On-Line', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Watson Wyatt Global Grading System', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Watson Wyatt Reward', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Word processing software', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Workscape Outsourced Employee Benefits Administration', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1141.00', 'Technology', 'Xactly Compel', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Tools', 'Laser printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Tools', 'Liquid crystal display LCD projectors', 45111614, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Tools', 'Overhead display projectors', 45111607, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Adobe Systems Adobe Authorware', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Adobe Systems Adobe Captivate', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Adobe Systems Adobe Fireworks', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Adobe Systems Adobe Flash', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Adobe Systems Adobe Photoshop software', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Adobe Systems Adobe Presenter', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Alchemy Systems SISTEM', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Apple Final Cut Pro', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Articulate Rapid E-Learning Studio', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Beeline Learning Management System LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Blackboard software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Blatant Media Absorb LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Brainshark Rapid Learning', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Cisco Systems WebEx', 43233502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Citrix software', 43232901, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Cobent Learning and Compliance Suite LCS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Computer Generated Solutions Learning Management System', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'dominKnow Learning Center', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Drupal', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Eedo Knowledgeware Eedo Force Ten', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'ElearningForce JoomlaLMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Epic Systems software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'EZ LCMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'FlexTraining Total e-Learning Solution', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'G-Cube Solutions Wizdom Web LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'GeoMetrix Data Systems Training Partner', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Halogen eLMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'HP TRIM software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'IBM Notes', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'ICS Learning Group Inquisiq EX', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Ikonami AT-Learning Tool', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Inspired eLearning iLMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Intelladon Enterprise Knowledge Platform EKP', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Intelligent Information Conversion Technologies MeritScholar', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Intellum Rollbook', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Interwoven software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'JavaScript', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Learn HQ Activate LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Medworxx Learning Management System', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Microsoft NetMeeting', 43233502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'MySQL software', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Mzinga On-Demand Learning Suite', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'NetDimensions Enterprise Knowledge Platform EKP', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'OnPoint Digital OnPoint Learning & Performance Suite', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Operitel LearnFlex', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Oracle PL/SQL', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Oracle Solaris', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Oracle WebLogic Server', 43232701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Pathlore LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Plateau Learning Management System LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Prezi', 43232106, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'PRO-ductivity Systems Compliance Training Manager Web', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Qarbon ViewletBuilder Professional', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Right Reason Technologies RightTrack', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'RISC Virtual Training Assistant', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'SkillSoft SkillPort', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'SPSS software', 43232605, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'SumTotal Systems ToolBook', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'SumTotal Systems TotalLMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'techniques.org knowledgeWorks LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Telania eLeaP Learning Management System LMS/LCMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'The Human Equation InSite LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'TrainCaster LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'TrainOnTrack Learning Management System LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Upside Learning UpsideLMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Xerceo Learn', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Xyleme Learning Content Management System LCMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1151.00', 'Technology', 'Ziiva Prosperity LMS', 43232502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Tools', 'Notebook computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Tools', 'Scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', '37Signals Basecamp', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'AcaStat software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Adaptive conjoint analysis ACA software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Adobe Systems Adobe ActionScript', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Adobe Systems Adobe AfterEffects', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Adobe Systems Adobe Fireworks', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Adobe Systems Adobe Flash', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Adobe Systems Adobe Flash Player', 43232107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Adobe Systems Adobe Photoshop software', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'ADXSTUDIO software', 43232201, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'AndersonBell Abstat', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Apache Hadoop', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Apache Hive', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Apple Final Cut Pro', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Aprimo Marketing', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Cascading Style Sheets CSS', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Claritas software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'ClassApps SelectSurveyASP', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Cytel LogXact', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Cytel Software XLMiner', 43232307, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Data analysis software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Delphi software', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Digivey software (expert system feature)', 43231511, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Digivey software (point of sale feature)', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Drupal', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Dynamic hypertext markup language DHTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Epiphany software', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'ESRI ArcGIS software', 43233506, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Extensible HyperText Markup Language XHTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Facebook', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Factiva', 43232309, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'FedBizOps', 43232309, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Financial planning software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Galilee Enterprise TargetPro', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Geographic information system GIS marketing software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'GMI NET-MR', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Google AdWords', 43231514, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Google Analytics', 43232307, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'IBM IMS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'IBM Intelligent Miner', 43232307, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'INPUT analysis software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Insightful Corporation Confirmit', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Insightful S-PLUS', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Intellimed software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'JavaScript', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Key Survey software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'LexisNexis software', 43232309, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'LinkedIn', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'LogiXML Ad-HOC', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'MapMaker software', 43232301, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Medstat/INFORUM', 43232309, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Microsoft Dynamics software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'MicroStrategy software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Minitab software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Mintel Reports', 43232309, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'NCR Teradata Warehouse Miner', 43232307, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Neoforma Healthcare Products Information Services HPIS Market Intelligence', 43232309, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Oracle Darwin', 43232307, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Oracle Eloqua software', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Oracle software', 43232306, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Palisade StatTools', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Perseus SurveySolutions', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Presentation software', 43232106, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Provalis Research Simstat', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'R', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Sage ACT!', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Salesforce software', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'SAP Business Objects software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'SAS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Sawtooth Choice-Base Conjoint CBS', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Sawtooth Composite Product Mapping CPM', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Sawtooth SSI Web', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Solucient software', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'SPSS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'StataCorp Stata', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'StatPac software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Survey software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Symantec security software', 43233205, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Tableau software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'TechExcel software', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Teradata Database', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Thomson Dialog', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Thomson Financial Investext', 43232309, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'TNS MarketWhys', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'TNS Miriad', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'TranspoLink BidLeads', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'UNISTAT Statistical Package', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Vantage MCIF', 43232303, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Verispan Patient Parameters', 43232309, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Walmart Retail Link', 43232309, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'WinCross software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'Word processing software', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1161.00', 'Technology', 'YouTube', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Air current testers', 41112509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Blower doors', 41111809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Carbon dioxide CO2 testers', 41113117, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Carbon monoxide detectors', 41113120, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Combustible gas monitors', 26131701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Computer data input scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Dataloggers', 43211715, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Digital infrared thermometers', 41112202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Digital multimeters', 41113630, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Digital still cameras', 45121504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Digital video cameras', 45121516, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Draft gauges', 41112509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Duct probe velometers', 41112509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Electrical circuit tracers', 41113644, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Electricity monitors', 41113708, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Electronic hygrothermometers', 41114408, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Flue gas analyzers', 41113118, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Handheld digital thermometers', 41112213, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Heating system combustion analyzers', 41113102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Infrared cameras', 41115321, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Insolation meters', 41114407, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Light meters', 41115308, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Manometers', 41103311, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Recording anemometers', 41114401, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Sling psychrometers', 41112302, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Smoke generators', 41111809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Smoke pens', 41111809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Two way radios', 43191510, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Volt meters', 41113637, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Water flow meters', 41111931, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Tools', 'Wattmeters', 41113640, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Abraxas Energy Consulting Metrix', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Adobe Systems Adobe Photoshop software', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Architectural Energy Corporation ENFORMA Building Diagnostics', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Architectural Energy Corporation REM/Rate', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Architectural Energy Corporation VisualDOE', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Autodesk AutoCAD software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Autodesk ECOTECT', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'C++', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Computer aided design CAD software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Cool Roof Calculator', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'dBASE', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'DesignBuilder Software DesignBuilder', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'EffTec EffTrack', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Elite Software Energy Audit', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Enercom Energy Depot for Business', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Enercom Energy Depot for Homes', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Energy Efficient Rehab Advisor', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'EnergyPlus', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Facility Energy Decision Systems FEDS', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Federal Renewable Energy Screening Assistant FRESA', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Fielding Data Labs OptoMizer', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Fundamental Objects foAudits', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Good Steward Software EnergyCAP', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Home Energy Efficient Design HEED', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'InterEnergy Software Building Energy Analyzer PRO', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Itron Enterprise Energy Management EEM Suite', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Linux', 43233004, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Microsoft .NET Framework', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Microsoft Internet Explorer', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Microsoft MapPoint', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Microsoft Visual FoxPro', 43232311, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'MotorMaster+', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Onset Computer Corporation HOBOware', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Performance Systems Development TREAT', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Program for Energy Analysis of Residences PEAR', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Psychrometric chart software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Python', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'R', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Retrofit Energy Savings Estimation Model RESEM', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'SAS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'SPSS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Stellar Processes EZ Sim', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'The MathWorks MATLAB', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'The Weatherization Assistant', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Trane TRACE', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'UNIX', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.01', 'Technology', 'Wolfram Research Mathematica', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Tools', 'Approach detection systems', 46171608, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Tools', 'Audioconferencing equipment', 45111901, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Tools', 'Card readers', 46171524, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Tools', 'Closed circuit television CCTV monitoring systems', 46171622, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Tools', 'Computer network routers', 43222609, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Tools', 'Computer server equipment', 43211501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Tools', 'Digital video recorders', 45121516, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Tools', 'Electronic access control systems', 46171619, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Tools', 'Intrusion detection systems', 46171604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Tools', 'Magnetometers', 41113806, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Tools', 'Mechanical access control systems', 46171619, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Tools', 'Network video recorders', 45121516, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Tools', 'Videoconferencing equipment', 45111902, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Tools', 'X ray screening equipment', 41111808, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'AccessData FTK', 43232801, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Adobe Systems Adobe Acrobat software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Adobe Systems Adobe ActionScript', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Adobe Systems Adobe ColdFusion', 43232408, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Advanced business application programming ABAP', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'ArcSight Enterprise Threat and Risk Management', 43233701, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Autodesk AutoCAD software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'C', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'C#', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'C++', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Chinotec Technologies Paros', 43233205, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Cisco Systems CiscoWorks software', 43232804, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Citrix software', 43232901, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Database software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'e-fense Helix3', 43232801, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Enterprise JavaBeans', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Firewall software', 43233204, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Guidance Software EnCase Forensic', 43232801, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'IBM Informix', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Intrusion prevention system IPS software', 43233203, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'JavaScript', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Kismet', 43233204, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Linux', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Live memory collection software', 43232801, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'McAfee software', 43233205, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Metasploit', 43233205, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Microsoft .NET Framework', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Microsoft Windows', 43233004, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Microsoft Windows PowerShell', 43233004, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'MySQL software', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Nessus', 43233205, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Nmap', 43233205, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Oracle Java', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Oracle Java EE', 43232402, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Oracle JavaServer Pages JSP', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Oracle Solaris', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Photo editing software', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Physical access management software', 43232603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Practical extraction and reporting language Perl', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Python', 43232405, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Ruby', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Secure web gateway software', 43232912, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Social networking software', 43232107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Splunk Enterprise', 43233701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Symantec PGP', 43233204, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Symantec security software', 43233205, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Tivoli', 43232901, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'TrueCrypt', 43233204, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'UNIX', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Videoconferencing software', 43233502, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Virtual private networking VPN software', 43233204, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Volatile Systems Volatility', 43232801, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.02', 'Technology', 'Wireshark', 43232801, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Tools', 'Computer data input scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Tools', 'Multiline telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Technology', 'Automated commercial environment software ACE', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Technology', 'Automated system for customs data ASYCUDA', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Technology', 'Customs records databases', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Technology', 'Electronic data interchange EDI software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Technology', 'Materials requirements planning MRP software', 43231506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Technology', 'Optical character reader OCR software', 43232111, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Technology', 'Parts classification databases', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Technology', 'SAP Customs Management', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Technology', 'Tariff databases', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.03', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Tools', 'Computer laser printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Tools', 'Computer server equipment', 43211501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Tools', 'Mainframe computers', 43211512, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Tools', 'Multiline telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Tools', 'Storage area network equipment', 43201835, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Tools', 'Teleconferencing systems', 43221522, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Actuate software', 43232314, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Adobe Systems Adobe Acrobat', 43232202, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Business continuity software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'CA Clarity PPM', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Computer operating systems', 43233004, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'COOP Systems myCOOP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'EMC RSA Archer Business Continuity Management', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Emergency notification system software', 43232902, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Enterprise backup systems', 43233415, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Jaspersoft Business Intelligence Suite', 43232314, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Local area network LAN software', 43232905, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Microsoft Office SharePoint Server MOSS', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Microsoft SQL Server software', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'MIR3 Intelligent Notification software', 43232902, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Oracle Primavera Enterprise Project Portfolio Management software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'RecoveryPlanner RPX', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'SAP Crystal Solutions Software', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Strategic BCP ResilienceONE', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Sungard Assurance', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'SunGard NotiFind', 43233002, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Virtual Corporation Sustainable Planner', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.04', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Tools', 'Computer data input scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Tools', 'Computer laser printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Tools', 'Multi-line telephone systems', 43191507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Adobe Systems Adobe Acrobat software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Adobe Systems Adobe Illustrator', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Adobe Systems Adobe InDesign', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Adobe Systems Adobe Photoshop software', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Autodesk AutoCAD software', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Autodesk Revit', 43232604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Geographic information system GIS software', 43233506, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Google Analytics', 43232307, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Life cycle assessment LCA software', 43232605, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Microsoft Publisher', 43232112, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Online database search and retrieval software', 43232309, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'PE INTERNATIONAL GaBi software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'PE INTERNATIONAL SoFi software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'PRe Consultants SimaPro', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Quark software', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.05', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Tools', 'Credit card machines', 43211702, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Tools', 'External hard drives', 43202010, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Tools', 'Label printers', 43212101, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Adobe Systems Adobe Dreamweaver', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Adobe Systems Adobe Fireworks', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Adobe Systems Adobe Photoshop software', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'AJAX', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Apache Solr', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Apache Struts', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Blogging software', 43232107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'C#', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'CCBill software', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Content management systems CMS software', 43232107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Drupal', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Dynamic hypertext markup language DHTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'e-check software', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Enterprise JavaBeans', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Extensible HyperText Markup Language XHTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Extensible markup language XML', 43232403, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Facebook', 43232107, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Financial accounting software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Google AdWords', 43231514, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Google Analytics', 43232307, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Google Checkout', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Hypertext markup language HTML', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'IBM Digital Analytics', 43232314, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'IBM Domino', 43232902, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'IBM InfoSphere DataStage', 43232403, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'IBM WebSphere', 43232403, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Intuit Merchant Services software', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Intuit QuickBooks software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Inventory tracking software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'JavaScript', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'jQuery', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Kagi software', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'LAMP Stack', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Linux', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Magento software', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Microsoft .NET Framework', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Microsoft Project', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Microsoft Visual Studio', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Mobile application software', 43233508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'MyCommerce RegNow', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'MySQL software', 43232304, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Oracle Java', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Oracle JavaServer Pages JSP', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'PayPal', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'PHP: Hypertext Preprocessor', 43232408, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'ProPay software', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Search engine marketing SEM software', 43231514, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Search engine optimization SEO software', 43232314, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Search engine results pages SERP software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Shipment processing software', 43231515, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Snorasson Holdings CCNow', 43232611, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Twitter', 43233504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'Webtrends software', 43231514, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'WordPress', 43232107, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-1199.06', 'Technology', 'YouTube', 43232103, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Tools', 'Notebook computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Tools', 'Photocopying equipment', 44101501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Tools', 'Scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', '1099 ProsSoftware', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Abacus Tax Software', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Accountants Templates JAZZ-It!', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Accounting compliance software', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Accounting fraud detection software', 43231604, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Accounts payable software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Accounts receivable software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'ACCUCert software', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Accurate NXG', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Accutrac software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'AcornSystems Corporate Performance Management', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'AcorynSystems Activity Based Costing/Management ABC/M', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'AdaptaSoft CyberPay', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'ADP Super Report Writer', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'ADP Workforce Now', 43231505, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Advanced Micro Systems 1099-Etc', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'AIM Asset Management Software', 43231508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'American Riviera Magtax', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Asset management software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'ATX Total Accounting Office', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'ATX Total Engagement Office', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'ATX Total Tax Office', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'AuditWare software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Automation Counselors municiPAL', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Avalara AvaTax ST', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Best MIP Fund Accounting', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Best Software CPAPayroll', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Billing software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Blackbaud The Raiser''s Edge', 43232303, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'BNA Estate and Gift Tax Suite', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'BNA Income Tax Planning Solutions', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'BNA Sales and Use Tax Rates and Forms', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Brentmark Estate Planning Quickview', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Cammack Computations Inter-Est', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Cartesis ES Magnitude', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Cartesis Magnitude iAnalysis', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'CCH ProSystem fx TAX', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'CCIS AccountAbility', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Cost accounting software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'CPSI EHR System', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Creative Solutions UltraTax 1040', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'CYMA IV Accounting for Windows', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Delphi software', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Document management system software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Estate planning software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Evron Computer Systems SAGE PFW (Platinum For Windows)', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Exact Software Macola ES', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'eXtensible Business Reporting Language XBRL', 43232402, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'FileMaker Pro software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Financial reporting software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Financial statement software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Fixed-assets depreciation software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'FLS eDP PAYROLLtax', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'FRx Software Microsoft FRx', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Fund accounting software', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'General ledger software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'H&R Block TaxCut Software', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Healthcare common procedure coding system HCPCS software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Heron CrossTie General Ledger', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Human resource management software HRMS', 43231505, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'IBM Cognos Impromptu', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'IBM Notes', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'IDMS Account Ability', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Income tax return preparation software', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Intrax ProcedureNet', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Intuit Lacerte', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Intuit ProSeries', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Intuit QuickBooks Premier', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Intuit TurboTax', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Invoice software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'KPB Associates TaxStream', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Lead Activity Analyzer', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Lead Business Analyzer', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'LexisNexis software', 43232309, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Medical condition coding software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Medical procedure coding software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'MEDITECH software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'MethodWare ProAudit Advisor', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Micronetics Xpert Write-up', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Microsoft Dynamics NAV', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Microsoft Dynamics SL', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Microsoft Dynamics software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Microsoft FRx', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Microsoft Outlook', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Microsoft SharePoint software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Microsoft Windows', 43233004, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Multiview Accounts Receivable', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'NetSuite ERP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'New Millennium Communications Genesis Accounting', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'NewPortWave Year End Solutions', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'OmniRIM software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Oracle Business Intelligence Enterprise Edition', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Oracle Hyperion software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Orrtax Software IntelliTax Business for Windows', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Orrtax Software IntelliTax Classic', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'OSI TrustWise', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Paisley AutoAudit', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Paisley Cardmap', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Paisley Focus Control Assurance', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Paisley IssueTrack', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Paisley RiskNavigator', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Payables Tests Sets for ACL software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Payroll software', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Pentana audit work system PAWS', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Practice management software PMS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Pro Systems Client Write-Up System for Windows', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Profit Developers Electronic File Interchange', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'PROPHIX Enterprise', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Roundtable Software Advantage Accounting System', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'RSM McGladrey Advanced Practice Solutions Paperless Audit', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'RSM McGladrey Auditor Assistant', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Sage 300 Construction and Real Estate', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Sage 50 Accounting', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Sage Abra HRMS', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Sage BusinessWorks', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Sage CPAAccounts Payable', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Sage CPAAccounts Receivable', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Sage CPAClient Checkbook', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Sage CPADocument Manager', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Sage ERP Accpac', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Sage MAS 200', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Sage MAS 500', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Sage Platinum for Windows PFW', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'SAP Business Objects software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'SAP BusinessObjects Data Integrator', 43232403, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'SAP Crystal Reports', 43232305, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Softrax Revenue Management', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Summit Software Summit Biofuels Accounting', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Sync Essentials Trade Accountant', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Tax compliance property tax management software', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Tax software', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Thomson GoSystem Tax', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Tumbleweed SecureTransport', 43232313, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'UA Business Software Professional Edition', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Universal Tax Systems TaxWise', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Yardi software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.01', 'Technology', 'Yardi Systems Yardi Enterprise', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Tools', 'Computer data input scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Tools', 'Laser facsimile machines', 44101508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Tools', 'Scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Tools', 'Tablet computers', 43211509, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Accounting compliance software', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Accounting fraud detection software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'ACL Audit Exchange', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'ACL Business Assurance Analytics', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Arbutus Analyzer', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Audit management software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Audit planning and control environment software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'AuditTracker software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'AuditWare CaseWare Examiner', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'AuditWare software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Automated auditors fraud detector software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Bi3 Audit Intelligence', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Bi3 Financial Statement Fraud Analysis', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'BizBench Benchmarking Software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'BNA Corporate Tax Audit Analyzer', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Brentmark Estate Planning Quickview', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Cammack Computations Inter-Est', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'CaseWare International IDEA', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'CaseWare International IDEA SmartAnalyzer', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'CaseWare Working Papers', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'CashFlow Guardian', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Cebos MQ1 Audit System', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Choice Technologies PowerBill +', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Client billing software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Corel WordPerfect Office Suite', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Corporate Responsibility System Technologies Limited Compliance Positioning System', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'D''Arcangelo Galileo', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Data entry software', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Data extraction software', 43232307, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Datavantage software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Digital analysis tests and statistics DATAS for Excel', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Digital analysis tests and statistics DATAS for SAS', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Financial Competence', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'FLS eDP PAYROLLtax', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Fund accounting software', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Google Docs', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Google Sheets', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Google Slides', 43232106, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Guidance Software EnCase Enterprise', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Healthcare common procedure coding system HCPCS software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'IAD Audit Leverage', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'IBM Cognos Impromptu', 43232314, 'Y');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'IBM Notes', 43233501, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'IBM Power Systems software', 43233701, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'InformationActive ActiveData for Excel', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Internal audit software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Intrax ProcedureNet', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Intuit QuickBooks', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Kirix ProffiPoint', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Lawson software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'LexisNexis software', 43232309, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Lumigent Entegra', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Medical condition coding software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Medical procedure coding software', 43232610, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'MethodWare ProAudit Advisor', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Microsoft Visio', 43232102, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Microsoft Works', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Oracle E-Business Suite Financials', 43231604, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Oracle Hyperion software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Oracle JD Edwards EnterpriseOne', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Oracle PeopleSoft Financials', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Oracle PeopleSoft software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Oracle Primavera Enterprise Project Portfolio Management software', 43231507, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Oracle software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'OSI TrustWise', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Paisley AutoAudit', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Paisley Cardmap', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Paisley Focus Control Assurance', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Paisley IssueTrack', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Paisley RiskNavigator', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Palisade @Risk', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Payables Tests Sets for ACL software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Pentana audit work system PAWS', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Pleier Audit Management System', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'PricewaterhouseCoopers TeamMate', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'ProfitCents software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'PSI software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Qlik Tech QlikView', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'R', 43232405, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Recovery audit software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'RSM McGladrey Advanced Practice Solutions Paperless Audit', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'RSM McGladrey Auditor Assistant', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Sage 50 Accounting', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Sage HandiSoft HandiLedger', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Sampson Data Pattern Index software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'SAP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'SAS software', 43232605, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Solutions Technology & Software HR Premier', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Spreadsheet software', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Star Software Fixed Asset Depreciation', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Star Software Materiality Calculator', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Tableau software', 43232314, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Tax compliance property tax management software', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Tax software', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'TechSmith Camtasia', 43232103, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Thomson Creative Solutions Engagement CS', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Thomson Creative Solutions Financial Analysis CS', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Thomson PPC e-Tools Suite', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Thomson Reuters risk management software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'TimeValue software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'TopCAATs', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'TrendTracker Compliance Solution', 43232606, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'Tropics software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'UNIX', 43233004, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'WizSoft WizRule', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'WizSoft WizWhy', 43232307, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2011.02', 'Technology', 'WorkForce Software EmpCenter Time and Attendance', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Tools', 'Appraisal, mapping, and comparison data reporting systems', 55111508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Tools', 'Electronic flood maps', 55111508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Tools', 'Electronic maps', 55111508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Tools', 'Flood Insights', 55111508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Tools', 'Handheld distance meters', 41111615, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Tools', 'Laser measuring devices', 41111615, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Tools', 'Mapping and geographic analysis systems', 55111508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Tools', 'Mapping or location-based analysis systems', 55111508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Tools', 'Real estate mapping and property description systems', 55111508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Tools', 'Ultrasonic distance measurers', 41111615, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'a la mode Pocket TOTAL', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'a la mode WinTOTAL', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Apex IV Assessor', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Apex IV Fee Appraiser', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Apex MobileSketch', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Ascend Property Assessment', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Bradford ClickFORMS', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Bruno Realty eNeighboorhoods', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Business Management Systems Municipal Geographic Management System MGMS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Compass Municipal Services CAMAlot', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Computer assisted mass appraisal CAMA software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Concierge Systems Report Concierge', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'CustomCAMA software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Emerald Data Deed-Chek', 43233506, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'eTrac software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'FBS Data Systems Flexmls', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'GCS Property Assessment and Tax Billing', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Geomechanical design analysis GDA software', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Govern Software GovMap', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Govern Software Land and Permits Management System', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Greenbrier Graphics Deed Plotter', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Hansen CAMA', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'HomeValue Plus software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Howard and Friends Computer CMA Plus', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'HP 49G+ Appraiser Fee Calculator', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Informatik MapDraw Deed Mapper', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Manatron MVP Tax', 43231603, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Manatron ProVal Plus', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Mass appraisal records system MARS software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'MicroSolve CAMA', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Midwest Appraisal Network software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Modellium PariTOP', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Multiple listing service software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Online title search and property report software', 43232309, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'ProMatch software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Real Edge Software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'RealData Comparative Lease Analysis', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Realty Tools Toolkit for Market Share', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'REI Wise Commercial', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'RPIS Silent CMA', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Softree Technical Systems Terrain Tools', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'ValueTech Report Builder', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Visual PAMSPro', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Wilson''s Computer Applications RealEasy Appraisals', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'Wilson''s Computer Applications RealEasy Photos Plus', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.01', 'Technology', 'WinGap software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Tools', 'Appraisal, mapping, and comparison data reporting systems', 55111508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Tools', 'Carbon monoxide detectors', 41113120, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Tools', 'Electronic flood maps', 55111508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Tools', 'Electronic maps', 55111508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Tools', 'Flood Insights', 55111508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Tools', 'Handheld distance meters', 41111615, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Tools', 'Laptop computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Tools', 'Laser measuring devices', 41111615, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Tools', 'Mapping and geographic analysis systems', 55111508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Tools', 'Mapping or location-based analysis systems', 55111508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Tools', 'Personal digital assistants PDA', 43211504, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Tools', 'Real estate mapping and property description systems', 55111508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Tools', 'Ultrasonic distance measurers', 41111615, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'a la mode Pocket TOTAL', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'a la mode WinTOTAL', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'ACI Appraiser''s Choice', 43232112, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Apex IV Assessor', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Apex IV Fee Appraiser', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Apex MobileSketch', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Ascend Property Assessment', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Bradford ClickFORMS', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Bruno Realty eNeighboorhoods', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Business Management Systems Municipal Geographic Management System MGMS', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Computer assisted mass appraisal CAMA software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Concierge Systems Report Concierge', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Construction Management Software ProEst', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Cost estimation software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'CPR International GeneralCOST Estimator', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'CPR Visual Estimator', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'CustomCAMA software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Emerald Data Deed-Chek', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'eTrac software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'FBS Data Systems Flexmls', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'GCS Property Assessment and Tax Billing', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Geomechanical design analysis GDA software', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Govern Software GovMap', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Govern Software Land and Permits Management System', 43232108, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Greenbrier Graphics Deed Plotter', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Hansen CAMA', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'HomeValue Plus software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Howard and Friends Computer CMA Plus', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'HP 49G+ Appraiser Fee Calculator', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Informatik MapDraw Deed Mapper', 43233506, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Manatron ProVal Plus', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Manufacturing Technology Costimater', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Mass appraisal records system MARS software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'MicroSolve CAMA', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Midwest Appraisal Network software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Modellium PariTOP', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Multiple listing service software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'ProMatch software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Real Edge Software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Real Estate Center Caparate Calculator', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'RealData Comparative Lease Analysis', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Realty Tools Toolkit for Market Share', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'RPIS Silent CMA', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Softree Technical Systems Terrain Tools', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'ValueTech Report Builder', 43232104, 'N');
GO
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Visual PAMSPro', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Web browser software', 43232705, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Wilson''s Computer Applications RealEasy Appraisals', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'Wilson''s Computer Applications RealEasy Photos Plus', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'WinEstimator WinEst', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2021.02', 'Technology', 'WinGap software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Tools', 'Laser printers', 43212105, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Tools', 'Notebook computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Accounting software', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Adaptive Planning', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Budget monitoring systems', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Budgeting, forecasting, and planning software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Business Objects Data Integrator', 43232402, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Business performance management BPM software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Deltek Costpoint', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Email software', 43233501, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Enterprise resource planning ERP software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Everest Software Advanced', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Extensity MPC', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Financial reporting software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'FRx Software Microsoft Forecaster', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Fund accounting software', 43231601, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Graphics software', 43232102, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Human resources management system software', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Hyperion Enterprise', 43231601, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'IBM Cognos Business Intelligence', 43232314, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'IBM Cognos Planning', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Lilly Software Associates VISUAL Enterprise', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Microsoft Access', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Microsoft Dynamics GP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Microsoft Excel', 43232110, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Microsoft FRx', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Microsoft Office software', 43231513, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Microsoft PowerPoint', 43232106, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Microsoft Sharepoint', 43231507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Microsoft Visual Basic', 43232402, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Microsoft Visual Basic.NET', 43232405, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Microsoft Word', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'NetSuite NetERP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'On line analytical processing OLAP software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Open Systems TRAVERSE software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Oracle Corporate Performance Management CPM software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Oracle PeopleSoft Enterprise software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'OutlookSoft', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Payroll software', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Presentation software', 43232106, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Relational database software', 43232306, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Revelwood Business Performance Management software', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Sage Active Planner', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Sage ERP Accpac', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Sage MAS 200 ERP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Sage MAS 90 ERP', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'SAP Business One', 43231602, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'SAP BusinessObjects Crystal Reports', 43232305, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'SAP Crystal Xcelsius', 43232106, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Satori Group proCube software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Spreadsheet software', 43232110, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Statistical software', 43232605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Structured query language SQL', 43232306, 'Y');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Time and attendance software', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Ultimate Software UltiPro Workplace', 43231505, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Valiant Vantage', 43231605, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2031.00', 'Technology', 'Word processing software', 43232104, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Tools', '10-key calculators', 44101809, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Tools', 'Desktop computers', 43211507, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Tools', 'Notebook computers', 43211503, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Tools', 'Personal computers', 43211508, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Tools', 'Scanners', 43211711, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Technology', 'CGI-AMS BureauLink Enterprise', 43232309, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Technology', 'CGI-AMS CACS Enterprise', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Technology', 'CGI-AMS Strata', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Technology', 'Credit adjudication and lending management system CALMS software', 43232202, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Technology', 'Credit and risk analysis software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Technology', 'Credit fraud detection software', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Technology', 'Dun and Bradstreet Global DecisionMaker', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, t2_example, commodity_code, hot_technology) VALUES ('13-2041.00', 'Technology', 'eCredit Enterprise', 43231604, 'N');
INSERT INTO tools_and_technology (onetsoc_code, t2_type, 