CREATE TABLE work_activities (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(5,2),
  lower_ci_bound DECIMAL(5,2),
  upper_ci_bound DECIMAL(5,2),
  recommend_suppress CHARACTER(1),
  not_relevant CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id));
GO

INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.a.1', 'IM', 4.72, 35, 0.13, 4.46, 4.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.a.1', 'LV', 5.35, 35, 0.23, 4.89, 5.81, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.a.2', 'IM', 3.68, 35, 0.17, 3.33, 4.03, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.a.2', 'LV', 4.76, 34, 0.27, 4.22, 5.30, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.b.1', 'IM', 4.20, 35, 0.15, 3.91, 4.50, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.b.1', 'LV', 4.91, 34, 0.22, 4.46, 5.37, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.b.2', 'IM', 2.38, 35, 0.29, 1.80, 2.96, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.b.2', 'LV', 2.11, 35, 0.44, 1.23, 3.00, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.b.3', 'IM', 3.59, 35, 0.34, 2.91, 4.27, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.1.b.3', 'LV', 3.72, 34, 0.48, 2.73, 4.71, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.a.1', 'IM', 4.35, 35, 0.18, 3.98, 4.73, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.a.1', 'LV', 5.39, 35, 0.22, 4.94, 5.84, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.a.2', 'IM', 4.03, 35, 0.24, 3.55, 4.52, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.a.2', 'LV', 5.33, 35, 0.31, 4.70, 5.96, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.a.3', 'IM', 4.22, 35, 0.17, 3.88, 4.55, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.a.3', 'LV', 5.39, 35, 0.24, 4.89, 5.89, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.a.4', 'IM', 4.36, 35, 0.15, 4.06, 4.66, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.a.4', 'LV', 5.38, 35, 0.19, 5.00, 5.77, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.1', 'IM', 4.74, 35, 0.08, 4.58, 4.90, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.1', 'LV', 6.18, 35, 0.19, 5.79, 6.57, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.2', 'IM', 3.86, 35, 0.19, 3.48, 4.24, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.2', 'LV', 4.88, 35, 0.22, 4.44, 5.33, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.3', 'IM', 4.06, 35, 0.16, 3.74, 4.38, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.3', 'LV', 4.92, 35, 0.23, 4.45, 5.40, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.4', 'IM', 4.50, 35, 0.12, 4.26, 4.75, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.4', 'LV', 5.68, 35, 0.24, 5.20, 6.16, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.5', 'IM', 3.36, 35, 0.21, 2.94, 3.79, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.5', 'LV', 4.24, 34, 0.35, 3.54, 4.94, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.6', 'IM', 4.18, 35, 0.13, 3.92, 4.45, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.2.b.6', 'LV', 5.79, 35, 0.22, 5.34, 6.23, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.a.1', 'IM', 1.39, 35, 0.14, 1.11, 1.67, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.a.1', 'LV', 0.80, 35, 0.29, 0.21, 1.39, 'N', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.a.2', 'IM', 1.34, 35, 0.13, 1.08, 1.60, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.a.2', 'LV', 0.76, 35, 0.27, 0.20, 1.32, 'N', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.a.3', 'IM', 1.40, 35, 0.14, 1.11, 1.68, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.a.3', 'LV', 0.96, 35, 0.33, 0.29, 1.62, 'N', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.a.4', 'IM', 1.34, 35, 0.13, 1.07, 1.60, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.a.4', 'LV', 0.68, 35, 0.25, 0.17, 1.20, 'N', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.1', 'IM', 4.20, 35, 0.18, 3.84, 4.57, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.1', 'LV', 3.82, 35, 0.25, 3.30, 4.33, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.2', 'IM', 1.62, 35, 0.20, 1.22, 2.03, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.2', 'LV', 1.21, 35, 0.38, 0.43, 1.99, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.4', 'IM', 1.21, 35, 0.11, 1.00, 1.42, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.4', 'LV', 0.48, 35, 0.24, 0.00, 0.97, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.5', 'IM', 1.27, 35, 0.14, 1.00, 1.55, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.5', 'LV', 0.49, 35, 0.23, 0.02, 0.97, 'N', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.6', 'IM', 2.84, 35, 0.31, 2.20, 3.48, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.3.b.6', 'LV', 2.77, 35, 0.50, 1.76, 3.78, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.1', 'IM', 4.07, 35, 0.16, 3.74, 4.40, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.1', 'LV', 4.52, 35, 0.25, 4.00, 5.04, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.2', 'IM', 4.73, 35, 0.08, 4.56, 4.90, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.2', 'LV', 5.96, 35, 0.20, 5.54, 6.37, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.3', 'IM', 4.61, 35, 0.10, 4.39, 4.82, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.3', 'LV', 5.87, 35, 0.29, 5.28, 6.45, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.4', 'IM', 4.50, 35, 0.11, 4.27, 4.73, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.4', 'LV', 5.99, 35, 0.26, 5.46, 6.52, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.5', 'IM', 2.18, 33, 0.25, 1.68, 2.68, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.5', 'LV', 2.40, 33, 0.45, 1.48, 3.31, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.6', 'IM', 3.68, 33, 0.33, 3.01, 4.35, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.6', 'LV', 4.65, 33, 0.58, 3.48, 5.83, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.7', 'IM', 4.26, 33, 0.16, 3.94, 4.58, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.7', 'LV', 6.06, 33, 0.22, 5.61, 6.51, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.8', 'IM', 2.94, 33, 0.36, 2.19, 3.68, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.a.8', 'LV', 3.35, 33, 0.61, 2.10, 4.60, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.1', 'IM', 3.93, 35, 0.23, 3.47, 4.40, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.1', 'LV', 5.12, 35, 0.35, 4.41, 5.83, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.2', 'IM', 4.55, 35, 0.12, 4.30, 4.80, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.2', 'LV', 5.18, 35, 0.31, 4.55, 5.81, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.3', 'IM', 3.00, 35, 0.26, 2.47, 3.52, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.3', 'LV', 3.34, 35, 0.36, 2.60, 4.07, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.4', 'IM', 4.57, 35, 0.11, 4.35, 4.79, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.4', 'LV', 5.89, 35, 0.29, 5.31, 6.47, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.5', 'IM', 3.92, 34, 0.19, 3.54, 4.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.5', 'LV', 4.80, 34, 0.31, 4.16, 5.44, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.6', 'IM', 3.65, 34, 0.17, 3.30, 4.01, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.b.6', 'LV', 5.42, 33, 0.32, 4.76, 6.07, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.c.1', 'IM', 3.14, 34, 0.34, 2.44, 3.84, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.c.1', 'LV', 4.13, 34, 0.56, 3.00, 5.26, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.c.2', 'IM', 3.70, 34, 0.30, 3.08, 4.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.c.2', 'LV', 4.63, 34, 0.40, 3.82, 5.45, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.c.3', 'IM', 4.43, 35, 0.13, 4.17, 4.70, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '4.A.4.c.3', 'LV', 6.01, 35, 0.18, 5.65, 6.38, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.a.1', 'IM', 4.48, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.a.1', 'LV', 5.40, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.a.2', 'IM', 3.27, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.a.2', 'LV', 3.92, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.b.1', 'IM', 3.62, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.b.1', 'LV', 4.28, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.b.2', 'IM', 2.36, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.b.2', 'LV', 2.60, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.b.3', 'IM', 3.31, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.1.b.3', 'LV', 3.76, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.a.1', 'IM', 3.43, 23, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.a.1', 'LV', 4.27, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.a.2', 'IM', 3.64, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.a.2', 'LV', 4.65, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.a.3', 'IM', 4.12, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.a.3', 'LV', 4.65, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.a.4', 'IM', 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.a.4', 'LV', 4.54, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.1', 'IM', 4.48, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.1', 'LV', 5.40, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.2', 'IM', 4.50, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.2', 'LV', 5.35, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.3', 'IM', 4.35, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.3', 'LV', 5.54, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.4', 'IM', 4.31, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.4', 'LV', 5.12, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.5', 'IM', 3.65, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.5', 'LV', 4.96, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.6', 'IM', 4.16, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.2.b.6', 'LV', 5.56, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.a.1', 'IM', 1.77, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.a.1', 'LV', 1.77, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.a.2', 'IM', 1.62, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.a.2', 'LV', 1.58, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.a.3', 'IM', 1.36, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.a.3', 'LV', 0.80, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.a.4', 'IM', 1.50, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.a.4', 'LV', 0.85, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.1', 'IM', 4.32, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.1', 'LV', 3.54, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.2', 'IM', 2.56, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.2', 'LV', 3.32, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.4', 'IM', 1.12, 24, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.4', 'LV', 0.21, 24, NULL, NULL, NULL, NULL, 'Y', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.5', 'IM', 1.12, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.5', 'LV', 0.20, 25, NULL, NULL, NULL, NULL, 'Y', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.6', 'IM', 3.44, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.3.b.6', 'LV', 3.83, 24, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.1', 'IM', 4.08, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.1', 'LV', 4.65, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.2', 'IM', 4.58, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.2', 'LV', 5.64, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.3', 'IM', 4.46, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.3', 'LV', 6.04, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.4', 'IM', 4.28, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.4', 'LV', 5.65, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.5', 'IM', 2.23, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.5', 'LV', 2.15, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.6', 'IM', 3.85, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.6', 'LV', 5.24, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.7', 'IM', 3.54, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.7', 'LV', 5.04, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.8', 'IM', 3.16, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.a.8', 'LV', 3.88, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.1', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.1', 'LV', 5.19, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.2', 'IM', 4.12, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.2', 'LV', 4.65, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.3', 'IM', 4.12, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.3', 'LV', 4.68, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.4', 'IM', 3.88, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.4', 'LV', 4.68, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.5', 'IM', 3.64, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.5', 'LV', 4.72, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.6', 'IM', 3.96, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.b.6', 'LV', 5.68, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.c.1', 'IM', 3.00, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.c.1', 'LV', 3.81, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.c.2', 'IM', 2.62, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.c.2', 'LV', 3.77, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.c.3', 'IM', 3.35, 26, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '4.A.4.c.3', 'LV', 4.31, 26, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.a.1', 'IM', 4.26, 50, 0.13, 3.99, 4.52, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.a.1', 'LV', 4.14, 50, 0.30, 3.54, 4.74, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.a.2', 'IM', 4.07, 51, 0.15, 3.78, 4.36, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.a.2', 'LV', 4.31, 50, 0.25, 3.80, 4.82, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.b.1', 'IM', 4.14, 51, 0.17, 3.80, 4.48, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.b.1', 'LV', 4.17, 50, 0.30, 3.56, 4.77, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.b.2', 'IM', 3.43, 51, 0.30, 2.81, 4.04, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.b.2', 'LV', 3.14, 51, 0.42, 2.30, 3.98, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.b.3', 'IM', 3.58, 51, 0.27, 3.03, 4.13, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.1.b.3', 'LV', 3.51, 50, 0.44, 2.63, 4.39, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.a.1', 'IM', 4.06, 49, 0.16, 3.73, 4.39, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.a.1', 'LV', 4.43, 50, 0.27, 3.88, 4.98, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.a.2', 'IM', 3.96, 51, 0.19, 3.58, 4.34, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.a.2', 'LV', 4.14, 51, 0.28, 3.57, 4.71, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.a.3', 'IM', 4.01, 51, 0.19, 3.62, 4.40, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.a.3', 'LV', 4.06, 51, 0.35, 3.35, 4.77, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.a.4', 'IM', 3.71, 51, 0.20, 3.31, 4.10, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.a.4', 'LV', 3.64, 51, 0.31, 3.02, 4.26, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.1', 'IM', 4.42, 51, 0.10, 4.22, 4.63, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.1', 'LV', 4.48, 51, 0.35, 3.78, 5.18, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.2', 'IM', 3.32, 50, 0.26, 2.80, 3.85, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.2', 'LV', 3.78, 50, 0.44, 2.89, 4.66, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.3', 'IM', 3.63, 51, 0.13, 3.37, 3.90, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.3', 'LV', 4.53, 51, 0.31, 3.91, 5.14, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.4', 'IM', 3.72, 51, 0.18, 3.36, 4.08, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.4', 'LV', 3.77, 51, 0.38, 3.01, 4.53, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.5', 'IM', 3.97, 51, 0.12, 3.72, 4.21, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.5', 'LV', 4.26, 51, 0.31, 3.64, 4.88, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.6', 'IM', 4.03, 51, 0.14, 3.74, 4.32, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.2.b.6', 'LV', 5.11, 51, 0.25, 4.60, 5.62, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.a.1', 'IM', 2.71, 51, 0.27, 2.16, 3.25, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.a.1', 'LV', 2.75, 51, 0.46, 1.83, 3.67, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.a.2', 'IM', 2.49, 51, 0.26, 1.98, 3.01, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.a.2', 'LV', 3.36, 51, 0.54, 2.29, 4.44, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.a.3', 'IM', 2.69, 51, 0.27, 2.15, 3.24, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.a.3', 'LV', 2.48, 51, 0.41, 1.66, 3.30, 'N', 'N', '2015-07-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.a.4', 'IM', 2.40, 51, 0.28, 1.84, 2.96, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.a.4', 'LV', 2.06, 51, 0.44, 1.18, 2.94, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.1', 'IM', 4.15, 51, 0.17, 3.81, 4.49, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.1', 'LV', 3.65, 51, 0.26, 3.12, 4.17, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.2', 'IM', 2.18, 51, 0.26, 1.66, 2.71, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.2', 'LV', 1.92, 50, 0.46, 0.99, 2.84, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.4', 'IM', 2.24, 51, 0.26, 1.72, 2.76, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.4', 'LV', 2.10, 51, 0.45, 1.19, 3.01, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.5', 'IM', 1.94, 51, 0.23, 1.47, 2.41, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.5', 'LV', 1.71, 50, 0.44, 0.83, 2.60, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.6', 'IM', 3.64, 51, 0.19, 3.26, 4.02, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.3.b.6', 'LV', 3.28, 50, 0.32, 2.64, 3.92, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.1', 'IM', 3.52, 49, 0.20, 3.11, 3.93, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.1', 'LV', 3.07, 47, 0.33, 2.39, 3.74, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.2', 'IM', 4.33, 49, 0.20, 3.93, 4.72, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.2', 'LV', 4.46, 49, 0.27, 3.92, 4.99, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.3', 'IM', 3.92, 49, 0.21, 3.49, 4.35, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.3', 'LV', 4.07, 49, 0.28, 3.50, 4.64, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.4', 'IM', 3.94, 49, 0.21, 3.53, 4.36, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.4', 'LV', 4.90, 49, 0.26, 4.39, 5.42, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.5', 'IM', 2.94, 51, 0.27, 2.39, 3.49, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.5', 'LV', 2.95, 51, 0.32, 2.30, 3.59, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.6', 'IM', 3.60, 50, 0.29, 3.02, 4.18, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.6', 'LV', 3.24, 50, 0.45, 2.33, 4.14, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.7', 'IM', 3.91, 51, 0.18, 3.54, 4.28, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.7', 'LV', 4.40, 51, 0.33, 3.75, 5.06, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.8', 'IM', 3.85, 51, 0.25, 3.34, 4.36, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.a.8', 'LV', 4.16, 48, 0.37, 3.42, 4.90, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.1', 'IM', 4.24, 50, 0.18, 3.88, 4.59, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.1', 'LV', 4.49, 50, 0.28, 3.92, 5.06, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.2', 'IM', 3.98, 51, 0.20, 3.59, 4.38, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.2', 'LV', 3.47, 51, 0.37, 2.73, 4.20, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.3', 'IM', 3.94, 51, 0.22, 3.50, 4.37, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.3', 'LV', 3.60, 51, 0.29, 3.02, 4.18, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.4', 'IM', 4.15, 51, 0.19, 3.77, 4.52, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.4', 'LV', 4.79, 51, 0.29, 4.21, 5.37, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.5', 'IM', 3.93, 50, 0.25, 3.42, 4.43, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.5', 'LV', 4.33, 51, 0.39, 3.55, 5.10, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.6', 'IM', 3.17, 51, 0.21, 2.75, 3.59, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.b.6', 'LV', 4.80, 50, 0.45, 3.90, 5.70, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.c.1', 'IM', 3.49, 51, 0.23, 3.02, 3.96, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.c.1', 'LV', 3.25, 51, 0.31, 2.63, 3.88, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.c.2', 'IM', 3.46, 51, 0.24, 2.97, 3.94, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.c.2', 'LV', 3.97, 50, 0.37, 3.22, 4.72, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.c.3', 'IM', 3.81, 51, 0.18, 3.45, 4.16, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '4.A.4.c.3', 'LV', 4.57, 50, 0.30, 3.98, 5.17, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.a.1', 'IM', 4.38, 19, 0.14, 4.08, 4.68, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.a.1', 'LV', 3.84, 18, 0.31, 3.17, 4.50, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.a.2', 'IM', 2.51, 19, 0.48, 1.51, 3.51, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.a.2', 'LV', 2.56, 18, 0.89, 0.68, 4.44, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.b.1', 'IM', 3.36, 19, 0.42, 2.48, 4.24, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.b.1', 'LV', 3.44, 16, 0.90, 1.52, 5.35, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.b.2', 'IM', 2.13, 18, 0.42, 1.24, 3.02, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.b.2', 'LV', 1.42, 17, 0.62, 0.11, 2.73, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.b.3', 'IM', 3.07, 18, 0.15, 2.74, 3.39, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.1.b.3', 'LV', 3.78, 16, 0.51, 2.69, 4.87, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.a.1', 'IM', 2.87, 19, 0.36, 2.11, 3.63, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.a.1', 'LV', 3.22, 18, 0.48, 2.20, 4.24, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.a.2', 'IM', 3.55, 19, 0.47, 2.57, 4.52, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.a.2', 'LV', 4.84, 17, 0.80, 3.14, 6.54, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.a.3', 'IM', 2.50, 19, 0.51, 1.43, 3.58, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.a.3', 'LV', 1.89, 18, 0.72, 0.38, 3.40, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.a.4', 'IM', 2.81, 19, 0.54, 1.67, 3.95, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.a.4', 'LV', 2.42, 18, 0.83, 0.67, 4.17, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.1', 'IM', 4.43, 19, 0.23, 3.94, 4.92, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.1', 'LV', 4.21, 18, 0.47, 3.22, 5.21, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.2', 'IM', 4.54, 19, 0.17, 4.18, 4.89, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.2', 'LV', 5.03, 18, 0.48, 4.02, 6.03, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.3', 'IM', 3.83, 19, 0.17, 3.48, 4.18, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.3', 'LV', 4.28, 18, 0.46, 3.30, 5.26, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.4', 'IM', 3.68, 19, 0.19, 3.29, 4.07, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.4', 'LV', 3.95, 18, 0.74, 2.40, 5.50, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.5', 'IM', 3.72, 19, 0.18, 3.34, 4.09, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.5', 'LV', 4.43, 18, 0.44, 3.50, 5.36, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.6', 'IM', 3.88, 19, 0.26, 3.34, 4.43, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.2.b.6', 'LV', 5.02, 18, 0.38, 4.22, 5.81, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.a.1', 'IM', 1.93, 18, 0.36, 1.16, 2.70, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.a.1', 'LV', 1.44, 18, 0.57, 0.24, 2.63, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.a.2', 'IM', 1.86, 19, 0.34, 1.14, 2.57, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.a.2', 'LV', 1.69, 18, 0.68, 0.26, 3.12, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.a.3', 'IM', 2.22, 19, 0.25, 1.69, 2.75, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.a.3', 'LV', 2.17, 18, 0.48, 1.16, 3.18, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.a.4', 'IM', 2.16, 19, 0.30, 1.54, 2.79, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.a.4', 'LV', 1.49, 19, 0.36, 0.74, 2.24, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.1', 'IM', 4.08, 19, 0.37, 3.31, 4.85, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.1', 'LV', 4.13, 18, 1.00, 2.02, 6.24, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.2', 'IM', 1.70, 19, 0.21, 1.25, 2.15, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.2', 'LV', 1.22, 19, 0.41, 0.37, 2.08, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.4', 'IM', 1.38, 19, 0.28, 1.00, 1.97, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.4', 'LV', 0.70, 19, 0.46, 0.00, 1.66, 'Y', 'Y', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.5', 'IM', 1.58, 18, 0.30, 1.00, 2.21, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.5', 'LV', 0.78, 18, 0.44, 0.00, 1.71, 'Y', 'Y', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.6', 'IM', 3.30, 19, 0.24, 2.80, 3.81, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.3.b.6', 'LV', 2.84, 18, 0.36, 2.07, 3.60, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.1', 'IM', 3.39, 19, 0.33, 2.69, 4.08, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.1', 'LV', 3.22, 18, 0.69, 1.76, 4.69, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.2', 'IM', 4.28, 19, 0.13, 4.02, 4.54, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.2', 'LV', 4.84, 18, 0.22, 4.37, 5.31, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.3', 'IM', 4.56, 19, 0.17, 4.20, 4.91, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.3', 'LV', 5.58, 19, 0.33, 4.88, 6.28, 'N', 'N', '2010-06-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.4', 'IM', 4.04, 19, 0.16, 3.69, 4.39, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.4', 'LV', 5.63, 18, 0.45, 4.68, 6.58, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.5', 'IM', 2.10, 18, 0.39, 1.28, 2.92, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.5', 'LV', 1.91, 18, 0.68, 0.47, 3.35, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.6', 'IM', 3.27, 19, 0.41, 2.42, 4.13, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.6', 'LV', 3.29, 18, 0.79, 1.63, 4.96, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.7', 'IM', 2.61, 19, 0.47, 1.62, 3.60, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.7', 'LV', 2.70, 18, 0.84, 0.92, 4.48, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.8', 'IM', 3.93, 19, 0.26, 3.38, 4.48, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.a.8', 'LV', 4.44, 18, 0.37, 3.65, 5.22, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.1', 'IM', 3.06, 19, 0.39, 2.23, 3.89, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.1', 'LV', 3.32, 18, 0.62, 2.02, 4.62, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.2', 'IM', 3.27, 19, 0.25, 2.75, 3.79, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.2', 'LV', 2.39, 19, 0.54, 1.27, 3.52, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.3', 'IM', 2.67, 19, 0.32, 2.00, 3.33, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.3', 'LV', 2.88, 19, 0.55, 1.74, 4.03, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.4', 'IM', 2.72, 18, 0.39, 1.90, 3.54, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.4', 'LV', 2.53, 17, 0.57, 1.33, 3.73, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.5', 'IM', 2.68, 19, 0.36, 1.92, 3.44, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.5', 'LV', 2.97, 19, 0.57, 1.77, 4.18, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.6', 'IM', 2.44, 19, 0.49, 1.42, 3.46, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.b.6', 'LV', 2.59, 19, 0.93, 0.64, 4.54, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.c.1', 'IM', 2.82, 19, 0.32, 2.14, 3.50, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.c.1', 'LV', 2.68, 18, 0.39, 1.86, 3.50, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.c.2', 'IM', 2.01, 19, 0.36, 1.26, 2.76, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.c.2', 'LV', 1.81, 19, 0.66, 0.43, 3.19, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.c.3', 'IM', 2.66, 19, 0.31, 2.01, 3.31, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '4.A.4.c.3', 'LV', 2.91, 18, 0.49, 1.88, 3.95, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.a.1', 'IM', 4.33, 40, 0.13, 4.07, 4.59, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.a.1', 'LV', 4.98, 40, 0.14, 4.69, 5.27, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.a.2', 'IM', 3.27, 40, 0.22, 2.83, 3.71, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.a.2', 'LV', 3.62, 40, 0.19, 3.24, 4.01, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.b.1', 'IM', 4.24, 40, 0.18, 3.88, 4.60, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.b.1', 'LV', 4.56, 40, 0.14, 4.28, 4.85, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.b.2', 'IM', 1.45, 40, 0.13, 1.18, 1.72, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.b.2', 'LV', 0.72, 40, 0.21, 0.29, 1.16, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.b.3', 'IM', 3.59, 40, 0.33, 2.94, 4.25, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.1.b.3', 'LV', 3.04, 39, 0.39, 2.25, 3.83, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.a.1', 'IM', 3.37, 40, 0.28, 2.79, 3.94, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.a.1', 'LV', 3.53, 40, 0.45, 2.62, 4.44, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.a.2', 'IM', 3.36, 40, 0.28, 2.79, 3.94, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.a.2', 'LV', 3.92, 40, 0.47, 2.97, 4.86, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.a.3', 'IM', 2.61, 39, 0.26, 2.08, 3.14, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.a.3', 'LV', 2.57, 39, 0.41, 1.73, 3.41, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.a.4', 'IM', 3.75, 40, 0.14, 3.47, 4.02, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.a.4', 'LV', 4.04, 40, 0.20, 3.65, 4.44, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.1', 'IM', 4.34, 40, 0.24, 3.86, 4.82, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.1', 'LV', 4.67, 40, 0.28, 4.11, 5.23, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.2', 'IM', 4.28, 40, 0.17, 3.93, 4.63, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.2', 'LV', 4.71, 40, 0.18, 4.35, 5.06, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.3', 'IM', 3.83, 40, 0.19, 3.45, 4.21, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.3', 'LV', 4.52, 40, 0.40, 3.71, 5.33, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.4', 'IM', 4.07, 40, 0.25, 3.56, 4.58, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.4', 'LV', 4.17, 40, 0.27, 3.63, 4.72, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.5', 'IM', 3.40, 39, 0.40, 2.58, 4.21, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.5', 'LV', 3.96, 40, 0.59, 2.77, 5.16, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.6', 'IM', 4.35, 40, 0.11, 4.13, 4.56, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.2.b.6', 'LV', 5.86, 40, 0.09, 5.68, 6.04, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.a.1', 'IM', 1.71, 40, 0.28, 1.13, 2.28, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.a.1', 'LV', 1.06, 40, 0.38, 0.28, 1.84, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.a.2', 'IM', 1.37, 40, 0.14, 1.08, 1.65, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.a.2', 'LV', 0.81, 40, 0.30, 0.21, 1.41, 'N', 'Y', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.a.3', 'IM', 1.20, 40, 0.07, 1.06, 1.34, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.a.3', 'LV', 0.37, 40, 0.13, 0.10, 0.63, 'N', 'Y', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.a.4', 'IM', 1.78, 40, 0.35, 1.08, 2.48, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.a.4', 'LV', 0.94, 40, 0.27, 0.40, 1.49, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.1', 'IM', 4.40, 39, 0.14, 4.12, 4.68, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.1', 'LV', 3.12, 40, 0.25, 2.61, 3.63, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.2', 'IM', 1.29, 39, 0.11, 1.07, 1.51, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.2', 'LV', 0.63, 39, 0.30, 0.03, 1.24, 'N', 'Y', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.4', 'IM', 1.14, 39, 0.09, 1.00, 1.33, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.4', 'LV', 0.28, 39, 0.19, 0.00, 0.67, 'Y', 'Y', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.5', 'IM', 1.15, 39, 0.07, 1.01, 1.30, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.5', 'LV', 0.31, 39, 0.16, 0.00, 0.63, 'Y', 'Y', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.6', 'IM', 3.00, 39, 0.30, 2.40, 3.61, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.3.b.6', 'LV', 2.53, 39, 0.24, 2.04, 3.02, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.1', 'IM', 3.39, 40, 0.28, 2.83, 3.95, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.1', 'LV', 2.98, 40, 0.21, 2.55, 3.40, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.2', 'IM', 4.75, 40, 0.08, 4.58, 4.92, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.2', 'LV', 5.28, 40, 0.25, 4.78, 5.79, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.3', 'IM', 4.20, 40, 0.19, 3.82, 4.58, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.3', 'LV', 5.60, 40, 0.22, 5.16, 6.04, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.4', 'IM', 4.68, 40, 0.10, 4.48, 4.88, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.4', 'LV', 5.88, 40, 0.15, 5.58, 6.17, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.5', 'IM', 2.44, 40, 0.33, 1.77, 3.11, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.5', 'LV', 2.21, 40, 0.44, 1.32, 3.09, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.6', 'IM', 4.27, 40, 0.27, 3.72, 4.83, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.6', 'LV', 5.43, 40, 0.49, 4.43, 6.42, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.7', 'IM', 3.68, 39, 0.15, 3.38, 3.98, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.7', 'LV', 4.94, 40, 0.19, 4.56, 5.32, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.8', 'IM', 2.81, 40, 0.38, 2.03, 3.58, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.a.8', 'LV', 3.07, 40, 0.66, 1.73, 4.40, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.1', 'IM', 3.97, 40, 0.15, 3.67, 4.26, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.1', 'LV', 4.83, 40, 0.23, 4.37, 5.30, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.2', 'IM', 4.08, 40, 0.15, 3.79, 4.38, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.2', 'LV', 4.26, 40, 0.23, 3.79, 4.73, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.3', 'IM', 3.14, 38, 0.18, 2.77, 3.51, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.3', 'LV', 3.34, 39, 0.24, 2.86, 3.83, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.4', 'IM', 3.84, 40, 0.17, 3.49, 4.19, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.4', 'LV', 4.23, 40, 0.26, 3.71, 4.74, 'N', 'N', '2015-07-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.5', 'IM', 3.36, 40, 0.18, 2.99, 3.74, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.5', 'LV', 3.74, 40, 0.30, 3.13, 4.34, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.6', 'IM', 3.18, 40, 0.14, 2.90, 3.47, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.b.6', 'LV', 4.34, 40, 0.25, 3.83, 4.85, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.c.1', 'IM', 2.59, 40, 0.15, 2.28, 2.89, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.c.1', 'LV', 2.95, 40, 0.25, 2.44, 3.47, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.c.2', 'IM', 2.25, 40, 0.30, 1.66, 2.85, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.c.2', 'LV', 2.18, 40, 0.52, 1.13, 3.23, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.c.3', 'IM', 3.18, 40, 0.15, 2.88, 3.49, 'N', NULL, '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '4.A.4.c.3', 'LV', 3.85, 40, 0.31, 3.22, 4.48, 'N', 'N', '2015-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.a.1', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.a.1', 'LV', 4.67, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.a.2', 'IM', 2.50, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.a.2', 'LV', 2.80, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.b.1', 'IM', 3.20, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.b.1', 'LV', 3.42, 19, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.b.2', 'IM', 1.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.b.2', 'LV', 0.71, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.b.3', 'IM', 2.70, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.1.b.3', 'LV', 2.55, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.a.1', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.a.1', 'LV', 4.50, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.a.2', 'IM', 3.45, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.a.2', 'LV', 4.35, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.a.3', 'IM', 2.85, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.a.3', 'LV', 2.90, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.a.4', 'IM', 3.45, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.a.4', 'LV', 4.00, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.1', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.1', 'LV', 4.80, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.2', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.2', 'LV', 4.25, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.3', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.3', 'LV', 4.50, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.4', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.4', 'LV', 4.10, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.5', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.5', 'LV', 4.45, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.6', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.2.b.6', 'LV', 5.15, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.a.1', 'IM', 1.85, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.a.1', 'LV', 1.65, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.a.2', 'IM', 1.65, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.a.2', 'LV', 1.50, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.a.3', 'IM', 1.47, 19, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.a.3', 'LV', 1.11, 19, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.a.4', 'IM', 2.60, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.a.4', 'LV', 1.75, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.1', 'IM', 3.80, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.1', 'LV', 3.60, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.2', 'IM', 1.60, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.2', 'LV', 1.05, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.4', 'IM', 1.40, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.4', 'LV', 0.85, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.5', 'IM', 1.50, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.5', 'LV', 0.90, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.6', 'IM', 3.05, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.3.b.6', 'LV', 3.20, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.1', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.1', 'LV', 3.30, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.2', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.2', 'LV', 5.25, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.3', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.3', 'LV', 5.25, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.4', 'IM', 4.75, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.4', 'LV', 5.75, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.5', 'IM', 2.25, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.5', 'LV', 2.30, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.6', 'IM', 4.85, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.6', 'LV', 6.00, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.7', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.7', 'LV', 5.37, 19, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.8', 'IM', 3.00, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.a.8', 'LV', 3.75, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.1', 'IM', 3.95, 19, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.1', 'LV', 4.84, 19, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.2', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.2', 'LV', 4.50, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.3', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.3', 'LV', 4.00, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.4', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.4', 'LV', 4.85, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.5', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.5', 'LV', 5.30, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.6', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.b.6', 'LV', 4.70, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.c.1', 'IM', 3.25, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.c.1', 'LV', 3.80, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.c.2', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.c.2', 'LV', 4.70, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.c.3', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '4.A.4.c.3', 'LV', 4.20, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.1.a.1', 'IM', 4.40, 37, 0.13, 4.14, 4.67, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.1.a.1', 'LV', 5.03, 37, 0.34, 4.35, 5.72, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.1.a.2', 'IM', 3.74, 37, 0.38, 2.97, 4.51, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.1.a.2', 'LV', 4.14, 37, 0.42, 3.29, 4.99, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.1.b.1', 'IM', 4.21, 37, 0.11, 3.98, 4.44, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.1.b.1', 'LV', 4.82, 37, 0.22, 4.37, 5.26, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.1.b.2', 'IM', 1.44, 37, 0.16, 1.12, 1.75, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.1.b.2', 'LV', 1.04, 37, 0.46, 0.11, 1.98, 'N', 'N', '2009-06-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.1.b.3', 'IM', 3.13, 37, 0.21, 2.70, 3.55, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.1.b.3', 'LV', 3.05, 37, 0.33, 2.38, 3.72, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.a.1', 'IM', 3.61, 37, 0.15, 3.31, 3.91, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.a.1', 'LV', 4.07, 37, 0.29, 3.49, 4.66, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.a.2', 'IM', 3.43, 37, 0.37, 2.69, 4.17, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.a.2', 'LV', 3.89, 37, 0.28, 3.32, 4.46, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.a.3', 'IM', 2.82, 37, 0.27, 2.28, 3.36, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.a.3', 'LV', 3.62, 37, 0.57, 2.46, 4.79, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.a.4', 'IM', 3.59, 35, 0.18, 3.23, 3.95, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.a.4', 'LV', 4.46, 36, 0.23, 4.00, 4.93, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.b.1', 'IM', 4.21, 36, 0.13, 3.95, 4.46, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.b.1', 'LV', 5.24, 36, 0.13, 4.98, 5.50, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.b.2', 'IM', 4.45, 37, 0.15, 4.16, 4.75, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.b.2', 'LV', 5.36, 36, 0.22, 4.90, 5.81, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.b.3', 'IM', 3.76, 37, 0.24, 3.28, 4.24, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.b.3', 'LV', 5.07, 37, 0.33, 4.40, 5.74, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.b.4', 'IM', 3.92, 37, 0.26, 3.38, 4.45, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.b.4', 'LV', 4.19, 37, 0.34, 3.51, 4.88, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.b.5', 'IM', 3.77, 37, 0.10, 3.56, 3.99, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.b.5', 'LV', 4.80, 37, 0.26, 4.28, 5.32, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.b.6', 'IM', 4.23, 36, 0.11, 4.00, 4.45, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.2.b.6', 'LV', 5.73, 36, 0.17, 5.39, 6.07, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.3.a.1', 'IM', 1.64, 36, 0.18, 1.28, 2.01, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.3.a.1', 'LV', 1.52, 36, 0.46, 0.59, 2.45, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.3.a.2', 'IM', 1.77, 36, 0.16, 1.45, 2.09, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.3.a.2', 'LV', 2.39, 36, 0.65, 1.06, 3.71, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.3.a.3', 'IM', 1.42, 37, 0.17, 1.08, 1.76, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.3.a.3', 'LV', 0.71, 37, 0.29, 0.13, 1.29, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.3.a.4', 'IM', 1.49, 37, 0.18, 1.12, 1.86, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.3.a.4', 'LV', 0.85, 37, 0.31, 0.22, 1.49, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.3.b.1', 'IM', 4.15, 37, 0.12, 3.91, 4.39, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.3.b.1', 'LV', 3.41, 37, 0.26, 2.87, 3.94, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.3.b.2', 'IM', 1.43, 37, 0.20, 1.02, 1.83, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.3.b.2', 'LV', 0.87, 37, 0.43, 0.00, 1.75, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.3.b.4', 'IM', 1.13, 37, 0.07, 1.00, 1.27, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.3.b.4', 'LV', 0.28, 37, 0.14, 0.00, 0.57, 'Y', 'Y', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.3.b.5', 'IM', 1.38, 37, 0.15, 1.07, 1.68, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.3.b.5', 'LV', 0.78, 37, 0.29, 0.19, 1.37, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.3.b.6', 'IM', 3.26, 37, 0.44, 2.38, 4.15, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.3.b.6', 'LV', 3.02, 37, 0.55, 1.90, 4.13, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.a.1', 'IM', 4.13, 36, 0.24, 3.65, 4.61, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.a.1', 'LV', 3.93, 36, 0.31, 3.29, 4.57, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.a.2', 'IM', 4.53, 36, 0.24, 4.04, 5.00, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.a.2', 'LV', 5.71, 36, 0.37, 4.95, 6.47, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.a.3', 'IM', 4.77, 37, 0.10, 4.57, 4.97, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.a.3', 'LV', 6.80, 37, 0.09, 6.63, 6.98, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.a.4', 'IM', 4.72, 37, 0.10, 4.52, 4.93, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.a.4', 'LV', 6.14, 37, 0.11, 5.92, 6.36, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.a.5', 'IM', 3.00, 37, 0.47, 2.05, 3.95, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.a.5', 'LV', 2.86, 37, 0.54, 1.77, 3.96, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.a.6', 'IM', 3.85, 37, 0.27, 3.30, 4.39, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.a.6', 'LV', 4.98, 37, 0.49, 3.98, 5.98, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.a.7', 'IM', 3.45, 37, 0.21, 3.02, 3.88, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.a.7', 'LV', 4.48, 37, 0.44, 3.60, 5.37, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.a.8', 'IM', 4.15, 37, 0.25, 3.65, 4.65, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.a.8', 'LV', 5.29, 37, 0.26, 4.77, 5.81, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.b.1', 'IM', 3.75, 37, 0.19, 3.38, 4.13, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.b.1', 'LV', 4.79, 37, 0.24, 4.31, 5.27, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.b.2', 'IM', 3.51, 37, 0.23, 3.05, 3.98, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.b.2', 'LV', 3.90, 37, 0.36, 3.17, 4.64, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.b.3', 'IM', 2.98, 37, 0.20, 2.57, 3.39, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.b.3', 'LV', 3.81, 37, 0.36, 3.08, 4.54, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.b.4', 'IM', 3.27, 37, 0.27, 2.73, 3.82, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.b.4', 'LV', 4.27, 37, 0.49, 3.27, 5.27, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.b.5', 'IM', 3.34, 37, 0.23, 2.87, 3.80, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.b.5', 'LV', 4.36, 37, 0.37, 3.61, 5.10, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.b.6', 'IM', 4.04, 37, 0.26, 3.52, 4.56, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.b.6', 'LV', 5.48, 37, 0.38, 4.71, 6.25, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.c.1', 'IM', 3.05, 37, 0.30, 2.44, 3.66, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.c.1', 'LV', 3.14, 36, 0.24, 2.65, 3.64, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.c.2', 'IM', 2.66, 37, 0.20, 2.26, 3.06, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.c.2', 'LV', 3.40, 36, 0.49, 2.41, 4.39, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.c.3', 'IM', 2.92, 37, 0.22, 2.48, 3.37, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '4.A.4.c.3', 'LV', 3.63, 37, 0.28, 3.07, 4.20, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.1.a.1', 'IM', 4.30, 35, 0.31, 3.66, 4.94, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.1.a.1', 'LV', 4.46, 34, 0.30, 3.84, 5.08, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.1.a.2', 'IM', 3.36, 34, 0.40, 2.54, 4.19, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.1.a.2', 'LV', 3.93, 34, 0.61, 2.70, 5.17, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.1.b.1', 'IM', 3.52, 35, 0.28, 2.96, 4.08, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.1.b.1', 'LV', 3.86, 34, 0.31, 3.23, 4.49, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.1.b.2', 'IM', 2.72, 35, 0.39, 1.93, 3.52, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.1.b.2', 'LV', 2.20, 35, 0.41, 1.36, 3.04, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.1.b.3', 'IM', 2.74, 33, 0.35, 2.02, 3.46, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.1.b.3', 'LV', 2.55, 33, 0.54, 1.45, 3.65, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.a.1', 'IM', 3.95, 34, 0.16, 3.63, 4.26, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.a.1', 'LV', 4.17, 34, 0.24, 3.68, 4.67, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.a.2', 'IM', 3.85, 34, 0.24, 3.37, 4.34, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.a.2', 'LV', 4.58, 34, 0.36, 3.85, 5.32, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.a.3', 'IM', 3.56, 34, 0.21, 3.13, 4.00, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.a.3', 'LV', 3.65, 34, 0.32, 3.00, 4.30, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.a.4', 'IM', 3.33, 34, 0.27, 2.78, 3.87, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.a.4', 'LV', 3.80, 34, 0.32, 3.14, 4.45, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.b.1', 'IM', 4.15, 35, 0.13, 3.89, 4.41, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.b.1', 'LV', 4.45, 35, 0.21, 4.02, 4.88, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.b.2', 'IM', 3.26, 35, 0.23, 2.81, 3.72, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.b.2', 'LV', 3.77, 35, 0.30, 3.16, 4.37, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.b.3', 'IM', 3.23, 35, 0.21, 2.80, 3.67, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.b.3', 'LV', 3.99, 35, 0.28, 3.42, 4.56, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.b.4', 'IM', 2.93, 35, 0.25, 2.43, 3.43, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.b.4', 'LV', 3.26, 35, 0.32, 2.61, 3.91, 'N', 'N', '2009-06-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.b.5', 'IM', 3.55, 35, 0.23, 3.09, 4.02, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.b.5', 'LV', 4.10, 35, 0.36, 3.38, 4.82, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.b.6', 'IM', 4.13, 35, 0.17, 3.78, 4.48, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.2.b.6', 'LV', 5.51, 35, 0.23, 5.05, 5.98, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.3.a.1', 'IM', 2.20, 35, 0.22, 1.75, 2.65, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.3.a.1', 'LV', 2.30, 35, 0.41, 1.46, 3.14, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.3.a.2', 'IM', 2.49, 35, 0.24, 2.01, 2.98, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.3.a.2', 'LV', 3.34, 35, 0.48, 2.35, 4.32, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.3.a.3', 'IM', 1.87, 35, 0.23, 1.40, 2.33, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.3.a.3', 'LV', 1.25, 35, 0.32, 0.61, 1.89, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.3.a.4', 'IM', 1.46, 35, 0.15, 1.17, 1.76, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.3.a.4', 'LV', 0.68, 35, 0.21, 0.25, 1.12, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.3.b.1', 'IM', 4.33, 35, 0.14, 4.05, 4.61, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.3.b.1', 'LV', 3.70, 35, 0.29, 3.11, 4.30, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.3.b.2', 'IM', 1.75, 34, 0.24, 1.27, 2.24, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.3.b.2', 'LV', 1.67, 34, 0.50, 0.66, 2.69, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.3.b.4', 'IM', 1.31, 35, 0.14, 1.02, 1.59, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.3.b.4', 'LV', 0.65, 35, 0.28, 0.07, 1.22, 'N', 'Y', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.3.b.5', 'IM', 1.61, 35, 0.20, 1.20, 2.01, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.3.b.5', 'LV', 0.95, 35, 0.29, 0.36, 1.54, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.3.b.6', 'IM', 3.93, 35, 0.17, 3.58, 4.28, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.3.b.6', 'LV', 4.33, 35, 0.29, 3.74, 4.92, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.a.1', 'IM', 2.57, 35, 0.25, 2.06, 3.08, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.a.1', 'LV', 2.43, 35, 0.36, 1.69, 3.16, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.a.2', 'IM', 4.53, 35, 0.13, 4.27, 4.79, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.a.2', 'LV', 4.88, 35, 0.16, 4.55, 5.21, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.a.3', 'IM', 4.07, 35, 0.21, 3.65, 4.49, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.a.3', 'LV', 4.78, 35, 0.21, 4.34, 5.22, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.a.4', 'IM', 3.98, 35, 0.22, 3.54, 4.43, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.a.4', 'LV', 4.84, 35, 0.21, 4.41, 5.26, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.a.5', 'IM', 2.71, 34, 0.28, 2.14, 3.28, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.a.5', 'LV', 3.12, 34, 0.33, 2.44, 3.80, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.a.6', 'IM', 2.21, 34, 0.22, 1.76, 2.66, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.a.6', 'LV', 2.21, 34, 0.32, 1.56, 2.87, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.a.7', 'IM', 3.63, 34, 0.28, 3.06, 4.20, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.a.7', 'LV', 4.28, 34, 0.23, 3.81, 4.75, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.a.8', 'IM', 3.44, 35, 0.26, 2.90, 3.98, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.a.8', 'LV', 4.06, 35, 0.29, 3.46, 4.65, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.b.1', 'IM', 3.55, 34, 0.31, 2.92, 4.18, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.b.1', 'LV', 4.33, 34, 0.52, 3.27, 5.39, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.b.2', 'IM', 3.03, 34, 0.30, 2.43, 3.63, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.b.2', 'LV', 2.80, 34, 0.43, 1.93, 3.68, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.b.3', 'IM', 2.90, 34, 0.31, 2.27, 3.52, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.b.3', 'LV', 2.73, 34, 0.43, 1.85, 3.62, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.b.4', 'IM', 2.81, 34, 0.30, 2.19, 3.42, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.b.4', 'LV', 2.74, 34, 0.46, 1.81, 3.67, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.b.5', 'IM', 2.59, 35, 0.25, 2.08, 3.09, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.b.5', 'LV', 3.23, 35, 0.46, 2.30, 4.16, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.b.6', 'IM', 2.70, 35, 0.17, 2.35, 3.05, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.b.6', 'LV', 3.52, 35, 0.34, 2.84, 4.21, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.c.1', 'IM', 4.24, 35, 0.16, 3.91, 4.57, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.c.1', 'LV', 4.38, 35, 0.34, 3.69, 5.06, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.c.2', 'IM', 2.51, 35, 0.30, 1.89, 3.13, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.c.2', 'LV', 2.47, 35, 0.46, 1.53, 3.42, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.c.3', 'IM', 3.36, 35, 0.20, 2.95, 3.76, 'N', NULL, '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '4.A.4.c.3', 'LV', 3.83, 35, 0.28, 3.26, 4.40, 'N', 'N', '2009-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.a.1', 'IM', 4.69, 47, 0.11, 4.46, 4.92, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.a.1', 'LV', 5.27, 47, 0.31, 4.64, 5.90, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.a.2', 'IM', 3.79, 47, 0.27, 3.26, 4.32, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.a.2', 'LV', 4.37, 46, 0.44, 3.49, 5.24, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.b.1', 'IM', 4.30, 47, 0.36, 3.57, 5.00, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.b.1', 'LV', 5.14, 46, 0.68, 3.77, 6.51, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.b.2', 'IM', 3.38, 47, 0.49, 2.40, 4.37, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.b.2', 'LV', 3.80, 46, 0.94, 1.91, 5.69, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.b.3', 'IM', 3.50, 47, 0.23, 3.04, 3.97, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.1.b.3', 'LV', 4.20, 47, 0.56, 3.07, 5.33, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.a.1', 'IM', 3.61, 47, 0.26, 3.08, 4.13, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.a.1', 'LV', 4.46, 47, 0.57, 3.32, 5.60, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.a.2', 'IM', 3.73, 46, 0.29, 3.15, 4.31, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.a.2', 'LV', 4.97, 47, 0.37, 4.23, 5.70, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.a.3', 'IM', 4.29, 47, 0.29, 3.71, 4.87, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.a.3', 'LV', 4.86, 47, 0.22, 4.42, 5.30, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.a.4', 'IM', 4.10, 45, 0.06, 3.97, 4.22, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.a.4', 'LV', 5.61, 46, 0.46, 4.69, 6.53, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.1', 'IM', 4.22, 45, 0.35, 3.52, 4.93, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.1', 'LV', 5.44, 46, 0.30, 4.85, 6.04, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.2', 'IM', 4.43, 45, 0.17, 4.09, 4.78, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.2', 'LV', 5.98, 46, 0.30, 5.38, 6.59, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.3', 'IM', 4.36, 45, 0.23, 3.90, 4.82, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.3', 'LV', 5.91, 46, 0.15, 5.61, 6.20, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.4', 'IM', 4.13, 47, 0.29, 3.54, 4.72, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.4', 'LV', 4.92, 47, 0.65, 3.60, 6.23, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.5', 'IM', 3.66, 47, 0.49, 2.67, 4.65, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.5', 'LV', 4.55, 47, 0.43, 3.68, 5.42, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.6', 'IM', 3.76, 47, 0.51, 2.72, 4.79, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.2.b.6', 'LV', 5.03, 47, 0.59, 3.84, 6.23, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.a.1', 'IM', 2.39, 47, 0.46, 1.47, 3.31, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.a.1', 'LV', 2.75, 47, 0.89, 0.95, 4.55, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.a.2', 'IM', 1.87, 46, 0.15, 1.56, 2.17, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.a.2', 'LV', 1.60, 47, 0.32, 0.97, 2.24, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.a.3', 'IM', 2.63, 47, 0.43, 1.77, 3.49, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.a.3', 'LV', 2.40, 47, 0.50, 1.40, 3.40, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.a.4', 'IM', 2.27, 47, 0.76, 1.00, 3.80, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.a.4', 'LV', 2.26, 47, 1.31, 0.00, 4.91, 'Y', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.1', 'IM', 4.78, 47, 0.10, 4.59, 4.98, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.1', 'LV', 6.00, 46, 0.34, 5.32, 6.68, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.2', 'IM', 2.35, 47, 0.20, 1.96, 2.75, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.2', 'LV', 2.25, 47, 0.28, 1.68, 2.82, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.4', 'IM', 2.52, 47, 0.69, 1.14, 3.90, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.4', 'LV', 2.71, 47, 1.20, 0.30, 5.12, 'N', 'N', '2008-06-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.5', 'IM', 2.84, 46, 0.65, 1.53, 4.15, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.5', 'LV', 3.49, 46, 1.06, 1.35, 5.63, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.6', 'IM', 4.13, 47, 0.37, 3.38, 4.88, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.3.b.6', 'LV', 4.85, 47, 0.71, 3.42, 6.29, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.1', 'IM', 4.22, 47, 0.27, 3.68, 4.76, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.1', 'LV', 4.79, 46, 0.69, 3.40, 6.18, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.2', 'IM', 3.75, 47, 0.49, 2.77, 4.74, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.2', 'LV', 4.33, 47, 0.67, 2.98, 5.68, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.3', 'IM', 3.90, 46, 0.41, 3.08, 4.72, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.3', 'LV', 4.76, 45, 0.75, 3.24, 6.27, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.4', 'IM', 4.45, 46, 0.21, 4.04, 4.87, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.4', 'LV', 5.93, 46, 0.34, 5.24, 6.62, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.5', 'IM', 2.84, 47, 0.28, 2.28, 3.41, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.5', 'LV', 3.06, 46, 0.43, 2.20, 3.92, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.6', 'IM', 3.48, 47, 0.47, 2.54, 4.43, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.6', 'LV', 4.32, 47, 0.81, 2.69, 5.95, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.7', 'IM', 3.89, 47, 0.39, 3.11, 4.68, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.7', 'LV', 5.03, 47, 0.68, 3.66, 6.39, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.8', 'IM', 2.64, 47, 0.72, 1.18, 4.09, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.a.8', 'LV', 2.81, 47, 1.25, 0.28, 5.33, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.1', 'IM', 3.98, 45, 0.11, 3.76, 4.20, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.1', 'LV', 5.14, 45, 0.33, 4.49, 5.80, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.2', 'IM', 4.35, 46, 0.21, 3.92, 4.79, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.2', 'LV', 5.20, 46, 0.55, 4.09, 6.31, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.3', 'IM', 3.77, 46, 0.41, 2.93, 4.60, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.3', 'LV', 4.65, 46, 0.75, 3.14, 6.16, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.4', 'IM', 4.23, 46, 0.24, 3.74, 4.72, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.4', 'LV', 5.26, 46, 0.53, 4.19, 6.33, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.5', 'IM', 4.12, 47, 0.27, 3.57, 4.67, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.5', 'LV', 5.22, 47, 0.55, 4.12, 6.31, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.6', 'IM', 3.82, 47, 0.18, 3.47, 4.18, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.b.6', 'LV', 5.20, 47, 0.31, 4.57, 5.83, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.c.1', 'IM', 3.22, 47, 0.26, 2.70, 3.74, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.c.1', 'LV', 4.22, 47, 0.54, 3.14, 5.30, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.c.2', 'IM', 3.27, 46, 0.25, 2.78, 3.77, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.c.2', 'LV', 4.52, 46, 0.46, 3.60, 5.45, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.c.3', 'IM', 3.61, 47, 0.18, 3.24, 3.98, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '4.A.4.c.3', 'LV', 4.68, 47, 0.42, 3.83, 5.52, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.a.1', 'IM', 4.53, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.a.1', 'LV', 5.23, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.a.2', 'IM', 3.43, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.a.2', 'LV', 4.13, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.b.1', 'IM', 3.77, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.b.1', 'LV', 4.62, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.b.2', 'IM', 1.43, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.b.2', 'LV', 0.83, 30, NULL, NULL, NULL, NULL, 'Y', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.b.3', 'IM', 3.10, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.1.b.3', 'LV', 3.48, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.a.1', 'IM', 3.38, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.a.1', 'LV', 4.38, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.a.2', 'IM', 4.48, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.a.2', 'LV', 5.38, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.a.3', 'IM', 4.00, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.a.3', 'LV', 4.76, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.a.4', 'IM', 4.50, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.a.4', 'LV', 5.60, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.1', 'IM', 4.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.1', 'LV', 6.10, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.2', 'IM', 3.67, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.2', 'LV', 4.53, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.3', 'IM', 4.07, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.3', 'LV', 5.30, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.4', 'IM', 4.28, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.4', 'LV', 5.34, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.5', 'IM', 3.34, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.5', 'LV', 4.24, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.6', 'IM', 4.10, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.2.b.6', 'LV', 5.52, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.a.1', 'IM', 1.62, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.a.1', 'LV', 0.97, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.a.2', 'IM', 1.50, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.a.2', 'LV', 0.97, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.a.3', 'IM', 1.73, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.a.3', 'LV', 1.10, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.a.4', 'IM', 1.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.a.4', 'LV', 0.60, 30, NULL, NULL, NULL, NULL, 'Y', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.1', 'IM', 4.23, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.1', 'LV', 4.03, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.2', 'IM', 1.23, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.2', 'LV', 0.53, 30, NULL, NULL, NULL, NULL, 'Y', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.4', 'IM', 1.20, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.4', 'LV', 0.43, 30, NULL, NULL, NULL, NULL, 'Y', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.5', 'IM', 1.27, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.5', 'LV', 0.53, 30, NULL, NULL, NULL, NULL, 'Y', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.6', 'IM', 3.33, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.3.b.6', 'LV', 3.83, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.1', 'IM', 3.97, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.1', 'LV', 4.30, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.2', 'IM', 4.37, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.2', 'LV', 5.47, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.3', 'IM', 4.03, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.3', 'LV', 4.97, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.4', 'IM', 3.93, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.4', 'LV', 5.43, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.5', 'IM', 2.03, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.5', 'LV', 2.20, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.6', 'IM', 2.80, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.6', 'LV', 3.23, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.7', 'IM', 3.47, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.7', 'LV', 5.07, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.8', 'IM', 2.17, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.a.8', 'LV', 2.33, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.1', 'IM', 3.63, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.1', 'LV', 4.83, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.2', 'IM', 4.10, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.2', 'LV', 4.63, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.3', 'IM', 3.07, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.3', 'LV', 3.79, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.4', 'IM', 3.83, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.4', 'LV', 5.43, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.5', 'IM', 3.63, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.5', 'LV', 4.93, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.6', 'IM', 3.80, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.b.6', 'LV', 5.47, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.c.1', 'IM', 2.90, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.c.1', 'LV', 4.07, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.c.2', 'IM', 3.40, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.c.2', 'LV', 4.60, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.c.3', 'IM', 4.23, 30, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '4.A.4.c.3', 'LV', 5.77, 30, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.1.a.1', 'IM', 3.84, 28, 0.41, 3.00, 4.68, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.1.a.1', 'LV', 4.23, 27, 0.52, 3.15, 5.30, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.1.a.2', 'IM', 4.03, 28, 0.20, 3.63, 4.43, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.1.a.2', 'LV', 4.41, 27, 0.29, 3.81, 5.01, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.1.b.1', 'IM', 3.19, 28, 0.33, 2.52, 3.85, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.1.b.1', 'LV', 3.62, 26, 0.58, 2.42, 4.82, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.1.b.2', 'IM', 1.95, 28, 0.32, 1.29, 2.61, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.1.b.2', 'LV', 1.33, 27, 0.55, 0.19, 2.46, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.1.b.3', 'IM', 2.38, 28, 0.36, 1.64, 3.13, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.1.b.3', 'LV', 2.18, 27, 0.60, 0.94, 3.42, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.a.1', 'IM', 3.59, 28, 0.26, 3.07, 4.12, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.a.1', 'LV', 4.00, 27, 0.31, 3.35, 4.64, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.a.2', 'IM', 3.17, 28, 0.45, 2.25, 4.09, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.a.2', 'LV', 3.66, 27, 0.82, 1.98, 5.35, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.a.3', 'IM', 3.91, 28, 0.29, 3.31, 4.52, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.a.3', 'LV', 4.10, 27, 0.54, 2.99, 5.22, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.a.4', 'IM', 3.83, 26, 0.27, 3.27, 4.39, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.a.4', 'LV', 4.29, 26, 0.29, 3.69, 4.90, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.b.1', 'IM', 3.81, 28, 0.32, 3.15, 4.47, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.b.1', 'LV', 4.77, 27, 0.57, 3.61, 5.94, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.b.2', 'IM', 3.46, 28, 0.20, 3.04, 3.87, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.b.2', 'LV', 4.62, 27, 0.47, 3.66, 5.58, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.b.3', 'IM', 3.74, 28, 0.19, 3.36, 4.12, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.b.3', 'LV', 4.66, 27, 0.13, 4.40, 4.93, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.b.4', 'IM', 3.34, 28, 0.16, 3.01, 3.68, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.b.4', 'LV', 3.77, 27, 0.32, 3.10, 4.43, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.b.5', 'IM', 3.05, 28, 0.26, 2.51, 3.58, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.b.5', 'LV', 3.52, 27, 0.51, 2.47, 4.56, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.b.6', 'IM', 3.93, 28, 0.26, 3.40, 4.46, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.2.b.6', 'LV', 5.14, 27, 0.48, 4.15, 6.14, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.3.a.1', 'IM', 1.34, 28, 0.11, 1.11, 1.57, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.3.a.1', 'LV', 0.72, 28, 0.24, 0.23, 1.21, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.3.a.2', 'IM', 1.46, 28, 0.31, 1.00, 2.10, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.3.a.2', 'LV', 0.84, 28, 0.55, 0.00, 1.97, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.3.a.3', 'IM', 1.59, 28, 0.24, 1.09, 2.10, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.3.a.3', 'LV', 1.05, 28, 0.40, 0.23, 1.86, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.3.a.4', 'IM', 1.08, 28, 0.05, 1.00, 1.19, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.3.a.4', 'LV', 0.14, 28, 0.10, 0.00, 0.34, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.3.b.1', 'IM', 4.41, 28, 0.21, 3.98, 4.85, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.3.b.1', 'LV', 4.74, 27, 0.56, 3.59, 5.90, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.3.b.2', 'IM', 1.03, 28, 0.02, 1.00, 1.07, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.3.b.2', 'LV', 0.05, 28, 0.04, 0.00, 0.13, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.3.b.4', 'IM', 1.03, 28, 0.02, 1.00, 1.07, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.3.b.4', 'LV', 0.05, 28, 0.04, 0.00, 0.14, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.3.b.5', 'IM', 1.17, 28, 0.11, 1.00, 1.39, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.3.b.5', 'LV', 0.33, 28, 0.22, 0.00, 0.77, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.3.b.6', 'IM', 3.02, 28, 0.18, 2.65, 3.38, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.3.b.6', 'LV', 3.04, 27, 0.24, 2.54, 3.53, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.a.1', 'IM', 2.91, 28, 0.22, 2.45, 3.37, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.a.1', 'LV', 2.49, 27, 0.33, 1.81, 3.17, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.a.2', 'IM', 4.16, 28, 0.20, 3.76, 4.56, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.a.2', 'LV', 4.98, 27, 0.37, 4.22, 5.74, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.a.3', 'IM', 3.69, 28, 0.21, 3.25, 4.12, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.a.3', 'LV', 4.30, 27, 0.43, 3.43, 5.17, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.a.4', 'IM', 4.03, 28, 0.28, 3.46, 4.60, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.a.4', 'LV', 5.04, 27, 0.46, 4.09, 5.99, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.a.5', 'IM', 2.33, 27, 0.15, 2.03, 2.63, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.a.5', 'LV', 2.49, 26, 0.19, 2.09, 2.88, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.a.6', 'IM', 3.74, 27, 0.32, 3.08, 4.39, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.a.6', 'LV', 4.59, 26, 0.56, 3.44, 5.73, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.a.7', 'IM', 3.71, 28, 0.28, 3.12, 4.29, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.a.7', 'LV', 4.77, 27, 0.57, 3.60, 5.93, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.a.8', 'IM', 3.31, 28, 0.40, 2.48, 4.14, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.a.8', 'LV', 3.78, 27, 0.84, 2.04, 5.51, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.b.1', 'IM', 3.84, 28, 0.31, 3.21, 4.47, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.b.1', 'LV', 4.73, 27, 0.46, 3.78, 5.68, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.b.2', 'IM', 3.81, 28, 0.28, 3.24, 4.37, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.b.2', 'LV', 4.25, 27, 0.52, 3.18, 5.31, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.b.3', 'IM', 3.79, 28, 0.32, 3.14, 4.44, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.b.3', 'LV', 4.36, 27, 0.61, 3.10, 5.62, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.b.4', 'IM', 4.07, 28, 0.22, 3.61, 4.53, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.b.4', 'LV', 4.76, 27, 0.55, 3.63, 5.89, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.b.5', 'IM', 4.06, 28, 0.23, 3.59, 4.53, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.b.5', 'LV', 5.01, 27, 0.38, 4.23, 5.79, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.b.6', 'IM', 3.50, 28, 0.34, 2.79, 4.20, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.b.6', 'LV', 4.23, 27, 0.58, 3.04, 5.42, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.c.1', 'IM', 2.62, 28, 0.36, 1.88, 3.35, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.c.1', 'LV', 2.72, 27, 0.64, 1.39, 4.04, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.c.2', 'IM', 2.91, 28, 0.44, 2.00, 3.83, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.c.2', 'LV', 3.20, 27, 0.74, 1.69, 4.71, 'N', 'N', '2014-07-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.c.3', 'IM', 2.40, 28, 0.40, 1.59, 3.21, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '4.A.4.c.3', 'LV', 2.35, 27, 0.68, 0.95, 3.74, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.a.1', 'IM', 4.21, 38, 0.09, 4.03, 4.38, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.a.1', 'LV', 4.62, 37, 0.18, 4.25, 4.99, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.a.2', 'IM', 3.98, 38, 0.14, 3.69, 4.27, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.a.2', 'LV', 5.03, 38, 0.21, 4.60, 5.46, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.b.1', 'IM', 4.00, 38, 0.13, 3.74, 4.27, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.b.1', 'LV', 4.54, 38, 0.27, 3.99, 5.09, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.b.2', 'IM', 3.56, 38, 0.20, 3.15, 3.96, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.b.2', 'LV', 4.09, 38, 0.29, 3.50, 4.67, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.b.3', 'IM', 3.67, 38, 0.23, 3.21, 4.13, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.1.b.3', 'LV', 3.74, 38, 0.33, 3.07, 4.42, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.a.1', 'IM', 3.93, 38, 0.14, 3.65, 4.21, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.a.1', 'LV', 4.71, 38, 0.27, 4.16, 5.26, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.a.2', 'IM', 3.54, 38, 0.20, 3.13, 3.95, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.a.2', 'LV', 4.51, 38, 0.37, 3.77, 5.26, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.a.3', 'IM', 3.63, 38, 0.22, 3.20, 4.07, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.a.3', 'LV', 4.01, 38, 0.34, 3.34, 4.69, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.a.4', 'IM', 3.68, 38, 0.15, 3.38, 3.98, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.a.4', 'LV', 4.24, 38, 0.19, 3.85, 4.63, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.1', 'IM', 4.47, 38, 0.09, 4.28, 4.65, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.1', 'LV', 5.24, 38, 0.20, 4.84, 5.64, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.2', 'IM', 3.77, 38, 0.09, 3.59, 3.96, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.2', 'LV', 4.77, 38, 0.17, 4.43, 5.11, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.3', 'IM', 3.82, 38, 0.10, 3.62, 4.02, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.3', 'LV', 4.70, 38, 0.18, 4.33, 5.06, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.4', 'IM', 3.81, 38, 0.19, 3.43, 4.19, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.4', 'LV', 4.03, 38, 0.35, 3.33, 4.74, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.5', 'IM', 4.01, 38, 0.12, 3.77, 4.25, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.5', 'LV', 4.91, 38, 0.18, 4.55, 5.28, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.6', 'IM', 4.12, 38, 0.14, 3.83, 4.40, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.2.b.6', 'LV', 5.22, 38, 0.21, 4.78, 5.65, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.a.1', 'IM', 2.45, 38, 0.18, 2.08, 2.82, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.a.1', 'LV', 2.77, 38, 0.39, 1.99, 3.56, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.a.2', 'IM', 2.59, 38, 0.20, 2.17, 3.00, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.a.2', 'LV', 3.93, 38, 0.42, 3.08, 4.78, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.a.3', 'IM', 3.10, 38, 0.31, 2.48, 3.72, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.a.3', 'LV', 3.80, 38, 0.46, 2.87, 4.73, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.a.4', 'IM', 2.10, 38, 0.20, 1.70, 2.50, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.a.4', 'LV', 1.96, 38, 0.37, 1.20, 2.72, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.1', 'IM', 3.81, 38, 0.20, 3.40, 4.22, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.1', 'LV', 3.72, 38, 0.39, 2.93, 4.51, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.2', 'IM', 2.65, 38, 0.25, 2.15, 3.15, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.2', 'LV', 3.05, 38, 0.43, 2.18, 3.91, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.4', 'IM', 2.62, 38, 0.29, 2.03, 3.20, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.4', 'LV', 3.12, 38, 0.57, 1.97, 4.27, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.5', 'IM', 2.03, 37, 0.28, 1.47, 2.60, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.5', 'LV', 2.10, 38, 0.54, 1.01, 3.20, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.6', 'IM', 3.85, 38, 0.20, 3.44, 4.26, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.3.b.6', 'LV', 4.04, 38, 0.36, 3.31, 4.77, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.1', 'IM', 3.44, 38, 0.17, 3.10, 3.78, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.1', 'LV', 3.63, 38, 0.30, 3.02, 4.25, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.2', 'IM', 4.38, 38, 0.16, 4.07, 4.70, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.2', 'LV', 5.35, 38, 0.28, 4.79, 5.91, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.3', 'IM', 3.50, 38, 0.17, 3.16, 3.83, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.3', 'LV', 3.97, 37, 0.21, 3.55, 4.39, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.4', 'IM', 4.15, 38, 0.20, 3.75, 4.55, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.4', 'LV', 5.05, 38, 0.18, 4.70, 5.41, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.5', 'IM', 3.15, 38, 0.23, 2.68, 3.62, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.5', 'LV', 3.88, 38, 0.31, 3.26, 4.50, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.6', 'IM', 3.38, 38, 0.23, 2.91, 3.84, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.6', 'LV', 3.70, 38, 0.32, 3.04, 4.36, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.7', 'IM', 4.17, 38, 0.14, 3.89, 4.45, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.7', 'LV', 5.44, 38, 0.20, 5.04, 5.85, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.8', 'IM', 1.78, 38, 0.19, 1.40, 2.16, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.a.8', 'LV', 1.79, 38, 0.45, 0.88, 2.70, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.1', 'IM', 4.03, 38, 0.22, 3.58, 4.49, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.1', 'LV', 5.10, 38, 0.39, 4.31, 5.88, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.2', 'IM', 3.88, 38, 0.24, 3.40, 4.36, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.2', 'LV', 4.48, 38, 0.34, 3.79, 5.17, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.3', 'IM', 3.83, 38, 0.16, 3.52, 4.15, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.3', 'LV', 4.14, 38, 0.26, 3.61, 4.67, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.4', 'IM', 4.18, 38, 0.18, 3.81, 4.55, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.4', 'LV', 5.78, 38, 0.22, 5.34, 6.23, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.5', 'IM', 3.99, 38, 0.23, 3.53, 4.44, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.5', 'LV', 4.85, 38, 0.34, 4.16, 5.55, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.6', 'IM', 3.42, 38, 0.19, 3.03, 3.81, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.b.6', 'LV', 4.79, 38, 0.34, 4.10, 5.48, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.c.1', 'IM', 3.11, 38, 0.19, 2.73, 3.50, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.c.1', 'LV', 3.68, 38, 0.30, 3.08, 4.29, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.c.2', 'IM', 3.68, 38, 0.14, 3.40, 3.97, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.c.2', 'LV', 4.64, 38, 0.21, 4.22, 5.06, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.c.3', 'IM', 3.87, 38, 0.14, 3.59, 4.15, 'N', NULL, '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '4.A.4.c.3', 'LV', 4.93, 38, 0.20, 4.53, 5.32, 'N', 'N', '2013-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.a.1', 'IM', 4.34, 21, 0.19, 3.95, 4.73, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.a.1', 'LV', 3.87, 21, 0.29, 3.27, 4.48, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.a.2', 'IM', 4.35, 21, 0.31, 3.71, 5.00, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.a.2', 'LV', 5.01, 21, 0.57, 3.83, 6.19, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.b.1', 'IM', 4.19, 21, 0.29, 3.59, 4.80, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.b.1', 'LV', 5.19, 21, 0.37, 4.41, 5.97, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.b.2', 'IM', 3.57, 21, 0.32, 2.89, 4.24, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.b.2', 'LV', 3.89, 21, 0.29, 3.29, 4.49, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.b.3', 'IM', 3.66, 21, 0.30, 3.03, 4.30, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.1.b.3', 'LV', 3.40, 21, 0.57, 2.20, 4.59, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.a.1', 'IM', 4.00, 21, 0.32, 3.34, 4.66, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.a.1', 'LV', 4.32, 21, 0.39, 3.51, 5.13, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.a.2', 'IM', 3.53, 21, 0.39, 2.72, 4.34, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.a.2', 'LV', 4.84, 21, 0.64, 3.51, 6.18, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.a.3', 'IM', 4.68, 21, 0.19, 4.30, 5.00, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.a.3', 'LV', 4.73, 21, 0.46, 3.77, 5.68, 'N', 'N', '2012-07-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.a.4', 'IM', 4.19, 21, 0.35, 3.46, 4.91, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.a.4', 'LV', 5.35, 21, 0.39, 4.53, 6.17, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.1', 'IM', 4.51, 21, 0.20, 4.09, 4.93, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.1', 'LV', 5.42, 21, 0.49, 4.39, 6.45, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.2', 'IM', 3.36, 21, 0.38, 2.57, 4.15, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.2', 'LV', 4.80, 21, 0.36, 4.05, 5.54, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.3', 'IM', 3.70, 21, 0.30, 3.07, 4.34, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.3', 'LV', 5.21, 21, 0.27, 4.65, 5.76, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.4', 'IM', 3.49, 21, 0.40, 2.66, 4.32, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.4', 'LV', 4.03, 21, 0.54, 2.91, 5.15, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.5', 'IM', 2.52, 21, 0.33, 1.84, 3.21, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.5', 'LV', 3.20, 21, 0.68, 1.77, 4.62, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.6', 'IM', 3.70, 21, 0.19, 3.32, 4.09, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.2.b.6', 'LV', 5.04, 21, 0.48, 4.05, 6.04, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.a.1', 'IM', 2.54, 21, 0.32, 1.87, 3.22, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.a.1', 'LV', 2.87, 21, 0.28, 2.28, 3.46, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.a.2', 'IM', 2.04, 20, 0.29, 1.42, 2.65, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.a.2', 'LV', 3.34, 21, 0.60, 2.08, 4.60, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.a.3', 'IM', 2.75, 21, 0.61, 1.48, 4.03, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.a.3', 'LV', 2.96, 21, 0.96, 0.96, 4.97, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.a.4', 'IM', 2.05, 21, 0.48, 1.05, 3.04, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.a.4', 'LV', 1.54, 21, 0.61, 0.27, 2.81, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.1', 'IM', 4.36, 21, 0.20, 3.95, 4.76, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.1', 'LV', 3.67, 21, 0.18, 3.29, 4.05, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.2', 'IM', 2.07, 21, 0.49, 1.05, 3.09, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.2', 'LV', 1.97, 21, 0.84, 0.21, 3.73, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.4', 'IM', 2.65, 21, 0.44, 1.73, 3.58, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.4', 'LV', 3.42, 21, 0.78, 1.80, 5.05, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.5', 'IM', 2.69, 21, 0.69, 1.25, 4.14, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.5', 'LV', 3.18, 21, 1.29, 0.48, 5.88, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.6', 'IM', 3.83, 21, 0.42, 2.96, 4.69, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.3.b.6', 'LV', 3.87, 21, 0.73, 2.34, 5.40, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.1', 'IM', 3.69, 21, 0.19, 3.30, 4.08, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.1', 'LV', 4.48, 21, 0.56, 3.31, 5.65, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.2', 'IM', 4.07, 21, 0.21, 3.62, 4.52, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.2', 'LV', 4.89, 21, 0.28, 4.31, 5.46, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.3', 'IM', 2.54, 21, 0.33, 1.85, 3.22, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.3', 'LV', 3.17, 21, 0.63, 1.87, 4.48, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.4', 'IM', 3.72, 21, 0.36, 2.97, 4.47, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.4', 'LV', 4.86, 21, 0.28, 4.28, 5.43, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.5', 'IM', 1.86, 21, 0.46, 1.00, 2.81, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.5', 'LV', 1.79, 21, 0.80, 0.11, 3.47, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.6', 'IM', 1.85, 21, 0.30, 1.23, 2.47, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.6', 'LV', 1.69, 21, 0.59, 0.45, 2.92, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.7', 'IM', 2.72, 21, 0.19, 2.33, 3.12, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.7', 'LV', 3.55, 21, 0.20, 3.13, 3.98, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.8', 'IM', 1.86, 21, 0.27, 1.29, 2.42, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.a.8', 'LV', 2.02, 21, 0.56, 0.85, 3.18, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.1', 'IM', 3.39, 21, 0.20, 2.98, 3.79, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.1', 'LV', 3.94, 21, 0.36, 3.19, 4.69, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.2', 'IM', 3.35, 21, 0.28, 2.76, 3.94, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.2', 'LV', 4.03, 21, 0.34, 3.33, 4.73, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.3', 'IM', 3.68, 21, 0.44, 2.76, 4.61, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.3', 'LV', 3.85, 21, 0.36, 3.10, 4.60, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.4', 'IM', 3.70, 21, 0.30, 3.06, 4.33, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.4', 'LV', 4.71, 21, 0.30, 4.09, 5.33, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.5', 'IM', 3.18, 21, 0.28, 2.60, 3.76, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.5', 'LV', 4.18, 21, 0.28, 3.61, 4.76, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.6', 'IM', 2.52, 21, 0.46, 1.56, 3.48, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.b.6', 'LV', 3.02, 21, 0.73, 1.50, 4.54, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.c.1', 'IM', 2.20, 21, 0.29, 1.59, 2.80, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.c.1', 'LV', 2.69, 21, 0.54, 1.55, 3.82, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.c.2', 'IM', 2.04, 21, 0.34, 1.33, 2.74, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.c.2', 'LV', 2.06, 21, 0.79, 0.40, 3.72, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.c.3', 'IM', 2.74, 21, 0.61, 1.47, 4.02, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '4.A.4.c.3', 'LV', 2.94, 21, 0.90, 1.08, 4.81, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.a.1', 'IM', 4.47, 14, 0.19, 4.07, 4.88, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.a.1', 'LV', 4.65, 14, 0.11, 4.40, 4.89, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.a.2', 'IM', 4.20, 14, 0.17, 3.82, 4.57, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.a.2', 'LV', 5.29, 14, 0.26, 4.72, 5.86, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.b.1', 'IM', 4.21, 14, 0.19, 3.80, 4.61, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.b.1', 'LV', 4.89, 14, 0.19, 4.48, 5.30, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.b.2', 'IM', 3.79, 14, 0.21, 3.34, 4.23, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.b.2', 'LV', 4.61, 14, 0.21, 4.16, 5.06, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.b.3', 'IM', 3.53, 14, 0.18, 3.14, 3.92, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.1.b.3', 'LV', 3.97, 14, 0.27, 3.39, 4.55, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.a.1', 'IM', 3.94, 14, 0.12, 3.68, 4.20, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.a.1', 'LV', 4.92, 14, 0.33, 4.22, 5.62, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.a.2', 'IM', 3.98, 14, 0.16, 3.64, 4.32, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.a.2', 'LV', 4.87, 14, 0.23, 4.37, 5.36, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.a.3', 'IM', 4.12, 14, 0.22, 3.65, 4.60, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.a.3', 'LV', 4.56, 14, 0.42, 3.66, 5.46, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.a.4', 'IM', 3.62, 14, 0.23, 3.13, 4.11, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.a.4', 'LV', 4.70, 14, 0.22, 4.23, 5.17, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.1', 'IM', 4.38, 14, 0.20, 3.95, 4.80, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.1', 'LV', 5.02, 14, 0.33, 4.32, 5.73, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.2', 'IM', 3.69, 14, 0.21, 3.23, 4.16, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.2', 'LV', 4.55, 14, 0.37, 3.76, 5.35, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.3', 'IM', 4.02, 14, 0.19, 3.60, 4.43, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.3', 'LV', 4.85, 14, 0.20, 4.42, 5.28, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.4', 'IM', 3.46, 14, 0.19, 3.05, 3.86, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.4', 'LV', 3.76, 14, 0.35, 3.02, 4.51, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.5', 'IM', 4.45, 14, 0.17, 4.08, 4.81, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.5', 'LV', 5.65, 14, 0.22, 5.17, 6.13, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.6', 'IM', 4.61, 14, 0.12, 4.35, 4.87, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.2.b.6', 'LV', 5.59, 14, 0.29, 4.95, 6.22, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.a.1', 'IM', 2.30, 14, 0.13, 2.02, 2.58, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.a.1', 'LV', 3.33, 14, 0.25, 2.79, 3.87, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.a.2', 'IM', 2.18, 14, 0.25, 1.65, 2.72, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.a.2', 'LV', 2.92, 14, 0.51, 1.83, 4.01, 'N', 'N', '2011-07-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.a.3', 'IM', 2.41, 14, 0.34, 1.67, 3.15, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.a.3', 'LV', 2.38, 14, 0.52, 1.27, 3.49, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.a.4', 'IM', 2.98, 14, 0.26, 2.41, 3.55, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.a.4', 'LV', 2.81, 14, 0.19, 2.40, 3.22, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.1', 'IM', 4.43, 14, 0.15, 4.11, 4.75, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.1', 'LV', 3.84, 14, 0.32, 3.15, 4.53, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.2', 'IM', 3.02, 14, 0.29, 2.39, 3.65, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.2', 'LV', 3.67, 14, 0.38, 2.86, 4.49, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.4', 'IM', 3.11, 14, 0.32, 2.42, 3.80, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.4', 'LV', 3.83, 14, 0.55, 2.64, 5.02, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.5', 'IM', 2.79, 14, 0.38, 1.97, 3.61, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.5', 'LV', 2.66, 14, 0.44, 1.72, 3.61, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.6', 'IM', 3.72, 14, 0.45, 2.75, 4.69, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.3.b.6', 'LV', 4.00, 14, 0.53, 2.86, 5.15, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.1', 'IM', 3.38, 14, 0.26, 2.81, 3.94, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.1', 'LV', 3.40, 14, 0.29, 2.77, 4.04, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.2', 'IM', 4.67, 14, 0.14, 4.37, 4.97, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.2', 'LV', 5.38, 14, 0.26, 4.81, 5.94, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.3', 'IM', 3.92, 14, 0.22, 3.45, 4.38, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.3', 'LV', 4.33, 14, 0.31, 3.66, 5.00, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.4', 'IM', 4.09, 14, 0.22, 3.62, 4.56, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.4', 'LV', 5.08, 14, 0.25, 4.55, 5.61, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.5', 'IM', 3.15, 14, 0.27, 2.55, 3.74, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.5', 'LV', 3.61, 14, 0.39, 2.78, 4.45, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.6', 'IM', 2.97, 14, 0.25, 2.44, 3.50, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.6', 'LV', 3.28, 14, 0.33, 2.58, 3.98, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.7', 'IM', 3.52, 14, 0.27, 2.95, 4.10, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.7', 'LV', 4.82, 14, 0.34, 4.10, 5.55, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.8', 'IM', 1.88, 14, 0.21, 1.43, 2.34, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.a.8', 'LV', 1.80, 14, 0.39, 0.96, 2.64, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.1', 'IM', 4.13, 13, 0.19, 3.71, 4.55, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.1', 'LV', 5.48, 13, 0.28, 4.87, 6.09, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.2', 'IM', 4.28, 12, 0.21, 3.81, 4.75, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.2', 'LV', 4.60, 13, 0.28, 4.00, 5.21, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.3', 'IM', 3.76, 13, 0.29, 3.14, 4.39, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.3', 'LV', 4.23, 13, 0.31, 3.55, 4.91, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.4', 'IM', 3.86, 13, 0.28, 3.25, 4.47, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.4', 'LV', 4.63, 13, 0.45, 3.65, 5.61, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.5', 'IM', 3.73, 14, 0.26, 3.17, 4.30, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.5', 'LV', 4.55, 14, 0.31, 3.88, 5.22, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.6', 'IM', 3.57, 13, 0.30, 2.92, 4.22, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.b.6', 'LV', 4.12, 14, 0.35, 3.36, 4.88, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.c.1', 'IM', 3.73, 14, 0.18, 3.35, 4.11, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.c.1', 'LV', 3.74, 14, 0.23, 3.26, 4.23, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.c.2', 'IM', 3.29, 14, 0.37, 2.50, 4.08, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.c.2', 'LV', 3.96, 14, 0.52, 2.83, 5.09, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.c.3', 'IM', 4.12, 14, 0.16, 3.77, 4.48, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '4.A.4.c.3', 'LV', 4.79, 14, 0.18, 4.40, 5.18, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.a.1', 'IM', 4.22, 42, 0.17, 3.88, 4.56, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.a.1', 'LV', 4.29, 42, 0.29, 3.71, 4.88, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.a.2', 'IM', 3.94, 42, 0.20, 3.54, 4.34, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.a.2', 'LV', 4.28, 42, 0.24, 3.79, 4.76, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.b.1', 'IM', 3.92, 42, 0.15, 3.61, 4.23, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.b.1', 'LV', 3.69, 42, 0.34, 3.01, 4.37, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.b.2', 'IM', 4.20, 42, 0.18, 3.85, 4.56, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.b.2', 'LV', 4.32, 42, 0.28, 3.75, 4.89, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.b.3', 'IM', 3.87, 42, 0.20, 3.47, 4.28, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.1.b.3', 'LV', 3.50, 42, 0.27, 2.96, 4.04, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.a.1', 'IM', 3.71, 42, 0.21, 3.28, 4.14, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.a.1', 'LV', 3.95, 42, 0.25, 3.45, 4.45, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.a.2', 'IM', 3.35, 42, 0.34, 2.66, 4.04, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.a.2', 'LV', 3.90, 42, 0.46, 2.97, 4.82, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.a.3', 'IM', 4.00, 42, 0.13, 3.74, 4.27, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.a.3', 'LV', 4.06, 42, 0.32, 3.42, 4.70, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.a.4', 'IM', 3.44, 42, 0.26, 2.91, 3.97, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.a.4', 'LV', 3.86, 41, 0.28, 3.29, 4.43, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.1', 'IM', 4.14, 42, 0.16, 3.81, 4.47, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.1', 'LV', 4.55, 42, 0.43, 3.69, 5.42, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.2', 'IM', 3.24, 42, 0.27, 2.70, 3.79, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.2', 'LV', 3.95, 42, 0.27, 3.40, 4.51, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.3', 'IM', 3.36, 42, 0.27, 2.80, 3.91, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.3', 'LV', 4.44, 42, 0.28, 3.88, 5.00, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.4', 'IM', 3.59, 42, 0.24, 3.11, 4.06, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.4', 'LV', 4.01, 42, 0.37, 3.27, 4.75, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.5', 'IM', 3.92, 42, 0.16, 3.60, 4.24, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.5', 'LV', 4.92, 42, 0.43, 4.04, 5.79, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.6', 'IM', 4.20, 42, 0.23, 3.73, 4.66, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.2.b.6', 'LV', 5.70, 42, 0.21, 5.28, 6.12, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.a.1', 'IM', 2.54, 42, 0.21, 2.11, 2.97, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.a.1', 'LV', 3.02, 42, 0.47, 2.07, 3.98, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.a.2', 'IM', 1.96, 42, 0.27, 1.41, 2.51, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.a.2', 'LV', 2.43, 42, 0.59, 1.24, 3.62, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.a.3', 'IM', 2.04, 42, 0.28, 1.47, 2.61, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.a.3', 'LV', 2.24, 42, 0.53, 1.16, 3.32, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.a.4', 'IM', 2.26, 42, 0.38, 1.50, 3.03, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.a.4', 'LV', 1.83, 42, 0.47, 0.88, 2.77, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.1', 'IM', 3.64, 42, 0.34, 2.97, 4.32, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.1', 'LV', 3.08, 42, 0.23, 2.63, 3.54, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.2', 'IM', 3.02, 42, 0.38, 2.24, 3.79, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.2', 'LV', 3.41, 42, 0.37, 2.66, 4.15, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.4', 'IM', 3.32, 42, 0.42, 2.48, 4.17, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.4', 'LV', 4.13, 42, 0.58, 2.96, 5.30, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.5', 'IM', 2.64, 42, 0.39, 1.85, 3.44, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.5', 'LV', 2.78, 42, 0.59, 1.60, 3.97, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.6', 'IM', 3.61, 42, 0.21, 3.19, 4.04, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.3.b.6', 'LV', 3.93, 42, 0.27, 3.38, 4.48, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.1', 'IM', 3.49, 42, 0.28, 2.92, 4.06, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.1', 'LV', 3.33, 41, 0.24, 2.85, 3.81, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.2', 'IM', 4.29, 42, 0.29, 3.71, 4.87, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.2', 'LV', 4.82, 42, 0.33, 4.15, 5.48, 'N', 'N', '2012-07-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.3', 'IM', 3.17, 42, 0.31, 2.54, 3.79, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.3', 'LV', 3.32, 42, 0.41, 2.50, 4.14, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.4', 'IM', 4.09, 42, 0.24, 3.60, 4.58, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.4', 'LV', 4.89, 42, 0.29, 4.29, 5.48, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.5', 'IM', 2.71, 42, 0.25, 2.21, 3.21, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.5', 'LV', 3.62, 42, 0.42, 2.78, 4.46, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.6', 'IM', 3.32, 42, 0.33, 2.65, 4.00, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.6', 'LV', 3.81, 42, 0.34, 3.11, 4.50, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.7', 'IM', 3.36, 41, 0.13, 3.10, 3.62, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.7', 'LV', 4.80, 42, 0.34, 4.11, 5.49, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.8', 'IM', 1.98, 41, 0.42, 1.14, 2.83, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.a.8', 'LV', 1.82, 41, 0.67, 0.47, 3.17, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.1', 'IM', 3.91, 42, 0.20, 3.50, 4.32, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.1', 'LV', 5.11, 42, 0.39, 4.31, 5.90, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.2', 'IM', 3.80, 42, 0.22, 3.36, 4.24, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.2', 'LV', 4.28, 42, 0.28, 3.72, 4.84, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.3', 'IM', 3.32, 42, 0.23, 2.85, 3.79, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.3', 'LV', 4.18, 42, 0.41, 3.36, 5.01, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.4', 'IM', 3.72, 42, 0.21, 3.29, 4.15, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.4', 'LV', 5.31, 42, 0.22, 4.87, 5.75, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.5', 'IM', 3.78, 42, 0.17, 3.43, 4.13, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.5', 'LV', 4.92, 41, 0.34, 4.23, 5.61, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.6', 'IM', 3.22, 42, 0.23, 2.76, 3.68, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.b.6', 'LV', 4.94, 42, 0.40, 4.13, 5.75, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.c.1', 'IM', 3.11, 42, 0.27, 2.55, 3.66, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.c.1', 'LV', 3.59, 42, 0.46, 2.67, 4.51, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.c.2', 'IM', 2.94, 40, 0.21, 2.52, 3.35, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.c.2', 'LV', 3.81, 42, 0.33, 3.14, 4.48, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.c.3', 'IM', 3.79, 41, 0.24, 3.30, 4.29, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '4.A.4.c.3', 'LV', 4.69, 41, 0.27, 4.15, 5.22, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.a.1', 'IM', 4.25, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.a.1', 'LV', 4.71, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.a.2', 'IM', 3.42, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.a.2', 'LV', 3.54, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.b.1', 'IM', 3.50, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.b.1', 'LV', 4.04, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.b.2', 'IM', 2.67, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.b.2', 'LV', 2.75, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.b.3', 'IM', 3.21, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.1.b.3', 'LV', 3.29, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.a.1', 'IM', 3.46, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.a.1', 'LV', 4.08, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.a.2', 'IM', 3.62, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.a.2', 'LV', 4.08, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.a.3', 'IM', 3.50, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.a.3', 'LV', 3.92, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.a.4', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.a.4', 'LV', 4.67, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.1', 'IM', 4.25, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.1', 'LV', 4.88, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.2', 'IM', 3.58, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.2', 'LV', 4.08, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.3', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.3', 'LV', 4.58, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.4', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.4', 'LV', 4.29, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.5', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.5', 'LV', 4.67, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.6', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.2.b.6', 'LV', 5.12, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.a.1', 'IM', 1.67, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.a.1', 'LV', 1.33, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.a.2', 'IM', 1.46, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.a.2', 'LV', 1.08, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.a.3', 'IM', 1.42, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.a.3', 'LV', 0.71, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.a.4', 'IM', 1.46, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.a.4', 'LV', 1.00, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.1', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.1', 'LV', 3.50, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.2', 'IM', 2.08, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.2', 'LV', 1.92, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.4', 'IM', 1.12, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.4', 'LV', 0.46, 24, NULL, NULL, NULL, NULL, 'Y', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.5', 'IM', 1.08, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.5', 'LV', 0.25, 24, NULL, NULL, NULL, NULL, 'Y', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.6', 'IM', 3.33, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.3.b.6', 'LV', 3.38, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.1', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.1', 'LV', 3.58, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.2', 'IM', 4.33, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.2', 'LV', 5.04, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.3', 'IM', 4.33, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.3', 'LV', 4.83, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.4', 'IM', 4.25, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.4', 'LV', 5.50, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.5', 'IM', 2.46, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.5', 'LV', 2.88, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.6', 'IM', 3.67, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.6', 'LV', 4.42, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.7', 'IM', 4.46, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.7', 'LV', 5.96, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.8', 'IM', 2.29, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.a.8', 'LV', 2.62, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.1', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.1', 'LV', 4.67, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.2', 'IM', 3.83, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.2', 'LV', 4.17, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.3', 'IM', 3.50, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.3', 'LV', 3.96, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.4', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.4', 'LV', 4.96, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.5', 'IM', 3.92, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.5', 'LV', 4.75, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.6', 'IM', 3.42, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.b.6', 'LV', 4.71, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.c.1', 'IM', 3.38, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.c.1', 'LV', 3.92, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.c.2', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.c.2', 'LV', 4.42, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.c.3', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, NULL, '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '4.A.4.c.3', 'LV', 4.83, 24, NULL, NULL, NULL, NULL, 'N', '2009-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.1.a.1', 'IM', 4.47, 29, 0.14, 4.18, 4.75, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.1.a.1', 'LV', 4.65, 28, 0.25, 4.15, 5.15, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.1.a.2', 'IM', 4.00, 29, 0.13, 3.73, 4.27, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.1.a.2', 'LV', 4.31, 29, 0.23, 3.84, 4.78, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.1.b.1', 'IM', 4.07, 29, 0.15, 3.76, 4.39, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.1.b.1', 'LV', 4.12, 29, 0.16, 3.80, 4.45, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.1.b.2', 'IM', 3.44, 29, 0.22, 3.00, 3.89, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.1.b.2', 'LV', 3.11, 29, 0.21, 2.68, 3.53, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.1.b.3', 'IM', 3.58, 29, 0.21, 3.15, 4.01, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.1.b.3', 'LV', 3.13, 29, 0.30, 2.51, 3.75, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.a.1', 'IM', 3.66, 29, 0.17, 3.31, 4.01, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.a.1', 'LV', 4.09, 29, 0.33, 3.42, 4.77, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.a.2', 'IM', 3.87, 29, 0.17, 3.52, 4.23, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.a.2', 'LV', 4.56, 29, 0.28, 3.99, 5.13, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.a.3', 'IM', 4.12, 29, 0.15, 3.81, 4.43, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.a.3', 'LV', 4.46, 29, 0.18, 4.09, 4.84, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.a.4', 'IM', 3.82, 29, 0.18, 3.46, 4.18, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.a.4', 'LV', 4.14, 29, 0.28, 3.57, 4.71, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.b.1', 'IM', 4.69, 29, 0.11, 4.47, 4.92, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.b.1', 'LV', 4.85, 29, 0.25, 4.33, 5.37, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.b.2', 'IM', 3.76, 29, 0.17, 3.42, 4.11, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.b.2', 'LV', 4.68, 29, 0.19, 4.28, 5.08, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.b.3', 'IM', 3.99, 29, 0.14, 3.71, 4.27, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.b.3', 'LV', 4.40, 29, 0.19, 4.01, 4.79, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.b.4', 'IM', 3.36, 29, 0.18, 3.00, 3.73, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.b.4', 'LV', 3.65, 29, 0.35, 2.93, 4.37, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.b.5', 'IM', 3.91, 29, 0.23, 3.45, 4.37, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.b.5', 'LV', 4.60, 28, 0.41, 3.76, 5.45, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.b.6', 'IM', 4.06, 29, 0.06, 3.93, 4.19, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.2.b.6', 'LV', 5.19, 29, 0.23, 4.71, 5.67, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.3.a.1', 'IM', 2.15, 29, 0.19, 1.76, 2.53, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.3.a.1', 'LV', 2.28, 29, 0.33, 1.62, 2.95, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.3.a.2', 'IM', 2.15, 28, 0.24, 1.67, 2.64, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.3.a.2', 'LV', 2.94, 28, 0.51, 1.89, 3.98, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.3.a.3', 'IM', 2.12, 28, 0.18, 1.75, 2.48, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.3.a.3', 'LV', 1.97, 28, 0.33, 1.29, 2.66, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.3.a.4', 'IM', 2.35, 29, 0.28, 1.78, 2.93, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.3.a.4', 'LV', 2.41, 29, 0.51, 1.36, 3.46, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.3.b.1', 'IM', 4.20, 29, 0.13, 3.94, 4.47, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.3.b.1', 'LV', 3.43, 29, 0.18, 3.06, 3.80, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.3.b.2', 'IM', 1.90, 29, 0.29, 1.31, 2.49, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.3.b.2', 'LV', 1.57, 29, 0.45, 0.66, 2.49, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.3.b.4', 'IM', 1.89, 29, 0.29, 1.29, 2.50, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.3.b.4', 'LV', 1.91, 29, 0.74, 0.40, 3.43, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.3.b.5', 'IM', 1.83, 29, 0.29, 1.23, 2.43, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.3.b.5', 'LV', 1.27, 29, 0.44, 0.36, 2.18, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.3.b.6', 'IM', 3.72, 29, 0.20, 3.31, 4.13, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.3.b.6', 'LV', 3.42, 29, 0.27, 2.87, 3.98, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.a.1', 'IM', 3.10, 29, 0.31, 2.47, 3.74, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.a.1', 'LV', 3.14, 29, 0.25, 2.62, 3.66, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.a.2', 'IM', 4.43, 29, 0.14, 4.15, 4.72, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.a.2', 'LV', 4.99, 29, 0.25, 4.48, 5.51, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.a.3', 'IM', 4.14, 29, 0.26, 3.61, 4.67, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.a.3', 'LV', 4.93, 29, 0.26, 4.40, 5.46, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.a.4', 'IM', 3.73, 29, 0.39, 2.93, 4.54, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.a.4', 'LV', 4.59, 29, 0.57, 3.43, 5.76, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.a.5', 'IM', 2.89, 29, 0.18, 2.53, 3.26, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.a.5', 'LV', 3.47, 29, 0.32, 2.82, 4.12, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.a.6', 'IM', 3.22, 28, 0.27, 2.67, 3.77, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.a.6', 'LV', 3.53, 29, 0.26, 2.99, 4.07, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.a.7', 'IM', 3.50, 29, 0.20, 3.10, 3.91, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.a.7', 'LV', 4.92, 29, 0.30, 4.30, 5.54, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.a.8', 'IM', 3.24, 29, 0.35, 2.53, 3.95, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.a.8', 'LV', 3.69, 28, 0.56, 2.53, 4.84, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.b.1', 'IM', 4.03, 29, 0.20, 3.62, 4.44, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.b.1', 'LV', 4.82, 29, 0.29, 4.23, 5.41, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.b.2', 'IM', 3.86, 29, 0.18, 3.49, 4.24, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.b.2', 'LV', 4.04, 29, 0.16, 3.72, 4.37, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.b.3', 'IM', 3.72, 29, 0.20, 3.31, 4.14, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.b.3', 'LV', 4.30, 29, 0.32, 3.65, 4.95, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.b.4', 'IM', 3.91, 29, 0.24, 3.42, 4.39, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.b.4', 'LV', 4.95, 28, 0.46, 4.02, 5.89, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.b.5', 'IM', 3.66, 29, 0.22, 3.20, 4.12, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.b.5', 'LV', 4.38, 29, 0.37, 3.63, 5.13, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.b.6', 'IM', 3.03, 29, 0.17, 2.69, 3.37, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.b.6', 'LV', 3.87, 29, 0.43, 2.98, 4.75, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.c.1', 'IM', 3.30, 29, 0.22, 2.84, 3.75, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.c.1', 'LV', 3.47, 29, 0.29, 2.88, 4.06, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.c.2', 'IM', 3.00, 29, 0.28, 2.42, 3.57, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.c.2', 'LV', 3.69, 29, 0.53, 2.61, 4.77, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.c.3', 'IM', 3.78, 29, 0.17, 3.43, 4.13, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '4.A.4.c.3', 'LV', 4.47, 29, 0.30, 3.84, 5.09, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.1.a.1', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.1.a.1', 'LV', 4.08, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.1.a.2', 'IM', 3.29, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.1.a.2', 'LV', 3.46, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.1.b.1', 'IM', 3.25, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.1.b.1', 'LV', 3.33, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.1.b.2', 'IM', 2.75, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.1.b.2', 'LV', 2.75, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.1.b.3', 'IM', 2.57, 23, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.1.b.3', 'LV', 2.52, 23, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.a.1', 'IM', 3.21, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.a.1', 'LV', 3.50, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.a.2', 'IM', 3.46, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.a.2', 'LV', 3.62, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.a.3', 'IM', 3.33, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.a.3', 'LV', 3.42, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.a.4', 'IM', 3.46, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.a.4', 'LV', 3.58, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.b.1', 'IM', 3.92, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.b.1', 'LV', 4.17, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.b.2', 'IM', 2.92, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.b.2', 'LV', 3.46, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.b.3', 'IM', 3.12, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.b.3', 'LV', 3.88, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.b.4', 'IM', 3.04, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.b.4', 'LV', 3.08, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.b.5', 'IM', 3.42, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.b.5', 'LV', 4.25, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.b.6', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.2.b.6', 'LV', 4.92, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.3.a.1', 'IM', 2.50, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.3.a.1', 'LV', 2.62, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.3.a.2', 'IM', 2.38, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.3.a.2', 'LV', 2.92, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.3.a.3', 'IM', 2.21, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.3.a.3', 'LV', 1.96, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.3.a.4', 'IM', 2.75, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.3.a.4', 'LV', 2.21, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.3.b.1', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.3.b.1', 'LV', 3.29, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.3.b.2', 'IM', 1.42, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.3.b.2', 'LV', 0.92, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.3.b.4', 'IM', 1.67, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.3.b.4', 'LV', 1.33, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.3.b.5', 'IM', 1.33, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.3.b.5', 'LV', 0.71, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.3.b.6', 'IM', 3.21, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.3.b.6', 'LV', 3.25, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.a.1', 'IM', 2.92, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.a.1', 'LV', 2.46, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.a.2', 'IM', 4.29, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.a.2', 'LV', 4.50, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.a.3', 'IM', 3.25, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.a.3', 'LV', 3.43, 23, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.a.4', 'IM', 3.91, 23, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.a.4', 'LV', 4.83, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.a.5', 'IM', 2.25, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.a.5', 'LV', 2.33, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.a.6', 'IM', 2.08, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.a.6', 'LV', 1.88, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.a.7', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.a.7', 'LV', 4.62, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.a.8', 'IM', 1.71, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.a.8', 'LV', 1.42, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.b.1', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.b.1', 'LV', 4.54, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.b.2', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.b.2', 'LV', 4.08, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.b.3', 'IM', 3.38, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.b.3', 'LV', 3.50, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.b.4', 'IM', 3.88, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.b.4', 'LV', 4.88, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.b.5', 'IM', 3.67, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.b.5', 'LV', 4.48, 23, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.b.6', 'IM', 2.96, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.b.6', 'LV', 3.67, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.c.1', 'IM', 3.12, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.c.1', 'LV', 3.12, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.c.2', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.c.2', 'LV', 3.75, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.c.3', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '4.A.4.c.3', 'LV', 4.35, 23, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.1.a.1', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.1.a.1', 'LV', 4.78, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.1.a.2', 'IM', 3.70, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.1.a.2', 'LV', 4.17, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.1.b.1', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.1.b.1', 'LV', 4.35, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.1.b.2', 'IM', 2.48, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.1.b.2', 'LV', 2.61, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.1.b.3', 'IM', 3.52, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.1.b.3', 'LV', 3.43, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.a.1', 'IM', 3.43, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.a.1', 'LV', 4.09, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.a.2', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.a.2', 'LV', 4.39, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.a.3', 'IM', 3.65, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.a.3', 'LV', 3.91, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.a.4', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.a.4', 'LV', 4.52, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.b.1', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.b.1', 'LV', 4.87, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.b.2', 'IM', 3.48, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.b.2', 'LV', 4.30, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.b.3', 'IM', 3.91, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.b.3', 'LV', 4.52, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.b.4', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.b.4', 'LV', 4.26, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.b.5', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.b.5', 'LV', 4.70, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.b.6', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.2.b.6', 'LV', 5.30, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.3.a.1', 'IM', 1.87, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.3.a.1', 'LV', 1.57, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.3.a.2', 'IM', 1.82, 22, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.3.a.2', 'LV', 2.27, 22, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.3.a.3', 'IM', 1.82, 22, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.3.a.3', 'LV', 1.50, 22, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.3.a.4', 'IM', 1.64, 22, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.3.a.4', 'LV', 1.09, 22, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.3.b.1', 'IM', 4.27, 22, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.3.b.1', 'LV', 3.59, 22, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.3.b.2', 'IM', 1.96, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.3.b.2', 'LV', 2.30, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.3.b.4', 'IM', 1.39, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.3.b.4', 'LV', 1.00, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.3.b.5', 'IM', 1.65, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.3.b.5', 'LV', 1.17, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.3.b.6', 'IM', 3.57, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.3.b.6', 'LV', 3.87, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.a.1', 'IM', 3.39, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.a.1', 'LV', 3.48, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.a.2', 'IM', 4.30, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.a.2', 'LV', 4.74, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.a.3', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.a.3', 'LV', 4.09, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.a.4', 'IM', 4.22, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.a.4', 'LV', 5.13, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.a.5', 'IM', 2.57, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.a.5', 'LV', 2.70, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.a.6', 'IM', 3.13, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.a.6', 'LV', 3.48, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.a.7', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.a.7', 'LV', 4.78, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.a.8', 'IM', 2.00, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.a.8', 'LV', 1.87, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.b.1', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.b.1', 'LV', 4.74, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.b.2', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.b.2', 'LV', 4.30, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.b.3', 'IM', 3.65, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.b.3', 'LV', 3.78, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.b.4', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.b.4', 'LV', 4.96, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.b.5', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.b.5', 'LV', 4.70, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.b.6', 'IM', 3.35, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.b.6', 'LV', 4.74, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.c.1', 'IM', 3.30, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.c.1', 'LV', 3.74, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.c.2', 'IM', 3.39, 23, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.c.2', 'LV', 4.13, 23, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.c.3', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, NULL, '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '4.A.4.c.3', 'LV', 4.50, 22, NULL, NULL, NULL, NULL, 'N', '2011-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.a.1', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.a.1', 'LV', 5.24, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.a.2', 'IM', 3.10, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.a.2', 'LV', 3.62, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.b.1', 'IM', 3.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.b.1', 'LV', 4.33, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.b.2', 'IM', 1.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.b.2', 'LV', 1.10, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.b.3', 'IM', 2.38, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.1.b.3', 'LV', 2.62, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.a.1', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.a.1', 'LV', 4.14, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.a.2', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.a.2', 'LV', 4.95, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.a.3', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.a.3', 'LV', 4.62, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.a.4', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.a.4', 'LV', 4.95, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.1', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.1', 'LV', 4.90, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.2', 'IM', 3.19, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.2', 'LV', 4.10, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.3', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.3', 'LV', 5.05, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.4', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.4', 'LV', 3.90, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.5', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.5', 'LV', 4.43, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.6', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.2.b.6', 'LV', 5.29, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.a.1', 'IM', 1.19, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.a.1', 'LV', 0.33, 21, NULL, NULL, NULL, NULL, 'Y', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.a.2', 'IM', 1.24, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.a.2', 'LV', 0.62, 21, NULL, NULL, NULL, NULL, 'Y', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.a.3', 'IM', 1.14, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.a.3', 'LV', 0.33, 21, NULL, NULL, NULL, NULL, 'Y', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.a.4', 'IM', 1.14, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.a.4', 'LV', 0.29, 21, NULL, NULL, NULL, NULL, 'Y', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.1', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.1', 'LV', 3.48, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.2', 'IM', 1.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.2', 'LV', 0.00, 21, NULL, NULL, NULL, NULL, 'Y', '2008-06-01', 'Occupational Expert');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.4', 'IM', 1.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.4', 'LV', 0.00, 21, NULL, NULL, NULL, NULL, 'Y', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.5', 'IM', 1.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.5', 'LV', 0.05, 21, NULL, NULL, NULL, NULL, 'Y', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.6', 'IM', 3.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.3.b.6', 'LV', 3.38, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.1', 'IM', 3.75, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.1', 'LV', 3.75, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.2', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.2', 'LV', 5.43, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.3', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.3', 'LV', 4.29, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.4', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.4', 'LV', 5.33, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.5', 'IM', 2.24, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.5', 'LV', 2.38, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.6', 'IM', 2.86, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.6', 'LV', 3.29, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.7', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.7', 'LV', 5.00, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.8', 'IM', 1.67, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.a.8', 'LV', 1.14, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.1', 'IM', 3.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.1', 'LV', 3.95, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.2', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.2', 'LV', 3.67, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.3', 'IM', 2.81, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.3', 'LV', 3.62, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.4', 'IM', 3.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.4', 'LV', 4.19, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.5', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.5', 'LV', 4.71, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.6', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.b.6', 'LV', 4.52, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.c.1', 'IM', 2.90, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.c.1', 'LV', 4.05, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.c.2', 'IM', 2.48, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.c.2', 'LV', 2.52, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.c.3', 'IM', 3.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '4.A.4.c.3', 'LV', 4.52, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.a.1', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.a.1', 'LV', 4.86, 22, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.a.2', 'IM', 3.09, 22, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.a.2', 'LV', 3.68, 22, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.b.1', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.b.1', 'LV', 4.45, 22, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.b.2', 'IM', 1.50, 22, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.b.2', 'LV', 0.82, 22, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.b.3', 'IM', 2.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.1.b.3', 'LV', 2.76, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.a.1', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.a.1', 'LV', 4.77, 22, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.a.2', 'IM', 3.64, 22, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.a.2', 'LV', 4.52, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.a.3', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.a.3', 'LV', 5.00, 22, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.a.4', 'IM', 3.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.a.4', 'LV', 4.29, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.1', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.1', 'LV', 5.25, 20, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.2', 'IM', 3.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.2', 'LV', 4.33, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.3', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.3', 'LV', 5.00, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.4', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.4', 'LV', 4.19, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.5', 'IM', 3.10, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.5', 'LV', 4.10, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.6', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.2.b.6', 'LV', 5.14, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.a.1', 'IM', 1.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.a.1', 'LV', 1.05, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.a.2', 'IM', 1.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.a.2', 'LV', 1.33, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.a.3', 'IM', 1.38, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.a.3', 'LV', 0.86, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.a.4', 'IM', 1.24, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.a.4', 'LV', 0.38, 21, NULL, NULL, NULL, NULL, 'Y', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.1', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.1', 'LV', 3.33, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.2', 'IM', 1.24, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.2', 'LV', 0.57, 21, NULL, NULL, NULL, NULL, 'Y', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.4', 'IM', 1.05, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.4', 'LV', 0.10, 21, NULL, NULL, NULL, NULL, 'Y', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.5', 'IM', 1.19, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.5', 'LV', 0.33, 21, NULL, NULL, NULL, NULL, 'Y', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.6', 'IM', 3.57, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.3.b.6', 'LV', 3.67, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.1', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.1', 'LV', 3.95, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.2', 'IM', 4.81, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.2', 'LV', 5.62, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.3', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.3', 'LV', 4.81, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.4', 'IM', 4.67, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.4', 'LV', 5.86, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.5', 'IM', 3.19, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.5', 'LV', 3.90, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.6', 'IM', 3.10, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.6', 'LV', 3.67, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.7', 'IM', 4.71, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.7', 'LV', 6.24, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.8', 'IM', 2.67, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.a.8', 'LV', 3.05, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.1', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.1', 'LV', 4.71, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.2', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.2', 'LV', 4.57, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.3', 'IM', 3.33, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.3', 'LV', 4.29, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.4', 'IM', 3.52, 21, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.4', 'LV', 4.52, 21, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.5', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.5', 'LV', 4.86, 22, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.6', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.b.6', 'LV', 5.32, 22, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.c.1', 'IM', 3.05, 22, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.c.1', 'LV', 4.14, 22, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.c.2', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.c.2', 'LV', 5.05, 22, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.c.3', 'IM', 3.18, 22, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '4.A.4.c.3', 'LV', 3.91, 22, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.a.1', 'IM', 4.33, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.a.1', 'LV', 5.00, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.a.2', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.a.2', 'LV', 4.21, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.b.1', 'IM', 3.50, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.b.1', 'LV', 4.46, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.b.2', 'IM', 2.50, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.b.2', 'LV', 2.25, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.b.3', 'IM', 3.12, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.1.b.3', 'LV', 3.04, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.a.1', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.a.1', 'LV', 4.21, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.a.2', 'IM', 3.42, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.a.2', 'LV', 3.79, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.a.3', 'IM', 3.67, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.a.3', 'LV', 4.00, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.a.4', 'IM', 3.58, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.a.4', 'LV', 4.12, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.1', 'IM', 4.29, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.1', 'LV', 5.25, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.2', 'IM', 4.17, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.2', 'LV', 4.88, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.3', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.3', 'LV', 5.17, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.4', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.4', 'LV', 4.21, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.5', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.5', 'LV', 4.79, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.6', 'IM', 4.58, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.2.b.6', 'LV', 6.04, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.a.1', 'IM', 1.88, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.a.1', 'LV', 1.67, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.a.2', 'IM', 2.21, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.a.2', 'LV', 2.92, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.a.3', 'IM', 2.04, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.a.3', 'LV', 1.92, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.a.4', 'IM', 1.71, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.a.4', 'LV', 1.00, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.1', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.1', 'LV', 3.25, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.2', 'IM', 1.54, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.2', 'LV', 1.17, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.4', 'IM', 1.33, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.4', 'LV', 0.71, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.5', 'IM', 1.33, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.5', 'LV', 0.62, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.6', 'IM', 3.42, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.3.b.6', 'LV', 3.38, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.1', 'IM', 3.62, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.1', 'LV', 3.78, 23, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.2', 'IM', 4.67, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.2', 'LV', 5.71, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.3', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.3', 'LV', 4.92, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.4', 'IM', 4.58, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.4', 'LV', 5.42, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.5', 'IM', 2.62, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.5', 'LV', 3.21, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.6', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.6', 'LV', 3.75, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.7', 'IM', 3.58, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.7', 'LV', 4.79, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.8', 'IM', 2.33, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.a.8', 'LV', 2.38, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.1', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.1', 'LV', 4.61, 23, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.2', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.2', 'LV', 4.45, 22, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.3', 'IM', 4.74, 23, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.3', 'LV', 5.78, 23, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.4', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.4', 'LV', 4.87, 23, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.5', 'IM', 4.25, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.5', 'LV', 5.25, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.6', 'IM', 3.88, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.b.6', 'LV', 5.08, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.c.1', 'IM', 3.12, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.c.1', 'LV', 3.42, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.c.2', 'IM', 3.38, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.c.2', 'LV', 4.12, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.c.3', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '4.A.4.c.3', 'LV', 4.58, 24, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.1.a.1', 'IM', 4.47, 20, 0.16, 4.13, 4.81, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.1.a.1', 'LV', 4.68, 20, 0.32, 4.01, 5.35, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.1.a.2', 'IM', 4.19, 20, 0.22, 3.74, 4.65, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.1.a.2', 'LV', 5.43, 19, 0.45, 4.49, 6.37, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.1.b.1', 'IM', 4.25, 20, 0.22, 3.78, 4.72, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.1.b.1', 'LV', 4.31, 20, 0.54, 3.18, 5.45, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.1.b.2', 'IM', 3.96, 20, 0.31, 3.31, 4.60, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.1.b.2', 'LV', 4.10, 19, 0.44, 3.18, 5.03, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.1.b.3', 'IM', 3.73, 20, 0.39, 2.91, 4.56, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.1.b.3', 'LV', 3.76, 19, 0.89, 1.88, 5.64, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.a.1', 'IM', 4.16, 20, 0.22, 3.71, 4.62, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.a.1', 'LV', 4.57, 19, 0.52, 3.48, 5.67, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.a.2', 'IM', 3.47, 20, 0.38, 2.68, 4.27, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.a.2', 'LV', 4.31, 19, 0.68, 2.88, 5.73, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.a.3', 'IM', 3.92, 20, 0.33, 3.24, 4.60, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.a.3', 'LV', 3.57, 20, 0.49, 2.54, 4.59, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.a.4', 'IM', 4.03, 20, 0.31, 3.39, 4.67, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.a.4', 'LV', 4.35, 19, 0.53, 3.23, 5.46, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.b.1', 'IM', 4.73, 20, 0.12, 4.47, 4.99, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.b.1', 'LV', 5.21, 19, 0.29, 4.59, 5.82, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.b.2', 'IM', 4.33, 20, 0.22, 3.87, 4.80, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.b.2', 'LV', 5.10, 19, 0.41, 4.24, 5.96, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.b.3', 'IM', 3.86, 20, 0.25, 3.33, 4.39, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.b.3', 'LV', 4.92, 19, 0.31, 4.26, 5.58, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.b.4', 'IM', 3.65, 20, 0.28, 3.07, 4.23, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.b.4', 'LV', 4.11, 19, 0.55, 2.95, 5.27, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.b.5', 'IM', 4.30, 20, 0.22, 3.84, 4.75, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.b.5', 'LV', 4.38, 19, 0.22, 3.92, 4.83, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.b.6', 'IM', 4.30, 20, 0.22, 3.85, 4.76, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.2.b.6', 'LV', 4.95, 20, 0.47, 3.97, 5.93, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.3.a.1', 'IM', 2.94, 20, 0.25, 2.42, 3.47, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.3.a.1', 'LV', 3.45, 20, 0.41, 2.58, 4.32, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.3.a.2', 'IM', 3.26, 20, 0.38, 2.47, 4.04, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.3.a.2', 'LV', 4.63, 19, 0.52, 3.53, 5.72, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.3.a.3', 'IM', 3.26, 20, 0.37, 2.48, 4.04, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.3.a.3', 'LV', 4.59, 19, 0.56, 3.42, 5.75, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.3.a.4', 'IM', 3.29, 20, 0.37, 2.52, 4.06, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.3.a.4', 'LV', 3.32, 20, 0.45, 2.37, 4.27, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.3.b.1', 'IM', 3.08, 20, 0.44, 2.17, 4.00, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.3.b.1', 'LV', 2.78, 20, 0.49, 1.76, 3.80, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.3.b.2', 'IM', 2.07, 20, 0.43, 1.17, 2.97, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.3.b.2', 'LV', 1.59, 20, 0.63, 0.28, 2.90, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.3.b.4', 'IM', 2.80, 20, 0.52, 1.71, 3.90, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.3.b.4', 'LV', 2.72, 20, 0.81, 1.02, 4.43, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.3.b.5', 'IM', 2.19, 20, 0.41, 1.34, 3.04, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.3.b.5', 'LV', 1.83, 20, 0.62, 0.54, 3.13, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.3.b.6', 'IM', 3.65, 20, 0.47, 2.66, 4.65, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.3.b.6', 'LV', 3.48, 20, 0.53, 2.38, 4.59, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.a.1', 'IM', 3.72, 20, 0.35, 2.98, 4.46, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.a.1', 'LV', 3.41, 19, 0.39, 2.59, 4.22, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.a.2', 'IM', 4.52, 20, 0.15, 4.22, 4.83, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.a.2', 'LV', 4.38, 19, 0.17, 4.02, 4.75, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.a.3', 'IM', 3.71, 20, 0.41, 2.85, 4.58, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.a.3', 'LV', 3.33, 20, 0.39, 2.52, 4.14, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.a.4', 'IM', 4.11, 20, 0.32, 3.45, 4.77, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.a.4', 'LV', 4.78, 20, 0.45, 3.84, 5.71, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.a.5', 'IM', 3.09, 20, 0.53, 1.99, 4.19, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.a.5', 'LV', 3.16, 19, 0.43, 2.25, 4.07, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.a.6', 'IM', 3.83, 20, 0.17, 3.46, 4.19, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.a.6', 'LV', 4.06, 19, 0.45, 3.11, 5.02, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.a.7', 'IM', 3.71, 20, 0.16, 3.38, 4.05, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.a.7', 'LV', 4.68, 19, 0.26, 4.14, 5.23, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.a.8', 'IM', 2.50, 20, 0.17, 2.14, 2.85, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.a.8', 'LV', 3.75, 19, 0.35, 3.02, 4.49, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.b.1', 'IM', 4.31, 20, 0.23, 3.84, 4.79, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.b.1', 'LV', 5.23, 19, 0.43, 4.32, 6.13, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.b.2', 'IM', 3.77, 20, 0.40, 2.93, 4.61, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.b.2', 'LV', 4.04, 20, 0.61, 2.76, 5.32, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.b.3', 'IM', 3.99, 20, 0.28, 3.42, 4.57, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.b.3', 'LV', 4.15, 20, 0.55, 3.00, 5.29, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.b.4', 'IM', 4.32, 20, 0.25, 3.79, 4.85, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.b.4', 'LV', 5.19, 19, 0.25, 4.68, 5.71, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.b.5', 'IM', 4.13, 20, 0.23, 3.64, 4.63, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.b.5', 'LV', 4.56, 20, 0.61, 3.28, 5.84, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.b.6', 'IM', 2.87, 20, 0.25, 2.35, 3.38, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.b.6', 'LV', 4.39, 20, 0.48, 3.39, 5.39, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.c.1', 'IM', 3.27, 20, 0.37, 2.50, 4.04, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.c.1', 'LV', 3.19, 20, 0.47, 2.22, 4.17, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.c.2', 'IM', 3.87, 20, 0.38, 3.07, 4.67, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.c.2', 'LV', 4.57, 19, 0.44, 3.65, 5.49, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.c.3', 'IM', 3.86, 20, 0.40, 3.02, 4.70, 'N', NULL, '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '4.A.4.c.3', 'LV', 4.57, 19, 0.31, 3.92, 5.21, 'N', 'N', '2007-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.1.a.1', 'IM', 3.52, 23, 0.36, 2.76, 4.27, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.1.a.1', 'LV', 4.29, 23, 0.17, 3.94, 4.64, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.1.a.2', 'IM', 3.46, 23, 0.41, 2.61, 4.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.1.a.2', 'LV', 4.20, 23, 0.85, 2.43, 5.97, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.1.b.1', 'IM', 3.50, 23, 0.43, 2.61, 4.38, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.1.b.1', 'LV', 3.65, 23, 0.67, 2.27, 5.04, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.1.b.2', 'IM', 3.77, 23, 0.39, 2.97, 4.58, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.1.b.2', 'LV', 3.33, 23, 0.78, 1.72, 4.94, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.1.b.3', 'IM', 3.35, 22, 0.32, 2.69, 4.01, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.1.b.3', 'LV', 2.94, 23, 0.34, 2.24, 3.63, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.a.1', 'IM', 2.81, 23, 0.50, 1.77, 3.85, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.a.1', 'LV', 3.00, 23, 0.72, 1.50, 4.50, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.a.2', 'IM', 3.31, 23, 0.39, 2.49, 4.12, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.a.2', 'LV', 3.99, 23, 0.32, 3.34, 4.65, 'N', 'N', '2014-07-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.a.3', 'IM', 3.19, 23, 0.43, 2.30, 4.08, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.a.3', 'LV', 3.16, 23, 0.60, 1.92, 4.40, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.a.4', 'IM', 3.71, 23, 0.32, 3.05, 4.38, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.a.4', 'LV', 3.92, 23, 0.57, 2.74, 5.09, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.b.1', 'IM', 4.18, 22, 0.23, 3.69, 4.67, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.b.1', 'LV', 4.90, 23, 0.79, 3.26, 6.53, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.b.2', 'IM', 3.48, 23, 0.57, 2.30, 4.67, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.b.2', 'LV', 4.70, 23, 0.73, 3.19, 6.21, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.b.3', 'IM', 3.62, 23, 0.40, 2.80, 4.44, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.b.3', 'LV', 4.65, 23, 0.48, 3.65, 5.65, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.b.4', 'IM', 3.84, 22, 0.38, 3.05, 4.62, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.b.4', 'LV', 4.91, 23, 0.49, 3.89, 5.94, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.b.5', 'IM', 3.24, 22, 0.58, 2.03, 4.46, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.b.5', 'LV', 3.49, 23, 0.84, 1.76, 5.23, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.b.6', 'IM', 4.01, 22, 0.35, 3.28, 4.74, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.2.b.6', 'LV', 5.30, 23, 0.57, 4.12, 6.47, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.3.a.1', 'IM', 3.61, 23, 0.41, 2.75, 4.47, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.3.a.1', 'LV', 4.50, 23, 0.72, 3.01, 5.98, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.3.a.2', 'IM', 3.56, 23, 0.46, 2.60, 4.52, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.3.a.2', 'LV', 4.43, 23, 0.84, 2.69, 6.17, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.3.a.3', 'IM', 3.69, 23, 0.50, 2.65, 4.74, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.3.a.3', 'LV', 4.13, 23, 0.77, 2.53, 5.73, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.3.a.4', 'IM', 3.96, 23, 0.44, 3.05, 4.86, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.3.a.4', 'LV', 4.59, 23, 0.53, 3.50, 5.68, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.3.b.1', 'IM', 2.64, 23, 0.46, 1.68, 3.60, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.3.b.1', 'LV', 2.38, 23, 0.53, 1.29, 3.46, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.3.b.2', 'IM', 2.14, 23, 0.35, 1.41, 2.86, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.3.b.2', 'LV', 2.21, 23, 0.68, 0.80, 3.62, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.3.b.4', 'IM', 3.42, 23, 0.65, 2.07, 4.76, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.3.b.4', 'LV', 4.27, 23, 1.14, 1.91, 6.63, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.3.b.5', 'IM', 3.50, 23, 0.28, 2.91, 4.08, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.3.b.5', 'LV', 3.67, 23, 0.45, 2.73, 4.60, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.3.b.6', 'IM', 3.43, 23, 0.64, 2.11, 4.75, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.3.b.6', 'LV', 3.32, 23, 0.92, 1.40, 5.23, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.a.1', 'IM', 3.05, 23, 0.41, 2.19, 3.91, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.a.1', 'LV', 2.70, 23, 0.43, 1.80, 3.60, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.a.2', 'IM', 3.49, 23, 0.45, 2.56, 4.43, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.a.2', 'LV', 3.82, 23, 0.53, 2.72, 4.92, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.a.3', 'IM', 3.53, 23, 0.28, 2.94, 4.11, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.a.3', 'LV', 3.69, 23, 0.41, 2.84, 4.54, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.a.4', 'IM', 3.34, 23, 0.33, 2.66, 4.03, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.a.4', 'LV', 3.87, 23, 0.53, 2.78, 4.96, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.a.5', 'IM', 2.60, 23, 0.49, 1.58, 3.63, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.a.5', 'LV', 2.65, 23, 0.86, 0.86, 4.43, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.a.6', 'IM', 2.84, 23, 0.46, 1.90, 3.79, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.a.6', 'LV', 2.78, 23, 0.69, 1.35, 4.22, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.a.7', 'IM', 2.85, 23, 0.35, 2.12, 3.57, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.a.7', 'LV', 3.21, 23, 0.61, 1.95, 4.46, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.a.8', 'IM', 2.93, 22, 0.59, 1.70, 4.15, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.a.8', 'LV', 2.73, 23, 0.67, 1.34, 4.12, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.b.1', 'IM', 3.09, 23, 0.56, 1.94, 4.24, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.b.1', 'LV', 2.96, 23, 0.80, 1.31, 4.62, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.b.2', 'IM', 2.37, 23, 0.43, 1.46, 3.27, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.b.2', 'LV', 1.88, 23, 0.59, 0.66, 3.11, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.b.3', 'IM', 2.79, 23, 0.50, 1.75, 3.83, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.b.3', 'LV', 2.68, 23, 0.68, 1.27, 4.09, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.b.4', 'IM', 2.57, 23, 0.36, 1.83, 3.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.b.4', 'LV', 2.58, 22, 0.51, 1.53, 3.64, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.b.5', 'IM', 2.54, 23, 0.52, 1.47, 3.62, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.b.5', 'LV', 2.47, 23, 0.80, 0.81, 4.13, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.b.6', 'IM', 2.32, 23, 0.54, 1.21, 3.44, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.b.6', 'LV', 2.09, 23, 0.73, 0.57, 3.60, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.c.1', 'IM', 3.27, 23, 0.62, 1.98, 4.56, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.c.1', 'LV', 3.19, 23, 0.74, 1.65, 4.73, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.c.2', 'IM', 2.34, 23, 0.39, 1.52, 3.15, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.c.2', 'LV', 2.01, 23, 0.55, 0.86, 3.15, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.c.3', 'IM', 3.84, 23, 0.49, 2.82, 4.87, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '4.A.4.c.3', 'LV', 5.11, 23, 0.49, 4.10, 6.12, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.1.a.1', 'IM', 4.06, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.1.a.1', 'LV', 4.94, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.1.a.2', 'IM', 3.97, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.1.a.2', 'LV', 5.16, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.1.b.1', 'IM', 3.90, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.1.b.1', 'LV', 4.97, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.1.b.2', 'IM', 3.77, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.1.b.2', 'LV', 4.32, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.1.b.3', 'IM', 3.93, 30, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.1.b.3', 'LV', 3.83, 30, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.a.1', 'IM', 3.60, 30, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.a.1', 'LV', 4.17, 30, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.a.2', 'IM', 3.90, 30, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.a.2', 'LV', 4.73, 30, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.a.3', 'IM', 3.50, 30, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.a.3', 'LV', 3.87, 30, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.a.4', 'IM', 4.00, 30, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.a.4', 'LV', 4.60, 30, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.b.1', 'IM', 4.30, 30, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.b.1', 'LV', 5.20, 30, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.b.2', 'IM', 3.97, 30, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.b.2', 'LV', 4.70, 30, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.b.3', 'IM', 3.97, 30, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.b.3', 'LV', 5.13, 30, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.b.4', 'IM', 3.77, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.b.4', 'LV', 4.48, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.b.5', 'IM', 3.84, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.b.5', 'LV', 4.74, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.b.6', 'IM', 3.97, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.2.b.6', 'LV', 5.13, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.3.a.1', 'IM', 3.39, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.3.a.1', 'LV', 4.39, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.3.a.2', 'IM', 3.13, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.3.a.2', 'LV', 4.77, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.3.a.3', 'IM', 3.29, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.3.a.3', 'LV', 3.84, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.3.a.4', 'IM', 3.29, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.3.a.4', 'LV', 3.00, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.3.b.1', 'IM', 3.71, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.3.b.1', 'LV', 3.65, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.3.b.2', 'IM', 3.10, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.3.b.2', 'LV', 3.90, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.3.b.4', 'IM', 3.32, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.3.b.4', 'LV', 4.29, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.3.b.5', 'IM', 3.06, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.3.b.5', 'LV', 3.77, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.3.b.6', 'IM', 3.84, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.3.b.6', 'LV', 3.74, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.a.1', 'IM', 3.45, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.a.1', 'LV', 3.71, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.a.2', 'IM', 4.26, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.a.2', 'LV', 4.90, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.a.3', 'IM', 3.87, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.a.3', 'LV', 4.71, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.a.4', 'IM', 4.03, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.a.4', 'LV', 5.03, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.a.5', 'IM', 2.68, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.a.5', 'LV', 3.23, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.a.6', 'IM', 3.42, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.a.6', 'LV', 4.10, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.a.7', 'IM', 3.55, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.a.7', 'LV', 4.94, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.a.8', 'IM', 3.29, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.a.8', 'LV', 4.16, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.b.1', 'IM', 4.06, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.b.1', 'LV', 5.10, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.b.2', 'IM', 3.65, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.b.2', 'LV', 3.94, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.b.3', 'IM', 3.45, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.b.3', 'LV', 3.97, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.b.4', 'IM', 3.87, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.b.4', 'LV', 4.61, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.b.5', 'IM', 3.48, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.b.5', 'LV', 4.45, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.b.6', 'IM', 3.29, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.b.6', 'LV', 4.77, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.c.1', 'IM', 3.58, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.c.1', 'LV', 4.29, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.c.2', 'IM', 3.32, 31, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.c.2', 'LV', 4.19, 31, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.c.3', 'IM', 4.20, 30, NULL, NULL, NULL, NULL, NULL, '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '4.A.4.c.3', 'LV', 5.00, 30, NULL, NULL, NULL, NULL, 'N', '2006-12-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.a.1', 'IM', 4.20, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.a.1', 'LV', 5.04, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.a.2', 'IM', 3.80, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.a.2', 'LV', 4.52, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.b.1', 'IM', 3.88, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.b.1', 'LV', 4.16, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.b.2', 'IM', 3.92, 24, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.b.2', 'LV', 4.64, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.b.3', 'IM', 3.80, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.1.b.3', 'LV', 3.88, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.a.1', 'IM', 3.40, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.a.1', 'LV', 4.04, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.a.2', 'IM', 3.60, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.a.2', 'LV', 4.44, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.a.3', 'IM', 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.a.3', 'LV', 4.28, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.a.4', 'IM', 3.72, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.a.4', 'LV', 4.44, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.1', 'IM', 4.60, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.1', 'LV', 5.12, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.2', 'IM', 3.44, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.2', 'LV', 4.12, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.3', 'IM', 3.76, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.3', 'LV', 4.80, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.4', 'IM', 3.56, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.4', 'LV', 4.20, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.5', 'IM', 4.24, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.5', 'LV', 5.56, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.6', 'IM', 4.16, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.2.b.6', 'LV', 5.76, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.a.1', 'IM', 2.72, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.a.1', 'LV', 3.04, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.a.2', 'IM', 2.08, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.a.2', 'LV', 2.48, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.a.3', 'IM', 1.76, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.a.3', 'LV', 1.32, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.a.4', 'IM', 2.24, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.a.4', 'LV', 1.72, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.1', 'IM', 4.20, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.1', 'LV', 3.56, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.2', 'IM', 2.84, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.2', 'LV', 3.48, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.4', 'IM', 1.40, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.4', 'LV', 0.84, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.5', 'IM', 1.20, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.5', 'LV', 0.36, 25, NULL, NULL, NULL, NULL, 'Y', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.6', 'IM', 3.92, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.3.b.6', 'LV', 4.52, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.1', 'IM', 4.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.1', 'LV', 4.08, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.2', 'IM', 4.58, 24, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.2', 'LV', 5.12, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.3', 'IM', 4.08, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.3', 'LV', 4.84, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.4', 'IM', 4.04, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.4', 'LV', 5.00, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.5', 'IM', 2.24, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.5', 'LV', 2.36, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.6', 'IM', 3.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.6', 'LV', 3.32, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.7', 'IM', 4.36, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.7', 'LV', 5.80, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.8', 'IM', 3.00, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.a.8', 'LV', 3.64, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.1', 'IM', 3.96, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.1', 'LV', 5.80, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.2', 'IM', 4.08, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.2', 'LV', 5.12, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.3', 'IM', 2.92, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.3', 'LV', 3.60, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.4', 'IM', 3.52, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.4', 'LV', 4.44, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.5', 'IM', 3.28, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.5', 'LV', 4.00, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.6', 'IM', 3.24, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.b.6', 'LV', 4.24, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.c.1', 'IM', 3.48, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.c.1', 'LV', 3.84, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.c.2', 'IM', 2.64, 25, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.c.2', 'LV', 3.16, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.c.3', 'IM', 3.29, 24, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '4.A.4.c.3', 'LV', 3.84, 25, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.a.1', 'IM', 4.08, 24, 0.29, 3.48, 4.67, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.a.1', 'LV', 3.49, 24, 0.36, 2.75, 4.23, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.a.2', 'IM', 3.13, 23, 0.36, 2.38, 3.87, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.a.2', 'LV', 3.26, 23, 0.56, 2.11, 4.42, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.b.1', 'IM', 3.37, 24, 0.29, 2.76, 3.97, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.b.1', 'LV', 3.43, 23, 0.46, 2.46, 4.39, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.b.2', 'IM', 3.20, 24, 0.39, 2.39, 4.01, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.b.2', 'LV', 2.02, 24, 0.34, 1.30, 2.73, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.b.3', 'IM', 2.21, 23, 0.28, 1.62, 2.80, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.1.b.3', 'LV', 2.06, 23, 0.49, 1.05, 3.07, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.a.1', 'IM', 3.89, 24, 0.26, 3.35, 4.43, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.a.1', 'LV', 3.15, 24, 0.31, 2.51, 3.79, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.a.2', 'IM', 3.92, 24, 0.28, 3.34, 4.51, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.a.2', 'LV', 3.69, 24, 0.40, 2.87, 4.51, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.a.3', 'IM', 4.22, 24, 0.21, 3.79, 4.65, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.a.3', 'LV', 3.39, 24, 0.34, 2.69, 4.09, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.a.4', 'IM', 2.55, 24, 0.24, 2.06, 3.03, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.a.4', 'LV', 2.84, 24, 0.33, 2.16, 3.51, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.1', 'IM', 4.32, 24, 0.20, 3.90, 4.73, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.1', 'LV', 5.06, 24, 0.33, 4.38, 5.74, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.2', 'IM', 3.46, 24, 0.31, 2.83, 4.10, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.2', 'LV', 3.30, 24, 0.51, 2.25, 4.34, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.3', 'IM', 3.42, 23, 0.28, 2.83, 4.00, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.3', 'LV', 4.00, 23, 0.42, 3.13, 4.88, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.4', 'IM', 3.14, 22, 0.33, 2.46, 3.81, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.4', 'LV', 3.27, 22, 0.57, 2.09, 4.45, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.5', 'IM', 3.88, 23, 0.40, 3.05, 4.70, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.5', 'LV', 3.79, 23, 0.53, 2.68, 4.90, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.6', 'IM', 3.71, 23, 0.26, 3.17, 4.25, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.2.b.6', 'LV', 4.99, 23, 0.43, 4.10, 5.89, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.a.1', 'IM', 3.22, 23, 0.38, 2.43, 4.01, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.a.1', 'LV', 2.58, 23, 0.48, 1.57, 3.58, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.a.2', 'IM', 2.44, 24, 0.23, 1.95, 2.92, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.a.2', 'LV', 3.09, 24, 0.52, 2.01, 4.17, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.a.3', 'IM', 1.54, 24, 0.16, 1.20, 1.88, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.a.3', 'LV', 1.04, 24, 0.33, 0.36, 1.72, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.a.4', 'IM', 1.87, 24, 0.35, 1.14, 2.60, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.a.4', 'LV', 1.12, 24, 0.39, 0.30, 1.93, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.1', 'IM', 3.88, 24, 0.22, 3.43, 4.33, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.1', 'LV', 2.83, 24, 0.25, 2.31, 3.35, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.2', 'IM', 1.22, 24, 0.11, 1.00, 1.44, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.2', 'LV', 0.58, 24, 0.27, 0.01, 1.14, 'N', 'Y', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.4', 'IM', 1.52, 24, 0.21, 1.08, 1.96, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.4', 'LV', 0.88, 24, 0.32, 0.22, 1.55, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.5', 'IM', 1.42, 23, 0.15, 1.11, 1.72, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.5', 'LV', 0.86, 23, 0.33, 0.18, 1.55, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.6', 'IM', 3.96, 24, 0.24, 3.47, 4.46, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.3.b.6', 'LV', 2.99, 24, 0.50, 1.96, 4.01, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.1', 'IM', 2.68, 24, 0.25, 2.16, 3.20, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.1', 'LV', 2.28, 22, 0.41, 1.44, 3.13, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.2', 'IM', 4.11, 23, 0.28, 3.53, 4.69, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.2', 'LV', 4.06, 24, 0.48, 3.07, 5.05, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.3', 'IM', 3.35, 24, 0.36, 2.61, 4.09, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.3', 'LV', 3.63, 24, 0.52, 2.56, 4.70, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.4', 'IM', 3.96, 24, 0.21, 3.52, 4.40, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.4', 'LV', 5.29, 24, 0.26, 4.75, 5.82, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.5', 'IM', 4.26, 24, 0.18, 3.88, 4.63, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.5', 'LV', 4.16, 24, 0.40, 3.34, 4.98, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.6', 'IM', 2.21, 24, 0.38, 1.42, 3.00, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.6', 'LV', 1.60, 24, 0.49, 0.59, 2.61, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.7', 'IM', 4.09, 24, 0.26, 3.55, 4.64, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.7', 'LV', 4.48, 24, 0.43, 3.60, 5.36, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.8', 'IM', 4.14, 24, 0.31, 3.50, 4.79, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.a.8', 'LV', 4.81, 23, 0.14, 4.52, 5.10, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.1', 'IM', 4.05, 24, 0.40, 3.23, 4.87, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.1', 'LV', 3.54, 24, 0.49, 2.52, 4.55, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.2', 'IM', 3.58, 24, 0.38, 2.80, 4.37, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.2', 'LV', 2.62, 24, 0.39, 1.81, 3.43, 'N', 'N', '2010-06-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.3', 'IM', 3.73, 24, 0.32, 3.08, 4.39, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.3', 'LV', 3.36, 24, 0.43, 2.47, 4.24, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.4', 'IM', 3.64, 24, 0.31, 2.99, 4.29, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.4', 'LV', 3.43, 24, 0.47, 2.46, 4.40, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.5', 'IM', 3.67, 24, 0.32, 3.01, 4.33, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.5', 'LV', 3.95, 24, 0.48, 2.95, 4.95, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.6', 'IM', 3.09, 24, 0.31, 2.44, 3.74, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.b.6', 'LV', 3.77, 24, 0.64, 2.44, 5.09, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.c.1', 'IM', 4.49, 24, 0.14, 4.20, 4.78, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.c.1', 'LV', 4.23, 24, 0.27, 3.68, 4.79, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.c.2', 'IM', 3.65, 24, 0.36, 2.90, 4.40, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.c.2', 'LV', 3.49, 24, 0.58, 2.29, 4.68, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.c.3', 'IM', 3.20, 24, 0.31, 2.56, 3.84, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '4.A.4.c.3', 'LV', 3.87, 24, 0.55, 2.74, 5.01, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.a.1', 'IM', 4.51, 31, 0.09, 4.32, 4.70, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.a.1', 'LV', 4.78, 30, 0.13, 4.52, 5.04, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.a.2', 'IM', 4.09, 31, 0.20, 3.68, 4.49, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.a.2', 'LV', 5.25, 30, 0.25, 4.75, 5.76, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.b.1', 'IM', 4.18, 31, 0.15, 3.87, 4.49, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.b.1', 'LV', 4.63, 29, 0.36, 3.89, 5.36, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.b.2', 'IM', 3.30, 31, 0.24, 2.82, 3.78, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.b.2', 'LV', 3.64, 31, 0.33, 2.97, 4.31, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.b.3', 'IM', 3.65, 30, 0.23, 3.19, 4.11, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.1.b.3', 'LV', 3.92, 28, 0.39, 3.12, 4.73, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.a.1', 'IM', 4.39, 30, 0.13, 4.13, 4.64, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.a.1', 'LV', 4.96, 29, 0.27, 4.41, 5.50, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.a.2', 'IM', 4.16, 29, 0.20, 3.76, 4.56, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.a.2', 'LV', 5.13, 30, 0.22, 4.67, 5.59, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.a.3', 'IM', 4.22, 30, 0.17, 3.88, 4.56, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.a.3', 'LV', 4.55, 29, 0.26, 4.01, 5.09, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.a.4', 'IM', 4.37, 31, 0.11, 4.14, 4.60, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.a.4', 'LV', 5.30, 30, 0.22, 4.86, 5.74, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.1', 'IM', 4.72, 31, 0.09, 4.54, 4.91, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.1', 'LV', 6.12, 30, 0.19, 5.74, 6.50, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.2', 'IM', 3.93, 31, 0.17, 3.58, 4.29, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.2', 'LV', 4.94, 30, 0.18, 4.57, 5.30, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.3', 'IM', 4.13, 31, 0.14, 3.84, 4.41, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.3', 'LV', 5.32, 30, 0.15, 5.01, 5.64, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.4', 'IM', 4.22, 31, 0.16, 3.90, 4.54, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.4', 'LV', 5.29, 30, 0.35, 4.57, 6.01, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.5', 'IM', 4.31, 31, 0.14, 4.03, 4.59, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.5', 'LV', 5.53, 30, 0.19, 5.14, 5.92, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.6', 'IM', 4.51, 31, 0.14, 4.22, 4.80, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.2.b.6', 'LV', 6.07, 31, 0.12, 5.82, 6.33, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.a.1', 'IM', 2.56, 30, 0.17, 2.22, 2.90, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.a.1', 'LV', 2.77, 29, 0.35, 2.05, 3.48, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.a.2', 'IM', 1.88, 31, 0.22, 1.43, 2.33, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.a.2', 'LV', 2.56, 31, 0.57, 1.40, 3.71, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.a.3', 'IM', 1.60, 31, 0.17, 1.25, 1.95, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.a.3', 'LV', 1.16, 31, 0.29, 0.57, 1.74, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.a.4', 'IM', 1.41, 31, 0.14, 1.14, 1.69, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.a.4', 'LV', 0.73, 31, 0.22, 0.29, 1.17, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.1', 'IM', 4.24, 31, 0.18, 3.88, 4.61, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.1', 'LV', 3.43, 31, 0.24, 2.94, 3.92, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.2', 'IM', 1.70, 31, 0.23, 1.24, 2.17, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.2', 'LV', 1.43, 31, 0.39, 0.62, 2.23, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.4', 'IM', 1.27, 31, 0.12, 1.03, 1.51, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.4', 'LV', 0.47, 31, 0.20, 0.07, 0.87, 'N', 'Y', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.5', 'IM', 1.45, 31, 0.17, 1.10, 1.79, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.5', 'LV', 0.75, 31, 0.27, 0.19, 1.31, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.6', 'IM', 3.63, 31, 0.20, 3.21, 4.05, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.3.b.6', 'LV', 4.02, 30, 0.22, 3.58, 4.47, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.1', 'IM', 4.07, 29, 0.16, 3.75, 4.39, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.1', 'LV', 4.30, 29, 0.22, 3.85, 4.76, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.2', 'IM', 4.73, 30, 0.11, 4.51, 4.95, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.2', 'LV', 5.80, 30, 0.16, 5.47, 6.14, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.3', 'IM', 4.52, 30, 0.14, 4.24, 4.80, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.3', 'LV', 5.48, 31, 0.15, 5.18, 5.78, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.4', 'IM', 4.72, 30, 0.09, 4.54, 4.90, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.4', 'LV', 6.05, 29, 0.14, 5.77, 6.33, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.5', 'IM', 3.47, 29, 0.21, 3.04, 3.91, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.5', 'LV', 4.05, 30, 0.29, 3.46, 4.65, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.6', 'IM', 3.34, 30, 0.29, 2.75, 3.93, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.6', 'LV', 3.89, 30, 0.38, 3.11, 4.67, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.7', 'IM', 4.28, 31, 0.13, 4.02, 4.54, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.7', 'LV', 5.52, 31, 0.17, 5.17, 5.87, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.8', 'IM', 4.11, 31, 0.27, 3.56, 4.66, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.a.8', 'LV', 4.96, 30, 0.37, 4.19, 5.72, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.1', 'IM', 4.35, 30, 0.11, 4.13, 4.57, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.1', 'LV', 5.75, 29, 0.17, 5.40, 6.10, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.2', 'IM', 4.69, 31, 0.09, 4.51, 4.87, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.2', 'LV', 5.39, 31, 0.23, 4.92, 5.85, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.3', 'IM', 4.29, 31, 0.11, 4.05, 4.52, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.3', 'LV', 5.48, 31, 0.15, 5.17, 5.78, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.4', 'IM', 4.59, 31, 0.09, 4.41, 4.77, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.4', 'LV', 5.97, 30, 0.19, 5.59, 6.35, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.5', 'IM', 4.46, 30, 0.13, 4.20, 4.72, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.5', 'LV', 5.71, 30, 0.20, 5.29, 6.12, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.6', 'IM', 3.93, 29, 0.22, 3.48, 4.39, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.b.6', 'LV', 5.50, 30, 0.20, 5.08, 5.92, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.c.1', 'IM', 4.11, 30, 0.17, 3.75, 4.46, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.c.1', 'LV', 5.34, 30, 0.25, 4.82, 5.86, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.c.2', 'IM', 4.08, 30, 0.15, 3.78, 4.39, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.c.2', 'LV', 5.11, 30, 0.19, 4.72, 5.50, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.c.3', 'IM', 3.94, 30, 0.20, 3.54, 4.34, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '4.A.4.c.3', 'LV', 5.06, 30, 0.26, 4.52, 5.60, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.a.1', 'IM', 4.44, 40, 0.10, 4.23, 4.64, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.a.1', 'LV', 5.05, 40, 0.10, 4.84, 5.26, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.a.2', 'IM', 3.59, 40, 0.13, 3.33, 3.84, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.a.2', 'LV', 4.29, 39, 0.23, 3.83, 4.75, 'N', 'N', '2010-06-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.b.1', 'IM', 4.05, 40, 0.10, 3.85, 4.26, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.b.1', 'LV', 4.75, 40, 0.27, 4.21, 5.30, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.b.2', 'IM', 2.01, 40, 0.17, 1.66, 2.36, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.b.2', 'LV', 1.96, 39, 0.40, 1.15, 2.77, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.b.3', 'IM', 3.38, 40, 0.13, 3.11, 3.65, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.1.b.3', 'LV', 3.27, 40, 0.28, 2.70, 3.83, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.a.1', 'IM', 4.21, 40, 0.16, 3.88, 4.54, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.a.1', 'LV', 4.99, 40, 0.16, 4.66, 5.31, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.a.2', 'IM', 4.09, 40, 0.20, 3.68, 4.50, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.a.2', 'LV', 5.25, 39, 0.22, 4.80, 5.70, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.a.3', 'IM', 3.77, 40, 0.19, 3.40, 4.14, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.a.3', 'LV', 4.36, 40, 0.21, 3.94, 4.79, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.a.4', 'IM', 4.01, 40, 0.11, 3.78, 4.23, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.a.4', 'LV', 4.87, 40, 0.17, 4.52, 5.21, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.1', 'IM', 4.54, 39, 0.13, 4.28, 4.80, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.1', 'LV', 5.65, 40, 0.13, 5.40, 5.91, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.2', 'IM', 3.99, 40, 0.17, 3.65, 4.34, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.2', 'LV', 5.01, 40, 0.30, 4.40, 5.62, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.3', 'IM', 3.92, 40, 0.15, 3.61, 4.23, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.3', 'LV', 5.27, 40, 0.28, 4.70, 5.85, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.4', 'IM', 3.96, 40, 0.12, 3.71, 4.21, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.4', 'LV', 4.85, 40, 0.16, 4.52, 5.17, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.5', 'IM', 3.85, 40, 0.18, 3.49, 4.21, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.5', 'LV', 4.99, 40, 0.24, 4.50, 5.49, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.6', 'IM', 4.35, 40, 0.12, 4.11, 4.60, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.2.b.6', 'LV', 6.03, 40, 0.16, 5.71, 6.34, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.a.1', 'IM', 1.81, 40, 0.17, 1.46, 2.16, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.a.1', 'LV', 1.44, 39, 0.24, 0.96, 1.92, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.a.2', 'IM', 1.84, 40, 0.19, 1.47, 2.22, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.a.2', 'LV', 1.90, 40, 0.34, 1.21, 2.59, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.a.3', 'IM', 1.93, 40, 0.25, 1.43, 2.44, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.a.3', 'LV', 1.81, 40, 0.53, 0.74, 2.88, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.a.4', 'IM', 1.35, 40, 0.08, 1.19, 1.51, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.a.4', 'LV', 0.71, 40, 0.18, 0.34, 1.09, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.1', 'IM', 4.30, 40, 0.16, 3.99, 4.62, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.1', 'LV', 3.76, 40, 0.26, 3.24, 4.29, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.2', 'IM', 1.43, 40, 0.12, 1.18, 1.67, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.2', 'LV', 0.98, 40, 0.23, 0.52, 1.44, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.4', 'IM', 1.12, 40, 0.04, 1.04, 1.21, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.4', 'LV', 0.30, 40, 0.11, 0.07, 0.53, 'N', 'Y', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.5', 'IM', 1.60, 40, 0.14, 1.32, 1.87, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.5', 'LV', 1.17, 39, 0.22, 0.73, 1.61, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.6', 'IM', 3.78, 40, 0.27, 3.25, 4.32, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.3.b.6', 'LV', 4.04, 39, 0.27, 3.49, 4.60, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.1', 'IM', 4.00, 40, 0.17, 3.67, 4.34, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.1', 'LV', 4.65, 39, 0.19, 4.26, 5.04, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.2', 'IM', 4.67, 40, 0.07, 4.53, 4.80, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.2', 'LV', 5.94, 40, 0.16, 5.61, 6.27, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.3', 'IM', 4.28, 40, 0.12, 4.04, 4.52, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.3', 'LV', 5.77, 39, 0.22, 5.32, 6.22, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.4', 'IM', 4.60, 39, 0.07, 4.46, 4.75, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.4', 'LV', 5.88, 40, 0.13, 5.62, 6.14, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.5', 'IM', 2.76, 39, 0.12, 2.51, 3.02, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.5', 'LV', 3.06, 39, 0.22, 2.61, 3.51, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.6', 'IM', 3.06, 39, 0.20, 2.64, 3.47, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.6', 'LV', 3.61, 39, 0.32, 2.97, 4.25, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.7', 'IM', 3.90, 39, 0.15, 3.59, 4.21, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.7', 'LV', 5.27, 39, 0.11, 5.04, 5.51, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.8', 'IM', 3.46, 39, 0.31, 2.83, 4.08, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.a.8', 'LV', 4.45, 38, 0.35, 3.73, 5.17, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.1', 'IM', 4.29, 40, 0.11, 4.06, 4.52, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.1', 'LV', 5.57, 39, 0.21, 5.15, 5.99, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.2', 'IM', 4.14, 40, 0.08, 3.98, 4.29, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.2', 'LV', 4.65, 40, 0.22, 4.20, 5.10, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.3', 'IM', 3.86, 39, 0.20, 3.45, 4.27, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.3', 'LV', 4.80, 40, 0.30, 4.19, 5.41, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.4', 'IM', 4.17, 40, 0.12, 3.92, 4.41, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.4', 'LV', 5.56, 39, 0.10, 5.36, 5.76, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.5', 'IM', 3.58, 40, 0.12, 3.33, 3.83, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.5', 'LV', 4.93, 40, 0.10, 4.73, 5.13, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.6', 'IM', 3.68, 40, 0.15, 3.37, 3.99, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.b.6', 'LV', 5.23, 40, 0.29, 4.65, 5.80, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.c.1', 'IM', 3.97, 40, 0.23, 3.50, 4.44, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.c.1', 'LV', 4.82, 40, 0.35, 4.11, 5.53, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.c.2', 'IM', 3.89, 40, 0.18, 3.53, 4.25, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.c.2', 'LV', 4.62, 40, 0.20, 4.21, 5.03, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.c.3', 'IM', 4.04, 40, 0.18, 3.68, 4.40, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '4.A.4.c.3', 'LV', 5.05, 40, 0.16, 4.72, 5.38, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.1.a.1', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.1.a.1', 'LV', 5.09, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.1.a.2', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.1.a.2', 'LV', 4.23, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.1.b.1', 'IM', 3.55, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.1.b.1', 'LV', 4.23, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.1.b.2', 'IM', 2.76, 21, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.1.b.2', 'LV', 3.27, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.1.b.3', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.1.b.3', 'LV', 3.55, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.a.1', 'IM', 3.36, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.a.1', 'LV', 4.33, 21, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.a.2', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.a.2', 'LV', 4.91, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.a.3', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.a.3', 'LV', 4.64, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.a.4', 'IM', 3.59, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.a.4', 'LV', 4.27, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.b.1', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.b.1', 'LV', 5.45, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.b.2', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.b.2', 'LV', 5.27, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.b.3', 'IM', 4.27, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.b.3', 'LV', 5.82, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.b.4', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.b.4', 'LV', 4.64, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.b.5', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.b.5', 'LV', 5.32, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.b.6', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.2.b.6', 'LV', 5.64, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.3.a.1', 'IM', 1.55, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.3.a.1', 'LV', 1.05, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.3.a.2', 'IM', 1.64, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.3.a.2', 'LV', 1.95, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.3.a.3', 'IM', 1.95, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.3.a.3', 'LV', 1.91, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.3.a.4', 'IM', 1.50, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.3.a.4', 'LV', 0.73, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.3.b.1', 'IM', 4.82, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.3.b.1', 'LV', 4.23, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.3.b.2', 'IM', 1.86, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.3.b.2', 'LV', 1.68, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.3.b.4', 'IM', 1.41, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.3.b.4', 'LV', 0.95, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.3.b.5', 'IM', 2.00, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.3.b.5', 'LV', 1.82, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.3.b.6', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.3.b.6', 'LV', 4.05, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.a.1', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.a.1', 'LV', 3.86, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.a.2', 'IM', 4.55, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.a.2', 'LV', 5.64, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.a.3', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.a.3', 'LV', 5.09, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.a.4', 'IM', 4.27, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.a.4', 'LV', 5.36, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.a.5', 'IM', 2.68, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.a.5', 'LV', 2.68, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.a.6', 'IM', 3.00, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.a.6', 'LV', 3.64, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.a.7', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.a.7', 'LV', 4.50, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.a.8', 'IM', 3.09, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.a.8', 'LV', 3.82, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.b.1', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.b.1', 'LV', 4.68, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.b.2', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.b.2', 'LV', 4.36, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.b.3', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.b.3', 'LV', 5.23, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.b.4', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.b.4', 'LV', 4.59, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.b.5', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.b.5', 'LV', 4.64, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.b.6', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.b.6', 'LV', 5.00, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.c.1', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.c.1', 'LV', 4.45, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.c.2', 'IM', 3.00, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.c.2', 'LV', 3.73, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.c.3', 'IM', 3.41, 22, NULL, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '4.A.4.c.3', 'LV', 4.73, 22, NULL, NULL, NULL, NULL, 'N', '2013-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.1.a.1', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.1.a.1', 'LV', 4.33, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.1.a.2', 'IM', 3.26, 23, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.1.a.2', 'LV', 3.67, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.1.b.1', 'IM', 3.58, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.1.b.1', 'LV', 3.96, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.1.b.2', 'IM', 3.00, 23, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.1.b.2', 'LV', 2.91, 23, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.1.b.3', 'IM', 2.65, 23, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.1.b.3', 'LV', 2.33, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.a.1', 'IM', 3.58, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.a.1', 'LV', 3.88, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.a.2', 'IM', 2.92, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.a.2', 'LV', 3.42, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.a.3', 'IM', 3.58, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.a.3', 'LV', 3.33, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.a.4', 'IM', 3.42, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.a.4', 'LV', 3.62, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.b.1', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.b.1', 'LV', 4.29, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.b.2', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.b.2', 'LV', 4.21, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.b.3', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.b.3', 'LV', 4.62, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.b.4', 'IM', 3.62, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.b.4', 'LV', 3.50, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.b.5', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.b.5', 'LV', 4.33, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.b.6', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.2.b.6', 'LV', 5.17, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.3.a.1', 'IM', 3.46, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.3.a.1', 'LV', 3.75, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.3.a.2', 'IM', 2.67, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.3.a.2', 'LV', 3.38, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.3.a.3', 'IM', 2.21, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.3.a.3', 'LV', 1.96, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.3.a.4', 'IM', 1.50, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.3.a.4', 'LV', 0.58, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.3.b.1', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.3.b.1', 'LV', 3.13, 23, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.3.b.2', 'IM', 1.46, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.3.b.2', 'LV', 1.00, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.3.b.4', 'IM', 1.87, 23, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.3.b.4', 'LV', 1.57, 23, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.3.b.5', 'IM', 1.75, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.3.b.5', 'LV', 1.21, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.3.b.6', 'IM', 3.58, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.3.b.6', 'LV', 3.38, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.a.1', 'IM', 3.38, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.a.1', 'LV', 3.21, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.a.2', 'IM', 4.38, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.a.2', 'LV', 5.04, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.a.3', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.a.3', 'LV', 4.58, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.a.4', 'IM', 4.58, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.a.4', 'LV', 5.38, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.a.5', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.a.5', 'LV', 3.96, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.a.6', 'IM', 3.83, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.a.6', 'LV', 4.46, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.a.7', 'IM', 3.50, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.a.7', 'LV', 4.29, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.a.8', 'IM', 3.62, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.a.8', 'LV', 4.21, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.b.1', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.b.1', 'LV', 4.79, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.b.2', 'IM', 3.83, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.b.2', 'LV', 4.04, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.b.3', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.b.3', 'LV', 4.38, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.b.4', 'IM', 3.88, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.b.4', 'LV', 4.42, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.b.5', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.b.5', 'LV', 5.00, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.b.6', 'IM', 3.62, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.b.6', 'LV', 4.62, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.c.1', 'IM', 3.62, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.c.1', 'LV', 4.12, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.c.2', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.c.2', 'LV', 4.25, 24, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.c.3', 'IM', 3.58, 24, NULL, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '4.A.4.c.3', 'LV', 4.17, 23, NULL, NULL, NULL, NULL, 'N', '2015-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.a.1', 'IM', 4.59, 40, 0.12, 4.34, 4.83, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.a.1', 'LV', 4.69, 40, 0.49, 3.69, 5.69, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.a.2', 'IM', 3.39, 40, 0.34, 2.69, 4.08, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.a.2', 'LV', 4.13, 40, 0.57, 2.97, 5.28, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.b.1', 'IM', 4.13, 40, 0.13, 3.86, 4.40, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.b.1', 'LV', 4.85, 40, 0.30, 4.25, 5.45, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.b.2', 'IM', 2.91, 39, 0.34, 2.21, 3.60, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.b.2', 'LV', 2.96, 40, 0.43, 2.09, 3.82, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.b.3', 'IM', 3.59, 40, 0.39, 2.79, 4.38, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.1.b.3', 'LV', 3.69, 39, 0.64, 2.39, 5.00, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.a.1', 'IM', 3.54, 40, 0.39, 2.76, 4.32, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.a.1', 'LV', 4.01, 39, 0.60, 2.80, 5.22, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.a.2', 'IM', 3.89, 40, 0.19, 3.49, 4.28, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.a.2', 'LV', 5.13, 40, 0.33, 4.46, 5.81, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.a.3', 'IM', 3.67, 40, 0.25, 3.16, 4.17, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.a.3', 'LV', 3.93, 39, 0.41, 3.09, 4.77, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.a.4', 'IM', 4.13, 39, 0.19, 3.74, 4.52, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.a.4', 'LV', 4.82, 39, 0.30, 4.21, 5.43, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.1', 'IM', 4.45, 38, 0.14, 4.18, 4.73, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.1', 'LV', 5.25, 39, 0.29, 4.65, 5.84, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.2', 'IM', 4.03, 39, 0.23, 3.57, 4.50, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.2', 'LV', 5.25, 39, 0.25, 4.74, 5.76, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.3', 'IM', 4.07, 39, 0.20, 3.67, 4.48, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.3', 'LV', 5.27, 39, 0.24, 4.78, 5.76, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.4', 'IM', 3.65, 40, 0.17, 3.31, 4.00, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.4', 'LV', 3.90, 40, 0.33, 3.24, 4.56, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.5', 'IM', 4.04, 40, 0.20, 3.62, 4.45, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.5', 'LV', 4.90, 40, 0.40, 4.10, 5.70, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.6', 'IM', 4.05, 40, 0.19, 3.66, 4.44, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.2.b.6', 'LV', 5.30, 40, 0.38, 4.53, 6.06, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.a.1', 'IM', 1.75, 40, 0.18, 1.39, 2.11, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.a.1', 'LV', 1.58, 40, 0.37, 0.83, 2.33, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.a.2', 'IM', 1.55, 40, 0.13, 1.28, 1.82, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.a.2', 'LV', 1.64, 40, 0.40, 0.84, 2.45, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.a.3', 'IM', 1.69, 40, 0.19, 1.31, 2.06, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.a.3', 'LV', 1.58, 40, 0.42, 0.73, 2.43, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.a.4', 'IM', 1.59, 40, 0.17, 1.24, 1.94, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.a.4', 'LV', 1.07, 40, 0.30, 0.47, 1.67, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.1', 'IM', 4.39, 40, 0.19, 4.01, 4.77, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.1', 'LV', 4.08, 40, 0.26, 3.55, 4.60, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.2', 'IM', 3.85, 40, 0.43, 2.99, 4.71, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.2', 'LV', 4.56, 40, 0.61, 3.33, 5.79, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.4', 'IM', 1.79, 40, 0.24, 1.30, 2.29, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.4', 'LV', 1.75, 40, 0.51, 0.72, 2.78, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.5', 'IM', 1.85, 40, 0.21, 1.43, 2.26, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.5', 'LV', 1.92, 40, 0.46, 1.00, 2.85, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.6', 'IM', 3.51, 40, 0.23, 3.04, 3.97, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.3.b.6', 'LV', 3.99, 40, 0.25, 3.48, 4.51, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.1', 'IM', 3.70, 40, 0.11, 3.47, 3.93, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.1', 'LV', 3.99, 40, 0.23, 3.52, 4.46, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.2', 'IM', 4.34, 39, 0.13, 4.09, 4.60, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.2', 'LV', 5.58, 40, 0.22, 5.14, 6.03, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.3', 'IM', 4.07, 39, 0.09, 3.90, 4.24, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.3', 'LV', 5.00, 40, 0.17, 4.67, 5.34, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.4', 'IM', 3.92, 40, 0.19, 3.53, 4.32, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.4', 'LV', 5.15, 40, 0.19, 4.76, 5.54, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.5', 'IM', 1.98, 40, 0.16, 1.66, 2.31, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.5', 'LV', 2.13, 40, 0.36, 1.41, 2.86, 'N', 'N', '2012-07-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.6', 'IM', 2.33, 39, 0.24, 1.85, 2.82, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.6', 'LV', 3.29, 40, 0.52, 2.23, 4.34, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.7', 'IM', 3.88, 40, 0.10, 3.67, 4.08, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.7', 'LV', 5.20, 40, 0.20, 4.80, 5.59, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.8', 'IM', 1.52, 40, 0.20, 1.11, 1.93, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.a.8', 'LV', 1.04, 40, 0.37, 0.29, 1.80, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.1', 'IM', 3.81, 40, 0.31, 3.19, 4.44, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.1', 'LV', 5.12, 40, 0.32, 4.47, 5.78, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.2', 'IM', 3.43, 40, 0.25, 2.93, 3.93, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.2', 'LV', 4.28, 40, 0.28, 3.72, 4.85, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.3', 'IM', 3.21, 40, 0.25, 2.71, 3.71, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.3', 'LV', 4.11, 40, 0.25, 3.60, 4.62, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.4', 'IM', 3.39, 40, 0.38, 2.61, 4.17, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.4', 'LV', 3.89, 39, 0.60, 2.67, 5.11, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.5', 'IM', 3.36, 40, 0.24, 2.88, 3.84, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.5', 'LV', 4.64, 40, 0.22, 4.21, 5.08, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.6', 'IM', 3.33, 40, 0.16, 3.01, 3.66, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.b.6', 'LV', 4.86, 40, 0.26, 4.32, 5.39, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.c.1', 'IM', 2.60, 40, 0.26, 2.08, 3.12, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.c.1', 'LV', 2.84, 39, 0.42, 1.98, 3.69, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.c.2', 'IM', 2.52, 40, 0.26, 2.00, 3.04, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.c.2', 'LV', 3.16, 40, 0.50, 2.15, 4.17, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.c.3', 'IM', 2.77, 40, 0.27, 2.22, 3.31, 'N', NULL, '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '4.A.4.c.3', 'LV', 3.42, 40, 0.48, 2.46, 4.39, 'N', 'N', '2012-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.a.1', 'IM', 4.49, 31, 0.13, 4.21, 4.76, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.a.1', 'LV', 5.19, 31, 0.36, 4.45, 5.93, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.a.2', 'IM', 4.08, 31, 0.17, 3.74, 4.42, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.a.2', 'LV', 5.13, 31, 0.15, 4.81, 5.45, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.b.1', 'IM', 4.05, 31, 0.12, 3.81, 4.28, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.b.1', 'LV', 5.46, 31, 0.16, 5.14, 5.79, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.b.2', 'IM', 3.29, 31, 0.10, 3.08, 3.50, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.b.2', 'LV', 4.12, 31, 0.18, 3.75, 4.50, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.b.3', 'IM', 3.97, 31, 0.18, 3.60, 4.33, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.1.b.3', 'LV', 4.43, 31, 0.15, 4.11, 4.74, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.a.1', 'IM', 3.86, 31, 0.24, 3.37, 4.36, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.a.1', 'LV', 4.62, 31, 0.23, 4.15, 5.10, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.a.2', 'IM', 4.32, 31, 0.19, 3.94, 4.70, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.a.2', 'LV', 5.87, 31, 0.17, 5.52, 6.22, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.a.3', 'IM', 3.72, 31, 0.26, 3.19, 4.26, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.a.3', 'LV', 4.29, 31, 0.26, 3.76, 4.82, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.a.4', 'IM', 4.52, 31, 0.13, 4.25, 4.78, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.a.4', 'LV', 5.74, 31, 0.19, 5.35, 6.12, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.1', 'IM', 4.56, 31, 0.13, 4.30, 4.82, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.1', 'LV', 5.28, 31, 0.19, 4.90, 5.66, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.2', 'IM', 4.05, 31, 0.12, 3.80, 4.29, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.2', 'LV', 5.53, 31, 0.27, 4.98, 6.08, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.3', 'IM', 4.09, 31, 0.16, 3.77, 4.42, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.3', 'LV', 5.56, 31, 0.19, 5.18, 5.94, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.4', 'IM', 4.03, 31, 0.18, 3.67, 4.39, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.4', 'LV', 4.57, 31, 0.21, 4.15, 4.99, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.5', 'IM', 3.46, 30, 0.30, 2.86, 4.06, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.5', 'LV', 4.52, 31, 0.23, 4.05, 4.98, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.6', 'IM', 3.85, 31, 0.14, 3.57, 4.13, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.2.b.6', 'LV', 5.29, 31, 0.21, 4.87, 5.71, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.a.1', 'IM', 2.74, 30, 0.21, 2.32, 3.17, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.a.1', 'LV', 3.17, 30, 0.42, 2.31, 4.03, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.a.2', 'IM', 2.35, 31, 0.14, 2.06, 2.64, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.a.2', 'LV', 3.41, 31, 0.43, 2.53, 4.28, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.a.3', 'IM', 3.28, 31, 0.35, 2.58, 3.99, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.a.3', 'LV', 3.91, 31, 0.44, 3.01, 4.81, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.a.4', 'IM', 1.81, 31, 0.22, 1.37, 2.25, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.a.4', 'LV', 1.78, 31, 0.51, 0.75, 2.81, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.1', 'IM', 4.59, 31, 0.15, 4.28, 4.90, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.1', 'LV', 4.26, 31, 0.25, 3.76, 4.76, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.2', 'IM', 2.80, 31, 0.44, 1.91, 3.69, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.2', 'LV', 3.33, 31, 0.58, 2.15, 4.50, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.4', 'IM', 2.40, 31, 0.45, 1.49, 3.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.4', 'LV', 3.06, 31, 0.78, 1.46, 4.66, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.5', 'IM', 2.81, 31, 0.37, 2.06, 3.56, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.5', 'LV', 3.41, 31, 0.72, 1.94, 4.88, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.6', 'IM', 4.01, 31, 0.11, 3.79, 4.24, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.3.b.6', 'LV', 4.54, 31, 0.33, 3.86, 5.21, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.1', 'IM', 3.90, 31, 0.07, 3.76, 4.04, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.1', 'LV', 5.27, 31, 0.26, 4.74, 5.79, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.2', 'IM', 4.28, 31, 0.15, 3.98, 4.57, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.2', 'LV', 5.39, 31, 0.33, 4.72, 6.06, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.3', 'IM', 3.67, 31, 0.27, 3.11, 4.22, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.3', 'LV', 4.46, 31, 0.39, 3.67, 5.25, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.4', 'IM', 3.65, 31, 0.15, 3.34, 3.97, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.4', 'LV', 4.87, 31, 0.22, 4.43, 5.31, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.5', 'IM', 2.57, 31, 0.20, 2.16, 2.98, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.5', 'LV', 2.58, 31, 0.41, 1.75, 3.41, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.6', 'IM', 2.87, 31, 0.25, 2.35, 3.39, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.6', 'LV', 3.57, 31, 0.42, 2.71, 4.43, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.7', 'IM', 2.85, 31, 0.15, 2.55, 3.16, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.7', 'LV', 3.90, 31, 0.27, 3.34, 4.46, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.8', 'IM', 2.04, 31, 0.20, 1.62, 2.45, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.a.8', 'LV', 2.25, 31, 0.38, 1.47, 3.03, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.1', 'IM', 3.84, 31, 0.18, 3.48, 4.21, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.1', 'LV', 4.16, 31, 0.34, 3.47, 4.85, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.2', 'IM', 4.08, 30, 0.14, 3.79, 4.36, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.2', 'LV', 4.24, 30, 0.40, 3.42, 5.05, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.3', 'IM', 3.24, 31, 0.12, 3.00, 3.47, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.3', 'LV', 3.79, 31, 0.22, 3.35, 4.24, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.4', 'IM', 3.40, 31, 0.26, 2.87, 3.93, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.4', 'LV', 4.11, 31, 0.37, 3.35, 4.86, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.5', 'IM', 2.93, 31, 0.15, 2.63, 3.23, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.5', 'LV', 3.91, 31, 0.13, 3.66, 4.17, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.6', 'IM', 3.46, 31, 0.15, 3.15, 3.78, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.b.6', 'LV', 5.30, 31, 0.42, 4.44, 6.16, 'N', 'N', '2014-07-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.c.1', 'IM', 2.49, 31, 0.20, 2.08, 2.90, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.c.1', 'LV', 3.07, 31, 0.49, 2.06, 4.08, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.c.2', 'IM', 2.58, 30, 0.26, 2.04, 3.11, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.c.2', 'LV', 3.13, 30, 0.34, 2.44, 3.81, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.c.3', 'IM', 3.42, 31, 0.23, 2.95, 3.89, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '4.A.4.c.3', 'LV', 4.31, 31, 0.35, 3.60, 5.01, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.a.1', 'IM', 4.19, 21, 0.17, 3.82, 4.55, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.a.1', 'LV', 3.88, 21, 0.38, 3.09, 4.67, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.a.2', 'IM', 3.82, 21, 0.24, 3.32, 4.33, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.a.2', 'LV', 3.61, 20, 0.28, 3.03, 4.19, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.b.1', 'IM', 4.03, 21, 0.17, 3.68, 4.38, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.b.1', 'LV', 4.36, 20, 0.13, 4.09, 4.64, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.b.2', 'IM', 3.70, 21, 0.25, 3.18, 4.22, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.b.2', 'LV', 3.64, 20, 0.34, 2.93, 4.34, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.b.3', 'IM', 3.44, 20, 0.21, 3.00, 3.88, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.1.b.3', 'LV', 3.08, 18, 0.30, 2.45, 3.71, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.a.1', 'IM', 3.94, 20, 0.23, 3.45, 4.43, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.a.1', 'LV', 3.94, 19, 0.34, 3.23, 4.66, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.a.2', 'IM', 3.57, 21, 0.34, 2.86, 4.29, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.a.2', 'LV', 3.58, 20, 0.47, 2.60, 4.56, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.a.3', 'IM', 3.49, 21, 0.22, 3.04, 3.94, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.a.3', 'LV', 3.97, 20, 0.28, 3.39, 4.55, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.a.4', 'IM', 3.37, 21, 0.22, 2.91, 3.83, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.a.4', 'LV', 3.42, 20, 0.27, 2.85, 3.99, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.1', 'IM', 4.46, 21, 0.12, 4.21, 4.70, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.1', 'LV', 4.36, 20, 0.24, 3.85, 4.86, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.2', 'IM', 3.06, 21, 0.20, 2.64, 3.49, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.2', 'LV', 3.72, 20, 0.34, 3.01, 4.42, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.3', 'IM', 3.92, 21, 0.29, 3.31, 4.52, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.3', 'LV', 3.82, 20, 0.29, 3.23, 4.42, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.4', 'IM', 3.30, 21, 0.24, 2.80, 3.80, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.4', 'LV', 3.27, 20, 0.37, 2.51, 4.04, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.5', 'IM', 3.83, 21, 0.30, 3.21, 4.45, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.5', 'LV', 4.65, 20, 0.38, 3.86, 5.43, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.6', 'IM', 4.15, 21, 0.18, 3.77, 4.52, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.2.b.6', 'LV', 5.00, 20, 0.30, 4.38, 5.62, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.a.1', 'IM', 3.30, 21, 0.20, 2.88, 3.71, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.a.1', 'LV', 3.65, 20, 0.30, 3.03, 4.28, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.a.2', 'IM', 2.84, 21, 0.20, 2.43, 3.25, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.a.2', 'LV', 3.78, 20, 0.43, 2.89, 4.68, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.a.3', 'IM', 3.07, 21, 0.24, 2.57, 3.57, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.a.3', 'LV', 2.96, 20, 0.33, 2.26, 3.66, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.a.4', 'IM', 2.15, 21, 0.31, 1.50, 2.81, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.a.4', 'LV', 1.84, 20, 0.53, 0.73, 2.95, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.1', 'IM', 2.96, 21, 0.24, 2.45, 3.47, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.1', 'LV', 3.62, 20, 0.22, 3.17, 4.07, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.2', 'IM', 2.20, 21, 0.30, 1.58, 2.82, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.2', 'LV', 2.05, 20, 0.50, 1.01, 3.09, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.4', 'IM', 2.70, 21, 0.31, 2.05, 3.34, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.4', 'LV', 3.19, 20, 0.53, 2.09, 4.30, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.5', 'IM', 2.16, 21, 0.21, 1.72, 2.60, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.5', 'LV', 2.36, 20, 0.49, 1.34, 3.39, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.6', 'IM', 3.87, 21, 0.25, 3.34, 4.39, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.3.b.6', 'LV', 3.53, 20, 0.43, 2.62, 4.44, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.1', 'IM', 3.00, 21, 0.27, 2.43, 3.57, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.1', 'LV', 2.44, 20, 0.44, 1.52, 3.35, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.2', 'IM', 4.08, 21, 0.21, 3.64, 4.53, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.2', 'LV', 4.00, 20, 0.26, 3.46, 4.54, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.3', 'IM', 3.83, 21, 0.25, 3.31, 4.36, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.3', 'LV', 4.18, 19, 0.40, 3.34, 5.02, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.4', 'IM', 3.67, 21, 0.34, 2.96, 4.39, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.4', 'LV', 4.02, 20, 0.60, 2.77, 5.27, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.5', 'IM', 3.40, 21, 0.23, 2.92, 3.89, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.5', 'LV', 3.69, 20, 0.27, 3.13, 4.26, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.6', 'IM', 3.65, 21, 0.29, 3.05, 4.26, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.6', 'LV', 3.69, 20, 0.45, 2.75, 4.64, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.7', 'IM', 4.08, 21, 0.21, 3.64, 4.53, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.7', 'LV', 5.31, 19, 0.34, 4.61, 6.02, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.8', 'IM', 4.16, 21, 0.32, 3.50, 4.82, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.a.8', 'LV', 4.97, 20, 0.37, 4.20, 5.74, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.1', 'IM', 3.99, 21, 0.25, 3.46, 4.52, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.1', 'LV', 4.68, 20, 0.45, 3.74, 5.61, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.2', 'IM', 4.08, 21, 0.26, 3.53, 4.62, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.2', 'LV', 3.89, 20, 0.48, 2.88, 4.90, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.3', 'IM', 4.29, 20, 0.31, 3.65, 4.92, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.3', 'LV', 4.47, 20, 0.54, 3.34, 5.60, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.4', 'IM', 4.15, 21, 0.20, 3.72, 4.57, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.4', 'LV', 4.57, 20, 0.46, 3.62, 5.53, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.5', 'IM', 4.07, 21, 0.31, 3.42, 4.73, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.5', 'LV', 4.66, 20, 0.53, 3.56, 5.77, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.6', 'IM', 3.29, 21, 0.25, 2.77, 3.82, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.b.6', 'LV', 3.49, 20, 0.36, 2.73, 4.24, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.c.1', 'IM', 3.75, 21, 0.20, 3.33, 4.16, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.c.1', 'LV', 3.86, 20, 0.31, 3.21, 4.51, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.c.2', 'IM', 3.87, 21, 0.28, 3.27, 4.46, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.c.2', 'LV', 4.06, 20, 0.41, 3.20, 4.92, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.c.3', 'IM', 3.57, 21, 0.17, 3.22, 3.92, 'N', NULL, '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '4.A.4.c.3', 'LV', 4.49, 20, 0.24, 3.98, 5.00, 'N', 'N', '2008-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.1.a.1', 'IM', 4.49, 18, 0.29, 3.88, 5.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.1.a.1', 'LV', 4.91, 18, 0.69, 3.45, 6.37, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.1.a.2', 'IM', 3.56, 18, 0.59, 2.31, 4.80, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.1.a.2', 'LV', 4.02, 18, 1.08, 1.74, 6.31, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.1.b.1', 'IM', 3.90, 18, 0.42, 3.03, 4.78, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.1.b.1', 'LV', 4.33, 17, 1.01, 2.19, 6.47, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.1.b.2', 'IM', 3.05, 17, 0.53, 1.93, 4.16, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.1.b.2', 'LV', 2.56, 18, 0.49, 1.52, 3.60, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.1.b.3', 'IM', 2.36, 18, 0.48, 1.34, 3.38, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.1.b.3', 'LV', 2.02, 18, 0.69, 0.57, 3.48, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.a.1', 'IM', 3.55, 18, 0.70, 2.07, 5.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.a.1', 'LV', 3.46, 18, 0.95, 1.46, 5.47, 'N', 'N', '2014-07-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.a.2', 'IM', 3.64, 17, 0.46, 2.68, 4.61, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.a.2', 'LV', 4.00, 18, 0.47, 3.01, 4.99, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.a.3', 'IM', 3.28, 18, 0.48, 2.28, 4.28, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.a.3', 'LV', 3.67, 18, 0.74, 2.12, 5.23, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.a.4', 'IM', 2.91, 18, 0.42, 2.03, 3.80, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.a.4', 'LV', 2.56, 18, 0.60, 1.30, 3.82, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.b.1', 'IM', 3.32, 18, 0.53, 2.21, 4.44, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.b.1', 'LV', 4.04, 18, 0.81, 2.34, 5.74, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.b.2', 'IM', 2.93, 18, 0.48, 1.92, 3.93, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.b.2', 'LV', 2.76, 18, 0.61, 1.48, 4.04, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.b.3', 'IM', 3.09, 18, 0.46, 2.13, 4.06, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.b.3', 'LV', 3.82, 18, 0.79, 2.15, 5.49, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.b.4', 'IM', 2.74, 18, 0.48, 1.73, 3.76, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.b.4', 'LV', 2.20, 18, 0.70, 0.72, 3.68, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.b.5', 'IM', 3.61, 18, 0.45, 2.67, 4.56, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.b.5', 'LV', 4.68, 18, 0.54, 3.55, 5.82, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.b.6', 'IM', 3.40, 18, 0.44, 2.48, 4.33, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.2.b.6', 'LV', 4.81, 18, 0.42, 3.93, 5.70, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.3.a.1', 'IM', 2.76, 18, 0.43, 1.85, 3.67, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.3.a.1', 'LV', 3.48, 18, 0.69, 2.03, 4.94, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.3.a.2', 'IM', 3.23, 18, 0.29, 2.63, 3.84, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.3.a.2', 'LV', 5.05, 18, 0.40, 4.21, 5.88, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.3.a.3', 'IM', 2.40, 18, 0.52, 1.31, 3.50, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.3.a.3', 'LV', 2.37, 18, 0.87, 0.53, 4.20, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.3.a.4', 'IM', 3.18, 18, 0.47, 2.19, 4.17, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.3.a.4', 'LV', 2.55, 18, 0.59, 1.31, 3.79, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.3.b.1', 'IM', 3.94, 18, 0.36, 3.19, 4.70, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.3.b.1', 'LV', 3.30, 18, 0.40, 2.45, 4.15, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.3.b.2', 'IM', 1.41, 18, 0.35, 1.00, 2.14, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.3.b.2', 'LV', 0.71, 18, 0.61, 0.00, 2.01, 'Y', 'Y', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.3.b.4', 'IM', 1.93, 18, 0.41, 1.05, 2.80, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.3.b.4', 'LV', 1.73, 18, 0.73, 0.19, 3.27, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.3.b.5', 'IM', 1.63, 18, 0.37, 1.00, 2.41, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.3.b.5', 'LV', 1.25, 18, 0.71, 0.00, 2.75, 'Y', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.3.b.6', 'IM', 4.10, 18, 0.33, 3.40, 4.80, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.3.b.6', 'LV', 4.09, 18, 0.45, 3.14, 5.04, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.a.1', 'IM', 3.60, 18, 0.39, 2.77, 4.42, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.a.1', 'LV', 3.02, 18, 0.42, 2.13, 3.91, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.a.2', 'IM', 3.82, 18, 0.50, 2.77, 4.87, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.a.2', 'LV', 4.17, 18, 0.82, 2.44, 5.90, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.a.3', 'IM', 4.15, 18, 0.24, 3.65, 4.66, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.a.3', 'LV', 4.43, 18, 0.48, 3.43, 5.44, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.a.4', 'IM', 3.65, 18, 0.49, 2.61, 4.70, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.a.4', 'LV', 4.63, 18, 0.85, 2.85, 6.41, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.a.5', 'IM', 4.67, 18, 0.18, 4.30, 5.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.a.5', 'LV', 5.45, 18, 0.31, 4.79, 6.12, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.a.6', 'IM', 3.69, 18, 0.38, 2.89, 4.48, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.a.6', 'LV', 4.07, 18, 0.39, 3.25, 4.89, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.a.7', 'IM', 2.65, 18, 0.44, 1.72, 3.58, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.a.7', 'LV', 2.97, 18, 0.93, 1.00, 4.94, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.a.8', 'IM', 4.65, 18, 0.18, 4.28, 5.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.a.8', 'LV', 5.30, 18, 0.20, 4.88, 5.71, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.b.1', 'IM', 4.09, 18, 0.25, 3.56, 4.61, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.b.1', 'LV', 4.71, 18, 0.48, 3.70, 5.72, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.b.2', 'IM', 2.44, 18, 0.52, 1.34, 3.55, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.b.2', 'LV', 1.79, 18, 0.71, 0.30, 3.29, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.b.3', 'IM', 3.19, 18, 0.51, 2.12, 4.26, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.b.3', 'LV', 3.56, 18, 0.70, 2.09, 5.03, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.b.4', 'IM', 2.88, 18, 0.51, 1.81, 3.95, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.b.4', 'LV', 3.53, 18, 0.98, 1.47, 5.58, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.b.5', 'IM', 3.12, 18, 0.40, 2.28, 3.96, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.b.5', 'LV', 3.84, 18, 0.69, 2.39, 5.30, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.b.6', 'IM', 3.42, 18, 0.38, 2.62, 4.22, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.b.6', 'LV', 3.80, 18, 0.66, 2.42, 5.19, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.c.1', 'IM', 3.65, 18, 0.38, 2.84, 4.47, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.c.1', 'LV', 4.25, 18, 0.51, 3.18, 5.32, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.c.2', 'IM', 2.41, 18, 0.43, 1.50, 3.33, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.c.2', 'LV', 2.93, 18, 0.87, 1.10, 4.77, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.c.3', 'IM', 2.51, 18, 0.42, 1.62, 3.40, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '4.A.4.c.3', 'LV', 3.36, 18, 0.91, 1.45, 5.28, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.a.1', 'IM', 4.18, 30, 0.19, 3.78, 4.57, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.a.1', 'LV', 4.15, 30, 0.25, 3.63, 4.66, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.a.2', 'IM', 3.97, 30, 0.10, 3.75, 4.18, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.a.2', 'LV', 4.44, 30, 0.21, 4.01, 4.88, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.b.1', 'IM', 3.98, 30, 0.15, 3.68, 4.28, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.b.1', 'LV', 4.17, 29, 0.31, 3.52, 4.81, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.b.2', 'IM', 3.12, 30, 0.18, 2.75, 3.49, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.b.2', 'LV', 3.28, 29, 0.30, 2.67, 3.89, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.b.3', 'IM', 3.26, 29, 0.19, 2.87, 3.65, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.1.b.3', 'LV', 3.22, 29, 0.31, 2.59, 3.85, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.a.1', 'IM', 3.82, 29, 0.29, 3.21, 4.42, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.a.1', 'LV', 4.12, 28, 0.35, 3.40, 4.84, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.a.2', 'IM', 3.47, 30, 0.16, 3.15, 3.79, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.a.2', 'LV', 3.94, 30, 0.27, 3.38, 4.49, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.a.3', 'IM', 4.19, 30, 0.14, 3.90, 4.48, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.a.3', 'LV', 4.52, 30, 0.23, 4.05, 5.00, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.a.4', 'IM', 3.60, 29, 0.15, 3.29, 3.90, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.a.4', 'LV', 4.16, 29, 0.24, 3.66, 4.65, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.1', 'IM', 4.28, 30, 0.13, 4.02, 4.55, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.1', 'LV', 4.75, 30, 0.21, 4.33, 5.17, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.2', 'IM', 3.21, 30, 0.14, 2.92, 3.49, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.2', 'LV', 3.75, 30, 0.23, 3.27, 4.23, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.3', 'IM', 3.53, 30, 0.29, 2.95, 4.11, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.3', 'LV', 4.31, 30, 0.35, 3.60, 5.02, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.4', 'IM', 3.05, 30, 0.24, 2.56, 3.55, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.4', 'LV', 3.05, 30, 0.31, 2.42, 3.68, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.5', 'IM', 3.96, 30, 0.13, 3.68, 4.23, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.5', 'LV', 4.94, 30, 0.20, 4.52, 5.35, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.6', 'IM', 3.97, 30, 0.13, 3.71, 4.24, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.2.b.6', 'LV', 4.82, 30, 0.23, 4.35, 5.30, 'N', 'N', '2014-07-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.a.1', 'IM', 2.41, 30, 0.15, 2.12, 2.71, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.a.1', 'LV', 2.58, 30, 0.27, 2.03, 3.13, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.a.2', 'IM', 2.36, 29, 0.19, 1.97, 2.75, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.a.2', 'LV', 2.92, 29, 0.32, 2.25, 3.58, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.a.3', 'IM', 2.03, 28, 0.24, 1.54, 2.53, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.a.3', 'LV', 1.92, 28, 0.47, 0.95, 2.90, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.a.4', 'IM', 1.61, 28, 0.20, 1.21, 2.02, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.a.4', 'LV', 1.06, 28, 0.35, 0.33, 1.78, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.1', 'IM', 4.20, 29, 0.20, 3.79, 4.60, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.1', 'LV', 4.12, 29, 0.20, 3.71, 4.53, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.2', 'IM', 2.21, 29, 0.19, 1.82, 2.60, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.2', 'LV', 1.91, 29, 0.32, 1.25, 2.57, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.4', 'IM', 2.26, 29, 0.21, 1.83, 2.69, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.4', 'LV', 2.51, 29, 0.40, 1.69, 3.32, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.5', 'IM', 1.92, 29, 0.17, 1.57, 2.28, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.5', 'LV', 1.77, 29, 0.37, 1.01, 2.52, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.6', 'IM', 4.03, 30, 0.17, 3.69, 4.38, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.3.b.6', 'LV', 3.95, 29, 0.21, 3.52, 4.39, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.1', 'IM', 3.14, 29, 0.11, 2.92, 3.37, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.1', 'LV', 3.08, 29, 0.23, 2.60, 3.55, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.2', 'IM', 4.45, 30, 0.12, 4.21, 4.70, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.2', 'LV', 4.80, 30, 0.17, 4.46, 5.14, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.3', 'IM', 3.41, 30, 0.29, 2.83, 4.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.3', 'LV', 3.63, 30, 0.31, 3.00, 4.26, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.4', 'IM', 4.11, 30, 0.17, 3.76, 4.46, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.4', 'LV', 4.70, 30, 0.19, 4.31, 5.09, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.5', 'IM', 2.79, 30, 0.24, 2.31, 3.28, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.5', 'LV', 2.88, 30, 0.27, 2.32, 3.44, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.6', 'IM', 2.58, 29, 0.23, 2.10, 3.05, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.6', 'LV', 2.64, 30, 0.37, 1.89, 3.39, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.7', 'IM', 4.16, 30, 0.14, 3.87, 4.44, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.7', 'LV', 4.85, 30, 0.20, 4.44, 5.25, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.8', 'IM', 4.17, 30, 0.12, 3.92, 4.42, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.a.8', 'LV', 4.72, 30, 0.27, 4.17, 5.27, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.1', 'IM', 3.89, 30, 0.14, 3.62, 4.17, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.1', 'LV', 4.51, 30, 0.23, 4.04, 4.98, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.2', 'IM', 4.00, 30, 0.20, 3.59, 4.41, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.2', 'LV', 4.20, 30, 0.24, 3.70, 4.70, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.3', 'IM', 3.94, 30, 0.18, 3.58, 4.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.3', 'LV', 4.21, 30, 0.30, 3.60, 4.81, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.4', 'IM', 4.22, 30, 0.14, 3.93, 4.52, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.4', 'LV', 5.05, 30, 0.25, 4.53, 5.57, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.5', 'IM', 4.24, 30, 0.17, 3.89, 4.59, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.5', 'LV', 4.84, 30, 0.23, 4.38, 5.30, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.6', 'IM', 3.43, 30, 0.22, 2.97, 3.89, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.b.6', 'LV', 4.39, 30, 0.37, 3.64, 5.14, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.c.1', 'IM', 3.42, 30, 0.15, 3.11, 3.72, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.c.1', 'LV', 3.59, 30, 0.29, 3.00, 4.18, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.c.2', 'IM', 3.67, 30, 0.16, 3.34, 4.00, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.c.2', 'LV', 4.38, 30, 0.17, 4.03, 4.74, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.c.3', 'IM', 3.73, 30, 0.17, 3.38, 4.08, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '4.A.4.c.3', 'LV', 4.31, 30, 0.21, 3.89, 4.73, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.a.1', 'IM', 4.13, 16, 0.12, 3.86, 4.39, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.a.1', 'LV', 4.26, 17, 0.15, 3.94, 4.58, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.a.2', 'IM', 3.78, 16, 0.39, 2.95, 4.62, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.a.2', 'LV', 3.89, 16, 0.48, 2.86, 4.92, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.b.1', 'IM', 3.85, 16, 0.42, 2.96, 4.74, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.b.1', 'LV', 4.78, 16, 0.48, 3.76, 5.79, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.b.2', 'IM', 3.08, 15, 0.35, 2.34, 3.83, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.b.2', 'LV', 2.27, 16, 0.35, 1.52, 3.01, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.b.3', 'IM', 3.57, 16, 0.20, 3.14, 4.00, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.1.b.3', 'LV', 2.85, 17, 0.34, 2.14, 3.57, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.a.1', 'IM', 3.99, 17, 0.41, 3.13, 4.86, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.a.1', 'LV', 4.42, 17, 0.64, 3.06, 5.78, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.a.2', 'IM', 3.52, 17, 0.28, 2.93, 4.12, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.a.2', 'LV', 4.13, 17, 0.39, 3.30, 4.96, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.a.3', 'IM', 3.66, 17, 0.30, 3.03, 4.30, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.a.3', 'LV', 3.87, 17, 0.57, 2.65, 5.09, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.a.4', 'IM', 3.74, 16, 0.38, 2.92, 4.55, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.a.4', 'LV', 3.98, 17, 0.48, 2.97, 4.99, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.1', 'IM', 4.37, 17, 0.28, 3.79, 4.96, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.1', 'LV', 4.36, 17, 0.43, 3.44, 5.27, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.2', 'IM', 3.62, 17, 0.33, 2.91, 4.33, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.2', 'LV', 4.94, 17, 0.17, 4.57, 5.30, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.3', 'IM', 3.73, 16, 0.34, 3.01, 4.45, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.3', 'LV', 4.80, 16, 0.42, 3.91, 5.69, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.4', 'IM', 3.65, 17, 0.31, 3.00, 4.30, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.4', 'LV', 4.02, 16, 0.67, 2.59, 5.45, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.5', 'IM', 3.64, 16, 0.32, 2.95, 4.33, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.5', 'LV', 4.44, 17, 0.28, 3.85, 5.03, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.6', 'IM', 3.95, 17, 0.32, 3.28, 4.62, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.2.b.6', 'LV', 5.54, 17, 0.34, 4.82, 6.27, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.a.1', 'IM', 2.66, 17, 0.42, 1.77, 3.56, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.a.1', 'LV', 2.90, 17, 0.77, 1.28, 4.53, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.a.2', 'IM', 2.10, 17, 0.36, 1.34, 2.86, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.a.2', 'LV', 2.52, 17, 0.83, 0.77, 4.27, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.a.3', 'IM', 2.79, 17, 0.39, 1.97, 3.61, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.a.3', 'LV', 2.50, 17, 0.42, 1.60, 3.40, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.a.4', 'IM', 2.29, 17, 0.36, 1.53, 3.04, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.a.4', 'LV', 1.70, 17, 0.47, 0.71, 2.69, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.1', 'IM', 4.38, 16, 0.27, 3.80, 4.96, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.1', 'LV', 4.14, 17, 0.39, 3.32, 4.96, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.2', 'IM', 2.39, 17, 0.36, 1.62, 3.15, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.2', 'LV', 2.11, 17, 0.60, 0.83, 3.39, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.4', 'IM', 2.73, 17, 0.36, 1.97, 3.48, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.4', 'LV', 2.79, 17, 0.45, 1.84, 3.74, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.5', 'IM', 2.89, 16, 0.25, 2.37, 3.42, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.5', 'LV', 3.22, 17, 0.26, 2.66, 3.78, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.6', 'IM', 4.09, 16, 0.25, 3.56, 4.62, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.3.b.6', 'LV', 3.98, 17, 0.61, 2.69, 5.27, 'N', 'N', '2010-06-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.1', 'IM', 3.57, 16, 0.42, 2.67, 4.47, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.1', 'LV', 3.88, 17, 0.62, 2.56, 5.19, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.2', 'IM', 4.26, 17, 0.32, 3.58, 4.94, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.2', 'LV', 4.76, 17, 0.36, 4.00, 5.51, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.3', 'IM', 4.26, 17, 0.29, 3.64, 4.87, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.3', 'LV', 4.75, 17, 0.50, 3.70, 5.81, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.4', 'IM', 3.98, 17, 0.29, 3.37, 4.60, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.4', 'LV', 5.91, 16, 0.28, 5.30, 6.51, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.5', 'IM', 4.16, 17, 0.29, 3.55, 4.76, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.5', 'LV', 4.95, 17, 0.09, 4.77, 5.13, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.6', 'IM', 4.08, 16, 0.20, 3.65, 4.50, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.6', 'LV', 4.80, 16, 0.47, 3.79, 5.81, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.7', 'IM', 3.87, 17, 0.24, 3.36, 4.39, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.7', 'LV', 5.06, 17, 0.47, 4.06, 6.06, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.8', 'IM', 4.59, 17, 0.28, 4.01, 5.00, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.a.8', 'LV', 5.54, 17, 0.33, 4.84, 6.25, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.1', 'IM', 4.05, 17, 0.29, 3.43, 4.66, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.1', 'LV', 4.76, 17, 0.36, 3.99, 5.52, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.2', 'IM', 4.03, 17, 0.27, 3.46, 4.59, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.2', 'LV', 3.95, 17, 0.46, 2.97, 4.92, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.3', 'IM', 3.91, 17, 0.28, 3.32, 4.50, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.3', 'LV', 4.50, 16, 0.33, 3.81, 5.20, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.4', 'IM', 4.22, 17, 0.23, 3.72, 4.71, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.4', 'LV', 5.45, 17, 0.27, 4.89, 6.02, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.5', 'IM', 3.97, 16, 0.26, 3.41, 4.53, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.5', 'LV', 4.90, 17, 0.21, 4.46, 5.34, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.6', 'IM', 3.68, 17, 0.31, 3.02, 4.34, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.b.6', 'LV', 4.81, 17, 0.49, 3.78, 5.84, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.c.1', 'IM', 3.83, 16, 0.32, 3.14, 4.52, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.c.1', 'LV', 4.82, 17, 0.50, 3.77, 5.87, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.c.2', 'IM', 3.70, 16, 0.30, 3.06, 4.33, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.c.2', 'LV', 4.84, 17, 0.52, 3.73, 5.94, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.c.3', 'IM', 3.75, 17, 0.19, 3.34, 4.15, 'N', NULL, '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '4.A.4.c.3', 'LV', 5.06, 17, 0.34, 4.34, 5.79, 'N', 'N', '2010-06-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.1.a.1', 'IM', 4.45, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.1.a.1', 'LV', 5.07, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.1.a.2', 'IM', 3.59, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.1.a.2', 'LV', 4.72, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.1.b.1', 'IM', 3.66, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.1.b.1', 'LV', 4.66, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.1.b.2', 'IM', 2.66, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.1.b.2', 'LV', 2.69, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.1.b.3', 'IM', 2.76, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.1.b.3', 'LV', 2.93, 28, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.a.1', 'IM', 4.17, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.a.1', 'LV', 4.93, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.a.2', 'IM', 4.10, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.a.2', 'LV', 4.93, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.a.3', 'IM', 4.48, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.a.3', 'LV', 5.07, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.a.4', 'IM', 4.34, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.a.4', 'LV', 5.18, 28, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.b.1', 'IM', 4.55, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.b.1', 'LV', 5.38, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.b.2', 'IM', 3.93, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.b.2', 'LV', 4.66, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.b.3', 'IM', 4.10, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.b.3', 'LV', 5.21, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.b.4', 'IM', 4.21, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.b.4', 'LV', 5.00, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.b.5', 'IM', 3.68, 28, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.b.5', 'LV', 4.86, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.b.6', 'IM', 4.28, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.2.b.6', 'LV', 5.83, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.3.a.1', 'IM', 1.93, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.3.a.1', 'LV', 1.86, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.3.a.2', 'IM', 2.00, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.3.a.2', 'LV', 2.34, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.3.a.3', 'IM', 1.90, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.3.a.3', 'LV', 1.69, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.3.a.4', 'IM', 1.52, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.3.a.4', 'LV', 0.79, 28, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.3.b.1', 'IM', 4.00, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.3.b.1', 'LV', 3.97, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.3.b.2', 'IM', 1.41, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.3.b.2', 'LV', 1.17, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.3.b.4', 'IM', 1.59, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.3.b.4', 'LV', 1.07, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.3.b.5', 'IM', 1.79, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.3.b.5', 'LV', 1.38, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.3.b.6', 'IM', 3.72, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.3.b.6', 'LV', 4.07, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.a.1', 'IM', 3.61, 28, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.a.1', 'LV', 4.00, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.a.2', 'IM', 4.62, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.a.2', 'LV', 5.69, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.a.3', 'IM', 4.10, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.a.3', 'LV', 5.17, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.a.4', 'IM', 4.48, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.a.4', 'LV', 5.66, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.a.5', 'IM', 3.86, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.a.5', 'LV', 4.39, 28, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.a.6', 'IM', 3.10, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.a.6', 'LV', 3.72, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.a.7', 'IM', 4.21, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.a.7', 'LV', 5.76, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.a.8', 'IM', 3.55, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.a.8', 'LV', 4.59, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.b.1', 'IM', 4.31, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.b.1', 'LV', 5.45, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.b.2', 'IM', 4.45, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.b.2', 'LV', 5.03, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.b.3', 'IM', 3.62, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.b.3', 'LV', 4.34, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.b.4', 'IM', 4.34, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.b.4', 'LV', 5.72, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.b.5', 'IM', 4.24, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.b.5', 'LV', 5.28, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.b.6', 'IM', 3.83, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.b.6', 'LV', 5.24, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.c.1', 'IM', 3.86, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.c.1', 'LV', 4.83, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.c.2', 'IM', 4.07, 29, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.c.2', 'LV', 5.17, 29, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.c.3', 'IM', 4.39, 28, NULL, NULL, NULL, NULL, NULL, '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '4.A.4.c.3', 'LV', 5.61, 28, NULL, NULL, NULL, NULL, 'N', '2008-06-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.1.a.1', 'IM', 4.41, 20, 0.15, 4.09, 4.72, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.1.a.1', 'LV', 5.62, 20, 0.26, 5.07, 6.17, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.1.a.2', 'IM', 3.90, 20, 0.24, 3.40, 4.40, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.1.a.2', 'LV', 4.73, 20, 0.33, 4.05, 5.41, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.1.b.1', 'IM', 3.97, 20, 0.26, 3.42, 4.52, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.1.b.1', 'LV', 4.82, 20, 0.28, 4.23, 5.41, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.1.b.2', 'IM', 2.93, 20, 0.27, 2.36, 3.49, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.1.b.2', 'LV', 3.50, 20, 0.39, 2.68, 4.32, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.1.b.3', 'IM', 3.72, 20, 0.27, 3.15, 4.29, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.1.b.3', 'LV', 3.83, 20, 0.25, 3.30, 4.36, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.a.1', 'IM', 3.44, 20, 0.34, 2.73, 4.15, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.a.1', 'LV', 4.42, 20, 0.51, 3.34, 5.49, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.a.2', 'IM', 4.32, 20, 0.15, 4.02, 4.63, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.a.2', 'LV', 5.70, 20, 0.22, 5.25, 6.15, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.a.3', 'IM', 3.76, 20, 0.28, 3.16, 4.35, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.a.3', 'LV', 4.75, 20, 0.44, 3.83, 5.67, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.a.4', 'IM', 4.34, 20, 0.21, 3.90, 4.78, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.a.4', 'LV', 5.14, 20, 0.28, 4.55, 5.73, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.b.1', 'IM', 4.31, 20, 0.17, 3.96, 4.66, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.b.1', 'LV', 4.90, 20, 0.30, 4.27, 5.52, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.b.2', 'IM', 3.78, 20, 0.34, 3.07, 4.48, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.b.2', 'LV', 4.95, 20, 0.43, 4.05, 5.85, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.b.3', 'IM', 4.46, 20, 0.16, 4.13, 4.78, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.b.3', 'LV', 6.00, 20, 0.24, 5.49, 6.51, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.b.4', 'IM', 3.73, 20, 0.27, 3.16, 4.31, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.b.4', 'LV', 4.44, 20, 0.51, 3.38, 5.50, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.b.5', 'IM', 3.78, 20, 0.30, 3.16, 4.40, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.b.5', 'LV', 4.75, 20, 0.42, 3.86, 5.63, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.b.6', 'IM', 4.12, 20, 0.26, 3.57, 4.66, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.2.b.6', 'LV', 5.63, 20, 0.30, 4.99, 6.26, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.3.a.1', 'IM', 2.01, 20, 0.27, 1.44, 2.58, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.3.a.1', 'LV', 2.06, 20, 0.53, 0.95, 3.17, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.3.a.2', 'IM', 1.82, 20, 0.20, 1.41, 2.23, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.3.a.2', 'LV', 2.38, 20, 0.57, 1.18, 3.57, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.3.a.3', 'IM', 1.95, 19, 0.30, 1.32, 2.57, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.3.a.3', 'LV', 2.18, 20, 0.66, 0.81, 3.55, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.3.a.4', 'IM', 2.05, 20, 0.35, 1.32, 2.77, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.3.a.4', 'LV', 1.35, 20, 0.38, 0.56, 2.15, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.3.b.1', 'IM', 4.09, 20, 0.22, 3.63, 4.55, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.3.b.1', 'LV', 3.35, 20, 0.34, 2.64, 4.05, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.3.b.2', 'IM', 2.15, 20, 0.23, 1.67, 2.64, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.3.b.2', 'LV', 2.19, 20, 0.57, 1.00, 3.37, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.3.b.4', 'IM', 1.61, 20, 0.22, 1.16, 2.07, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.3.b.4', 'LV', 1.21, 20, 0.44, 0.29, 2.13, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.3.b.5', 'IM', 2.08, 20, 0.36, 1.34, 2.83, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.3.b.5', 'LV', 1.63, 20, 0.47, 0.65, 2.60, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.3.b.6', 'IM', 4.06, 20, 0.20, 3.64, 4.48, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.3.b.6', 'LV', 4.44, 20, 0.36, 3.68, 5.19, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.a.1', 'IM', 3.79, 20, 0.33, 3.11, 4.47, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.a.1', 'LV', 4.73, 20, 0.57, 3.54, 5.92, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.a.2', 'IM', 4.32, 20, 0.21, 3.88, 4.77, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.a.2', 'LV', 5.51, 20, 0.31, 4.86, 6.16, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.a.3', 'IM', 4.41, 19, 0.18, 4.04, 4.78, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.a.3', 'LV', 5.53, 20, 0.35, 4.80, 6.26, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.a.4', 'IM', 4.14, 20, 0.21, 3.70, 4.57, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.a.4', 'LV', 5.29, 20, 0.32, 4.62, 5.96, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.a.5', 'IM', 2.55, 20, 0.44, 1.64, 3.47, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.a.5', 'LV', 2.37, 20, 0.55, 1.21, 3.52, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.a.6', 'IM', 2.50, 20, 0.46, 1.54, 3.46, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.a.6', 'LV', 2.78, 20, 0.77, 1.17, 4.40, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.a.7', 'IM', 2.98, 20, 0.24, 2.46, 3.49, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.a.7', 'LV', 4.17, 20, 0.41, 3.30, 5.03, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.a.8', 'IM', 2.80, 20, 0.47, 1.81, 3.78, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.a.8', 'LV', 3.14, 20, 0.56, 1.97, 4.31, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.b.1', 'IM', 3.61, 20, 0.31, 2.97, 4.25, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.b.1', 'LV', 4.10, 20, 0.26, 3.55, 4.65, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.b.2', 'IM', 3.69, 20, 0.31, 3.04, 4.33, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.b.2', 'LV', 3.22, 20, 0.26, 2.67, 3.77, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.b.3', 'IM', 3.39, 20, 0.31, 2.74, 4.03, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.b.3', 'LV', 4.22, 20, 0.53, 3.10, 5.34, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.b.4', 'IM', 3.28, 20, 0.26, 2.72, 3.83, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.b.4', 'LV', 3.81, 20, 0.39, 2.99, 4.63, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.b.5', 'IM', 3.26, 20, 0.35, 2.54, 3.99, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.b.5', 'LV', 4.48, 20, 0.37, 3.69, 5.26, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.b.6', 'IM', 3.53, 20, 0.37, 2.77, 4.30, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.b.6', 'LV', 4.63, 20, 0.51, 3.55, 5.70, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.c.1', 'IM', 3.02, 20, 0.37, 2.25, 3.79, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.c.1', 'LV', 3.37, 20, 0.40, 2.54, 4.20, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.c.2', 'IM', 2.52, 20, 0.21, 2.07, 2.96, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.c.2', 'LV', 3.48, 20, 0.35, 2.74, 4.21, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.c.3', 'IM', 3.13, 20, 0.27, 2.56, 3.70, 'N', NULL, '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '4.A.4.c.3', 'LV', 4.10, 20, 0.45, 3.15, 5.05, 'N', 'N', '2014-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.1.a.1', 'IM', 4.66, 19, 0.12, 4.41, 4.92, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.1.a.1', 'LV', 4.94, 18, 0.14, 4.63, 5.24, 'N', 'N', '2011-07-01', 'Incumbent');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.1.a.2', 'IM', 3.96, 19, 0.46, 3.01, 4.92, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.1.a.2', 'LV', 4.92, 19, 0.56, 3.75, 6.09, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.1.b.1', 'IM', 4.15, 19, 0.28, 3.57, 4.73, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.1.b.1', 'LV', 5.37, 19, 0.27, 4.81, 5.93, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.1.b.2', 'IM', 2.36, 19, 0.33, 1.66, 3.06, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.1.b.2', 'LV', 2.35, 19, 0.56, 1.18, 3.53, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.1.b.3', 'IM', 3.20, 19, 0.55, 2.05, 4.35, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.1.b.3', 'LV', 3.03, 19, 0.77, 1.41, 4.65, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.a.1', 'IM', 3.32, 18, 0.67, 1.91, 4.72, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.a.1', 'LV', 3.31, 18, 0.93, 1.35, 5.27, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.a.2', 'IM', 4.28, 19, 0.28, 3.70, 4.86, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.a.2', 'LV', 5.79, 19, 0.22, 5.33, 6.25, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.a.3', 'IM', 4.17, 19, 0.26, 3.63, 4.72, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.a.3', 'LV', 4.55, 19, 0.32, 3.87, 5.23, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.a.4', 'IM', 3.63, 19, 0.38, 2.84, 4.42, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.a.4', 'LV', 4.03, 19, 0.64, 2.68, 5.38, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.b.1', 'IM', 4.63, 19, 0.14, 4.35, 4.92, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.b.1', 'LV', 5.74, 18, 0.18, 5.37, 6.11, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.b.2', 'IM', 3.66, 19, 0.32, 2.98, 4.34, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.b.2', 'LV', 4.88, 18, 0.84, 3.11, 6.66, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.b.3', 'IM', 4.30, 19, 0.18, 3.93, 4.67, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.b.3', 'LV', 5.67, 19, 0.31, 5.02, 6.32, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.b.4', 'IM', 3.30, 19, 0.36, 2.53, 4.06, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.b.4', 'LV', 3.22, 19, 0.46, 2.25, 4.19, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.b.5', 'IM', 4.26, 19, 0.20, 3.85, 4.68, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.b.5', 'LV', 5.67, 18, 0.42, 4.79, 6.56, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.b.6', 'IM', 4.46, 19, 0.13, 4.18, 4.74, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.2.b.6', 'LV', 6.29, 19, 0.24, 5.80, 6.79, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.3.a.1', 'IM', 2.03, 19, 0.40, 1.19, 2.87, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.3.a.1', 'LV', 1.78, 19, 0.63, 0.47, 3.10, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.3.a.2', 'IM', 1.70, 19, 0.26, 1.15, 2.24, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.3.a.2', 'LV', 1.98, 19, 0.61, 0.70, 3.26, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.3.a.3', 'IM', 2.05, 19, 0.48, 1.04, 3.05, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.3.a.3', 'LV', 1.63, 19, 0.65, 0.26, 2.99, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.3.a.4', 'IM', 1.51, 19, 0.33, 1.00, 2.19, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.3.a.4', 'LV', 0.69, 19, 0.47, 0.00, 1.67, 'Y', 'Y', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.3.b.1', 'IM', 4.22, 19, 0.31, 3.56, 4.87, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.3.b.1', 'LV', 3.70, 19, 0.42, 2.82, 4.58, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.3.b.2', 'IM', 1.41, 19, 0.22, 1.00, 1.87, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.3.b.2', 'LV', 0.94, 19, 0.59, 0.00, 2.18, 'Y', 'Y', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.3.b.4', 'IM', 1.18, 19, 0.15, 1.00, 1.49, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.3.b.4', 'LV', 0.41, 19, 0.33, 0.00, 1.11, 'Y', 'Y', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.3.b.5', 'IM', 1.25, 19, 0.16, 1.00, 1.58, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.3.b.5', 'LV', 0.43, 19, 0.27, 0.00, 1.00, 'Y', 'Y', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.3.b.6', 'IM', 4.28, 19, 0.52, 3.20, 5.00, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.3.b.6', 'LV', 4.62, 19, 0.73, 3.09, 6.14, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.a.1', 'IM', 3.90, 19, 0.19, 3.50, 4.30, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.a.1', 'LV', 4.32, 19, 0.42, 3.44, 5.21, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.a.2', 'IM', 4.29, 19, 0.18, 3.91, 4.67, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.a.2', 'LV', 5.20, 19, 0.41, 4.35, 6.06, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.a.3', 'IM', 4.15, 19, 0.40, 3.30, 5.00, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.a.3', 'LV', 4.75, 19, 0.75, 3.17, 6.33, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.a.4', 'IM', 4.65, 19, 0.14, 4.37, 4.94, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.a.4', 'LV', 5.60, 19, 0.24, 5.09, 6.11, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.a.5', 'IM', 3.83, 19, 0.33, 3.15, 4.52, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.a.5', 'LV', 4.29, 19, 0.56, 3.12, 5.45, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.a.6', 'IM', 2.16, 19, 0.35, 1.43, 2.90, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.a.6', 'LV', 2.18, 19, 0.57, 0.98, 3.37, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.a.7', 'IM', 3.82, 19, 0.19, 3.41, 4.23, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.a.7', 'LV', 5.10, 19, 0.25, 4.57, 5.63, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.a.8', 'IM', 2.81, 19, 0.63, 1.49, 4.14, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.a.8', 'LV', 3.01, 19, 0.98, 0.96, 5.06, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.b.1', 'IM', 3.96, 18, 0.18, 3.59, 4.34, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.b.1', 'LV', 5.46, 18, 0.45, 4.51, 6.42, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.b.2', 'IM', 3.89, 18, 0.35, 3.15, 4.64, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.b.2', 'LV', 4.70, 18, 0.61, 3.41, 5.99, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.b.3', 'IM', 4.10, 17, 0.10, 3.90, 4.31, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.b.3', 'LV', 4.76, 17, 0.40, 3.92, 5.60, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.b.4', 'IM', 3.83, 18, 0.22, 3.36, 4.30, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.b.4', 'LV', 4.71, 18, 0.20, 4.28, 5.13, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.b.5', 'IM', 2.93, 19, 0.45, 2.00, 3.87, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.b.5', 'LV', 3.60, 19, 0.61, 2.32, 4.87, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.b.6', 'IM', 3.11, 19, 0.38, 2.31, 3.91, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.b.6', 'LV', 3.72, 19, 0.63, 2.40, 5.03, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.c.1', 'IM', 3.35, 19, 0.32, 2.69, 4.01, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.c.1', 'LV', 3.75, 19, 0.44, 2.82, 4.67, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.c.2', 'IM', 2.82, 19, 0.28, 2.23, 3.41, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.c.2', 'LV', 3.48, 19, 0.65, 2.12, 4.85, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.c.3', 'IM', 3.98, 19, 0.05, 3.88, 4.08, 'N', NULL, '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '4.A.4.c.3', 'LV', 4.83, 19, 0.13, 4.56, 5.09, 'N', 'N', '2011-07-01', 'Incumbent');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.1.a.1', 'IM', 4.62, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.1.a.1', 'LV', 5.29, 28, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.1.a.2', 'IM', 3.76, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.1.a.2', 'LV', 4.83, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.1.b.1', 'IM', 3.72, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.1.b.1', 'LV', 4.66, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.1.b.2', 'IM', 2.86, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.1.b.2', 'LV', 3.66, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.1.b.3', 'IM', 3.76, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.1.b.3', 'LV', 4.66, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.2.a.1', 'IM', 3.38, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.2.a.1', 'LV', 4.28, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.2.a.2', 'IM', 4.28, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.2.a.2', 'LV', 5.76, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.2.a.3', 'IM', 4.21, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.2.a.3', 'LV', 5.10, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.2.a.4', 'IM', 4.62, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.2.a.4', 'LV', 5.83, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.2.b.1', 'IM', 4.38, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.2.b.1', 'LV', 5.69, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
GO
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.2.b.2', 'IM', 3.79, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.2.b.2', 'LV', 5.10, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.2.b.3', 'IM', 4.24, 29, NULL, NULL, NULL, NULL, NULL, '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '4.A.2.b.3', 'LV', 5.55, 29, NULL, NULL, NULL, NULL, 'N', '2012-07-01', 'Occupational Expert');
INSERT INTO work_activities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci